///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import "DBPAPERUserAuthRoutes.h"
#import "DBPAPERAddMember.h"
#import "DBPAPERAddPaperDocUser.h"
#import "DBPAPERAddPaperDocUserMemberResult.h"
#import "DBPAPERAddPaperDocUserResult.h"
#import "DBPAPERCursor.h"
#import "DBPAPERDocLookupError.h"
#import "DBPAPERExportFormat.h"
#import "DBPAPERFolder.h"
#import "DBPAPERFolderSharingPolicyType.h"
#import "DBPAPERFoldersContainingPaperDoc.h"
#import "DBPAPERImportFormat.h"
#import "DBPAPERInviteeInfoWithPermissionLevel.h"
#import "DBPAPERListDocsCursorError.h"
#import "DBPAPERListPaperDocsArgs.h"
#import "DBPAPERListPaperDocsContinueArgs.h"
#import "DBPAPERListPaperDocsFilterBy.h"
#import "DBPAPERListPaperDocsResponse.h"
#import "DBPAPERListPaperDocsSortBy.h"
#import "DBPAPERListPaperDocsSortOrder.h"
#import "DBPAPERListUsersCursorError.h"
#import "DBPAPERListUsersOnFolderArgs.h"
#import "DBPAPERListUsersOnFolderContinueArgs.h"
#import "DBPAPERListUsersOnFolderResponse.h"
#import "DBPAPERListUsersOnPaperDocArgs.h"
#import "DBPAPERListUsersOnPaperDocContinueArgs.h"
#import "DBPAPERListUsersOnPaperDocResponse.h"
#import "DBPAPERPaperApiBaseError.h"
#import "DBPAPERPaperApiCursorError.h"
#import "DBPAPERPaperDocCreateArgs.h"
#import "DBPAPERPaperDocCreateError.h"
#import "DBPAPERPaperDocCreateUpdateResult.h"
#import "DBPAPERPaperDocExport.h"
#import "DBPAPERPaperDocExportResult.h"
#import "DBPAPERPaperDocSharingPolicy.h"
#import "DBPAPERPaperDocUpdateArgs.h"
#import "DBPAPERPaperDocUpdateError.h"
#import "DBPAPERPaperDocUpdatePolicy.h"
#import "DBPAPERPaperFolderCreateArg.h"
#import "DBPAPERPaperFolderCreateError.h"
#import "DBPAPERPaperFolderCreateResult.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBPAPERRemovePaperDocUser.h"
#import "DBPAPERRouteObjects.h"
#import "DBPAPERSharingPolicy.h"
#import "DBPAPERSharingPublicPolicyType.h"
#import "DBPAPERSharingTeamPolicyType.h"
#import "DBPAPERUserInfoWithPermissionLevel.h"
#import "DBPAPERUserOnPaperDocFilter.h"
#import "DBRequestErrors.h"
#import "DBSHARINGInviteeInfo.h"
#import "DBSHARINGMemberSelector.h"
#import "DBSHARINGUserInfo.h"
#import "DBStoneBase.h"
#import "DBTransportClientProtocol.h"

@implementation DBPAPERUserAuthRoutes

- (instancetype)init:(id<DBTransportClient>)client {
  self = [super init];
  if (self) {
    _client = client;
  }
  return self;
}

- (DBRpcTask *)docsArchive:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsArchive;
  DBPAPERRefPaperDoc *arg = [[DBPAPERRefPaperDoc alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBUploadTask *)docsCreateUrl:(DBPAPERImportFormat *)importFormat inputUrl:(NSString *)inputUrl {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg = [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputUrl:inputUrl];
}

- (DBUploadTask *)docsCreateUrl:(DBPAPERImportFormat *)importFormat
                 parentFolderId:(NSString *)parentFolderId
                       inputUrl:(NSString *)inputUrl {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg =
      [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat parentFolderId:parentFolderId];
  return [self.client requestUpload:route arg:arg inputUrl:inputUrl];
}

- (DBUploadTask *)docsCreateData:(DBPAPERImportFormat *)importFormat inputData:(NSData *)inputData {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg = [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputData:inputData];
}

- (DBUploadTask *)docsCreateData:(DBPAPERImportFormat *)importFormat
                  parentFolderId:(NSString *)parentFolderId
                       inputData:(NSData *)inputData {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg =
      [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat parentFolderId:parentFolderId];
  return [self.client requestUpload:route arg:arg inputData:inputData];
}

- (DBUploadTask *)docsCreateStream:(DBPAPERImportFormat *)importFormat inputStream:(NSInputStream *)inputStream {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg = [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputStream:inputStream];
}

- (DBUploadTask *)docsCreateStream:(DBPAPERImportFormat *)importFormat
                    parentFolderId:(NSString *)parentFolderId
                       inputStream:(NSInputStream *)inputStream {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsCreate;
  DBPAPERPaperDocCreateArgs *arg =
      [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat parentFolderId:parentFolderId];
  return [self.client requestUpload:route arg:arg inputStream:inputStream];
}

- (DBDownloadUrlTask *)docsDownloadUrl:(NSString *)docId
                          exportFormat:(DBPAPERExportFormat *)exportFormat
                             overwrite:(BOOL)overwrite
                           destination:(NSURL *)destination {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsDownload;
  DBPAPERPaperDocExport *arg = [[DBPAPERPaperDocExport alloc] initWithDocId:docId exportFormat:exportFormat];
  return [self.client requestDownload:route arg:arg overwrite:overwrite destination:destination];
}

- (DBDownloadUrlTask *)docsDownloadUrl:(NSString *)docId
                          exportFormat:(DBPAPERExportFormat *)exportFormat
                             overwrite:(BOOL)overwrite
                           destination:(NSURL *)destination
                       byteOffsetStart:(NSNumber *)byteOffsetStart
                         byteOffsetEnd:(NSNumber *)byteOffsetEnd {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsDownload;
  DBPAPERPaperDocExport *arg = [[DBPAPERPaperDocExport alloc] initWithDocId:docId exportFormat:exportFormat];
  return [self.client requestDownload:route
                                  arg:arg
                            overwrite:overwrite
                          destination:destination
                      byteOffsetStart:byteOffsetStart
                        byteOffsetEnd:byteOffsetEnd];
}

- (DBDownloadDataTask *)docsDownloadData:(NSString *)docId exportFormat:(DBPAPERExportFormat *)exportFormat {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsDownload;
  DBPAPERPaperDocExport *arg = [[DBPAPERPaperDocExport alloc] initWithDocId:docId exportFormat:exportFormat];
  return [self.client requestDownload:route arg:arg];
}

- (DBDownloadDataTask *)docsDownloadData:(NSString *)docId
                            exportFormat:(DBPAPERExportFormat *)exportFormat
                         byteOffsetStart:(NSNumber *)byteOffsetStart
                           byteOffsetEnd:(NSNumber *)byteOffsetEnd {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsDownload;
  DBPAPERPaperDocExport *arg = [[DBPAPERPaperDocExport alloc] initWithDocId:docId exportFormat:exportFormat];
  return [self.client requestDownload:route arg:arg byteOffsetStart:byteOffsetStart byteOffsetEnd:byteOffsetEnd];
}

- (DBRpcTask *)docsFolderUsersList:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsFolderUsersList;
  DBPAPERListUsersOnFolderArgs *arg = [[DBPAPERListUsersOnFolderArgs alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsFolderUsersList:(NSString *)docId limit:(NSNumber *)limit {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsFolderUsersList;
  DBPAPERListUsersOnFolderArgs *arg = [[DBPAPERListUsersOnFolderArgs alloc] initWithDocId:docId limit:limit];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsFolderUsersListContinue:(NSString *)docId cursor:(NSString *)cursor {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsFolderUsersListContinue;
  DBPAPERListUsersOnFolderContinueArgs *arg =
      [[DBPAPERListUsersOnFolderContinueArgs alloc] initWithDocId:docId cursor:cursor];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsGetFolderInfo:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsGetFolderInfo;
  DBPAPERRefPaperDoc *arg = [[DBPAPERRefPaperDoc alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsList {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsList;
  DBPAPERListPaperDocsArgs *arg = [[DBPAPERListPaperDocsArgs alloc] initDefault];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsList:(DBPAPERListPaperDocsFilterBy *)filterBy
                 sortBy:(DBPAPERListPaperDocsSortBy *)sortBy
              sortOrder:(DBPAPERListPaperDocsSortOrder *)sortOrder
                  limit:(NSNumber *)limit {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsList;
  DBPAPERListPaperDocsArgs *arg =
      [[DBPAPERListPaperDocsArgs alloc] initWithFilterBy:filterBy sortBy:sortBy sortOrder:sortOrder limit:limit];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsListContinue:(NSString *)cursor {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsListContinue;
  DBPAPERListPaperDocsContinueArgs *arg = [[DBPAPERListPaperDocsContinueArgs alloc] initWithCursor:cursor];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsPermanentlyDelete:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsPermanentlyDelete;
  DBPAPERRefPaperDoc *arg = [[DBPAPERRefPaperDoc alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsSharingPolicyGet:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsSharingPolicyGet;
  DBPAPERRefPaperDoc *arg = [[DBPAPERRefPaperDoc alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsSharingPolicySet:(NSString *)docId sharingPolicy:(DBPAPERSharingPolicy *)sharingPolicy {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsSharingPolicySet;
  DBPAPERPaperDocSharingPolicy *arg =
      [[DBPAPERPaperDocSharingPolicy alloc] initWithDocId:docId sharingPolicy:sharingPolicy];
  return [self.client requestRpc:route arg:arg];
}

- (DBUploadTask *)docsUpdateUrl:(NSString *)docId
                docUpdatePolicy:(DBPAPERPaperDocUpdatePolicy *)docUpdatePolicy
                       revision:(NSNumber *)revision
                   importFormat:(DBPAPERImportFormat *)importFormat
                       inputUrl:(NSString *)inputUrl {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUpdate;
  DBPAPERPaperDocUpdateArgs *arg = [[DBPAPERPaperDocUpdateArgs alloc] initWithDocId:docId
                                                                    docUpdatePolicy:docUpdatePolicy
                                                                           revision:revision
                                                                       importFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputUrl:inputUrl];
}

- (DBUploadTask *)docsUpdateData:(NSString *)docId
                 docUpdatePolicy:(DBPAPERPaperDocUpdatePolicy *)docUpdatePolicy
                        revision:(NSNumber *)revision
                    importFormat:(DBPAPERImportFormat *)importFormat
                       inputData:(NSData *)inputData {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUpdate;
  DBPAPERPaperDocUpdateArgs *arg = [[DBPAPERPaperDocUpdateArgs alloc] initWithDocId:docId
                                                                    docUpdatePolicy:docUpdatePolicy
                                                                           revision:revision
                                                                       importFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputData:inputData];
}

- (DBUploadTask *)docsUpdateStream:(NSString *)docId
                   docUpdatePolicy:(DBPAPERPaperDocUpdatePolicy *)docUpdatePolicy
                          revision:(NSNumber *)revision
                      importFormat:(DBPAPERImportFormat *)importFormat
                       inputStream:(NSInputStream *)inputStream {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUpdate;
  DBPAPERPaperDocUpdateArgs *arg = [[DBPAPERPaperDocUpdateArgs alloc] initWithDocId:docId
                                                                    docUpdatePolicy:docUpdatePolicy
                                                                           revision:revision
                                                                       importFormat:importFormat];
  return [self.client requestUpload:route arg:arg inputStream:inputStream];
}

- (DBRpcTask *)docsUsersAdd:(NSString *)docId members:(NSArray<DBPAPERAddMember *> *)members {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersAdd;
  DBPAPERAddPaperDocUser *arg = [[DBPAPERAddPaperDocUser alloc] initWithDocId:docId members:members];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsUsersAdd:(NSString *)docId
                    members:(NSArray<DBPAPERAddMember *> *)members
              customMessage:(NSString *)customMessage
                      quiet:(NSNumber *)quiet {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersAdd;
  DBPAPERAddPaperDocUser *arg =
      [[DBPAPERAddPaperDocUser alloc] initWithDocId:docId members:members customMessage:customMessage quiet:quiet];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsUsersList:(NSString *)docId {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersList;
  DBPAPERListUsersOnPaperDocArgs *arg = [[DBPAPERListUsersOnPaperDocArgs alloc] initWithDocId:docId];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsUsersList:(NSString *)docId
                       limit:(NSNumber *)limit
                    filterBy:(DBPAPERUserOnPaperDocFilter *)filterBy {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersList;
  DBPAPERListUsersOnPaperDocArgs *arg =
      [[DBPAPERListUsersOnPaperDocArgs alloc] initWithDocId:docId limit:limit filterBy:filterBy];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsUsersListContinue:(NSString *)docId cursor:(NSString *)cursor {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersListContinue;
  DBPAPERListUsersOnPaperDocContinueArgs *arg =
      [[DBPAPERListUsersOnPaperDocContinueArgs alloc] initWithDocId:docId cursor:cursor];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)docsUsersRemove:(NSString *)docId member:(DBSHARINGMemberSelector *)member {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERDocsUsersRemove;
  DBPAPERRemovePaperDocUser *arg = [[DBPAPERRemovePaperDocUser alloc] initWithDocId:docId member:member];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)foldersCreate:(NSString *)name {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERFoldersCreate;
  DBPAPERPaperFolderCreateArg *arg = [[DBPAPERPaperFolderCreateArg alloc] initWithName:name];
  return [self.client requestRpc:route arg:arg];
}

- (DBRpcTask *)foldersCreate:(NSString *)name
              parentFolderId:(NSString *)parentFolderId
                isTeamFolder:(NSNumber *)isTeamFolder {
  DBRoute *route = DBPAPERRouteObjects.DBPAPERFoldersCreate;
  DBPAPERPaperFolderCreateArg *arg =
      [[DBPAPERPaperFolderCreateArg alloc] initWithName:name parentFolderId:parentFolderId isTeamFolder:isTeamFolder];
  return [self.client requestRpc:route arg:arg];
}

@end
