///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBTasks.h"

@class DBCONTACTSDeleteManualContactsError;
@class DBNilObject;

@protocol DBTransportClient;

///
/// Routes for the `Contacts` namespace
///

NS_ASSUME_NONNULL_BEGIN

@interface DBCONTACTSUserAuthRoutes : NSObject

/// An instance of the networking client that each route will use to submit a
/// request.
@property (nonatomic, readonly) id<DBTransportClient> client;

/// Initializes the `DBCONTACTSUserAuthRoutes` namespace container object with a
/// networking client.
- (instancetype)init:(id<DBTransportClient>)client;

///
/// Removes all manually added contacts. You'll still keep contacts who are on your team or who you imported. New
/// contacts will be added when you share.
///
///
/// @return Through the response callback, the caller will receive a `void` object on success or a `void` object on
/// failure.
///
- (DBRpcTask<DBNilObject *, DBNilObject *> *)deleteManualContacts;

///
/// Removes manually added contacts from the given list.
///
/// @param emailAddresses List of manually added contacts to be deleted.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBCONTACTSDeleteManualContactsError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBCONTACTSDeleteManualContactsError *> *)deleteManualContactsBatch:
    (NSArray<NSString *> *)emailAddresses;

@end

NS_ASSUME_NONNULL_END
