///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSSpaceAllocation;
@class DBUSERSSpaceUsage;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SpaceUsage` struct.
///
/// Information about a user's space usage and quota.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSSpaceUsage : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The user's total space usage (bytes).
@property (nonatomic, readonly) NSNumber *used;

/// The user's space allocation.
@property (nonatomic, readonly) DBUSERSSpaceAllocation *allocation;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param used The user's total space usage (bytes).
/// @param allocation The user's space allocation.
///
/// @return An initialized instance.
///
- (instancetype)initWithUsed:(NSNumber *)used allocation:(DBUSERSSpaceAllocation *)allocation;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SpaceUsage` struct.
///
@interface DBUSERSSpaceUsageSerializer : NSObject

///
/// Serializes `DBUSERSSpaceUsage` instances.
///
/// @param instance An instance of the `DBUSERSSpaceUsage` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSSpaceUsage` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSSpaceUsage *)instance;

///
/// Deserializes `DBUSERSSpaceUsage` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSSpaceUsage` API object.
///
/// @return An instantiation of the `DBUSERSSpaceUsage` object.
///
+ (DBUSERSSpaceUsage *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
