///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBUSERSFileLockingValue;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileLockingValue` union.
///
/// The value for `fileLocking` in `DBUSERSUserFeature`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBUSERSFileLockingValue : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBUSERSFileLockingValueTag` enum type represents the possible tag
/// states with which the `DBUSERSFileLockingValue` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBUSERSFileLockingValueTag){
    /// When this value is True, the user can lock files in shared directories.
    /// When the value is False the user can unlock the files they have locked
    /// or request to unlock files locked by others.
    DBUSERSFileLockingValueEnabled,

    /// (no description).
    DBUSERSFileLockingValueOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBUSERSFileLockingValueTag tag;

/// When this value is True, the user can lock files in shared directories. When
/// the value is False the user can unlock the files they have locked or request
/// to unlock files locked by others. @note Ensure the `isEnabled` method
/// returns true before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) NSNumber *enabled;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "enabled".
///
/// Description of the "enabled" tag state: When this value is True, the user
/// can lock files in shared directories. When the value is False the user can
/// unlock the files they have locked or request to unlock files locked by
/// others.
///
/// @param enabled When this value is True, the user can lock files in shared
/// directories. When the value is False the user can unlock the files they have
/// locked or request to unlock files locked by others.
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled:(NSNumber *)enabled;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @note Call this method and ensure it returns true before accessing the
/// `enabled` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBUSERSFileLockingValue` union.
///
@interface DBUSERSFileLockingValueSerializer : NSObject

///
/// Serializes `DBUSERSFileLockingValue` instances.
///
/// @param instance An instance of the `DBUSERSFileLockingValue` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBUSERSFileLockingValue` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBUSERSFileLockingValue *)instance;

///
/// Deserializes `DBUSERSFileLockingValue` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBUSERSFileLockingValue` API object.
///
/// @return An instantiation of the `DBUSERSFileLockingValue` object.
///
+ (DBUSERSFileLockingValue *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
