///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Users` namespace.

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSAccount.h"
#import "DBUSERSName.h"

#pragma mark - API Object

@implementation DBUSERSAccount

#pragma mark - Constructors

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled
                  profilePhotoUrl:(NSString *)profilePhotoUrl {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](email);
  [DBStoneValidators nonnullValidator:nil](emailVerified);
  [DBStoneValidators nonnullValidator:nil](disabled);

  self = [super init];
  if (self) {
    _accountId = accountId;
    _name = name;
    _email = email;
    _emailVerified = emailVerified;
    _profilePhotoUrl = profilePhotoUrl;
    _disabled = disabled;
  }
  return self;
}

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled {
  return [self initWithAccountId:accountId
                            name:name
                           email:email
                   emailVerified:emailVerified
                        disabled:disabled
                 profilePhotoUrl:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSAccountSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSAccountSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSAccountSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountId hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.email hash];
  result = prime * result + [self.emailVerified hash];
  result = prime * result + [self.disabled hash];
  if (self.profilePhotoUrl != nil) {
    result = prime * result + [self.profilePhotoUrl hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccount:other];
}

- (BOOL)isEqualToAccount:(DBUSERSAccount *)anAccount {
  if (self == anAccount) {
    return YES;
  }
  if (![self.accountId isEqual:anAccount.accountId]) {
    return NO;
  }
  if (![self.name isEqual:anAccount.name]) {
    return NO;
  }
  if (![self.email isEqual:anAccount.email]) {
    return NO;
  }
  if (![self.emailVerified isEqual:anAccount.emailVerified]) {
    return NO;
  }
  if (![self.disabled isEqual:anAccount.disabled]) {
    return NO;
  }
  if (self.profilePhotoUrl) {
    if (![self.profilePhotoUrl isEqual:anAccount.profilePhotoUrl]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSAccountSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSAccount *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_id"] = valueObj.accountId;
  jsonDict[@"name"] = [DBUSERSNameSerializer serialize:valueObj.name];
  jsonDict[@"email"] = valueObj.email;
  jsonDict[@"email_verified"] = valueObj.emailVerified;
  jsonDict[@"disabled"] = valueObj.disabled;
  if (valueObj.profilePhotoUrl) {
    jsonDict[@"profile_photo_url"] = valueObj.profilePhotoUrl;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSAccount *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *accountId = valueDict[@"account_id"];
  DBUSERSName *name = [DBUSERSNameSerializer deserialize:valueDict[@"name"]];
  NSString *email = valueDict[@"email"];
  NSNumber *emailVerified = valueDict[@"email_verified"];
  NSNumber *disabled = valueDict[@"disabled"];
  NSString *profilePhotoUrl = valueDict[@"profile_photo_url"] ?: nil;

  return [[DBUSERSAccount alloc] initWithAccountId:accountId
                                              name:name
                                             email:email
                                     emailVerified:emailVerified
                                          disabled:disabled
                                   profilePhotoUrl:profilePhotoUrl];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSAccount.h"
#import "DBUSERSBasicAccount.h"
#import "DBUSERSName.h"

#pragma mark - API Object

@implementation DBUSERSBasicAccount

#pragma mark - Constructors

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled
                       isTeammate:(NSNumber *)isTeammate
                  profilePhotoUrl:(NSString *)profilePhotoUrl
                     teamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](email);
  [DBStoneValidators nonnullValidator:nil](emailVerified);
  [DBStoneValidators nonnullValidator:nil](disabled);
  [DBStoneValidators nonnullValidator:nil](isTeammate);

  self = [super initWithAccountId:accountId
                             name:name
                            email:email
                    emailVerified:emailVerified
                         disabled:disabled
                  profilePhotoUrl:profilePhotoUrl];
  if (self) {
    _isTeammate = isTeammate;
    _teamMemberId = teamMemberId;
  }
  return self;
}

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled
                       isTeammate:(NSNumber *)isTeammate {
  return [self initWithAccountId:accountId
                            name:name
                           email:email
                   emailVerified:emailVerified
                        disabled:disabled
                      isTeammate:isTeammate
                 profilePhotoUrl:nil
                    teamMemberId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSBasicAccountSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSBasicAccountSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSBasicAccountSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountId hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.email hash];
  result = prime * result + [self.emailVerified hash];
  result = prime * result + [self.disabled hash];
  result = prime * result + [self.isTeammate hash];
  if (self.profilePhotoUrl != nil) {
    result = prime * result + [self.profilePhotoUrl hash];
  }
  if (self.teamMemberId != nil) {
    result = prime * result + [self.teamMemberId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBasicAccount:other];
}

- (BOOL)isEqualToBasicAccount:(DBUSERSBasicAccount *)aBasicAccount {
  if (self == aBasicAccount) {
    return YES;
  }
  if (![self.accountId isEqual:aBasicAccount.accountId]) {
    return NO;
  }
  if (![self.name isEqual:aBasicAccount.name]) {
    return NO;
  }
  if (![self.email isEqual:aBasicAccount.email]) {
    return NO;
  }
  if (![self.emailVerified isEqual:aBasicAccount.emailVerified]) {
    return NO;
  }
  if (![self.disabled isEqual:aBasicAccount.disabled]) {
    return NO;
  }
  if (![self.isTeammate isEqual:aBasicAccount.isTeammate]) {
    return NO;
  }
  if (self.profilePhotoUrl) {
    if (![self.profilePhotoUrl isEqual:aBasicAccount.profilePhotoUrl]) {
      return NO;
    }
  }
  if (self.teamMemberId) {
    if (![self.teamMemberId isEqual:aBasicAccount.teamMemberId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSBasicAccountSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSBasicAccount *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_id"] = valueObj.accountId;
  jsonDict[@"name"] = [DBUSERSNameSerializer serialize:valueObj.name];
  jsonDict[@"email"] = valueObj.email;
  jsonDict[@"email_verified"] = valueObj.emailVerified;
  jsonDict[@"disabled"] = valueObj.disabled;
  jsonDict[@"is_teammate"] = valueObj.isTeammate;
  if (valueObj.profilePhotoUrl) {
    jsonDict[@"profile_photo_url"] = valueObj.profilePhotoUrl;
  }
  if (valueObj.teamMemberId) {
    jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSBasicAccount *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *accountId = valueDict[@"account_id"];
  DBUSERSName *name = [DBUSERSNameSerializer deserialize:valueDict[@"name"]];
  NSString *email = valueDict[@"email"];
  NSNumber *emailVerified = valueDict[@"email_verified"];
  NSNumber *disabled = valueDict[@"disabled"];
  NSNumber *isTeammate = valueDict[@"is_teammate"];
  NSString *profilePhotoUrl = valueDict[@"profile_photo_url"] ?: nil;
  NSString *teamMemberId = valueDict[@"team_member_id"] ?: nil;

  return [[DBUSERSBasicAccount alloc] initWithAccountId:accountId
                                                   name:name
                                                  email:email
                                          emailVerified:emailVerified
                                               disabled:disabled
                                             isTeammate:isTeammate
                                        profilePhotoUrl:profilePhotoUrl
                                           teamMemberId:teamMemberId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSFileLockingValue.h"

#pragma mark - API Object

@implementation DBUSERSFileLockingValue

@synthesize enabled = _enabled;

#pragma mark - Constructors

- (instancetype)initWithEnabled:(NSNumber *)enabled {
  self = [super init];
  if (self) {
    _tag = DBUSERSFileLockingValueEnabled;
    _enabled = enabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSFileLockingValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSNumber *)enabled {
  if (![self isEnabled]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSFileLockingValueEnabled, but was %@.", [self tagName]];
  }
  return _enabled;
}

#pragma mark - Tag state methods

- (BOOL)isEnabled {
  return _tag == DBUSERSFileLockingValueEnabled;
}

- (BOOL)isOther {
  return _tag == DBUSERSFileLockingValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSFileLockingValueEnabled:
    return @"DBUSERSFileLockingValueEnabled";
  case DBUSERSFileLockingValueOther:
    return @"DBUSERSFileLockingValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSFileLockingValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSFileLockingValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSFileLockingValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSFileLockingValueEnabled:
    result = prime * result + [self.enabled hash];
    break;
  case DBUSERSFileLockingValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLockingValue:other];
}

- (BOOL)isEqualToFileLockingValue:(DBUSERSFileLockingValue *)aFileLockingValue {
  if (self == aFileLockingValue) {
    return YES;
  }
  if (self.tag != aFileLockingValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSFileLockingValueEnabled:
    return [self.enabled isEqual:aFileLockingValue.enabled];
  case DBUSERSFileLockingValueOther:
    return [[self tagName] isEqual:[aFileLockingValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSFileLockingValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSFileLockingValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEnabled]) {
    jsonDict[@"enabled"] = valueObj.enabled;
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSFileLockingValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"enabled"]) {
    NSNumber *enabled = valueDict[@"enabled"];
    return [[DBUSERSFileLockingValue alloc] initWithEnabled:enabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSFileLockingValue alloc] initWithOther];
  } else {
    return [[DBUSERSFileLockingValue alloc] initWithOther];
  }
}

@end

#import "DBCOMMONRootInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSAccount.h"
#import "DBUSERSCOMMONAccountType.h"
#import "DBUSERSFullAccount.h"
#import "DBUSERSFullTeam.h"
#import "DBUSERSName.h"

#pragma mark - API Object

@implementation DBUSERSFullAccount

#pragma mark - Constructors

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled
                           locale:(NSString *)locale
                     referralLink:(NSString *)referralLink
                         isPaired:(NSNumber *)isPaired
                      accountType:(DBUSERSCOMMONAccountType *)accountType
                         rootInfo:(DBCOMMONRootInfo *)rootInfo
                  profilePhotoUrl:(NSString *)profilePhotoUrl
                          country:(NSString *)country
                             team:(DBUSERSFullTeam *)team
                     teamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](email);
  [DBStoneValidators nonnullValidator:nil](emailVerified);
  [DBStoneValidators nonnullValidator:nil](disabled);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(2) maxLength:nil pattern:nil]](locale);
  [DBStoneValidators nonnullValidator:nil](referralLink);
  [DBStoneValidators nonnullValidator:nil](isPaired);
  [DBStoneValidators nonnullValidator:nil](accountType);
  [DBStoneValidators nonnullValidator:nil](rootInfo);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(2) maxLength:@(2) pattern:nil]](country);

  self = [super initWithAccountId:accountId
                             name:name
                            email:email
                    emailVerified:emailVerified
                         disabled:disabled
                  profilePhotoUrl:profilePhotoUrl];
  if (self) {
    _country = country;
    _locale = locale;
    _referralLink = referralLink;
    _team = team;
    _teamMemberId = teamMemberId;
    _isPaired = isPaired;
    _accountType = accountType;
    _rootInfo = rootInfo;
  }
  return self;
}

- (instancetype)initWithAccountId:(NSString *)accountId
                             name:(DBUSERSName *)name
                            email:(NSString *)email
                    emailVerified:(NSNumber *)emailVerified
                         disabled:(NSNumber *)disabled
                           locale:(NSString *)locale
                     referralLink:(NSString *)referralLink
                         isPaired:(NSNumber *)isPaired
                      accountType:(DBUSERSCOMMONAccountType *)accountType
                         rootInfo:(DBCOMMONRootInfo *)rootInfo {
  return [self initWithAccountId:accountId
                            name:name
                           email:email
                   emailVerified:emailVerified
                        disabled:disabled
                          locale:locale
                    referralLink:referralLink
                        isPaired:isPaired
                     accountType:accountType
                        rootInfo:rootInfo
                 profilePhotoUrl:nil
                         country:nil
                            team:nil
                    teamMemberId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSFullAccountSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSFullAccountSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSFullAccountSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountId hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.email hash];
  result = prime * result + [self.emailVerified hash];
  result = prime * result + [self.disabled hash];
  result = prime * result + [self.locale hash];
  result = prime * result + [self.referralLink hash];
  result = prime * result + [self.isPaired hash];
  result = prime * result + [self.accountType hash];
  result = prime * result + [self.rootInfo hash];
  if (self.profilePhotoUrl != nil) {
    result = prime * result + [self.profilePhotoUrl hash];
  }
  if (self.country != nil) {
    result = prime * result + [self.country hash];
  }
  if (self.team != nil) {
    result = prime * result + [self.team hash];
  }
  if (self.teamMemberId != nil) {
    result = prime * result + [self.teamMemberId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFullAccount:other];
}

- (BOOL)isEqualToFullAccount:(DBUSERSFullAccount *)aFullAccount {
  if (self == aFullAccount) {
    return YES;
  }
  if (![self.accountId isEqual:aFullAccount.accountId]) {
    return NO;
  }
  if (![self.name isEqual:aFullAccount.name]) {
    return NO;
  }
  if (![self.email isEqual:aFullAccount.email]) {
    return NO;
  }
  if (![self.emailVerified isEqual:aFullAccount.emailVerified]) {
    return NO;
  }
  if (![self.disabled isEqual:aFullAccount.disabled]) {
    return NO;
  }
  if (![self.locale isEqual:aFullAccount.locale]) {
    return NO;
  }
  if (![self.referralLink isEqual:aFullAccount.referralLink]) {
    return NO;
  }
  if (![self.isPaired isEqual:aFullAccount.isPaired]) {
    return NO;
  }
  if (![self.accountType isEqual:aFullAccount.accountType]) {
    return NO;
  }
  if (![self.rootInfo isEqual:aFullAccount.rootInfo]) {
    return NO;
  }
  if (self.profilePhotoUrl) {
    if (![self.profilePhotoUrl isEqual:aFullAccount.profilePhotoUrl]) {
      return NO;
    }
  }
  if (self.country) {
    if (![self.country isEqual:aFullAccount.country]) {
      return NO;
    }
  }
  if (self.team) {
    if (![self.team isEqual:aFullAccount.team]) {
      return NO;
    }
  }
  if (self.teamMemberId) {
    if (![self.teamMemberId isEqual:aFullAccount.teamMemberId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSFullAccountSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSFullAccount *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_id"] = valueObj.accountId;
  jsonDict[@"name"] = [DBUSERSNameSerializer serialize:valueObj.name];
  jsonDict[@"email"] = valueObj.email;
  jsonDict[@"email_verified"] = valueObj.emailVerified;
  jsonDict[@"disabled"] = valueObj.disabled;
  jsonDict[@"locale"] = valueObj.locale;
  jsonDict[@"referral_link"] = valueObj.referralLink;
  jsonDict[@"is_paired"] = valueObj.isPaired;
  jsonDict[@"account_type"] = [DBUSERSCOMMONAccountTypeSerializer serialize:valueObj.accountType];
  jsonDict[@"root_info"] = [DBCOMMONRootInfoSerializer serialize:valueObj.rootInfo];
  if (valueObj.profilePhotoUrl) {
    jsonDict[@"profile_photo_url"] = valueObj.profilePhotoUrl;
  }
  if (valueObj.country) {
    jsonDict[@"country"] = valueObj.country;
  }
  if (valueObj.team) {
    jsonDict[@"team"] = [DBUSERSFullTeamSerializer serialize:valueObj.team];
  }
  if (valueObj.teamMemberId) {
    jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSFullAccount *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *accountId = valueDict[@"account_id"];
  DBUSERSName *name = [DBUSERSNameSerializer deserialize:valueDict[@"name"]];
  NSString *email = valueDict[@"email"];
  NSNumber *emailVerified = valueDict[@"email_verified"];
  NSNumber *disabled = valueDict[@"disabled"];
  NSString *locale = valueDict[@"locale"];
  NSString *referralLink = valueDict[@"referral_link"];
  NSNumber *isPaired = valueDict[@"is_paired"];
  DBUSERSCOMMONAccountType *accountType = [DBUSERSCOMMONAccountTypeSerializer deserialize:valueDict[@"account_type"]];
  DBCOMMONRootInfo *rootInfo = [DBCOMMONRootInfoSerializer deserialize:valueDict[@"root_info"]];
  NSString *profilePhotoUrl = valueDict[@"profile_photo_url"] ?: nil;
  NSString *country = valueDict[@"country"] ?: nil;
  DBUSERSFullTeam *team = valueDict[@"team"] ? [DBUSERSFullTeamSerializer deserialize:valueDict[@"team"]] : nil;
  NSString *teamMemberId = valueDict[@"team_member_id"] ?: nil;

  return [[DBUSERSFullAccount alloc] initWithAccountId:accountId
                                                  name:name
                                                 email:email
                                         emailVerified:emailVerified
                                              disabled:disabled
                                                locale:locale
                                          referralLink:referralLink
                                              isPaired:isPaired
                                           accountType:accountType
                                              rootInfo:rootInfo
                                       profilePhotoUrl:profilePhotoUrl
                                               country:country
                                                  team:team
                                          teamMemberId:teamMemberId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBUSERSTeam

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ name:(NSString *)name {
  [DBStoneValidators nonnullValidator:nil](id_);
  [DBStoneValidators nonnullValidator:nil](name);

  self = [super init];
  if (self) {
    _id_ = id_;
    _name = name;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSTeamSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSTeamSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSTeamSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.name hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeam:other];
}

- (BOOL)isEqualToTeam:(DBUSERSTeam *)aTeam {
  if (self == aTeam) {
    return YES;
  }
  if (![self.id_ isEqual:aTeam.id_]) {
    return NO;
  }
  if (![self.name isEqual:aTeam.name]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSTeamSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSTeam *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"name"] = valueObj.name;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSTeam *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"];

  return [[DBUSERSTeam alloc] initWithId_:id_ name:name];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESOfficeAddInPolicy.h"
#import "DBTEAMPOLICIESTeamSharingPolicies.h"
#import "DBUSERSFullTeam.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBUSERSFullTeam

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
            sharingPolicies:(DBTEAMPOLICIESTeamSharingPolicies *)sharingPolicies
          officeAddinPolicy:(DBTEAMPOLICIESOfficeAddInPolicy *)officeAddinPolicy {
  [DBStoneValidators nonnullValidator:nil](id_);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](sharingPolicies);
  [DBStoneValidators nonnullValidator:nil](officeAddinPolicy);

  self = [super initWithId_:id_ name:name];
  if (self) {
    _sharingPolicies = sharingPolicies;
    _officeAddinPolicy = officeAddinPolicy;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSFullTeamSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSFullTeamSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSFullTeamSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.sharingPolicies hash];
  result = prime * result + [self.officeAddinPolicy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFullTeam:other];
}

- (BOOL)isEqualToFullTeam:(DBUSERSFullTeam *)aFullTeam {
  if (self == aFullTeam) {
    return YES;
  }
  if (![self.id_ isEqual:aFullTeam.id_]) {
    return NO;
  }
  if (![self.name isEqual:aFullTeam.name]) {
    return NO;
  }
  if (![self.sharingPolicies isEqual:aFullTeam.sharingPolicies]) {
    return NO;
  }
  if (![self.officeAddinPolicy isEqual:aFullTeam.officeAddinPolicy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSFullTeamSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSFullTeam *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"sharing_policies"] = [DBTEAMPOLICIESTeamSharingPoliciesSerializer serialize:valueObj.sharingPolicies];
  jsonDict[@"office_addin_policy"] = [DBTEAMPOLICIESOfficeAddInPolicySerializer serialize:valueObj.officeAddinPolicy];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSFullTeam *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"];
  DBTEAMPOLICIESTeamSharingPolicies *sharingPolicies =
      [DBTEAMPOLICIESTeamSharingPoliciesSerializer deserialize:valueDict[@"sharing_policies"]];
  DBTEAMPOLICIESOfficeAddInPolicy *officeAddinPolicy =
      [DBTEAMPOLICIESOfficeAddInPolicySerializer deserialize:valueDict[@"office_addin_policy"]];

  return [[DBUSERSFullTeam alloc] initWithId_:id_
                                         name:name
                              sharingPolicies:sharingPolicies
                            officeAddinPolicy:officeAddinPolicy];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSGetAccountArg.h"

#pragma mark - API Object

@implementation DBUSERSGetAccountArg

#pragma mark - Constructors

- (instancetype)initWithAccountId:(NSString *)accountId {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);

  self = [super init];
  if (self) {
    _accountId = accountId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSGetAccountArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSGetAccountArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSGetAccountArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetAccountArg:other];
}

- (BOOL)isEqualToGetAccountArg:(DBUSERSGetAccountArg *)aGetAccountArg {
  if (self == aGetAccountArg) {
    return YES;
  }
  if (![self.accountId isEqual:aGetAccountArg.accountId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSGetAccountArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSGetAccountArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_id"] = valueObj.accountId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSGetAccountArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *accountId = valueDict[@"account_id"];

  return [[DBUSERSGetAccountArg alloc] initWithAccountId:accountId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSGetAccountBatchArg.h"

#pragma mark - API Object

@implementation DBUSERSGetAccountBatchArg

#pragma mark - Constructors

- (instancetype)initWithAccountIds:(NSArray<NSString *> *)accountIds {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:@(1)
                              maxItems:nil
                         itemValidator:[DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40)
                                                                                                    maxLength:@(40)
                                                                                                      pattern:nil]]]](
      accountIds);

  self = [super init];
  if (self) {
    _accountIds = accountIds;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSGetAccountBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSGetAccountBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSGetAccountBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountIds hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetAccountBatchArg:other];
}

- (BOOL)isEqualToGetAccountBatchArg:(DBUSERSGetAccountBatchArg *)aGetAccountBatchArg {
  if (self == aGetAccountBatchArg) {
    return YES;
  }
  if (![self.accountIds isEqual:aGetAccountBatchArg.accountIds]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSGetAccountBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSGetAccountBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_ids"] = [DBArraySerializer serialize:valueObj.accountIds
                                                withBlock:^id(id elem0) {
                                                  return elem0;
                                                }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSGetAccountBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *accountIds = [DBArraySerializer deserialize:valueDict[@"account_ids"]
                                                         withBlock:^id(id elem0) {
                                                           return elem0;
                                                         }];

  return [[DBUSERSGetAccountBatchArg alloc] initWithAccountIds:accountIds];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSGetAccountBatchError.h"

#pragma mark - API Object

@implementation DBUSERSGetAccountBatchError

@synthesize noAccount = _noAccount;

#pragma mark - Constructors

- (instancetype)initWithNoAccount:(NSString *)noAccount {
  self = [super init];
  if (self) {
    _tag = DBUSERSGetAccountBatchErrorNoAccount;
    _noAccount = noAccount;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSGetAccountBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)noAccount {
  if (![self isNoAccount]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSGetAccountBatchErrorNoAccount, but was %@.", [self tagName]];
  }
  return _noAccount;
}

#pragma mark - Tag state methods

- (BOOL)isNoAccount {
  return _tag == DBUSERSGetAccountBatchErrorNoAccount;
}

- (BOOL)isOther {
  return _tag == DBUSERSGetAccountBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSGetAccountBatchErrorNoAccount:
    return @"DBUSERSGetAccountBatchErrorNoAccount";
  case DBUSERSGetAccountBatchErrorOther:
    return @"DBUSERSGetAccountBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSGetAccountBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSGetAccountBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSGetAccountBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSGetAccountBatchErrorNoAccount:
    result = prime * result + [self.noAccount hash];
    break;
  case DBUSERSGetAccountBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetAccountBatchError:other];
}

- (BOOL)isEqualToGetAccountBatchError:(DBUSERSGetAccountBatchError *)aGetAccountBatchError {
  if (self == aGetAccountBatchError) {
    return YES;
  }
  if (self.tag != aGetAccountBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSGetAccountBatchErrorNoAccount:
    return [self.noAccount isEqual:aGetAccountBatchError.noAccount];
  case DBUSERSGetAccountBatchErrorOther:
    return [[self tagName] isEqual:[aGetAccountBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSGetAccountBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSGetAccountBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNoAccount]) {
    jsonDict[@"no_account"] = valueObj.noAccount;
    jsonDict[@".tag"] = @"no_account";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSGetAccountBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"no_account"]) {
    NSString *noAccount = valueDict[@"no_account"];
    return [[DBUSERSGetAccountBatchError alloc] initWithNoAccount:noAccount];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSGetAccountBatchError alloc] initWithOther];
  } else {
    return [[DBUSERSGetAccountBatchError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSGetAccountError.h"

#pragma mark - API Object

@implementation DBUSERSGetAccountError

#pragma mark - Constructors

- (instancetype)initWithNoAccount {
  self = [super init];
  if (self) {
    _tag = DBUSERSGetAccountErrorNoAccount;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSGetAccountErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isNoAccount {
  return _tag == DBUSERSGetAccountErrorNoAccount;
}

- (BOOL)isOther {
  return _tag == DBUSERSGetAccountErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSGetAccountErrorNoAccount:
    return @"DBUSERSGetAccountErrorNoAccount";
  case DBUSERSGetAccountErrorOther:
    return @"DBUSERSGetAccountErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSGetAccountErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSGetAccountErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSGetAccountErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSGetAccountErrorNoAccount:
    result = prime * result + [[self tagName] hash];
    break;
  case DBUSERSGetAccountErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetAccountError:other];
}

- (BOOL)isEqualToGetAccountError:(DBUSERSGetAccountError *)aGetAccountError {
  if (self == aGetAccountError) {
    return YES;
  }
  if (self.tag != aGetAccountError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSGetAccountErrorNoAccount:
    return [[self tagName] isEqual:[aGetAccountError tagName]];
  case DBUSERSGetAccountErrorOther:
    return [[self tagName] isEqual:[aGetAccountError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSGetAccountErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSGetAccountError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNoAccount]) {
    jsonDict[@".tag"] = @"no_account";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSGetAccountError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"no_account"]) {
    return [[DBUSERSGetAccountError alloc] initWithNoAccount];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSGetAccountError alloc] initWithOther];
  } else {
    return [[DBUSERSGetAccountError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSIndividualSpaceAllocation.h"

#pragma mark - API Object

@implementation DBUSERSIndividualSpaceAllocation

#pragma mark - Constructors

- (instancetype)initWithAllocated:(NSNumber *)allocated {
  [DBStoneValidators nonnullValidator:nil](allocated);

  self = [super init];
  if (self) {
    _allocated = allocated;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSIndividualSpaceAllocationSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSIndividualSpaceAllocationSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSIndividualSpaceAllocationSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.allocated hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToIndividualSpaceAllocation:other];
}

- (BOOL)isEqualToIndividualSpaceAllocation:(DBUSERSIndividualSpaceAllocation *)anIndividualSpaceAllocation {
  if (self == anIndividualSpaceAllocation) {
    return YES;
  }
  if (![self.allocated isEqual:anIndividualSpaceAllocation.allocated]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSIndividualSpaceAllocationSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSIndividualSpaceAllocation *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"allocated"] = valueObj.allocated;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSIndividualSpaceAllocation *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *allocated = valueDict[@"allocated"];

  return [[DBUSERSIndividualSpaceAllocation alloc] initWithAllocated:allocated];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSName.h"

#pragma mark - API Object

@implementation DBUSERSName

#pragma mark - Constructors

- (instancetype)initWithGivenName:(NSString *)givenName
                          surname:(NSString *)surname
                     familiarName:(NSString *)familiarName
                      displayName:(NSString *)displayName
                  abbreviatedName:(NSString *)abbreviatedName {
  [DBStoneValidators nonnullValidator:nil](givenName);
  [DBStoneValidators nonnullValidator:nil](surname);
  [DBStoneValidators nonnullValidator:nil](familiarName);
  [DBStoneValidators nonnullValidator:nil](displayName);
  [DBStoneValidators nonnullValidator:nil](abbreviatedName);

  self = [super init];
  if (self) {
    _givenName = givenName;
    _surname = surname;
    _familiarName = familiarName;
    _displayName = displayName;
    _abbreviatedName = abbreviatedName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSNameSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSNameSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSNameSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.givenName hash];
  result = prime * result + [self.surname hash];
  result = prime * result + [self.familiarName hash];
  result = prime * result + [self.displayName hash];
  result = prime * result + [self.abbreviatedName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToName:other];
}

- (BOOL)isEqualToName:(DBUSERSName *)aName {
  if (self == aName) {
    return YES;
  }
  if (![self.givenName isEqual:aName.givenName]) {
    return NO;
  }
  if (![self.surname isEqual:aName.surname]) {
    return NO;
  }
  if (![self.familiarName isEqual:aName.familiarName]) {
    return NO;
  }
  if (![self.displayName isEqual:aName.displayName]) {
    return NO;
  }
  if (![self.abbreviatedName isEqual:aName.abbreviatedName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSNameSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSName *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"given_name"] = valueObj.givenName;
  jsonDict[@"surname"] = valueObj.surname;
  jsonDict[@"familiar_name"] = valueObj.familiarName;
  jsonDict[@"display_name"] = valueObj.displayName;
  jsonDict[@"abbreviated_name"] = valueObj.abbreviatedName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSName *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *givenName = valueDict[@"given_name"];
  NSString *surname = valueDict[@"surname"];
  NSString *familiarName = valueDict[@"familiar_name"];
  NSString *displayName = valueDict[@"display_name"];
  NSString *abbreviatedName = valueDict[@"abbreviated_name"];

  return [[DBUSERSName alloc] initWithGivenName:givenName
                                        surname:surname
                                   familiarName:familiarName
                                    displayName:displayName
                                abbreviatedName:abbreviatedName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSPaperAsFilesValue.h"

#pragma mark - API Object

@implementation DBUSERSPaperAsFilesValue

@synthesize enabled = _enabled;

#pragma mark - Constructors

- (instancetype)initWithEnabled:(NSNumber *)enabled {
  self = [super init];
  if (self) {
    _tag = DBUSERSPaperAsFilesValueEnabled;
    _enabled = enabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSPaperAsFilesValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSNumber *)enabled {
  if (![self isEnabled]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSPaperAsFilesValueEnabled, but was %@.", [self tagName]];
  }
  return _enabled;
}

#pragma mark - Tag state methods

- (BOOL)isEnabled {
  return _tag == DBUSERSPaperAsFilesValueEnabled;
}

- (BOOL)isOther {
  return _tag == DBUSERSPaperAsFilesValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSPaperAsFilesValueEnabled:
    return @"DBUSERSPaperAsFilesValueEnabled";
  case DBUSERSPaperAsFilesValueOther:
    return @"DBUSERSPaperAsFilesValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSPaperAsFilesValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSPaperAsFilesValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSPaperAsFilesValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSPaperAsFilesValueEnabled:
    result = prime * result + [self.enabled hash];
    break;
  case DBUSERSPaperAsFilesValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperAsFilesValue:other];
}

- (BOOL)isEqualToPaperAsFilesValue:(DBUSERSPaperAsFilesValue *)aPaperAsFilesValue {
  if (self == aPaperAsFilesValue) {
    return YES;
  }
  if (self.tag != aPaperAsFilesValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSPaperAsFilesValueEnabled:
    return [self.enabled isEqual:aPaperAsFilesValue.enabled];
  case DBUSERSPaperAsFilesValueOther:
    return [[self tagName] isEqual:[aPaperAsFilesValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSPaperAsFilesValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSPaperAsFilesValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEnabled]) {
    jsonDict[@"enabled"] = valueObj.enabled;
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSPaperAsFilesValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"enabled"]) {
    NSNumber *enabled = valueDict[@"enabled"];
    return [[DBUSERSPaperAsFilesValue alloc] initWithEnabled:enabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSPaperAsFilesValue alloc] initWithOther];
  } else {
    return [[DBUSERSPaperAsFilesValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSIndividualSpaceAllocation.h"
#import "DBUSERSSpaceAllocation.h"
#import "DBUSERSTeamSpaceAllocation.h"

#pragma mark - API Object

@implementation DBUSERSSpaceAllocation

@synthesize individual = _individual;
@synthesize team = _team;

#pragma mark - Constructors

- (instancetype)initWithIndividual:(DBUSERSIndividualSpaceAllocation *)individual {
  self = [super init];
  if (self) {
    _tag = DBUSERSSpaceAllocationIndividual;
    _individual = individual;
  }
  return self;
}

- (instancetype)initWithTeam:(DBUSERSTeamSpaceAllocation *)team {
  self = [super init];
  if (self) {
    _tag = DBUSERSSpaceAllocationTeam;
    _team = team;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSSpaceAllocationOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBUSERSIndividualSpaceAllocation *)individual {
  if (![self isIndividual]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSSpaceAllocationIndividual, but was %@.", [self tagName]];
  }
  return _individual;
}

- (DBUSERSTeamSpaceAllocation *)team {
  if (![self isTeam]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSSpaceAllocationTeam, but was %@.", [self tagName]];
  }
  return _team;
}

#pragma mark - Tag state methods

- (BOOL)isIndividual {
  return _tag == DBUSERSSpaceAllocationIndividual;
}

- (BOOL)isTeam {
  return _tag == DBUSERSSpaceAllocationTeam;
}

- (BOOL)isOther {
  return _tag == DBUSERSSpaceAllocationOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSSpaceAllocationIndividual:
    return @"DBUSERSSpaceAllocationIndividual";
  case DBUSERSSpaceAllocationTeam:
    return @"DBUSERSSpaceAllocationTeam";
  case DBUSERSSpaceAllocationOther:
    return @"DBUSERSSpaceAllocationOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSSpaceAllocationSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSSpaceAllocationSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSSpaceAllocationSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSSpaceAllocationIndividual:
    result = prime * result + [self.individual hash];
    break;
  case DBUSERSSpaceAllocationTeam:
    result = prime * result + [self.team hash];
    break;
  case DBUSERSSpaceAllocationOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSpaceAllocation:other];
}

- (BOOL)isEqualToSpaceAllocation:(DBUSERSSpaceAllocation *)aSpaceAllocation {
  if (self == aSpaceAllocation) {
    return YES;
  }
  if (self.tag != aSpaceAllocation.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSSpaceAllocationIndividual:
    return [self.individual isEqual:aSpaceAllocation.individual];
  case DBUSERSSpaceAllocationTeam:
    return [self.team isEqual:aSpaceAllocation.team];
  case DBUSERSSpaceAllocationOther:
    return [[self tagName] isEqual:[aSpaceAllocation tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSSpaceAllocationSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSSpaceAllocation *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIndividual]) {
    jsonDict = [[DBUSERSIndividualSpaceAllocationSerializer serialize:valueObj.individual] mutableCopy];
    jsonDict[@".tag"] = @"individual";
  } else if ([valueObj isTeam]) {
    jsonDict = [[DBUSERSTeamSpaceAllocationSerializer serialize:valueObj.team] mutableCopy];
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSSpaceAllocation *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"individual"]) {
    DBUSERSIndividualSpaceAllocation *individual = [DBUSERSIndividualSpaceAllocationSerializer deserialize:valueDict];
    return [[DBUSERSSpaceAllocation alloc] initWithIndividual:individual];
  } else if ([tag isEqualToString:@"team"]) {
    DBUSERSTeamSpaceAllocation *team = [DBUSERSTeamSpaceAllocationSerializer deserialize:valueDict];
    return [[DBUSERSSpaceAllocation alloc] initWithTeam:team];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSSpaceAllocation alloc] initWithOther];
  } else {
    return [[DBUSERSSpaceAllocation alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSSpaceAllocation.h"
#import "DBUSERSSpaceUsage.h"

#pragma mark - API Object

@implementation DBUSERSSpaceUsage

#pragma mark - Constructors

- (instancetype)initWithUsed:(NSNumber *)used allocation:(DBUSERSSpaceAllocation *)allocation {
  [DBStoneValidators nonnullValidator:nil](used);
  [DBStoneValidators nonnullValidator:nil](allocation);

  self = [super init];
  if (self) {
    _used = used;
    _allocation = allocation;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSSpaceUsageSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSSpaceUsageSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSSpaceUsageSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.used hash];
  result = prime * result + [self.allocation hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSpaceUsage:other];
}

- (BOOL)isEqualToSpaceUsage:(DBUSERSSpaceUsage *)aSpaceUsage {
  if (self == aSpaceUsage) {
    return YES;
  }
  if (![self.used isEqual:aSpaceUsage.used]) {
    return NO;
  }
  if (![self.allocation isEqual:aSpaceUsage.allocation]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSSpaceUsageSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSSpaceUsage *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"used"] = valueObj.used;
  jsonDict[@"allocation"] = [DBUSERSSpaceAllocationSerializer serialize:valueObj.allocation];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSSpaceUsage *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *used = valueDict[@"used"];
  DBUSERSSpaceAllocation *allocation = [DBUSERSSpaceAllocationSerializer deserialize:valueDict[@"allocation"]];

  return [[DBUSERSSpaceUsage alloc] initWithUsed:used allocation:allocation];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONMemberSpaceLimitType.h"
#import "DBUSERSTeamSpaceAllocation.h"

#pragma mark - API Object

@implementation DBUSERSTeamSpaceAllocation

#pragma mark - Constructors

- (instancetype)initWithUsed:(NSNumber *)used
                        allocated:(NSNumber *)allocated
     userWithinTeamSpaceAllocated:(NSNumber *)userWithinTeamSpaceAllocated
     userWithinTeamSpaceLimitType:(DBTEAMCOMMONMemberSpaceLimitType *)userWithinTeamSpaceLimitType
    userWithinTeamSpaceUsedCached:(NSNumber *)userWithinTeamSpaceUsedCached {
  [DBStoneValidators nonnullValidator:nil](used);
  [DBStoneValidators nonnullValidator:nil](allocated);
  [DBStoneValidators nonnullValidator:nil](userWithinTeamSpaceAllocated);
  [DBStoneValidators nonnullValidator:nil](userWithinTeamSpaceLimitType);
  [DBStoneValidators nonnullValidator:nil](userWithinTeamSpaceUsedCached);

  self = [super init];
  if (self) {
    _used = used;
    _allocated = allocated;
    _userWithinTeamSpaceAllocated = userWithinTeamSpaceAllocated;
    _userWithinTeamSpaceLimitType = userWithinTeamSpaceLimitType;
    _userWithinTeamSpaceUsedCached = userWithinTeamSpaceUsedCached;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSTeamSpaceAllocationSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSTeamSpaceAllocationSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSTeamSpaceAllocationSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.used hash];
  result = prime * result + [self.allocated hash];
  result = prime * result + [self.userWithinTeamSpaceAllocated hash];
  result = prime * result + [self.userWithinTeamSpaceLimitType hash];
  result = prime * result + [self.userWithinTeamSpaceUsedCached hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamSpaceAllocation:other];
}

- (BOOL)isEqualToTeamSpaceAllocation:(DBUSERSTeamSpaceAllocation *)aTeamSpaceAllocation {
  if (self == aTeamSpaceAllocation) {
    return YES;
  }
  if (![self.used isEqual:aTeamSpaceAllocation.used]) {
    return NO;
  }
  if (![self.allocated isEqual:aTeamSpaceAllocation.allocated]) {
    return NO;
  }
  if (![self.userWithinTeamSpaceAllocated isEqual:aTeamSpaceAllocation.userWithinTeamSpaceAllocated]) {
    return NO;
  }
  if (![self.userWithinTeamSpaceLimitType isEqual:aTeamSpaceAllocation.userWithinTeamSpaceLimitType]) {
    return NO;
  }
  if (![self.userWithinTeamSpaceUsedCached isEqual:aTeamSpaceAllocation.userWithinTeamSpaceUsedCached]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSTeamSpaceAllocationSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSTeamSpaceAllocation *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"used"] = valueObj.used;
  jsonDict[@"allocated"] = valueObj.allocated;
  jsonDict[@"user_within_team_space_allocated"] = valueObj.userWithinTeamSpaceAllocated;
  jsonDict[@"user_within_team_space_limit_type"] =
      [DBTEAMCOMMONMemberSpaceLimitTypeSerializer serialize:valueObj.userWithinTeamSpaceLimitType];
  jsonDict[@"user_within_team_space_used_cached"] = valueObj.userWithinTeamSpaceUsedCached;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSTeamSpaceAllocation *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *used = valueDict[@"used"];
  NSNumber *allocated = valueDict[@"allocated"];
  NSNumber *userWithinTeamSpaceAllocated = valueDict[@"user_within_team_space_allocated"];
  DBTEAMCOMMONMemberSpaceLimitType *userWithinTeamSpaceLimitType =
      [DBTEAMCOMMONMemberSpaceLimitTypeSerializer deserialize:valueDict[@"user_within_team_space_limit_type"]];
  NSNumber *userWithinTeamSpaceUsedCached = valueDict[@"user_within_team_space_used_cached"];

  return [[DBUSERSTeamSpaceAllocation alloc] initWithUsed:used
                                                allocated:allocated
                             userWithinTeamSpaceAllocated:userWithinTeamSpaceAllocated
                             userWithinTeamSpaceLimitType:userWithinTeamSpaceLimitType
                            userWithinTeamSpaceUsedCached:userWithinTeamSpaceUsedCached];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSUserFeature.h"

#pragma mark - API Object

@implementation DBUSERSUserFeature

#pragma mark - Constructors

- (instancetype)initWithPaperAsFiles {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeaturePaperAsFiles;
  }
  return self;
}

- (instancetype)initWithFileLocking {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeatureFileLocking;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeatureOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPaperAsFiles {
  return _tag == DBUSERSUserFeaturePaperAsFiles;
}

- (BOOL)isFileLocking {
  return _tag == DBUSERSUserFeatureFileLocking;
}

- (BOOL)isOther {
  return _tag == DBUSERSUserFeatureOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSUserFeaturePaperAsFiles:
    return @"DBUSERSUserFeaturePaperAsFiles";
  case DBUSERSUserFeatureFileLocking:
    return @"DBUSERSUserFeatureFileLocking";
  case DBUSERSUserFeatureOther:
    return @"DBUSERSUserFeatureOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSUserFeatureSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSUserFeatureSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSUserFeatureSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSUserFeaturePaperAsFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBUSERSUserFeatureFileLocking:
    result = prime * result + [[self tagName] hash];
    break;
  case DBUSERSUserFeatureOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFeature:other];
}

- (BOOL)isEqualToUserFeature:(DBUSERSUserFeature *)anUserFeature {
  if (self == anUserFeature) {
    return YES;
  }
  if (self.tag != anUserFeature.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSUserFeaturePaperAsFiles:
    return [[self tagName] isEqual:[anUserFeature tagName]];
  case DBUSERSUserFeatureFileLocking:
    return [[self tagName] isEqual:[anUserFeature tagName]];
  case DBUSERSUserFeatureOther:
    return [[self tagName] isEqual:[anUserFeature tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSUserFeatureSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeature *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPaperAsFiles]) {
    jsonDict[@".tag"] = @"paper_as_files";
  } else if ([valueObj isFileLocking]) {
    jsonDict[@".tag"] = @"file_locking";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSUserFeature *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"paper_as_files"]) {
    return [[DBUSERSUserFeature alloc] initWithPaperAsFiles];
  } else if ([tag isEqualToString:@"file_locking"]) {
    return [[DBUSERSUserFeature alloc] initWithFileLocking];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSUserFeature alloc] initWithOther];
  } else {
    return [[DBUSERSUserFeature alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSFileLockingValue.h"
#import "DBUSERSPaperAsFilesValue.h"
#import "DBUSERSUserFeatureValue.h"

#pragma mark - API Object

@implementation DBUSERSUserFeatureValue

@synthesize paperAsFiles = _paperAsFiles;
@synthesize fileLocking = _fileLocking;

#pragma mark - Constructors

- (instancetype)initWithPaperAsFiles:(DBUSERSPaperAsFilesValue *)paperAsFiles {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeatureValuePaperAsFiles;
    _paperAsFiles = paperAsFiles;
  }
  return self;
}

- (instancetype)initWithFileLocking:(DBUSERSFileLockingValue *)fileLocking {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeatureValueFileLocking;
    _fileLocking = fileLocking;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeatureValueOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBUSERSPaperAsFilesValue *)paperAsFiles {
  if (![self isPaperAsFiles]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSUserFeatureValuePaperAsFiles, but was %@.", [self tagName]];
  }
  return _paperAsFiles;
}

- (DBUSERSFileLockingValue *)fileLocking {
  if (![self isFileLocking]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBUSERSUserFeatureValueFileLocking, but was %@.", [self tagName]];
  }
  return _fileLocking;
}

#pragma mark - Tag state methods

- (BOOL)isPaperAsFiles {
  return _tag == DBUSERSUserFeatureValuePaperAsFiles;
}

- (BOOL)isFileLocking {
  return _tag == DBUSERSUserFeatureValueFileLocking;
}

- (BOOL)isOther {
  return _tag == DBUSERSUserFeatureValueOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSUserFeatureValuePaperAsFiles:
    return @"DBUSERSUserFeatureValuePaperAsFiles";
  case DBUSERSUserFeatureValueFileLocking:
    return @"DBUSERSUserFeatureValueFileLocking";
  case DBUSERSUserFeatureValueOther:
    return @"DBUSERSUserFeatureValueOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSUserFeatureValueSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSUserFeatureValueSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSUserFeatureValueSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSUserFeatureValuePaperAsFiles:
    result = prime * result + [self.paperAsFiles hash];
    break;
  case DBUSERSUserFeatureValueFileLocking:
    result = prime * result + [self.fileLocking hash];
    break;
  case DBUSERSUserFeatureValueOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFeatureValue:other];
}

- (BOOL)isEqualToUserFeatureValue:(DBUSERSUserFeatureValue *)anUserFeatureValue {
  if (self == anUserFeatureValue) {
    return YES;
  }
  if (self.tag != anUserFeatureValue.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSUserFeatureValuePaperAsFiles:
    return [self.paperAsFiles isEqual:anUserFeatureValue.paperAsFiles];
  case DBUSERSUserFeatureValueFileLocking:
    return [self.fileLocking isEqual:anUserFeatureValue.fileLocking];
  case DBUSERSUserFeatureValueOther:
    return [[self tagName] isEqual:[anUserFeatureValue tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSUserFeatureValueSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeatureValue *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPaperAsFiles]) {
    jsonDict[@"paper_as_files"] = [[DBUSERSPaperAsFilesValueSerializer serialize:valueObj.paperAsFiles] mutableCopy];
    jsonDict[@".tag"] = @"paper_as_files";
  } else if ([valueObj isFileLocking]) {
    jsonDict[@"file_locking"] = [[DBUSERSFileLockingValueSerializer serialize:valueObj.fileLocking] mutableCopy];
    jsonDict[@".tag"] = @"file_locking";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSUserFeatureValue *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"paper_as_files"]) {
    DBUSERSPaperAsFilesValue *paperAsFiles =
        [DBUSERSPaperAsFilesValueSerializer deserialize:valueDict[@"paper_as_files"]];
    return [[DBUSERSUserFeatureValue alloc] initWithPaperAsFiles:paperAsFiles];
  } else if ([tag isEqualToString:@"file_locking"]) {
    DBUSERSFileLockingValue *fileLocking = [DBUSERSFileLockingValueSerializer deserialize:valueDict[@"file_locking"]];
    return [[DBUSERSUserFeatureValue alloc] initWithFileLocking:fileLocking];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSUserFeatureValue alloc] initWithOther];
  } else {
    return [[DBUSERSUserFeatureValue alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSUserFeature.h"
#import "DBUSERSUserFeaturesGetValuesBatchArg.h"

#pragma mark - API Object

@implementation DBUSERSUserFeaturesGetValuesBatchArg

#pragma mark - Constructors

- (instancetype)initWithFeatures:(NSArray<DBUSERSUserFeature *> *)features {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](features);

  self = [super init];
  if (self) {
    _features = features;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSUserFeaturesGetValuesBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSUserFeaturesGetValuesBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSUserFeaturesGetValuesBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.features hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFeaturesGetValuesBatchArg:other];
}

- (BOOL)isEqualToUserFeaturesGetValuesBatchArg:(DBUSERSUserFeaturesGetValuesBatchArg *)anUserFeaturesGetValuesBatchArg {
  if (self == anUserFeaturesGetValuesBatchArg) {
    return YES;
  }
  if (![self.features isEqual:anUserFeaturesGetValuesBatchArg.features]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSUserFeaturesGetValuesBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeaturesGetValuesBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"features"] = [DBArraySerializer serialize:valueObj.features
                                             withBlock:^id(id elem0) {
                                               return [DBUSERSUserFeatureSerializer serialize:elem0];
                                             }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSUserFeaturesGetValuesBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBUSERSUserFeature *> *features =
      [DBArraySerializer deserialize:valueDict[@"features"]
                           withBlock:^id(id elem0) {
                             return [DBUSERSUserFeatureSerializer deserialize:elem0];
                           }];

  return [[DBUSERSUserFeaturesGetValuesBatchArg alloc] initWithFeatures:features];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSUserFeaturesGetValuesBatchError.h"

#pragma mark - API Object

@implementation DBUSERSUserFeaturesGetValuesBatchError

#pragma mark - Constructors

- (instancetype)initWithEmptyFeaturesList {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBUSERSUserFeaturesGetValuesBatchErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEmptyFeaturesList {
  return _tag == DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList;
}

- (BOOL)isOther {
  return _tag == DBUSERSUserFeaturesGetValuesBatchErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList:
    return @"DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList";
  case DBUSERSUserFeaturesGetValuesBatchErrorOther:
    return @"DBUSERSUserFeaturesGetValuesBatchErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSUserFeaturesGetValuesBatchErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSUserFeaturesGetValuesBatchErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSUserFeaturesGetValuesBatchErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList:
    result = prime * result + [[self tagName] hash];
    break;
  case DBUSERSUserFeaturesGetValuesBatchErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFeaturesGetValuesBatchError:other];
}

- (BOOL)isEqualToUserFeaturesGetValuesBatchError:
    (DBUSERSUserFeaturesGetValuesBatchError *)anUserFeaturesGetValuesBatchError {
  if (self == anUserFeaturesGetValuesBatchError) {
    return YES;
  }
  if (self.tag != anUserFeaturesGetValuesBatchError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBUSERSUserFeaturesGetValuesBatchErrorEmptyFeaturesList:
    return [[self tagName] isEqual:[anUserFeaturesGetValuesBatchError tagName]];
  case DBUSERSUserFeaturesGetValuesBatchErrorOther:
    return [[self tagName] isEqual:[anUserFeaturesGetValuesBatchError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSUserFeaturesGetValuesBatchErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeaturesGetValuesBatchError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmptyFeaturesList]) {
    jsonDict[@".tag"] = @"empty_features_list";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSUserFeaturesGetValuesBatchError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"empty_features_list"]) {
    return [[DBUSERSUserFeaturesGetValuesBatchError alloc] initWithEmptyFeaturesList];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBUSERSUserFeaturesGetValuesBatchError alloc] initWithOther];
  } else {
    return [[DBUSERSUserFeaturesGetValuesBatchError alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSUserFeatureValue.h"
#import "DBUSERSUserFeaturesGetValuesBatchResult.h"

#pragma mark - API Object

@implementation DBUSERSUserFeaturesGetValuesBatchResult

#pragma mark - Constructors

- (instancetype)initWithValues:(NSArray<DBUSERSUserFeatureValue *> *)values {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](values);

  self = [super init];
  if (self) {
    _values = values;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBUSERSUserFeaturesGetValuesBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBUSERSUserFeaturesGetValuesBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBUSERSUserFeaturesGetValuesBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.values hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFeaturesGetValuesBatchResult:other];
}

- (BOOL)isEqualToUserFeaturesGetValuesBatchResult:
    (DBUSERSUserFeaturesGetValuesBatchResult *)anUserFeaturesGetValuesBatchResult {
  if (self == anUserFeaturesGetValuesBatchResult) {
    return YES;
  }
  if (![self.values isEqual:anUserFeaturesGetValuesBatchResult.values]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBUSERSUserFeaturesGetValuesBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBUSERSUserFeaturesGetValuesBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"values"] = [DBArraySerializer serialize:valueObj.values
                                           withBlock:^id(id elem0) {
                                             return [DBUSERSUserFeatureValueSerializer serialize:elem0];
                                           }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBUSERSUserFeaturesGetValuesBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBUSERSUserFeatureValue *> *values =
      [DBArraySerializer deserialize:valueDict[@"values"]
                           withBlock:^id(id elem0) {
                             return [DBUSERSUserFeatureValueSerializer deserialize:elem0];
                           }];

  return [[DBUSERSUserFeaturesGetValuesBatchResult alloc] initWithValues:values];
}

@end
