///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESSharedFolderMemberPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedFolderMemberPolicy` union.
///
/// Policy governing who can be a member of a folder shared by a team member.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESSharedFolderMemberPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESSharedFolderMemberPolicyTag` enum type represents the
/// possible tag states with which the `DBTEAMPOLICIESSharedFolderMemberPolicy`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESSharedFolderMemberPolicyTag){
    /// Only a teammate can be a member of a folder shared by a team member.
    DBTEAMPOLICIESSharedFolderMemberPolicyTeam,

    /// Anyone can be a member of a folder shared by a team member.
    DBTEAMPOLICIESSharedFolderMemberPolicyAnyone,

    /// (no description).
    DBTEAMPOLICIESSharedFolderMemberPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESSharedFolderMemberPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "team".
///
/// Description of the "team" tag state: Only a teammate can be a member of a
/// folder shared by a team member.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeam;

///
/// Initializes union class with tag state of "anyone".
///
/// Description of the "anyone" tag state: Anyone can be a member of a folder
/// shared by a team member.
///
/// @return An initialized instance.
///
- (instancetype)initWithAnyone;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "team".
///
/// @return Whether the union's current tag state has value "team".
///
- (BOOL)isTeam;

///
/// Retrieves whether the union's current tag state has value "anyone".
///
/// @return Whether the union's current tag state has value "anyone".
///
- (BOOL)isAnyone;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESSharedFolderMemberPolicy`
/// union.
///
@interface DBTEAMPOLICIESSharedFolderMemberPolicySerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESSharedFolderMemberPolicy` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESSharedFolderMemberPolicy`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSharedFolderMemberPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSharedFolderMemberPolicy *)instance;

///
/// Deserializes `DBTEAMPOLICIESSharedFolderMemberPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESSharedFolderMemberPolicy` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESSharedFolderMemberPolicy`
/// object.
///
+ (DBTEAMPOLICIESSharedFolderMemberPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
