///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMPOLICIESPaperEnabledPolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperEnabledPolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMPOLICIESPaperEnabledPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMPOLICIESPaperEnabledPolicyTag` enum type represents the possible
/// tag states with which the `DBTEAMPOLICIESPaperEnabledPolicy` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMPOLICIESPaperEnabledPolicyTag){
    /// Paper is disabled.
    DBTEAMPOLICIESPaperEnabledPolicyDisabled,

    /// Paper is enabled.
    DBTEAMPOLICIESPaperEnabledPolicyEnabled,

    /// Unspecified policy.
    DBTEAMPOLICIESPaperEnabledPolicyUnspecified,

    /// (no description).
    DBTEAMPOLICIESPaperEnabledPolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMPOLICIESPaperEnabledPolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disabled".
///
/// Description of the "disabled" tag state: Paper is disabled.
///
/// @return An initialized instance.
///
- (instancetype)initWithDisabled;

///
/// Initializes union class with tag state of "enabled".
///
/// Description of the "enabled" tag state: Paper is enabled.
///
/// @return An initialized instance.
///
- (instancetype)initWithEnabled;

///
/// Initializes union class with tag state of "unspecified".
///
/// Description of the "unspecified" tag state: Unspecified policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnspecified;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disabled".
///
/// @return Whether the union's current tag state has value "disabled".
///
- (BOOL)isDisabled;

///
/// Retrieves whether the union's current tag state has value "enabled".
///
/// @return Whether the union's current tag state has value "enabled".
///
- (BOOL)isEnabled;

///
/// Retrieves whether the union's current tag state has value "unspecified".
///
/// @return Whether the union's current tag state has value "unspecified".
///
- (BOOL)isUnspecified;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMPOLICIESPaperEnabledPolicy` union.
///
@interface DBTEAMPOLICIESPaperEnabledPolicySerializer : NSObject

///
/// Serializes `DBTEAMPOLICIESPaperEnabledPolicy` instances.
///
/// @param instance An instance of the `DBTEAMPOLICIESPaperEnabledPolicy` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESPaperEnabledPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperEnabledPolicy *)instance;

///
/// Deserializes `DBTEAMPOLICIESPaperEnabledPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMPOLICIESPaperEnabledPolicy` API object.
///
/// @return An instantiation of the `DBTEAMPOLICIESPaperEnabledPolicy` object.
///
+ (DBTEAMPOLICIESPaperEnabledPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
