///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `TeamPolicies` namespace.

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESCameraUploadsPolicyState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESCameraUploadsPolicyState

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESCameraUploadsPolicyStateDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESCameraUploadsPolicyStateEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESCameraUploadsPolicyStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESCameraUploadsPolicyStateDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESCameraUploadsPolicyStateEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESCameraUploadsPolicyStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESCameraUploadsPolicyStateDisabled:
    return @"DBTEAMPOLICIESCameraUploadsPolicyStateDisabled";
  case DBTEAMPOLICIESCameraUploadsPolicyStateEnabled:
    return @"DBTEAMPOLICIESCameraUploadsPolicyStateEnabled";
  case DBTEAMPOLICIESCameraUploadsPolicyStateOther:
    return @"DBTEAMPOLICIESCameraUploadsPolicyStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESCameraUploadsPolicyStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESCameraUploadsPolicyStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESCameraUploadsPolicyStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESCameraUploadsPolicyStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESCameraUploadsPolicyStateEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESCameraUploadsPolicyStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCameraUploadsPolicyState:other];
}

- (BOOL)isEqualToCameraUploadsPolicyState:(DBTEAMPOLICIESCameraUploadsPolicyState *)aCameraUploadsPolicyState {
  if (self == aCameraUploadsPolicyState) {
    return YES;
  }
  if (self.tag != aCameraUploadsPolicyState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESCameraUploadsPolicyStateDisabled:
    return [[self tagName] isEqual:[aCameraUploadsPolicyState tagName]];
  case DBTEAMPOLICIESCameraUploadsPolicyStateEnabled:
    return [[self tagName] isEqual:[aCameraUploadsPolicyState tagName]];
  case DBTEAMPOLICIESCameraUploadsPolicyStateOther:
    return [[self tagName] isEqual:[aCameraUploadsPolicyState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESCameraUploadsPolicyStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESCameraUploadsPolicyState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESCameraUploadsPolicyState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESCameraUploadsPolicyState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESCameraUploadsPolicyState alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESCameraUploadsPolicyState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESCameraUploadsPolicyState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESComputerBackupPolicyState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESComputerBackupPolicyState

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESComputerBackupPolicyStateDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESComputerBackupPolicyStateEnabled;
  }
  return self;
}

- (instancetype)initWithDefault_ {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESComputerBackupPolicyStateDefault_;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESComputerBackupPolicyStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESComputerBackupPolicyStateDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESComputerBackupPolicyStateEnabled;
}

- (BOOL)isDefault_ {
  return _tag == DBTEAMPOLICIESComputerBackupPolicyStateDefault_;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESComputerBackupPolicyStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESComputerBackupPolicyStateDisabled:
    return @"DBTEAMPOLICIESComputerBackupPolicyStateDisabled";
  case DBTEAMPOLICIESComputerBackupPolicyStateEnabled:
    return @"DBTEAMPOLICIESComputerBackupPolicyStateEnabled";
  case DBTEAMPOLICIESComputerBackupPolicyStateDefault_:
    return @"DBTEAMPOLICIESComputerBackupPolicyStateDefault_";
  case DBTEAMPOLICIESComputerBackupPolicyStateOther:
    return @"DBTEAMPOLICIESComputerBackupPolicyStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESComputerBackupPolicyStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESComputerBackupPolicyStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESComputerBackupPolicyStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESComputerBackupPolicyStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESComputerBackupPolicyStateEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESComputerBackupPolicyStateDefault_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESComputerBackupPolicyStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToComputerBackupPolicyState:other];
}

- (BOOL)isEqualToComputerBackupPolicyState:(DBTEAMPOLICIESComputerBackupPolicyState *)aComputerBackupPolicyState {
  if (self == aComputerBackupPolicyState) {
    return YES;
  }
  if (self.tag != aComputerBackupPolicyState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESComputerBackupPolicyStateDisabled:
    return [[self tagName] isEqual:[aComputerBackupPolicyState tagName]];
  case DBTEAMPOLICIESComputerBackupPolicyStateEnabled:
    return [[self tagName] isEqual:[aComputerBackupPolicyState tagName]];
  case DBTEAMPOLICIESComputerBackupPolicyStateDefault_:
    return [[self tagName] isEqual:[aComputerBackupPolicyState tagName]];
  case DBTEAMPOLICIESComputerBackupPolicyStateOther:
    return [[self tagName] isEqual:[aComputerBackupPolicyState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESComputerBackupPolicyStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESComputerBackupPolicyState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isDefault_]) {
    jsonDict[@".tag"] = @"default";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESComputerBackupPolicyState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESComputerBackupPolicyState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESComputerBackupPolicyState alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"default"]) {
    return [[DBTEAMPOLICIESComputerBackupPolicyState alloc] initWithDefault_];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESComputerBackupPolicyState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESComputerBackupPolicyState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESEmmState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESEmmState

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESEmmStateDisabled;
  }
  return self;
}

- (instancetype)initWithOptional {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESEmmStateOptional;
  }
  return self;
}

- (instancetype)initWithRequired {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESEmmStateRequired;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESEmmStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESEmmStateDisabled;
}

- (BOOL)isOptional {
  return _tag == DBTEAMPOLICIESEmmStateOptional;
}

- (BOOL)isRequired {
  return _tag == DBTEAMPOLICIESEmmStateRequired;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESEmmStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESEmmStateDisabled:
    return @"DBTEAMPOLICIESEmmStateDisabled";
  case DBTEAMPOLICIESEmmStateOptional:
    return @"DBTEAMPOLICIESEmmStateOptional";
  case DBTEAMPOLICIESEmmStateRequired:
    return @"DBTEAMPOLICIESEmmStateRequired";
  case DBTEAMPOLICIESEmmStateOther:
    return @"DBTEAMPOLICIESEmmStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESEmmStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESEmmStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESEmmStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESEmmStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESEmmStateOptional:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESEmmStateRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESEmmStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmState:other];
}

- (BOOL)isEqualToEmmState:(DBTEAMPOLICIESEmmState *)anEmmState {
  if (self == anEmmState) {
    return YES;
  }
  if (self.tag != anEmmState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESEmmStateDisabled:
    return [[self tagName] isEqual:[anEmmState tagName]];
  case DBTEAMPOLICIESEmmStateOptional:
    return [[self tagName] isEqual:[anEmmState tagName]];
  case DBTEAMPOLICIESEmmStateRequired:
    return [[self tagName] isEqual:[anEmmState tagName]];
  case DBTEAMPOLICIESEmmStateOther:
    return [[self tagName] isEqual:[anEmmState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESEmmStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESEmmState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isOptional]) {
    jsonDict[@".tag"] = @"optional";
  } else if ([valueObj isRequired]) {
    jsonDict[@".tag"] = @"required";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESEmmState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESEmmState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"optional"]) {
    return [[DBTEAMPOLICIESEmmState alloc] initWithOptional];
  } else if ([tag isEqualToString:@"required"]) {
    return [[DBTEAMPOLICIESEmmState alloc] initWithRequired];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESEmmState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESEmmState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESFileLockingPolicyState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESFileLockingPolicyState

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESFileLockingPolicyStateDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESFileLockingPolicyStateEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESFileLockingPolicyStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESFileLockingPolicyStateDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESFileLockingPolicyStateEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESFileLockingPolicyStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESFileLockingPolicyStateDisabled:
    return @"DBTEAMPOLICIESFileLockingPolicyStateDisabled";
  case DBTEAMPOLICIESFileLockingPolicyStateEnabled:
    return @"DBTEAMPOLICIESFileLockingPolicyStateEnabled";
  case DBTEAMPOLICIESFileLockingPolicyStateOther:
    return @"DBTEAMPOLICIESFileLockingPolicyStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESFileLockingPolicyStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESFileLockingPolicyStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESFileLockingPolicyStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESFileLockingPolicyStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESFileLockingPolicyStateEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESFileLockingPolicyStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLockingPolicyState:other];
}

- (BOOL)isEqualToFileLockingPolicyState:(DBTEAMPOLICIESFileLockingPolicyState *)aFileLockingPolicyState {
  if (self == aFileLockingPolicyState) {
    return YES;
  }
  if (self.tag != aFileLockingPolicyState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESFileLockingPolicyStateDisabled:
    return [[self tagName] isEqual:[aFileLockingPolicyState tagName]];
  case DBTEAMPOLICIESFileLockingPolicyStateEnabled:
    return [[self tagName] isEqual:[aFileLockingPolicyState tagName]];
  case DBTEAMPOLICIESFileLockingPolicyStateOther:
    return [[self tagName] isEqual:[aFileLockingPolicyState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESFileLockingPolicyStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESFileLockingPolicyState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESFileLockingPolicyState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESFileLockingPolicyState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESFileLockingPolicyState alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESFileLockingPolicyState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESFileLockingPolicyState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESGroupCreation.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESGroupCreation

#pragma mark - Constructors

- (instancetype)initWithAdminsAndMembers {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESGroupCreationAdminsAndMembers;
  }
  return self;
}

- (instancetype)initWithAdminsOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESGroupCreationAdminsOnly;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAdminsAndMembers {
  return _tag == DBTEAMPOLICIESGroupCreationAdminsAndMembers;
}

- (BOOL)isAdminsOnly {
  return _tag == DBTEAMPOLICIESGroupCreationAdminsOnly;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESGroupCreationAdminsAndMembers:
    return @"DBTEAMPOLICIESGroupCreationAdminsAndMembers";
  case DBTEAMPOLICIESGroupCreationAdminsOnly:
    return @"DBTEAMPOLICIESGroupCreationAdminsOnly";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESGroupCreationSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESGroupCreationSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESGroupCreationSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESGroupCreationAdminsAndMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESGroupCreationAdminsOnly:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupCreation:other];
}

- (BOOL)isEqualToGroupCreation:(DBTEAMPOLICIESGroupCreation *)aGroupCreation {
  if (self == aGroupCreation) {
    return YES;
  }
  if (self.tag != aGroupCreation.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESGroupCreationAdminsAndMembers:
    return [[self tagName] isEqual:[aGroupCreation tagName]];
  case DBTEAMPOLICIESGroupCreationAdminsOnly:
    return [[self tagName] isEqual:[aGroupCreation tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESGroupCreationSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESGroupCreation *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAdminsAndMembers]) {
    jsonDict[@".tag"] = @"admins_and_members";
  } else if ([valueObj isAdminsOnly]) {
    jsonDict[@".tag"] = @"admins_only";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESGroupCreation *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"admins_and_members"]) {
    return [[DBTEAMPOLICIESGroupCreation alloc] initWithAdminsAndMembers];
  } else if ([tag isEqualToString:@"admins_only"]) {
    return [[DBTEAMPOLICIESGroupCreation alloc] initWithAdminsOnly];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESOfficeAddInPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESOfficeAddInPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESOfficeAddInPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESOfficeAddInPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESOfficeAddInPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESOfficeAddInPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESOfficeAddInPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESOfficeAddInPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESOfficeAddInPolicyDisabled:
    return @"DBTEAMPOLICIESOfficeAddInPolicyDisabled";
  case DBTEAMPOLICIESOfficeAddInPolicyEnabled:
    return @"DBTEAMPOLICIESOfficeAddInPolicyEnabled";
  case DBTEAMPOLICIESOfficeAddInPolicyOther:
    return @"DBTEAMPOLICIESOfficeAddInPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESOfficeAddInPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESOfficeAddInPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESOfficeAddInPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESOfficeAddInPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESOfficeAddInPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESOfficeAddInPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToOfficeAddInPolicy:other];
}

- (BOOL)isEqualToOfficeAddInPolicy:(DBTEAMPOLICIESOfficeAddInPolicy *)anOfficeAddInPolicy {
  if (self == anOfficeAddInPolicy) {
    return YES;
  }
  if (self.tag != anOfficeAddInPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESOfficeAddInPolicyDisabled:
    return [[self tagName] isEqual:[anOfficeAddInPolicy tagName]];
  case DBTEAMPOLICIESOfficeAddInPolicyEnabled:
    return [[self tagName] isEqual:[anOfficeAddInPolicy tagName]];
  case DBTEAMPOLICIESOfficeAddInPolicyOther:
    return [[self tagName] isEqual:[anOfficeAddInPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESOfficeAddInPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESOfficeAddInPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESOfficeAddInPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESOfficeAddInPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESOfficeAddInPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESOfficeAddInPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESOfficeAddInPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPaperDefaultFolderPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPaperDefaultFolderPolicy

#pragma mark - Constructors

- (instancetype)initWithEveryoneInTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam;
  }
  return self;
}

- (instancetype)initWithInviteOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDefaultFolderPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEveryoneInTeam {
  return _tag == DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam;
}

- (BOOL)isInviteOnly {
  return _tag == DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPaperDefaultFolderPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam:
    return @"DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam";
  case DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly:
    return @"DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly";
  case DBTEAMPOLICIESPaperDefaultFolderPolicyOther:
    return @"DBTEAMPOLICIESPaperDefaultFolderPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPaperDefaultFolderPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPaperDefaultFolderPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPaperDefaultFolderPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDefaultFolderPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDefaultFolderPolicy:other];
}

- (BOOL)isEqualToPaperDefaultFolderPolicy:(DBTEAMPOLICIESPaperDefaultFolderPolicy *)aPaperDefaultFolderPolicy {
  if (self == aPaperDefaultFolderPolicy) {
    return YES;
  }
  if (self.tag != aPaperDefaultFolderPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPaperDefaultFolderPolicyEveryoneInTeam:
    return [[self tagName] isEqual:[aPaperDefaultFolderPolicy tagName]];
  case DBTEAMPOLICIESPaperDefaultFolderPolicyInviteOnly:
    return [[self tagName] isEqual:[aPaperDefaultFolderPolicy tagName]];
  case DBTEAMPOLICIESPaperDefaultFolderPolicyOther:
    return [[self tagName] isEqual:[aPaperDefaultFolderPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPaperDefaultFolderPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperDefaultFolderPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEveryoneInTeam]) {
    jsonDict[@".tag"] = @"everyone_in_team";
  } else if ([valueObj isInviteOnly]) {
    jsonDict[@".tag"] = @"invite_only";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPaperDefaultFolderPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"everyone_in_team"]) {
    return [[DBTEAMPOLICIESPaperDefaultFolderPolicy alloc] initWithEveryoneInTeam];
  } else if ([tag isEqualToString:@"invite_only"]) {
    return [[DBTEAMPOLICIESPaperDefaultFolderPolicy alloc] initWithInviteOnly];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPaperDefaultFolderPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPaperDefaultFolderPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPaperDeploymentPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPaperDeploymentPolicy

#pragma mark - Constructors

- (instancetype)initWithFull {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDeploymentPolicyFull;
  }
  return self;
}

- (instancetype)initWithPartial {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDeploymentPolicyPartial;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDeploymentPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFull {
  return _tag == DBTEAMPOLICIESPaperDeploymentPolicyFull;
}

- (BOOL)isPartial {
  return _tag == DBTEAMPOLICIESPaperDeploymentPolicyPartial;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPaperDeploymentPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPaperDeploymentPolicyFull:
    return @"DBTEAMPOLICIESPaperDeploymentPolicyFull";
  case DBTEAMPOLICIESPaperDeploymentPolicyPartial:
    return @"DBTEAMPOLICIESPaperDeploymentPolicyPartial";
  case DBTEAMPOLICIESPaperDeploymentPolicyOther:
    return @"DBTEAMPOLICIESPaperDeploymentPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPaperDeploymentPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPaperDeploymentPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPaperDeploymentPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPaperDeploymentPolicyFull:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDeploymentPolicyPartial:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDeploymentPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDeploymentPolicy:other];
}

- (BOOL)isEqualToPaperDeploymentPolicy:(DBTEAMPOLICIESPaperDeploymentPolicy *)aPaperDeploymentPolicy {
  if (self == aPaperDeploymentPolicy) {
    return YES;
  }
  if (self.tag != aPaperDeploymentPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPaperDeploymentPolicyFull:
    return [[self tagName] isEqual:[aPaperDeploymentPolicy tagName]];
  case DBTEAMPOLICIESPaperDeploymentPolicyPartial:
    return [[self tagName] isEqual:[aPaperDeploymentPolicy tagName]];
  case DBTEAMPOLICIESPaperDeploymentPolicyOther:
    return [[self tagName] isEqual:[aPaperDeploymentPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPaperDeploymentPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperDeploymentPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFull]) {
    jsonDict[@".tag"] = @"full";
  } else if ([valueObj isPartial]) {
    jsonDict[@".tag"] = @"partial";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPaperDeploymentPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"full"]) {
    return [[DBTEAMPOLICIESPaperDeploymentPolicy alloc] initWithFull];
  } else if ([tag isEqualToString:@"partial"]) {
    return [[DBTEAMPOLICIESPaperDeploymentPolicy alloc] initWithPartial];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPaperDeploymentPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPaperDeploymentPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPaperDesktopPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPaperDesktopPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDesktopPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDesktopPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperDesktopPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESPaperDesktopPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESPaperDesktopPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPaperDesktopPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPaperDesktopPolicyDisabled:
    return @"DBTEAMPOLICIESPaperDesktopPolicyDisabled";
  case DBTEAMPOLICIESPaperDesktopPolicyEnabled:
    return @"DBTEAMPOLICIESPaperDesktopPolicyEnabled";
  case DBTEAMPOLICIESPaperDesktopPolicyOther:
    return @"DBTEAMPOLICIESPaperDesktopPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPaperDesktopPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPaperDesktopPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPaperDesktopPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPaperDesktopPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDesktopPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperDesktopPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDesktopPolicy:other];
}

- (BOOL)isEqualToPaperDesktopPolicy:(DBTEAMPOLICIESPaperDesktopPolicy *)aPaperDesktopPolicy {
  if (self == aPaperDesktopPolicy) {
    return YES;
  }
  if (self.tag != aPaperDesktopPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPaperDesktopPolicyDisabled:
    return [[self tagName] isEqual:[aPaperDesktopPolicy tagName]];
  case DBTEAMPOLICIESPaperDesktopPolicyEnabled:
    return [[self tagName] isEqual:[aPaperDesktopPolicy tagName]];
  case DBTEAMPOLICIESPaperDesktopPolicyOther:
    return [[self tagName] isEqual:[aPaperDesktopPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPaperDesktopPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperDesktopPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPaperDesktopPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESPaperDesktopPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESPaperDesktopPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPaperDesktopPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPaperDesktopPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPaperEnabledPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPaperEnabledPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperEnabledPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperEnabledPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithUnspecified {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperEnabledPolicyUnspecified;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPaperEnabledPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESPaperEnabledPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESPaperEnabledPolicyEnabled;
}

- (BOOL)isUnspecified {
  return _tag == DBTEAMPOLICIESPaperEnabledPolicyUnspecified;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPaperEnabledPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPaperEnabledPolicyDisabled:
    return @"DBTEAMPOLICIESPaperEnabledPolicyDisabled";
  case DBTEAMPOLICIESPaperEnabledPolicyEnabled:
    return @"DBTEAMPOLICIESPaperEnabledPolicyEnabled";
  case DBTEAMPOLICIESPaperEnabledPolicyUnspecified:
    return @"DBTEAMPOLICIESPaperEnabledPolicyUnspecified";
  case DBTEAMPOLICIESPaperEnabledPolicyOther:
    return @"DBTEAMPOLICIESPaperEnabledPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPaperEnabledPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPaperEnabledPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPaperEnabledPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPaperEnabledPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperEnabledPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperEnabledPolicyUnspecified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPaperEnabledPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperEnabledPolicy:other];
}

- (BOOL)isEqualToPaperEnabledPolicy:(DBTEAMPOLICIESPaperEnabledPolicy *)aPaperEnabledPolicy {
  if (self == aPaperEnabledPolicy) {
    return YES;
  }
  if (self.tag != aPaperEnabledPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPaperEnabledPolicyDisabled:
    return [[self tagName] isEqual:[aPaperEnabledPolicy tagName]];
  case DBTEAMPOLICIESPaperEnabledPolicyEnabled:
    return [[self tagName] isEqual:[aPaperEnabledPolicy tagName]];
  case DBTEAMPOLICIESPaperEnabledPolicyUnspecified:
    return [[self tagName] isEqual:[aPaperEnabledPolicy tagName]];
  case DBTEAMPOLICIESPaperEnabledPolicyOther:
    return [[self tagName] isEqual:[aPaperEnabledPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPaperEnabledPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPaperEnabledPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isUnspecified]) {
    jsonDict[@".tag"] = @"unspecified";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPaperEnabledPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESPaperEnabledPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESPaperEnabledPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"unspecified"]) {
    return [[DBTEAMPOLICIESPaperEnabledPolicy alloc] initWithUnspecified];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPaperEnabledPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPaperEnabledPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPasswordControlMode.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPasswordControlMode

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordControlModeDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordControlModeEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordControlModeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESPasswordControlModeDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESPasswordControlModeEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPasswordControlModeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPasswordControlModeDisabled:
    return @"DBTEAMPOLICIESPasswordControlModeDisabled";
  case DBTEAMPOLICIESPasswordControlModeEnabled:
    return @"DBTEAMPOLICIESPasswordControlModeEnabled";
  case DBTEAMPOLICIESPasswordControlModeOther:
    return @"DBTEAMPOLICIESPasswordControlModeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPasswordControlModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPasswordControlModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPasswordControlModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPasswordControlModeDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPasswordControlModeEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPasswordControlModeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPasswordControlMode:other];
}

- (BOOL)isEqualToPasswordControlMode:(DBTEAMPOLICIESPasswordControlMode *)aPasswordControlMode {
  if (self == aPasswordControlMode) {
    return YES;
  }
  if (self.tag != aPasswordControlMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPasswordControlModeDisabled:
    return [[self tagName] isEqual:[aPasswordControlMode tagName]];
  case DBTEAMPOLICIESPasswordControlModeEnabled:
    return [[self tagName] isEqual:[aPasswordControlMode tagName]];
  case DBTEAMPOLICIESPasswordControlModeOther:
    return [[self tagName] isEqual:[aPasswordControlMode tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPasswordControlModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPasswordControlMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPasswordControlMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESPasswordControlMode alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESPasswordControlMode alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPasswordControlMode alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPasswordControlMode alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESPasswordStrengthPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESPasswordStrengthPolicy

#pragma mark - Constructors

- (instancetype)initWithMinimalRequirements {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements;
  }
  return self;
}

- (instancetype)initWithModeratePassword {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword;
  }
  return self;
}

- (instancetype)initWithStrongPassword {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESPasswordStrengthPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isMinimalRequirements {
  return _tag == DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements;
}

- (BOOL)isModeratePassword {
  return _tag == DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword;
}

- (BOOL)isStrongPassword {
  return _tag == DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESPasswordStrengthPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements:
    return @"DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements";
  case DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword:
    return @"DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword";
  case DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword:
    return @"DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword";
  case DBTEAMPOLICIESPasswordStrengthPolicyOther:
    return @"DBTEAMPOLICIESPasswordStrengthPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESPasswordStrengthPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESPasswordStrengthPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESPasswordStrengthPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESPasswordStrengthPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPasswordStrengthPolicy:other];
}

- (BOOL)isEqualToPasswordStrengthPolicy:(DBTEAMPOLICIESPasswordStrengthPolicy *)aPasswordStrengthPolicy {
  if (self == aPasswordStrengthPolicy) {
    return YES;
  }
  if (self.tag != aPasswordStrengthPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESPasswordStrengthPolicyMinimalRequirements:
    return [[self tagName] isEqual:[aPasswordStrengthPolicy tagName]];
  case DBTEAMPOLICIESPasswordStrengthPolicyModeratePassword:
    return [[self tagName] isEqual:[aPasswordStrengthPolicy tagName]];
  case DBTEAMPOLICIESPasswordStrengthPolicyStrongPassword:
    return [[self tagName] isEqual:[aPasswordStrengthPolicy tagName]];
  case DBTEAMPOLICIESPasswordStrengthPolicyOther:
    return [[self tagName] isEqual:[aPasswordStrengthPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESPasswordStrengthPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESPasswordStrengthPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMinimalRequirements]) {
    jsonDict[@".tag"] = @"minimal_requirements";
  } else if ([valueObj isModeratePassword]) {
    jsonDict[@".tag"] = @"moderate_password";
  } else if ([valueObj isStrongPassword]) {
    jsonDict[@".tag"] = @"strong_password";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESPasswordStrengthPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"minimal_requirements"]) {
    return [[DBTEAMPOLICIESPasswordStrengthPolicy alloc] initWithMinimalRequirements];
  } else if ([tag isEqualToString:@"moderate_password"]) {
    return [[DBTEAMPOLICIESPasswordStrengthPolicy alloc] initWithModeratePassword];
  } else if ([tag isEqualToString:@"strong_password"]) {
    return [[DBTEAMPOLICIESPasswordStrengthPolicy alloc] initWithStrongPassword];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESPasswordStrengthPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESPasswordStrengthPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESRolloutMethod.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESRolloutMethod

#pragma mark - Constructors

- (instancetype)initWithUnlinkAll {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESRolloutMethodUnlinkAll;
  }
  return self;
}

- (instancetype)initWithUnlinkMostInactive {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESRolloutMethodUnlinkMostInactive;
  }
  return self;
}

- (instancetype)initWithAddMemberToExceptions {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESRolloutMethodAddMemberToExceptions;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isUnlinkAll {
  return _tag == DBTEAMPOLICIESRolloutMethodUnlinkAll;
}

- (BOOL)isUnlinkMostInactive {
  return _tag == DBTEAMPOLICIESRolloutMethodUnlinkMostInactive;
}

- (BOOL)isAddMemberToExceptions {
  return _tag == DBTEAMPOLICIESRolloutMethodAddMemberToExceptions;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESRolloutMethodUnlinkAll:
    return @"DBTEAMPOLICIESRolloutMethodUnlinkAll";
  case DBTEAMPOLICIESRolloutMethodUnlinkMostInactive:
    return @"DBTEAMPOLICIESRolloutMethodUnlinkMostInactive";
  case DBTEAMPOLICIESRolloutMethodAddMemberToExceptions:
    return @"DBTEAMPOLICIESRolloutMethodAddMemberToExceptions";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESRolloutMethodSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESRolloutMethodSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESRolloutMethodSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESRolloutMethodUnlinkAll:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESRolloutMethodUnlinkMostInactive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESRolloutMethodAddMemberToExceptions:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRolloutMethod:other];
}

- (BOOL)isEqualToRolloutMethod:(DBTEAMPOLICIESRolloutMethod *)aRolloutMethod {
  if (self == aRolloutMethod) {
    return YES;
  }
  if (self.tag != aRolloutMethod.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESRolloutMethodUnlinkAll:
    return [[self tagName] isEqual:[aRolloutMethod tagName]];
  case DBTEAMPOLICIESRolloutMethodUnlinkMostInactive:
    return [[self tagName] isEqual:[aRolloutMethod tagName]];
  case DBTEAMPOLICIESRolloutMethodAddMemberToExceptions:
    return [[self tagName] isEqual:[aRolloutMethod tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESRolloutMethodSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESRolloutMethod *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnlinkAll]) {
    jsonDict[@".tag"] = @"unlink_all";
  } else if ([valueObj isUnlinkMostInactive]) {
    jsonDict[@".tag"] = @"unlink_most_inactive";
  } else if ([valueObj isAddMemberToExceptions]) {
    jsonDict[@".tag"] = @"add_member_to_exceptions";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESRolloutMethod *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unlink_all"]) {
    return [[DBTEAMPOLICIESRolloutMethod alloc] initWithUnlinkAll];
  } else if ([tag isEqualToString:@"unlink_most_inactive"]) {
    return [[DBTEAMPOLICIESRolloutMethod alloc] initWithUnlinkMostInactive];
  } else if ([tag isEqualToString:@"add_member_to_exceptions"]) {
    return [[DBTEAMPOLICIESRolloutMethod alloc] initWithAddMemberToExceptions];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSharedFolderJoinPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSharedFolderJoinPolicy

#pragma mark - Constructors

- (instancetype)initWithFromTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly;
  }
  return self;
}

- (instancetype)initWithFromAnyone {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderJoinPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFromTeamOnly {
  return _tag == DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly;
}

- (BOOL)isFromAnyone {
  return _tag == DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSharedFolderJoinPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly:
    return @"DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly";
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone:
    return @"DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone";
  case DBTEAMPOLICIESSharedFolderJoinPolicyOther:
    return @"DBTEAMPOLICIESSharedFolderJoinPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSharedFolderJoinPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSharedFolderJoinPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSharedFolderJoinPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedFolderJoinPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderJoinPolicy:other];
}

- (BOOL)isEqualToSharedFolderJoinPolicy:(DBTEAMPOLICIESSharedFolderJoinPolicy *)aSharedFolderJoinPolicy {
  if (self == aSharedFolderJoinPolicy) {
    return YES;
  }
  if (self.tag != aSharedFolderJoinPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromTeamOnly:
    return [[self tagName] isEqual:[aSharedFolderJoinPolicy tagName]];
  case DBTEAMPOLICIESSharedFolderJoinPolicyFromAnyone:
    return [[self tagName] isEqual:[aSharedFolderJoinPolicy tagName]];
  case DBTEAMPOLICIESSharedFolderJoinPolicyOther:
    return [[self tagName] isEqual:[aSharedFolderJoinPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSharedFolderJoinPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSharedFolderJoinPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFromTeamOnly]) {
    jsonDict[@".tag"] = @"from_team_only";
  } else if ([valueObj isFromAnyone]) {
    jsonDict[@".tag"] = @"from_anyone";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSharedFolderJoinPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"from_team_only"]) {
    return [[DBTEAMPOLICIESSharedFolderJoinPolicy alloc] initWithFromTeamOnly];
  } else if ([tag isEqualToString:@"from_anyone"]) {
    return [[DBTEAMPOLICIESSharedFolderJoinPolicy alloc] initWithFromAnyone];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSharedFolderJoinPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSharedFolderJoinPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSharedFolderMemberPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSharedFolderMemberPolicy

#pragma mark - Constructors

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderMemberPolicyTeam;
  }
  return self;
}

- (instancetype)initWithAnyone {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderMemberPolicyAnyone;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedFolderMemberPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTeam {
  return _tag == DBTEAMPOLICIESSharedFolderMemberPolicyTeam;
}

- (BOOL)isAnyone {
  return _tag == DBTEAMPOLICIESSharedFolderMemberPolicyAnyone;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSharedFolderMemberPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderMemberPolicyTeam:
    return @"DBTEAMPOLICIESSharedFolderMemberPolicyTeam";
  case DBTEAMPOLICIESSharedFolderMemberPolicyAnyone:
    return @"DBTEAMPOLICIESSharedFolderMemberPolicyAnyone";
  case DBTEAMPOLICIESSharedFolderMemberPolicyOther:
    return @"DBTEAMPOLICIESSharedFolderMemberPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSharedFolderMemberPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSharedFolderMemberPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSharedFolderMemberPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderMemberPolicyTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedFolderMemberPolicyAnyone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedFolderMemberPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderMemberPolicy:other];
}

- (BOOL)isEqualToSharedFolderMemberPolicy:(DBTEAMPOLICIESSharedFolderMemberPolicy *)aSharedFolderMemberPolicy {
  if (self == aSharedFolderMemberPolicy) {
    return YES;
  }
  if (self.tag != aSharedFolderMemberPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSharedFolderMemberPolicyTeam:
    return [[self tagName] isEqual:[aSharedFolderMemberPolicy tagName]];
  case DBTEAMPOLICIESSharedFolderMemberPolicyAnyone:
    return [[self tagName] isEqual:[aSharedFolderMemberPolicy tagName]];
  case DBTEAMPOLICIESSharedFolderMemberPolicyOther:
    return [[self tagName] isEqual:[aSharedFolderMemberPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSharedFolderMemberPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSharedFolderMemberPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isAnyone]) {
    jsonDict[@".tag"] = @"anyone";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSharedFolderMemberPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"team"]) {
    return [[DBTEAMPOLICIESSharedFolderMemberPolicy alloc] initWithTeam];
  } else if ([tag isEqualToString:@"anyone"]) {
    return [[DBTEAMPOLICIESSharedFolderMemberPolicy alloc] initWithAnyone];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSharedFolderMemberPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSharedFolderMemberPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSharedLinkCreatePolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSharedLinkCreatePolicy

#pragma mark - Constructors

- (instancetype)initWithDefaultPublic {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic;
  }
  return self;
}

- (instancetype)initWithDefaultTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly;
  }
  return self;
}

- (instancetype)initWithTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSharedLinkCreatePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDefaultPublic {
  return _tag == DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic;
}

- (BOOL)isDefaultTeamOnly {
  return _tag == DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly;
}

- (BOOL)isTeamOnly {
  return _tag == DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSharedLinkCreatePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic:
    return @"DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic";
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly:
    return @"DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly";
  case DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly:
    return @"DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly";
  case DBTEAMPOLICIESSharedLinkCreatePolicyOther:
    return @"DBTEAMPOLICIESSharedLinkCreatePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSharedLinkCreatePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSharedLinkCreatePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSharedLinkCreatePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSharedLinkCreatePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkCreatePolicy:other];
}

- (BOOL)isEqualToSharedLinkCreatePolicy:(DBTEAMPOLICIESSharedLinkCreatePolicy *)aSharedLinkCreatePolicy {
  if (self == aSharedLinkCreatePolicy) {
    return YES;
  }
  if (self.tag != aSharedLinkCreatePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultPublic:
    return [[self tagName] isEqual:[aSharedLinkCreatePolicy tagName]];
  case DBTEAMPOLICIESSharedLinkCreatePolicyDefaultTeamOnly:
    return [[self tagName] isEqual:[aSharedLinkCreatePolicy tagName]];
  case DBTEAMPOLICIESSharedLinkCreatePolicyTeamOnly:
    return [[self tagName] isEqual:[aSharedLinkCreatePolicy tagName]];
  case DBTEAMPOLICIESSharedLinkCreatePolicyOther:
    return [[self tagName] isEqual:[aSharedLinkCreatePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSharedLinkCreatePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSharedLinkCreatePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDefaultPublic]) {
    jsonDict[@".tag"] = @"default_public";
  } else if ([valueObj isDefaultTeamOnly]) {
    jsonDict[@".tag"] = @"default_team_only";
  } else if ([valueObj isTeamOnly]) {
    jsonDict[@".tag"] = @"team_only";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSharedLinkCreatePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"default_public"]) {
    return [[DBTEAMPOLICIESSharedLinkCreatePolicy alloc] initWithDefaultPublic];
  } else if ([tag isEqualToString:@"default_team_only"]) {
    return [[DBTEAMPOLICIESSharedLinkCreatePolicy alloc] initWithDefaultTeamOnly];
  } else if ([tag isEqualToString:@"team_only"]) {
    return [[DBTEAMPOLICIESSharedLinkCreatePolicy alloc] initWithTeamOnly];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSharedLinkCreatePolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSharedLinkCreatePolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESShowcaseDownloadPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESShowcaseDownloadPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseDownloadPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseDownloadPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseDownloadPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESShowcaseDownloadPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESShowcaseDownloadPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESShowcaseDownloadPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseDownloadPolicyDisabled:
    return @"DBTEAMPOLICIESShowcaseDownloadPolicyDisabled";
  case DBTEAMPOLICIESShowcaseDownloadPolicyEnabled:
    return @"DBTEAMPOLICIESShowcaseDownloadPolicyEnabled";
  case DBTEAMPOLICIESShowcaseDownloadPolicyOther:
    return @"DBTEAMPOLICIESShowcaseDownloadPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESShowcaseDownloadPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESShowcaseDownloadPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESShowcaseDownloadPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESShowcaseDownloadPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseDownloadPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseDownloadPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShowcaseDownloadPolicy:other];
}

- (BOOL)isEqualToShowcaseDownloadPolicy:(DBTEAMPOLICIESShowcaseDownloadPolicy *)aShowcaseDownloadPolicy {
  if (self == aShowcaseDownloadPolicy) {
    return YES;
  }
  if (self.tag != aShowcaseDownloadPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseDownloadPolicyDisabled:
    return [[self tagName] isEqual:[aShowcaseDownloadPolicy tagName]];
  case DBTEAMPOLICIESShowcaseDownloadPolicyEnabled:
    return [[self tagName] isEqual:[aShowcaseDownloadPolicy tagName]];
  case DBTEAMPOLICIESShowcaseDownloadPolicyOther:
    return [[self tagName] isEqual:[aShowcaseDownloadPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESShowcaseDownloadPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESShowcaseDownloadPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESShowcaseDownloadPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESShowcaseDownloadPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESShowcaseDownloadPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESShowcaseDownloadPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESShowcaseDownloadPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESShowcaseEnabledPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESShowcaseEnabledPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseEnabledPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseEnabledPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseEnabledPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESShowcaseEnabledPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESShowcaseEnabledPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESShowcaseEnabledPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseEnabledPolicyDisabled:
    return @"DBTEAMPOLICIESShowcaseEnabledPolicyDisabled";
  case DBTEAMPOLICIESShowcaseEnabledPolicyEnabled:
    return @"DBTEAMPOLICIESShowcaseEnabledPolicyEnabled";
  case DBTEAMPOLICIESShowcaseEnabledPolicyOther:
    return @"DBTEAMPOLICIESShowcaseEnabledPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESShowcaseEnabledPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESShowcaseEnabledPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESShowcaseEnabledPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESShowcaseEnabledPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseEnabledPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseEnabledPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShowcaseEnabledPolicy:other];
}

- (BOOL)isEqualToShowcaseEnabledPolicy:(DBTEAMPOLICIESShowcaseEnabledPolicy *)aShowcaseEnabledPolicy {
  if (self == aShowcaseEnabledPolicy) {
    return YES;
  }
  if (self.tag != aShowcaseEnabledPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseEnabledPolicyDisabled:
    return [[self tagName] isEqual:[aShowcaseEnabledPolicy tagName]];
  case DBTEAMPOLICIESShowcaseEnabledPolicyEnabled:
    return [[self tagName] isEqual:[aShowcaseEnabledPolicy tagName]];
  case DBTEAMPOLICIESShowcaseEnabledPolicyOther:
    return [[self tagName] isEqual:[aShowcaseEnabledPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESShowcaseEnabledPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESShowcaseEnabledPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESShowcaseEnabledPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESShowcaseEnabledPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESShowcaseEnabledPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESShowcaseEnabledPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESShowcaseEnabledPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESShowcaseExternalSharingPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESShowcaseExternalSharingPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESShowcaseExternalSharingPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESShowcaseExternalSharingPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled:
    return @"DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled";
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled:
    return @"DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled";
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyOther:
    return @"DBTEAMPOLICIESShowcaseExternalSharingPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESShowcaseExternalSharingPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESShowcaseExternalSharingPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESShowcaseExternalSharingPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShowcaseExternalSharingPolicy:other];
}

- (BOOL)isEqualToShowcaseExternalSharingPolicy:
    (DBTEAMPOLICIESShowcaseExternalSharingPolicy *)aShowcaseExternalSharingPolicy {
  if (self == aShowcaseExternalSharingPolicy) {
    return YES;
  }
  if (self.tag != aShowcaseExternalSharingPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyDisabled:
    return [[self tagName] isEqual:[aShowcaseExternalSharingPolicy tagName]];
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyEnabled:
    return [[self tagName] isEqual:[aShowcaseExternalSharingPolicy tagName]];
  case DBTEAMPOLICIESShowcaseExternalSharingPolicyOther:
    return [[self tagName] isEqual:[aShowcaseExternalSharingPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESShowcaseExternalSharingPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESShowcaseExternalSharingPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESShowcaseExternalSharingPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESShowcaseExternalSharingPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESShowcaseExternalSharingPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESShowcaseExternalSharingPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESShowcaseExternalSharingPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSmartSyncPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSmartSyncPolicy

#pragma mark - Constructors

- (instancetype)initWithLocal {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmartSyncPolicyLocal;
  }
  return self;
}

- (instancetype)initWithOnDemand {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmartSyncPolicyOnDemand;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmartSyncPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isLocal {
  return _tag == DBTEAMPOLICIESSmartSyncPolicyLocal;
}

- (BOOL)isOnDemand {
  return _tag == DBTEAMPOLICIESSmartSyncPolicyOnDemand;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSmartSyncPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSmartSyncPolicyLocal:
    return @"DBTEAMPOLICIESSmartSyncPolicyLocal";
  case DBTEAMPOLICIESSmartSyncPolicyOnDemand:
    return @"DBTEAMPOLICIESSmartSyncPolicyOnDemand";
  case DBTEAMPOLICIESSmartSyncPolicyOther:
    return @"DBTEAMPOLICIESSmartSyncPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSmartSyncPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSmartSyncPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSmartSyncPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSmartSyncPolicyLocal:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSmartSyncPolicyOnDemand:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSmartSyncPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSmartSyncPolicy:other];
}

- (BOOL)isEqualToSmartSyncPolicy:(DBTEAMPOLICIESSmartSyncPolicy *)aSmartSyncPolicy {
  if (self == aSmartSyncPolicy) {
    return YES;
  }
  if (self.tag != aSmartSyncPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSmartSyncPolicyLocal:
    return [[self tagName] isEqual:[aSmartSyncPolicy tagName]];
  case DBTEAMPOLICIESSmartSyncPolicyOnDemand:
    return [[self tagName] isEqual:[aSmartSyncPolicy tagName]];
  case DBTEAMPOLICIESSmartSyncPolicyOther:
    return [[self tagName] isEqual:[aSmartSyncPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSmartSyncPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSmartSyncPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLocal]) {
    jsonDict[@".tag"] = @"local";
  } else if ([valueObj isOnDemand]) {
    jsonDict[@".tag"] = @"on_demand";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSmartSyncPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"local"]) {
    return [[DBTEAMPOLICIESSmartSyncPolicy alloc] initWithLocal];
  } else if ([tag isEqualToString:@"on_demand"]) {
    return [[DBTEAMPOLICIESSmartSyncPolicy alloc] initWithOnDemand];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSmartSyncPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSmartSyncPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSmarterSmartSyncPolicyState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSmarterSmartSyncPolicyState

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled:
    return @"DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled";
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled:
    return @"DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled";
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther:
    return @"DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSmarterSmartSyncPolicyStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSmarterSmartSyncPolicyStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSmarterSmartSyncPolicyStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSmarterSmartSyncPolicyState:other];
}

- (BOOL)isEqualToSmarterSmartSyncPolicyState:(DBTEAMPOLICIESSmarterSmartSyncPolicyState *)aSmarterSmartSyncPolicyState {
  if (self == aSmarterSmartSyncPolicyState) {
    return YES;
  }
  if (self.tag != aSmarterSmartSyncPolicyState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateDisabled:
    return [[self tagName] isEqual:[aSmarterSmartSyncPolicyState tagName]];
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateEnabled:
    return [[self tagName] isEqual:[aSmarterSmartSyncPolicyState tagName]];
  case DBTEAMPOLICIESSmarterSmartSyncPolicyStateOther:
    return [[self tagName] isEqual:[aSmarterSmartSyncPolicyState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSmarterSmartSyncPolicyStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSmarterSmartSyncPolicyState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSmarterSmartSyncPolicyState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESSmarterSmartSyncPolicyState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESSmarterSmartSyncPolicyState alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSmarterSmartSyncPolicyState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSmarterSmartSyncPolicyState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSsoPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSsoPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSsoPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithOptional {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSsoPolicyOptional;
  }
  return self;
}

- (instancetype)initWithRequired {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSsoPolicyRequired;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSsoPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESSsoPolicyDisabled;
}

- (BOOL)isOptional {
  return _tag == DBTEAMPOLICIESSsoPolicyOptional;
}

- (BOOL)isRequired {
  return _tag == DBTEAMPOLICIESSsoPolicyRequired;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSsoPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSsoPolicyDisabled:
    return @"DBTEAMPOLICIESSsoPolicyDisabled";
  case DBTEAMPOLICIESSsoPolicyOptional:
    return @"DBTEAMPOLICIESSsoPolicyOptional";
  case DBTEAMPOLICIESSsoPolicyRequired:
    return @"DBTEAMPOLICIESSsoPolicyRequired";
  case DBTEAMPOLICIESSsoPolicyOther:
    return @"DBTEAMPOLICIESSsoPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSsoPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSsoPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSsoPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSsoPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSsoPolicyOptional:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSsoPolicyRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSsoPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSsoPolicy:other];
}

- (BOOL)isEqualToSsoPolicy:(DBTEAMPOLICIESSsoPolicy *)aSsoPolicy {
  if (self == aSsoPolicy) {
    return YES;
  }
  if (self.tag != aSsoPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSsoPolicyDisabled:
    return [[self tagName] isEqual:[aSsoPolicy tagName]];
  case DBTEAMPOLICIESSsoPolicyOptional:
    return [[self tagName] isEqual:[aSsoPolicy tagName]];
  case DBTEAMPOLICIESSsoPolicyRequired:
    return [[self tagName] isEqual:[aSsoPolicy tagName]];
  case DBTEAMPOLICIESSsoPolicyOther:
    return [[self tagName] isEqual:[aSsoPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSsoPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSsoPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isOptional]) {
    jsonDict[@".tag"] = @"optional";
  } else if ([valueObj isRequired]) {
    jsonDict[@".tag"] = @"required";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSsoPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESSsoPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"optional"]) {
    return [[DBTEAMPOLICIESSsoPolicy alloc] initWithOptional];
  } else if ([tag isEqualToString:@"required"]) {
    return [[DBTEAMPOLICIESSsoPolicy alloc] initWithRequired];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSsoPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSsoPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSuggestMembersPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESSuggestMembersPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSuggestMembersPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSuggestMembersPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESSuggestMembersPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESSuggestMembersPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMPOLICIESSuggestMembersPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESSuggestMembersPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESSuggestMembersPolicyDisabled:
    return @"DBTEAMPOLICIESSuggestMembersPolicyDisabled";
  case DBTEAMPOLICIESSuggestMembersPolicyEnabled:
    return @"DBTEAMPOLICIESSuggestMembersPolicyEnabled";
  case DBTEAMPOLICIESSuggestMembersPolicyOther:
    return @"DBTEAMPOLICIESSuggestMembersPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESSuggestMembersPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESSuggestMembersPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESSuggestMembersPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESSuggestMembersPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSuggestMembersPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESSuggestMembersPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSuggestMembersPolicy:other];
}

- (BOOL)isEqualToSuggestMembersPolicy:(DBTEAMPOLICIESSuggestMembersPolicy *)aSuggestMembersPolicy {
  if (self == aSuggestMembersPolicy) {
    return YES;
  }
  if (self.tag != aSuggestMembersPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESSuggestMembersPolicyDisabled:
    return [[self tagName] isEqual:[aSuggestMembersPolicy tagName]];
  case DBTEAMPOLICIESSuggestMembersPolicyEnabled:
    return [[self tagName] isEqual:[aSuggestMembersPolicy tagName]];
  case DBTEAMPOLICIESSuggestMembersPolicyOther:
    return [[self tagName] isEqual:[aSuggestMembersPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESSuggestMembersPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESSuggestMembersPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESSuggestMembersPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESSuggestMembersPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMPOLICIESSuggestMembersPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESSuggestMembersPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESSuggestMembersPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESEmmState.h"
#import "DBTEAMPOLICIESOfficeAddInPolicy.h"
#import "DBTEAMPOLICIESSuggestMembersPolicy.h"
#import "DBTEAMPOLICIESTeamMemberPolicies.h"
#import "DBTEAMPOLICIESTeamSharingPolicies.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESTeamMemberPolicies

#pragma mark - Constructors

- (instancetype)initWithSharing:(DBTEAMPOLICIESTeamSharingPolicies *)sharing
                       emmState:(DBTEAMPOLICIESEmmState *)emmState
                    officeAddin:(DBTEAMPOLICIESOfficeAddInPolicy *)officeAddin
           suggestMembersPolicy:(DBTEAMPOLICIESSuggestMembersPolicy *)suggestMembersPolicy {
  [DBStoneValidators nonnullValidator:nil](sharing);
  [DBStoneValidators nonnullValidator:nil](emmState);
  [DBStoneValidators nonnullValidator:nil](officeAddin);
  [DBStoneValidators nonnullValidator:nil](suggestMembersPolicy);

  self = [super init];
  if (self) {
    _sharing = sharing;
    _emmState = emmState;
    _officeAddin = officeAddin;
    _suggestMembersPolicy = suggestMembersPolicy;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESTeamMemberPoliciesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESTeamMemberPoliciesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESTeamMemberPoliciesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharing hash];
  result = prime * result + [self.emmState hash];
  result = prime * result + [self.officeAddin hash];
  result = prime * result + [self.suggestMembersPolicy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamMemberPolicies:other];
}

- (BOOL)isEqualToTeamMemberPolicies:(DBTEAMPOLICIESTeamMemberPolicies *)aTeamMemberPolicies {
  if (self == aTeamMemberPolicies) {
    return YES;
  }
  if (![self.sharing isEqual:aTeamMemberPolicies.sharing]) {
    return NO;
  }
  if (![self.emmState isEqual:aTeamMemberPolicies.emmState]) {
    return NO;
  }
  if (![self.officeAddin isEqual:aTeamMemberPolicies.officeAddin]) {
    return NO;
  }
  if (![self.suggestMembersPolicy isEqual:aTeamMemberPolicies.suggestMembersPolicy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESTeamMemberPoliciesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESTeamMemberPolicies *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"sharing"] = [DBTEAMPOLICIESTeamSharingPoliciesSerializer serialize:valueObj.sharing];
  jsonDict[@"emm_state"] = [DBTEAMPOLICIESEmmStateSerializer serialize:valueObj.emmState];
  jsonDict[@"office_addin"] = [DBTEAMPOLICIESOfficeAddInPolicySerializer serialize:valueObj.officeAddin];
  jsonDict[@"suggest_members_policy"] =
      [DBTEAMPOLICIESSuggestMembersPolicySerializer serialize:valueObj.suggestMembersPolicy];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESTeamMemberPolicies *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMPOLICIESTeamSharingPolicies *sharing =
      [DBTEAMPOLICIESTeamSharingPoliciesSerializer deserialize:valueDict[@"sharing"]];
  DBTEAMPOLICIESEmmState *emmState = [DBTEAMPOLICIESEmmStateSerializer deserialize:valueDict[@"emm_state"]];
  DBTEAMPOLICIESOfficeAddInPolicy *officeAddin =
      [DBTEAMPOLICIESOfficeAddInPolicySerializer deserialize:valueDict[@"office_addin"]];
  DBTEAMPOLICIESSuggestMembersPolicy *suggestMembersPolicy =
      [DBTEAMPOLICIESSuggestMembersPolicySerializer deserialize:valueDict[@"suggest_members_policy"]];

  return [[DBTEAMPOLICIESTeamMemberPolicies alloc] initWithSharing:sharing
                                                          emmState:emmState
                                                       officeAddin:officeAddin
                                              suggestMembersPolicy:suggestMembersPolicy];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESSharedFolderJoinPolicy.h"
#import "DBTEAMPOLICIESSharedFolderMemberPolicy.h"
#import "DBTEAMPOLICIESSharedLinkCreatePolicy.h"
#import "DBTEAMPOLICIESTeamSharingPolicies.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESTeamSharingPolicies

#pragma mark - Constructors

- (instancetype)initWithSharedFolderMemberPolicy:(DBTEAMPOLICIESSharedFolderMemberPolicy *)sharedFolderMemberPolicy
                          sharedFolderJoinPolicy:(DBTEAMPOLICIESSharedFolderJoinPolicy *)sharedFolderJoinPolicy
                          sharedLinkCreatePolicy:(DBTEAMPOLICIESSharedLinkCreatePolicy *)sharedLinkCreatePolicy {
  [DBStoneValidators nonnullValidator:nil](sharedFolderMemberPolicy);
  [DBStoneValidators nonnullValidator:nil](sharedFolderJoinPolicy);
  [DBStoneValidators nonnullValidator:nil](sharedLinkCreatePolicy);

  self = [super init];
  if (self) {
    _sharedFolderMemberPolicy = sharedFolderMemberPolicy;
    _sharedFolderJoinPolicy = sharedFolderJoinPolicy;
    _sharedLinkCreatePolicy = sharedLinkCreatePolicy;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESTeamSharingPoliciesSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESTeamSharingPoliciesSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESTeamSharingPoliciesSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderMemberPolicy hash];
  result = prime * result + [self.sharedFolderJoinPolicy hash];
  result = prime * result + [self.sharedLinkCreatePolicy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamSharingPolicies:other];
}

- (BOOL)isEqualToTeamSharingPolicies:(DBTEAMPOLICIESTeamSharingPolicies *)aTeamSharingPolicies {
  if (self == aTeamSharingPolicies) {
    return YES;
  }
  if (![self.sharedFolderMemberPolicy isEqual:aTeamSharingPolicies.sharedFolderMemberPolicy]) {
    return NO;
  }
  if (![self.sharedFolderJoinPolicy isEqual:aTeamSharingPolicies.sharedFolderJoinPolicy]) {
    return NO;
  }
  if (![self.sharedLinkCreatePolicy isEqual:aTeamSharingPolicies.sharedLinkCreatePolicy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESTeamSharingPoliciesSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESTeamSharingPolicies *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_member_policy"] =
      [DBTEAMPOLICIESSharedFolderMemberPolicySerializer serialize:valueObj.sharedFolderMemberPolicy];
  jsonDict[@"shared_folder_join_policy"] =
      [DBTEAMPOLICIESSharedFolderJoinPolicySerializer serialize:valueObj.sharedFolderJoinPolicy];
  jsonDict[@"shared_link_create_policy"] =
      [DBTEAMPOLICIESSharedLinkCreatePolicySerializer serialize:valueObj.sharedLinkCreatePolicy];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESTeamSharingPolicies *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMPOLICIESSharedFolderMemberPolicy *sharedFolderMemberPolicy =
      [DBTEAMPOLICIESSharedFolderMemberPolicySerializer deserialize:valueDict[@"shared_folder_member_policy"]];
  DBTEAMPOLICIESSharedFolderJoinPolicy *sharedFolderJoinPolicy =
      [DBTEAMPOLICIESSharedFolderJoinPolicySerializer deserialize:valueDict[@"shared_folder_join_policy"]];
  DBTEAMPOLICIESSharedLinkCreatePolicy *sharedLinkCreatePolicy =
      [DBTEAMPOLICIESSharedLinkCreatePolicySerializer deserialize:valueDict[@"shared_link_create_policy"]];

  return [[DBTEAMPOLICIESTeamSharingPolicies alloc] initWithSharedFolderMemberPolicy:sharedFolderMemberPolicy
                                                              sharedFolderJoinPolicy:sharedFolderJoinPolicy
                                                              sharedLinkCreatePolicy:sharedLinkCreatePolicy];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESTwoStepVerificationPolicy.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESTwoStepVerificationPolicy

#pragma mark - Constructors

- (instancetype)initWithRequireTfaEnable {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable;
  }
  return self;
}

- (instancetype)initWithRequireTfaDisable {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isRequireTfaEnable {
  return _tag == DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable;
}

- (BOOL)isRequireTfaDisable {
  return _tag == DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESTwoStepVerificationPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable:
    return @"DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable";
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable:
    return @"DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable";
  case DBTEAMPOLICIESTwoStepVerificationPolicyOther:
    return @"DBTEAMPOLICIESTwoStepVerificationPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESTwoStepVerificationPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESTwoStepVerificationPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESTwoStepVerificationPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESTwoStepVerificationPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTwoStepVerificationPolicy:other];
}

- (BOOL)isEqualToTwoStepVerificationPolicy:(DBTEAMPOLICIESTwoStepVerificationPolicy *)aTwoStepVerificationPolicy {
  if (self == aTwoStepVerificationPolicy) {
    return YES;
  }
  if (self.tag != aTwoStepVerificationPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaEnable:
    return [[self tagName] isEqual:[aTwoStepVerificationPolicy tagName]];
  case DBTEAMPOLICIESTwoStepVerificationPolicyRequireTfaDisable:
    return [[self tagName] isEqual:[aTwoStepVerificationPolicy tagName]];
  case DBTEAMPOLICIESTwoStepVerificationPolicyOther:
    return [[self tagName] isEqual:[aTwoStepVerificationPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESTwoStepVerificationPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESTwoStepVerificationPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRequireTfaEnable]) {
    jsonDict[@".tag"] = @"require_tfa_enable";
  } else if ([valueObj isRequireTfaDisable]) {
    jsonDict[@".tag"] = @"require_tfa_disable";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESTwoStepVerificationPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"require_tfa_enable"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationPolicy alloc] initWithRequireTfaEnable];
  } else if ([tag isEqualToString:@"require_tfa_disable"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationPolicy alloc] initWithRequireTfaDisable];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESTwoStepVerificationPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMPOLICIESTwoStepVerificationState.h"

#pragma mark - API Object

@implementation DBTEAMPOLICIESTwoStepVerificationState

#pragma mark - Constructors

- (instancetype)initWithRequired {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationStateRequired;
  }
  return self;
}

- (instancetype)initWithOptional {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationStateOptional;
  }
  return self;
}

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationStateDisabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMPOLICIESTwoStepVerificationStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isRequired {
  return _tag == DBTEAMPOLICIESTwoStepVerificationStateRequired;
}

- (BOOL)isOptional {
  return _tag == DBTEAMPOLICIESTwoStepVerificationStateOptional;
}

- (BOOL)isDisabled {
  return _tag == DBTEAMPOLICIESTwoStepVerificationStateDisabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMPOLICIESTwoStepVerificationStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationStateRequired:
    return @"DBTEAMPOLICIESTwoStepVerificationStateRequired";
  case DBTEAMPOLICIESTwoStepVerificationStateOptional:
    return @"DBTEAMPOLICIESTwoStepVerificationStateOptional";
  case DBTEAMPOLICIESTwoStepVerificationStateDisabled:
    return @"DBTEAMPOLICIESTwoStepVerificationStateDisabled";
  case DBTEAMPOLICIESTwoStepVerificationStateOther:
    return @"DBTEAMPOLICIESTwoStepVerificationStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMPOLICIESTwoStepVerificationStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMPOLICIESTwoStepVerificationStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMPOLICIESTwoStepVerificationStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationStateRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESTwoStepVerificationStateOptional:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESTwoStepVerificationStateDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMPOLICIESTwoStepVerificationStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTwoStepVerificationState:other];
}

- (BOOL)isEqualToTwoStepVerificationState:(DBTEAMPOLICIESTwoStepVerificationState *)aTwoStepVerificationState {
  if (self == aTwoStepVerificationState) {
    return YES;
  }
  if (self.tag != aTwoStepVerificationState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMPOLICIESTwoStepVerificationStateRequired:
    return [[self tagName] isEqual:[aTwoStepVerificationState tagName]];
  case DBTEAMPOLICIESTwoStepVerificationStateOptional:
    return [[self tagName] isEqual:[aTwoStepVerificationState tagName]];
  case DBTEAMPOLICIESTwoStepVerificationStateDisabled:
    return [[self tagName] isEqual:[aTwoStepVerificationState tagName]];
  case DBTEAMPOLICIESTwoStepVerificationStateOther:
    return [[self tagName] isEqual:[aTwoStepVerificationState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMPOLICIESTwoStepVerificationStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMPOLICIESTwoStepVerificationState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRequired]) {
    jsonDict[@".tag"] = @"required";
  } else if ([valueObj isOptional]) {
    jsonDict[@".tag"] = @"optional";
  } else if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMPOLICIESTwoStepVerificationState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"required"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationState alloc] initWithRequired];
  } else if ([tag isEqualToString:@"optional"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationState alloc] initWithOptional];
  } else if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationState alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMPOLICIESTwoStepVerificationState alloc] initWithOther];
  } else {
    return [[DBTEAMPOLICIESTwoStepVerificationState alloc] initWithOther];
  }
}

@end
