///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPrimaryTeamRequestCanceledDetails;
@class DBTEAMLOGSecondaryTeamRequestCanceledDetails;
@class DBTEAMLOGTeamMergeRequestCanceledExtraDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `TeamMergeRequestCanceledExtraDetails` union.
///
/// Team merge request cancellation details
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGTeamMergeRequestCanceledExtraDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGTeamMergeRequestCanceledExtraDetailsTag` enum type represents
/// the possible tag states with which the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGTeamMergeRequestCanceledExtraDetailsTag){
    /// Team merge request cancellation details shown to the primary team.
    DBTEAMLOGTeamMergeRequestCanceledExtraDetailsPrimaryTeam,

    /// Team merge request cancellation details shown to the secondary team.
    DBTEAMLOGTeamMergeRequestCanceledExtraDetailsSecondaryTeam,

    /// (no description).
    DBTEAMLOGTeamMergeRequestCanceledExtraDetailsOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGTeamMergeRequestCanceledExtraDetailsTag tag;

/// Team merge request cancellation details shown to the primary team. @note
/// Ensure the `isPrimaryTeam` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGPrimaryTeamRequestCanceledDetails *primaryTeam;

/// Team merge request cancellation details shown to the secondary team. @note
/// Ensure the `isSecondaryTeam` method returns true before accessing, otherwise
/// a runtime exception will be raised.
@property (nonatomic, readonly) DBTEAMLOGSecondaryTeamRequestCanceledDetails *secondaryTeam;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "primary_team".
///
/// Description of the "primary_team" tag state: Team merge request cancellation
/// details shown to the primary team.
///
/// @param primaryTeam Team merge request cancellation details shown to the
/// primary team.
///
/// @return An initialized instance.
///
- (instancetype)initWithPrimaryTeam:(DBTEAMLOGPrimaryTeamRequestCanceledDetails *)primaryTeam;

///
/// Initializes union class with tag state of "secondary_team".
///
/// Description of the "secondary_team" tag state: Team merge request
/// cancellation details shown to the secondary team.
///
/// @param secondaryTeam Team merge request cancellation details shown to the
/// secondary team.
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryTeam:(DBTEAMLOGSecondaryTeamRequestCanceledDetails *)secondaryTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "primary_team".
///
/// @note Call this method and ensure it returns true before accessing the
/// `primaryTeam` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "primary_team".
///
- (BOOL)isPrimaryTeam;

///
/// Retrieves whether the union's current tag state has value "secondary_team".
///
/// @note Call this method and ensure it returns true before accessing the
/// `secondaryTeam` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "secondary_team".
///
- (BOOL)isSecondaryTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` union.
///
@interface DBTEAMLOGTeamMergeRequestCanceledExtraDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGTeamMergeRequestCanceledExtraDetails *)instance;

///
/// Deserializes `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGTeamMergeRequestCanceledExtraDetails` object.
///
+ (DBTEAMLOGTeamMergeRequestCanceledExtraDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
