///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGSfTeamJoinFromOobLinkDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SfTeamJoinFromOobLinkDetails` struct.
///
/// Joined team member's shared folder from link.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGSfTeamJoinFromOobLinkDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Target asset position in the Assets list.
@property (nonatomic, readonly) NSNumber *targetAssetIndex;

/// Original shared folder name.
@property (nonatomic, readonly, copy) NSString *originalFolderName;

/// Shared link token key.
@property (nonatomic, readonly, copy, nullable) NSString *tokenKey;

/// Sharing permission.
@property (nonatomic, readonly, copy, nullable) NSString *sharingPermission;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param targetAssetIndex Target asset position in the Assets list.
/// @param originalFolderName Original shared folder name.
/// @param tokenKey Shared link token key.
/// @param sharingPermission Sharing permission.
///
/// @return An initialized instance.
///
- (instancetype)initWithTargetAssetIndex:(NSNumber *)targetAssetIndex
                      originalFolderName:(NSString *)originalFolderName
                                tokenKey:(nullable NSString *)tokenKey
                       sharingPermission:(nullable NSString *)sharingPermission;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param targetAssetIndex Target asset position in the Assets list.
/// @param originalFolderName Original shared folder name.
///
/// @return An initialized instance.
///
- (instancetype)initWithTargetAssetIndex:(NSNumber *)targetAssetIndex originalFolderName:(NSString *)originalFolderName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SfTeamJoinFromOobLinkDetails` struct.
///
@interface DBTEAMLOGSfTeamJoinFromOobLinkDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGSfTeamJoinFromOobLinkDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGSfTeamJoinFromOobLinkDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGSfTeamJoinFromOobLinkDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSfTeamJoinFromOobLinkDetails *)instance;

///
/// Deserializes `DBTEAMLOGSfTeamJoinFromOobLinkDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGSfTeamJoinFromOobLinkDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGSfTeamJoinFromOobLinkDetails`
/// object.
///
+ (DBTEAMLOGSfTeamJoinFromOobLinkDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
