///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPrimaryTeamRequestCanceledDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PrimaryTeamRequestCanceledDetails` struct.
///
/// Team merge request cancellation details shown to the primary team
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPrimaryTeamRequestCanceledDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The secondary team name.
@property (nonatomic, readonly, copy) NSString *secondaryTeam;

/// The name of the secondary team admin who sent the request originally.
@property (nonatomic, readonly, copy) NSString *sentBy;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param secondaryTeam The secondary team name.
/// @param sentBy The name of the secondary team admin who sent the request
/// originally.
///
/// @return An initialized instance.
///
- (instancetype)initWithSecondaryTeam:(NSString *)secondaryTeam sentBy:(NSString *)sentBy;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PrimaryTeamRequestCanceledDetails` struct.
///
@interface DBTEAMLOGPrimaryTeamRequestCanceledDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGPrimaryTeamRequestCanceledDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGPrimaryTeamRequestCanceledDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPrimaryTeamRequestCanceledDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPrimaryTeamRequestCanceledDetails *)instance;

///
/// Deserializes `DBTEAMLOGPrimaryTeamRequestCanceledDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPrimaryTeamRequestCanceledDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGPrimaryTeamRequestCanceledDetails`
/// object.
///
+ (DBTEAMLOGPrimaryTeamRequestCanceledDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
