///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PolicyType` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPolicyType : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGPolicyTypeTag` enum type represents the possible tag states
/// with which the `DBTEAMLOGPolicyType` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGPolicyTypeTag){
    /// (no description).
    DBTEAMLOGPolicyTypeDisposition,

    /// (no description).
    DBTEAMLOGPolicyTypeRetention,

    /// (no description).
    DBTEAMLOGPolicyTypeOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGPolicyTypeTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "disposition".
///
/// @return An initialized instance.
///
- (instancetype)initWithDisposition;

///
/// Initializes union class with tag state of "retention".
///
/// @return An initialized instance.
///
- (instancetype)initWithRetention;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "disposition".
///
/// @return Whether the union's current tag state has value "disposition".
///
- (BOOL)isDisposition;

///
/// Retrieves whether the union's current tag state has value "retention".
///
/// @return Whether the union's current tag state has value "retention".
///
- (BOOL)isRetention;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGPolicyType` union.
///
@interface DBTEAMLOGPolicyTypeSerializer : NSObject

///
/// Serializes `DBTEAMLOGPolicyType` instances.
///
/// @param instance An instance of the `DBTEAMLOGPolicyType` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPolicyType` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPolicyType *)instance;

///
/// Deserializes `DBTEAMLOGPolicyType` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPolicyType` API object.
///
/// @return An instantiation of the `DBTEAMLOGPolicyType` object.
///
+ (DBTEAMLOGPolicyType *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
