///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGNamespaceRelativePathLogInfo;
@class DBTEAMLOGPathLogInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PathLogInfo` struct.
///
/// Path's details.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGPathLogInfo : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Fully qualified path relative to event's context.
@property (nonatomic, readonly, copy, nullable) NSString *contextual;

/// Path relative to the namespace containing the content.
@property (nonatomic, readonly) DBTEAMLOGNamespaceRelativePathLogInfo *namespaceRelative;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param namespaceRelative Path relative to the namespace containing the
/// content.
/// @param contextual Fully qualified path relative to event's context.
///
/// @return An initialized instance.
///
- (instancetype)initWithNamespaceRelative:(DBTEAMLOGNamespaceRelativePathLogInfo *)namespaceRelative
                               contextual:(nullable NSString *)contextual;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param namespaceRelative Path relative to the namespace containing the
/// content.
///
/// @return An initialized instance.
///
- (instancetype)initWithNamespaceRelative:(DBTEAMLOGNamespaceRelativePathLogInfo *)namespaceRelative;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `PathLogInfo` struct.
///
@interface DBTEAMLOGPathLogInfoSerializer : NSObject

///
/// Serializes `DBTEAMLOGPathLogInfo` instances.
///
/// @param instance An instance of the `DBTEAMLOGPathLogInfo` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGPathLogInfo` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGPathLogInfo *)instance;

///
/// Deserializes `DBTEAMLOGPathLogInfo` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGPathLogInfo` API object.
///
/// @return An instantiation of the `DBTEAMLOGPathLogInfo` object.
///
+ (DBTEAMLOGPathLogInfo *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
