///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGMemberChangeResellerRoleDetails;
@class DBTEAMLOGResellerRole;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberChangeResellerRoleDetails` struct.
///
/// Changed team member reseller role.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGMemberChangeResellerRoleDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New reseller role. This field is relevant when the reseller role is changed.
@property (nonatomic, readonly) DBTEAMLOGResellerRole *dNewValue;

/// Previous reseller role. This field is relevant when the reseller role is
/// changed or when the reseller role is removed.
@property (nonatomic, readonly) DBTEAMLOGResellerRole *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New reseller role. This field is relevant when the reseller
/// role is changed.
/// @param previousValue Previous reseller role. This field is relevant when the
/// reseller role is changed or when the reseller role is removed.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(DBTEAMLOGResellerRole *)dNewValue
                    previousValue:(DBTEAMLOGResellerRole *)previousValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberChangeResellerRoleDetails` struct.
///
@interface DBTEAMLOGMemberChangeResellerRoleDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGMemberChangeResellerRoleDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGMemberChangeResellerRoleDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeResellerRoleDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGMemberChangeResellerRoleDetails *)instance;

///
/// Deserializes `DBTEAMLOGMemberChangeResellerRoleDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGMemberChangeResellerRoleDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGMemberChangeResellerRoleDetails`
/// object.
///
+ (DBTEAMLOGMemberChangeResellerRoleDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
