///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGLegalHoldsExportAHoldDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsExportAHoldDetails` struct.
///
/// Exported hold.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGLegalHoldsExportAHoldDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Hold ID.
@property (nonatomic, readonly, copy) NSString *legalHoldId;

/// Hold name.
@property (nonatomic, readonly, copy) NSString *name;

/// Export name.
@property (nonatomic, readonly, copy, nullable) NSString *exportName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
/// @param exportName Export name.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId
                               name:(NSString *)name
                         exportName:(nullable NSString *)exportName;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param legalHoldId Hold ID.
/// @param name Hold name.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldId:(NSString *)legalHoldId name:(NSString *)name;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldsExportAHoldDetails` struct.
///
@interface DBTEAMLOGLegalHoldsExportAHoldDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGLegalHoldsExportAHoldDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGLegalHoldsExportAHoldDetails`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsExportAHoldDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGLegalHoldsExportAHoldDetails *)instance;

///
/// Deserializes `DBTEAMLOGLegalHoldsExportAHoldDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGLegalHoldsExportAHoldDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGLegalHoldsExportAHoldDetails`
/// object.
///
+ (DBTEAMLOGLegalHoldsExportAHoldDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
