///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGovernancePolicyExportCreatedDetails;
@class DBTEAMLOGPolicyType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GovernancePolicyExportCreatedDetails` struct.
///
/// Created a policy download.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGovernancePolicyExportCreatedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Policy ID.
@property (nonatomic, readonly, copy) NSString *governancePolicyId;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// Policy type.
@property (nonatomic, readonly, nullable) DBTEAMLOGPolicyType *policyType;

/// Export name.
@property (nonatomic, readonly, copy) NSString *exportName;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param exportName Export name.
/// @param policyType Policy type.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                exportName:(NSString *)exportName
                                policyType:(nullable DBTEAMLOGPolicyType *)policyType;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param governancePolicyId Policy ID.
/// @param name Policy name.
/// @param exportName Export name.
///
/// @return An initialized instance.
///
- (instancetype)initWithGovernancePolicyId:(NSString *)governancePolicyId
                                      name:(NSString *)name
                                exportName:(NSString *)exportName;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GovernancePolicyExportCreatedDetails`
/// struct.
///
@interface DBTEAMLOGGovernancePolicyExportCreatedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGGovernancePolicyExportCreatedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGGovernancePolicyExportCreatedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyExportCreatedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGovernancePolicyExportCreatedDetails *)instance;

///
/// Deserializes `DBTEAMLOGGovernancePolicyExportCreatedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGovernancePolicyExportCreatedDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGGovernancePolicyExportCreatedDetails` object.
///
+ (DBTEAMLOGGovernancePolicyExportCreatedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
