///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGGetTeamEventsError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GetTeamEventsError` union.
///
/// Errors that can be raised when calling `getEvents`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGGetTeamEventsError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGGetTeamEventsErrorTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGGetTeamEventsError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGGetTeamEventsErrorTag){
    /// No user found matching the provided account_id.
    DBTEAMLOGGetTeamEventsErrorAccountIdNotFound,

    /// Invalid time range.
    DBTEAMLOGGetTeamEventsErrorInvalidTimeRange,

    /// Invalid filters. Do not specify both event_type and category parameters
    /// for the same call.
    DBTEAMLOGGetTeamEventsErrorInvalidFilters,

    /// (no description).
    DBTEAMLOGGetTeamEventsErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGGetTeamEventsErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "account_id_not_found".
///
/// Description of the "account_id_not_found" tag state: No user found matching
/// the provided account_id.
///
/// @return An initialized instance.
///
- (instancetype)initWithAccountIdNotFound;

///
/// Initializes union class with tag state of "invalid_time_range".
///
/// Description of the "invalid_time_range" tag state: Invalid time range.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidTimeRange;

///
/// Initializes union class with tag state of "invalid_filters".
///
/// Description of the "invalid_filters" tag state: Invalid filters. Do not
/// specify both event_type and category parameters for the same call.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidFilters;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "account_id_not_found".
///
/// @return Whether the union's current tag state has value
/// "account_id_not_found".
///
- (BOOL)isAccountIdNotFound;

///
/// Retrieves whether the union's current tag state has value
/// "invalid_time_range".
///
/// @return Whether the union's current tag state has value
/// "invalid_time_range".
///
- (BOOL)isInvalidTimeRange;

///
/// Retrieves whether the union's current tag state has value "invalid_filters".
///
/// @return Whether the union's current tag state has value "invalid_filters".
///
- (BOOL)isInvalidFilters;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGGetTeamEventsError` union.
///
@interface DBTEAMLOGGetTeamEventsErrorSerializer : NSObject

///
/// Serializes `DBTEAMLOGGetTeamEventsError` instances.
///
/// @param instance An instance of the `DBTEAMLOGGetTeamEventsError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGGetTeamEventsError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGGetTeamEventsError *)instance;

///
/// Deserializes `DBTEAMLOGGetTeamEventsError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGGetTeamEventsError` API object.
///
/// @return An instantiation of the `DBTEAMLOGGetTeamEventsError` object.
///
+ (DBTEAMLOGGetTeamEventsError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
