///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFileRequestCreateDetails;
@class DBTEAMLOGFileRequestDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FileRequestCreateDetails` struct.
///
/// Created file request.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFileRequestCreateDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// File request id. Might be missing due to historical data gap.
@property (nonatomic, readonly, copy, nullable) NSString *fileRequestId;

/// File request details. Might be missing due to historical data gap.
@property (nonatomic, readonly, nullable) DBTEAMLOGFileRequestDetails *requestDetails;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param fileRequestId File request id. Might be missing due to historical
/// data gap.
/// @param requestDetails File request details. Might be missing due to
/// historical data gap.
///
/// @return An initialized instance.
///
- (instancetype)initWithFileRequestId:(nullable NSString *)fileRequestId
                       requestDetails:(nullable DBTEAMLOGFileRequestDetails *)requestDetails;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
///
/// @return An initialized instance.
///
- (instancetype)initDefault;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `FileRequestCreateDetails` struct.
///
@interface DBTEAMLOGFileRequestCreateDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGFileRequestCreateDetails` instances.
///
/// @param instance An instance of the `DBTEAMLOGFileRequestCreateDetails` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFileRequestCreateDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFileRequestCreateDetails *)instance;

///
/// Deserializes `DBTEAMLOGFileRequestCreateDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFileRequestCreateDetails` API object.
///
/// @return An instantiation of the `DBTEAMLOGFileRequestCreateDetails` object.
///
+ (DBTEAMLOGFileRequestCreateDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
