///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGFedHandshakeAction;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `FedHandshakeAction` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGFedHandshakeAction : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGFedHandshakeActionTag` enum type represents the possible tag
/// states with which the `DBTEAMLOGFedHandshakeAction` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGFedHandshakeActionTag){
    /// (no description).
    DBTEAMLOGFedHandshakeActionAcceptedInvite,

    /// (no description).
    DBTEAMLOGFedHandshakeActionCanceledInvite,

    /// (no description).
    DBTEAMLOGFedHandshakeActionInviteExpired,

    /// (no description).
    DBTEAMLOGFedHandshakeActionInvited,

    /// (no description).
    DBTEAMLOGFedHandshakeActionRejectedInvite,

    /// (no description).
    DBTEAMLOGFedHandshakeActionRemovedTeam,

    /// (no description).
    DBTEAMLOGFedHandshakeActionOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGFedHandshakeActionTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "accepted_invite".
///
/// @return An initialized instance.
///
- (instancetype)initWithAcceptedInvite;

///
/// Initializes union class with tag state of "canceled_invite".
///
/// @return An initialized instance.
///
- (instancetype)initWithCanceledInvite;

///
/// Initializes union class with tag state of "invite_expired".
///
/// @return An initialized instance.
///
- (instancetype)initWithInviteExpired;

///
/// Initializes union class with tag state of "invited".
///
/// @return An initialized instance.
///
- (instancetype)initWithInvited;

///
/// Initializes union class with tag state of "rejected_invite".
///
/// @return An initialized instance.
///
- (instancetype)initWithRejectedInvite;

///
/// Initializes union class with tag state of "removed_team".
///
/// @return An initialized instance.
///
- (instancetype)initWithRemovedTeam;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "accepted_invite".
///
/// @return Whether the union's current tag state has value "accepted_invite".
///
- (BOOL)isAcceptedInvite;

///
/// Retrieves whether the union's current tag state has value "canceled_invite".
///
/// @return Whether the union's current tag state has value "canceled_invite".
///
- (BOOL)isCanceledInvite;

///
/// Retrieves whether the union's current tag state has value "invite_expired".
///
/// @return Whether the union's current tag state has value "invite_expired".
///
- (BOOL)isInviteExpired;

///
/// Retrieves whether the union's current tag state has value "invited".
///
/// @return Whether the union's current tag state has value "invited".
///
- (BOOL)isInvited;

///
/// Retrieves whether the union's current tag state has value "rejected_invite".
///
/// @return Whether the union's current tag state has value "rejected_invite".
///
- (BOOL)isRejectedInvite;

///
/// Retrieves whether the union's current tag state has value "removed_team".
///
/// @return Whether the union's current tag state has value "removed_team".
///
- (BOOL)isRemovedTeam;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGFedHandshakeAction` union.
///
@interface DBTEAMLOGFedHandshakeActionSerializer : NSObject

///
/// Serializes `DBTEAMLOGFedHandshakeAction` instances.
///
/// @param instance An instance of the `DBTEAMLOGFedHandshakeAction` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGFedHandshakeAction` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGFedHandshakeAction *)instance;

///
/// Deserializes `DBTEAMLOGFedHandshakeAction` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGFedHandshakeAction` API object.
///
/// @return An instantiation of the `DBTEAMLOGFedHandshakeAction` object.
///
+ (DBTEAMLOGFedHandshakeAction *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
