///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGDomainInvitesEmailExistingUsersDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DomainInvitesEmailExistingUsersDetails` struct.
///
/// Sent domain invites to existing domain accounts.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGDomainInvitesEmailExistingUsersDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Domain names.
@property (nonatomic, readonly, copy) NSString *domainName;

/// Number of recipients.
@property (nonatomic, readonly) NSNumber *numRecipients;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param domainName Domain names.
/// @param numRecipients Number of recipients.
///
/// @return An initialized instance.
///
- (instancetype)initWithDomainName:(NSString *)domainName numRecipients:(NSNumber *)numRecipients;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DomainInvitesEmailExistingUsersDetails`
/// struct.
///
@interface DBTEAMLOGDomainInvitesEmailExistingUsersDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)instance;

///
/// Deserializes `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGDomainInvitesEmailExistingUsersDetails` object.
///
+ (DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
