///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGContentAdministrationPolicyChangedDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ContentAdministrationPolicyChangedDetails` struct.
///
/// Changed content management setting.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGContentAdministrationPolicyChangedDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// New content administration policy.
@property (nonatomic, readonly, copy) NSString *dNewValue;

/// Previous content administration policy.
@property (nonatomic, readonly, copy) NSString *previousValue;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param dNewValue New content administration policy.
/// @param previousValue Previous content administration policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithDNewValue:(NSString *)dNewValue previousValue:(NSString *)previousValue;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ContentAdministrationPolicyChangedDetails`
/// struct.
///
@interface DBTEAMLOGContentAdministrationPolicyChangedDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGContentAdministrationPolicyChangedDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGContentAdministrationPolicyChangedDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGContentAdministrationPolicyChangedDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGContentAdministrationPolicyChangedDetails *)instance;

///
/// Deserializes `DBTEAMLOGContentAdministrationPolicyChangedDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGContentAdministrationPolicyChangedDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGContentAdministrationPolicyChangedDetails` object.
///
+ (DBTEAMLOGContentAdministrationPolicyChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
