///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertCategoryEnum;
@class DBTEAMLOGAdminAlertSeverityEnum;
@class DBTEAMLOGAdminAlertingTriggeredAlertDetails;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertingTriggeredAlertDetails` struct.
///
/// Triggered security alert.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertingTriggeredAlertDetails : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Alert name.
@property (nonatomic, readonly, copy) NSString *alertName;

/// Alert severity.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertSeverityEnum *alertSeverity;

/// Alert category.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertCategoryEnum *alertCategory;

/// Alert ID.
@property (nonatomic, readonly, copy) NSString *alertInstanceId;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param alertName Alert name.
/// @param alertSeverity Alert severity.
/// @param alertCategory Alert category.
/// @param alertInstanceId Alert ID.
///
/// @return An initialized instance.
///
- (instancetype)initWithAlertName:(NSString *)alertName
                    alertSeverity:(DBTEAMLOGAdminAlertSeverityEnum *)alertSeverity
                    alertCategory:(DBTEAMLOGAdminAlertCategoryEnum *)alertCategory
                  alertInstanceId:(NSString *)alertInstanceId;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `AdminAlertingTriggeredAlertDetails` struct.
///
@interface DBTEAMLOGAdminAlertingTriggeredAlertDetailsSerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertingTriggeredAlertDetails` instances.
///
/// @param instance An instance of the
/// `DBTEAMLOGAdminAlertingTriggeredAlertDetails` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingTriggeredAlertDetails` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingTriggeredAlertDetails *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertingTriggeredAlertDetails` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingTriggeredAlertDetails` API object.
///
/// @return An instantiation of the
/// `DBTEAMLOGAdminAlertingTriggeredAlertDetails` object.
///
+ (DBTEAMLOGAdminAlertingTriggeredAlertDetails *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
