///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLOGAdminAlertingAlertSensitivity;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AdminAlertingAlertSensitivity` union.
///
/// Alert sensitivity
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLOGAdminAlertingAlertSensitivity : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLOGAdminAlertingAlertSensitivityTag` enum type represents the
/// possible tag states with which the `DBTEAMLOGAdminAlertingAlertSensitivity`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLOGAdminAlertingAlertSensitivityTag){
    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityHigh,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityHighest,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityInvalid,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityLow,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityLowest,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityMedium,

    /// (no description).
    DBTEAMLOGAdminAlertingAlertSensitivityOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLOGAdminAlertingAlertSensitivityTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "high".
///
/// @return An initialized instance.
///
- (instancetype)initWithHigh;

///
/// Initializes union class with tag state of "highest".
///
/// @return An initialized instance.
///
- (instancetype)initWithHighest;

///
/// Initializes union class with tag state of "invalid".
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalid;

///
/// Initializes union class with tag state of "low".
///
/// @return An initialized instance.
///
- (instancetype)initWithLow;

///
/// Initializes union class with tag state of "lowest".
///
/// @return An initialized instance.
///
- (instancetype)initWithLowest;

///
/// Initializes union class with tag state of "medium".
///
/// @return An initialized instance.
///
- (instancetype)initWithMedium;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "high".
///
/// @return Whether the union's current tag state has value "high".
///
- (BOOL)isHigh;

///
/// Retrieves whether the union's current tag state has value "highest".
///
/// @return Whether the union's current tag state has value "highest".
///
- (BOOL)isHighest;

///
/// Retrieves whether the union's current tag state has value "invalid".
///
/// @return Whether the union's current tag state has value "invalid".
///
- (BOOL)isInvalid;

///
/// Retrieves whether the union's current tag state has value "low".
///
/// @return Whether the union's current tag state has value "low".
///
- (BOOL)isLow;

///
/// Retrieves whether the union's current tag state has value "lowest".
///
/// @return Whether the union's current tag state has value "lowest".
///
- (BOOL)isLowest;

///
/// Retrieves whether the union's current tag state has value "medium".
///
/// @return Whether the union's current tag state has value "medium".
///
- (BOOL)isMedium;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLOGAdminAlertingAlertSensitivity`
/// union.
///
@interface DBTEAMLOGAdminAlertingAlertSensitivitySerializer : NSObject

///
/// Serializes `DBTEAMLOGAdminAlertingAlertSensitivity` instances.
///
/// @param instance An instance of the `DBTEAMLOGAdminAlertingAlertSensitivity`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertSensitivity` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertSensitivity *)instance;

///
/// Deserializes `DBTEAMLOGAdminAlertingAlertSensitivity` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLOGAdminAlertingAlertSensitivity` API object.
///
/// @return An instantiation of the `DBTEAMLOGAdminAlertingAlertSensitivity`
/// object.
///
+ (DBTEAMLOGAdminAlertingAlertSensitivity *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
