///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `TeamLog` namespace.

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccessMethodLogInfo.h"
#import "DBTEAMLOGApiSessionLogInfo.h"
#import "DBTEAMLOGSessionLogInfo.h"
#import "DBTEAMLOGWebSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccessMethodLogInfo

@synthesize adminConsole = _adminConsole;
@synthesize api = _api;
@synthesize contentManager = _contentManager;
@synthesize endUser = _endUser;
@synthesize enterpriseConsole = _enterpriseConsole;
@synthesize signInAs = _signInAs;

#pragma mark - Constructors

- (instancetype)initWithAdminConsole:(DBTEAMLOGWebSessionLogInfo *)adminConsole {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoAdminConsole;
    _adminConsole = adminConsole;
  }
  return self;
}

- (instancetype)initWithApi:(DBTEAMLOGApiSessionLogInfo *)api {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoApi;
    _api = api;
  }
  return self;
}

- (instancetype)initWithContentManager:(DBTEAMLOGWebSessionLogInfo *)contentManager {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoContentManager;
    _contentManager = contentManager;
  }
  return self;
}

- (instancetype)initWithEndUser:(DBTEAMLOGSessionLogInfo *)endUser {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoEndUser;
    _endUser = endUser;
  }
  return self;
}

- (instancetype)initWithEnterpriseConsole:(DBTEAMLOGWebSessionLogInfo *)enterpriseConsole {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoEnterpriseConsole;
    _enterpriseConsole = enterpriseConsole;
  }
  return self;
}

- (instancetype)initWithSignInAs:(DBTEAMLOGWebSessionLogInfo *)signInAs {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoSignInAs;
    _signInAs = signInAs;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccessMethodLogInfoOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGWebSessionLogInfo *)adminConsole {
  if (![self isAdminConsole]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoAdminConsole, but was %@.", [self tagName]];
  }
  return _adminConsole;
}

- (DBTEAMLOGApiSessionLogInfo *)api {
  if (![self isApi]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoApi, but was %@.", [self tagName]];
  }
  return _api;
}

- (DBTEAMLOGWebSessionLogInfo *)contentManager {
  if (![self isContentManager]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoContentManager, but was %@.", [self tagName]];
  }
  return _contentManager;
}

- (DBTEAMLOGSessionLogInfo *)endUser {
  if (![self isEndUser]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoEndUser, but was %@.", [self tagName]];
  }
  return _endUser;
}

- (DBTEAMLOGWebSessionLogInfo *)enterpriseConsole {
  if (![self isEnterpriseConsole]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoEnterpriseConsole, but was %@.", [self tagName]];
  }
  return _enterpriseConsole;
}

- (DBTEAMLOGWebSessionLogInfo *)signInAs {
  if (![self isSignInAs]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAccessMethodLogInfoSignInAs, but was %@.", [self tagName]];
  }
  return _signInAs;
}

#pragma mark - Tag state methods

- (BOOL)isAdminConsole {
  return _tag == DBTEAMLOGAccessMethodLogInfoAdminConsole;
}

- (BOOL)isApi {
  return _tag == DBTEAMLOGAccessMethodLogInfoApi;
}

- (BOOL)isContentManager {
  return _tag == DBTEAMLOGAccessMethodLogInfoContentManager;
}

- (BOOL)isEndUser {
  return _tag == DBTEAMLOGAccessMethodLogInfoEndUser;
}

- (BOOL)isEnterpriseConsole {
  return _tag == DBTEAMLOGAccessMethodLogInfoEnterpriseConsole;
}

- (BOOL)isSignInAs {
  return _tag == DBTEAMLOGAccessMethodLogInfoSignInAs;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAccessMethodLogInfoOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAccessMethodLogInfoAdminConsole:
    return @"DBTEAMLOGAccessMethodLogInfoAdminConsole";
  case DBTEAMLOGAccessMethodLogInfoApi:
    return @"DBTEAMLOGAccessMethodLogInfoApi";
  case DBTEAMLOGAccessMethodLogInfoContentManager:
    return @"DBTEAMLOGAccessMethodLogInfoContentManager";
  case DBTEAMLOGAccessMethodLogInfoEndUser:
    return @"DBTEAMLOGAccessMethodLogInfoEndUser";
  case DBTEAMLOGAccessMethodLogInfoEnterpriseConsole:
    return @"DBTEAMLOGAccessMethodLogInfoEnterpriseConsole";
  case DBTEAMLOGAccessMethodLogInfoSignInAs:
    return @"DBTEAMLOGAccessMethodLogInfoSignInAs";
  case DBTEAMLOGAccessMethodLogInfoOther:
    return @"DBTEAMLOGAccessMethodLogInfoOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccessMethodLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccessMethodLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccessMethodLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAccessMethodLogInfoAdminConsole:
    result = prime * result + [self.adminConsole hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoApi:
    result = prime * result + [self.api hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoContentManager:
    result = prime * result + [self.contentManager hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoEndUser:
    result = prime * result + [self.endUser hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoEnterpriseConsole:
    result = prime * result + [self.enterpriseConsole hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoSignInAs:
    result = prime * result + [self.signInAs hash];
    break;
  case DBTEAMLOGAccessMethodLogInfoOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccessMethodLogInfo:other];
}

- (BOOL)isEqualToAccessMethodLogInfo:(DBTEAMLOGAccessMethodLogInfo *)anAccessMethodLogInfo {
  if (self == anAccessMethodLogInfo) {
    return YES;
  }
  if (self.tag != anAccessMethodLogInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAccessMethodLogInfoAdminConsole:
    return [self.adminConsole isEqual:anAccessMethodLogInfo.adminConsole];
  case DBTEAMLOGAccessMethodLogInfoApi:
    return [self.api isEqual:anAccessMethodLogInfo.api];
  case DBTEAMLOGAccessMethodLogInfoContentManager:
    return [self.contentManager isEqual:anAccessMethodLogInfo.contentManager];
  case DBTEAMLOGAccessMethodLogInfoEndUser:
    return [self.endUser isEqual:anAccessMethodLogInfo.endUser];
  case DBTEAMLOGAccessMethodLogInfoEnterpriseConsole:
    return [self.enterpriseConsole isEqual:anAccessMethodLogInfo.enterpriseConsole];
  case DBTEAMLOGAccessMethodLogInfoSignInAs:
    return [self.signInAs isEqual:anAccessMethodLogInfo.signInAs];
  case DBTEAMLOGAccessMethodLogInfoOther:
    return [[self tagName] isEqual:[anAccessMethodLogInfo tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccessMethodLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccessMethodLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAdminConsole]) {
    jsonDict = [[DBTEAMLOGWebSessionLogInfoSerializer serialize:valueObj.adminConsole] mutableCopy];
    jsonDict[@".tag"] = @"admin_console";
  } else if ([valueObj isApi]) {
    jsonDict = [[DBTEAMLOGApiSessionLogInfoSerializer serialize:valueObj.api] mutableCopy];
    jsonDict[@".tag"] = @"api";
  } else if ([valueObj isContentManager]) {
    jsonDict = [[DBTEAMLOGWebSessionLogInfoSerializer serialize:valueObj.contentManager] mutableCopy];
    jsonDict[@".tag"] = @"content_manager";
  } else if ([valueObj isEndUser]) {
    jsonDict[@"end_user"] = [[DBTEAMLOGSessionLogInfoSerializer serialize:valueObj.endUser] mutableCopy];
    jsonDict[@".tag"] = @"end_user";
  } else if ([valueObj isEnterpriseConsole]) {
    jsonDict = [[DBTEAMLOGWebSessionLogInfoSerializer serialize:valueObj.enterpriseConsole] mutableCopy];
    jsonDict[@".tag"] = @"enterprise_console";
  } else if ([valueObj isSignInAs]) {
    jsonDict = [[DBTEAMLOGWebSessionLogInfoSerializer serialize:valueObj.signInAs] mutableCopy];
    jsonDict[@".tag"] = @"sign_in_as";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccessMethodLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"admin_console"]) {
    DBTEAMLOGWebSessionLogInfo *adminConsole = [DBTEAMLOGWebSessionLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithAdminConsole:adminConsole];
  } else if ([tag isEqualToString:@"api"]) {
    DBTEAMLOGApiSessionLogInfo *api = [DBTEAMLOGApiSessionLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithApi:api];
  } else if ([tag isEqualToString:@"content_manager"]) {
    DBTEAMLOGWebSessionLogInfo *contentManager = [DBTEAMLOGWebSessionLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithContentManager:contentManager];
  } else if ([tag isEqualToString:@"end_user"]) {
    DBTEAMLOGSessionLogInfo *endUser = [DBTEAMLOGSessionLogInfoSerializer deserialize:valueDict[@"end_user"]];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithEndUser:endUser];
  } else if ([tag isEqualToString:@"enterprise_console"]) {
    DBTEAMLOGWebSessionLogInfo *enterpriseConsole = [DBTEAMLOGWebSessionLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithEnterpriseConsole:enterpriseConsole];
  } else if ([tag isEqualToString:@"sign_in_as"]) {
    DBTEAMLOGWebSessionLogInfo *signInAs = [DBTEAMLOGWebSessionLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithSignInAs:signInAs];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAccessMethodLogInfo alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureAvailability.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureAvailability

#pragma mark - Constructors

- (instancetype)initWithAvailable {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureAvailabilityAvailable;
  }
  return self;
}

- (instancetype)initWithUnavailable {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureAvailabilityUnavailable;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureAvailabilityOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAvailable {
  return _tag == DBTEAMLOGAccountCaptureAvailabilityAvailable;
}

- (BOOL)isUnavailable {
  return _tag == DBTEAMLOGAccountCaptureAvailabilityUnavailable;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAccountCaptureAvailabilityOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAccountCaptureAvailabilityAvailable:
    return @"DBTEAMLOGAccountCaptureAvailabilityAvailable";
  case DBTEAMLOGAccountCaptureAvailabilityUnavailable:
    return @"DBTEAMLOGAccountCaptureAvailabilityUnavailable";
  case DBTEAMLOGAccountCaptureAvailabilityOther:
    return @"DBTEAMLOGAccountCaptureAvailabilityOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureAvailabilitySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureAvailabilitySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureAvailabilitySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAccountCaptureAvailabilityAvailable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCaptureAvailabilityUnavailable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCaptureAvailabilityOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureAvailability:other];
}

- (BOOL)isEqualToAccountCaptureAvailability:(DBTEAMLOGAccountCaptureAvailability *)anAccountCaptureAvailability {
  if (self == anAccountCaptureAvailability) {
    return YES;
  }
  if (self.tag != anAccountCaptureAvailability.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAccountCaptureAvailabilityAvailable:
    return [[self tagName] isEqual:[anAccountCaptureAvailability tagName]];
  case DBTEAMLOGAccountCaptureAvailabilityUnavailable:
    return [[self tagName] isEqual:[anAccountCaptureAvailability tagName]];
  case DBTEAMLOGAccountCaptureAvailabilityOther:
    return [[self tagName] isEqual:[anAccountCaptureAvailability tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureAvailabilitySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureAvailability *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAvailable]) {
    jsonDict[@".tag"] = @"available";
  } else if ([valueObj isUnavailable]) {
    jsonDict[@".tag"] = @"unavailable";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureAvailability *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"available"]) {
    return [[DBTEAMLOGAccountCaptureAvailability alloc] initWithAvailable];
  } else if ([tag isEqualToString:@"unavailable"]) {
    return [[DBTEAMLOGAccountCaptureAvailability alloc] initWithUnavailable];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAccountCaptureAvailability alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAccountCaptureAvailability alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureAvailability.h"
#import "DBTEAMLOGAccountCaptureChangeAvailabilityDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureChangeAvailabilityDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGAccountCaptureAvailability *)dNewValue
                    previousValue:(DBTEAMLOGAccountCaptureAvailability *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initWithDNewValue:(DBTEAMLOGAccountCaptureAvailability *)dNewValue {
  return [self initWithDNewValue:dNewValue previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureChangeAvailabilityDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureChangeAvailabilityDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureChangeAvailabilityDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureChangeAvailabilityDetails:other];
}

- (BOOL)isEqualToAccountCaptureChangeAvailabilityDetails:
    (DBTEAMLOGAccountCaptureChangeAvailabilityDetails *)anAccountCaptureChangeAvailabilityDetails {
  if (self == anAccountCaptureChangeAvailabilityDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:anAccountCaptureChangeAvailabilityDetails.dNewValue]) {
    return NO;
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:anAccountCaptureChangeAvailabilityDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureChangeAvailabilityDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureChangeAvailabilityDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = [DBTEAMLOGAccountCaptureAvailabilitySerializer serialize:valueObj.dNewValue];
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMLOGAccountCaptureAvailabilitySerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureChangeAvailabilityDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAccountCaptureAvailability *dNewValue =
      [DBTEAMLOGAccountCaptureAvailabilitySerializer deserialize:valueDict[@"new_value"]];
  DBTEAMLOGAccountCaptureAvailability *previousValue =
      valueDict[@"previous_value"]
          ? [DBTEAMLOGAccountCaptureAvailabilitySerializer deserialize:valueDict[@"previous_value"]]
          : nil;

  return [[DBTEAMLOGAccountCaptureChangeAvailabilityDetails alloc] initWithDNewValue:dNewValue
                                                                       previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureChangeAvailabilityType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureChangeAvailabilityType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureChangeAvailabilityTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureChangeAvailabilityTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureChangeAvailabilityTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureChangeAvailabilityType:other];
}

- (BOOL)isEqualToAccountCaptureChangeAvailabilityType:
    (DBTEAMLOGAccountCaptureChangeAvailabilityType *)anAccountCaptureChangeAvailabilityType {
  if (self == anAccountCaptureChangeAvailabilityType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountCaptureChangeAvailabilityType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureChangeAvailabilityTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureChangeAvailabilityType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureChangeAvailabilityType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountCaptureChangeAvailabilityType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureChangePolicyDetails.h"
#import "DBTEAMLOGAccountCapturePolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureChangePolicyDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGAccountCapturePolicy *)dNewValue
                    previousValue:(DBTEAMLOGAccountCapturePolicy *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initWithDNewValue:(DBTEAMLOGAccountCapturePolicy *)dNewValue {
  return [self initWithDNewValue:dNewValue previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureChangePolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureChangePolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureChangePolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureChangePolicyDetails:other];
}

- (BOOL)isEqualToAccountCaptureChangePolicyDetails:
    (DBTEAMLOGAccountCaptureChangePolicyDetails *)anAccountCaptureChangePolicyDetails {
  if (self == anAccountCaptureChangePolicyDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:anAccountCaptureChangePolicyDetails.dNewValue]) {
    return NO;
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:anAccountCaptureChangePolicyDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureChangePolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureChangePolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = [DBTEAMLOGAccountCapturePolicySerializer serialize:valueObj.dNewValue];
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMLOGAccountCapturePolicySerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAccountCapturePolicy *dNewValue =
      [DBTEAMLOGAccountCapturePolicySerializer deserialize:valueDict[@"new_value"]];
  DBTEAMLOGAccountCapturePolicy *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMLOGAccountCapturePolicySerializer deserialize:valueDict[@"previous_value"]]
                                   : nil;

  return [[DBTEAMLOGAccountCaptureChangePolicyDetails alloc] initWithDNewValue:dNewValue previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureChangePolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureChangePolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureChangePolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureChangePolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureChangePolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureChangePolicyType:other];
}

- (BOOL)isEqualToAccountCaptureChangePolicyType:
    (DBTEAMLOGAccountCaptureChangePolicyType *)anAccountCaptureChangePolicyType {
  if (self == anAccountCaptureChangePolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountCaptureChangePolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureChangePolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureChangePolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureChangePolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountCaptureChangePolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureMigrateAccountDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureMigrateAccountDetails

#pragma mark - Constructors

- (instancetype)initWithDomainName:(NSString *)domainName {
  [DBStoneValidators nonnullValidator:nil](domainName);

  self = [super init];
  if (self) {
    _domainName = domainName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureMigrateAccountDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureMigrateAccountDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureMigrateAccountDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureMigrateAccountDetails:other];
}

- (BOOL)isEqualToAccountCaptureMigrateAccountDetails:
    (DBTEAMLOGAccountCaptureMigrateAccountDetails *)anAccountCaptureMigrateAccountDetails {
  if (self == anAccountCaptureMigrateAccountDetails) {
    return YES;
  }
  if (![self.domainName isEqual:anAccountCaptureMigrateAccountDetails.domainName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureMigrateAccountDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureMigrateAccountDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_name"] = valueObj.domainName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureMigrateAccountDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *domainName = valueDict[@"domain_name"];

  return [[DBTEAMLOGAccountCaptureMigrateAccountDetails alloc] initWithDomainName:domainName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureMigrateAccountType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureMigrateAccountType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureMigrateAccountTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureMigrateAccountTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureMigrateAccountTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureMigrateAccountType:other];
}

- (BOOL)isEqualToAccountCaptureMigrateAccountType:
    (DBTEAMLOGAccountCaptureMigrateAccountType *)anAccountCaptureMigrateAccountType {
  if (self == anAccountCaptureMigrateAccountType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountCaptureMigrateAccountType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureMigrateAccountTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureMigrateAccountType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureMigrateAccountType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountCaptureMigrateAccountType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureNotificationEmailsSentDetails.h"
#import "DBTEAMLOGAccountCaptureNotificationType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureNotificationEmailsSentDetails

#pragma mark - Constructors

- (instancetype)initWithDomainName:(NSString *)domainName
                  notificationType:(DBTEAMLOGAccountCaptureNotificationType *)notificationType {
  [DBStoneValidators nonnullValidator:nil](domainName);

  self = [super init];
  if (self) {
    _domainName = domainName;
    _notificationType = notificationType;
  }
  return self;
}

- (instancetype)initWithDomainName:(NSString *)domainName {
  return [self initWithDomainName:domainName notificationType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureNotificationEmailsSentDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureNotificationEmailsSentDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureNotificationEmailsSentDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainName hash];
  if (self.notificationType != nil) {
    result = prime * result + [self.notificationType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureNotificationEmailsSentDetails:other];
}

- (BOOL)isEqualToAccountCaptureNotificationEmailsSentDetails:
    (DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)anAccountCaptureNotificationEmailsSentDetails {
  if (self == anAccountCaptureNotificationEmailsSentDetails) {
    return YES;
  }
  if (![self.domainName isEqual:anAccountCaptureNotificationEmailsSentDetails.domainName]) {
    return NO;
  }
  if (self.notificationType) {
    if (![self.notificationType isEqual:anAccountCaptureNotificationEmailsSentDetails.notificationType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureNotificationEmailsSentDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_name"] = valueObj.domainName;
  if (valueObj.notificationType) {
    jsonDict[@"notification_type"] =
        [DBTEAMLOGAccountCaptureNotificationTypeSerializer serialize:valueObj.notificationType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *domainName = valueDict[@"domain_name"];
  DBTEAMLOGAccountCaptureNotificationType *notificationType =
      valueDict[@"notification_type"]
          ? [DBTEAMLOGAccountCaptureNotificationTypeSerializer deserialize:valueDict[@"notification_type"]]
          : nil;

  return [[DBTEAMLOGAccountCaptureNotificationEmailsSentDetails alloc] initWithDomainName:domainName
                                                                         notificationType:notificationType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureNotificationEmailsSentType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureNotificationEmailsSentType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureNotificationEmailsSentTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureNotificationEmailsSentTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureNotificationEmailsSentTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureNotificationEmailsSentType:other];
}

- (BOOL)isEqualToAccountCaptureNotificationEmailsSentType:
    (DBTEAMLOGAccountCaptureNotificationEmailsSentType *)anAccountCaptureNotificationEmailsSentType {
  if (self == anAccountCaptureNotificationEmailsSentType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountCaptureNotificationEmailsSentType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureNotificationEmailsSentTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureNotificationEmailsSentType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureNotificationEmailsSentType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountCaptureNotificationEmailsSentType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureNotificationType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureNotificationType

#pragma mark - Constructors

- (instancetype)initWithActionableNotification {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureNotificationTypeActionableNotification;
  }
  return self;
}

- (instancetype)initWithProactiveWarningNotification {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCaptureNotificationTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isActionableNotification {
  return _tag == DBTEAMLOGAccountCaptureNotificationTypeActionableNotification;
}

- (BOOL)isProactiveWarningNotification {
  return _tag == DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAccountCaptureNotificationTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAccountCaptureNotificationTypeActionableNotification:
    return @"DBTEAMLOGAccountCaptureNotificationTypeActionableNotification";
  case DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification:
    return @"DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification";
  case DBTEAMLOGAccountCaptureNotificationTypeOther:
    return @"DBTEAMLOGAccountCaptureNotificationTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureNotificationTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureNotificationTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureNotificationTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAccountCaptureNotificationTypeActionableNotification:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCaptureNotificationTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureNotificationType:other];
}

- (BOOL)isEqualToAccountCaptureNotificationType:
    (DBTEAMLOGAccountCaptureNotificationType *)anAccountCaptureNotificationType {
  if (self == anAccountCaptureNotificationType) {
    return YES;
  }
  if (self.tag != anAccountCaptureNotificationType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAccountCaptureNotificationTypeActionableNotification:
    return [[self tagName] isEqual:[anAccountCaptureNotificationType tagName]];
  case DBTEAMLOGAccountCaptureNotificationTypeProactiveWarningNotification:
    return [[self tagName] isEqual:[anAccountCaptureNotificationType tagName]];
  case DBTEAMLOGAccountCaptureNotificationTypeOther:
    return [[self tagName] isEqual:[anAccountCaptureNotificationType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureNotificationTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureNotificationType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isActionableNotification]) {
    jsonDict[@".tag"] = @"actionable_notification";
  } else if ([valueObj isProactiveWarningNotification]) {
    jsonDict[@".tag"] = @"proactive_warning_notification";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureNotificationType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"actionable_notification"]) {
    return [[DBTEAMLOGAccountCaptureNotificationType alloc] initWithActionableNotification];
  } else if ([tag isEqualToString:@"proactive_warning_notification"]) {
    return [[DBTEAMLOGAccountCaptureNotificationType alloc] initWithProactiveWarningNotification];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAccountCaptureNotificationType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAccountCaptureNotificationType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCapturePolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCapturePolicy

#pragma mark - Constructors

- (instancetype)initWithAllUsers {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCapturePolicyAllUsers;
  }
  return self;
}

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCapturePolicyDisabled;
  }
  return self;
}

- (instancetype)initWithInvitedUsers {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCapturePolicyInvitedUsers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountCapturePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAllUsers {
  return _tag == DBTEAMLOGAccountCapturePolicyAllUsers;
}

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGAccountCapturePolicyDisabled;
}

- (BOOL)isInvitedUsers {
  return _tag == DBTEAMLOGAccountCapturePolicyInvitedUsers;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAccountCapturePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAccountCapturePolicyAllUsers:
    return @"DBTEAMLOGAccountCapturePolicyAllUsers";
  case DBTEAMLOGAccountCapturePolicyDisabled:
    return @"DBTEAMLOGAccountCapturePolicyDisabled";
  case DBTEAMLOGAccountCapturePolicyInvitedUsers:
    return @"DBTEAMLOGAccountCapturePolicyInvitedUsers";
  case DBTEAMLOGAccountCapturePolicyOther:
    return @"DBTEAMLOGAccountCapturePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCapturePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCapturePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCapturePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAccountCapturePolicyAllUsers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCapturePolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCapturePolicyInvitedUsers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountCapturePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCapturePolicy:other];
}

- (BOOL)isEqualToAccountCapturePolicy:(DBTEAMLOGAccountCapturePolicy *)anAccountCapturePolicy {
  if (self == anAccountCapturePolicy) {
    return YES;
  }
  if (self.tag != anAccountCapturePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAccountCapturePolicyAllUsers:
    return [[self tagName] isEqual:[anAccountCapturePolicy tagName]];
  case DBTEAMLOGAccountCapturePolicyDisabled:
    return [[self tagName] isEqual:[anAccountCapturePolicy tagName]];
  case DBTEAMLOGAccountCapturePolicyInvitedUsers:
    return [[self tagName] isEqual:[anAccountCapturePolicy tagName]];
  case DBTEAMLOGAccountCapturePolicyOther:
    return [[self tagName] isEqual:[anAccountCapturePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCapturePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCapturePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAllUsers]) {
    jsonDict[@".tag"] = @"all_users";
  } else if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isInvitedUsers]) {
    jsonDict[@".tag"] = @"invited_users";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCapturePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"all_users"]) {
    return [[DBTEAMLOGAccountCapturePolicy alloc] initWithAllUsers];
  } else if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGAccountCapturePolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"invited_users"]) {
    return [[DBTEAMLOGAccountCapturePolicy alloc] initWithInvitedUsers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAccountCapturePolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAccountCapturePolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureRelinquishAccountDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureRelinquishAccountDetails

#pragma mark - Constructors

- (instancetype)initWithDomainName:(NSString *)domainName {
  [DBStoneValidators nonnullValidator:nil](domainName);

  self = [super init];
  if (self) {
    _domainName = domainName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureRelinquishAccountDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureRelinquishAccountDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureRelinquishAccountDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureRelinquishAccountDetails:other];
}

- (BOOL)isEqualToAccountCaptureRelinquishAccountDetails:
    (DBTEAMLOGAccountCaptureRelinquishAccountDetails *)anAccountCaptureRelinquishAccountDetails {
  if (self == anAccountCaptureRelinquishAccountDetails) {
    return YES;
  }
  if (![self.domainName isEqual:anAccountCaptureRelinquishAccountDetails.domainName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureRelinquishAccountDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureRelinquishAccountDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_name"] = valueObj.domainName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureRelinquishAccountDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *domainName = valueDict[@"domain_name"];

  return [[DBTEAMLOGAccountCaptureRelinquishAccountDetails alloc] initWithDomainName:domainName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureRelinquishAccountType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountCaptureRelinquishAccountType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountCaptureRelinquishAccountTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountCaptureRelinquishAccountTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountCaptureRelinquishAccountTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountCaptureRelinquishAccountType:other];
}

- (BOOL)isEqualToAccountCaptureRelinquishAccountType:
    (DBTEAMLOGAccountCaptureRelinquishAccountType *)anAccountCaptureRelinquishAccountType {
  if (self == anAccountCaptureRelinquishAccountType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountCaptureRelinquishAccountType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountCaptureRelinquishAccountTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountCaptureRelinquishAccountType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountCaptureRelinquishAccountType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountCaptureRelinquishAccountType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountLockOrUnlockedDetails.h"
#import "DBTEAMLOGAccountState.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountLockOrUnlockedDetails

#pragma mark - Constructors

- (instancetype)initWithPreviousValue:(DBTEAMLOGAccountState *)previousValue
                            dNewValue:(DBTEAMLOGAccountState *)dNewValue {
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _previousValue = previousValue;
    _dNewValue = dNewValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountLockOrUnlockedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountLockOrUnlockedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountLockOrUnlockedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountLockOrUnlockedDetails:other];
}

- (BOOL)isEqualToAccountLockOrUnlockedDetails:(DBTEAMLOGAccountLockOrUnlockedDetails *)anAccountLockOrUnlockedDetails {
  if (self == anAccountLockOrUnlockedDetails) {
    return YES;
  }
  if (![self.previousValue isEqual:anAccountLockOrUnlockedDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:anAccountLockOrUnlockedDetails.dNewValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountLockOrUnlockedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountLockOrUnlockedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"previous_value"] = [DBTEAMLOGAccountStateSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGAccountStateSerializer serialize:valueObj.dNewValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountLockOrUnlockedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAccountState *previousValue = [DBTEAMLOGAccountStateSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGAccountState *dNewValue = [DBTEAMLOGAccountStateSerializer deserialize:valueDict[@"new_value"]];

  return [[DBTEAMLOGAccountLockOrUnlockedDetails alloc] initWithPreviousValue:previousValue dNewValue:dNewValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountLockOrUnlockedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountLockOrUnlockedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountLockOrUnlockedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountLockOrUnlockedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountLockOrUnlockedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountLockOrUnlockedType:other];
}

- (BOOL)isEqualToAccountLockOrUnlockedType:(DBTEAMLOGAccountLockOrUnlockedType *)anAccountLockOrUnlockedType {
  if (self == anAccountLockOrUnlockedType) {
    return YES;
  }
  if (![self.description_ isEqual:anAccountLockOrUnlockedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountLockOrUnlockedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountLockOrUnlockedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountLockOrUnlockedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAccountLockOrUnlockedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountState.h"

#pragma mark - API Object

@implementation DBTEAMLOGAccountState

#pragma mark - Constructors

- (instancetype)initWithLocked {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountStateLocked;
  }
  return self;
}

- (instancetype)initWithUnlocked {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountStateUnlocked;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAccountStateOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isLocked {
  return _tag == DBTEAMLOGAccountStateLocked;
}

- (BOOL)isUnlocked {
  return _tag == DBTEAMLOGAccountStateUnlocked;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAccountStateOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAccountStateLocked:
    return @"DBTEAMLOGAccountStateLocked";
  case DBTEAMLOGAccountStateUnlocked:
    return @"DBTEAMLOGAccountStateUnlocked";
  case DBTEAMLOGAccountStateOther:
    return @"DBTEAMLOGAccountStateOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAccountStateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAccountStateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAccountStateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAccountStateLocked:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountStateUnlocked:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAccountStateOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccountState:other];
}

- (BOOL)isEqualToAccountState:(DBTEAMLOGAccountState *)anAccountState {
  if (self == anAccountState) {
    return YES;
  }
  if (self.tag != anAccountState.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAccountStateLocked:
    return [[self tagName] isEqual:[anAccountState tagName]];
  case DBTEAMLOGAccountStateUnlocked:
    return [[self tagName] isEqual:[anAccountState tagName]];
  case DBTEAMLOGAccountStateOther:
    return [[self tagName] isEqual:[anAccountState tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAccountStateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAccountState *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLocked]) {
    jsonDict[@".tag"] = @"locked";
  } else if ([valueObj isUnlocked]) {
    jsonDict[@".tag"] = @"unlocked";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAccountState *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"locked"]) {
    return [[DBTEAMLOGAccountState alloc] initWithLocked];
  } else if ([tag isEqualToString:@"unlocked"]) {
    return [[DBTEAMLOGAccountState alloc] initWithUnlocked];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAccountState alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAccountState alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGActionDetails.h"
#import "DBTEAMLOGJoinTeamDetails.h"
#import "DBTEAMLOGMemberRemoveActionType.h"
#import "DBTEAMLOGTeamInviteDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGActionDetails

@synthesize removeAction = _removeAction;
@synthesize teamInviteDetails = _teamInviteDetails;
@synthesize teamJoinDetails = _teamJoinDetails;

#pragma mark - Constructors

- (instancetype)initWithRemoveAction:(DBTEAMLOGMemberRemoveActionType *)removeAction {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActionDetailsRemoveAction;
    _removeAction = removeAction;
  }
  return self;
}

- (instancetype)initWithTeamInviteDetails:(DBTEAMLOGTeamInviteDetails *)teamInviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActionDetailsTeamInviteDetails;
    _teamInviteDetails = teamInviteDetails;
  }
  return self;
}

- (instancetype)initWithTeamJoinDetails:(DBTEAMLOGJoinTeamDetails *)teamJoinDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActionDetailsTeamJoinDetails;
    _teamJoinDetails = teamJoinDetails;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActionDetailsOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGMemberRemoveActionType *)removeAction {
  if (![self isRemoveAction]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActionDetailsRemoveAction, but was %@.", [self tagName]];
  }
  return _removeAction;
}

- (DBTEAMLOGTeamInviteDetails *)teamInviteDetails {
  if (![self isTeamInviteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActionDetailsTeamInviteDetails, but was %@.", [self tagName]];
  }
  return _teamInviteDetails;
}

- (DBTEAMLOGJoinTeamDetails *)teamJoinDetails {
  if (![self isTeamJoinDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActionDetailsTeamJoinDetails, but was %@.", [self tagName]];
  }
  return _teamJoinDetails;
}

#pragma mark - Tag state methods

- (BOOL)isRemoveAction {
  return _tag == DBTEAMLOGActionDetailsRemoveAction;
}

- (BOOL)isTeamInviteDetails {
  return _tag == DBTEAMLOGActionDetailsTeamInviteDetails;
}

- (BOOL)isTeamJoinDetails {
  return _tag == DBTEAMLOGActionDetailsTeamJoinDetails;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGActionDetailsOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGActionDetailsRemoveAction:
    return @"DBTEAMLOGActionDetailsRemoveAction";
  case DBTEAMLOGActionDetailsTeamInviteDetails:
    return @"DBTEAMLOGActionDetailsTeamInviteDetails";
  case DBTEAMLOGActionDetailsTeamJoinDetails:
    return @"DBTEAMLOGActionDetailsTeamJoinDetails";
  case DBTEAMLOGActionDetailsOther:
    return @"DBTEAMLOGActionDetailsOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGActionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGActionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGActionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGActionDetailsRemoveAction:
    result = prime * result + [self.removeAction hash];
    break;
  case DBTEAMLOGActionDetailsTeamInviteDetails:
    result = prime * result + [self.teamInviteDetails hash];
    break;
  case DBTEAMLOGActionDetailsTeamJoinDetails:
    result = prime * result + [self.teamJoinDetails hash];
    break;
  case DBTEAMLOGActionDetailsOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToActionDetails:other];
}

- (BOOL)isEqualToActionDetails:(DBTEAMLOGActionDetails *)anActionDetails {
  if (self == anActionDetails) {
    return YES;
  }
  if (self.tag != anActionDetails.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGActionDetailsRemoveAction:
    return [self.removeAction isEqual:anActionDetails.removeAction];
  case DBTEAMLOGActionDetailsTeamInviteDetails:
    return [self.teamInviteDetails isEqual:anActionDetails.teamInviteDetails];
  case DBTEAMLOGActionDetailsTeamJoinDetails:
    return [self.teamJoinDetails isEqual:anActionDetails.teamJoinDetails];
  case DBTEAMLOGActionDetailsOther:
    return [[self tagName] isEqual:[anActionDetails tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGActionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGActionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRemoveAction]) {
    jsonDict[@"remove_action"] =
        [[DBTEAMLOGMemberRemoveActionTypeSerializer serialize:valueObj.removeAction] mutableCopy];
    jsonDict[@".tag"] = @"remove_action";
  } else if ([valueObj isTeamInviteDetails]) {
    jsonDict = [[DBTEAMLOGTeamInviteDetailsSerializer serialize:valueObj.teamInviteDetails] mutableCopy];
    jsonDict[@".tag"] = @"team_invite_details";
  } else if ([valueObj isTeamJoinDetails]) {
    jsonDict = [[DBTEAMLOGJoinTeamDetailsSerializer serialize:valueObj.teamJoinDetails] mutableCopy];
    jsonDict[@".tag"] = @"team_join_details";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGActionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"remove_action"]) {
    DBTEAMLOGMemberRemoveActionType *removeAction =
        [DBTEAMLOGMemberRemoveActionTypeSerializer deserialize:valueDict[@"remove_action"]];
    return [[DBTEAMLOGActionDetails alloc] initWithRemoveAction:removeAction];
  } else if ([tag isEqualToString:@"team_invite_details"]) {
    DBTEAMLOGTeamInviteDetails *teamInviteDetails = [DBTEAMLOGTeamInviteDetailsSerializer deserialize:valueDict];
    return [[DBTEAMLOGActionDetails alloc] initWithTeamInviteDetails:teamInviteDetails];
  } else if ([tag isEqualToString:@"team_join_details"]) {
    DBTEAMLOGJoinTeamDetails *teamJoinDetails = [DBTEAMLOGJoinTeamDetailsSerializer deserialize:valueDict];
    return [[DBTEAMLOGActionDetails alloc] initWithTeamJoinDetails:teamJoinDetails];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGActionDetails alloc] initWithOther];
  } else {
    return [[DBTEAMLOGActionDetails alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGActorLogInfo.h"
#import "DBTEAMLOGAppLogInfo.h"
#import "DBTEAMLOGResellerLogInfo.h"
#import "DBTEAMLOGUserLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGActorLogInfo

@synthesize admin = _admin;
@synthesize app = _app;
@synthesize reseller = _reseller;
@synthesize user = _user;

#pragma mark - Constructors

- (instancetype)initWithAdmin:(DBTEAMLOGUserLogInfo *)admin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoAdmin;
    _admin = admin;
  }
  return self;
}

- (instancetype)initWithAnonymous {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoAnonymous;
  }
  return self;
}

- (instancetype)initWithApp:(DBTEAMLOGAppLogInfo *)app {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoApp;
    _app = app;
  }
  return self;
}

- (instancetype)initWithDropbox {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoDropbox;
  }
  return self;
}

- (instancetype)initWithReseller:(DBTEAMLOGResellerLogInfo *)reseller {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoReseller;
    _reseller = reseller;
  }
  return self;
}

- (instancetype)initWithUser:(DBTEAMLOGUserLogInfo *)user {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoUser;
    _user = user;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGActorLogInfoOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGUserLogInfo *)admin {
  if (![self isAdmin]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActorLogInfoAdmin, but was %@.", [self tagName]];
  }
  return _admin;
}

- (DBTEAMLOGAppLogInfo *)app {
  if (![self isApp]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActorLogInfoApp, but was %@.", [self tagName]];
  }
  return _app;
}

- (DBTEAMLOGResellerLogInfo *)reseller {
  if (![self isReseller]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActorLogInfoReseller, but was %@.", [self tagName]];
  }
  return _reseller;
}

- (DBTEAMLOGUserLogInfo *)user {
  if (![self isUser]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGActorLogInfoUser, but was %@.", [self tagName]];
  }
  return _user;
}

#pragma mark - Tag state methods

- (BOOL)isAdmin {
  return _tag == DBTEAMLOGActorLogInfoAdmin;
}

- (BOOL)isAnonymous {
  return _tag == DBTEAMLOGActorLogInfoAnonymous;
}

- (BOOL)isApp {
  return _tag == DBTEAMLOGActorLogInfoApp;
}

- (BOOL)isDropbox {
  return _tag == DBTEAMLOGActorLogInfoDropbox;
}

- (BOOL)isReseller {
  return _tag == DBTEAMLOGActorLogInfoReseller;
}

- (BOOL)isUser {
  return _tag == DBTEAMLOGActorLogInfoUser;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGActorLogInfoOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGActorLogInfoAdmin:
    return @"DBTEAMLOGActorLogInfoAdmin";
  case DBTEAMLOGActorLogInfoAnonymous:
    return @"DBTEAMLOGActorLogInfoAnonymous";
  case DBTEAMLOGActorLogInfoApp:
    return @"DBTEAMLOGActorLogInfoApp";
  case DBTEAMLOGActorLogInfoDropbox:
    return @"DBTEAMLOGActorLogInfoDropbox";
  case DBTEAMLOGActorLogInfoReseller:
    return @"DBTEAMLOGActorLogInfoReseller";
  case DBTEAMLOGActorLogInfoUser:
    return @"DBTEAMLOGActorLogInfoUser";
  case DBTEAMLOGActorLogInfoOther:
    return @"DBTEAMLOGActorLogInfoOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGActorLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGActorLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGActorLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGActorLogInfoAdmin:
    result = prime * result + [self.admin hash];
    break;
  case DBTEAMLOGActorLogInfoAnonymous:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGActorLogInfoApp:
    result = prime * result + [self.app hash];
    break;
  case DBTEAMLOGActorLogInfoDropbox:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGActorLogInfoReseller:
    result = prime * result + [self.reseller hash];
    break;
  case DBTEAMLOGActorLogInfoUser:
    result = prime * result + [self.user hash];
    break;
  case DBTEAMLOGActorLogInfoOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToActorLogInfo:other];
}

- (BOOL)isEqualToActorLogInfo:(DBTEAMLOGActorLogInfo *)anActorLogInfo {
  if (self == anActorLogInfo) {
    return YES;
  }
  if (self.tag != anActorLogInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGActorLogInfoAdmin:
    return [self.admin isEqual:anActorLogInfo.admin];
  case DBTEAMLOGActorLogInfoAnonymous:
    return [[self tagName] isEqual:[anActorLogInfo tagName]];
  case DBTEAMLOGActorLogInfoApp:
    return [self.app isEqual:anActorLogInfo.app];
  case DBTEAMLOGActorLogInfoDropbox:
    return [[self tagName] isEqual:[anActorLogInfo tagName]];
  case DBTEAMLOGActorLogInfoReseller:
    return [self.reseller isEqual:anActorLogInfo.reseller];
  case DBTEAMLOGActorLogInfoUser:
    return [self.user isEqual:anActorLogInfo.user];
  case DBTEAMLOGActorLogInfoOther:
    return [[self tagName] isEqual:[anActorLogInfo tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGActorLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGActorLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAdmin]) {
    jsonDict[@"admin"] = [[DBTEAMLOGUserLogInfoSerializer serialize:valueObj.admin] mutableCopy];
    jsonDict[@".tag"] = @"admin";
  } else if ([valueObj isAnonymous]) {
    jsonDict[@".tag"] = @"anonymous";
  } else if ([valueObj isApp]) {
    jsonDict[@"app"] = [[DBTEAMLOGAppLogInfoSerializer serialize:valueObj.app] mutableCopy];
    jsonDict[@".tag"] = @"app";
  } else if ([valueObj isDropbox]) {
    jsonDict[@".tag"] = @"dropbox";
  } else if ([valueObj isReseller]) {
    jsonDict = [[DBTEAMLOGResellerLogInfoSerializer serialize:valueObj.reseller] mutableCopy];
    jsonDict[@".tag"] = @"reseller";
  } else if ([valueObj isUser]) {
    jsonDict[@"user"] = [[DBTEAMLOGUserLogInfoSerializer serialize:valueObj.user] mutableCopy];
    jsonDict[@".tag"] = @"user";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGActorLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"admin"]) {
    DBTEAMLOGUserLogInfo *admin = [DBTEAMLOGUserLogInfoSerializer deserialize:valueDict[@"admin"]];
    return [[DBTEAMLOGActorLogInfo alloc] initWithAdmin:admin];
  } else if ([tag isEqualToString:@"anonymous"]) {
    return [[DBTEAMLOGActorLogInfo alloc] initWithAnonymous];
  } else if ([tag isEqualToString:@"app"]) {
    DBTEAMLOGAppLogInfo *app = [DBTEAMLOGAppLogInfoSerializer deserialize:valueDict[@"app"]];
    return [[DBTEAMLOGActorLogInfo alloc] initWithApp:app];
  } else if ([tag isEqualToString:@"dropbox"]) {
    return [[DBTEAMLOGActorLogInfo alloc] initWithDropbox];
  } else if ([tag isEqualToString:@"reseller"]) {
    DBTEAMLOGResellerLogInfo *reseller = [DBTEAMLOGResellerLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGActorLogInfo alloc] initWithReseller:reseller];
  } else if ([tag isEqualToString:@"user"]) {
    DBTEAMLOGUserLogInfo *user = [DBTEAMLOGUserLogInfoSerializer deserialize:valueDict[@"user"]];
    return [[DBTEAMLOGActorLogInfo alloc] initWithUser:user];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGActorLogInfo alloc] initWithOther];
  } else {
    return [[DBTEAMLOGActorLogInfo alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertCategoryEnum.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertCategoryEnum

#pragma mark - Constructors

- (instancetype)initWithAccountTakeover {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumAccountTakeover;
  }
  return self;
}

- (instancetype)initWithDataLossProtection {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumDataLossProtection;
  }
  return self;
}

- (instancetype)initWithMalwareSharing {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumMalwareSharing;
  }
  return self;
}

- (instancetype)initWithMassiveFileOperation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation;
  }
  return self;
}

- (instancetype)initWithNa {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumNa;
  }
  return self;
}

- (instancetype)initWithThreatManagement {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumThreatManagement;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertCategoryEnumOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAccountTakeover {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumAccountTakeover;
}

- (BOOL)isDataLossProtection {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumDataLossProtection;
}

- (BOOL)isMalwareSharing {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumMalwareSharing;
}

- (BOOL)isMassiveFileOperation {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation;
}

- (BOOL)isNa {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumNa;
}

- (BOOL)isThreatManagement {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumThreatManagement;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAdminAlertCategoryEnumOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAdminAlertCategoryEnumAccountTakeover:
    return @"DBTEAMLOGAdminAlertCategoryEnumAccountTakeover";
  case DBTEAMLOGAdminAlertCategoryEnumDataLossProtection:
    return @"DBTEAMLOGAdminAlertCategoryEnumDataLossProtection";
  case DBTEAMLOGAdminAlertCategoryEnumMalwareSharing:
    return @"DBTEAMLOGAdminAlertCategoryEnumMalwareSharing";
  case DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation:
    return @"DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation";
  case DBTEAMLOGAdminAlertCategoryEnumNa:
    return @"DBTEAMLOGAdminAlertCategoryEnumNa";
  case DBTEAMLOGAdminAlertCategoryEnumThreatManagement:
    return @"DBTEAMLOGAdminAlertCategoryEnumThreatManagement";
  case DBTEAMLOGAdminAlertCategoryEnumOther:
    return @"DBTEAMLOGAdminAlertCategoryEnumOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertCategoryEnumSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertCategoryEnumSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertCategoryEnumSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAdminAlertCategoryEnumAccountTakeover:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumDataLossProtection:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumMalwareSharing:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumNa:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumThreatManagement:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertCategoryEnumOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertCategoryEnum:other];
}

- (BOOL)isEqualToAdminAlertCategoryEnum:(DBTEAMLOGAdminAlertCategoryEnum *)anAdminAlertCategoryEnum {
  if (self == anAdminAlertCategoryEnum) {
    return YES;
  }
  if (self.tag != anAdminAlertCategoryEnum.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAdminAlertCategoryEnumAccountTakeover:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumDataLossProtection:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumMalwareSharing:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumMassiveFileOperation:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumNa:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumThreatManagement:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  case DBTEAMLOGAdminAlertCategoryEnumOther:
    return [[self tagName] isEqual:[anAdminAlertCategoryEnum tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertCategoryEnumSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertCategoryEnum *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccountTakeover]) {
    jsonDict[@".tag"] = @"account_takeover";
  } else if ([valueObj isDataLossProtection]) {
    jsonDict[@".tag"] = @"data_loss_protection";
  } else if ([valueObj isMalwareSharing]) {
    jsonDict[@".tag"] = @"malware_sharing";
  } else if ([valueObj isMassiveFileOperation]) {
    jsonDict[@".tag"] = @"massive_file_operation";
  } else if ([valueObj isNa]) {
    jsonDict[@".tag"] = @"na";
  } else if ([valueObj isThreatManagement]) {
    jsonDict[@".tag"] = @"threat_management";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertCategoryEnum *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"account_takeover"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithAccountTakeover];
  } else if ([tag isEqualToString:@"data_loss_protection"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithDataLossProtection];
  } else if ([tag isEqualToString:@"malware_sharing"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithMalwareSharing];
  } else if ([tag isEqualToString:@"massive_file_operation"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithMassiveFileOperation];
  } else if ([tag isEqualToString:@"na"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithNa];
  } else if ([tag isEqualToString:@"threat_management"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithThreatManagement];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAdminAlertCategoryEnum alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertSeverityEnum.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertSeverityEnum

#pragma mark - Constructors

- (instancetype)initWithHigh {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumHigh;
  }
  return self;
}

- (instancetype)initWithInfo {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumInfo;
  }
  return self;
}

- (instancetype)initWithLow {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumLow;
  }
  return self;
}

- (instancetype)initWithMedium {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumMedium;
  }
  return self;
}

- (instancetype)initWithNa {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumNa;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertSeverityEnumOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isHigh {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumHigh;
}

- (BOOL)isInfo {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumInfo;
}

- (BOOL)isLow {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumLow;
}

- (BOOL)isMedium {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumMedium;
}

- (BOOL)isNa {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumNa;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAdminAlertSeverityEnumOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAdminAlertSeverityEnumHigh:
    return @"DBTEAMLOGAdminAlertSeverityEnumHigh";
  case DBTEAMLOGAdminAlertSeverityEnumInfo:
    return @"DBTEAMLOGAdminAlertSeverityEnumInfo";
  case DBTEAMLOGAdminAlertSeverityEnumLow:
    return @"DBTEAMLOGAdminAlertSeverityEnumLow";
  case DBTEAMLOGAdminAlertSeverityEnumMedium:
    return @"DBTEAMLOGAdminAlertSeverityEnumMedium";
  case DBTEAMLOGAdminAlertSeverityEnumNa:
    return @"DBTEAMLOGAdminAlertSeverityEnumNa";
  case DBTEAMLOGAdminAlertSeverityEnumOther:
    return @"DBTEAMLOGAdminAlertSeverityEnumOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertSeverityEnumSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertSeverityEnumSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertSeverityEnumSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAdminAlertSeverityEnumHigh:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertSeverityEnumInfo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertSeverityEnumLow:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertSeverityEnumMedium:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertSeverityEnumNa:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertSeverityEnumOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertSeverityEnum:other];
}

- (BOOL)isEqualToAdminAlertSeverityEnum:(DBTEAMLOGAdminAlertSeverityEnum *)anAdminAlertSeverityEnum {
  if (self == anAdminAlertSeverityEnum) {
    return YES;
  }
  if (self.tag != anAdminAlertSeverityEnum.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAdminAlertSeverityEnumHigh:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  case DBTEAMLOGAdminAlertSeverityEnumInfo:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  case DBTEAMLOGAdminAlertSeverityEnumLow:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  case DBTEAMLOGAdminAlertSeverityEnumMedium:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  case DBTEAMLOGAdminAlertSeverityEnumNa:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  case DBTEAMLOGAdminAlertSeverityEnumOther:
    return [[self tagName] isEqual:[anAdminAlertSeverityEnum tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertSeverityEnumSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertSeverityEnum *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHigh]) {
    jsonDict[@".tag"] = @"high";
  } else if ([valueObj isInfo]) {
    jsonDict[@".tag"] = @"info";
  } else if ([valueObj isLow]) {
    jsonDict[@".tag"] = @"low";
  } else if ([valueObj isMedium]) {
    jsonDict[@".tag"] = @"medium";
  } else if ([valueObj isNa]) {
    jsonDict[@".tag"] = @"na";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertSeverityEnum *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"high"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithHigh];
  } else if ([tag isEqualToString:@"info"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithInfo];
  } else if ([tag isEqualToString:@"low"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithLow];
  } else if ([tag isEqualToString:@"medium"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithMedium];
  } else if ([tag isEqualToString:@"na"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithNa];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAdminAlertSeverityEnum alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingAlertConfiguration.h"
#import "DBTEAMLOGAdminAlertingAlertSensitivity.h"
#import "DBTEAMLOGAdminAlertingAlertStatePolicy.h"
#import "DBTEAMLOGRecipientsConfiguration.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingAlertConfiguration

#pragma mark - Constructors

- (instancetype)initWithAlertState:(DBTEAMLOGAdminAlertingAlertStatePolicy *)alertState
                  sensitivityLevel:(DBTEAMLOGAdminAlertingAlertSensitivity *)sensitivityLevel
                recipientsSettings:(DBTEAMLOGRecipientsConfiguration *)recipientsSettings {

  self = [super init];
  if (self) {
    _alertState = alertState;
    _sensitivityLevel = sensitivityLevel;
    _recipientsSettings = recipientsSettings;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithAlertState:nil sensitivityLevel:nil recipientsSettings:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingAlertConfigurationSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingAlertConfigurationSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingAlertConfigurationSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.alertState != nil) {
    result = prime * result + [self.alertState hash];
  }
  if (self.sensitivityLevel != nil) {
    result = prime * result + [self.sensitivityLevel hash];
  }
  if (self.recipientsSettings != nil) {
    result = prime * result + [self.recipientsSettings hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingAlertConfiguration:other];
}

- (BOOL)isEqualToAdminAlertingAlertConfiguration:
    (DBTEAMLOGAdminAlertingAlertConfiguration *)anAdminAlertingAlertConfiguration {
  if (self == anAdminAlertingAlertConfiguration) {
    return YES;
  }
  if (self.alertState) {
    if (![self.alertState isEqual:anAdminAlertingAlertConfiguration.alertState]) {
      return NO;
    }
  }
  if (self.sensitivityLevel) {
    if (![self.sensitivityLevel isEqual:anAdminAlertingAlertConfiguration.sensitivityLevel]) {
      return NO;
    }
  }
  if (self.recipientsSettings) {
    if (![self.recipientsSettings isEqual:anAdminAlertingAlertConfiguration.recipientsSettings]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingAlertConfigurationSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertConfiguration *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.alertState) {
    jsonDict[@"alert_state"] = [DBTEAMLOGAdminAlertingAlertStatePolicySerializer serialize:valueObj.alertState];
  }
  if (valueObj.sensitivityLevel) {
    jsonDict[@"sensitivity_level"] =
        [DBTEAMLOGAdminAlertingAlertSensitivitySerializer serialize:valueObj.sensitivityLevel];
  }
  if (valueObj.recipientsSettings) {
    jsonDict[@"recipients_settings"] =
        [DBTEAMLOGRecipientsConfigurationSerializer serialize:valueObj.recipientsSettings];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingAlertConfiguration *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAdminAlertingAlertStatePolicy *alertState =
      valueDict[@"alert_state"]
          ? [DBTEAMLOGAdminAlertingAlertStatePolicySerializer deserialize:valueDict[@"alert_state"]]
          : nil;
  DBTEAMLOGAdminAlertingAlertSensitivity *sensitivityLevel =
      valueDict[@"sensitivity_level"]
          ? [DBTEAMLOGAdminAlertingAlertSensitivitySerializer deserialize:valueDict[@"sensitivity_level"]]
          : nil;
  DBTEAMLOGRecipientsConfiguration *recipientsSettings =
      valueDict[@"recipients_settings"]
          ? [DBTEAMLOGRecipientsConfigurationSerializer deserialize:valueDict[@"recipients_settings"]]
          : nil;

  return [[DBTEAMLOGAdminAlertingAlertConfiguration alloc] initWithAlertState:alertState
                                                             sensitivityLevel:sensitivityLevel
                                                           recipientsSettings:recipientsSettings];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingAlertSensitivity.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingAlertSensitivity

#pragma mark - Constructors

- (instancetype)initWithHigh {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityHigh;
  }
  return self;
}

- (instancetype)initWithHighest {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityHighest;
  }
  return self;
}

- (instancetype)initWithInvalid {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityInvalid;
  }
  return self;
}

- (instancetype)initWithLow {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityLow;
  }
  return self;
}

- (instancetype)initWithLowest {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityLowest;
  }
  return self;
}

- (instancetype)initWithMedium {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityMedium;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertSensitivityOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isHigh {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityHigh;
}

- (BOOL)isHighest {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityHighest;
}

- (BOOL)isInvalid {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityInvalid;
}

- (BOOL)isLow {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityLow;
}

- (BOOL)isLowest {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityLowest;
}

- (BOOL)isMedium {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityMedium;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAdminAlertingAlertSensitivityOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertSensitivityHigh:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityHigh";
  case DBTEAMLOGAdminAlertingAlertSensitivityHighest:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityHighest";
  case DBTEAMLOGAdminAlertingAlertSensitivityInvalid:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityInvalid";
  case DBTEAMLOGAdminAlertingAlertSensitivityLow:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityLow";
  case DBTEAMLOGAdminAlertingAlertSensitivityLowest:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityLowest";
  case DBTEAMLOGAdminAlertingAlertSensitivityMedium:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityMedium";
  case DBTEAMLOGAdminAlertingAlertSensitivityOther:
    return @"DBTEAMLOGAdminAlertingAlertSensitivityOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingAlertSensitivitySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingAlertSensitivitySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingAlertSensitivitySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertSensitivityHigh:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityHighest:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityInvalid:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityLow:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityLowest:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityMedium:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertSensitivityOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingAlertSensitivity:other];
}

- (BOOL)isEqualToAdminAlertingAlertSensitivity:
    (DBTEAMLOGAdminAlertingAlertSensitivity *)anAdminAlertingAlertSensitivity {
  if (self == anAdminAlertingAlertSensitivity) {
    return YES;
  }
  if (self.tag != anAdminAlertingAlertSensitivity.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertSensitivityHigh:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityHighest:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityInvalid:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityLow:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityLowest:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityMedium:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  case DBTEAMLOGAdminAlertingAlertSensitivityOther:
    return [[self tagName] isEqual:[anAdminAlertingAlertSensitivity tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingAlertSensitivitySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertSensitivity *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHigh]) {
    jsonDict[@".tag"] = @"high";
  } else if ([valueObj isHighest]) {
    jsonDict[@".tag"] = @"highest";
  } else if ([valueObj isInvalid]) {
    jsonDict[@".tag"] = @"invalid";
  } else if ([valueObj isLow]) {
    jsonDict[@".tag"] = @"low";
  } else if ([valueObj isLowest]) {
    jsonDict[@".tag"] = @"lowest";
  } else if ([valueObj isMedium]) {
    jsonDict[@".tag"] = @"medium";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingAlertSensitivity *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"high"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithHigh];
  } else if ([tag isEqualToString:@"highest"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithHighest];
  } else if ([tag isEqualToString:@"invalid"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithInvalid];
  } else if ([tag isEqualToString:@"low"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithLow];
  } else if ([tag isEqualToString:@"lowest"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithLowest];
  } else if ([tag isEqualToString:@"medium"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithMedium];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAdminAlertingAlertSensitivity alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingAlertStatePolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingAlertStatePolicy

#pragma mark - Constructors

- (instancetype)initWithOff {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertStatePolicyOff;
  }
  return self;
}

- (instancetype)initWithOn {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertStatePolicyOn;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminAlertingAlertStatePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOff {
  return _tag == DBTEAMLOGAdminAlertingAlertStatePolicyOff;
}

- (BOOL)isOn {
  return _tag == DBTEAMLOGAdminAlertingAlertStatePolicyOn;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAdminAlertingAlertStatePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertStatePolicyOff:
    return @"DBTEAMLOGAdminAlertingAlertStatePolicyOff";
  case DBTEAMLOGAdminAlertingAlertStatePolicyOn:
    return @"DBTEAMLOGAdminAlertingAlertStatePolicyOn";
  case DBTEAMLOGAdminAlertingAlertStatePolicyOther:
    return @"DBTEAMLOGAdminAlertingAlertStatePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingAlertStatePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingAlertStatePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingAlertStatePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertStatePolicyOff:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertStatePolicyOn:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminAlertingAlertStatePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingAlertStatePolicy:other];
}

- (BOOL)isEqualToAdminAlertingAlertStatePolicy:
    (DBTEAMLOGAdminAlertingAlertStatePolicy *)anAdminAlertingAlertStatePolicy {
  if (self == anAdminAlertingAlertStatePolicy) {
    return YES;
  }
  if (self.tag != anAdminAlertingAlertStatePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAdminAlertingAlertStatePolicyOff:
    return [[self tagName] isEqual:[anAdminAlertingAlertStatePolicy tagName]];
  case DBTEAMLOGAdminAlertingAlertStatePolicyOn:
    return [[self tagName] isEqual:[anAdminAlertingAlertStatePolicy tagName]];
  case DBTEAMLOGAdminAlertingAlertStatePolicyOther:
    return [[self tagName] isEqual:[anAdminAlertingAlertStatePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingAlertStatePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingAlertStatePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOff]) {
    jsonDict[@".tag"] = @"off";
  } else if ([valueObj isOn]) {
    jsonDict[@".tag"] = @"on";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingAlertStatePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"off"]) {
    return [[DBTEAMLOGAdminAlertingAlertStatePolicy alloc] initWithOff];
  } else if ([tag isEqualToString:@"on"]) {
    return [[DBTEAMLOGAdminAlertingAlertStatePolicy alloc] initWithOn];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAdminAlertingAlertStatePolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAdminAlertingAlertStatePolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingAlertConfiguration.h"
#import "DBTEAMLOGAdminAlertingChangedAlertConfigDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingChangedAlertConfigDetails

#pragma mark - Constructors

- (instancetype)initWithAlertName:(NSString *)alertName
              previousAlertConfig:(DBTEAMLOGAdminAlertingAlertConfiguration *)previousAlertConfig
                  dNewAlertConfig:(DBTEAMLOGAdminAlertingAlertConfiguration *)dNewAlertConfig {
  [DBStoneValidators nonnullValidator:nil](alertName);
  [DBStoneValidators nonnullValidator:nil](previousAlertConfig);
  [DBStoneValidators nonnullValidator:nil](dNewAlertConfig);

  self = [super init];
  if (self) {
    _alertName = alertName;
    _previousAlertConfig = previousAlertConfig;
    _dNewAlertConfig = dNewAlertConfig;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingChangedAlertConfigDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingChangedAlertConfigDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingChangedAlertConfigDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.alertName hash];
  result = prime * result + [self.previousAlertConfig hash];
  result = prime * result + [self.dNewAlertConfig hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingChangedAlertConfigDetails:other];
}

- (BOOL)isEqualToAdminAlertingChangedAlertConfigDetails:
    (DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)anAdminAlertingChangedAlertConfigDetails {
  if (self == anAdminAlertingChangedAlertConfigDetails) {
    return YES;
  }
  if (![self.alertName isEqual:anAdminAlertingChangedAlertConfigDetails.alertName]) {
    return NO;
  }
  if (![self.previousAlertConfig isEqual:anAdminAlertingChangedAlertConfigDetails.previousAlertConfig]) {
    return NO;
  }
  if (![self.dNewAlertConfig isEqual:anAdminAlertingChangedAlertConfigDetails.dNewAlertConfig]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingChangedAlertConfigDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"alert_name"] = valueObj.alertName;
  jsonDict[@"previous_alert_config"] =
      [DBTEAMLOGAdminAlertingAlertConfigurationSerializer serialize:valueObj.previousAlertConfig];
  jsonDict[@"new_alert_config"] =
      [DBTEAMLOGAdminAlertingAlertConfigurationSerializer serialize:valueObj.dNewAlertConfig];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *alertName = valueDict[@"alert_name"];
  DBTEAMLOGAdminAlertingAlertConfiguration *previousAlertConfig =
      [DBTEAMLOGAdminAlertingAlertConfigurationSerializer deserialize:valueDict[@"previous_alert_config"]];
  DBTEAMLOGAdminAlertingAlertConfiguration *dNewAlertConfig =
      [DBTEAMLOGAdminAlertingAlertConfigurationSerializer deserialize:valueDict[@"new_alert_config"]];

  return [[DBTEAMLOGAdminAlertingChangedAlertConfigDetails alloc] initWithAlertName:alertName
                                                                previousAlertConfig:previousAlertConfig
                                                                    dNewAlertConfig:dNewAlertConfig];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingChangedAlertConfigType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingChangedAlertConfigType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingChangedAlertConfigTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingChangedAlertConfigTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingChangedAlertConfigTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingChangedAlertConfigType:other];
}

- (BOOL)isEqualToAdminAlertingChangedAlertConfigType:
    (DBTEAMLOGAdminAlertingChangedAlertConfigType *)anAdminAlertingChangedAlertConfigType {
  if (self == anAdminAlertingChangedAlertConfigType) {
    return YES;
  }
  if (![self.description_ isEqual:anAdminAlertingChangedAlertConfigType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingChangedAlertConfigTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingChangedAlertConfigType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingChangedAlertConfigType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAdminAlertingChangedAlertConfigType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertCategoryEnum.h"
#import "DBTEAMLOGAdminAlertSeverityEnum.h"
#import "DBTEAMLOGAdminAlertingTriggeredAlertDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingTriggeredAlertDetails

#pragma mark - Constructors

- (instancetype)initWithAlertName:(NSString *)alertName
                    alertSeverity:(DBTEAMLOGAdminAlertSeverityEnum *)alertSeverity
                    alertCategory:(DBTEAMLOGAdminAlertCategoryEnum *)alertCategory
                  alertInstanceId:(NSString *)alertInstanceId {
  [DBStoneValidators nonnullValidator:nil](alertName);
  [DBStoneValidators nonnullValidator:nil](alertSeverity);
  [DBStoneValidators nonnullValidator:nil](alertCategory);
  [DBStoneValidators nonnullValidator:nil](alertInstanceId);

  self = [super init];
  if (self) {
    _alertName = alertName;
    _alertSeverity = alertSeverity;
    _alertCategory = alertCategory;
    _alertInstanceId = alertInstanceId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingTriggeredAlertDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingTriggeredAlertDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingTriggeredAlertDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.alertName hash];
  result = prime * result + [self.alertSeverity hash];
  result = prime * result + [self.alertCategory hash];
  result = prime * result + [self.alertInstanceId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingTriggeredAlertDetails:other];
}

- (BOOL)isEqualToAdminAlertingTriggeredAlertDetails:
    (DBTEAMLOGAdminAlertingTriggeredAlertDetails *)anAdminAlertingTriggeredAlertDetails {
  if (self == anAdminAlertingTriggeredAlertDetails) {
    return YES;
  }
  if (![self.alertName isEqual:anAdminAlertingTriggeredAlertDetails.alertName]) {
    return NO;
  }
  if (![self.alertSeverity isEqual:anAdminAlertingTriggeredAlertDetails.alertSeverity]) {
    return NO;
  }
  if (![self.alertCategory isEqual:anAdminAlertingTriggeredAlertDetails.alertCategory]) {
    return NO;
  }
  if (![self.alertInstanceId isEqual:anAdminAlertingTriggeredAlertDetails.alertInstanceId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingTriggeredAlertDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingTriggeredAlertDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"alert_name"] = valueObj.alertName;
  jsonDict[@"alert_severity"] = [DBTEAMLOGAdminAlertSeverityEnumSerializer serialize:valueObj.alertSeverity];
  jsonDict[@"alert_category"] = [DBTEAMLOGAdminAlertCategoryEnumSerializer serialize:valueObj.alertCategory];
  jsonDict[@"alert_instance_id"] = valueObj.alertInstanceId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingTriggeredAlertDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *alertName = valueDict[@"alert_name"];
  DBTEAMLOGAdminAlertSeverityEnum *alertSeverity =
      [DBTEAMLOGAdminAlertSeverityEnumSerializer deserialize:valueDict[@"alert_severity"]];
  DBTEAMLOGAdminAlertCategoryEnum *alertCategory =
      [DBTEAMLOGAdminAlertCategoryEnumSerializer deserialize:valueDict[@"alert_category"]];
  NSString *alertInstanceId = valueDict[@"alert_instance_id"];

  return [[DBTEAMLOGAdminAlertingTriggeredAlertDetails alloc] initWithAlertName:alertName
                                                                  alertSeverity:alertSeverity
                                                                  alertCategory:alertCategory
                                                                alertInstanceId:alertInstanceId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminAlertingTriggeredAlertType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminAlertingTriggeredAlertType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminAlertingTriggeredAlertTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminAlertingTriggeredAlertTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminAlertingTriggeredAlertTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminAlertingTriggeredAlertType:other];
}

- (BOOL)isEqualToAdminAlertingTriggeredAlertType:
    (DBTEAMLOGAdminAlertingTriggeredAlertType *)anAdminAlertingTriggeredAlertType {
  if (self == anAdminAlertingTriggeredAlertType) {
    return YES;
  }
  if (![self.description_ isEqual:anAdminAlertingTriggeredAlertType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminAlertingTriggeredAlertTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminAlertingTriggeredAlertType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminAlertingTriggeredAlertType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAdminAlertingTriggeredAlertType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAdminRole.h"

#pragma mark - API Object

@implementation DBTEAMLOGAdminRole

#pragma mark - Constructors

- (instancetype)initWithBillingAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleBillingAdmin;
  }
  return self;
}

- (instancetype)initWithLimitedAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleLimitedAdmin;
  }
  return self;
}

- (instancetype)initWithMemberOnly {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleMemberOnly;
  }
  return self;
}

- (instancetype)initWithSupportAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleSupportAdmin;
  }
  return self;
}

- (instancetype)initWithTeamAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleTeamAdmin;
  }
  return self;
}

- (instancetype)initWithUserManagementAdmin {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleUserManagementAdmin;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAdminRoleOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isBillingAdmin {
  return _tag == DBTEAMLOGAdminRoleBillingAdmin;
}

- (BOOL)isLimitedAdmin {
  return _tag == DBTEAMLOGAdminRoleLimitedAdmin;
}

- (BOOL)isMemberOnly {
  return _tag == DBTEAMLOGAdminRoleMemberOnly;
}

- (BOOL)isSupportAdmin {
  return _tag == DBTEAMLOGAdminRoleSupportAdmin;
}

- (BOOL)isTeamAdmin {
  return _tag == DBTEAMLOGAdminRoleTeamAdmin;
}

- (BOOL)isUserManagementAdmin {
  return _tag == DBTEAMLOGAdminRoleUserManagementAdmin;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAdminRoleOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAdminRoleBillingAdmin:
    return @"DBTEAMLOGAdminRoleBillingAdmin";
  case DBTEAMLOGAdminRoleLimitedAdmin:
    return @"DBTEAMLOGAdminRoleLimitedAdmin";
  case DBTEAMLOGAdminRoleMemberOnly:
    return @"DBTEAMLOGAdminRoleMemberOnly";
  case DBTEAMLOGAdminRoleSupportAdmin:
    return @"DBTEAMLOGAdminRoleSupportAdmin";
  case DBTEAMLOGAdminRoleTeamAdmin:
    return @"DBTEAMLOGAdminRoleTeamAdmin";
  case DBTEAMLOGAdminRoleUserManagementAdmin:
    return @"DBTEAMLOGAdminRoleUserManagementAdmin";
  case DBTEAMLOGAdminRoleOther:
    return @"DBTEAMLOGAdminRoleOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAdminRoleSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAdminRoleSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAdminRoleSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAdminRoleBillingAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleLimitedAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleMemberOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleSupportAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleTeamAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleUserManagementAdmin:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAdminRoleOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAdminRole:other];
}

- (BOOL)isEqualToAdminRole:(DBTEAMLOGAdminRole *)anAdminRole {
  if (self == anAdminRole) {
    return YES;
  }
  if (self.tag != anAdminRole.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAdminRoleBillingAdmin:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleLimitedAdmin:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleMemberOnly:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleSupportAdmin:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleTeamAdmin:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleUserManagementAdmin:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  case DBTEAMLOGAdminRoleOther:
    return [[self tagName] isEqual:[anAdminRole tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAdminRoleSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAdminRole *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isBillingAdmin]) {
    jsonDict[@".tag"] = @"billing_admin";
  } else if ([valueObj isLimitedAdmin]) {
    jsonDict[@".tag"] = @"limited_admin";
  } else if ([valueObj isMemberOnly]) {
    jsonDict[@".tag"] = @"member_only";
  } else if ([valueObj isSupportAdmin]) {
    jsonDict[@".tag"] = @"support_admin";
  } else if ([valueObj isTeamAdmin]) {
    jsonDict[@".tag"] = @"team_admin";
  } else if ([valueObj isUserManagementAdmin]) {
    jsonDict[@".tag"] = @"user_management_admin";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAdminRole *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"billing_admin"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithBillingAdmin];
  } else if ([tag isEqualToString:@"limited_admin"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithLimitedAdmin];
  } else if ([tag isEqualToString:@"member_only"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithMemberOnly];
  } else if ([tag isEqualToString:@"support_admin"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithSupportAdmin];
  } else if ([tag isEqualToString:@"team_admin"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithTeamAdmin];
  } else if ([tag isEqualToString:@"user_management_admin"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithUserManagementAdmin];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAdminRole alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAdminRole alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAlertRecipientsSettingType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAlertRecipientsSettingType

#pragma mark - Constructors

- (instancetype)initWithCustomList {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAlertRecipientsSettingTypeCustomList;
  }
  return self;
}

- (instancetype)initWithInvalid {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAlertRecipientsSettingTypeInvalid;
  }
  return self;
}

- (instancetype)initWithNone {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAlertRecipientsSettingTypeNone;
  }
  return self;
}

- (instancetype)initWithTeamAdmins {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAlertRecipientsSettingTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isCustomList {
  return _tag == DBTEAMLOGAlertRecipientsSettingTypeCustomList;
}

- (BOOL)isInvalid {
  return _tag == DBTEAMLOGAlertRecipientsSettingTypeInvalid;
}

- (BOOL)isNone {
  return _tag == DBTEAMLOGAlertRecipientsSettingTypeNone;
}

- (BOOL)isTeamAdmins {
  return _tag == DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAlertRecipientsSettingTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAlertRecipientsSettingTypeCustomList:
    return @"DBTEAMLOGAlertRecipientsSettingTypeCustomList";
  case DBTEAMLOGAlertRecipientsSettingTypeInvalid:
    return @"DBTEAMLOGAlertRecipientsSettingTypeInvalid";
  case DBTEAMLOGAlertRecipientsSettingTypeNone:
    return @"DBTEAMLOGAlertRecipientsSettingTypeNone";
  case DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins:
    return @"DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins";
  case DBTEAMLOGAlertRecipientsSettingTypeOther:
    return @"DBTEAMLOGAlertRecipientsSettingTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAlertRecipientsSettingTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAlertRecipientsSettingTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAlertRecipientsSettingTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAlertRecipientsSettingTypeCustomList:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAlertRecipientsSettingTypeInvalid:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAlertRecipientsSettingTypeNone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGAlertRecipientsSettingTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAlertRecipientsSettingType:other];
}

- (BOOL)isEqualToAlertRecipientsSettingType:(DBTEAMLOGAlertRecipientsSettingType *)anAlertRecipientsSettingType {
  if (self == anAlertRecipientsSettingType) {
    return YES;
  }
  if (self.tag != anAlertRecipientsSettingType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAlertRecipientsSettingTypeCustomList:
    return [[self tagName] isEqual:[anAlertRecipientsSettingType tagName]];
  case DBTEAMLOGAlertRecipientsSettingTypeInvalid:
    return [[self tagName] isEqual:[anAlertRecipientsSettingType tagName]];
  case DBTEAMLOGAlertRecipientsSettingTypeNone:
    return [[self tagName] isEqual:[anAlertRecipientsSettingType tagName]];
  case DBTEAMLOGAlertRecipientsSettingTypeTeamAdmins:
    return [[self tagName] isEqual:[anAlertRecipientsSettingType tagName]];
  case DBTEAMLOGAlertRecipientsSettingTypeOther:
    return [[self tagName] isEqual:[anAlertRecipientsSettingType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAlertRecipientsSettingTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAlertRecipientsSettingType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isCustomList]) {
    jsonDict[@".tag"] = @"custom_list";
  } else if ([valueObj isInvalid]) {
    jsonDict[@".tag"] = @"invalid";
  } else if ([valueObj isNone]) {
    jsonDict[@".tag"] = @"none";
  } else if ([valueObj isTeamAdmins]) {
    jsonDict[@".tag"] = @"team_admins";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAlertRecipientsSettingType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"custom_list"]) {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithCustomList];
  } else if ([tag isEqualToString:@"invalid"]) {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithInvalid];
  } else if ([tag isEqualToString:@"none"]) {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithNone];
  } else if ([tag isEqualToString:@"team_admins"]) {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithTeamAdmins];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAlertRecipientsSettingType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAllowDownloadDisabledDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAllowDownloadDisabledDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAllowDownloadDisabledDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAllowDownloadDisabledDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAllowDownloadDisabledDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAllowDownloadDisabledDetails:other];
}

- (BOOL)isEqualToAllowDownloadDisabledDetails:(DBTEAMLOGAllowDownloadDisabledDetails *)anAllowDownloadDisabledDetails {
  if (self == anAllowDownloadDisabledDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAllowDownloadDisabledDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAllowDownloadDisabledDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAllowDownloadDisabledDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGAllowDownloadDisabledDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAllowDownloadDisabledType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAllowDownloadDisabledType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAllowDownloadDisabledTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAllowDownloadDisabledTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAllowDownloadDisabledTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAllowDownloadDisabledType:other];
}

- (BOOL)isEqualToAllowDownloadDisabledType:(DBTEAMLOGAllowDownloadDisabledType *)anAllowDownloadDisabledType {
  if (self == anAllowDownloadDisabledType) {
    return YES;
  }
  if (![self.description_ isEqual:anAllowDownloadDisabledType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAllowDownloadDisabledTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAllowDownloadDisabledType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAllowDownloadDisabledType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAllowDownloadDisabledType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAllowDownloadEnabledDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAllowDownloadEnabledDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAllowDownloadEnabledDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAllowDownloadEnabledDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAllowDownloadEnabledDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAllowDownloadEnabledDetails:other];
}

- (BOOL)isEqualToAllowDownloadEnabledDetails:(DBTEAMLOGAllowDownloadEnabledDetails *)anAllowDownloadEnabledDetails {
  if (self == anAllowDownloadEnabledDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAllowDownloadEnabledDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAllowDownloadEnabledDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAllowDownloadEnabledDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGAllowDownloadEnabledDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAllowDownloadEnabledType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAllowDownloadEnabledType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAllowDownloadEnabledTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAllowDownloadEnabledTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAllowDownloadEnabledTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAllowDownloadEnabledType:other];
}

- (BOOL)isEqualToAllowDownloadEnabledType:(DBTEAMLOGAllowDownloadEnabledType *)anAllowDownloadEnabledType {
  if (self == anAllowDownloadEnabledType) {
    return YES;
  }
  if (![self.description_ isEqual:anAllowDownloadEnabledType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAllowDownloadEnabledTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAllowDownloadEnabledType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAllowDownloadEnabledType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAllowDownloadEnabledType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGApiSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGApiSessionLogInfo

#pragma mark - Constructors

- (instancetype)initWithRequestId:(NSString *)requestId {
  [DBStoneValidators nonnullValidator:nil](requestId);

  self = [super init];
  if (self) {
    _requestId = requestId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGApiSessionLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGApiSessionLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGApiSessionLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.requestId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToApiSessionLogInfo:other];
}

- (BOOL)isEqualToApiSessionLogInfo:(DBTEAMLOGApiSessionLogInfo *)anApiSessionLogInfo {
  if (self == anApiSessionLogInfo) {
    return YES;
  }
  if (![self.requestId isEqual:anApiSessionLogInfo.requestId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGApiSessionLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGApiSessionLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"request_id"] = valueObj.requestId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGApiSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *requestId = valueDict[@"request_id"];

  return [[DBTEAMLOGApiSessionLogInfo alloc] initWithRequestId:requestId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLinkTeamDetails.h"
#import "DBTEAMLOGAppLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppLinkTeamDetails

#pragma mark - Constructors

- (instancetype)initWithAppInfo:(DBTEAMLOGAppLogInfo *)appInfo {
  [DBStoneValidators nonnullValidator:nil](appInfo);

  self = [super init];
  if (self) {
    _appInfo = appInfo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppLinkTeamDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppLinkTeamDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppLinkTeamDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appInfo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppLinkTeamDetails:other];
}

- (BOOL)isEqualToAppLinkTeamDetails:(DBTEAMLOGAppLinkTeamDetails *)anAppLinkTeamDetails {
  if (self == anAppLinkTeamDetails) {
    return YES;
  }
  if (![self.appInfo isEqual:anAppLinkTeamDetails.appInfo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppLinkTeamDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppLinkTeamDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_info"] = [DBTEAMLOGAppLogInfoSerializer serialize:valueObj.appInfo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppLinkTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAppLogInfo *appInfo = [DBTEAMLOGAppLogInfoSerializer deserialize:valueDict[@"app_info"]];

  return [[DBTEAMLOGAppLinkTeamDetails alloc] initWithAppInfo:appInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLinkTeamType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppLinkTeamType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppLinkTeamTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppLinkTeamTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppLinkTeamTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppLinkTeamType:other];
}

- (BOOL)isEqualToAppLinkTeamType:(DBTEAMLOGAppLinkTeamType *)anAppLinkTeamType {
  if (self == anAppLinkTeamType) {
    return YES;
  }
  if (![self.description_ isEqual:anAppLinkTeamType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppLinkTeamTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppLinkTeamType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppLinkTeamType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAppLinkTeamType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLinkUserDetails.h"
#import "DBTEAMLOGAppLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppLinkUserDetails

#pragma mark - Constructors

- (instancetype)initWithAppInfo:(DBTEAMLOGAppLogInfo *)appInfo {
  [DBStoneValidators nonnullValidator:nil](appInfo);

  self = [super init];
  if (self) {
    _appInfo = appInfo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppLinkUserDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppLinkUserDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppLinkUserDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appInfo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppLinkUserDetails:other];
}

- (BOOL)isEqualToAppLinkUserDetails:(DBTEAMLOGAppLinkUserDetails *)anAppLinkUserDetails {
  if (self == anAppLinkUserDetails) {
    return YES;
  }
  if (![self.appInfo isEqual:anAppLinkUserDetails.appInfo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppLinkUserDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppLinkUserDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_info"] = [DBTEAMLOGAppLogInfoSerializer serialize:valueObj.appInfo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppLinkUserDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAppLogInfo *appInfo = [DBTEAMLOGAppLogInfoSerializer deserialize:valueDict[@"app_info"]];

  return [[DBTEAMLOGAppLinkUserDetails alloc] initWithAppInfo:appInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLinkUserType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppLinkUserType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppLinkUserTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppLinkUserTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppLinkUserTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppLinkUserType:other];
}

- (BOOL)isEqualToAppLinkUserType:(DBTEAMLOGAppLinkUserType *)anAppLinkUserType {
  if (self == anAppLinkUserType) {
    return YES;
  }
  if (![self.description_ isEqual:anAppLinkUserType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppLinkUserTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppLinkUserType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppLinkUserType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAppLinkUserType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLogInfo.h"
#import "DBTEAMLOGTeamLinkedAppLogInfo.h"
#import "DBTEAMLOGUserLinkedAppLogInfo.h"
#import "DBTEAMLOGUserOrTeamLinkedAppLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppLogInfo

#pragma mark - Constructors

- (instancetype)initWithAppId:(NSString *)appId displayName:(NSString *)displayName {

  self = [super init];
  if (self) {
    _appId = appId;
    _displayName = displayName;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithAppId:nil displayName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.appId != nil) {
    result = prime * result + [self.appId hash];
  }
  if (self.displayName != nil) {
    result = prime * result + [self.displayName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppLogInfo:other];
}

- (BOOL)isEqualToAppLogInfo:(DBTEAMLOGAppLogInfo *)anAppLogInfo {
  if (self == anAppLogInfo) {
    return YES;
  }
  if (self.appId) {
    if (![self.appId isEqual:anAppLogInfo.appId]) {
      return NO;
    }
  }
  if (self.displayName) {
    if (![self.displayName isEqual:anAppLogInfo.displayName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.appId) {
    jsonDict[@"app_id"] = valueObj.appId;
  }
  if (valueObj.displayName) {
    jsonDict[@"display_name"] = valueObj.displayName;
  }

  if ([valueObj isKindOfClass:[DBTEAMLOGUserOrTeamLinkedAppLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGUserOrTeamLinkedAppLogInfoSerializer serialize:(DBTEAMLOGUserOrTeamLinkedAppLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"userOrTeamLinkedApp";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGUserLinkedAppLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGUserLinkedAppLogInfoSerializer serialize:(DBTEAMLOGUserLinkedAppLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"userLinkedApp";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGTeamLinkedAppLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGTeamLinkedAppLogInfoSerializer serialize:(DBTEAMLOGTeamLinkedAppLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"teamLinkedApp";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"user_or_team_linked_app"]) {
    return [DBTEAMLOGUserOrTeamLinkedAppLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"user_linked_app"]) {
    return [DBTEAMLOGUserLinkedAppLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"team_linked_app"]) {
    return [DBTEAMLOGTeamLinkedAppLogInfoSerializer deserialize:valueDict];
  }

  NSString *appId = valueDict[@"app_id"] ?: nil;
  NSString *displayName = valueDict[@"display_name"] ?: nil;

  return [[DBTEAMLOGAppLogInfo alloc] initWithAppId:appId displayName:displayName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLogInfo.h"
#import "DBTEAMLOGAppUnlinkTeamDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppUnlinkTeamDetails

#pragma mark - Constructors

- (instancetype)initWithAppInfo:(DBTEAMLOGAppLogInfo *)appInfo {
  [DBStoneValidators nonnullValidator:nil](appInfo);

  self = [super init];
  if (self) {
    _appInfo = appInfo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppUnlinkTeamDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppUnlinkTeamDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppUnlinkTeamDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appInfo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppUnlinkTeamDetails:other];
}

- (BOOL)isEqualToAppUnlinkTeamDetails:(DBTEAMLOGAppUnlinkTeamDetails *)anAppUnlinkTeamDetails {
  if (self == anAppUnlinkTeamDetails) {
    return YES;
  }
  if (![self.appInfo isEqual:anAppUnlinkTeamDetails.appInfo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppUnlinkTeamDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppUnlinkTeamDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_info"] = [DBTEAMLOGAppLogInfoSerializer serialize:valueObj.appInfo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppUnlinkTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAppLogInfo *appInfo = [DBTEAMLOGAppLogInfoSerializer deserialize:valueDict[@"app_info"]];

  return [[DBTEAMLOGAppUnlinkTeamDetails alloc] initWithAppInfo:appInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppUnlinkTeamType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppUnlinkTeamType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppUnlinkTeamTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppUnlinkTeamTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppUnlinkTeamTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppUnlinkTeamType:other];
}

- (BOOL)isEqualToAppUnlinkTeamType:(DBTEAMLOGAppUnlinkTeamType *)anAppUnlinkTeamType {
  if (self == anAppUnlinkTeamType) {
    return YES;
  }
  if (![self.description_ isEqual:anAppUnlinkTeamType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppUnlinkTeamTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppUnlinkTeamType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppUnlinkTeamType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAppUnlinkTeamType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppLogInfo.h"
#import "DBTEAMLOGAppUnlinkUserDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppUnlinkUserDetails

#pragma mark - Constructors

- (instancetype)initWithAppInfo:(DBTEAMLOGAppLogInfo *)appInfo {
  [DBStoneValidators nonnullValidator:nil](appInfo);

  self = [super init];
  if (self) {
    _appInfo = appInfo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppUnlinkUserDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppUnlinkUserDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppUnlinkUserDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.appInfo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppUnlinkUserDetails:other];
}

- (BOOL)isEqualToAppUnlinkUserDetails:(DBTEAMLOGAppUnlinkUserDetails *)anAppUnlinkUserDetails {
  if (self == anAppUnlinkUserDetails) {
    return YES;
  }
  if (![self.appInfo isEqual:anAppUnlinkUserDetails.appInfo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppUnlinkUserDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppUnlinkUserDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"app_info"] = [DBTEAMLOGAppLogInfoSerializer serialize:valueObj.appInfo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppUnlinkUserDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGAppLogInfo *appInfo = [DBTEAMLOGAppLogInfoSerializer deserialize:valueDict[@"app_info"]];

  return [[DBTEAMLOGAppUnlinkUserDetails alloc] initWithAppInfo:appInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAppUnlinkUserType.h"

#pragma mark - API Object

@implementation DBTEAMLOGAppUnlinkUserType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAppUnlinkUserTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAppUnlinkUserTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAppUnlinkUserTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAppUnlinkUserType:other];
}

- (BOOL)isEqualToAppUnlinkUserType:(DBTEAMLOGAppUnlinkUserType *)anAppUnlinkUserType {
  if (self == anAppUnlinkUserType) {
    return YES;
  }
  if (![self.description_ isEqual:anAppUnlinkUserType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAppUnlinkUserTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAppUnlinkUserType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAppUnlinkUserType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGAppUnlinkUserType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAssetLogInfo.h"
#import "DBTEAMLOGFileLogInfo.h"
#import "DBTEAMLOGFolderLogInfo.h"
#import "DBTEAMLOGPaperDocumentLogInfo.h"
#import "DBTEAMLOGPaperFolderLogInfo.h"
#import "DBTEAMLOGShowcaseDocumentLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGAssetLogInfo

@synthesize file = _file;
@synthesize folder = _folder;
@synthesize paperDocument = _paperDocument;
@synthesize paperFolder = _paperFolder;
@synthesize showcaseDocument = _showcaseDocument;

#pragma mark - Constructors

- (instancetype)initWithFile:(DBTEAMLOGFileLogInfo *)file {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoFile;
    _file = file;
  }
  return self;
}

- (instancetype)initWithFolder:(DBTEAMLOGFolderLogInfo *)folder {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoFolder;
    _folder = folder;
  }
  return self;
}

- (instancetype)initWithPaperDocument:(DBTEAMLOGPaperDocumentLogInfo *)paperDocument {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoPaperDocument;
    _paperDocument = paperDocument;
  }
  return self;
}

- (instancetype)initWithPaperFolder:(DBTEAMLOGPaperFolderLogInfo *)paperFolder {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoPaperFolder;
    _paperFolder = paperFolder;
  }
  return self;
}

- (instancetype)initWithShowcaseDocument:(DBTEAMLOGShowcaseDocumentLogInfo *)showcaseDocument {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoShowcaseDocument;
    _showcaseDocument = showcaseDocument;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGAssetLogInfoOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGFileLogInfo *)file {
  if (![self isFile]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAssetLogInfoFile, but was %@.", [self tagName]];
  }
  return _file;
}

- (DBTEAMLOGFolderLogInfo *)folder {
  if (![self isFolder]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAssetLogInfoFolder, but was %@.", [self tagName]];
  }
  return _folder;
}

- (DBTEAMLOGPaperDocumentLogInfo *)paperDocument {
  if (![self isPaperDocument]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAssetLogInfoPaperDocument, but was %@.", [self tagName]];
  }
  return _paperDocument;
}

- (DBTEAMLOGPaperFolderLogInfo *)paperFolder {
  if (![self isPaperFolder]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAssetLogInfoPaperFolder, but was %@.", [self tagName]];
  }
  return _paperFolder;
}

- (DBTEAMLOGShowcaseDocumentLogInfo *)showcaseDocument {
  if (![self isShowcaseDocument]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGAssetLogInfoShowcaseDocument, but was %@.", [self tagName]];
  }
  return _showcaseDocument;
}

#pragma mark - Tag state methods

- (BOOL)isFile {
  return _tag == DBTEAMLOGAssetLogInfoFile;
}

- (BOOL)isFolder {
  return _tag == DBTEAMLOGAssetLogInfoFolder;
}

- (BOOL)isPaperDocument {
  return _tag == DBTEAMLOGAssetLogInfoPaperDocument;
}

- (BOOL)isPaperFolder {
  return _tag == DBTEAMLOGAssetLogInfoPaperFolder;
}

- (BOOL)isShowcaseDocument {
  return _tag == DBTEAMLOGAssetLogInfoShowcaseDocument;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGAssetLogInfoOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGAssetLogInfoFile:
    return @"DBTEAMLOGAssetLogInfoFile";
  case DBTEAMLOGAssetLogInfoFolder:
    return @"DBTEAMLOGAssetLogInfoFolder";
  case DBTEAMLOGAssetLogInfoPaperDocument:
    return @"DBTEAMLOGAssetLogInfoPaperDocument";
  case DBTEAMLOGAssetLogInfoPaperFolder:
    return @"DBTEAMLOGAssetLogInfoPaperFolder";
  case DBTEAMLOGAssetLogInfoShowcaseDocument:
    return @"DBTEAMLOGAssetLogInfoShowcaseDocument";
  case DBTEAMLOGAssetLogInfoOther:
    return @"DBTEAMLOGAssetLogInfoOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGAssetLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGAssetLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGAssetLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGAssetLogInfoFile:
    result = prime * result + [self.file hash];
    break;
  case DBTEAMLOGAssetLogInfoFolder:
    result = prime * result + [self.folder hash];
    break;
  case DBTEAMLOGAssetLogInfoPaperDocument:
    result = prime * result + [self.paperDocument hash];
    break;
  case DBTEAMLOGAssetLogInfoPaperFolder:
    result = prime * result + [self.paperFolder hash];
    break;
  case DBTEAMLOGAssetLogInfoShowcaseDocument:
    result = prime * result + [self.showcaseDocument hash];
    break;
  case DBTEAMLOGAssetLogInfoOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAssetLogInfo:other];
}

- (BOOL)isEqualToAssetLogInfo:(DBTEAMLOGAssetLogInfo *)anAssetLogInfo {
  if (self == anAssetLogInfo) {
    return YES;
  }
  if (self.tag != anAssetLogInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGAssetLogInfoFile:
    return [self.file isEqual:anAssetLogInfo.file];
  case DBTEAMLOGAssetLogInfoFolder:
    return [self.folder isEqual:anAssetLogInfo.folder];
  case DBTEAMLOGAssetLogInfoPaperDocument:
    return [self.paperDocument isEqual:anAssetLogInfo.paperDocument];
  case DBTEAMLOGAssetLogInfoPaperFolder:
    return [self.paperFolder isEqual:anAssetLogInfo.paperFolder];
  case DBTEAMLOGAssetLogInfoShowcaseDocument:
    return [self.showcaseDocument isEqual:anAssetLogInfo.showcaseDocument];
  case DBTEAMLOGAssetLogInfoOther:
    return [[self tagName] isEqual:[anAssetLogInfo tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGAssetLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGAssetLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFile]) {
    jsonDict = [[DBTEAMLOGFileLogInfoSerializer serialize:valueObj.file] mutableCopy];
    jsonDict[@".tag"] = @"file";
  } else if ([valueObj isFolder]) {
    jsonDict = [[DBTEAMLOGFolderLogInfoSerializer serialize:valueObj.folder] mutableCopy];
    jsonDict[@".tag"] = @"folder";
  } else if ([valueObj isPaperDocument]) {
    jsonDict = [[DBTEAMLOGPaperDocumentLogInfoSerializer serialize:valueObj.paperDocument] mutableCopy];
    jsonDict[@".tag"] = @"paper_document";
  } else if ([valueObj isPaperFolder]) {
    jsonDict = [[DBTEAMLOGPaperFolderLogInfoSerializer serialize:valueObj.paperFolder] mutableCopy];
    jsonDict[@".tag"] = @"paper_folder";
  } else if ([valueObj isShowcaseDocument]) {
    jsonDict = [[DBTEAMLOGShowcaseDocumentLogInfoSerializer serialize:valueObj.showcaseDocument] mutableCopy];
    jsonDict[@".tag"] = @"showcase_document";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGAssetLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"file"]) {
    DBTEAMLOGFileLogInfo *file = [DBTEAMLOGFileLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAssetLogInfo alloc] initWithFile:file];
  } else if ([tag isEqualToString:@"folder"]) {
    DBTEAMLOGFolderLogInfo *folder = [DBTEAMLOGFolderLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAssetLogInfo alloc] initWithFolder:folder];
  } else if ([tag isEqualToString:@"paper_document"]) {
    DBTEAMLOGPaperDocumentLogInfo *paperDocument = [DBTEAMLOGPaperDocumentLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAssetLogInfo alloc] initWithPaperDocument:paperDocument];
  } else if ([tag isEqualToString:@"paper_folder"]) {
    DBTEAMLOGPaperFolderLogInfo *paperFolder = [DBTEAMLOGPaperFolderLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAssetLogInfo alloc] initWithPaperFolder:paperFolder];
  } else if ([tag isEqualToString:@"showcase_document"]) {
    DBTEAMLOGShowcaseDocumentLogInfo *showcaseDocument =
        [DBTEAMLOGShowcaseDocumentLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGAssetLogInfo alloc] initWithShowcaseDocument:showcaseDocument];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGAssetLogInfo alloc] initWithOther];
  } else {
    return [[DBTEAMLOGAssetLogInfo alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBackupStatus.h"

#pragma mark - API Object

@implementation DBTEAMLOGBackupStatus

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGBackupStatusDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGBackupStatusEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGBackupStatusOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGBackupStatusDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMLOGBackupStatusEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGBackupStatusOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGBackupStatusDisabled:
    return @"DBTEAMLOGBackupStatusDisabled";
  case DBTEAMLOGBackupStatusEnabled:
    return @"DBTEAMLOGBackupStatusEnabled";
  case DBTEAMLOGBackupStatusOther:
    return @"DBTEAMLOGBackupStatusOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBackupStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBackupStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBackupStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGBackupStatusDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGBackupStatusEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGBackupStatusOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBackupStatus:other];
}

- (BOOL)isEqualToBackupStatus:(DBTEAMLOGBackupStatus *)aBackupStatus {
  if (self == aBackupStatus) {
    return YES;
  }
  if (self.tag != aBackupStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGBackupStatusDisabled:
    return [[self tagName] isEqual:[aBackupStatus tagName]];
  case DBTEAMLOGBackupStatusEnabled:
    return [[self tagName] isEqual:[aBackupStatus tagName]];
  case DBTEAMLOGBackupStatusOther:
    return [[self tagName] isEqual:[aBackupStatus tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBackupStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBackupStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBackupStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGBackupStatus alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMLOGBackupStatus alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGBackupStatus alloc] initWithOther];
  } else {
    return [[DBTEAMLOGBackupStatus alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderAddPageDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderAddPageDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderAddPageDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderAddPageDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderAddPageDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderAddPageDetails:other];
}

- (BOOL)isEqualToBinderAddPageDetails:(DBTEAMLOGBinderAddPageDetails *)aBinderAddPageDetails {
  if (self == aBinderAddPageDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderAddPageDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderAddPageDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderAddPageDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderAddPageDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderAddPageDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderAddPageDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderAddPageDetails alloc] initWithEventUuid:eventUuid
                                                         docTitle:docTitle
                                                   binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderAddPageType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderAddPageType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderAddPageTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderAddPageTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderAddPageTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderAddPageType:other];
}

- (BOOL)isEqualToBinderAddPageType:(DBTEAMLOGBinderAddPageType *)aBinderAddPageType {
  if (self == aBinderAddPageType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderAddPageType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderAddPageTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderAddPageType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderAddPageType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderAddPageType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderAddSectionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderAddSectionDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderAddSectionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderAddSectionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderAddSectionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderAddSectionDetails:other];
}

- (BOOL)isEqualToBinderAddSectionDetails:(DBTEAMLOGBinderAddSectionDetails *)aBinderAddSectionDetails {
  if (self == aBinderAddSectionDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderAddSectionDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderAddSectionDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderAddSectionDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderAddSectionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderAddSectionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderAddSectionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderAddSectionDetails alloc] initWithEventUuid:eventUuid
                                                            docTitle:docTitle
                                                      binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderAddSectionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderAddSectionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderAddSectionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderAddSectionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderAddSectionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderAddSectionType:other];
}

- (BOOL)isEqualToBinderAddSectionType:(DBTEAMLOGBinderAddSectionType *)aBinderAddSectionType {
  if (self == aBinderAddSectionType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderAddSectionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderAddSectionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderAddSectionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderAddSectionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderAddSectionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRemovePageDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRemovePageDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRemovePageDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRemovePageDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRemovePageDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRemovePageDetails:other];
}

- (BOOL)isEqualToBinderRemovePageDetails:(DBTEAMLOGBinderRemovePageDetails *)aBinderRemovePageDetails {
  if (self == aBinderRemovePageDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderRemovePageDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderRemovePageDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderRemovePageDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRemovePageDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRemovePageDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRemovePageDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderRemovePageDetails alloc] initWithEventUuid:eventUuid
                                                            docTitle:docTitle
                                                      binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRemovePageType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRemovePageType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRemovePageTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRemovePageTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRemovePageTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRemovePageType:other];
}

- (BOOL)isEqualToBinderRemovePageType:(DBTEAMLOGBinderRemovePageType *)aBinderRemovePageType {
  if (self == aBinderRemovePageType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderRemovePageType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRemovePageTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRemovePageType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRemovePageType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderRemovePageType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRemoveSectionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRemoveSectionDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRemoveSectionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRemoveSectionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRemoveSectionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRemoveSectionDetails:other];
}

- (BOOL)isEqualToBinderRemoveSectionDetails:(DBTEAMLOGBinderRemoveSectionDetails *)aBinderRemoveSectionDetails {
  if (self == aBinderRemoveSectionDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderRemoveSectionDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderRemoveSectionDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderRemoveSectionDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRemoveSectionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRemoveSectionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRemoveSectionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderRemoveSectionDetails alloc] initWithEventUuid:eventUuid
                                                               docTitle:docTitle
                                                         binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRemoveSectionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRemoveSectionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRemoveSectionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRemoveSectionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRemoveSectionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRemoveSectionType:other];
}

- (BOOL)isEqualToBinderRemoveSectionType:(DBTEAMLOGBinderRemoveSectionType *)aBinderRemoveSectionType {
  if (self == aBinderRemoveSectionType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderRemoveSectionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRemoveSectionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRemoveSectionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRemoveSectionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderRemoveSectionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRenamePageDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRenamePageDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName
           previousBinderItemName:(NSString *)previousBinderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
    _previousBinderItemName = previousBinderItemName;
  }
  return self;
}

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  return [self initWithEventUuid:eventUuid docTitle:docTitle binderItemName:binderItemName previousBinderItemName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRenamePageDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRenamePageDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRenamePageDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];
  if (self.previousBinderItemName != nil) {
    result = prime * result + [self.previousBinderItemName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRenamePageDetails:other];
}

- (BOOL)isEqualToBinderRenamePageDetails:(DBTEAMLOGBinderRenamePageDetails *)aBinderRenamePageDetails {
  if (self == aBinderRenamePageDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderRenamePageDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderRenamePageDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderRenamePageDetails.binderItemName]) {
    return NO;
  }
  if (self.previousBinderItemName) {
    if (![self.previousBinderItemName isEqual:aBinderRenamePageDetails.previousBinderItemName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRenamePageDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRenamePageDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;
  if (valueObj.previousBinderItemName) {
    jsonDict[@"previous_binder_item_name"] = valueObj.previousBinderItemName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRenamePageDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];
  NSString *previousBinderItemName = valueDict[@"previous_binder_item_name"] ?: nil;

  return [[DBTEAMLOGBinderRenamePageDetails alloc] initWithEventUuid:eventUuid
                                                            docTitle:docTitle
                                                      binderItemName:binderItemName
                                              previousBinderItemName:previousBinderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRenamePageType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRenamePageType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRenamePageTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRenamePageTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRenamePageTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRenamePageType:other];
}

- (BOOL)isEqualToBinderRenamePageType:(DBTEAMLOGBinderRenamePageType *)aBinderRenamePageType {
  if (self == aBinderRenamePageType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderRenamePageType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRenamePageTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRenamePageType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRenamePageType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderRenamePageType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRenameSectionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRenameSectionDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName
           previousBinderItemName:(NSString *)previousBinderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
    _previousBinderItemName = previousBinderItemName;
  }
  return self;
}

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  return [self initWithEventUuid:eventUuid docTitle:docTitle binderItemName:binderItemName previousBinderItemName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRenameSectionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRenameSectionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRenameSectionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];
  if (self.previousBinderItemName != nil) {
    result = prime * result + [self.previousBinderItemName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRenameSectionDetails:other];
}

- (BOOL)isEqualToBinderRenameSectionDetails:(DBTEAMLOGBinderRenameSectionDetails *)aBinderRenameSectionDetails {
  if (self == aBinderRenameSectionDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderRenameSectionDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderRenameSectionDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderRenameSectionDetails.binderItemName]) {
    return NO;
  }
  if (self.previousBinderItemName) {
    if (![self.previousBinderItemName isEqual:aBinderRenameSectionDetails.previousBinderItemName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRenameSectionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRenameSectionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;
  if (valueObj.previousBinderItemName) {
    jsonDict[@"previous_binder_item_name"] = valueObj.previousBinderItemName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRenameSectionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];
  NSString *previousBinderItemName = valueDict[@"previous_binder_item_name"] ?: nil;

  return [[DBTEAMLOGBinderRenameSectionDetails alloc] initWithEventUuid:eventUuid
                                                               docTitle:docTitle
                                                         binderItemName:binderItemName
                                                 previousBinderItemName:previousBinderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderRenameSectionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderRenameSectionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderRenameSectionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderRenameSectionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderRenameSectionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderRenameSectionType:other];
}

- (BOOL)isEqualToBinderRenameSectionType:(DBTEAMLOGBinderRenameSectionType *)aBinderRenameSectionType {
  if (self == aBinderRenameSectionType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderRenameSectionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderRenameSectionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderRenameSectionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderRenameSectionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderRenameSectionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderReorderPageDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderReorderPageDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderReorderPageDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderReorderPageDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderReorderPageDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderReorderPageDetails:other];
}

- (BOOL)isEqualToBinderReorderPageDetails:(DBTEAMLOGBinderReorderPageDetails *)aBinderReorderPageDetails {
  if (self == aBinderReorderPageDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderReorderPageDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderReorderPageDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderReorderPageDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderReorderPageDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderReorderPageDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderReorderPageDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderReorderPageDetails alloc] initWithEventUuid:eventUuid
                                                             docTitle:docTitle
                                                       binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderReorderPageType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderReorderPageType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderReorderPageTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderReorderPageTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderReorderPageTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderReorderPageType:other];
}

- (BOOL)isEqualToBinderReorderPageType:(DBTEAMLOGBinderReorderPageType *)aBinderReorderPageType {
  if (self == aBinderReorderPageType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderReorderPageType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderReorderPageTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderReorderPageType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderReorderPageType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderReorderPageType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderReorderSectionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderReorderSectionDetails

#pragma mark - Constructors

- (instancetype)initWithEventUuid:(NSString *)eventUuid
                         docTitle:(NSString *)docTitle
                   binderItemName:(NSString *)binderItemName {
  [DBStoneValidators nonnullValidator:nil](eventUuid);
  [DBStoneValidators nonnullValidator:nil](docTitle);
  [DBStoneValidators nonnullValidator:nil](binderItemName);

  self = [super init];
  if (self) {
    _eventUuid = eventUuid;
    _docTitle = docTitle;
    _binderItemName = binderItemName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderReorderSectionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderReorderSectionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderReorderSectionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.eventUuid hash];
  result = prime * result + [self.docTitle hash];
  result = prime * result + [self.binderItemName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderReorderSectionDetails:other];
}

- (BOOL)isEqualToBinderReorderSectionDetails:(DBTEAMLOGBinderReorderSectionDetails *)aBinderReorderSectionDetails {
  if (self == aBinderReorderSectionDetails) {
    return YES;
  }
  if (![self.eventUuid isEqual:aBinderReorderSectionDetails.eventUuid]) {
    return NO;
  }
  if (![self.docTitle isEqual:aBinderReorderSectionDetails.docTitle]) {
    return NO;
  }
  if (![self.binderItemName isEqual:aBinderReorderSectionDetails.binderItemName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderReorderSectionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderReorderSectionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"event_uuid"] = valueObj.eventUuid;
  jsonDict[@"doc_title"] = valueObj.docTitle;
  jsonDict[@"binder_item_name"] = valueObj.binderItemName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderReorderSectionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *eventUuid = valueDict[@"event_uuid"];
  NSString *docTitle = valueDict[@"doc_title"];
  NSString *binderItemName = valueDict[@"binder_item_name"];

  return [[DBTEAMLOGBinderReorderSectionDetails alloc] initWithEventUuid:eventUuid
                                                                docTitle:docTitle
                                                          binderItemName:binderItemName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBinderReorderSectionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGBinderReorderSectionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGBinderReorderSectionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGBinderReorderSectionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGBinderReorderSectionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToBinderReorderSectionType:other];
}

- (BOOL)isEqualToBinderReorderSectionType:(DBTEAMLOGBinderReorderSectionType *)aBinderReorderSectionType {
  if (self == aBinderReorderSectionType) {
    return YES;
  }
  if (![self.description_ isEqual:aBinderReorderSectionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGBinderReorderSectionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGBinderReorderSectionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGBinderReorderSectionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGBinderReorderSectionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCameraUploadsPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGCameraUploadsPolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGCameraUploadsPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGCameraUploadsPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGCameraUploadsPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGCameraUploadsPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMLOGCameraUploadsPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGCameraUploadsPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGCameraUploadsPolicyDisabled:
    return @"DBTEAMLOGCameraUploadsPolicyDisabled";
  case DBTEAMLOGCameraUploadsPolicyEnabled:
    return @"DBTEAMLOGCameraUploadsPolicyEnabled";
  case DBTEAMLOGCameraUploadsPolicyOther:
    return @"DBTEAMLOGCameraUploadsPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCameraUploadsPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCameraUploadsPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCameraUploadsPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGCameraUploadsPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGCameraUploadsPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGCameraUploadsPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCameraUploadsPolicy:other];
}

- (BOOL)isEqualToCameraUploadsPolicy:(DBTEAMLOGCameraUploadsPolicy *)aCameraUploadsPolicy {
  if (self == aCameraUploadsPolicy) {
    return YES;
  }
  if (self.tag != aCameraUploadsPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGCameraUploadsPolicyDisabled:
    return [[self tagName] isEqual:[aCameraUploadsPolicy tagName]];
  case DBTEAMLOGCameraUploadsPolicyEnabled:
    return [[self tagName] isEqual:[aCameraUploadsPolicy tagName]];
  case DBTEAMLOGCameraUploadsPolicyOther:
    return [[self tagName] isEqual:[aCameraUploadsPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCameraUploadsPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCameraUploadsPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCameraUploadsPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGCameraUploadsPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMLOGCameraUploadsPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGCameraUploadsPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGCameraUploadsPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCameraUploadsPolicy.h"
#import "DBTEAMLOGCameraUploadsPolicyChangedDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGCameraUploadsPolicyChangedDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGCameraUploadsPolicy *)dNewValue
                    previousValue:(DBTEAMLOGCameraUploadsPolicy *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);
  [DBStoneValidators nonnullValidator:nil](previousValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCameraUploadsPolicyChangedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCameraUploadsPolicyChangedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCameraUploadsPolicyChangedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  result = prime * result + [self.previousValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCameraUploadsPolicyChangedDetails:other];
}

- (BOOL)isEqualToCameraUploadsPolicyChangedDetails:
    (DBTEAMLOGCameraUploadsPolicyChangedDetails *)aCameraUploadsPolicyChangedDetails {
  if (self == aCameraUploadsPolicyChangedDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:aCameraUploadsPolicyChangedDetails.dNewValue]) {
    return NO;
  }
  if (![self.previousValue isEqual:aCameraUploadsPolicyChangedDetails.previousValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCameraUploadsPolicyChangedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCameraUploadsPolicyChangedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = [DBTEAMLOGCameraUploadsPolicySerializer serialize:valueObj.dNewValue];
  jsonDict[@"previous_value"] = [DBTEAMLOGCameraUploadsPolicySerializer serialize:valueObj.previousValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCameraUploadsPolicyChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGCameraUploadsPolicy *dNewValue =
      [DBTEAMLOGCameraUploadsPolicySerializer deserialize:valueDict[@"new_value"]];
  DBTEAMLOGCameraUploadsPolicy *previousValue =
      [DBTEAMLOGCameraUploadsPolicySerializer deserialize:valueDict[@"previous_value"]];

  return [[DBTEAMLOGCameraUploadsPolicyChangedDetails alloc] initWithDNewValue:dNewValue previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCameraUploadsPolicyChangedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGCameraUploadsPolicyChangedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCameraUploadsPolicyChangedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCameraUploadsPolicyChangedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCameraUploadsPolicyChangedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCameraUploadsPolicyChangedType:other];
}

- (BOOL)isEqualToCameraUploadsPolicyChangedType:
    (DBTEAMLOGCameraUploadsPolicyChangedType *)aCameraUploadsPolicyChangedType {
  if (self == aCameraUploadsPolicyChangedType) {
    return YES;
  }
  if (![self.description_ isEqual:aCameraUploadsPolicyChangedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCameraUploadsPolicyChangedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCameraUploadsPolicyChangedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCameraUploadsPolicyChangedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGCameraUploadsPolicyChangedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCertificate.h"

#pragma mark - API Object

@implementation DBTEAMLOGCertificate

#pragma mark - Constructors

- (instancetype)initWithSubject:(NSString *)subject
                         issuer:(NSString *)issuer
                      issueDate:(NSString *)issueDate
                 expirationDate:(NSString *)expirationDate
                   serialNumber:(NSString *)serialNumber
                sha1Fingerprint:(NSString *)sha1Fingerprint
                     commonName:(NSString *)commonName {
  [DBStoneValidators nonnullValidator:nil](subject);
  [DBStoneValidators nonnullValidator:nil](issuer);
  [DBStoneValidators nonnullValidator:nil](issueDate);
  [DBStoneValidators nonnullValidator:nil](expirationDate);
  [DBStoneValidators nonnullValidator:nil](serialNumber);
  [DBStoneValidators nonnullValidator:nil](sha1Fingerprint);

  self = [super init];
  if (self) {
    _subject = subject;
    _issuer = issuer;
    _issueDate = issueDate;
    _expirationDate = expirationDate;
    _serialNumber = serialNumber;
    _sha1Fingerprint = sha1Fingerprint;
    _commonName = commonName;
  }
  return self;
}

- (instancetype)initWithSubject:(NSString *)subject
                         issuer:(NSString *)issuer
                      issueDate:(NSString *)issueDate
                 expirationDate:(NSString *)expirationDate
                   serialNumber:(NSString *)serialNumber
                sha1Fingerprint:(NSString *)sha1Fingerprint {
  return [self initWithSubject:subject
                        issuer:issuer
                     issueDate:issueDate
                expirationDate:expirationDate
                  serialNumber:serialNumber
               sha1Fingerprint:sha1Fingerprint
                    commonName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCertificateSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCertificateSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCertificateSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.subject hash];
  result = prime * result + [self.issuer hash];
  result = prime * result + [self.issueDate hash];
  result = prime * result + [self.expirationDate hash];
  result = prime * result + [self.serialNumber hash];
  result = prime * result + [self.sha1Fingerprint hash];
  if (self.commonName != nil) {
    result = prime * result + [self.commonName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCertificate:other];
}

- (BOOL)isEqualToCertificate:(DBTEAMLOGCertificate *)aCertificate {
  if (self == aCertificate) {
    return YES;
  }
  if (![self.subject isEqual:aCertificate.subject]) {
    return NO;
  }
  if (![self.issuer isEqual:aCertificate.issuer]) {
    return NO;
  }
  if (![self.issueDate isEqual:aCertificate.issueDate]) {
    return NO;
  }
  if (![self.expirationDate isEqual:aCertificate.expirationDate]) {
    return NO;
  }
  if (![self.serialNumber isEqual:aCertificate.serialNumber]) {
    return NO;
  }
  if (![self.sha1Fingerprint isEqual:aCertificate.sha1Fingerprint]) {
    return NO;
  }
  if (self.commonName) {
    if (![self.commonName isEqual:aCertificate.commonName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCertificateSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCertificate *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"subject"] = valueObj.subject;
  jsonDict[@"issuer"] = valueObj.issuer;
  jsonDict[@"issue_date"] = valueObj.issueDate;
  jsonDict[@"expiration_date"] = valueObj.expirationDate;
  jsonDict[@"serial_number"] = valueObj.serialNumber;
  jsonDict[@"sha1_fingerprint"] = valueObj.sha1Fingerprint;
  if (valueObj.commonName) {
    jsonDict[@"common_name"] = valueObj.commonName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCertificate *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *subject = valueDict[@"subject"];
  NSString *issuer = valueDict[@"issuer"];
  NSString *issueDate = valueDict[@"issue_date"];
  NSString *expirationDate = valueDict[@"expiration_date"];
  NSString *serialNumber = valueDict[@"serial_number"];
  NSString *sha1Fingerprint = valueDict[@"sha1_fingerprint"];
  NSString *commonName = valueDict[@"common_name"] ?: nil;

  return [[DBTEAMLOGCertificate alloc] initWithSubject:subject
                                                issuer:issuer
                                             issueDate:issueDate
                                        expirationDate:expirationDate
                                          serialNumber:serialNumber
                                       sha1Fingerprint:sha1Fingerprint
                                            commonName:commonName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGChangedEnterpriseAdminRoleDetails.h"
#import "DBTEAMLOGFedAdminRole.h"

#pragma mark - API Object

@implementation DBTEAMLOGChangedEnterpriseAdminRoleDetails

#pragma mark - Constructors

- (instancetype)initWithPreviousValue:(DBTEAMLOGFedAdminRole *)previousValue
                            dNewValue:(DBTEAMLOGFedAdminRole *)dNewValue
                             teamName:(NSString *)teamName {
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);
  [DBStoneValidators nonnullValidator:nil](teamName);

  self = [super init];
  if (self) {
    _previousValue = previousValue;
    _dNewValue = dNewValue;
    _teamName = teamName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGChangedEnterpriseAdminRoleDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGChangedEnterpriseAdminRoleDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGChangedEnterpriseAdminRoleDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];
  result = prime * result + [self.teamName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToChangedEnterpriseAdminRoleDetails:other];
}

- (BOOL)isEqualToChangedEnterpriseAdminRoleDetails:
    (DBTEAMLOGChangedEnterpriseAdminRoleDetails *)aChangedEnterpriseAdminRoleDetails {
  if (self == aChangedEnterpriseAdminRoleDetails) {
    return YES;
  }
  if (![self.previousValue isEqual:aChangedEnterpriseAdminRoleDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:aChangedEnterpriseAdminRoleDetails.dNewValue]) {
    return NO;
  }
  if (![self.teamName isEqual:aChangedEnterpriseAdminRoleDetails.teamName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGChangedEnterpriseAdminRoleDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGChangedEnterpriseAdminRoleDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"previous_value"] = [DBTEAMLOGFedAdminRoleSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGFedAdminRoleSerializer serialize:valueObj.dNewValue];
  jsonDict[@"team_name"] = valueObj.teamName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGChangedEnterpriseAdminRoleDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGFedAdminRole *previousValue = [DBTEAMLOGFedAdminRoleSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGFedAdminRole *dNewValue = [DBTEAMLOGFedAdminRoleSerializer deserialize:valueDict[@"new_value"]];
  NSString *teamName = valueDict[@"team_name"];

  return [[DBTEAMLOGChangedEnterpriseAdminRoleDetails alloc] initWithPreviousValue:previousValue
                                                                         dNewValue:dNewValue
                                                                          teamName:teamName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGChangedEnterpriseAdminRoleType.h"

#pragma mark - API Object

@implementation DBTEAMLOGChangedEnterpriseAdminRoleType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGChangedEnterpriseAdminRoleTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGChangedEnterpriseAdminRoleTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGChangedEnterpriseAdminRoleTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToChangedEnterpriseAdminRoleType:other];
}

- (BOOL)isEqualToChangedEnterpriseAdminRoleType:
    (DBTEAMLOGChangedEnterpriseAdminRoleType *)aChangedEnterpriseAdminRoleType {
  if (self == aChangedEnterpriseAdminRoleType) {
    return YES;
  }
  if (![self.description_ isEqual:aChangedEnterpriseAdminRoleType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGChangedEnterpriseAdminRoleTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGChangedEnterpriseAdminRoleType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGChangedEnterpriseAdminRoleType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGChangedEnterpriseAdminRoleType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails.h"
#import "DBTEAMLOGFedHandshakeAction.h"
#import "DBTEAMLOGFederationStatusChangeAdditionalInfo.h"
#import "DBTEAMLOGTrustedTeamsRequestState.h"

#pragma mark - API Object

@implementation DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails

#pragma mark - Constructors

- (instancetype)initWithAction:(DBTEAMLOGFedHandshakeAction *)action
                additionalInfo:(DBTEAMLOGFederationStatusChangeAdditionalInfo *)additionalInfo
                 previousValue:(DBTEAMLOGTrustedTeamsRequestState *)previousValue
                     dNewValue:(DBTEAMLOGTrustedTeamsRequestState *)dNewValue {
  [DBStoneValidators nonnullValidator:nil](action);
  [DBStoneValidators nonnullValidator:nil](additionalInfo);
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _action = action;
    _additionalInfo = additionalInfo;
    _previousValue = previousValue;
    _dNewValue = dNewValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.action hash];
  result = prime * result + [self.additionalInfo hash];
  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToChangedEnterpriseConnectedTeamStatusDetails:other];
}

- (BOOL)isEqualToChangedEnterpriseConnectedTeamStatusDetails:
    (DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails *)aChangedEnterpriseConnectedTeamStatusDetails {
  if (self == aChangedEnterpriseConnectedTeamStatusDetails) {
    return YES;
  }
  if (![self.action isEqual:aChangedEnterpriseConnectedTeamStatusDetails.action]) {
    return NO;
  }
  if (![self.additionalInfo isEqual:aChangedEnterpriseConnectedTeamStatusDetails.additionalInfo]) {
    return NO;
  }
  if (![self.previousValue isEqual:aChangedEnterpriseConnectedTeamStatusDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:aChangedEnterpriseConnectedTeamStatusDetails.dNewValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"action"] = [DBTEAMLOGFedHandshakeActionSerializer serialize:valueObj.action];
  jsonDict[@"additional_info"] =
      [DBTEAMLOGFederationStatusChangeAdditionalInfoSerializer serialize:valueObj.additionalInfo];
  jsonDict[@"previous_value"] = [DBTEAMLOGTrustedTeamsRequestStateSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGTrustedTeamsRequestStateSerializer serialize:valueObj.dNewValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGFedHandshakeAction *action = [DBTEAMLOGFedHandshakeActionSerializer deserialize:valueDict[@"action"]];
  DBTEAMLOGFederationStatusChangeAdditionalInfo *additionalInfo =
      [DBTEAMLOGFederationStatusChangeAdditionalInfoSerializer deserialize:valueDict[@"additional_info"]];
  DBTEAMLOGTrustedTeamsRequestState *previousValue =
      [DBTEAMLOGTrustedTeamsRequestStateSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGTrustedTeamsRequestState *dNewValue =
      [DBTEAMLOGTrustedTeamsRequestStateSerializer deserialize:valueDict[@"new_value"]];

  return [[DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails alloc] initWithAction:action
                                                                       additionalInfo:additionalInfo
                                                                        previousValue:previousValue
                                                                            dNewValue:dNewValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGChangedEnterpriseConnectedTeamStatusType.h"

#pragma mark - API Object

@implementation DBTEAMLOGChangedEnterpriseConnectedTeamStatusType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGChangedEnterpriseConnectedTeamStatusTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGChangedEnterpriseConnectedTeamStatusTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGChangedEnterpriseConnectedTeamStatusTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToChangedEnterpriseConnectedTeamStatusType:other];
}

- (BOOL)isEqualToChangedEnterpriseConnectedTeamStatusType:
    (DBTEAMLOGChangedEnterpriseConnectedTeamStatusType *)aChangedEnterpriseConnectedTeamStatusType {
  if (self == aChangedEnterpriseConnectedTeamStatusType) {
    return YES;
  }
  if (![self.description_ isEqual:aChangedEnterpriseConnectedTeamStatusType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGChangedEnterpriseConnectedTeamStatusTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGChangedEnterpriseConnectedTeamStatusType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGChangedEnterpriseConnectedTeamStatusType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGChangedEnterpriseConnectedTeamStatusType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationChangePolicyDetails.h"
#import "DBTEAMLOGClassificationPolicyEnumWrapper.h"
#import "DBTEAMLOGClassificationType.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationChangePolicyDetails

#pragma mark - Constructors

- (instancetype)initWithPreviousValue:(DBTEAMLOGClassificationPolicyEnumWrapper *)previousValue
                            dNewValue:(DBTEAMLOGClassificationPolicyEnumWrapper *)dNewValue
                   classificationType:(DBTEAMLOGClassificationType *)classificationType {
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);
  [DBStoneValidators nonnullValidator:nil](classificationType);

  self = [super init];
  if (self) {
    _previousValue = previousValue;
    _dNewValue = dNewValue;
    _classificationType = classificationType;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationChangePolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationChangePolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationChangePolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];
  result = prime * result + [self.classificationType hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationChangePolicyDetails:other];
}

- (BOOL)isEqualToClassificationChangePolicyDetails:
    (DBTEAMLOGClassificationChangePolicyDetails *)aClassificationChangePolicyDetails {
  if (self == aClassificationChangePolicyDetails) {
    return YES;
  }
  if (![self.previousValue isEqual:aClassificationChangePolicyDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:aClassificationChangePolicyDetails.dNewValue]) {
    return NO;
  }
  if (![self.classificationType isEqual:aClassificationChangePolicyDetails.classificationType]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationChangePolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationChangePolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"previous_value"] = [DBTEAMLOGClassificationPolicyEnumWrapperSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGClassificationPolicyEnumWrapperSerializer serialize:valueObj.dNewValue];
  jsonDict[@"classification_type"] = [DBTEAMLOGClassificationTypeSerializer serialize:valueObj.classificationType];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGClassificationPolicyEnumWrapper *previousValue =
      [DBTEAMLOGClassificationPolicyEnumWrapperSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGClassificationPolicyEnumWrapper *dNewValue =
      [DBTEAMLOGClassificationPolicyEnumWrapperSerializer deserialize:valueDict[@"new_value"]];
  DBTEAMLOGClassificationType *classificationType =
      [DBTEAMLOGClassificationTypeSerializer deserialize:valueDict[@"classification_type"]];

  return [[DBTEAMLOGClassificationChangePolicyDetails alloc] initWithPreviousValue:previousValue
                                                                         dNewValue:dNewValue
                                                                classificationType:classificationType];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationChangePolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationChangePolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationChangePolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationChangePolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationChangePolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationChangePolicyType:other];
}

- (BOOL)isEqualToClassificationChangePolicyType:
    (DBTEAMLOGClassificationChangePolicyType *)aClassificationChangePolicyType {
  if (self == aClassificationChangePolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:aClassificationChangePolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationChangePolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationChangePolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationChangePolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGClassificationChangePolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationCreateReportDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationCreateReportDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationCreateReportDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationCreateReportDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationCreateReportDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationCreateReportDetails:other];
}

- (BOOL)isEqualToClassificationCreateReportDetails:
    (DBTEAMLOGClassificationCreateReportDetails *)aClassificationCreateReportDetails {
  if (self == aClassificationCreateReportDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationCreateReportDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationCreateReportDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationCreateReportDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGClassificationCreateReportDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationCreateReportFailDetails.h"
#import "DBTEAMTeamReportFailureReason.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationCreateReportFailDetails

#pragma mark - Constructors

- (instancetype)initWithFailureReason:(DBTEAMTeamReportFailureReason *)failureReason {
  [DBStoneValidators nonnullValidator:nil](failureReason);

  self = [super init];
  if (self) {
    _failureReason = failureReason;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationCreateReportFailDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationCreateReportFailDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationCreateReportFailDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.failureReason hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationCreateReportFailDetails:other];
}

- (BOOL)isEqualToClassificationCreateReportFailDetails:
    (DBTEAMLOGClassificationCreateReportFailDetails *)aClassificationCreateReportFailDetails {
  if (self == aClassificationCreateReportFailDetails) {
    return YES;
  }
  if (![self.failureReason isEqual:aClassificationCreateReportFailDetails.failureReason]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationCreateReportFailDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationCreateReportFailDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"failure_reason"] = [DBTEAMTeamReportFailureReasonSerializer serialize:valueObj.failureReason];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationCreateReportFailDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMTeamReportFailureReason *failureReason =
      [DBTEAMTeamReportFailureReasonSerializer deserialize:valueDict[@"failure_reason"]];

  return [[DBTEAMLOGClassificationCreateReportFailDetails alloc] initWithFailureReason:failureReason];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationCreateReportFailType.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationCreateReportFailType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationCreateReportFailTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationCreateReportFailTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationCreateReportFailTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationCreateReportFailType:other];
}

- (BOOL)isEqualToClassificationCreateReportFailType:
    (DBTEAMLOGClassificationCreateReportFailType *)aClassificationCreateReportFailType {
  if (self == aClassificationCreateReportFailType) {
    return YES;
  }
  if (![self.description_ isEqual:aClassificationCreateReportFailType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationCreateReportFailTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationCreateReportFailType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationCreateReportFailType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGClassificationCreateReportFailType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationCreateReportType.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationCreateReportType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationCreateReportTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationCreateReportTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationCreateReportTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationCreateReportType:other];
}

- (BOOL)isEqualToClassificationCreateReportType:
    (DBTEAMLOGClassificationCreateReportType *)aClassificationCreateReportType {
  if (self == aClassificationCreateReportType) {
    return YES;
  }
  if (![self.description_ isEqual:aClassificationCreateReportType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationCreateReportTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationCreateReportType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationCreateReportType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGClassificationCreateReportType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationPolicyEnumWrapper.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationPolicyEnumWrapper

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationPolicyEnumWrapperDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationPolicyEnumWrapperEnabled;
  }
  return self;
}

- (instancetype)initWithMemberAndTeamFolders {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders;
  }
  return self;
}

- (instancetype)initWithTeamFolders {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationPolicyEnumWrapperOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGClassificationPolicyEnumWrapperDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMLOGClassificationPolicyEnumWrapperEnabled;
}

- (BOOL)isMemberAndTeamFolders {
  return _tag == DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders;
}

- (BOOL)isTeamFolders {
  return _tag == DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGClassificationPolicyEnumWrapperOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGClassificationPolicyEnumWrapperDisabled:
    return @"DBTEAMLOGClassificationPolicyEnumWrapperDisabled";
  case DBTEAMLOGClassificationPolicyEnumWrapperEnabled:
    return @"DBTEAMLOGClassificationPolicyEnumWrapperEnabled";
  case DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders:
    return @"DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders";
  case DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders:
    return @"DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders";
  case DBTEAMLOGClassificationPolicyEnumWrapperOther:
    return @"DBTEAMLOGClassificationPolicyEnumWrapperOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationPolicyEnumWrapperSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationPolicyEnumWrapperSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationPolicyEnumWrapperSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGClassificationPolicyEnumWrapperDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationPolicyEnumWrapperEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationPolicyEnumWrapperOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationPolicyEnumWrapper:other];
}

- (BOOL)isEqualToClassificationPolicyEnumWrapper:
    (DBTEAMLOGClassificationPolicyEnumWrapper *)aClassificationPolicyEnumWrapper {
  if (self == aClassificationPolicyEnumWrapper) {
    return YES;
  }
  if (self.tag != aClassificationPolicyEnumWrapper.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGClassificationPolicyEnumWrapperDisabled:
    return [[self tagName] isEqual:[aClassificationPolicyEnumWrapper tagName]];
  case DBTEAMLOGClassificationPolicyEnumWrapperEnabled:
    return [[self tagName] isEqual:[aClassificationPolicyEnumWrapper tagName]];
  case DBTEAMLOGClassificationPolicyEnumWrapperMemberAndTeamFolders:
    return [[self tagName] isEqual:[aClassificationPolicyEnumWrapper tagName]];
  case DBTEAMLOGClassificationPolicyEnumWrapperTeamFolders:
    return [[self tagName] isEqual:[aClassificationPolicyEnumWrapper tagName]];
  case DBTEAMLOGClassificationPolicyEnumWrapperOther:
    return [[self tagName] isEqual:[aClassificationPolicyEnumWrapper tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationPolicyEnumWrapperSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationPolicyEnumWrapper *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isMemberAndTeamFolders]) {
    jsonDict[@".tag"] = @"member_and_team_folders";
  } else if ([valueObj isTeamFolders]) {
    jsonDict[@".tag"] = @"team_folders";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationPolicyEnumWrapper *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"member_and_team_folders"]) {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithMemberAndTeamFolders];
  } else if ([tag isEqualToString:@"team_folders"]) {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithTeamFolders];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithOther];
  } else {
    return [[DBTEAMLOGClassificationPolicyEnumWrapper alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGClassificationType.h"

#pragma mark - API Object

@implementation DBTEAMLOGClassificationType

#pragma mark - Constructors

- (instancetype)initWithPersonalInformation {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationTypePersonalInformation;
  }
  return self;
}

- (instancetype)initWithPii {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationTypePii;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGClassificationTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPersonalInformation {
  return _tag == DBTEAMLOGClassificationTypePersonalInformation;
}

- (BOOL)isPii {
  return _tag == DBTEAMLOGClassificationTypePii;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGClassificationTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGClassificationTypePersonalInformation:
    return @"DBTEAMLOGClassificationTypePersonalInformation";
  case DBTEAMLOGClassificationTypePii:
    return @"DBTEAMLOGClassificationTypePii";
  case DBTEAMLOGClassificationTypeOther:
    return @"DBTEAMLOGClassificationTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGClassificationTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGClassificationTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGClassificationTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGClassificationTypePersonalInformation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationTypePii:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGClassificationTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToClassificationType:other];
}

- (BOOL)isEqualToClassificationType:(DBTEAMLOGClassificationType *)aClassificationType {
  if (self == aClassificationType) {
    return YES;
  }
  if (self.tag != aClassificationType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGClassificationTypePersonalInformation:
    return [[self tagName] isEqual:[aClassificationType tagName]];
  case DBTEAMLOGClassificationTypePii:
    return [[self tagName] isEqual:[aClassificationType tagName]];
  case DBTEAMLOGClassificationTypeOther:
    return [[self tagName] isEqual:[aClassificationType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGClassificationTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGClassificationType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPersonalInformation]) {
    jsonDict[@".tag"] = @"personal_information";
  } else if ([valueObj isPii]) {
    jsonDict[@".tag"] = @"pii";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGClassificationType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"personal_information"]) {
    return [[DBTEAMLOGClassificationType alloc] initWithPersonalInformation];
  } else if ([tag isEqualToString:@"pii"]) {
    return [[DBTEAMLOGClassificationType alloc] initWithPii];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGClassificationType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGClassificationType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCollectionShareDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGCollectionShareDetails

#pragma mark - Constructors

- (instancetype)initWithAlbumName:(NSString *)albumName {
  [DBStoneValidators nonnullValidator:nil](albumName);

  self = [super init];
  if (self) {
    _albumName = albumName;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCollectionShareDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCollectionShareDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCollectionShareDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.albumName hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCollectionShareDetails:other];
}

- (BOOL)isEqualToCollectionShareDetails:(DBTEAMLOGCollectionShareDetails *)aCollectionShareDetails {
  if (self == aCollectionShareDetails) {
    return YES;
  }
  if (![self.albumName isEqual:aCollectionShareDetails.albumName]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCollectionShareDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCollectionShareDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"album_name"] = valueObj.albumName;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCollectionShareDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *albumName = valueDict[@"album_name"];

  return [[DBTEAMLOGCollectionShareDetails alloc] initWithAlbumName:albumName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCollectionShareType.h"

#pragma mark - API Object

@implementation DBTEAMLOGCollectionShareType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCollectionShareTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCollectionShareTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCollectionShareTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCollectionShareType:other];
}

- (BOOL)isEqualToCollectionShareType:(DBTEAMLOGCollectionShareType *)aCollectionShareType {
  if (self == aCollectionShareType) {
    return YES;
  }
  if (![self.description_ isEqual:aCollectionShareType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCollectionShareTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCollectionShareType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCollectionShareType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGCollectionShareType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGComputerBackupPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGComputerBackupPolicy

#pragma mark - Constructors

- (instancetype)initWithDefault_ {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGComputerBackupPolicyDefault_;
  }
  return self;
}

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGComputerBackupPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGComputerBackupPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGComputerBackupPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDefault_ {
  return _tag == DBTEAMLOGComputerBackupPolicyDefault_;
}

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGComputerBackupPolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMLOGComputerBackupPolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGComputerBackupPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGComputerBackupPolicyDefault_:
    return @"DBTEAMLOGComputerBackupPolicyDefault_";
  case DBTEAMLOGComputerBackupPolicyDisabled:
    return @"DBTEAMLOGComputerBackupPolicyDisabled";
  case DBTEAMLOGComputerBackupPolicyEnabled:
    return @"DBTEAMLOGComputerBackupPolicyEnabled";
  case DBTEAMLOGComputerBackupPolicyOther:
    return @"DBTEAMLOGComputerBackupPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGComputerBackupPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGComputerBackupPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGComputerBackupPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGComputerBackupPolicyDefault_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGComputerBackupPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGComputerBackupPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGComputerBackupPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToComputerBackupPolicy:other];
}

- (BOOL)isEqualToComputerBackupPolicy:(DBTEAMLOGComputerBackupPolicy *)aComputerBackupPolicy {
  if (self == aComputerBackupPolicy) {
    return YES;
  }
  if (self.tag != aComputerBackupPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGComputerBackupPolicyDefault_:
    return [[self tagName] isEqual:[aComputerBackupPolicy tagName]];
  case DBTEAMLOGComputerBackupPolicyDisabled:
    return [[self tagName] isEqual:[aComputerBackupPolicy tagName]];
  case DBTEAMLOGComputerBackupPolicyEnabled:
    return [[self tagName] isEqual:[aComputerBackupPolicy tagName]];
  case DBTEAMLOGComputerBackupPolicyOther:
    return [[self tagName] isEqual:[aComputerBackupPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGComputerBackupPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGComputerBackupPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDefault_]) {
    jsonDict[@".tag"] = @"default";
  } else if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGComputerBackupPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"default"]) {
    return [[DBTEAMLOGComputerBackupPolicy alloc] initWithDefault_];
  } else if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGComputerBackupPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMLOGComputerBackupPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGComputerBackupPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGComputerBackupPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGComputerBackupPolicy.h"
#import "DBTEAMLOGComputerBackupPolicyChangedDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGComputerBackupPolicyChangedDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGComputerBackupPolicy *)dNewValue
                    previousValue:(DBTEAMLOGComputerBackupPolicy *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);
  [DBStoneValidators nonnullValidator:nil](previousValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGComputerBackupPolicyChangedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGComputerBackupPolicyChangedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGComputerBackupPolicyChangedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  result = prime * result + [self.previousValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToComputerBackupPolicyChangedDetails:other];
}

- (BOOL)isEqualToComputerBackupPolicyChangedDetails:
    (DBTEAMLOGComputerBackupPolicyChangedDetails *)aComputerBackupPolicyChangedDetails {
  if (self == aComputerBackupPolicyChangedDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:aComputerBackupPolicyChangedDetails.dNewValue]) {
    return NO;
  }
  if (![self.previousValue isEqual:aComputerBackupPolicyChangedDetails.previousValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGComputerBackupPolicyChangedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGComputerBackupPolicyChangedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = [DBTEAMLOGComputerBackupPolicySerializer serialize:valueObj.dNewValue];
  jsonDict[@"previous_value"] = [DBTEAMLOGComputerBackupPolicySerializer serialize:valueObj.previousValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGComputerBackupPolicyChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGComputerBackupPolicy *dNewValue =
      [DBTEAMLOGComputerBackupPolicySerializer deserialize:valueDict[@"new_value"]];
  DBTEAMLOGComputerBackupPolicy *previousValue =
      [DBTEAMLOGComputerBackupPolicySerializer deserialize:valueDict[@"previous_value"]];

  return [[DBTEAMLOGComputerBackupPolicyChangedDetails alloc] initWithDNewValue:dNewValue previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGComputerBackupPolicyChangedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGComputerBackupPolicyChangedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGComputerBackupPolicyChangedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGComputerBackupPolicyChangedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGComputerBackupPolicyChangedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToComputerBackupPolicyChangedType:other];
}

- (BOOL)isEqualToComputerBackupPolicyChangedType:
    (DBTEAMLOGComputerBackupPolicyChangedType *)aComputerBackupPolicyChangedType {
  if (self == aComputerBackupPolicyChangedType) {
    return YES;
  }
  if (![self.description_ isEqual:aComputerBackupPolicyChangedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGComputerBackupPolicyChangedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGComputerBackupPolicyChangedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGComputerBackupPolicyChangedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGComputerBackupPolicyChangedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGConnectedTeamName.h"

#pragma mark - API Object

@implementation DBTEAMLOGConnectedTeamName

#pragma mark - Constructors

- (instancetype)initWithTeam:(NSString *)team {
  [DBStoneValidators nonnullValidator:nil](team);

  self = [super init];
  if (self) {
    _team = team;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGConnectedTeamNameSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGConnectedTeamNameSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGConnectedTeamNameSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.team hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToConnectedTeamName:other];
}

- (BOOL)isEqualToConnectedTeamName:(DBTEAMLOGConnectedTeamName *)aConnectedTeamName {
  if (self == aConnectedTeamName) {
    return YES;
  }
  if (![self.team isEqual:aConnectedTeamName.team]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGConnectedTeamNameSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGConnectedTeamName *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team"] = valueObj.team;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGConnectedTeamName *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *team = valueDict[@"team"];

  return [[DBTEAMLOGConnectedTeamName alloc] initWithTeam:team];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGContentAdministrationPolicyChangedDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGContentAdministrationPolicyChangedDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(NSString *)dNewValue previousValue:(NSString *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);
  [DBStoneValidators nonnullValidator:nil](previousValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGContentAdministrationPolicyChangedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGContentAdministrationPolicyChangedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGContentAdministrationPolicyChangedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  result = prime * result + [self.previousValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContentAdministrationPolicyChangedDetails:other];
}

- (BOOL)isEqualToContentAdministrationPolicyChangedDetails:
    (DBTEAMLOGContentAdministrationPolicyChangedDetails *)aContentAdministrationPolicyChangedDetails {
  if (self == aContentAdministrationPolicyChangedDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:aContentAdministrationPolicyChangedDetails.dNewValue]) {
    return NO;
  }
  if (![self.previousValue isEqual:aContentAdministrationPolicyChangedDetails.previousValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGContentAdministrationPolicyChangedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGContentAdministrationPolicyChangedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = valueObj.dNewValue;
  jsonDict[@"previous_value"] = valueObj.previousValue;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGContentAdministrationPolicyChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *dNewValue = valueDict[@"new_value"];
  NSString *previousValue = valueDict[@"previous_value"];

  return [[DBTEAMLOGContentAdministrationPolicyChangedDetails alloc] initWithDNewValue:dNewValue
                                                                         previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGContentAdministrationPolicyChangedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGContentAdministrationPolicyChangedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGContentAdministrationPolicyChangedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGContentAdministrationPolicyChangedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGContentAdministrationPolicyChangedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContentAdministrationPolicyChangedType:other];
}

- (BOOL)isEqualToContentAdministrationPolicyChangedType:
    (DBTEAMLOGContentAdministrationPolicyChangedType *)aContentAdministrationPolicyChangedType {
  if (self == aContentAdministrationPolicyChangedType) {
    return YES;
  }
  if (![self.description_ isEqual:aContentAdministrationPolicyChangedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGContentAdministrationPolicyChangedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGContentAdministrationPolicyChangedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGContentAdministrationPolicyChangedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGContentAdministrationPolicyChangedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGContentPermanentDeletePolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGContentPermanentDeletePolicy

#pragma mark - Constructors

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContentPermanentDeletePolicyDisabled;
  }
  return self;
}

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContentPermanentDeletePolicyEnabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContentPermanentDeletePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabled {
  return _tag == DBTEAMLOGContentPermanentDeletePolicyDisabled;
}

- (BOOL)isEnabled {
  return _tag == DBTEAMLOGContentPermanentDeletePolicyEnabled;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGContentPermanentDeletePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGContentPermanentDeletePolicyDisabled:
    return @"DBTEAMLOGContentPermanentDeletePolicyDisabled";
  case DBTEAMLOGContentPermanentDeletePolicyEnabled:
    return @"DBTEAMLOGContentPermanentDeletePolicyEnabled";
  case DBTEAMLOGContentPermanentDeletePolicyOther:
    return @"DBTEAMLOGContentPermanentDeletePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGContentPermanentDeletePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGContentPermanentDeletePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGContentPermanentDeletePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGContentPermanentDeletePolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGContentPermanentDeletePolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGContentPermanentDeletePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContentPermanentDeletePolicy:other];
}

- (BOOL)isEqualToContentPermanentDeletePolicy:(DBTEAMLOGContentPermanentDeletePolicy *)aContentPermanentDeletePolicy {
  if (self == aContentPermanentDeletePolicy) {
    return YES;
  }
  if (self.tag != aContentPermanentDeletePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGContentPermanentDeletePolicyDisabled:
    return [[self tagName] isEqual:[aContentPermanentDeletePolicy tagName]];
  case DBTEAMLOGContentPermanentDeletePolicyEnabled:
    return [[self tagName] isEqual:[aContentPermanentDeletePolicy tagName]];
  case DBTEAMLOGContentPermanentDeletePolicyOther:
    return [[self tagName] isEqual:[aContentPermanentDeletePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGContentPermanentDeletePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGContentPermanentDeletePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGContentPermanentDeletePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled"]) {
    return [[DBTEAMLOGContentPermanentDeletePolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"enabled"]) {
    return [[DBTEAMLOGContentPermanentDeletePolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGContentPermanentDeletePolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGContentPermanentDeletePolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGContextLogInfo.h"
#import "DBTEAMLOGNonTeamMemberLogInfo.h"
#import "DBTEAMLOGTeamLogInfo.h"
#import "DBTEAMLOGTeamMemberLogInfo.h"
#import "DBTEAMLOGTrustedNonTeamMemberLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGContextLogInfo

@synthesize nonTeamMember = _nonTeamMember;
@synthesize organizationTeam = _organizationTeam;
@synthesize teamMember = _teamMember;
@synthesize trustedNonTeamMember = _trustedNonTeamMember;

#pragma mark - Constructors

- (instancetype)initWithAnonymous {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoAnonymous;
  }
  return self;
}

- (instancetype)initWithNonTeamMember:(DBTEAMLOGNonTeamMemberLogInfo *)nonTeamMember {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoNonTeamMember;
    _nonTeamMember = nonTeamMember;
  }
  return self;
}

- (instancetype)initWithOrganizationTeam:(DBTEAMLOGTeamLogInfo *)organizationTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoOrganizationTeam;
    _organizationTeam = organizationTeam;
  }
  return self;
}

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoTeam;
  }
  return self;
}

- (instancetype)initWithTeamMember:(DBTEAMLOGTeamMemberLogInfo *)teamMember {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoTeamMember;
    _teamMember = teamMember;
  }
  return self;
}

- (instancetype)initWithTrustedNonTeamMember:(DBTEAMLOGTrustedNonTeamMemberLogInfo *)trustedNonTeamMember {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoTrustedNonTeamMember;
    _trustedNonTeamMember = trustedNonTeamMember;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGContextLogInfoOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGNonTeamMemberLogInfo *)nonTeamMember {
  if (![self isNonTeamMember]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGContextLogInfoNonTeamMember, but was %@.", [self tagName]];
  }
  return _nonTeamMember;
}

- (DBTEAMLOGTeamLogInfo *)organizationTeam {
  if (![self isOrganizationTeam]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGContextLogInfoOrganizationTeam, but was %@.", [self tagName]];
  }
  return _organizationTeam;
}

- (DBTEAMLOGTeamMemberLogInfo *)teamMember {
  if (![self isTeamMember]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGContextLogInfoTeamMember, but was %@.", [self tagName]];
  }
  return _teamMember;
}

- (DBTEAMLOGTrustedNonTeamMemberLogInfo *)trustedNonTeamMember {
  if (![self isTrustedNonTeamMember]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGContextLogInfoTrustedNonTeamMember, but was %@.", [self tagName]];
  }
  return _trustedNonTeamMember;
}

#pragma mark - Tag state methods

- (BOOL)isAnonymous {
  return _tag == DBTEAMLOGContextLogInfoAnonymous;
}

- (BOOL)isNonTeamMember {
  return _tag == DBTEAMLOGContextLogInfoNonTeamMember;
}

- (BOOL)isOrganizationTeam {
  return _tag == DBTEAMLOGContextLogInfoOrganizationTeam;
}

- (BOOL)isTeam {
  return _tag == DBTEAMLOGContextLogInfoTeam;
}

- (BOOL)isTeamMember {
  return _tag == DBTEAMLOGContextLogInfoTeamMember;
}

- (BOOL)isTrustedNonTeamMember {
  return _tag == DBTEAMLOGContextLogInfoTrustedNonTeamMember;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGContextLogInfoOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGContextLogInfoAnonymous:
    return @"DBTEAMLOGContextLogInfoAnonymous";
  case DBTEAMLOGContextLogInfoNonTeamMember:
    return @"DBTEAMLOGContextLogInfoNonTeamMember";
  case DBTEAMLOGContextLogInfoOrganizationTeam:
    return @"DBTEAMLOGContextLogInfoOrganizationTeam";
  case DBTEAMLOGContextLogInfoTeam:
    return @"DBTEAMLOGContextLogInfoTeam";
  case DBTEAMLOGContextLogInfoTeamMember:
    return @"DBTEAMLOGContextLogInfoTeamMember";
  case DBTEAMLOGContextLogInfoTrustedNonTeamMember:
    return @"DBTEAMLOGContextLogInfoTrustedNonTeamMember";
  case DBTEAMLOGContextLogInfoOther:
    return @"DBTEAMLOGContextLogInfoOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGContextLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGContextLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGContextLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGContextLogInfoAnonymous:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGContextLogInfoNonTeamMember:
    result = prime * result + [self.nonTeamMember hash];
    break;
  case DBTEAMLOGContextLogInfoOrganizationTeam:
    result = prime * result + [self.organizationTeam hash];
    break;
  case DBTEAMLOGContextLogInfoTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGContextLogInfoTeamMember:
    result = prime * result + [self.teamMember hash];
    break;
  case DBTEAMLOGContextLogInfoTrustedNonTeamMember:
    result = prime * result + [self.trustedNonTeamMember hash];
    break;
  case DBTEAMLOGContextLogInfoOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToContextLogInfo:other];
}

- (BOOL)isEqualToContextLogInfo:(DBTEAMLOGContextLogInfo *)aContextLogInfo {
  if (self == aContextLogInfo) {
    return YES;
  }
  if (self.tag != aContextLogInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGContextLogInfoAnonymous:
    return [[self tagName] isEqual:[aContextLogInfo tagName]];
  case DBTEAMLOGContextLogInfoNonTeamMember:
    return [self.nonTeamMember isEqual:aContextLogInfo.nonTeamMember];
  case DBTEAMLOGContextLogInfoOrganizationTeam:
    return [self.organizationTeam isEqual:aContextLogInfo.organizationTeam];
  case DBTEAMLOGContextLogInfoTeam:
    return [[self tagName] isEqual:[aContextLogInfo tagName]];
  case DBTEAMLOGContextLogInfoTeamMember:
    return [self.teamMember isEqual:aContextLogInfo.teamMember];
  case DBTEAMLOGContextLogInfoTrustedNonTeamMember:
    return [self.trustedNonTeamMember isEqual:aContextLogInfo.trustedNonTeamMember];
  case DBTEAMLOGContextLogInfoOther:
    return [[self tagName] isEqual:[aContextLogInfo tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGContextLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGContextLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAnonymous]) {
    jsonDict[@".tag"] = @"anonymous";
  } else if ([valueObj isNonTeamMember]) {
    jsonDict = [[DBTEAMLOGNonTeamMemberLogInfoSerializer serialize:valueObj.nonTeamMember] mutableCopy];
    jsonDict[@".tag"] = @"non_team_member";
  } else if ([valueObj isOrganizationTeam]) {
    jsonDict = [[DBTEAMLOGTeamLogInfoSerializer serialize:valueObj.organizationTeam] mutableCopy];
    jsonDict[@".tag"] = @"organization_team";
  } else if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isTeamMember]) {
    jsonDict = [[DBTEAMLOGTeamMemberLogInfoSerializer serialize:valueObj.teamMember] mutableCopy];
    jsonDict[@".tag"] = @"team_member";
  } else if ([valueObj isTrustedNonTeamMember]) {
    jsonDict = [[DBTEAMLOGTrustedNonTeamMemberLogInfoSerializer serialize:valueObj.trustedNonTeamMember] mutableCopy];
    jsonDict[@".tag"] = @"trusted_non_team_member";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGContextLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"anonymous"]) {
    return [[DBTEAMLOGContextLogInfo alloc] initWithAnonymous];
  } else if ([tag isEqualToString:@"non_team_member"]) {
    DBTEAMLOGNonTeamMemberLogInfo *nonTeamMember = [DBTEAMLOGNonTeamMemberLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGContextLogInfo alloc] initWithNonTeamMember:nonTeamMember];
  } else if ([tag isEqualToString:@"organization_team"]) {
    DBTEAMLOGTeamLogInfo *organizationTeam = [DBTEAMLOGTeamLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGContextLogInfo alloc] initWithOrganizationTeam:organizationTeam];
  } else if ([tag isEqualToString:@"team"]) {
    return [[DBTEAMLOGContextLogInfo alloc] initWithTeam];
  } else if ([tag isEqualToString:@"team_member"]) {
    DBTEAMLOGTeamMemberLogInfo *teamMember = [DBTEAMLOGTeamMemberLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGContextLogInfo alloc] initWithTeamMember:teamMember];
  } else if ([tag isEqualToString:@"trusted_non_team_member"]) {
    DBTEAMLOGTrustedNonTeamMemberLogInfo *trustedNonTeamMember =
        [DBTEAMLOGTrustedNonTeamMemberLogInfoSerializer deserialize:valueDict];
    return [[DBTEAMLOGContextLogInfo alloc] initWithTrustedNonTeamMember:trustedNonTeamMember];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGContextLogInfo alloc] initWithOther];
  } else {
    return [[DBTEAMLOGContextLogInfo alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCreateFolderDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGCreateFolderDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCreateFolderDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCreateFolderDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCreateFolderDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderDetails:other];
}

- (BOOL)isEqualToCreateFolderDetails:(DBTEAMLOGCreateFolderDetails *)aCreateFolderDetails {
  if (self == aCreateFolderDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCreateFolderDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCreateFolderDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCreateFolderDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGCreateFolderDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCreateFolderType.h"

#pragma mark - API Object

@implementation DBTEAMLOGCreateFolderType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCreateFolderTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCreateFolderTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCreateFolderTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFolderType:other];
}

- (BOOL)isEqualToCreateFolderType:(DBTEAMLOGCreateFolderType *)aCreateFolderType {
  if (self == aCreateFolderType) {
    return YES;
  }
  if (![self.description_ isEqual:aCreateFolderType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCreateFolderTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCreateFolderType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCreateFolderType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGCreateFolderType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCreateTeamInviteLinkDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGCreateTeamInviteLinkDetails

#pragma mark - Constructors

- (instancetype)initWithLinkUrl:(NSString *)linkUrl expiryDate:(NSString *)expiryDate {
  [DBStoneValidators nonnullValidator:nil](linkUrl);
  [DBStoneValidators nonnullValidator:nil](expiryDate);

  self = [super init];
  if (self) {
    _linkUrl = linkUrl;
    _expiryDate = expiryDate;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCreateTeamInviteLinkDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCreateTeamInviteLinkDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCreateTeamInviteLinkDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.linkUrl hash];
  result = prime * result + [self.expiryDate hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateTeamInviteLinkDetails:other];
}

- (BOOL)isEqualToCreateTeamInviteLinkDetails:(DBTEAMLOGCreateTeamInviteLinkDetails *)aCreateTeamInviteLinkDetails {
  if (self == aCreateTeamInviteLinkDetails) {
    return YES;
  }
  if (![self.linkUrl isEqual:aCreateTeamInviteLinkDetails.linkUrl]) {
    return NO;
  }
  if (![self.expiryDate isEqual:aCreateTeamInviteLinkDetails.expiryDate]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCreateTeamInviteLinkDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCreateTeamInviteLinkDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"link_url"] = valueObj.linkUrl;
  jsonDict[@"expiry_date"] = valueObj.expiryDate;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCreateTeamInviteLinkDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *linkUrl = valueDict[@"link_url"];
  NSString *expiryDate = valueDict[@"expiry_date"];

  return [[DBTEAMLOGCreateTeamInviteLinkDetails alloc] initWithLinkUrl:linkUrl expiryDate:expiryDate];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGCreateTeamInviteLinkType.h"

#pragma mark - API Object

@implementation DBTEAMLOGCreateTeamInviteLinkType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGCreateTeamInviteLinkTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGCreateTeamInviteLinkTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGCreateTeamInviteLinkTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateTeamInviteLinkType:other];
}

- (BOOL)isEqualToCreateTeamInviteLinkType:(DBTEAMLOGCreateTeamInviteLinkType *)aCreateTeamInviteLinkType {
  if (self == aCreateTeamInviteLinkType) {
    return YES;
  }
  if (![self.description_ isEqual:aCreateTeamInviteLinkType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGCreateTeamInviteLinkTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGCreateTeamInviteLinkType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGCreateTeamInviteLinkType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGCreateTeamInviteLinkType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDataPlacementRestrictionChangePolicyDetails.h"
#import "DBTEAMLOGPlacementRestriction.h"

#pragma mark - API Object

@implementation DBTEAMLOGDataPlacementRestrictionChangePolicyDetails

#pragma mark - Constructors

- (instancetype)initWithPreviousValue:(DBTEAMLOGPlacementRestriction *)previousValue
                            dNewValue:(DBTEAMLOGPlacementRestriction *)dNewValue {
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _previousValue = previousValue;
    _dNewValue = dNewValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDataPlacementRestrictionChangePolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDataPlacementRestrictionChangePolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDataPlacementRestrictionChangePolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDataPlacementRestrictionChangePolicyDetails:other];
}

- (BOOL)isEqualToDataPlacementRestrictionChangePolicyDetails:
    (DBTEAMLOGDataPlacementRestrictionChangePolicyDetails *)aDataPlacementRestrictionChangePolicyDetails {
  if (self == aDataPlacementRestrictionChangePolicyDetails) {
    return YES;
  }
  if (![self.previousValue isEqual:aDataPlacementRestrictionChangePolicyDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:aDataPlacementRestrictionChangePolicyDetails.dNewValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDataPlacementRestrictionChangePolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDataPlacementRestrictionChangePolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"previous_value"] = [DBTEAMLOGPlacementRestrictionSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGPlacementRestrictionSerializer serialize:valueObj.dNewValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDataPlacementRestrictionChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGPlacementRestriction *previousValue =
      [DBTEAMLOGPlacementRestrictionSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGPlacementRestriction *dNewValue =
      [DBTEAMLOGPlacementRestrictionSerializer deserialize:valueDict[@"new_value"]];

  return [[DBTEAMLOGDataPlacementRestrictionChangePolicyDetails alloc] initWithPreviousValue:previousValue
                                                                                   dNewValue:dNewValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDataPlacementRestrictionChangePolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDataPlacementRestrictionChangePolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDataPlacementRestrictionChangePolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDataPlacementRestrictionChangePolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDataPlacementRestrictionChangePolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDataPlacementRestrictionChangePolicyType:other];
}

- (BOOL)isEqualToDataPlacementRestrictionChangePolicyType:
    (DBTEAMLOGDataPlacementRestrictionChangePolicyType *)aDataPlacementRestrictionChangePolicyType {
  if (self == aDataPlacementRestrictionChangePolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:aDataPlacementRestrictionChangePolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDataPlacementRestrictionChangePolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDataPlacementRestrictionChangePolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDataPlacementRestrictionChangePolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDataPlacementRestrictionChangePolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails.h"
#import "DBTEAMLOGPlacementRestriction.h"

#pragma mark - API Object

@implementation DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails

#pragma mark - Constructors

- (instancetype)initWithPlacementRestriction:(DBTEAMLOGPlacementRestriction *)placementRestriction {
  [DBStoneValidators nonnullValidator:nil](placementRestriction);

  self = [super init];
  if (self) {
    _placementRestriction = placementRestriction;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.placementRestriction hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDataPlacementRestrictionSatisfyPolicyDetails:other];
}

- (BOOL)isEqualToDataPlacementRestrictionSatisfyPolicyDetails:
    (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails *)aDataPlacementRestrictionSatisfyPolicyDetails {
  if (self == aDataPlacementRestrictionSatisfyPolicyDetails) {
    return YES;
  }
  if (![self.placementRestriction isEqual:aDataPlacementRestrictionSatisfyPolicyDetails.placementRestriction]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"placement_restriction"] =
      [DBTEAMLOGPlacementRestrictionSerializer serialize:valueObj.placementRestriction];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGPlacementRestriction *placementRestriction =
      [DBTEAMLOGPlacementRestrictionSerializer deserialize:valueDict[@"placement_restriction"]];

  return
      [[DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails alloc] initWithPlacementRestriction:placementRestriction];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDataPlacementRestrictionSatisfyPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDataPlacementRestrictionSatisfyPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDataPlacementRestrictionSatisfyPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDataPlacementRestrictionSatisfyPolicyType:other];
}

- (BOOL)isEqualToDataPlacementRestrictionSatisfyPolicyType:
    (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType *)aDataPlacementRestrictionSatisfyPolicyType {
  if (self == aDataPlacementRestrictionSatisfyPolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:aDataPlacementRestrictionSatisfyPolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDataPlacementRestrictionSatisfyPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDataPlacementRestrictionSatisfyPolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeleteTeamInviteLinkDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeleteTeamInviteLinkDetails

#pragma mark - Constructors

- (instancetype)initWithLinkUrl:(NSString *)linkUrl {
  [DBStoneValidators nonnullValidator:nil](linkUrl);

  self = [super init];
  if (self) {
    _linkUrl = linkUrl;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeleteTeamInviteLinkDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeleteTeamInviteLinkDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeleteTeamInviteLinkDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.linkUrl hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteTeamInviteLinkDetails:other];
}

- (BOOL)isEqualToDeleteTeamInviteLinkDetails:(DBTEAMLOGDeleteTeamInviteLinkDetails *)aDeleteTeamInviteLinkDetails {
  if (self == aDeleteTeamInviteLinkDetails) {
    return YES;
  }
  if (![self.linkUrl isEqual:aDeleteTeamInviteLinkDetails.linkUrl]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeleteTeamInviteLinkDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeleteTeamInviteLinkDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"link_url"] = valueObj.linkUrl;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeleteTeamInviteLinkDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *linkUrl = valueDict[@"link_url"];

  return [[DBTEAMLOGDeleteTeamInviteLinkDetails alloc] initWithLinkUrl:linkUrl];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeleteTeamInviteLinkType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeleteTeamInviteLinkType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeleteTeamInviteLinkTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeleteTeamInviteLinkTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeleteTeamInviteLinkTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteTeamInviteLinkType:other];
}

- (BOOL)isEqualToDeleteTeamInviteLinkType:(DBTEAMLOGDeleteTeamInviteLinkType *)aDeleteTeamInviteLinkType {
  if (self == aDeleteTeamInviteLinkType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeleteTeamInviteLinkType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeleteTeamInviteLinkTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeleteTeamInviteLinkType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeleteTeamInviteLinkType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeleteTeamInviteLinkType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDesktopDeviceSessionLogInfo.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"
#import "DBTEAMLOGLegacyDeviceSessionLogInfo.h"
#import "DBTEAMLOGMobileDeviceSessionLogInfo.h"
#import "DBTEAMLOGWebDeviceSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceSessionLogInfo

#pragma mark - Constructors

- (instancetype)initWithIpAddress:(NSString *)ipAddress created:(NSDate *)created updated:(NSDate *)updated {

  self = [super init];
  if (self) {
    _ipAddress = ipAddress;
    _created = created;
    _updated = updated;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithIpAddress:nil created:nil updated:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceSessionLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceSessionLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceSessionLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceSessionLogInfo:other];
}

- (BOOL)isEqualToDeviceSessionLogInfo:(DBTEAMLOGDeviceSessionLogInfo *)aDeviceSessionLogInfo {
  if (self == aDeviceSessionLogInfo) {
    return YES;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aDeviceSessionLogInfo.ipAddress]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aDeviceSessionLogInfo.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:aDeviceSessionLogInfo.updated]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceSessionLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceSessionLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  if ([valueObj isKindOfClass:[DBTEAMLOGDesktopDeviceSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer serialize:(DBTEAMLOGDesktopDeviceSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"desktopDeviceSession";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGMobileDeviceSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGMobileDeviceSessionLogInfoSerializer serialize:(DBTEAMLOGMobileDeviceSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"mobileDeviceSession";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGWebDeviceSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGWebDeviceSessionLogInfoSerializer serialize:(DBTEAMLOGWebDeviceSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"webDeviceSession";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGLegacyDeviceSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGLegacyDeviceSessionLogInfoSerializer serialize:(DBTEAMLOGLegacyDeviceSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"legacyDeviceSession";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"desktop_device_session"]) {
    return [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"mobile_device_session"]) {
    return [DBTEAMLOGMobileDeviceSessionLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"web_device_session"]) {
    return [DBTEAMLOGWebDeviceSessionLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"legacy_device_session"]) {
    return [DBTEAMLOGLegacyDeviceSessionLogInfoSerializer deserialize:valueDict];
  }

  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBTEAMLOGDeviceSessionLogInfo alloc] initWithIpAddress:ipAddress created:created updated:updated];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMDesktopPlatform.h"
#import "DBTEAMLOGDesktopDeviceSessionLogInfo.h"
#import "DBTEAMLOGDesktopSessionLogInfo.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDesktopDeviceSessionLogInfo

#pragma mark - Constructors

- (instancetype)initWithHostName:(NSString *)hostName
                      clientType:(DBTEAMDesktopPlatform *)clientType
                        platform:(NSString *)platform
       isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported
                       ipAddress:(NSString *)ipAddress
                         created:(NSDate *)created
                         updated:(NSDate *)updated
                     sessionInfo:(DBTEAMLOGDesktopSessionLogInfo *)sessionInfo
                   clientVersion:(NSString *)clientVersion {
  [DBStoneValidators nonnullValidator:nil](hostName);
  [DBStoneValidators nonnullValidator:nil](clientType);
  [DBStoneValidators nonnullValidator:nil](platform);
  [DBStoneValidators nonnullValidator:nil](isDeleteOnUnlinkSupported);

  self = [super initWithIpAddress:ipAddress created:created updated:updated];
  if (self) {
    _sessionInfo = sessionInfo;
    _hostName = hostName;
    _clientType = clientType;
    _clientVersion = clientVersion;
    _platform = platform;
    _isDeleteOnUnlinkSupported = isDeleteOnUnlinkSupported;
  }
  return self;
}

- (instancetype)initWithHostName:(NSString *)hostName
                      clientType:(DBTEAMDesktopPlatform *)clientType
                        platform:(NSString *)platform
       isDeleteOnUnlinkSupported:(NSNumber *)isDeleteOnUnlinkSupported {
  return [self initWithHostName:hostName
                     clientType:clientType
                       platform:platform
      isDeleteOnUnlinkSupported:isDeleteOnUnlinkSupported
                      ipAddress:nil
                        created:nil
                        updated:nil
                    sessionInfo:nil
                  clientVersion:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDesktopDeviceSessionLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.hostName hash];
  result = prime * result + [self.clientType hash];
  result = prime * result + [self.platform hash];
  result = prime * result + [self.isDeleteOnUnlinkSupported hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }
  if (self.created != nil) {
    result = prime * result + [self.created hash];
  }
  if (self.updated != nil) {
    result = prime * result + [self.updated hash];
  }
  if (self.sessionInfo != nil) {
    result = prime * result + [self.sessionInfo hash];
  }
  if (self.clientVersion != nil) {
    result = prime * result + [self.clientVersion hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDesktopDeviceSessionLogInfo:other];
}

- (BOOL)isEqualToDesktopDeviceSessionLogInfo:(DBTEAMLOGDesktopDeviceSessionLogInfo *)aDesktopDeviceSessionLogInfo {
  if (self == aDesktopDeviceSessionLogInfo) {
    return YES;
  }
  if (![self.hostName isEqual:aDesktopDeviceSessionLogInfo.hostName]) {
    return NO;
  }
  if (![self.clientType isEqual:aDesktopDeviceSessionLogInfo.clientType]) {
    return NO;
  }
  if (![self.platform isEqual:aDesktopDeviceSessionLogInfo.platform]) {
    return NO;
  }
  if (![self.isDeleteOnUnlinkSupported isEqual:aDesktopDeviceSessionLogInfo.isDeleteOnUnlinkSupported]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aDesktopDeviceSessionLogInfo.ipAddress]) {
      return NO;
    }
  }
  if (self.created) {
    if (![self.created isEqual:aDesktopDeviceSessionLogInfo.created]) {
      return NO;
    }
  }
  if (self.updated) {
    if (![self.updated isEqual:aDesktopDeviceSessionLogInfo.updated]) {
      return NO;
    }
  }
  if (self.sessionInfo) {
    if (![self.sessionInfo isEqual:aDesktopDeviceSessionLogInfo.sessionInfo]) {
      return NO;
    }
  }
  if (self.clientVersion) {
    if (![self.clientVersion isEqual:aDesktopDeviceSessionLogInfo.clientVersion]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDesktopDeviceSessionLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDesktopDeviceSessionLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"host_name"] = valueObj.hostName;
  jsonDict[@"client_type"] = [DBTEAMDesktopPlatformSerializer serialize:valueObj.clientType];
  jsonDict[@"platform"] = valueObj.platform;
  jsonDict[@"is_delete_on_unlink_supported"] = valueObj.isDeleteOnUnlinkSupported;
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }
  if (valueObj.created) {
    jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.updated) {
    jsonDict[@"updated"] = [DBNSDateSerializer serialize:valueObj.updated dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.sessionInfo) {
    jsonDict[@"session_info"] = [DBTEAMLOGDesktopSessionLogInfoSerializer serialize:valueObj.sessionInfo];
  }
  if (valueObj.clientVersion) {
    jsonDict[@"client_version"] = valueObj.clientVersion;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDesktopDeviceSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *hostName = valueDict[@"host_name"];
  DBTEAMDesktopPlatform *clientType = [DBTEAMDesktopPlatformSerializer deserialize:valueDict[@"client_type"]];
  NSString *platform = valueDict[@"platform"];
  NSNumber *isDeleteOnUnlinkSupported = valueDict[@"is_delete_on_unlink_supported"];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;
  NSDate *created = valueDict[@"created"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSDate *updated = valueDict[@"updated"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"updated"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  DBTEAMLOGDesktopSessionLogInfo *sessionInfo =
      valueDict[@"session_info"] ? [DBTEAMLOGDesktopSessionLogInfoSerializer deserialize:valueDict[@"session_info"]]
                                 : nil;
  NSString *clientVersion = valueDict[@"client_version"] ?: nil;

  return [[DBTEAMLOGDesktopDeviceSessionLogInfo alloc] initWithHostName:hostName
                                                             clientType:clientType
                                                               platform:platform
                                              isDeleteOnUnlinkSupported:isDeleteOnUnlinkSupported
                                                              ipAddress:ipAddress
                                                                created:created
                                                                updated:updated
                                                            sessionInfo:sessionInfo
                                                          clientVersion:clientVersion];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDesktopSessionLogInfo.h"
#import "DBTEAMLOGMobileSessionLogInfo.h"
#import "DBTEAMLOGSessionLogInfo.h"
#import "DBTEAMLOGWebSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGSessionLogInfo

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId {

  self = [super init];
  if (self) {
    _sessionId = sessionId;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithSessionId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGSessionLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGSessionLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGSessionLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.sessionId != nil) {
    result = prime * result + [self.sessionId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSessionLogInfo:other];
}

- (BOOL)isEqualToSessionLogInfo:(DBTEAMLOGSessionLogInfo *)aSessionLogInfo {
  if (self == aSessionLogInfo) {
    return YES;
  }
  if (self.sessionId) {
    if (![self.sessionId isEqual:aSessionLogInfo.sessionId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGSessionLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGSessionLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.sessionId) {
    jsonDict[@"session_id"] = valueObj.sessionId;
  }

  if ([valueObj isKindOfClass:[DBTEAMLOGWebSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGWebSessionLogInfoSerializer serialize:(DBTEAMLOGWebSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"web";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGDesktopSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGDesktopSessionLogInfoSerializer serialize:(DBTEAMLOGDesktopSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"desktop";
  } else if ([valueObj isKindOfClass:[DBTEAMLOGMobileSessionLogInfo class]]) {
    NSDictionary *subTypeFields =
        [DBTEAMLOGMobileSessionLogInfoSerializer serialize:(DBTEAMLOGMobileSessionLogInfo *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"mobile";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"web"]) {
    return [DBTEAMLOGWebSessionLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"desktop"]) {
    return [DBTEAMLOGDesktopSessionLogInfoSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"mobile"]) {
    return [DBTEAMLOGMobileSessionLogInfoSerializer deserialize:valueDict];
  }

  NSString *sessionId = valueDict[@"session_id"] ?: nil;

  return [[DBTEAMLOGSessionLogInfo alloc] initWithSessionId:sessionId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDesktopSessionLogInfo.h"
#import "DBTEAMLOGSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDesktopSessionLogInfo

#pragma mark - Constructors

- (instancetype)initWithSessionId:(NSString *)sessionId {

  self = [super initWithSessionId:sessionId];
  if (self) {
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithSessionId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDesktopSessionLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDesktopSessionLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDesktopSessionLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.sessionId != nil) {
    result = prime * result + [self.sessionId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDesktopSessionLogInfo:other];
}

- (BOOL)isEqualToDesktopSessionLogInfo:(DBTEAMLOGDesktopSessionLogInfo *)aDesktopSessionLogInfo {
  if (self == aDesktopSessionLogInfo) {
    return YES;
  }
  if (self.sessionId) {
    if (![self.sessionId isEqual:aDesktopSessionLogInfo.sessionId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDesktopSessionLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDesktopSessionLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.sessionId) {
    jsonDict[@"session_id"] = valueObj.sessionId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDesktopSessionLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sessionId = valueDict[@"session_id"] ?: nil;

  return [[DBTEAMLOGDesktopSessionLogInfo alloc] initWithSessionId:sessionId];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsAddExceptionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsAddExceptionDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsAddExceptionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsAddExceptionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsAddExceptionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsAddExceptionDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsAddExceptionDetails:
    (DBTEAMLOGDeviceApprovalsAddExceptionDetails *)aDeviceApprovalsAddExceptionDetails {
  if (self == aDeviceApprovalsAddExceptionDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsAddExceptionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsAddExceptionDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsAddExceptionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDeviceApprovalsAddExceptionDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsAddExceptionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsAddExceptionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsAddExceptionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsAddExceptionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsAddExceptionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsAddExceptionType:other];
}

- (BOOL)isEqualToDeviceApprovalsAddExceptionType:
    (DBTEAMLOGDeviceApprovalsAddExceptionType *)aDeviceApprovalsAddExceptionType {
  if (self == aDeviceApprovalsAddExceptionType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsAddExceptionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsAddExceptionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsAddExceptionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsAddExceptionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsAddExceptionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails.h"
#import "DBTEAMLOGDeviceApprovalsPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGDeviceApprovalsPolicy *)dNewValue
                    previousValue:(DBTEAMLOGDeviceApprovalsPolicy *)previousValue {

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDNewValue:nil previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dNewValue != nil) {
    result = prime * result + [self.dNewValue hash];
  }
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeDesktopPolicyDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeDesktopPolicyDetails:
    (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails *)aDeviceApprovalsChangeDesktopPolicyDetails {
  if (self == aDeviceApprovalsChangeDesktopPolicyDetails) {
    return YES;
  }
  if (self.dNewValue) {
    if (![self.dNewValue isEqual:aDeviceApprovalsChangeDesktopPolicyDetails.dNewValue]) {
      return NO;
    }
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:aDeviceApprovalsChangeDesktopPolicyDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dNewValue) {
    jsonDict[@"new_value"] = [DBTEAMLOGDeviceApprovalsPolicySerializer serialize:valueObj.dNewValue];
  }
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMLOGDeviceApprovalsPolicySerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceApprovalsPolicy *dNewValue =
      valueDict[@"new_value"] ? [DBTEAMLOGDeviceApprovalsPolicySerializer deserialize:valueDict[@"new_value"]] : nil;
  DBTEAMLOGDeviceApprovalsPolicy *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMLOGDeviceApprovalsPolicySerializer deserialize:valueDict[@"previous_value"]]
                                   : nil;

  return [[DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails alloc] initWithDNewValue:dNewValue
                                                                         previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeDesktopPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeDesktopPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeDesktopPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeDesktopPolicyType:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeDesktopPolicyType:
    (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType *)aDeviceApprovalsChangeDesktopPolicyType {
  if (self == aDeviceApprovalsChangeDesktopPolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsChangeDesktopPolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeDesktopPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsChangeDesktopPolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails.h"
#import "DBTEAMLOGDeviceApprovalsPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGDeviceApprovalsPolicy *)dNewValue
                    previousValue:(DBTEAMLOGDeviceApprovalsPolicy *)previousValue {

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDNewValue:nil previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dNewValue != nil) {
    result = prime * result + [self.dNewValue hash];
  }
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeMobilePolicyDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeMobilePolicyDetails:
    (DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)aDeviceApprovalsChangeMobilePolicyDetails {
  if (self == aDeviceApprovalsChangeMobilePolicyDetails) {
    return YES;
  }
  if (self.dNewValue) {
    if (![self.dNewValue isEqual:aDeviceApprovalsChangeMobilePolicyDetails.dNewValue]) {
      return NO;
    }
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:aDeviceApprovalsChangeMobilePolicyDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dNewValue) {
    jsonDict[@"new_value"] = [DBTEAMLOGDeviceApprovalsPolicySerializer serialize:valueObj.dNewValue];
  }
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMLOGDeviceApprovalsPolicySerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceApprovalsPolicy *dNewValue =
      valueDict[@"new_value"] ? [DBTEAMLOGDeviceApprovalsPolicySerializer deserialize:valueDict[@"new_value"]] : nil;
  DBTEAMLOGDeviceApprovalsPolicy *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMLOGDeviceApprovalsPolicySerializer deserialize:valueDict[@"previous_value"]]
                                   : nil;

  return [[DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails alloc] initWithDNewValue:dNewValue
                                                                        previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeMobilePolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeMobilePolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeMobilePolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeMobilePolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeMobilePolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeMobilePolicyType:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeMobilePolicyType:
    (DBTEAMLOGDeviceApprovalsChangeMobilePolicyType *)aDeviceApprovalsChangeMobilePolicyType {
  if (self == aDeviceApprovalsChangeMobilePolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsChangeMobilePolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeMobilePolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeMobilePolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeMobilePolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsChangeMobilePolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeOverageActionDetails.h"
#import "DBTEAMPOLICIESRolloutMethod.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeOverageActionDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMPOLICIESRolloutMethod *)dNewValue
                    previousValue:(DBTEAMPOLICIESRolloutMethod *)previousValue {

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDNewValue:nil previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeOverageActionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeOverageActionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeOverageActionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dNewValue != nil) {
    result = prime * result + [self.dNewValue hash];
  }
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeOverageActionDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeOverageActionDetails:
    (DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)aDeviceApprovalsChangeOverageActionDetails {
  if (self == aDeviceApprovalsChangeOverageActionDetails) {
    return YES;
  }
  if (self.dNewValue) {
    if (![self.dNewValue isEqual:aDeviceApprovalsChangeOverageActionDetails.dNewValue]) {
      return NO;
    }
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:aDeviceApprovalsChangeOverageActionDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeOverageActionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dNewValue) {
    jsonDict[@"new_value"] = [DBTEAMPOLICIESRolloutMethodSerializer serialize:valueObj.dNewValue];
  }
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMPOLICIESRolloutMethodSerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMPOLICIESRolloutMethod *dNewValue =
      valueDict[@"new_value"] ? [DBTEAMPOLICIESRolloutMethodSerializer deserialize:valueDict[@"new_value"]] : nil;
  DBTEAMPOLICIESRolloutMethod *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMPOLICIESRolloutMethodSerializer deserialize:valueDict[@"previous_value"]]
                                   : nil;

  return [[DBTEAMLOGDeviceApprovalsChangeOverageActionDetails alloc] initWithDNewValue:dNewValue
                                                                         previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeOverageActionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeOverageActionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeOverageActionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeOverageActionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeOverageActionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeOverageActionType:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeOverageActionType:
    (DBTEAMLOGDeviceApprovalsChangeOverageActionType *)aDeviceApprovalsChangeOverageActionType {
  if (self == aDeviceApprovalsChangeOverageActionType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsChangeOverageActionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeOverageActionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeOverageActionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeOverageActionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsChangeOverageActionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails.h"
#import "DBTEAMLOGDeviceUnlinkPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMLOGDeviceUnlinkPolicy *)dNewValue
                    previousValue:(DBTEAMLOGDeviceUnlinkPolicy *)previousValue {

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDNewValue:nil previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.dNewValue != nil) {
    result = prime * result + [self.dNewValue hash];
  }
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeUnlinkActionDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeUnlinkActionDetails:
    (DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)aDeviceApprovalsChangeUnlinkActionDetails {
  if (self == aDeviceApprovalsChangeUnlinkActionDetails) {
    return YES;
  }
  if (self.dNewValue) {
    if (![self.dNewValue isEqual:aDeviceApprovalsChangeUnlinkActionDetails.dNewValue]) {
      return NO;
    }
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:aDeviceApprovalsChangeUnlinkActionDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.dNewValue) {
    jsonDict[@"new_value"] = [DBTEAMLOGDeviceUnlinkPolicySerializer serialize:valueObj.dNewValue];
  }
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMLOGDeviceUnlinkPolicySerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceUnlinkPolicy *dNewValue =
      valueDict[@"new_value"] ? [DBTEAMLOGDeviceUnlinkPolicySerializer deserialize:valueDict[@"new_value"]] : nil;
  DBTEAMLOGDeviceUnlinkPolicy *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMLOGDeviceUnlinkPolicySerializer deserialize:valueDict[@"previous_value"]]
                                   : nil;

  return [[DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails alloc] initWithDNewValue:dNewValue
                                                                        previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsChangeUnlinkActionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsChangeUnlinkActionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsChangeUnlinkActionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsChangeUnlinkActionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsChangeUnlinkActionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsChangeUnlinkActionType:other];
}

- (BOOL)isEqualToDeviceApprovalsChangeUnlinkActionType:
    (DBTEAMLOGDeviceApprovalsChangeUnlinkActionType *)aDeviceApprovalsChangeUnlinkActionType {
  if (self == aDeviceApprovalsChangeUnlinkActionType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsChangeUnlinkActionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsChangeUnlinkActionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsChangeUnlinkActionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsChangeUnlinkActionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsChangeUnlinkActionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsPolicy

#pragma mark - Constructors

- (instancetype)initWithLimited {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceApprovalsPolicyLimited;
  }
  return self;
}

- (instancetype)initWithUnlimited {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceApprovalsPolicyUnlimited;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceApprovalsPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isLimited {
  return _tag == DBTEAMLOGDeviceApprovalsPolicyLimited;
}

- (BOOL)isUnlimited {
  return _tag == DBTEAMLOGDeviceApprovalsPolicyUnlimited;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGDeviceApprovalsPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGDeviceApprovalsPolicyLimited:
    return @"DBTEAMLOGDeviceApprovalsPolicyLimited";
  case DBTEAMLOGDeviceApprovalsPolicyUnlimited:
    return @"DBTEAMLOGDeviceApprovalsPolicyUnlimited";
  case DBTEAMLOGDeviceApprovalsPolicyOther:
    return @"DBTEAMLOGDeviceApprovalsPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGDeviceApprovalsPolicyLimited:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceApprovalsPolicyUnlimited:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceApprovalsPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsPolicy:other];
}

- (BOOL)isEqualToDeviceApprovalsPolicy:(DBTEAMLOGDeviceApprovalsPolicy *)aDeviceApprovalsPolicy {
  if (self == aDeviceApprovalsPolicy) {
    return YES;
  }
  if (self.tag != aDeviceApprovalsPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGDeviceApprovalsPolicyLimited:
    return [[self tagName] isEqual:[aDeviceApprovalsPolicy tagName]];
  case DBTEAMLOGDeviceApprovalsPolicyUnlimited:
    return [[self tagName] isEqual:[aDeviceApprovalsPolicy tagName]];
  case DBTEAMLOGDeviceApprovalsPolicyOther:
    return [[self tagName] isEqual:[aDeviceApprovalsPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLimited]) {
    jsonDict[@".tag"] = @"limited";
  } else if ([valueObj isUnlimited]) {
    jsonDict[@".tag"] = @"unlimited";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"limited"]) {
    return [[DBTEAMLOGDeviceApprovalsPolicy alloc] initWithLimited];
  } else if ([tag isEqualToString:@"unlimited"]) {
    return [[DBTEAMLOGDeviceApprovalsPolicy alloc] initWithUnlimited];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGDeviceApprovalsPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGDeviceApprovalsPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsRemoveExceptionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsRemoveExceptionDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsRemoveExceptionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsRemoveExceptionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsRemoveExceptionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsRemoveExceptionDetails:other];
}

- (BOOL)isEqualToDeviceApprovalsRemoveExceptionDetails:
    (DBTEAMLOGDeviceApprovalsRemoveExceptionDetails *)aDeviceApprovalsRemoveExceptionDetails {
  if (self == aDeviceApprovalsRemoveExceptionDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsRemoveExceptionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsRemoveExceptionDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsRemoveExceptionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDeviceApprovalsRemoveExceptionDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceApprovalsRemoveExceptionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceApprovalsRemoveExceptionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceApprovalsRemoveExceptionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceApprovalsRemoveExceptionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceApprovalsRemoveExceptionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceApprovalsRemoveExceptionType:other];
}

- (BOOL)isEqualToDeviceApprovalsRemoveExceptionType:
    (DBTEAMLOGDeviceApprovalsRemoveExceptionType *)aDeviceApprovalsRemoveExceptionType {
  if (self == aDeviceApprovalsRemoveExceptionType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceApprovalsRemoveExceptionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceApprovalsRemoveExceptionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceApprovalsRemoveExceptionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceApprovalsRemoveExceptionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceApprovalsRemoveExceptionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpDesktopDetails.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpDesktopDetails

#pragma mark - Constructors

- (instancetype)initWithDeviceSessionInfo:(DBTEAMLOGDeviceSessionLogInfo *)deviceSessionInfo {
  [DBStoneValidators nonnullValidator:nil](deviceSessionInfo);

  self = [super init];
  if (self) {
    _deviceSessionInfo = deviceSessionInfo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpDesktopDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpDesktopDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpDesktopDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.deviceSessionInfo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpDesktopDetails:other];
}

- (BOOL)isEqualToDeviceChangeIpDesktopDetails:(DBTEAMLOGDeviceChangeIpDesktopDetails *)aDeviceChangeIpDesktopDetails {
  if (self == aDeviceChangeIpDesktopDetails) {
    return YES;
  }
  if (![self.deviceSessionInfo isEqual:aDeviceChangeIpDesktopDetails.deviceSessionInfo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpDesktopDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpDesktopDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"device_session_info"] = [DBTEAMLOGDeviceSessionLogInfoSerializer serialize:valueObj.deviceSessionInfo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpDesktopDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceSessionLogInfo *deviceSessionInfo =
      [DBTEAMLOGDeviceSessionLogInfoSerializer deserialize:valueDict[@"device_session_info"]];

  return [[DBTEAMLOGDeviceChangeIpDesktopDetails alloc] initWithDeviceSessionInfo:deviceSessionInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpDesktopType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpDesktopType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpDesktopTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpDesktopTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpDesktopTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpDesktopType:other];
}

- (BOOL)isEqualToDeviceChangeIpDesktopType:(DBTEAMLOGDeviceChangeIpDesktopType *)aDeviceChangeIpDesktopType {
  if (self == aDeviceChangeIpDesktopType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceChangeIpDesktopType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpDesktopTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpDesktopType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpDesktopType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceChangeIpDesktopType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpMobileDetails.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpMobileDetails

#pragma mark - Constructors

- (instancetype)initWithDeviceSessionInfo:(DBTEAMLOGDeviceSessionLogInfo *)deviceSessionInfo {

  self = [super init];
  if (self) {
    _deviceSessionInfo = deviceSessionInfo;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDeviceSessionInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpMobileDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpMobileDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpMobileDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.deviceSessionInfo != nil) {
    result = prime * result + [self.deviceSessionInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpMobileDetails:other];
}

- (BOOL)isEqualToDeviceChangeIpMobileDetails:(DBTEAMLOGDeviceChangeIpMobileDetails *)aDeviceChangeIpMobileDetails {
  if (self == aDeviceChangeIpMobileDetails) {
    return YES;
  }
  if (self.deviceSessionInfo) {
    if (![self.deviceSessionInfo isEqual:aDeviceChangeIpMobileDetails.deviceSessionInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpMobileDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpMobileDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.deviceSessionInfo) {
    jsonDict[@"device_session_info"] = [DBTEAMLOGDeviceSessionLogInfoSerializer serialize:valueObj.deviceSessionInfo];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpMobileDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceSessionLogInfo *deviceSessionInfo =
      valueDict[@"device_session_info"]
          ? [DBTEAMLOGDeviceSessionLogInfoSerializer deserialize:valueDict[@"device_session_info"]]
          : nil;

  return [[DBTEAMLOGDeviceChangeIpMobileDetails alloc] initWithDeviceSessionInfo:deviceSessionInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpMobileType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpMobileType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpMobileTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpMobileTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpMobileTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpMobileType:other];
}

- (BOOL)isEqualToDeviceChangeIpMobileType:(DBTEAMLOGDeviceChangeIpMobileType *)aDeviceChangeIpMobileType {
  if (self == aDeviceChangeIpMobileType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceChangeIpMobileType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpMobileTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpMobileType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpMobileType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceChangeIpMobileType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpWebDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpWebDetails

#pragma mark - Constructors

- (instancetype)initWithUserAgent:(NSString *)userAgent {
  [DBStoneValidators nonnullValidator:nil](userAgent);

  self = [super init];
  if (self) {
    _userAgent = userAgent;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpWebDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpWebDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpWebDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.userAgent hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpWebDetails:other];
}

- (BOOL)isEqualToDeviceChangeIpWebDetails:(DBTEAMLOGDeviceChangeIpWebDetails *)aDeviceChangeIpWebDetails {
  if (self == aDeviceChangeIpWebDetails) {
    return YES;
  }
  if (![self.userAgent isEqual:aDeviceChangeIpWebDetails.userAgent]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpWebDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpWebDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user_agent"] = valueObj.userAgent;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpWebDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *userAgent = valueDict[@"user_agent"];

  return [[DBTEAMLOGDeviceChangeIpWebDetails alloc] initWithUserAgent:userAgent];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceChangeIpWebType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceChangeIpWebType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceChangeIpWebTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceChangeIpWebTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceChangeIpWebTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceChangeIpWebType:other];
}

- (BOOL)isEqualToDeviceChangeIpWebType:(DBTEAMLOGDeviceChangeIpWebType *)aDeviceChangeIpWebType {
  if (self == aDeviceChangeIpWebType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceChangeIpWebType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceChangeIpWebTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceChangeIpWebType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceChangeIpWebType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceChangeIpWebType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkFailDetails.h"
#import "DBTEAMLOGSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkFailDetails

#pragma mark - Constructors

- (instancetype)initWithNumFailures:(NSNumber *)numFailures
                        sessionInfo:(DBTEAMLOGSessionLogInfo *)sessionInfo
                        displayName:(NSString *)displayName {
  [DBStoneValidators nonnullValidator:nil](numFailures);

  self = [super init];
  if (self) {
    _sessionInfo = sessionInfo;
    _displayName = displayName;
    _numFailures = numFailures;
  }
  return self;
}

- (instancetype)initWithNumFailures:(NSNumber *)numFailures {
  return [self initWithNumFailures:numFailures sessionInfo:nil displayName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceDeleteOnUnlinkFailDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceDeleteOnUnlinkFailDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceDeleteOnUnlinkFailDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.numFailures hash];
  if (self.sessionInfo != nil) {
    result = prime * result + [self.sessionInfo hash];
  }
  if (self.displayName != nil) {
    result = prime * result + [self.displayName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceDeleteOnUnlinkFailDetails:other];
}

- (BOOL)isEqualToDeviceDeleteOnUnlinkFailDetails:
    (DBTEAMLOGDeviceDeleteOnUnlinkFailDetails *)aDeviceDeleteOnUnlinkFailDetails {
  if (self == aDeviceDeleteOnUnlinkFailDetails) {
    return YES;
  }
  if (![self.numFailures isEqual:aDeviceDeleteOnUnlinkFailDetails.numFailures]) {
    return NO;
  }
  if (self.sessionInfo) {
    if (![self.sessionInfo isEqual:aDeviceDeleteOnUnlinkFailDetails.sessionInfo]) {
      return NO;
    }
  }
  if (self.displayName) {
    if (![self.displayName isEqual:aDeviceDeleteOnUnlinkFailDetails.displayName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkFailDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceDeleteOnUnlinkFailDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"num_failures"] = valueObj.numFailures;
  if (valueObj.sessionInfo) {
    jsonDict[@"session_info"] = [DBTEAMLOGSessionLogInfoSerializer serialize:valueObj.sessionInfo];
  }
  if (valueObj.displayName) {
    jsonDict[@"display_name"] = valueObj.displayName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceDeleteOnUnlinkFailDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *numFailures = valueDict[@"num_failures"];
  DBTEAMLOGSessionLogInfo *sessionInfo =
      valueDict[@"session_info"] ? [DBTEAMLOGSessionLogInfoSerializer deserialize:valueDict[@"session_info"]] : nil;
  NSString *displayName = valueDict[@"display_name"] ?: nil;

  return [[DBTEAMLOGDeviceDeleteOnUnlinkFailDetails alloc] initWithNumFailures:numFailures
                                                                   sessionInfo:sessionInfo
                                                                   displayName:displayName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkFailType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkFailType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceDeleteOnUnlinkFailTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceDeleteOnUnlinkFailTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceDeleteOnUnlinkFailTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceDeleteOnUnlinkFailType:other];
}

- (BOOL)isEqualToDeviceDeleteOnUnlinkFailType:(DBTEAMLOGDeviceDeleteOnUnlinkFailType *)aDeviceDeleteOnUnlinkFailType {
  if (self == aDeviceDeleteOnUnlinkFailType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceDeleteOnUnlinkFailType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkFailTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceDeleteOnUnlinkFailType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceDeleteOnUnlinkFailType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceDeleteOnUnlinkFailType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails.h"
#import "DBTEAMLOGSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails

#pragma mark - Constructors

- (instancetype)initWithSessionInfo:(DBTEAMLOGSessionLogInfo *)sessionInfo displayName:(NSString *)displayName {

  self = [super init];
  if (self) {
    _sessionInfo = sessionInfo;
    _displayName = displayName;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithSessionInfo:nil displayName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.sessionInfo != nil) {
    result = prime * result + [self.sessionInfo hash];
  }
  if (self.displayName != nil) {
    result = prime * result + [self.displayName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceDeleteOnUnlinkSuccessDetails:other];
}

- (BOOL)isEqualToDeviceDeleteOnUnlinkSuccessDetails:
    (DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)aDeviceDeleteOnUnlinkSuccessDetails {
  if (self == aDeviceDeleteOnUnlinkSuccessDetails) {
    return YES;
  }
  if (self.sessionInfo) {
    if (![self.sessionInfo isEqual:aDeviceDeleteOnUnlinkSuccessDetails.sessionInfo]) {
      return NO;
    }
  }
  if (self.displayName) {
    if (![self.displayName isEqual:aDeviceDeleteOnUnlinkSuccessDetails.displayName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.sessionInfo) {
    jsonDict[@"session_info"] = [DBTEAMLOGSessionLogInfoSerializer serialize:valueObj.sessionInfo];
  }
  if (valueObj.displayName) {
    jsonDict[@"display_name"] = valueObj.displayName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGSessionLogInfo *sessionInfo =
      valueDict[@"session_info"] ? [DBTEAMLOGSessionLogInfoSerializer deserialize:valueDict[@"session_info"]] : nil;
  NSString *displayName = valueDict[@"display_name"] ?: nil;

  return [[DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails alloc] initWithSessionInfo:sessionInfo displayName:displayName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkSuccessType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkSuccessType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceDeleteOnUnlinkSuccessTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceDeleteOnUnlinkSuccessTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceDeleteOnUnlinkSuccessTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceDeleteOnUnlinkSuccessType:other];
}

- (BOOL)isEqualToDeviceDeleteOnUnlinkSuccessType:
    (DBTEAMLOGDeviceDeleteOnUnlinkSuccessType *)aDeviceDeleteOnUnlinkSuccessType {
  if (self == aDeviceDeleteOnUnlinkSuccessType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceDeleteOnUnlinkSuccessType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceDeleteOnUnlinkSuccessTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceDeleteOnUnlinkSuccessType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceDeleteOnUnlinkSuccessType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceDeleteOnUnlinkSuccessType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceLinkFailDetails.h"
#import "DBTEAMLOGDeviceType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceLinkFailDetails

#pragma mark - Constructors

- (instancetype)initWithDeviceType:(DBTEAMLOGDeviceType *)deviceType ipAddress:(NSString *)ipAddress {
  [DBStoneValidators nonnullValidator:nil](deviceType);

  self = [super init];
  if (self) {
    _ipAddress = ipAddress;
    _deviceType = deviceType;
  }
  return self;
}

- (instancetype)initWithDeviceType:(DBTEAMLOGDeviceType *)deviceType {
  return [self initWithDeviceType:deviceType ipAddress:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceLinkFailDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceLinkFailDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceLinkFailDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.deviceType hash];
  if (self.ipAddress != nil) {
    result = prime * result + [self.ipAddress hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceLinkFailDetails:other];
}

- (BOOL)isEqualToDeviceLinkFailDetails:(DBTEAMLOGDeviceLinkFailDetails *)aDeviceLinkFailDetails {
  if (self == aDeviceLinkFailDetails) {
    return YES;
  }
  if (![self.deviceType isEqual:aDeviceLinkFailDetails.deviceType]) {
    return NO;
  }
  if (self.ipAddress) {
    if (![self.ipAddress isEqual:aDeviceLinkFailDetails.ipAddress]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceLinkFailDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceLinkFailDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"device_type"] = [DBTEAMLOGDeviceTypeSerializer serialize:valueObj.deviceType];
  if (valueObj.ipAddress) {
    jsonDict[@"ip_address"] = valueObj.ipAddress;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceLinkFailDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceType *deviceType = [DBTEAMLOGDeviceTypeSerializer deserialize:valueDict[@"device_type"]];
  NSString *ipAddress = valueDict[@"ip_address"] ?: nil;

  return [[DBTEAMLOGDeviceLinkFailDetails alloc] initWithDeviceType:deviceType ipAddress:ipAddress];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceLinkFailType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceLinkFailType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceLinkFailTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceLinkFailTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceLinkFailTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceLinkFailType:other];
}

- (BOOL)isEqualToDeviceLinkFailType:(DBTEAMLOGDeviceLinkFailType *)aDeviceLinkFailType {
  if (self == aDeviceLinkFailType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceLinkFailType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceLinkFailTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceLinkFailType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceLinkFailType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceLinkFailType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceLinkSuccessDetails.h"
#import "DBTEAMLOGDeviceSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceLinkSuccessDetails

#pragma mark - Constructors

- (instancetype)initWithDeviceSessionInfo:(DBTEAMLOGDeviceSessionLogInfo *)deviceSessionInfo {

  self = [super init];
  if (self) {
    _deviceSessionInfo = deviceSessionInfo;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithDeviceSessionInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceLinkSuccessDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceLinkSuccessDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceLinkSuccessDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.deviceSessionInfo != nil) {
    result = prime * result + [self.deviceSessionInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceLinkSuccessDetails:other];
}

- (BOOL)isEqualToDeviceLinkSuccessDetails:(DBTEAMLOGDeviceLinkSuccessDetails *)aDeviceLinkSuccessDetails {
  if (self == aDeviceLinkSuccessDetails) {
    return YES;
  }
  if (self.deviceSessionInfo) {
    if (![self.deviceSessionInfo isEqual:aDeviceLinkSuccessDetails.deviceSessionInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceLinkSuccessDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceLinkSuccessDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.deviceSessionInfo) {
    jsonDict[@"device_session_info"] = [DBTEAMLOGDeviceSessionLogInfoSerializer serialize:valueObj.deviceSessionInfo];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceLinkSuccessDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDeviceSessionLogInfo *deviceSessionInfo =
      valueDict[@"device_session_info"]
          ? [DBTEAMLOGDeviceSessionLogInfoSerializer deserialize:valueDict[@"device_session_info"]]
          : nil;

  return [[DBTEAMLOGDeviceLinkSuccessDetails alloc] initWithDeviceSessionInfo:deviceSessionInfo];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceLinkSuccessType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceLinkSuccessType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceLinkSuccessTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceLinkSuccessTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceLinkSuccessTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceLinkSuccessType:other];
}

- (BOOL)isEqualToDeviceLinkSuccessType:(DBTEAMLOGDeviceLinkSuccessType *)aDeviceLinkSuccessType {
  if (self == aDeviceLinkSuccessType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceLinkSuccessType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceLinkSuccessTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceLinkSuccessType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceLinkSuccessType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceLinkSuccessType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceManagementDisabledDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceManagementDisabledDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceManagementDisabledDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceManagementDisabledDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceManagementDisabledDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceManagementDisabledDetails:other];
}

- (BOOL)isEqualToDeviceManagementDisabledDetails:
    (DBTEAMLOGDeviceManagementDisabledDetails *)aDeviceManagementDisabledDetails {
  if (self == aDeviceManagementDisabledDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceManagementDisabledDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceManagementDisabledDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceManagementDisabledDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDeviceManagementDisabledDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceManagementDisabledType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceManagementDisabledType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceManagementDisabledTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceManagementDisabledTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceManagementDisabledTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceManagementDisabledType:other];
}

- (BOOL)isEqualToDeviceManagementDisabledType:(DBTEAMLOGDeviceManagementDisabledType *)aDeviceManagementDisabledType {
  if (self == aDeviceManagementDisabledType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceManagementDisabledType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceManagementDisabledTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceManagementDisabledType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceManagementDisabledType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceManagementDisabledType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceManagementEnabledDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceManagementEnabledDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceManagementEnabledDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceManagementEnabledDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceManagementEnabledDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceManagementEnabledDetails:other];
}

- (BOOL)isEqualToDeviceManagementEnabledDetails:
    (DBTEAMLOGDeviceManagementEnabledDetails *)aDeviceManagementEnabledDetails {
  if (self == aDeviceManagementEnabledDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceManagementEnabledDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceManagementEnabledDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceManagementEnabledDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDeviceManagementEnabledDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceManagementEnabledType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceManagementEnabledType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceManagementEnabledTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceManagementEnabledTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceManagementEnabledTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceManagementEnabledType:other];
}

- (BOOL)isEqualToDeviceManagementEnabledType:(DBTEAMLOGDeviceManagementEnabledType *)aDeviceManagementEnabledType {
  if (self == aDeviceManagementEnabledType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceManagementEnabledType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceManagementEnabledTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceManagementEnabledType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceManagementEnabledType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceManagementEnabledType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGBackupStatus.h"
#import "DBTEAMLOGDesktopDeviceSessionLogInfo.h"
#import "DBTEAMLOGDeviceSyncBackupStatusChangedDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceSyncBackupStatusChangedDetails

#pragma mark - Constructors

- (instancetype)initWithDesktopDeviceSessionInfo:(DBTEAMLOGDesktopDeviceSessionLogInfo *)desktopDeviceSessionInfo
                                   previousValue:(DBTEAMLOGBackupStatus *)previousValue
                                       dNewValue:(DBTEAMLOGBackupStatus *)dNewValue {
  [DBStoneValidators nonnullValidator:nil](desktopDeviceSessionInfo);
  [DBStoneValidators nonnullValidator:nil](previousValue);
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _desktopDeviceSessionInfo = desktopDeviceSessionInfo;
    _previousValue = previousValue;
    _dNewValue = dNewValue;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceSyncBackupStatusChangedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceSyncBackupStatusChangedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceSyncBackupStatusChangedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.desktopDeviceSessionInfo hash];
  result = prime * result + [self.previousValue hash];
  result = prime * result + [self.dNewValue hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceSyncBackupStatusChangedDetails:other];
}

- (BOOL)isEqualToDeviceSyncBackupStatusChangedDetails:
    (DBTEAMLOGDeviceSyncBackupStatusChangedDetails *)aDeviceSyncBackupStatusChangedDetails {
  if (self == aDeviceSyncBackupStatusChangedDetails) {
    return YES;
  }
  if (![self.desktopDeviceSessionInfo isEqual:aDeviceSyncBackupStatusChangedDetails.desktopDeviceSessionInfo]) {
    return NO;
  }
  if (![self.previousValue isEqual:aDeviceSyncBackupStatusChangedDetails.previousValue]) {
    return NO;
  }
  if (![self.dNewValue isEqual:aDeviceSyncBackupStatusChangedDetails.dNewValue]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceSyncBackupStatusChangedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceSyncBackupStatusChangedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"desktop_device_session_info"] =
      [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer serialize:valueObj.desktopDeviceSessionInfo];
  jsonDict[@"previous_value"] = [DBTEAMLOGBackupStatusSerializer serialize:valueObj.previousValue];
  jsonDict[@"new_value"] = [DBTEAMLOGBackupStatusSerializer serialize:valueObj.dNewValue];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceSyncBackupStatusChangedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGDesktopDeviceSessionLogInfo *desktopDeviceSessionInfo =
      [DBTEAMLOGDesktopDeviceSessionLogInfoSerializer deserialize:valueDict[@"desktop_device_session_info"]];
  DBTEAMLOGBackupStatus *previousValue = [DBTEAMLOGBackupStatusSerializer deserialize:valueDict[@"previous_value"]];
  DBTEAMLOGBackupStatus *dNewValue = [DBTEAMLOGBackupStatusSerializer deserialize:valueDict[@"new_value"]];

  return
      [[DBTEAMLOGDeviceSyncBackupStatusChangedDetails alloc] initWithDesktopDeviceSessionInfo:desktopDeviceSessionInfo
                                                                                previousValue:previousValue
                                                                                    dNewValue:dNewValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceSyncBackupStatusChangedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceSyncBackupStatusChangedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceSyncBackupStatusChangedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceSyncBackupStatusChangedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceSyncBackupStatusChangedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceSyncBackupStatusChangedType:other];
}

- (BOOL)isEqualToDeviceSyncBackupStatusChangedType:
    (DBTEAMLOGDeviceSyncBackupStatusChangedType *)aDeviceSyncBackupStatusChangedType {
  if (self == aDeviceSyncBackupStatusChangedType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceSyncBackupStatusChangedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceSyncBackupStatusChangedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceSyncBackupStatusChangedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceSyncBackupStatusChangedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceSyncBackupStatusChangedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceType

#pragma mark - Constructors

- (instancetype)initWithDesktop {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceTypeDesktop;
  }
  return self;
}

- (instancetype)initWithMobile {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceTypeMobile;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDesktop {
  return _tag == DBTEAMLOGDeviceTypeDesktop;
}

- (BOOL)isMobile {
  return _tag == DBTEAMLOGDeviceTypeMobile;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGDeviceTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGDeviceTypeDesktop:
    return @"DBTEAMLOGDeviceTypeDesktop";
  case DBTEAMLOGDeviceTypeMobile:
    return @"DBTEAMLOGDeviceTypeMobile";
  case DBTEAMLOGDeviceTypeOther:
    return @"DBTEAMLOGDeviceTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGDeviceTypeDesktop:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceTypeMobile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceType:other];
}

- (BOOL)isEqualToDeviceType:(DBTEAMLOGDeviceType *)aDeviceType {
  if (self == aDeviceType) {
    return YES;
  }
  if (self.tag != aDeviceType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGDeviceTypeDesktop:
    return [[self tagName] isEqual:[aDeviceType tagName]];
  case DBTEAMLOGDeviceTypeMobile:
    return [[self tagName] isEqual:[aDeviceType tagName]];
  case DBTEAMLOGDeviceTypeOther:
    return [[self tagName] isEqual:[aDeviceType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDesktop]) {
    jsonDict[@".tag"] = @"desktop";
  } else if ([valueObj isMobile]) {
    jsonDict[@".tag"] = @"mobile";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"desktop"]) {
    return [[DBTEAMLOGDeviceType alloc] initWithDesktop];
  } else if ([tag isEqualToString:@"mobile"]) {
    return [[DBTEAMLOGDeviceType alloc] initWithMobile];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGDeviceType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGDeviceType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceUnlinkDetails.h"
#import "DBTEAMLOGSessionLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceUnlinkDetails

#pragma mark - Constructors

- (instancetype)initWithDeleteData:(NSNumber *)deleteData
                       sessionInfo:(DBTEAMLOGSessionLogInfo *)sessionInfo
                       displayName:(NSString *)displayName {
  [DBStoneValidators nonnullValidator:nil](deleteData);

  self = [super init];
  if (self) {
    _sessionInfo = sessionInfo;
    _displayName = displayName;
    _deleteData = deleteData;
  }
  return self;
}

- (instancetype)initWithDeleteData:(NSNumber *)deleteData {
  return [self initWithDeleteData:deleteData sessionInfo:nil displayName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceUnlinkDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceUnlinkDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceUnlinkDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.deleteData hash];
  if (self.sessionInfo != nil) {
    result = prime * result + [self.sessionInfo hash];
  }
  if (self.displayName != nil) {
    result = prime * result + [self.displayName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceUnlinkDetails:other];
}

- (BOOL)isEqualToDeviceUnlinkDetails:(DBTEAMLOGDeviceUnlinkDetails *)aDeviceUnlinkDetails {
  if (self == aDeviceUnlinkDetails) {
    return YES;
  }
  if (![self.deleteData isEqual:aDeviceUnlinkDetails.deleteData]) {
    return NO;
  }
  if (self.sessionInfo) {
    if (![self.sessionInfo isEqual:aDeviceUnlinkDetails.sessionInfo]) {
      return NO;
    }
  }
  if (self.displayName) {
    if (![self.displayName isEqual:aDeviceUnlinkDetails.displayName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceUnlinkDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceUnlinkDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"delete_data"] = valueObj.deleteData;
  if (valueObj.sessionInfo) {
    jsonDict[@"session_info"] = [DBTEAMLOGSessionLogInfoSerializer serialize:valueObj.sessionInfo];
  }
  if (valueObj.displayName) {
    jsonDict[@"display_name"] = valueObj.displayName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceUnlinkDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *deleteData = valueDict[@"delete_data"];
  DBTEAMLOGSessionLogInfo *sessionInfo =
      valueDict[@"session_info"] ? [DBTEAMLOGSessionLogInfoSerializer deserialize:valueDict[@"session_info"]] : nil;
  NSString *displayName = valueDict[@"display_name"] ?: nil;

  return [[DBTEAMLOGDeviceUnlinkDetails alloc] initWithDeleteData:deleteData
                                                      sessionInfo:sessionInfo
                                                      displayName:displayName];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceUnlinkPolicy.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceUnlinkPolicy

#pragma mark - Constructors

- (instancetype)initWithKeep {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceUnlinkPolicyKeep;
  }
  return self;
}

- (instancetype)initWithRemove {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceUnlinkPolicyRemove;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDeviceUnlinkPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isKeep {
  return _tag == DBTEAMLOGDeviceUnlinkPolicyKeep;
}

- (BOOL)isRemove {
  return _tag == DBTEAMLOGDeviceUnlinkPolicyRemove;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGDeviceUnlinkPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGDeviceUnlinkPolicyKeep:
    return @"DBTEAMLOGDeviceUnlinkPolicyKeep";
  case DBTEAMLOGDeviceUnlinkPolicyRemove:
    return @"DBTEAMLOGDeviceUnlinkPolicyRemove";
  case DBTEAMLOGDeviceUnlinkPolicyOther:
    return @"DBTEAMLOGDeviceUnlinkPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceUnlinkPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceUnlinkPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceUnlinkPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGDeviceUnlinkPolicyKeep:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceUnlinkPolicyRemove:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDeviceUnlinkPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceUnlinkPolicy:other];
}

- (BOOL)isEqualToDeviceUnlinkPolicy:(DBTEAMLOGDeviceUnlinkPolicy *)aDeviceUnlinkPolicy {
  if (self == aDeviceUnlinkPolicy) {
    return YES;
  }
  if (self.tag != aDeviceUnlinkPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGDeviceUnlinkPolicyKeep:
    return [[self tagName] isEqual:[aDeviceUnlinkPolicy tagName]];
  case DBTEAMLOGDeviceUnlinkPolicyRemove:
    return [[self tagName] isEqual:[aDeviceUnlinkPolicy tagName]];
  case DBTEAMLOGDeviceUnlinkPolicyOther:
    return [[self tagName] isEqual:[aDeviceUnlinkPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceUnlinkPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceUnlinkPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isKeep]) {
    jsonDict[@".tag"] = @"keep";
  } else if ([valueObj isRemove]) {
    jsonDict[@".tag"] = @"remove";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceUnlinkPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"keep"]) {
    return [[DBTEAMLOGDeviceUnlinkPolicy alloc] initWithKeep];
  } else if ([tag isEqualToString:@"remove"]) {
    return [[DBTEAMLOGDeviceUnlinkPolicy alloc] initWithRemove];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGDeviceUnlinkPolicy alloc] initWithOther];
  } else {
    return [[DBTEAMLOGDeviceUnlinkPolicy alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDeviceUnlinkType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDeviceUnlinkType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDeviceUnlinkTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDeviceUnlinkTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDeviceUnlinkTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeviceUnlinkType:other];
}

- (BOOL)isEqualToDeviceUnlinkType:(DBTEAMLOGDeviceUnlinkType *)aDeviceUnlinkType {
  if (self == aDeviceUnlinkType) {
    return YES;
  }
  if (![self.description_ isEqual:aDeviceUnlinkType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDeviceUnlinkTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDeviceUnlinkType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDeviceUnlinkType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDeviceUnlinkType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDirectoryRestrictionsAddMembersDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDirectoryRestrictionsAddMembersDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDirectoryRestrictionsAddMembersDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDirectoryRestrictionsAddMembersDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDirectoryRestrictionsAddMembersDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDirectoryRestrictionsAddMembersDetails:other];
}

- (BOOL)isEqualToDirectoryRestrictionsAddMembersDetails:
    (DBTEAMLOGDirectoryRestrictionsAddMembersDetails *)aDirectoryRestrictionsAddMembersDetails {
  if (self == aDirectoryRestrictionsAddMembersDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDirectoryRestrictionsAddMembersDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDirectoryRestrictionsAddMembersDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDirectoryRestrictionsAddMembersDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDirectoryRestrictionsAddMembersDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDirectoryRestrictionsAddMembersType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDirectoryRestrictionsAddMembersType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDirectoryRestrictionsAddMembersTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDirectoryRestrictionsAddMembersTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDirectoryRestrictionsAddMembersTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDirectoryRestrictionsAddMembersType:other];
}

- (BOOL)isEqualToDirectoryRestrictionsAddMembersType:
    (DBTEAMLOGDirectoryRestrictionsAddMembersType *)aDirectoryRestrictionsAddMembersType {
  if (self == aDirectoryRestrictionsAddMembersType) {
    return YES;
  }
  if (![self.description_ isEqual:aDirectoryRestrictionsAddMembersType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDirectoryRestrictionsAddMembersTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDirectoryRestrictionsAddMembersType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDirectoryRestrictionsAddMembersType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDirectoryRestrictionsAddMembersType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDirectoryRestrictionsRemoveMembersDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDirectoryRestrictionsRemoveMembersDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDirectoryRestrictionsRemoveMembersDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDirectoryRestrictionsRemoveMembersDetails:other];
}

- (BOOL)isEqualToDirectoryRestrictionsRemoveMembersDetails:
    (DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails *)aDirectoryRestrictionsRemoveMembersDetails {
  if (self == aDirectoryRestrictionsRemoveMembersDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDirectoryRestrictionsRemoveMembersDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDirectoryRestrictionsRemoveMembersType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDirectoryRestrictionsRemoveMembersType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDirectoryRestrictionsRemoveMembersTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDirectoryRestrictionsRemoveMembersTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDirectoryRestrictionsRemoveMembersTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDirectoryRestrictionsRemoveMembersType:other];
}

- (BOOL)isEqualToDirectoryRestrictionsRemoveMembersType:
    (DBTEAMLOGDirectoryRestrictionsRemoveMembersType *)aDirectoryRestrictionsRemoveMembersType {
  if (self == aDirectoryRestrictionsRemoveMembersType) {
    return YES;
  }
  if (![self.description_ isEqual:aDirectoryRestrictionsRemoveMembersType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDirectoryRestrictionsRemoveMembersTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDirectoryRestrictionsRemoveMembersType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDirectoryRestrictionsRemoveMembersType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDirectoryRestrictionsRemoveMembersType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDisabledDomainInvitesDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDisabledDomainInvitesDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDisabledDomainInvitesDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDisabledDomainInvitesDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDisabledDomainInvitesDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDisabledDomainInvitesDetails:other];
}

- (BOOL)isEqualToDisabledDomainInvitesDetails:(DBTEAMLOGDisabledDomainInvitesDetails *)aDisabledDomainInvitesDetails {
  if (self == aDisabledDomainInvitesDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDisabledDomainInvitesDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDisabledDomainInvitesDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDisabledDomainInvitesDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDisabledDomainInvitesDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDisabledDomainInvitesType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDisabledDomainInvitesType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDisabledDomainInvitesTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDisabledDomainInvitesTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDisabledDomainInvitesTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDisabledDomainInvitesType:other];
}

- (BOOL)isEqualToDisabledDomainInvitesType:(DBTEAMLOGDisabledDomainInvitesType *)aDisabledDomainInvitesType {
  if (self == aDisabledDomainInvitesType) {
    return YES;
  }
  if (![self.description_ isEqual:aDisabledDomainInvitesType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDisabledDomainInvitesTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDisabledDomainInvitesType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDisabledDomainInvitesType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDisabledDomainInvitesType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDispositionActionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDispositionActionType

#pragma mark - Constructors

- (instancetype)initWithAutomaticDelete {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDispositionActionTypeAutomaticDelete;
  }
  return self;
}

- (instancetype)initWithAutomaticPermanentlyDelete {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDispositionActionTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAutomaticDelete {
  return _tag == DBTEAMLOGDispositionActionTypeAutomaticDelete;
}

- (BOOL)isAutomaticPermanentlyDelete {
  return _tag == DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGDispositionActionTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGDispositionActionTypeAutomaticDelete:
    return @"DBTEAMLOGDispositionActionTypeAutomaticDelete";
  case DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete:
    return @"DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete";
  case DBTEAMLOGDispositionActionTypeOther:
    return @"DBTEAMLOGDispositionActionTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDispositionActionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDispositionActionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDispositionActionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGDispositionActionTypeAutomaticDelete:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDispositionActionTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDispositionActionType:other];
}

- (BOOL)isEqualToDispositionActionType:(DBTEAMLOGDispositionActionType *)aDispositionActionType {
  if (self == aDispositionActionType) {
    return YES;
  }
  if (self.tag != aDispositionActionType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGDispositionActionTypeAutomaticDelete:
    return [[self tagName] isEqual:[aDispositionActionType tagName]];
  case DBTEAMLOGDispositionActionTypeAutomaticPermanentlyDelete:
    return [[self tagName] isEqual:[aDispositionActionType tagName]];
  case DBTEAMLOGDispositionActionTypeOther:
    return [[self tagName] isEqual:[aDispositionActionType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDispositionActionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDispositionActionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAutomaticDelete]) {
    jsonDict[@".tag"] = @"automatic_delete";
  } else if ([valueObj isAutomaticPermanentlyDelete]) {
    jsonDict[@".tag"] = @"automatic_permanently_delete";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDispositionActionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"automatic_delete"]) {
    return [[DBTEAMLOGDispositionActionType alloc] initWithAutomaticDelete];
  } else if ([tag isEqualToString:@"automatic_permanently_delete"]) {
    return [[DBTEAMLOGDispositionActionType alloc] initWithAutomaticPermanentlyDelete];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGDispositionActionType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGDispositionActionType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesApproveRequestToJoinTeamDetails:other];
}

- (BOOL)isEqualToDomainInvitesApproveRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails *)aDomainInvitesApproveRequestToJoinTeamDetails {
  if (self == aDomainInvitesApproveRequestToJoinTeamDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesApproveRequestToJoinTeamTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesApproveRequestToJoinTeamTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesApproveRequestToJoinTeamTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesApproveRequestToJoinTeamType:other];
}

- (BOOL)isEqualToDomainInvitesApproveRequestToJoinTeamType:
    (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType *)aDomainInvitesApproveRequestToJoinTeamType {
  if (self == aDomainInvitesApproveRequestToJoinTeamType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesApproveRequestToJoinTeamType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesApproveRequestToJoinTeamTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesApproveRequestToJoinTeamType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesDeclineRequestToJoinTeamDetails:other];
}

- (BOOL)isEqualToDomainInvitesDeclineRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails *)aDomainInvitesDeclineRequestToJoinTeamDetails {
  if (self == aDomainInvitesDeclineRequestToJoinTeamDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesDeclineRequestToJoinTeamType:other];
}

- (BOOL)isEqualToDomainInvitesDeclineRequestToJoinTeamType:
    (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType *)aDomainInvitesDeclineRequestToJoinTeamType {
  if (self == aDomainInvitesDeclineRequestToJoinTeamType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesDeclineRequestToJoinTeamType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesEmailExistingUsersDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesEmailExistingUsersDetails

#pragma mark - Constructors

- (instancetype)initWithDomainName:(NSString *)domainName numRecipients:(NSNumber *)numRecipients {
  [DBStoneValidators nonnullValidator:nil](domainName);
  [DBStoneValidators nonnullValidator:nil](numRecipients);

  self = [super init];
  if (self) {
    _domainName = domainName;
    _numRecipients = numRecipients;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesEmailExistingUsersDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesEmailExistingUsersDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesEmailExistingUsersDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainName hash];
  result = prime * result + [self.numRecipients hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesEmailExistingUsersDetails:other];
}

- (BOOL)isEqualToDomainInvitesEmailExistingUsersDetails:
    (DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)aDomainInvitesEmailExistingUsersDetails {
  if (self == aDomainInvitesEmailExistingUsersDetails) {
    return YES;
  }
  if (![self.domainName isEqual:aDomainInvitesEmailExistingUsersDetails.domainName]) {
    return NO;
  }
  if (![self.numRecipients isEqual:aDomainInvitesEmailExistingUsersDetails.numRecipients]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesEmailExistingUsersDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_name"] = valueObj.domainName;
  jsonDict[@"num_recipients"] = valueObj.numRecipients;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *domainName = valueDict[@"domain_name"];
  NSNumber *numRecipients = valueDict[@"num_recipients"];

  return [[DBTEAMLOGDomainInvitesEmailExistingUsersDetails alloc] initWithDomainName:domainName
                                                                       numRecipients:numRecipients];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesEmailExistingUsersType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesEmailExistingUsersType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesEmailExistingUsersTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesEmailExistingUsersTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesEmailExistingUsersTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesEmailExistingUsersType:other];
}

- (BOOL)isEqualToDomainInvitesEmailExistingUsersType:
    (DBTEAMLOGDomainInvitesEmailExistingUsersType *)aDomainInvitesEmailExistingUsersType {
  if (self == aDomainInvitesEmailExistingUsersType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesEmailExistingUsersType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesEmailExistingUsersTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesEmailExistingUsersType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesEmailExistingUsersType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesEmailExistingUsersType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesRequestToJoinTeamDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesRequestToJoinTeamDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesRequestToJoinTeamDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesRequestToJoinTeamDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesRequestToJoinTeamDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesRequestToJoinTeamDetails:other];
}

- (BOOL)isEqualToDomainInvitesRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesRequestToJoinTeamDetails *)aDomainInvitesRequestToJoinTeamDetails {
  if (self == aDomainInvitesRequestToJoinTeamDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesRequestToJoinTeamDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesRequestToJoinTeamDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesRequestToJoinTeamDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDomainInvitesRequestToJoinTeamDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesRequestToJoinTeamType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesRequestToJoinTeamType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesRequestToJoinTeamTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesRequestToJoinTeamTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesRequestToJoinTeamTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesRequestToJoinTeamType:other];
}

- (BOOL)isEqualToDomainInvitesRequestToJoinTeamType:
    (DBTEAMLOGDomainInvitesRequestToJoinTeamType *)aDomainInvitesRequestToJoinTeamType {
  if (self == aDomainInvitesRequestToJoinTeamType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesRequestToJoinTeamType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesRequestToJoinTeamTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesRequestToJoinTeamType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesRequestToJoinTeamType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesRequestToJoinTeamType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesSetInviteNewUserPrefToNoDetails:other];
}

- (BOOL)isEqualToDomainInvitesSetInviteNewUserPrefToNoDetails:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails *)aDomainInvitesSetInviteNewUserPrefToNoDetails {
  if (self == aDomainInvitesSetInviteNewUserPrefToNoDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesSetInviteNewUserPrefToNoType:other];
}

- (BOOL)isEqualToDomainInvitesSetInviteNewUserPrefToNoType:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType *)aDomainInvitesSetInviteNewUserPrefToNoType {
  if (self == aDomainInvitesSetInviteNewUserPrefToNoType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesSetInviteNewUserPrefToNoType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesSetInviteNewUserPrefToYesDetails:other];
}

- (BOOL)isEqualToDomainInvitesSetInviteNewUserPrefToYesDetails:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails *)aDomainInvitesSetInviteNewUserPrefToYesDetails {
  if (self == aDomainInvitesSetInviteNewUserPrefToYesDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainInvitesSetInviteNewUserPrefToYesType:other];
}

- (BOOL)isEqualToDomainInvitesSetInviteNewUserPrefToYesType:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType *)aDomainInvitesSetInviteNewUserPrefToYesType {
  if (self == aDomainInvitesSetInviteNewUserPrefToYesType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainInvitesSetInviteNewUserPrefToYesType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationAddDomainFailDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationAddDomainFailDetails

#pragma mark - Constructors

- (instancetype)initWithDomainName:(NSString *)domainName verificationMethod:(NSString *)verificationMethod {
  [DBStoneValidators nonnullValidator:nil](domainName);

  self = [super init];
  if (self) {
    _domainName = domainName;
    _verificationMethod = verificationMethod;
  }
  return self;
}

- (instancetype)initWithDomainName:(NSString *)domainName {
  return [self initWithDomainName:domainName verificationMethod:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationAddDomainFailDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationAddDomainFailDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationAddDomainFailDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainName hash];
  if (self.verificationMethod != nil) {
    result = prime * result + [self.verificationMethod hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationAddDomainFailDetails:other];
}

- (BOOL)isEqualToDomainVerificationAddDomainFailDetails:
    (DBTEAMLOGDomainVerificationAddDomainFailDetails *)aDomainVerificationAddDomainFailDetails {
  if (self == aDomainVerificationAddDomainFailDetails) {
    return YES;
  }
  if (![self.domainName isEqual:aDomainVerificationAddDomainFailDetails.domainName]) {
    return NO;
  }
  if (self.verificationMethod) {
    if (![self.verificationMethod isEqual:aDomainVerificationAddDomainFailDetails.verificationMethod]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationAddDomainFailDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationAddDomainFailDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_name"] = valueObj.domainName;
  if (valueObj.verificationMethod) {
    jsonDict[@"verification_method"] = valueObj.verificationMethod;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationAddDomainFailDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *domainName = valueDict[@"domain_name"];
  NSString *verificationMethod = valueDict[@"verification_method"] ?: nil;

  return [[DBTEAMLOGDomainVerificationAddDomainFailDetails alloc] initWithDomainName:domainName
                                                                  verificationMethod:verificationMethod];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationAddDomainFailType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationAddDomainFailType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationAddDomainFailTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationAddDomainFailTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationAddDomainFailTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationAddDomainFailType:other];
}

- (BOOL)isEqualToDomainVerificationAddDomainFailType:
    (DBTEAMLOGDomainVerificationAddDomainFailType *)aDomainVerificationAddDomainFailType {
  if (self == aDomainVerificationAddDomainFailType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainVerificationAddDomainFailType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationAddDomainFailTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationAddDomainFailType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationAddDomainFailType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainVerificationAddDomainFailType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationAddDomainSuccessDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationAddDomainSuccessDetails

#pragma mark - Constructors

- (instancetype)initWithDomainNames:(NSArray<NSString *> *)domainNames
                 verificationMethod:(NSString *)verificationMethod {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](domainNames);

  self = [super init];
  if (self) {
    _domainNames = domainNames;
    _verificationMethod = verificationMethod;
  }
  return self;
}

- (instancetype)initWithDomainNames:(NSArray<NSString *> *)domainNames {
  return [self initWithDomainNames:domainNames verificationMethod:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationAddDomainSuccessDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationAddDomainSuccessDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationAddDomainSuccessDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainNames hash];
  if (self.verificationMethod != nil) {
    result = prime * result + [self.verificationMethod hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationAddDomainSuccessDetails:other];
}

- (BOOL)isEqualToDomainVerificationAddDomainSuccessDetails:
    (DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)aDomainVerificationAddDomainSuccessDetails {
  if (self == aDomainVerificationAddDomainSuccessDetails) {
    return YES;
  }
  if (![self.domainNames isEqual:aDomainVerificationAddDomainSuccessDetails.domainNames]) {
    return NO;
  }
  if (self.verificationMethod) {
    if (![self.verificationMethod isEqual:aDomainVerificationAddDomainSuccessDetails.verificationMethod]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationAddDomainSuccessDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_names"] = [DBArraySerializer serialize:valueObj.domainNames
                                                 withBlock:^id(id elem0) {
                                                   return elem0;
                                                 }];
  if (valueObj.verificationMethod) {
    jsonDict[@"verification_method"] = valueObj.verificationMethod;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *domainNames = [DBArraySerializer deserialize:valueDict[@"domain_names"]
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
  NSString *verificationMethod = valueDict[@"verification_method"] ?: nil;

  return [[DBTEAMLOGDomainVerificationAddDomainSuccessDetails alloc] initWithDomainNames:domainNames
                                                                      verificationMethod:verificationMethod];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationAddDomainSuccessType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationAddDomainSuccessType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationAddDomainSuccessTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationAddDomainSuccessTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationAddDomainSuccessTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationAddDomainSuccessType:other];
}

- (BOOL)isEqualToDomainVerificationAddDomainSuccessType:
    (DBTEAMLOGDomainVerificationAddDomainSuccessType *)aDomainVerificationAddDomainSuccessType {
  if (self == aDomainVerificationAddDomainSuccessType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainVerificationAddDomainSuccessType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationAddDomainSuccessTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationAddDomainSuccessType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationAddDomainSuccessType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainVerificationAddDomainSuccessType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationRemoveDomainDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationRemoveDomainDetails

#pragma mark - Constructors

- (instancetype)initWithDomainNames:(NSArray<NSString *> *)domainNames {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](domainNames);

  self = [super init];
  if (self) {
    _domainNames = domainNames;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationRemoveDomainDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationRemoveDomainDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationRemoveDomainDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.domainNames hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationRemoveDomainDetails:other];
}

- (BOOL)isEqualToDomainVerificationRemoveDomainDetails:
    (DBTEAMLOGDomainVerificationRemoveDomainDetails *)aDomainVerificationRemoveDomainDetails {
  if (self == aDomainVerificationRemoveDomainDetails) {
    return YES;
  }
  if (![self.domainNames isEqual:aDomainVerificationRemoveDomainDetails.domainNames]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationRemoveDomainDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationRemoveDomainDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"domain_names"] = [DBArraySerializer serialize:valueObj.domainNames
                                                 withBlock:^id(id elem0) {
                                                   return elem0;
                                                 }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationRemoveDomainDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *domainNames = [DBArraySerializer deserialize:valueDict[@"domain_names"]
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];

  return [[DBTEAMLOGDomainVerificationRemoveDomainDetails alloc] initWithDomainNames:domainNames];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDomainVerificationRemoveDomainType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDomainVerificationRemoveDomainType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDomainVerificationRemoveDomainTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDomainVerificationRemoveDomainTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDomainVerificationRemoveDomainTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDomainVerificationRemoveDomainType:other];
}

- (BOOL)isEqualToDomainVerificationRemoveDomainType:
    (DBTEAMLOGDomainVerificationRemoveDomainType *)aDomainVerificationRemoveDomainType {
  if (self == aDomainVerificationRemoveDomainType) {
    return YES;
  }
  if (![self.description_ isEqual:aDomainVerificationRemoveDomainType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDomainVerificationRemoveDomainTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDomainVerificationRemoveDomainType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDomainVerificationRemoveDomainType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDomainVerificationRemoveDomainType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDownloadPolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDownloadPolicyType

#pragma mark - Constructors

- (instancetype)initWithAllow {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDownloadPolicyTypeAllow;
  }
  return self;
}

- (instancetype)initWithDisallow {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDownloadPolicyTypeDisallow;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGDownloadPolicyTypeOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAllow {
  return _tag == DBTEAMLOGDownloadPolicyTypeAllow;
}

- (BOOL)isDisallow {
  return _tag == DBTEAMLOGDownloadPolicyTypeDisallow;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGDownloadPolicyTypeOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGDownloadPolicyTypeAllow:
    return @"DBTEAMLOGDownloadPolicyTypeAllow";
  case DBTEAMLOGDownloadPolicyTypeDisallow:
    return @"DBTEAMLOGDownloadPolicyTypeDisallow";
  case DBTEAMLOGDownloadPolicyTypeOther:
    return @"DBTEAMLOGDownloadPolicyTypeOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDownloadPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDownloadPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDownloadPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGDownloadPolicyTypeAllow:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDownloadPolicyTypeDisallow:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGDownloadPolicyTypeOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDownloadPolicyType:other];
}

- (BOOL)isEqualToDownloadPolicyType:(DBTEAMLOGDownloadPolicyType *)aDownloadPolicyType {
  if (self == aDownloadPolicyType) {
    return YES;
  }
  if (self.tag != aDownloadPolicyType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGDownloadPolicyTypeAllow:
    return [[self tagName] isEqual:[aDownloadPolicyType tagName]];
  case DBTEAMLOGDownloadPolicyTypeDisallow:
    return [[self tagName] isEqual:[aDownloadPolicyType tagName]];
  case DBTEAMLOGDownloadPolicyTypeOther:
    return [[self tagName] isEqual:[aDownloadPolicyType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDownloadPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDownloadPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAllow]) {
    jsonDict[@".tag"] = @"allow";
  } else if ([valueObj isDisallow]) {
    jsonDict[@".tag"] = @"disallow";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDownloadPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"allow"]) {
    return [[DBTEAMLOGDownloadPolicyType alloc] initWithAllow];
  } else if ([tag isEqualToString:@"disallow"]) {
    return [[DBTEAMLOGDownloadPolicyType alloc] initWithDisallow];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGDownloadPolicyType alloc] initWithOther];
  } else {
    return [[DBTEAMLOGDownloadPolicyType alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDropboxPasswordsExportedDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDropboxPasswordsExportedDetails

#pragma mark - Constructors

- (instancetype)initWithPlatform:(NSString *)platform {
  [DBStoneValidators nonnullValidator:nil](platform);

  self = [super init];
  if (self) {
    _platform = platform;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDropboxPasswordsExportedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDropboxPasswordsExportedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDropboxPasswordsExportedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.platform hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDropboxPasswordsExportedDetails:other];
}

- (BOOL)isEqualToDropboxPasswordsExportedDetails:
    (DBTEAMLOGDropboxPasswordsExportedDetails *)aDropboxPasswordsExportedDetails {
  if (self == aDropboxPasswordsExportedDetails) {
    return YES;
  }
  if (![self.platform isEqual:aDropboxPasswordsExportedDetails.platform]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDropboxPasswordsExportedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDropboxPasswordsExportedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"platform"] = valueObj.platform;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDropboxPasswordsExportedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *platform = valueDict[@"platform"];

  return [[DBTEAMLOGDropboxPasswordsExportedDetails alloc] initWithPlatform:platform];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDropboxPasswordsExportedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDropboxPasswordsExportedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDropboxPasswordsExportedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDropboxPasswordsExportedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDropboxPasswordsExportedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDropboxPasswordsExportedType:other];
}

- (BOOL)isEqualToDropboxPasswordsExportedType:(DBTEAMLOGDropboxPasswordsExportedType *)aDropboxPasswordsExportedType {
  if (self == aDropboxPasswordsExportedType) {
    return YES;
  }
  if (![self.description_ isEqual:aDropboxPasswordsExportedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDropboxPasswordsExportedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDropboxPasswordsExportedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDropboxPasswordsExportedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDropboxPasswordsExportedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails

#pragma mark - Constructors

- (instancetype)initWithIsFirstDevice:(NSNumber *)isFirstDevice platform:(NSString *)platform {
  [DBStoneValidators nonnullValidator:nil](isFirstDevice);
  [DBStoneValidators nonnullValidator:nil](platform);

  self = [super init];
  if (self) {
    _isFirstDevice = isFirstDevice;
    _platform = platform;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.isFirstDevice hash];
  result = prime * result + [self.platform hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDropboxPasswordsNewDeviceEnrolledDetails:other];
}

- (BOOL)isEqualToDropboxPasswordsNewDeviceEnrolledDetails:
    (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)aDropboxPasswordsNewDeviceEnrolledDetails {
  if (self == aDropboxPasswordsNewDeviceEnrolledDetails) {
    return YES;
  }
  if (![self.isFirstDevice isEqual:aDropboxPasswordsNewDeviceEnrolledDetails.isFirstDevice]) {
    return NO;
  }
  if (![self.platform isEqual:aDropboxPasswordsNewDeviceEnrolledDetails.platform]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"is_first_device"] = valueObj.isFirstDevice;
  jsonDict[@"platform"] = valueObj.platform;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *isFirstDevice = valueDict[@"is_first_device"];
  NSString *platform = valueDict[@"platform"];

  return
      [[DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails alloc] initWithIsFirstDevice:isFirstDevice platform:platform];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType.h"

#pragma mark - API Object

@implementation DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDropboxPasswordsNewDeviceEnrolledTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDropboxPasswordsNewDeviceEnrolledTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDropboxPasswordsNewDeviceEnrolledTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDropboxPasswordsNewDeviceEnrolledType:other];
}

- (BOOL)isEqualToDropboxPasswordsNewDeviceEnrolledType:
    (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType *)aDropboxPasswordsNewDeviceEnrolledType {
  if (self == aDropboxPasswordsNewDeviceEnrolledType) {
    return YES;
  }
  if (![self.description_ isEqual:aDropboxPasswordsNewDeviceEnrolledType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDropboxPasswordsNewDeviceEnrolledTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGDropboxPasswordsNewDeviceEnrolledType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGDurationLogInfo.h"
#import "DBTEAMLOGTimeUnit.h"

#pragma mark - API Object

@implementation DBTEAMLOGDurationLogInfo

#pragma mark - Constructors

- (instancetype)initWithUnit:(DBTEAMLOGTimeUnit *)unit amount:(NSNumber *)amount {
  [DBStoneValidators nonnullValidator:nil](unit);
  [DBStoneValidators nonnullValidator:nil](amount);

  self = [super init];
  if (self) {
    _unit = unit;
    _amount = amount;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGDurationLogInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGDurationLogInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGDurationLogInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.unit hash];
  result = prime * result + [self.amount hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDurationLogInfo:other];
}

- (BOOL)isEqualToDurationLogInfo:(DBTEAMLOGDurationLogInfo *)aDurationLogInfo {
  if (self == aDurationLogInfo) {
    return YES;
  }
  if (![self.unit isEqual:aDurationLogInfo.unit]) {
    return NO;
  }
  if (![self.amount isEqual:aDurationLogInfo.amount]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGDurationLogInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGDurationLogInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"unit"] = [DBTEAMLOGTimeUnitSerializer serialize:valueObj.unit];
  jsonDict[@"amount"] = valueObj.amount;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGDurationLogInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGTimeUnit *unit = [DBTEAMLOGTimeUnitSerializer deserialize:valueDict[@"unit"]];
  NSNumber *amount = valueDict[@"amount"];

  return [[DBTEAMLOGDurationLogInfo alloc] initWithUnit:unit amount:amount];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmAddExceptionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmAddExceptionDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmAddExceptionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmAddExceptionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmAddExceptionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmAddExceptionDetails:other];
}

- (BOOL)isEqualToEmmAddExceptionDetails:(DBTEAMLOGEmmAddExceptionDetails *)anEmmAddExceptionDetails {
  if (self == anEmmAddExceptionDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmAddExceptionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmAddExceptionDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmAddExceptionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEmmAddExceptionDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmAddExceptionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmAddExceptionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmAddExceptionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmAddExceptionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmAddExceptionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmAddExceptionType:other];
}

- (BOOL)isEqualToEmmAddExceptionType:(DBTEAMLOGEmmAddExceptionType *)anEmmAddExceptionType {
  if (self == anEmmAddExceptionType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmAddExceptionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmAddExceptionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmAddExceptionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmAddExceptionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmAddExceptionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmChangePolicyDetails.h"
#import "DBTEAMPOLICIESEmmState.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmChangePolicyDetails

#pragma mark - Constructors

- (instancetype)initWithDNewValue:(DBTEAMPOLICIESEmmState *)dNewValue
                    previousValue:(DBTEAMPOLICIESEmmState *)previousValue {
  [DBStoneValidators nonnullValidator:nil](dNewValue);

  self = [super init];
  if (self) {
    _dNewValue = dNewValue;
    _previousValue = previousValue;
  }
  return self;
}

- (instancetype)initWithDNewValue:(DBTEAMPOLICIESEmmState *)dNewValue {
  return [self initWithDNewValue:dNewValue previousValue:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmChangePolicyDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmChangePolicyDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmChangePolicyDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.dNewValue hash];
  if (self.previousValue != nil) {
    result = prime * result + [self.previousValue hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmChangePolicyDetails:other];
}

- (BOOL)isEqualToEmmChangePolicyDetails:(DBTEAMLOGEmmChangePolicyDetails *)anEmmChangePolicyDetails {
  if (self == anEmmChangePolicyDetails) {
    return YES;
  }
  if (![self.dNewValue isEqual:anEmmChangePolicyDetails.dNewValue]) {
    return NO;
  }
  if (self.previousValue) {
    if (![self.previousValue isEqual:anEmmChangePolicyDetails.previousValue]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmChangePolicyDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmChangePolicyDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"new_value"] = [DBTEAMPOLICIESEmmStateSerializer serialize:valueObj.dNewValue];
  if (valueObj.previousValue) {
    jsonDict[@"previous_value"] = [DBTEAMPOLICIESEmmStateSerializer serialize:valueObj.previousValue];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmChangePolicyDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMPOLICIESEmmState *dNewValue = [DBTEAMPOLICIESEmmStateSerializer deserialize:valueDict[@"new_value"]];
  DBTEAMPOLICIESEmmState *previousValue =
      valueDict[@"previous_value"] ? [DBTEAMPOLICIESEmmStateSerializer deserialize:valueDict[@"previous_value"]] : nil;

  return [[DBTEAMLOGEmmChangePolicyDetails alloc] initWithDNewValue:dNewValue previousValue:previousValue];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmChangePolicyType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmChangePolicyType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmChangePolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmChangePolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmChangePolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmChangePolicyType:other];
}

- (BOOL)isEqualToEmmChangePolicyType:(DBTEAMLOGEmmChangePolicyType *)anEmmChangePolicyType {
  if (self == anEmmChangePolicyType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmChangePolicyType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmChangePolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmChangePolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmChangePolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmChangePolicyType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmCreateExceptionsReportDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmCreateExceptionsReportDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmCreateExceptionsReportDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmCreateExceptionsReportDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmCreateExceptionsReportDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmCreateExceptionsReportDetails:other];
}

- (BOOL)isEqualToEmmCreateExceptionsReportDetails:
    (DBTEAMLOGEmmCreateExceptionsReportDetails *)anEmmCreateExceptionsReportDetails {
  if (self == anEmmCreateExceptionsReportDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmCreateExceptionsReportDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmCreateExceptionsReportDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmCreateExceptionsReportDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEmmCreateExceptionsReportDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmCreateExceptionsReportType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmCreateExceptionsReportType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmCreateExceptionsReportTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmCreateExceptionsReportTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmCreateExceptionsReportTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmCreateExceptionsReportType:other];
}

- (BOOL)isEqualToEmmCreateExceptionsReportType:
    (DBTEAMLOGEmmCreateExceptionsReportType *)anEmmCreateExceptionsReportType {
  if (self == anEmmCreateExceptionsReportType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmCreateExceptionsReportType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmCreateExceptionsReportTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmCreateExceptionsReportType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmCreateExceptionsReportType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmCreateExceptionsReportType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmCreateUsageReportDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmCreateUsageReportDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmCreateUsageReportDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmCreateUsageReportDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmCreateUsageReportDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmCreateUsageReportDetails:other];
}

- (BOOL)isEqualToEmmCreateUsageReportDetails:(DBTEAMLOGEmmCreateUsageReportDetails *)anEmmCreateUsageReportDetails {
  if (self == anEmmCreateUsageReportDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmCreateUsageReportDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmCreateUsageReportDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmCreateUsageReportDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEmmCreateUsageReportDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmCreateUsageReportType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmCreateUsageReportType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmCreateUsageReportTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmCreateUsageReportTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmCreateUsageReportTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmCreateUsageReportType:other];
}

- (BOOL)isEqualToEmmCreateUsageReportType:(DBTEAMLOGEmmCreateUsageReportType *)anEmmCreateUsageReportType {
  if (self == anEmmCreateUsageReportType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmCreateUsageReportType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmCreateUsageReportTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmCreateUsageReportType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmCreateUsageReportType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmCreateUsageReportType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmErrorDetails.h"
#import "DBTEAMLOGFailureDetailsLogInfo.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmErrorDetails

#pragma mark - Constructors

- (instancetype)initWithErrorDetails:(DBTEAMLOGFailureDetailsLogInfo *)errorDetails {
  [DBStoneValidators nonnullValidator:nil](errorDetails);

  self = [super init];
  if (self) {
    _errorDetails = errorDetails;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmErrorDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmErrorDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmErrorDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.errorDetails hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmErrorDetails:other];
}

- (BOOL)isEqualToEmmErrorDetails:(DBTEAMLOGEmmErrorDetails *)anEmmErrorDetails {
  if (self == anEmmErrorDetails) {
    return YES;
  }
  if (![self.errorDetails isEqual:anEmmErrorDetails.errorDetails]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmErrorDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmErrorDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"error_details"] = [DBTEAMLOGFailureDetailsLogInfoSerializer serialize:valueObj.errorDetails];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmErrorDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGFailureDetailsLogInfo *errorDetails =
      [DBTEAMLOGFailureDetailsLogInfoSerializer deserialize:valueDict[@"error_details"]];

  return [[DBTEAMLOGEmmErrorDetails alloc] initWithErrorDetails:errorDetails];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmErrorType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmErrorType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmErrorTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmErrorTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmErrorTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmErrorType:other];
}

- (BOOL)isEqualToEmmErrorType:(DBTEAMLOGEmmErrorType *)anEmmErrorType {
  if (self == anEmmErrorType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmErrorType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmErrorTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmErrorType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmErrorType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmErrorType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmRefreshAuthTokenDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmRefreshAuthTokenDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmRefreshAuthTokenDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmRefreshAuthTokenDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmRefreshAuthTokenDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmRefreshAuthTokenDetails:other];
}

- (BOOL)isEqualToEmmRefreshAuthTokenDetails:(DBTEAMLOGEmmRefreshAuthTokenDetails *)anEmmRefreshAuthTokenDetails {
  if (self == anEmmRefreshAuthTokenDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmRefreshAuthTokenDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmRefreshAuthTokenDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmRefreshAuthTokenDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEmmRefreshAuthTokenDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmRefreshAuthTokenType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmRefreshAuthTokenType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmRefreshAuthTokenTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmRefreshAuthTokenTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmRefreshAuthTokenTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmRefreshAuthTokenType:other];
}

- (BOOL)isEqualToEmmRefreshAuthTokenType:(DBTEAMLOGEmmRefreshAuthTokenType *)anEmmRefreshAuthTokenType {
  if (self == anEmmRefreshAuthTokenType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmRefreshAuthTokenType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmRefreshAuthTokenTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmRefreshAuthTokenType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmRefreshAuthTokenType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmRefreshAuthTokenType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmRemoveExceptionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmRemoveExceptionDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmRemoveExceptionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmRemoveExceptionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmRemoveExceptionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmRemoveExceptionDetails:other];
}

- (BOOL)isEqualToEmmRemoveExceptionDetails:(DBTEAMLOGEmmRemoveExceptionDetails *)anEmmRemoveExceptionDetails {
  if (self == anEmmRemoveExceptionDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmRemoveExceptionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmRemoveExceptionDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmRemoveExceptionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEmmRemoveExceptionDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEmmRemoveExceptionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEmmRemoveExceptionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEmmRemoveExceptionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEmmRemoveExceptionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEmmRemoveExceptionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEmmRemoveExceptionType:other];
}

- (BOOL)isEqualToEmmRemoveExceptionType:(DBTEAMLOGEmmRemoveExceptionType *)anEmmRemoveExceptionType {
  if (self == anEmmRemoveExceptionType) {
    return YES;
  }
  if (![self.description_ isEqual:anEmmRemoveExceptionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEmmRemoveExceptionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEmmRemoveExceptionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEmmRemoveExceptionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEmmRemoveExceptionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEnabledDomainInvitesDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEnabledDomainInvitesDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEnabledDomainInvitesDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEnabledDomainInvitesDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEnabledDomainInvitesDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEnabledDomainInvitesDetails:other];
}

- (BOOL)isEqualToEnabledDomainInvitesDetails:(DBTEAMLOGEnabledDomainInvitesDetails *)anEnabledDomainInvitesDetails {
  if (self == anEnabledDomainInvitesDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEnabledDomainInvitesDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEnabledDomainInvitesDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEnabledDomainInvitesDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEnabledDomainInvitesDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEnabledDomainInvitesType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEnabledDomainInvitesType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEnabledDomainInvitesTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEnabledDomainInvitesTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEnabledDomainInvitesTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEnabledDomainInvitesType:other];
}

- (BOOL)isEqualToEnabledDomainInvitesType:(DBTEAMLOGEnabledDomainInvitesType *)anEnabledDomainInvitesType {
  if (self == anEnabledDomainInvitesType) {
    return YES;
  }
  if (![self.description_ isEqual:anEnabledDomainInvitesType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEnabledDomainInvitesTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEnabledDomainInvitesType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEnabledDomainInvitesType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEnabledDomainInvitesType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails.h"
#import "DBTEAMLOGFedExtraDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails

#pragma mark - Constructors

- (instancetype)initWithFederationExtraDetails:(DBTEAMLOGFedExtraDetails *)federationExtraDetails {
  [DBStoneValidators nonnullValidator:nil](federationExtraDetails);

  self = [super init];
  if (self) {
    _federationExtraDetails = federationExtraDetails;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.federationExtraDetails hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEndedEnterpriseAdminSessionDeprecatedDetails:other];
}

- (BOOL)isEqualToEndedEnterpriseAdminSessionDeprecatedDetails:
    (DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails *)anEndedEnterpriseAdminSessionDeprecatedDetails {
  if (self == anEndedEnterpriseAdminSessionDeprecatedDetails) {
    return YES;
  }
  if (![self.federationExtraDetails isEqual:anEndedEnterpriseAdminSessionDeprecatedDetails.federationExtraDetails]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"federation_extra_details"] =
      [DBTEAMLOGFedExtraDetailsSerializer serialize:valueObj.federationExtraDetails];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBTEAMLOGFedExtraDetails *federationExtraDetails =
      [DBTEAMLOGFedExtraDetailsSerializer deserialize:valueDict[@"federation_extra_details"]];

  return [[DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails alloc]
      initWithFederationExtraDetails:federationExtraDetails];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEndedEnterpriseAdminSessionDeprecatedType:other];
}

- (BOOL)isEqualToEndedEnterpriseAdminSessionDeprecatedType:
    (DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType *)anEndedEnterpriseAdminSessionDeprecatedType {
  if (self == anEndedEnterpriseAdminSessionDeprecatedType) {
    return YES;
  }
  if (![self.description_ isEqual:anEndedEnterpriseAdminSessionDeprecatedType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDetails

#pragma mark - Constructors

- (instancetype)initDefault {

  self = [super init];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEndedEnterpriseAdminSessionDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEndedEnterpriseAdminSessionDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEndedEnterpriseAdminSessionDetails:other];
}

- (BOOL)isEqualToEndedEnterpriseAdminSessionDetails:
    (DBTEAMLOGEndedEnterpriseAdminSessionDetails *)anEndedEnterpriseAdminSessionDetails {
  if (self == anEndedEnterpriseAdminSessionDetails) {
    return YES;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEndedEnterpriseAdminSessionDetails *)valueObj {
#pragma unused(valueObj)
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEndedEnterpriseAdminSessionDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
#pragma unused(valueDict)

  return [[DBTEAMLOGEndedEnterpriseAdminSessionDetails alloc] initDefault];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEndedEnterpriseAdminSessionTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEndedEnterpriseAdminSessionTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEndedEnterpriseAdminSessionTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEndedEnterpriseAdminSessionType:other];
}

- (BOOL)isEqualToEndedEnterpriseAdminSessionType:
    (DBTEAMLOGEndedEnterpriseAdminSessionType *)anEndedEnterpriseAdminSessionType {
  if (self == anEndedEnterpriseAdminSessionType) {
    return YES;
  }
  if (![self.description_ isEqual:anEndedEnterpriseAdminSessionType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEndedEnterpriseAdminSessionTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEndedEnterpriseAdminSessionType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEndedEnterpriseAdminSessionType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEndedEnterpriseAdminSessionType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEnterpriseSettingsLockingDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEnterpriseSettingsLockingDetails

#pragma mark - Constructors

- (instancetype)initWithTeamName:(NSString *)teamName
                    settingsPageName:(NSString *)settingsPageName
    previousSettingsPageLockingState:(NSString *)previousSettingsPageLockingState
        dNewSettingsPageLockingState:(NSString *)dNewSettingsPageLockingState {
  [DBStoneValidators nonnullValidator:nil](teamName);
  [DBStoneValidators nonnullValidator:nil](settingsPageName);
  [DBStoneValidators nonnullValidator:nil](previousSettingsPageLockingState);
  [DBStoneValidators nonnullValidator:nil](dNewSettingsPageLockingState);

  self = [super init];
  if (self) {
    _teamName = teamName;
    _settingsPageName = settingsPageName;
    _previousSettingsPageLockingState = previousSettingsPageLockingState;
    _dNewSettingsPageLockingState = dNewSettingsPageLockingState;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEnterpriseSettingsLockingDetailsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEnterpriseSettingsLockingDetailsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEnterpriseSettingsLockingDetailsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamName hash];
  result = prime * result + [self.settingsPageName hash];
  result = prime * result + [self.previousSettingsPageLockingState hash];
  result = prime * result + [self.dNewSettingsPageLockingState hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEnterpriseSettingsLockingDetails:other];
}

- (BOOL)isEqualToEnterpriseSettingsLockingDetails:
    (DBTEAMLOGEnterpriseSettingsLockingDetails *)anEnterpriseSettingsLockingDetails {
  if (self == anEnterpriseSettingsLockingDetails) {
    return YES;
  }
  if (![self.teamName isEqual:anEnterpriseSettingsLockingDetails.teamName]) {
    return NO;
  }
  if (![self.settingsPageName isEqual:anEnterpriseSettingsLockingDetails.settingsPageName]) {
    return NO;
  }
  if (![self.previousSettingsPageLockingState
          isEqual:anEnterpriseSettingsLockingDetails.previousSettingsPageLockingState]) {
    return NO;
  }
  if (![self.dNewSettingsPageLockingState isEqual:anEnterpriseSettingsLockingDetails.dNewSettingsPageLockingState]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEnterpriseSettingsLockingDetailsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEnterpriseSettingsLockingDetails *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_name"] = valueObj.teamName;
  jsonDict[@"settings_page_name"] = valueObj.settingsPageName;
  jsonDict[@"previous_settings_page_locking_state"] = valueObj.previousSettingsPageLockingState;
  jsonDict[@"new_settings_page_locking_state"] = valueObj.dNewSettingsPageLockingState;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEnterpriseSettingsLockingDetails *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *teamName = valueDict[@"team_name"];
  NSString *settingsPageName = valueDict[@"settings_page_name"];
  NSString *previousSettingsPageLockingState = valueDict[@"previous_settings_page_locking_state"];
  NSString *dNewSettingsPageLockingState = valueDict[@"new_settings_page_locking_state"];

  return [[DBTEAMLOGEnterpriseSettingsLockingDetails alloc] initWithTeamName:teamName
                                                            settingsPageName:settingsPageName
                                            previousSettingsPageLockingState:previousSettingsPageLockingState
                                                dNewSettingsPageLockingState:dNewSettingsPageLockingState];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEnterpriseSettingsLockingType.h"

#pragma mark - API Object

@implementation DBTEAMLOGEnterpriseSettingsLockingType

#pragma mark - Constructors

- (instancetype)initWithDescription_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:nil](description_);

  self = [super init];
  if (self) {
    _description_ = description_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEnterpriseSettingsLockingTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEnterpriseSettingsLockingTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEnterpriseSettingsLockingTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.description_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEnterpriseSettingsLockingType:other];
}

- (BOOL)isEqualToEnterpriseSettingsLockingType:
    (DBTEAMLOGEnterpriseSettingsLockingType *)anEnterpriseSettingsLockingType {
  if (self == anEnterpriseSettingsLockingType) {
    return YES;
  }
  if (![self.description_ isEqual:anEnterpriseSettingsLockingType.description_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEnterpriseSettingsLockingTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEnterpriseSettingsLockingType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"description"] = valueObj.description_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEnterpriseSettingsLockingType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *description_ = valueDict[@"description"];

  return [[DBTEAMLOGEnterpriseSettingsLockingType alloc] initWithDescription_:description_];
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGEventCategory.h"

#pragma mark - API Object

@implementation DBTEAMLOGEventCategory

#pragma mark - Constructors

- (instancetype)initWithAdminAlerting {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryAdminAlerting;
  }
  return self;
}

- (instancetype)initWithApps {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryApps;
  }
  return self;
}

- (instancetype)initWithComments {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryComments;
  }
  return self;
}

- (instancetype)initWithDataGovernance {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryDataGovernance;
  }
  return self;
}

- (instancetype)initWithDevices {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryDevices;
  }
  return self;
}

- (instancetype)initWithDomains {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryDomains;
  }
  return self;
}

- (instancetype)initWithFileOperations {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryFileOperations;
  }
  return self;
}

- (instancetype)initWithFileRequests {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryFileRequests;
  }
  return self;
}

- (instancetype)initWithGroups {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryGroups;
  }
  return self;
}

- (instancetype)initWithLogins {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryLogins;
  }
  return self;
}

- (instancetype)initWithMembers {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryMembers;
  }
  return self;
}

- (instancetype)initWithPaper {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryPaper;
  }
  return self;
}

- (instancetype)initWithPasswords {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryPasswords;
  }
  return self;
}

- (instancetype)initWithReports {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryReports;
  }
  return self;
}

- (instancetype)initWithSharing {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategorySharing;
  }
  return self;
}

- (instancetype)initWithShowcase {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryShowcase;
  }
  return self;
}

- (instancetype)initWithSso {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategorySso;
  }
  return self;
}

- (instancetype)initWithTeamFolders {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryTeamFolders;
  }
  return self;
}

- (instancetype)initWithTeamPolicies {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryTeamPolicies;
  }
  return self;
}

- (instancetype)initWithTeamProfile {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryTeamProfile;
  }
  return self;
}

- (instancetype)initWithTfa {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryTfa;
  }
  return self;
}

- (instancetype)initWithTrustedTeams {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryTrustedTeams;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventCategoryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAdminAlerting {
  return _tag == DBTEAMLOGEventCategoryAdminAlerting;
}

- (BOOL)isApps {
  return _tag == DBTEAMLOGEventCategoryApps;
}

- (BOOL)isComments {
  return _tag == DBTEAMLOGEventCategoryComments;
}

- (BOOL)isDataGovernance {
  return _tag == DBTEAMLOGEventCategoryDataGovernance;
}

- (BOOL)isDevices {
  return _tag == DBTEAMLOGEventCategoryDevices;
}

- (BOOL)isDomains {
  return _tag == DBTEAMLOGEventCategoryDomains;
}

- (BOOL)isFileOperations {
  return _tag == DBTEAMLOGEventCategoryFileOperations;
}

- (BOOL)isFileRequests {
  return _tag == DBTEAMLOGEventCategoryFileRequests;
}

- (BOOL)isGroups {
  return _tag == DBTEAMLOGEventCategoryGroups;
}

- (BOOL)isLogins {
  return _tag == DBTEAMLOGEventCategoryLogins;
}

- (BOOL)isMembers {
  return _tag == DBTEAMLOGEventCategoryMembers;
}

- (BOOL)isPaper {
  return _tag == DBTEAMLOGEventCategoryPaper;
}

- (BOOL)isPasswords {
  return _tag == DBTEAMLOGEventCategoryPasswords;
}

- (BOOL)isReports {
  return _tag == DBTEAMLOGEventCategoryReports;
}

- (BOOL)isSharing {
  return _tag == DBTEAMLOGEventCategorySharing;
}

- (BOOL)isShowcase {
  return _tag == DBTEAMLOGEventCategoryShowcase;
}

- (BOOL)isSso {
  return _tag == DBTEAMLOGEventCategorySso;
}

- (BOOL)isTeamFolders {
  return _tag == DBTEAMLOGEventCategoryTeamFolders;
}

- (BOOL)isTeamPolicies {
  return _tag == DBTEAMLOGEventCategoryTeamPolicies;
}

- (BOOL)isTeamProfile {
  return _tag == DBTEAMLOGEventCategoryTeamProfile;
}

- (BOOL)isTfa {
  return _tag == DBTEAMLOGEventCategoryTfa;
}

- (BOOL)isTrustedTeams {
  return _tag == DBTEAMLOGEventCategoryTrustedTeams;
}

- (BOOL)isOther {
  return _tag == DBTEAMLOGEventCategoryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBTEAMLOGEventCategoryAdminAlerting:
    return @"DBTEAMLOGEventCategoryAdminAlerting";
  case DBTEAMLOGEventCategoryApps:
    return @"DBTEAMLOGEventCategoryApps";
  case DBTEAMLOGEventCategoryComments:
    return @"DBTEAMLOGEventCategoryComments";
  case DBTEAMLOGEventCategoryDataGovernance:
    return @"DBTEAMLOGEventCategoryDataGovernance";
  case DBTEAMLOGEventCategoryDevices:
    return @"DBTEAMLOGEventCategoryDevices";
  case DBTEAMLOGEventCategoryDomains:
    return @"DBTEAMLOGEventCategoryDomains";
  case DBTEAMLOGEventCategoryFileOperations:
    return @"DBTEAMLOGEventCategoryFileOperations";
  case DBTEAMLOGEventCategoryFileRequests:
    return @"DBTEAMLOGEventCategoryFileRequests";
  case DBTEAMLOGEventCategoryGroups:
    return @"DBTEAMLOGEventCategoryGroups";
  case DBTEAMLOGEventCategoryLogins:
    return @"DBTEAMLOGEventCategoryLogins";
  case DBTEAMLOGEventCategoryMembers:
    return @"DBTEAMLOGEventCategoryMembers";
  case DBTEAMLOGEventCategoryPaper:
    return @"DBTEAMLOGEventCategoryPaper";
  case DBTEAMLOGEventCategoryPasswords:
    return @"DBTEAMLOGEventCategoryPasswords";
  case DBTEAMLOGEventCategoryReports:
    return @"DBTEAMLOGEventCategoryReports";
  case DBTEAMLOGEventCategorySharing:
    return @"DBTEAMLOGEventCategorySharing";
  case DBTEAMLOGEventCategoryShowcase:
    return @"DBTEAMLOGEventCategoryShowcase";
  case DBTEAMLOGEventCategorySso:
    return @"DBTEAMLOGEventCategorySso";
  case DBTEAMLOGEventCategoryTeamFolders:
    return @"DBTEAMLOGEventCategoryTeamFolders";
  case DBTEAMLOGEventCategoryTeamPolicies:
    return @"DBTEAMLOGEventCategoryTeamPolicies";
  case DBTEAMLOGEventCategoryTeamProfile:
    return @"DBTEAMLOGEventCategoryTeamProfile";
  case DBTEAMLOGEventCategoryTfa:
    return @"DBTEAMLOGEventCategoryTfa";
  case DBTEAMLOGEventCategoryTrustedTeams:
    return @"DBTEAMLOGEventCategoryTrustedTeams";
  case DBTEAMLOGEventCategoryOther:
    return @"DBTEAMLOGEventCategoryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBTEAMLOGEventCategorySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBTEAMLOGEventCategorySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBTEAMLOGEventCategorySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBTEAMLOGEventCategoryAdminAlerting:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryApps:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryComments:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryDataGovernance:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryDevices:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryDomains:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryFileOperations:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryFileRequests:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryGroups:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryLogins:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryPaper:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryPasswords:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryReports:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategorySharing:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryShowcase:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategorySso:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryTeamFolders:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryTeamPolicies:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryTeamProfile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryTfa:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryTrustedTeams:
    result = prime * result + [[self tagName] hash];
    break;
  case DBTEAMLOGEventCategoryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToEventCategory:other];
}

- (BOOL)isEqualToEventCategory:(DBTEAMLOGEventCategory *)anEventCategory {
  if (self == anEventCategory) {
    return YES;
  }
  if (self.tag != anEventCategory.tag) {
    return NO;
  }
  switch (_tag) {
  case DBTEAMLOGEventCategoryAdminAlerting:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryApps:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryComments:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryDataGovernance:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryDevices:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryDomains:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryFileOperations:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryFileRequests:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryGroups:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryLogins:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryMembers:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryPaper:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryPasswords:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryReports:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategorySharing:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryShowcase:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategorySso:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryTeamFolders:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryTeamPolicies:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryTeamProfile:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryTfa:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryTrustedTeams:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  case DBTEAMLOGEventCategoryOther:
    return [[self tagName] isEqual:[anEventCategory tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBTEAMLOGEventCategorySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBTEAMLOGEventCategory *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAdminAlerting]) {
    jsonDict[@".tag"] = @"admin_alerting";
  } else if ([valueObj isApps]) {
    jsonDict[@".tag"] = @"apps";
  } else if ([valueObj isComments]) {
    jsonDict[@".tag"] = @"comments";
  } else if ([valueObj isDataGovernance]) {
    jsonDict[@".tag"] = @"data_governance";
  } else if ([valueObj isDevices]) {
    jsonDict[@".tag"] = @"devices";
  } else if ([valueObj isDomains]) {
    jsonDict[@".tag"] = @"domains";
  } else if ([valueObj isFileOperations]) {
    jsonDict[@".tag"] = @"file_operations";
  } else if ([valueObj isFileRequests]) {
    jsonDict[@".tag"] = @"file_requests";
  } else if ([valueObj isGroups]) {
    jsonDict[@".tag"] = @"groups";
  } else if ([valueObj isLogins]) {
    jsonDict[@".tag"] = @"logins";
  } else if ([valueObj isMembers]) {
    jsonDict[@".tag"] = @"members";
  } else if ([valueObj isPaper]) {
    jsonDict[@".tag"] = @"paper";
  } else if ([valueObj isPasswords]) {
    jsonDict[@".tag"] = @"passwords";
  } else if ([valueObj isReports]) {
    jsonDict[@".tag"] = @"reports";
  } else if ([valueObj isSharing]) {
    jsonDict[@".tag"] = @"sharing";
  } else if ([valueObj isShowcase]) {
    jsonDict[@".tag"] = @"showcase";
  } else if ([valueObj isSso]) {
    jsonDict[@".tag"] = @"sso";
  } else if ([valueObj isTeamFolders]) {
    jsonDict[@".tag"] = @"team_folders";
  } else if ([valueObj isTeamPolicies]) {
    jsonDict[@".tag"] = @"team_policies";
  } else if ([valueObj isTeamProfile]) {
    jsonDict[@".tag"] = @"team_profile";
  } else if ([valueObj isTfa]) {
    jsonDict[@".tag"] = @"tfa";
  } else if ([valueObj isTrustedTeams]) {
    jsonDict[@".tag"] = @"trusted_teams";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBTEAMLOGEventCategory *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"admin_alerting"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithAdminAlerting];
  } else if ([tag isEqualToString:@"apps"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithApps];
  } else if ([tag isEqualToString:@"comments"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithComments];
  } else if ([tag isEqualToString:@"data_governance"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithDataGovernance];
  } else if ([tag isEqualToString:@"devices"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithDevices];
  } else if ([tag isEqualToString:@"domains"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithDomains];
  } else if ([tag isEqualToString:@"file_operations"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithFileOperations];
  } else if ([tag isEqualToString:@"file_requests"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithFileRequests];
  } else if ([tag isEqualToString:@"groups"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithGroups];
  } else if ([tag isEqualToString:@"logins"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithLogins];
  } else if ([tag isEqualToString:@"members"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithMembers];
  } else if ([tag isEqualToString:@"paper"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithPaper];
  } else if ([tag isEqualToString:@"passwords"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithPasswords];
  } else if ([tag isEqualToString:@"reports"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithReports];
  } else if ([tag isEqualToString:@"sharing"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithSharing];
  } else if ([tag isEqualToString:@"showcase"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithShowcase];
  } else if ([tag isEqualToString:@"sso"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithSso];
  } else if ([tag isEqualToString:@"team_folders"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithTeamFolders];
  } else if ([tag isEqualToString:@"team_policies"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithTeamPolicies];
  } else if ([tag isEqualToString:@"team_profile"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithTeamProfile];
  } else if ([tag isEqualToString:@"tfa"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithTfa];
  } else if ([tag isEqualToString:@"trusted_teams"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithTrustedTeams];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBTEAMLOGEventCategory alloc] initWithOther];
  } else {
    return [[DBTEAMLOGEventCategory alloc] initWithOther];
  }
}

@end

#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMLOGAccountCaptureChangeAvailabilityDetails.h"
#import "DBTEAMLOGAccountCaptureChangePolicyDetails.h"
#import "DBTEAMLOGAccountCaptureMigrateAccountDetails.h"
#import "DBTEAMLOGAccountCaptureNotificationEmailsSentDetails.h"
#import "DBTEAMLOGAccountCaptureRelinquishAccountDetails.h"
#import "DBTEAMLOGAccountLockOrUnlockedDetails.h"
#import "DBTEAMLOGAdminAlertingChangedAlertConfigDetails.h"
#import "DBTEAMLOGAdminAlertingTriggeredAlertDetails.h"
#import "DBTEAMLOGAllowDownloadDisabledDetails.h"
#import "DBTEAMLOGAllowDownloadEnabledDetails.h"
#import "DBTEAMLOGAppLinkTeamDetails.h"
#import "DBTEAMLOGAppLinkUserDetails.h"
#import "DBTEAMLOGAppUnlinkTeamDetails.h"
#import "DBTEAMLOGAppUnlinkUserDetails.h"
#import "DBTEAMLOGBinderAddPageDetails.h"
#import "DBTEAMLOGBinderAddSectionDetails.h"
#import "DBTEAMLOGBinderRemovePageDetails.h"
#import "DBTEAMLOGBinderRemoveSectionDetails.h"
#import "DBTEAMLOGBinderRenamePageDetails.h"
#import "DBTEAMLOGBinderRenameSectionDetails.h"
#import "DBTEAMLOGBinderReorderPageDetails.h"
#import "DBTEAMLOGBinderReorderSectionDetails.h"
#import "DBTEAMLOGCameraUploadsPolicyChangedDetails.h"
#import "DBTEAMLOGChangedEnterpriseAdminRoleDetails.h"
#import "DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails.h"
#import "DBTEAMLOGClassificationChangePolicyDetails.h"
#import "DBTEAMLOGClassificationCreateReportDetails.h"
#import "DBTEAMLOGClassificationCreateReportFailDetails.h"
#import "DBTEAMLOGCollectionShareDetails.h"
#import "DBTEAMLOGComputerBackupPolicyChangedDetails.h"
#import "DBTEAMLOGContentAdministrationPolicyChangedDetails.h"
#import "DBTEAMLOGCreateFolderDetails.h"
#import "DBTEAMLOGCreateTeamInviteLinkDetails.h"
#import "DBTEAMLOGDataPlacementRestrictionChangePolicyDetails.h"
#import "DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails.h"
#import "DBTEAMLOGDeleteTeamInviteLinkDetails.h"
#import "DBTEAMLOGDeviceApprovalsAddExceptionDetails.h"
#import "DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails.h"
#import "DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails.h"
#import "DBTEAMLOGDeviceApprovalsChangeOverageActionDetails.h"
#import "DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails.h"
#import "DBTEAMLOGDeviceApprovalsRemoveExceptionDetails.h"
#import "DBTEAMLOGDeviceChangeIpDesktopDetails.h"
#import "DBTEAMLOGDeviceChangeIpMobileDetails.h"
#import "DBTEAMLOGDeviceChangeIpWebDetails.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkFailDetails.h"
#import "DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails.h"
#import "DBTEAMLOGDeviceLinkFailDetails.h"
#import "DBTEAMLOGDeviceLinkSuccessDetails.h"
#import "DBTEAMLOGDeviceManagementDisabledDetails.h"
#import "DBTEAMLOGDeviceManagementEnabledDetails.h"
#import "DBTEAMLOGDeviceSyncBackupStatusChangedDetails.h"
#import "DBTEAMLOGDeviceUnlinkDetails.h"
#import "DBTEAMLOGDirectoryRestrictionsAddMembersDetails.h"
#import "DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails.h"
#import "DBTEAMLOGDisabledDomainInvitesDetails.h"
#import "DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails.h"
#import "DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails.h"
#import "DBTEAMLOGDomainInvitesEmailExistingUsersDetails.h"
#import "DBTEAMLOGDomainInvitesRequestToJoinTeamDetails.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails.h"
#import "DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails.h"
#import "DBTEAMLOGDomainVerificationAddDomainFailDetails.h"
#import "DBTEAMLOGDomainVerificationAddDomainSuccessDetails.h"
#import "DBTEAMLOGDomainVerificationRemoveDomainDetails.h"
#import "DBTEAMLOGDropboxPasswordsExportedDetails.h"
#import "DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails.h"
#import "DBTEAMLOGEmmAddExceptionDetails.h"
#import "DBTEAMLOGEmmChangePolicyDetails.h"
#import "DBTEAMLOGEmmCreateExceptionsReportDetails.h"
#import "DBTEAMLOGEmmCreateUsageReportDetails.h"
#import "DBTEAMLOGEmmErrorDetails.h"
#import "DBTEAMLOGEmmRefreshAuthTokenDetails.h"
#import "DBTEAMLOGEmmRemoveExceptionDetails.h"
#import "DBTEAMLOGEnabledDomainInvitesDetails.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails.h"
#import "DBTEAMLOGEndedEnterpriseAdminSessionDetails.h"
#import "DBTEAMLOGEnterpriseSettingsLockingDetails.h"
#import "DBTEAMLOGEventDetails.h"
#import "DBTEAMLOGExportMembersReportDetails.h"
#import "DBTEAMLOGExportMembersReportFailDetails.h"
#import "DBTEAMLOGExtendedVersionHistoryChangePolicyDetails.h"
#import "DBTEAMLOGExternalSharingCreateReportDetails.h"
#import "DBTEAMLOGExternalSharingReportFailedDetails.h"
#import "DBTEAMLOGFileAddCommentDetails.h"
#import "DBTEAMLOGFileAddDetails.h"
#import "DBTEAMLOGFileChangeCommentSubscriptionDetails.h"
#import "DBTEAMLOGFileCommentsChangePolicyDetails.h"
#import "DBTEAMLOGFileCopyDetails.h"
#import "DBTEAMLOGFileDeleteCommentDetails.h"
#import "DBTEAMLOGFileDeleteDetails.h"
#import "DBTEAMLOGFileDownloadDetails.h"
#import "DBTEAMLOGFileEditCommentDetails.h"
#import "DBTEAMLOGFileEditDetails.h"
#import "DBTEAMLOGFileGetCopyReferenceDetails.h"
#import "DBTEAMLOGFileLikeCommentDetails.h"
#import "DBTEAMLOGFileLockingLockStatusChangedDetails.h"
#import "DBTEAMLOGFileLockingPolicyChangedDetails.h"
#import "DBTEAMLOGFileMoveDetails.h"
#import "DBTEAMLOGFilePermanentlyDeleteDetails.h"
#import "DBTEAMLOGFilePreviewDetails.h"
#import "DBTEAMLOGFileRenameDetails.h"
#import "DBTEAMLOGFileRequestChangeDetails.h"
#import "DBTEAMLOGFileRequestCloseDetails.h"
#import "DBTEAMLOGFileRequestCreateDetails.h"
#import "DBTEAMLOGFileRequestDeleteDetails.h"
#import "DBTEAMLOGFileRequestReceiveFileDetails.h"
#import "DBTEAMLOGFileRequestsChangePolicyDetails.h"
#import "DBTEAMLOGFileRequestsEmailsEnabledDetails.h"
#import "DBTEAMLOGFileRequestsEmailsRestrictedToTeamOnlyDetails.h"
#import "DBTEAMLOGFileResolveCommentDetails.h"
#import "DBTEAMLOGFileRestoreDetails.h"
#import "DBTEAMLOGFileRevertDetails.h"
#import "DBTEAMLOGFileRollbackChangesDetails.h"
#import "DBTEAMLOGFileSaveCopyReferenceDetails.h"
#import "DBTEAMLOGFileTransfersFileAddDetails.h"
#import "DBTEAMLOGFileTransfersPolicyChangedDetails.h"
#import "DBTEAMLOGFileTransfersTransferDeleteDetails.h"
#import "DBTEAMLOGFileTransfersTransferDownloadDetails.h"
#import "DBTEAMLOGFileTransfersTransferSendDetails.h"
#import "DBTEAMLOGFileTransfersTransferViewDetails.h"
#import "DBTEAMLOGFileUnlikeCommentDetails.h"
#import "DBTEAMLOGFileUnresolveCommentDetails.h"
#import "DBTEAMLOGFolderOverviewDescriptionChangedDetails.h"
#import "DBTEAMLOGFolderOverviewItemPinnedDetails.h"
#import "DBTEAMLOGFolderOverviewItemUnpinnedDetails.h"
#import "DBTEAMLOGGoogleSsoChangePolicyDetails.h"
#import "DBTEAMLOGGovernancePolicyAddFolderFailedDetails.h"
#import "DBTEAMLOGGovernancePolicyAddFoldersDetails.h"
#import "DBTEAMLOGGovernancePolicyContentDisposedDetails.h"
#import "DBTEAMLOGGovernancePolicyCreateDetails.h"
#import "DBTEAMLOGGovernancePolicyDeleteDetails.h"
#import "DBTEAMLOGGovernancePolicyEditDetailsDetails.h"
#import "DBTEAMLOGGovernancePolicyEditDurationDetails.h"
#import "DBTEAMLOGGovernancePolicyExportCreatedDetails.h"
#import "DBTEAMLOGGovernancePolicyExportRemovedDetails.h"
#import "DBTEAMLOGGovernancePolicyRemoveFoldersDetails.h"
#import "DBTEAMLOGGovernancePolicyReportCreatedDetails.h"
#import "DBTEAMLOGGovernancePolicyZipPartDownloadedDetails.h"
#import "DBTEAMLOGGroupAddExternalIdDetails.h"
#import "DBTEAMLOGGroupAddMemberDetails.h"
#import "DBTEAMLOGGroupChangeExternalIdDetails.h"
#import "DBTEAMLOGGroupChangeManagementTypeDetails.h"
#import "DBTEAMLOGGroupChangeMemberRoleDetails.h"
#import "DBTEAMLOGGroupCreateDetails.h"
#import "DBTEAMLOGGroupDeleteDetails.h"
#import "DBTEAMLOGGroupDescriptionUpdatedDetails.h"
#import "DBTEAMLOGGroupJoinPolicyUpdatedDetails.h"
#import "DBTEAMLOGGroupMovedDetails.h"
#import "DBTEAMLOGGroupRemoveExternalIdDetails.h"
#import "DBTEAMLOGGroupRemoveMemberDetails.h"
#import "DBTEAMLOGGroupRenameDetails.h"
#import "DBTEAMLOGGroupUserManagementChangePolicyDetails.h"
#import "DBTEAMLOGGuestAdminChangeStatusDetails.h"
#import "DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails.h"
#import "DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails.h"
#import "DBTEAMLOGIntegrationConnectedDetails.h"
#import "DBTEAMLOGIntegrationDisconnectedDetails.h"
#import "DBTEAMLOGIntegrationPolicyChangedDetails.h"
#import "DBTEAMLOGLegalHoldsActivateAHoldDetails.h"
#import "DBTEAMLOGLegalHoldsAddMembersDetails.h"
#import "DBTEAMLOGLegalHoldsChangeHoldDetailsDetails.h"
#import "DBTEAMLOGLegalHoldsChangeHoldNameDetails.h"
#import "DBTEAMLOGLegalHoldsExportAHoldDetails.h"
#import "DBTEAMLOGLegalHoldsExportCancelledDetails.h"
#import "DBTEAMLOGLegalHoldsExportDownloadedDetails.h"
#import "DBTEAMLOGLegalHoldsExportRemovedDetails.h"
#import "DBTEAMLOGLegalHoldsReleaseAHoldDetails.h"
#import "DBTEAMLOGLegalHoldsRemoveMembersDetails.h"
#import "DBTEAMLOGLegalHoldsReportAHoldDetails.h"
#import "DBTEAMLOGLoginFailDetails.h"
#import "DBTEAMLOGLoginSuccessDetails.h"
#import "DBTEAMLOGLogoutDetails.h"
#import "DBTEAMLOGMemberAddExternalIdDetails.h"
#import "DBTEAMLOGMemberAddNameDetails.h"
#import "DBTEAMLOGMemberChangeAdminRoleDetails.h"
#import "DBTEAMLOGMemberChangeEmailDetails.h"
#import "DBTEAMLOGMemberChangeExternalIdDetails.h"
#import "DBTEAMLOGMemberChangeMembershipTypeDetails.h"
#import "DBTEAMLOGMemberChangeNameDetails.h"
#import "DBTEAMLOGMemberChangeResellerRoleDetails.h"
#import "DBTEAMLOGMemberChangeStatusDetails.h"
#import "DBTEAMLOGMemberDeleteManualContactsDetails.h"
#import "DBTEAMLOGMemberDeleteProfilePhotoDetails.h"
#import "DBTEAMLOGMemberPermanentlyDeleteAccountContentsDetails.h"
#import "DBTEAMLOGMemberRemoveExternalIdDetails.h"
#import "DBTEAMLOGMemberRequestsChangePolicyDetails.h"
#import "DBTEAMLOGMemberSendInvitePolicyChangedDetails.h"
#import "DBTEAMLOGMemberSetProfilePhotoDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsAddCustomQuotaDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsAddExceptionDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsChangeCapsTypePolicyDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsChangeCustomQuotaDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsChangePolicyDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsChangeStatusDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsRemoveCustomQuotaDetails.h"
#import "DBTEAMLOGMemberSpaceLimitsRemoveExceptionDetails.h"
#import "DBTEAMLOGMemberSuggestDetails.h"
#import "DBTEAMLOGMemberSuggestionsChangePolicyDetails.h"
#import "DBTEAMLOGMemberTransferAccountContentsDetails.h"
#import "DBTEAMLOGMicrosoftOfficeAddinChangePolicyDetails.h"
#import "DBTEAMLOGMissingDetails.h"
#import "DBTEAMLOGNetworkControlChangePolicyDetails.h"
#import "DBTEAMLOGNoExpirationLinkGenCreateReportDetails.h"
#import "DBTEAMLOGNoExpirationLinkGenReportFailedDetails.h"
#import "DBTEAMLOGNoPasswordLinkGenCreateReportDetails.h"
#import "DBTEAMLOGNoPasswordLinkGenReportFailedDetails.h"
#import "DBTEAMLOGNoPasswordLinkViewCreateReportDetails.h"
#import "DBTEAMLOGNoPasswordLinkViewReportFailedDetails.h"
#import "DBTEAMLOGNoteAclInviteOnlyDetails.h"
#import "DBTEAMLOGNoteAclLinkDetails.h"
#import "DBTEAMLOGNoteAclTeamLinkDetails.h"
#import "DBTEAMLOGNoteShareReceiveDetails.h"
#import "DBTEAMLOGNoteSharedDetails.h"
#import "DBTEAMLOGObjectLabelAddedDetails.h"
#import "DBTEAMLOGObjectLabelRemovedDetails.h"
#import "DBTEAMLOGObjectLabelUpdatedValueDetails.h"
#import "DBTEAMLOGOpenNoteSharedDetails.h"
#import "DBTEAMLOGOutdatedLinkViewCreateReportDetails.h"
#import "DBTEAMLOGOutdatedLinkViewReportFailedDetails.h"
#import "DBTEAMLOGPaperAdminExportStartDetails.h"
#import "DBTEAMLOGPaperChangeDeploymentPolicyDetails.h"
#import "DBTEAMLOGPaperChangeMemberLinkPolicyDetails.h"
#import "DBTEAMLOGPaperChangeMemberPolicyDetails.h"
#import "DBTEAMLOGPaperChangePolicyDetails.h"
#import "DBTEAMLOGPaperContentAddMemberDetails.h"
#import "DBTEAMLOGPaperContentAddToFolderDetails.h"
#import "DBTEAMLOGPaperContentArchiveDetails.h"
#import "DBTEAMLOGPaperContentCreateDetails.h"
#import "DBTEAMLOGPaperContentPermanentlyDeleteDetails.h"
#import "DBTEAMLOGPaperContentRemoveFromFolderDetails.h"
#import "DBTEAMLOGPaperContentRemoveMemberDetails.h"
#import "DBTEAMLOGPaperContentRenameDetails.h"
#import "DBTEAMLOGPaperContentRestoreDetails.h"
#import "DBTEAMLOGPaperDefaultFolderPolicyChangedDetails.h"
#import "DBTEAMLOGPaperDesktopPolicyChangedDetails.h"
#import "DBTEAMLOGPaperDocAddCommentDetails.h"
#import "DBTEAMLOGPaperDocChangeMemberRoleDetails.h"
#import "DBTEAMLOGPaperDocChangeSharingPolicyDetails.h"
#import "DBTEAMLOGPaperDocChangeSubscriptionDetails.h"
#import "DBTEAMLOGPaperDocDeleteCommentDetails.h"
#import "DBTEAMLOGPaperDocDeletedDetails.h"
#import "DBTEAMLOGPaperDocDownloadDetails.h"
#import "DBTEAMLOGPaperDocEditCommentDetails.h"
#import "DBTEAMLOGPaperDocEditDetails.h"
#import "DBTEAMLOGPaperDocFollowedDetails.h"
#import "DBTEAMLOGPaperDocMentionDetails.h"
#import "DBTEAMLOGPaperDocOwnershipChangedDetails.h"
#import "DBTEAMLOGPaperDocRequestAccessDetails.h"
#import "DBTEAMLOGPaperDocResolveCommentDetails.h"
#import "DBTEAMLOGPaperDocRevertDetails.h"
#import "DBTEAMLOGPaperDocSlackShareDetails.h"
#import "DBTEAMLOGPaperDocTeamInviteDetails.h"
#import "DBTEAMLOGPaperDocTrashedDetails.h"
#import "DBTEAMLOGPaperDocUnresolveCommentDetails.h"
#import "DBTEAMLOGPaperDocUntrashedDetails.h"
#import "DBTEAMLOGPaperDocViewDetails.h"
#import "DBTEAMLOGPaperEnabledUsersGroupAdditionDetails.h"
#import "DBTEAMLOGPaperEnabledUsersGroupRemovalDetails.h"
#import "DBTEAMLOGPaperExternalViewAllowDetails.h"
#import "DBTEAMLOGPaperExternalViewDefaultTeamDetails.h"
#import "DBTEAMLOGPaperExternalViewForbidDetails.h"
#import "DBTEAMLOGPaperFolderChangeSubscriptionDetails.h"
#import "DBTEAMLOGPaperFolderDeletedDetails.h"
#import "DBTEAMLOGPaperFolderFollowedDetails.h"
#import "DBTEAMLOGPaperFolderTeamInviteDetails.h"
#import "DBTEAMLOGPaperPublishedLinkChangePermissionDetails.h"
#import "DBTEAMLOGPaperPublishedLinkCreateDetails.h"
#import "DBTEAMLOGPaperPublishedLinkDisabledDetails.h"
#import "DBTEAMLOGPaperPublishedLinkViewDetails.h"
#import "DBTEAMLOGPasswordChangeDetails.h"
#import "DBTEAMLOGPasswordResetAllDetails.h"
#import "DBTEAMLOGPasswordResetDetails.h"
#import "DBTEAMLOGPasswordStrengthRequirementsChangePolicyDetails.h"
#import "DBTEAMLOGPendingSecondaryEmailAddedDetails.h"
#import "DBTEAMLOGPermanentDeleteChangePolicyDetails.h"
#import "DBTEAMLOGResellerSupportChangePolicyDetails.h"
#import "DBTEAMLOGResellerSupportSessionEndDetails.h"
#import "DBTEAMLOGResellerSupportSessionStartDetails.h"
#import "DBTEAMLOGRewindFolderDetails.h"
#import "DBTEAMLOGRewindPolicyChangedDetails.h"
#import "DBTEAMLOGSecondaryEmailDeletedDetails.h"
#import "DBTEAMLOGSecondaryEmailVerifiedDetails.h"
#import "DBTEAMLOGSecondaryMailsPolicyChangedDetails.h"
#import "DBTEAMLOGSendForSignaturePolicyChangedDetails.h"
#import "DBTEAMLOGSfAddGroupDetails.h"
#import "DBTEAMLOGSfAllowNonMembersToViewSharedLinksDetails.h"
#import "DBTEAMLOGSfExternalInviteWarnDetails.h"
#import "DBTEAMLOGSfFbInviteChangeRoleDetails.h"
#import "DBTEAMLOGSfFbInviteDetails.h"
#import "DBTEAMLOGSfFbUninviteDetails.h"
#import "DBTEAMLOGSfInviteGroupDetails.h"
#import "DBTEAMLOGSfTeamGrantAccessDetails.h"
#import "DBTEAMLOGSfTeamInviteChangeRoleDetails.h"
#import "DBTEAMLOGSfTeamInviteDetails.h"
#import "DBTEAMLOGSfTeamJoinDetails.h"
#import "DBTEAMLOGSfTeamJoinFromOobLinkDetails.h"
#import "DBTEAMLOGSfTeamUninviteDetails.h"
#import "DBTEAMLOGSharedContentAddInviteesDetails.h"
#import "DBTEAMLOGSharedContentAddLinkExpiryDetails.h"
#import "DBTEAMLOGSharedContentAddLinkPasswordDetails.h"
#import "DBTEAMLOGSharedContentAddMemberDetails.h"
#import "DBTEAMLOGSharedContentChangeDownloadsPolicyDetails.h"
#import "DBTEAMLOGSharedContentChangeInviteeRoleDetails.h"
#import "DBTEAMLOGSharedContentChangeLinkAudienceDetails.h"
#import "DBTEAMLOGSharedContentChangeLinkExpiryDetails.h"
#import "DBTEAMLOGSharedContentChangeLinkPasswordDetails.h"
#import "DBTEAMLOGSharedContentChangeMemberRoleDetails.h"
#import "DBTEAMLOGSharedContentChangeViewerInfoPolicyDetails.h"
#import "DBTEAMLOGSharedContentClaimInvitationDetails.h"
#import "DBTEAMLOGSharedContentCopyDetails.h"
#import "DBTEAMLOGSharedContentDownloadDetails.h"
#import "DBTEAMLOGSharedContentRelinquishMembershipDetails.h"
#import "DBTEAMLOGSharedContentRemoveInviteesDetails.h"
#import "DBTEAMLOGSharedContentRemoveLinkExpiryDetails.h"
#import "DBTEAMLOGSharedContentRemoveLinkPasswordDetails.h"
#import "DBTEAMLOGSharedContentRemoveMemberDetails.h"
#import "DBTEAMLOGSharedContentRequestAccessDetails.h"
#import "DBTEAMLOGSharedContentRestoreInviteesDetails.h"
#import "DBTEAMLOGSharedContentRestoreMemberDetails.h"
#import "DBTEAMLOGSharedContentUnshareDetails.h"
#import "DBTEAMLOGSharedContentViewDetails.h"
#import "DBTEAMLOGSharedFolderChangeLinkPolicyDetails.h"
#import "DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails.h"
#import "DBTEAMLOGSharedFolderChangeMembersManagementPolicyDetails.h"
#import "DBTEAMLOGSharedFolderChangeMembersPolicyDetails.h"
#import "DBTEAMLOGSharedFolderCreateDetails.h"
#import "DBTEAMLOGSharedFolderDeclineInvitationDetails.h"
#import "DBTEAMLOGSharedFolderMountDetails.h"
#import "DBTEAMLOGSharedFolderNestDetails.h"
#import "DBTEAMLOGSharedFolderTransferOwnershipDetails.h"
#import "DBTEAMLOGSharedFolderUnmountDetails.h"
#import "DBTEAMLOGSharedLinkAddExpiryDetails.h"
#import "DBTEAMLOGSharedLinkChangeExpiryDetails.h"
#import "DBTEAMLOGSharedLinkChangeVisibilityDetails.h"
#import "DBTEAMLOGSharedLinkCopyDetails.h"
#import "DBTEAMLOGSharedLinkCreateDetails.h"
#import "DBTEAMLOGSharedLinkDisableDetails.h"
#import "DBTEAMLOGSharedLinkDownloadDetails.h"
#import "DBTEAMLOGSharedLinkRemoveExpiryDetails.h"
#import "DBTEAMLOGSharedLinkSettingsAddExpirationDetails.h"
#import "DBTEAMLOGSharedLinkSettingsAddPasswordDetails.h"
#import "DBTEAMLOGSharedLinkSettingsAllowDownloadDisabledDetails.h"
#import "DBTEAMLOGSharedLinkSettingsAllowDownloadEnabledDetails.h"
#import "DBTEAMLOGSharedLinkSettingsChangeAudienceDetails.h"
#import "DBTEAMLOGSharedLinkSettingsChangeExpirationDetails.h"
#import "DBTEAMLOGSharedLinkSettingsChangePasswordDetails.h"
#import "DBTEAMLOGSharedLinkSettingsRemoveExpirationDetails.h"
#import "DBTEAMLOGSharedLinkSettingsRemovePasswordDetails.h"
#import "DBTEAMLOGSharedLinkShareDetails.h"
#import "DBTEAMLOGSharedLinkViewDetails.h"
#import "DBTEAMLOGSharedNoteOpenedDetails.h"
#import "DBTEAMLOGSharingChangeFolderJoinPolicyDetails.h"
#import "DBTEAMLOGSharingChangeLinkPolicyDetails.h"
#import "DBTEAMLOGSharingChangeMemberPolicyDetails.h"
#import "DBTEAMLOGShmodelDisableDownloadsDetails.h"
#import "DBTEAMLOGShmodelEnableDownloadsDetails.h"
#import "DBTEAMLOGShmodelGroupShareDetails.h"
#import "DBTEAMLOGShowcaseAccessGrantedDetails.h"
#import "DBTEAMLOGShowcaseAddMemberDetails.h"
#import "DBTEAMLOGShowcaseArchivedDetails.h"
#import "DBTEAMLOGShowcaseChangeDownloadPolicyDetails.h"
#import "DBTEAMLOGShowcaseChangeEnabledPolicyDetails.h"
#import "DBTEAMLOGShowcaseChangeExternalSharingPolicyDetails.h"
#import "DBTEAMLOGShowcaseCreatedDetails.h"
#import "DBTEAMLOGShowcaseDeleteCommentDetails.h"
#import "DBTEAMLOGShowcaseEditCommentDetails.h"
#import "DBTEAMLOGShowcaseEditedDetails.h"
#import "DBTEAMLOGShowcaseFileAddedDetails.h"
#import "DBTEAMLOGShowcaseFileDownloadDetails.h"
#import "DBTEAMLOGShowcaseFileRemovedDetails.h"
#import "DBTEAMLOGShowcaseFileViewDetails.h"
#import "DBTEAMLOGShowcasePermanentlyDeletedDetails.h"
#import "DBTEAMLOGShowcasePostCommentDetails.h"
#import "DBTEAMLOGShowcaseRemoveMemberDetails.h"
#import "DBTEAMLOGShowcaseRenamedDetails.h"
#import "DBTEAMLOGShowcaseRequestAccessDetails.h"
#import "DBTEAMLOGShowcaseResolveCommentDetails.h"
#import "DBTEAMLOGShowcaseRestoredDetails.h"
#import "DBTEAMLOGShowcaseTrashedDeprecatedDetails.h"
#import "DBTEAMLOGShowcaseTrashedDetails.h"
#import "DBTEAMLOGShowcaseUnresolveCommentDetails.h"
#import "DBTEAMLOGShowcaseUntrashedDeprecatedDetails.h"
#import "DBTEAMLOGShowcaseUntrashedDetails.h"
#import "DBTEAMLOGShowcaseViewDetails.h"
#import "DBTEAMLOGSignInAsSessionEndDetails.h"
#import "DBTEAMLOGSignInAsSessionStartDetails.h"
#import "DBTEAMLOGSmartSyncChangePolicyDetails.h"
#import "DBTEAMLOGSmartSyncCreateAdminPrivilegeReportDetails.h"
#import "DBTEAMLOGSmartSyncNotOptOutDetails.h"
#import "DBTEAMLOGSmartSyncOptOutDetails.h"
#import "DBTEAMLOGSmarterSmartSyncPolicyChangedDetails.h"
#import "DBTEAMLOGSsoAddCertDetails.h"
#import "DBTEAMLOGSsoAddLoginUrlDetails.h"
#import "DBTEAMLOGSsoAddLogoutUrlDetails.h"
#import "DBTEAMLOGSsoChangeCertDetails.h"
#import "DBTEAMLOGSsoChangeLoginUrlDetails.h"
#import "DBTEAMLOGSsoChangeLogoutUrlDetails.h"
#import "DBTEAMLOGSsoChangePolicyDetails.h"
#import "DBTEAMLOGSsoChangeSamlIdentityModeDetails.h"
#import "DBTEAMLOGSsoErrorDetails.h"
#import "DBTEAMLOGSsoRemoveCertDetails.h"
#import "DBTEAMLOGSsoRemoveLoginUrlDetails.h"
#import "DBTEAMLOGSsoRemoveLogoutUrlDetails.h"
#import "DBTEAMLOGStartedEnterpriseAdminSessionDetails.h"
#import "DBTEAMLOGTeamActivityCreateReportDetails.h"
#import "DBTEAMLOGTeamActivityCreateReportFailDetails.h"
#import "DBTEAMLOGTeamBrandingPolicyChangedDetails.h"
#import "DBTEAMLOGTeamExtensionsPolicyChangedDetails.h"
#import "DBTEAMLOGTeamFolderChangeStatusDetails.h"
#import "DBTEAMLOGTeamFolderCreateDetails.h"
#import "DBTEAMLOGTeamFolderDowngradeDetails.h"
#import "DBTEAMLOGTeamFolderPermanentlyDeleteDetails.h"
#import "DBTEAMLOGTeamFolderRenameDetails.h"
#import "DBTEAMLOGTeamMergeFromDetails.h"
#import "DBTEAMLOGTeamMergeRequestAcceptedDetails.h"
#import "DBTEAMLOGTeamMergeRequestAcceptedShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestAcceptedShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestAutoCanceledDetails.h"
#import "DBTEAMLOGTeamMergeRequestCanceledDetails.h"
#import "DBTEAMLOGTeamMergeRequestCanceledShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestCanceledShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestExpiredDetails.h"
#import "DBTEAMLOGTeamMergeRequestExpiredShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestExpiredShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestRejectedShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestRejectedShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestReminderDetails.h"
#import "DBTEAMLOGTeamMergeRequestReminderShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestReminderShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestRevokedDetails.h"
#import "DBTEAMLOGTeamMergeRequestSentShownToPrimaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeRequestSentShownToSecondaryTeamDetails.h"
#import "DBTEAMLOGTeamMergeToDetails.h"
#import "DBTEAMLOGTeamProfileAddBackgroundDetails.h"
#import "DBTEAMLOGTeamProfileAddLogoDetails.h"
#import "DBTEAMLOGTeamProfileChangeBackgroundDetails.h"
#import "DBTEAMLOGTeamProfileChangeDefaultLanguageDetails.h"
#import "DBTEAMLOGTeamProfileChangeLogoDetails.h"
#import "DBTEAMLOGTeamProfileChangeNameDetails.h"
#import "DBTEAMLOGTeamProfileRemoveBackgroundDetails.h"
#import "DBTEAMLOGTeamProfileRemoveLogoDetails.h"
#import "DBTEAMLOGTeamSelectiveSyncPolicyChangedDetails.h"
#import "DBTEAMLOGTeamSelectiveSyncSettingsChangedDetails.h"
#import "DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails.h"
#import "DBTEAMLOGTfaAddBackupPhoneDetails.h"
#import "DBTEAMLOGTfaAddExceptionDetails.h"
#import "DBTEAMLOGTfaAddSecurityKeyDetails.h"
#import "DBTEAMLOGTfaChangeBackupPhoneDetails.h"
#import "DBTEAMLOGTfaChangePolicyDetails.h"
#import "DBTEAMLOGTfaChangeStatusDetails.h"
#import "DBTEAMLOGTfaRemoveBackupPhoneDetails.h"
#import "DBTEAMLOGTfaRemoveExceptionDetails.h"
#import "DBTEAMLOGTfaRemoveSecurityKeyDetails.h"
#import "DBTEAMLOGTfaResetDetails.h"
#import "DBTEAMLOGTwoAccountChangePolicyDetails.h"
#import "DBTEAMLOGViewerInfoPolicyChangedDetails.h"
#import "DBTEAMLOGWatermarkingPolicyChangedDetails.h"
#import "DBTEAMLOGWebSessionsChangeActiveSessionLimitDetails.h"
#import "DBTEAMLOGWebSessionsChangeFixedLengthPolicyDetails.h"
#import "DBTEAMLOGWebSessionsChangeIdleLengthPolicyDetails.h"

#pragma mark - API Object

@implementation DBTEAMLOGEventDetails

@synthesize adminAlertingChangedAlertConfigDetails = _adminAlertingChangedAlertConfigDetails;
@synthesize adminAlertingTriggeredAlertDetails = _adminAlertingTriggeredAlertDetails;
@synthesize appLinkTeamDetails = _appLinkTeamDetails;
@synthesize appLinkUserDetails = _appLinkUserDetails;
@synthesize appUnlinkTeamDetails = _appUnlinkTeamDetails;
@synthesize appUnlinkUserDetails = _appUnlinkUserDetails;
@synthesize integrationConnectedDetails = _integrationConnectedDetails;
@synthesize integrationDisconnectedDetails = _integrationDisconnectedDetails;
@synthesize fileAddCommentDetails = _fileAddCommentDetails;
@synthesize fileChangeCommentSubscriptionDetails = _fileChangeCommentSubscriptionDetails;
@synthesize fileDeleteCommentDetails = _fileDeleteCommentDetails;
@synthesize fileEditCommentDetails = _fileEditCommentDetails;
@synthesize fileLikeCommentDetails = _fileLikeCommentDetails;
@synthesize fileResolveCommentDetails = _fileResolveCommentDetails;
@synthesize fileUnlikeCommentDetails = _fileUnlikeCommentDetails;
@synthesize fileUnresolveCommentDetails = _fileUnresolveCommentDetails;
@synthesize governancePolicyAddFoldersDetails = _governancePolicyAddFoldersDetails;
@synthesize governancePolicyAddFolderFailedDetails = _governancePolicyAddFolderFailedDetails;
@synthesize governancePolicyContentDisposedDetails = _governancePolicyContentDisposedDetails;
@synthesize governancePolicyCreateDetails = _governancePolicyCreateDetails;
@synthesize governancePolicyDeleteDetails = _governancePolicyDeleteDetails;
@synthesize governancePolicyEditDetailsDetails = _governancePolicyEditDetailsDetails;
@synthesize governancePolicyEditDurationDetails = _governancePolicyEditDurationDetails;
@synthesize governancePolicyExportCreatedDetails = _governancePolicyExportCreatedDetails;
@synthesize governancePolicyExportRemovedDetails = _governancePolicyExportRemovedDetails;
@synthesize governancePolicyRemoveFoldersDetails = _governancePolicyRemoveFoldersDetails;
@synthesize governancePolicyReportCreatedDetails = _governancePolicyReportCreatedDetails;
@synthesize governancePolicyZipPartDownloadedDetails = _governancePolicyZipPartDownloadedDetails;
@synthesize legalHoldsActivateAHoldDetails = _legalHoldsActivateAHoldDetails;
@synthesize legalHoldsAddMembersDetails = _legalHoldsAddMembersDetails;
@synthesize legalHoldsChangeHoldDetailsDetails = _legalHoldsChangeHoldDetailsDetails;
@synthesize legalHoldsChangeHoldNameDetails = _legalHoldsChangeHoldNameDetails;
@synthesize legalHoldsExportAHoldDetails = _legalHoldsExportAHoldDetails;
@synthesize legalHoldsExportCancelledDetails = _legalHoldsExportCancelledDetails;
@synthesize legalHoldsExportDownloadedDetails = _legalHoldsExportDownloadedDetails;
@synthesize legalHoldsExportRemovedDetails = _legalHoldsExportRemovedDetails;
@synthesize legalHoldsReleaseAHoldDetails = _legalHoldsReleaseAHoldDetails;
@synthesize legalHoldsRemoveMembersDetails = _legalHoldsRemoveMembersDetails;
@synthesize legalHoldsReportAHoldDetails = _legalHoldsReportAHoldDetails;
@synthesize deviceChangeIpDesktopDetails = _deviceChangeIpDesktopDetails;
@synthesize deviceChangeIpMobileDetails = _deviceChangeIpMobileDetails;
@synthesize deviceChangeIpWebDetails = _deviceChangeIpWebDetails;
@synthesize deviceDeleteOnUnlinkFailDetails = _deviceDeleteOnUnlinkFailDetails;
@synthesize deviceDeleteOnUnlinkSuccessDetails = _deviceDeleteOnUnlinkSuccessDetails;
@synthesize deviceLinkFailDetails = _deviceLinkFailDetails;
@synthesize deviceLinkSuccessDetails = _deviceLinkSuccessDetails;
@synthesize deviceManagementDisabledDetails = _deviceManagementDisabledDetails;
@synthesize deviceManagementEnabledDetails = _deviceManagementEnabledDetails;
@synthesize deviceSyncBackupStatusChangedDetails = _deviceSyncBackupStatusChangedDetails;
@synthesize deviceUnlinkDetails = _deviceUnlinkDetails;
@synthesize dropboxPasswordsExportedDetails = _dropboxPasswordsExportedDetails;
@synthesize dropboxPasswordsNewDeviceEnrolledDetails = _dropboxPasswordsNewDeviceEnrolledDetails;
@synthesize emmRefreshAuthTokenDetails = _emmRefreshAuthTokenDetails;
@synthesize accountCaptureChangeAvailabilityDetails = _accountCaptureChangeAvailabilityDetails;
@synthesize accountCaptureMigrateAccountDetails = _accountCaptureMigrateAccountDetails;
@synthesize accountCaptureNotificationEmailsSentDetails = _accountCaptureNotificationEmailsSentDetails;
@synthesize accountCaptureRelinquishAccountDetails = _accountCaptureRelinquishAccountDetails;
@synthesize disabledDomainInvitesDetails = _disabledDomainInvitesDetails;
@synthesize domainInvitesApproveRequestToJoinTeamDetails = _domainInvitesApproveRequestToJoinTeamDetails;
@synthesize domainInvitesDeclineRequestToJoinTeamDetails = _domainInvitesDeclineRequestToJoinTeamDetails;
@synthesize domainInvitesEmailExistingUsersDetails = _domainInvitesEmailExistingUsersDetails;
@synthesize domainInvitesRequestToJoinTeamDetails = _domainInvitesRequestToJoinTeamDetails;
@synthesize domainInvitesSetInviteNewUserPrefToNoDetails = _domainInvitesSetInviteNewUserPrefToNoDetails;
@synthesize domainInvitesSetInviteNewUserPrefToYesDetails = _domainInvitesSetInviteNewUserPrefToYesDetails;
@synthesize domainVerificationAddDomainFailDetails = _domainVerificationAddDomainFailDetails;
@synthesize domainVerificationAddDomainSuccessDetails = _domainVerificationAddDomainSuccessDetails;
@synthesize domainVerificationRemoveDomainDetails = _domainVerificationRemoveDomainDetails;
@synthesize enabledDomainInvitesDetails = _enabledDomainInvitesDetails;
@synthesize createFolderDetails = _createFolderDetails;
@synthesize fileAddDetails = _fileAddDetails;
@synthesize fileCopyDetails = _fileCopyDetails;
@synthesize fileDeleteDetails = _fileDeleteDetails;
@synthesize fileDownloadDetails = _fileDownloadDetails;
@synthesize fileEditDetails = _fileEditDetails;
@synthesize fileGetCopyReferenceDetails = _fileGetCopyReferenceDetails;
@synthesize fileLockingLockStatusChangedDetails = _fileLockingLockStatusChangedDetails;
@synthesize fileMoveDetails = _fileMoveDetails;
@synthesize filePermanentlyDeleteDetails = _filePermanentlyDeleteDetails;
@synthesize filePreviewDetails = _filePreviewDetails;
@synthesize fileRenameDetails = _fileRenameDetails;
@synthesize fileRestoreDetails = _fileRestoreDetails;
@synthesize fileRevertDetails = _fileRevertDetails;
@synthesize fileRollbackChangesDetails = _fileRollbackChangesDetails;
@synthesize fileSaveCopyReferenceDetails = _fileSaveCopyReferenceDetails;
@synthesize folderOverviewDescriptionChangedDetails = _folderOverviewDescriptionChangedDetails;
@synthesize folderOverviewItemPinnedDetails = _folderOverviewItemPinnedDetails;
@synthesize folderOverviewItemUnpinnedDetails = _folderOverviewItemUnpinnedDetails;
@synthesize objectLabelAddedDetails = _objectLabelAddedDetails;
@synthesize objectLabelRemovedDetails = _objectLabelRemovedDetails;
@synthesize objectLabelUpdatedValueDetails = _objectLabelUpdatedValueDetails;
@synthesize rewindFolderDetails = _rewindFolderDetails;
@synthesize fileRequestChangeDetails = _fileRequestChangeDetails;
@synthesize fileRequestCloseDetails = _fileRequestCloseDetails;
@synthesize fileRequestCreateDetails = _fileRequestCreateDetails;
@synthesize fileRequestDeleteDetails = _fileRequestDeleteDetails;
@synthesize fileRequestReceiveFileDetails = _fileRequestReceiveFileDetails;
@synthesize groupAddExternalIdDetails = _groupAddExternalIdDetails;
@synthesize groupAddMemberDetails = _groupAddMemberDetails;
@synthesize groupChangeExternalIdDetails = _groupChangeExternalIdDetails;
@synthesize groupChangeManagementTypeDetails = _groupChangeManagementTypeDetails;
@synthesize groupChangeMemberRoleDetails = _groupChangeMemberRoleDetails;
@synthesize groupCreateDetails = _groupCreateDetails;
@synthesize groupDeleteDetails = _groupDeleteDetails;
@synthesize groupDescriptionUpdatedDetails = _groupDescriptionUpdatedDetails;
@synthesize groupJoinPolicyUpdatedDetails = _groupJoinPolicyUpdatedDetails;
@synthesize groupMovedDetails = _groupMovedDetails;
@synthesize groupRemoveExternalIdDetails = _groupRemoveExternalIdDetails;
@synthesize groupRemoveMemberDetails = _groupRemoveMemberDetails;
@synthesize groupRenameDetails = _groupRenameDetails;
@synthesize accountLockOrUnlockedDetails = _accountLockOrUnlockedDetails;
@synthesize emmErrorDetails = _emmErrorDetails;
@synthesize guestAdminSignedInViaTrustedTeamsDetails = _guestAdminSignedInViaTrustedTeamsDetails;
@synthesize guestAdminSignedOutViaTrustedTeamsDetails = _guestAdminSignedOutViaTrustedTeamsDetails;
@synthesize loginFailDetails = _loginFailDetails;
@synthesize loginSuccessDetails = _loginSuccessDetails;
@synthesize logoutDetails = _logoutDetails;
@synthesize resellerSupportSessionEndDetails = _resellerSupportSessionEndDetails;
@synthesize resellerSupportSessionStartDetails = _resellerSupportSessionStartDetails;
@synthesize signInAsSessionEndDetails = _signInAsSessionEndDetails;
@synthesize signInAsSessionStartDetails = _signInAsSessionStartDetails;
@synthesize ssoErrorDetails = _ssoErrorDetails;
@synthesize createTeamInviteLinkDetails = _createTeamInviteLinkDetails;
@synthesize deleteTeamInviteLinkDetails = _deleteTeamInviteLinkDetails;
@synthesize memberAddExternalIdDetails = _memberAddExternalIdDetails;
@synthesize memberAddNameDetails = _memberAddNameDetails;
@synthesize memberChangeAdminRoleDetails = _memberChangeAdminRoleDetails;
@synthesize memberChangeEmailDetails = _memberChangeEmailDetails;
@synthesize memberChangeExternalIdDetails = _memberChangeExternalIdDetails;
@synthesize memberChangeMembershipTypeDetails = _memberChangeMembershipTypeDetails;
@synthesize memberChangeNameDetails = _memberChangeNameDetails;
@synthesize memberChangeResellerRoleDetails = _memberChangeResellerRoleDetails;
@synthesize memberChangeStatusDetails = _memberChangeStatusDetails;
@synthesize memberDeleteManualContactsDetails = _memberDeleteManualContactsDetails;
@synthesize memberDeleteProfilePhotoDetails = _memberDeleteProfilePhotoDetails;
@synthesize memberPermanentlyDeleteAccountContentsDetails = _memberPermanentlyDeleteAccountContentsDetails;
@synthesize memberRemoveExternalIdDetails = _memberRemoveExternalIdDetails;
@synthesize memberSetProfilePhotoDetails = _memberSetProfilePhotoDetails;
@synthesize memberSpaceLimitsAddCustomQuotaDetails = _memberSpaceLimitsAddCustomQuotaDetails;
@synthesize memberSpaceLimitsChangeCustomQuotaDetails = _memberSpaceLimitsChangeCustomQuotaDetails;
@synthesize memberSpaceLimitsChangeStatusDetails = _memberSpaceLimitsChangeStatusDetails;
@synthesize memberSpaceLimitsRemoveCustomQuotaDetails = _memberSpaceLimitsRemoveCustomQuotaDetails;
@synthesize memberSuggestDetails = _memberSuggestDetails;
@synthesize memberTransferAccountContentsDetails = _memberTransferAccountContentsDetails;
@synthesize pendingSecondaryEmailAddedDetails = _pendingSecondaryEmailAddedDetails;
@synthesize secondaryEmailDeletedDetails = _secondaryEmailDeletedDetails;
@synthesize secondaryEmailVerifiedDetails = _secondaryEmailVerifiedDetails;
@synthesize secondaryMailsPolicyChangedDetails = _secondaryMailsPolicyChangedDetails;
@synthesize binderAddPageDetails = _binderAddPageDetails;
@synthesize binderAddSectionDetails = _binderAddSectionDetails;
@synthesize binderRemovePageDetails = _binderRemovePageDetails;
@synthesize binderRemoveSectionDetails = _binderRemoveSectionDetails;
@synthesize binderRenamePageDetails = _binderRenamePageDetails;
@synthesize binderRenameSectionDetails = _binderRenameSectionDetails;
@synthesize binderReorderPageDetails = _binderReorderPageDetails;
@synthesize binderReorderSectionDetails = _binderReorderSectionDetails;
@synthesize paperContentAddMemberDetails = _paperContentAddMemberDetails;
@synthesize paperContentAddToFolderDetails = _paperContentAddToFolderDetails;
@synthesize paperContentArchiveDetails = _paperContentArchiveDetails;
@synthesize paperContentCreateDetails = _paperContentCreateDetails;
@synthesize paperContentPermanentlyDeleteDetails = _paperContentPermanentlyDeleteDetails;
@synthesize paperContentRemoveFromFolderDetails = _paperContentRemoveFromFolderDetails;
@synthesize paperContentRemoveMemberDetails = _paperContentRemoveMemberDetails;
@synthesize paperContentRenameDetails = _paperContentRenameDetails;
@synthesize paperContentRestoreDetails = _paperContentRestoreDetails;
@synthesize paperDocAddCommentDetails = _paperDocAddCommentDetails;
@synthesize paperDocChangeMemberRoleDetails = _paperDocChangeMemberRoleDetails;
@synthesize paperDocChangeSharingPolicyDetails = _paperDocChangeSharingPolicyDetails;
@synthesize paperDocChangeSubscriptionDetails = _paperDocChangeSubscriptionDetails;
@synthesize paperDocDeletedDetails = _paperDocDeletedDetails;
@synthesize paperDocDeleteCommentDetails = _paperDocDeleteCommentDetails;
@synthesize paperDocDownloadDetails = _paperDocDownloadDetails;
@synthesize paperDocEditDetails = _paperDocEditDetails;
@synthesize paperDocEditCommentDetails = _paperDocEditCommentDetails;
@synthesize paperDocFollowedDetails = _paperDocFollowedDetails;
@synthesize paperDocMentionDetails = _paperDocMentionDetails;
@synthesize paperDocOwnershipChangedDetails = _paperDocOwnershipChangedDetails;
@synthesize paperDocRequestAccessDetails = _paperDocRequestAccessDetails;
@synthesize paperDocResolveCommentDetails = _paperDocResolveCommentDetails;
@synthesize paperDocRevertDetails = _paperDocRevertDetails;
@synthesize paperDocSlackShareDetails = _paperDocSlackShareDetails;
@synthesize paperDocTeamInviteDetails = _paperDocTeamInviteDetails;
@synthesize paperDocTrashedDetails = _paperDocTrashedDetails;
@synthesize paperDocUnresolveCommentDetails = _paperDocUnresolveCommentDetails;
@synthesize paperDocUntrashedDetails = _paperDocUntrashedDetails;
@synthesize paperDocViewDetails = _paperDocViewDetails;
@synthesize paperExternalViewAllowDetails = _paperExternalViewAllowDetails;
@synthesize paperExternalViewDefaultTeamDetails = _paperExternalViewDefaultTeamDetails;
@synthesize paperExternalViewForbidDetails = _paperExternalViewForbidDetails;
@synthesize paperFolderChangeSubscriptionDetails = _paperFolderChangeSubscriptionDetails;
@synthesize paperFolderDeletedDetails = _paperFolderDeletedDetails;
@synthesize paperFolderFollowedDetails = _paperFolderFollowedDetails;
@synthesize paperFolderTeamInviteDetails = _paperFolderTeamInviteDetails;
@synthesize paperPublishedLinkChangePermissionDetails = _paperPublishedLinkChangePermissionDetails;
@synthesize paperPublishedLinkCreateDetails = _paperPublishedLinkCreateDetails;
@synthesize paperPublishedLinkDisabledDetails = _paperPublishedLinkDisabledDetails;
@synthesize paperPublishedLinkViewDetails = _paperPublishedLinkViewDetails;
@synthesize passwordChangeDetails = _passwordChangeDetails;
@synthesize passwordResetDetails = _passwordResetDetails;
@synthesize passwordResetAllDetails = _passwordResetAllDetails;
@synthesize classificationCreateReportDetails = _classificationCreateReportDetails;
@synthesize classificationCreateReportFailDetails = _classificationCreateReportFailDetails;
@synthesize emmCreateExceptionsReportDetails = _emmCreateExceptionsReportDetails;
@synthesize emmCreateUsageReportDetails = _emmCreateUsageReportDetails;
@synthesize exportMembersReportDetails = _exportMembersReportDetails;
@synthesize exportMembersReportFailDetails = _exportMembersReportFailDetails;
@synthesize externalSharingCreateReportDetails = _externalSharingCreateReportDetails;
@synthesize externalSharingReportFailedDetails = _externalSharingReportFailedDetails;
@synthesize noExpirationLinkGenCreateReportDetails = _noExpirationLinkGenCreateReportDetails;
@synthesize noExpirationLinkGenReportFailedDetails = _noExpirationLinkGenReportFailedDetails;
@synthesize noPasswordLinkGenCreateReportDetails = _noPasswordLinkGenCreateReportDetails;
@synthesize noPasswordLinkGenReportFailedDetails = _noPasswordLinkGenReportFailedDetails;
@synthesize noPasswordLinkViewCreateReportDetails = _noPasswordLinkViewCreateReportDetails;
@synthesize noPasswordLinkViewReportFailedDetails = _noPasswordLinkViewReportFailedDetails;
@synthesize outdatedLinkViewCreateReportDetails = _outdatedLinkViewCreateReportDetails;
@synthesize outdatedLinkViewReportFailedDetails = _outdatedLinkViewReportFailedDetails;
@synthesize paperAdminExportStartDetails = _paperAdminExportStartDetails;
@synthesize smartSyncCreateAdminPrivilegeReportDetails = _smartSyncCreateAdminPrivilegeReportDetails;
@synthesize teamActivityCreateReportDetails = _teamActivityCreateReportDetails;
@synthesize teamActivityCreateReportFailDetails = _teamActivityCreateReportFailDetails;
@synthesize collectionShareDetails = _collectionShareDetails;
@synthesize fileTransfersFileAddDetails = _fileTransfersFileAddDetails;
@synthesize fileTransfersTransferDeleteDetails = _fileTransfersTransferDeleteDetails;
@synthesize fileTransfersTransferDownloadDetails = _fileTransfersTransferDownloadDetails;
@synthesize fileTransfersTransferSendDetails = _fileTransfersTransferSendDetails;
@synthesize fileTransfersTransferViewDetails = _fileTransfersTransferViewDetails;
@synthesize noteAclInviteOnlyDetails = _noteAclInviteOnlyDetails;
@synthesize noteAclLinkDetails = _noteAclLinkDetails;
@synthesize noteAclTeamLinkDetails = _noteAclTeamLinkDetails;
@synthesize noteSharedDetails = _noteSharedDetails;
@synthesize noteShareReceiveDetails = _noteShareReceiveDetails;
@synthesize openNoteSharedDetails = _openNoteSharedDetails;
@synthesize sfAddGroupDetails = _sfAddGroupDetails;
@synthesize sfAllowNonMembersToViewSharedLinksDetails = _sfAllowNonMembersToViewSharedLinksDetails;
@synthesize sfExternalInviteWarnDetails = _sfExternalInviteWarnDetails;
@synthesize sfFbInviteDetails = _sfFbInviteDetails;
@synthesize sfFbInviteChangeRoleDetails = _sfFbInviteChangeRoleDetails;
@synthesize sfFbUninviteDetails = _sfFbUninviteDetails;
@synthesize sfInviteGroupDetails = _sfInviteGroupDetails;
@synthesize sfTeamGrantAccessDetails = _sfTeamGrantAccessDetails;
@synthesize sfTeamInviteDetails = _sfTeamInviteDetails;
@synthesize sfTeamInviteChangeRoleDetails = _sfTeamInviteChangeRoleDetails;
@synthesize sfTeamJoinDetails = _sfTeamJoinDetails;
@synthesize sfTeamJoinFromOobLinkDetails = _sfTeamJoinFromOobLinkDetails;
@synthesize sfTeamUninviteDetails = _sfTeamUninviteDetails;
@synthesize sharedContentAddInviteesDetails = _sharedContentAddInviteesDetails;
@synthesize sharedContentAddLinkExpiryDetails = _sharedContentAddLinkExpiryDetails;
@synthesize sharedContentAddLinkPasswordDetails = _sharedContentAddLinkPasswordDetails;
@synthesize sharedContentAddMemberDetails = _sharedContentAddMemberDetails;
@synthesize sharedContentChangeDownloadsPolicyDetails = _sharedContentChangeDownloadsPolicyDetails;
@synthesize sharedContentChangeInviteeRoleDetails = _sharedContentChangeInviteeRoleDetails;
@synthesize sharedContentChangeLinkAudienceDetails = _sharedContentChangeLinkAudienceDetails;
@synthesize sharedContentChangeLinkExpiryDetails = _sharedContentChangeLinkExpiryDetails;
@synthesize sharedContentChangeLinkPasswordDetails = _sharedContentChangeLinkPasswordDetails;
@synthesize sharedContentChangeMemberRoleDetails = _sharedContentChangeMemberRoleDetails;
@synthesize sharedContentChangeViewerInfoPolicyDetails = _sharedContentChangeViewerInfoPolicyDetails;
@synthesize sharedContentClaimInvitationDetails = _sharedContentClaimInvitationDetails;
@synthesize sharedContentCopyDetails = _sharedContentCopyDetails;
@synthesize sharedContentDownloadDetails = _sharedContentDownloadDetails;
@synthesize sharedContentRelinquishMembershipDetails = _sharedContentRelinquishMembershipDetails;
@synthesize sharedContentRemoveInviteesDetails = _sharedContentRemoveInviteesDetails;
@synthesize sharedContentRemoveLinkExpiryDetails = _sharedContentRemoveLinkExpiryDetails;
@synthesize sharedContentRemoveLinkPasswordDetails = _sharedContentRemoveLinkPasswordDetails;
@synthesize sharedContentRemoveMemberDetails = _sharedContentRemoveMemberDetails;
@synthesize sharedContentRequestAccessDetails = _sharedContentRequestAccessDetails;
@synthesize sharedContentRestoreInviteesDetails = _sharedContentRestoreInviteesDetails;
@synthesize sharedContentRestoreMemberDetails = _sharedContentRestoreMemberDetails;
@synthesize sharedContentUnshareDetails = _sharedContentUnshareDetails;
@synthesize sharedContentViewDetails = _sharedContentViewDetails;
@synthesize sharedFolderChangeLinkPolicyDetails = _sharedFolderChangeLinkPolicyDetails;
@synthesize sharedFolderChangeMembersInheritancePolicyDetails = _sharedFolderChangeMembersInheritancePolicyDetails;
@synthesize sharedFolderChangeMembersManagementPolicyDetails = _sharedFolderChangeMembersManagementPolicyDetails;
@synthesize sharedFolderChangeMembersPolicyDetails = _sharedFolderChangeMembersPolicyDetails;
@synthesize sharedFolderCreateDetails = _sharedFolderCreateDetails;
@synthesize sharedFolderDeclineInvitationDetails = _sharedFolderDeclineInvitationDetails;
@synthesize sharedFolderMountDetails = _sharedFolderMountDetails;
@synthesize sharedFolderNestDetails = _sharedFolderNestDetails;
@synthesize sharedFolderTransferOwnershipDetails = _sharedFolderTransferOwnershipDetails;
@synthesize sharedFolderUnmountDetails = _sharedFolderUnmountDetails;
@synthesize sharedLinkAddExpiryDetails = _sharedLinkAddExpiryDetails;
@synthesize sharedLinkChangeExpiryDetails = _sharedLinkChangeExpiryDetails;
@synthesize sharedLinkChangeVisibilityDetails = _sharedLinkChangeVisibilityDetails;
@synthesize sharedLinkCopyDetails = _sharedLinkCopyDetails;
@synthesize sharedLinkCreateDetails = _sharedLinkCreateDetails;
@synthesize sharedLinkDisableDetails = _sharedLinkDisableDetails;
@synthesize sharedLinkDownloadDetails = _sharedLinkDownloadDetails;
@synthesize sharedLinkRemoveExpiryDetails = _sharedLinkRemoveExpiryDetails;
@synthesize sharedLinkSettingsAddExpirationDetails = _sharedLinkSettingsAddExpirationDetails;
@synthesize sharedLinkSettingsAddPasswordDetails = _sharedLinkSettingsAddPasswordDetails;
@synthesize sharedLinkSettingsAllowDownloadDisabledDetails = _sharedLinkSettingsAllowDownloadDisabledDetails;
@synthesize sharedLinkSettingsAllowDownloadEnabledDetails = _sharedLinkSettingsAllowDownloadEnabledDetails;
@synthesize sharedLinkSettingsChangeAudienceDetails = _sharedLinkSettingsChangeAudienceDetails;
@synthesize sharedLinkSettingsChangeExpirationDetails = _sharedLinkSettingsChangeExpirationDetails;
@synthesize sharedLinkSettingsChangePasswordDetails = _sharedLinkSettingsChangePasswordDetails;
@synthesize sharedLinkSettingsRemoveExpirationDetails = _sharedLinkSettingsRemoveExpirationDetails;
@synthesize sharedLinkSettingsRemovePasswordDetails = _sharedLinkSettingsRemovePasswordDetails;
@synthesize sharedLinkShareDetails = _sharedLinkShareDetails;
@synthesize sharedLinkViewDetails = _sharedLinkViewDetails;
@synthesize sharedNoteOpenedDetails = _sharedNoteOpenedDetails;
@synthesize shmodelDisableDownloadsDetails = _shmodelDisableDownloadsDetails;
@synthesize shmodelEnableDownloadsDetails = _shmodelEnableDownloadsDetails;
@synthesize shmodelGroupShareDetails = _shmodelGroupShareDetails;
@synthesize showcaseAccessGrantedDetails = _showcaseAccessGrantedDetails;
@synthesize showcaseAddMemberDetails = _showcaseAddMemberDetails;
@synthesize showcaseArchivedDetails = _showcaseArchivedDetails;
@synthesize showcaseCreatedDetails = _showcaseCreatedDetails;
@synthesize showcaseDeleteCommentDetails = _showcaseDeleteCommentDetails;
@synthesize showcaseEditedDetails = _showcaseEditedDetails;
@synthesize showcaseEditCommentDetails = _showcaseEditCommentDetails;
@synthesize showcaseFileAddedDetails = _showcaseFileAddedDetails;
@synthesize showcaseFileDownloadDetails = _showcaseFileDownloadDetails;
@synthesize showcaseFileRemovedDetails = _showcaseFileRemovedDetails;
@synthesize showcaseFileViewDetails = _showcaseFileViewDetails;
@synthesize showcasePermanentlyDeletedDetails = _showcasePermanentlyDeletedDetails;
@synthesize showcasePostCommentDetails = _showcasePostCommentDetails;
@synthesize showcaseRemoveMemberDetails = _showcaseRemoveMemberDetails;
@synthesize showcaseRenamedDetails = _showcaseRenamedDetails;
@synthesize showcaseRequestAccessDetails = _showcaseRequestAccessDetails;
@synthesize showcaseResolveCommentDetails = _showcaseResolveCommentDetails;
@synthesize showcaseRestoredDetails = _showcaseRestoredDetails;
@synthesize showcaseTrashedDetails = _showcaseTrashedDetails;
@synthesize showcaseTrashedDeprecatedDetails = _showcaseTrashedDeprecatedDetails;
@synthesize showcaseUnresolveCommentDetails = _showcaseUnresolveCommentDetails;
@synthesize showcaseUntrashedDetails = _showcaseUntrashedDetails;
@synthesize showcaseUntrashedDeprecatedDetails = _showcaseUntrashedDeprecatedDetails;
@synthesize showcaseViewDetails = _showcaseViewDetails;
@synthesize ssoAddCertDetails = _ssoAddCertDetails;
@synthesize ssoAddLoginUrlDetails = _ssoAddLoginUrlDetails;
@synthesize ssoAddLogoutUrlDetails = _ssoAddLogoutUrlDetails;
@synthesize ssoChangeCertDetails = _ssoChangeCertDetails;
@synthesize ssoChangeLoginUrlDetails = _ssoChangeLoginUrlDetails;
@synthesize ssoChangeLogoutUrlDetails = _ssoChangeLogoutUrlDetails;
@synthesize ssoChangeSamlIdentityModeDetails = _ssoChangeSamlIdentityModeDetails;
@synthesize ssoRemoveCertDetails = _ssoRemoveCertDetails;
@synthesize ssoRemoveLoginUrlDetails = _ssoRemoveLoginUrlDetails;
@synthesize ssoRemoveLogoutUrlDetails = _ssoRemoveLogoutUrlDetails;
@synthesize teamFolderChangeStatusDetails = _teamFolderChangeStatusDetails;
@synthesize teamFolderCreateDetails = _teamFolderCreateDetails;
@synthesize teamFolderDowngradeDetails = _teamFolderDowngradeDetails;
@synthesize teamFolderPermanentlyDeleteDetails = _teamFolderPermanentlyDeleteDetails;
@synthesize teamFolderRenameDetails = _teamFolderRenameDetails;
@synthesize teamSelectiveSyncSettingsChangedDetails = _teamSelectiveSyncSettingsChangedDetails;
@synthesize accountCaptureChangePolicyDetails = _accountCaptureChangePolicyDetails;
@synthesize allowDownloadDisabledDetails = _allowDownloadDisabledDetails;
@synthesize allowDownloadEnabledDetails = _allowDownloadEnabledDetails;
@synthesize cameraUploadsPolicyChangedDetails = _cameraUploadsPolicyChangedDetails;
@synthesize classificationChangePolicyDetails = _classificationChangePolicyDetails;
@synthesize computerBackupPolicyChangedDetails = _computerBackupPolicyChangedDetails;
@synthesize contentAdministrationPolicyChangedDetails = _contentAdministrationPolicyChangedDetails;
@synthesize dataPlacementRestrictionChangePolicyDetails = _dataPlacementRestrictionChangePolicyDetails;
@synthesize dataPlacementRestrictionSatisfyPolicyDetails = _dataPlacementRestrictionSatisfyPolicyDetails;
@synthesize deviceApprovalsAddExceptionDetails = _deviceApprovalsAddExceptionDetails;
@synthesize deviceApprovalsChangeDesktopPolicyDetails = _deviceApprovalsChangeDesktopPolicyDetails;
@synthesize deviceApprovalsChangeMobilePolicyDetails = _deviceApprovalsChangeMobilePolicyDetails;
@synthesize deviceApprovalsChangeOverageActionDetails = _deviceApprovalsChangeOverageActionDetails;
@synthesize deviceApprovalsChangeUnlinkActionDetails = _deviceApprovalsChangeUnlinkActionDetails;
@synthesize deviceApprovalsRemoveExceptionDetails = _deviceApprovalsRemoveExceptionDetails;
@synthesize directoryRestrictionsAddMembersDetails = _directoryRestrictionsAddMembersDetails;
@synthesize directoryRestrictionsRemoveMembersDetails = _directoryRestrictionsRemoveMembersDetails;
@synthesize emmAddExceptionDetails = _emmAddExceptionDetails;
@synthesize emmChangePolicyDetails = _emmChangePolicyDetails;
@synthesize emmRemoveExceptionDetails = _emmRemoveExceptionDetails;
@synthesize extendedVersionHistoryChangePolicyDetails = _extendedVersionHistoryChangePolicyDetails;
@synthesize fileCommentsChangePolicyDetails = _fileCommentsChangePolicyDetails;
@synthesize fileLockingPolicyChangedDetails = _fileLockingPolicyChangedDetails;
@synthesize fileRequestsChangePolicyDetails = _fileRequestsChangePolicyDetails;
@synthesize fileRequestsEmailsEnabledDetails = _fileRequestsEmailsEnabledDetails;
@synthesize fileRequestsEmailsRestrictedToTeamOnlyDetails = _fileRequestsEmailsRestrictedToTeamOnlyDetails;
@synthesize fileTransfersPolicyChangedDetails = _fileTransfersPolicyChangedDetails;
@synthesize googleSsoChangePolicyDetails = _googleSsoChangePolicyDetails;
@synthesize groupUserManagementChangePolicyDetails = _groupUserManagementChangePolicyDetails;
@synthesize integrationPolicyChangedDetails = _integrationPolicyChangedDetails;
@synthesize memberRequestsChangePolicyDetails = _memberRequestsChangePolicyDetails;
@synthesize memberSendInvitePolicyChangedDetails = _memberSendInvitePolicyChangedDetails;
@synthesize memberSpaceLimitsAddExceptionDetails = _memberSpaceLimitsAddExceptionDetails;
@synthesize memberSpaceLimitsChangeCapsTypePolicyDetails = _memberSpaceLimitsChangeCapsTypePolicyDetails;
@synthesize memberSpaceLimitsChangePolicyDetails = _memberSpaceLimitsChangePolicyDetails;
@synthesize memberSpaceLimitsRemoveExceptionDetails = _memberSpaceLimitsRemoveExceptionDetails;
@synthesize memberSuggestionsChangePolicyDetails = _memberSuggestionsChangePolicyDetails;
@synthesize microsoftOfficeAddinChangePolicyDetails = _microsoftOfficeAddinChangePolicyDetails;
@synthesize networkControlChangePolicyDetails = _networkControlChangePolicyDetails;
@synthesize paperChangeDeploymentPolicyDetails = _paperChangeDeploymentPolicyDetails;
@synthesize paperChangeMemberLinkPolicyDetails = _paperChangeMemberLinkPolicyDetails;
@synthesize paperChangeMemberPolicyDetails = _paperChangeMemberPolicyDetails;
@synthesize paperChangePolicyDetails = _paperChangePolicyDetails;
@synthesize paperDefaultFolderPolicyChangedDetails = _paperDefaultFolderPolicyChangedDetails;
@synthesize paperDesktopPolicyChangedDetails = _paperDesktopPolicyChangedDetails;
@synthesize paperEnabledUsersGroupAdditionDetails = _paperEnabledUsersGroupAdditionDetails;
@synthesize paperEnabledUsersGroupRemovalDetails = _paperEnabledUsersGroupRemovalDetails;
@synthesize passwordStrengthRequirementsChangePolicyDetails = _passwordStrengthRequirementsChangePolicyDetails;
@synthesize permanentDeleteChangePolicyDetails = _permanentDeleteChangePolicyDetails;
@synthesize resellerSupportChangePolicyDetails = _resellerSupportChangePolicyDetails;
@synthesize rewindPolicyChangedDetails = _rewindPolicyChangedDetails;
@synthesize sendForSignaturePolicyChangedDetails = _sendForSignaturePolicyChangedDetails;
@synthesize sharingChangeFolderJoinPolicyDetails = _sharingChangeFolderJoinPolicyDetails;
@synthesize sharingChangeLinkPolicyDetails = _sharingChangeLinkPolicyDetails;
@synthesize sharingChangeMemberPolicyDetails = _sharingChangeMemberPolicyDetails;
@synthesize showcaseChangeDownloadPolicyDetails = _showcaseChangeDownloadPolicyDetails;
@synthesize showcaseChangeEnabledPolicyDetails = _showcaseChangeEnabledPolicyDetails;
@synthesize showcaseChangeExternalSharingPolicyDetails = _showcaseChangeExternalSharingPolicyDetails;
@synthesize smarterSmartSyncPolicyChangedDetails = _smarterSmartSyncPolicyChangedDetails;
@synthesize smartSyncChangePolicyDetails = _smartSyncChangePolicyDetails;
@synthesize smartSyncNotOptOutDetails = _smartSyncNotOptOutDetails;
@synthesize smartSyncOptOutDetails = _smartSyncOptOutDetails;
@synthesize ssoChangePolicyDetails = _ssoChangePolicyDetails;
@synthesize teamBrandingPolicyChangedDetails = _teamBrandingPolicyChangedDetails;
@synthesize teamExtensionsPolicyChangedDetails = _teamExtensionsPolicyChangedDetails;
@synthesize teamSelectiveSyncPolicyChangedDetails = _teamSelectiveSyncPolicyChangedDetails;
@synthesize teamSharingWhitelistSubjectsChangedDetails = _teamSharingWhitelistSubjectsChangedDetails;
@synthesize tfaAddExceptionDetails = _tfaAddExceptionDetails;
@synthesize tfaChangePolicyDetails = _tfaChangePolicyDetails;
@synthesize tfaRemoveExceptionDetails = _tfaRemoveExceptionDetails;
@synthesize twoAccountChangePolicyDetails = _twoAccountChangePolicyDetails;
@synthesize viewerInfoPolicyChangedDetails = _viewerInfoPolicyChangedDetails;
@synthesize watermarkingPolicyChangedDetails = _watermarkingPolicyChangedDetails;
@synthesize webSessionsChangeActiveSessionLimitDetails = _webSessionsChangeActiveSessionLimitDetails;
@synthesize webSessionsChangeFixedLengthPolicyDetails = _webSessionsChangeFixedLengthPolicyDetails;
@synthesize webSessionsChangeIdleLengthPolicyDetails = _webSessionsChangeIdleLengthPolicyDetails;
@synthesize teamMergeFromDetails = _teamMergeFromDetails;
@synthesize teamMergeToDetails = _teamMergeToDetails;
@synthesize teamProfileAddBackgroundDetails = _teamProfileAddBackgroundDetails;
@synthesize teamProfileAddLogoDetails = _teamProfileAddLogoDetails;
@synthesize teamProfileChangeBackgroundDetails = _teamProfileChangeBackgroundDetails;
@synthesize teamProfileChangeDefaultLanguageDetails = _teamProfileChangeDefaultLanguageDetails;
@synthesize teamProfileChangeLogoDetails = _teamProfileChangeLogoDetails;
@synthesize teamProfileChangeNameDetails = _teamProfileChangeNameDetails;
@synthesize teamProfileRemoveBackgroundDetails = _teamProfileRemoveBackgroundDetails;
@synthesize teamProfileRemoveLogoDetails = _teamProfileRemoveLogoDetails;
@synthesize tfaAddBackupPhoneDetails = _tfaAddBackupPhoneDetails;
@synthesize tfaAddSecurityKeyDetails = _tfaAddSecurityKeyDetails;
@synthesize tfaChangeBackupPhoneDetails = _tfaChangeBackupPhoneDetails;
@synthesize tfaChangeStatusDetails = _tfaChangeStatusDetails;
@synthesize tfaRemoveBackupPhoneDetails = _tfaRemoveBackupPhoneDetails;
@synthesize tfaRemoveSecurityKeyDetails = _tfaRemoveSecurityKeyDetails;
@synthesize tfaResetDetails = _tfaResetDetails;
@synthesize changedEnterpriseAdminRoleDetails = _changedEnterpriseAdminRoleDetails;
@synthesize changedEnterpriseConnectedTeamStatusDetails = _changedEnterpriseConnectedTeamStatusDetails;
@synthesize endedEnterpriseAdminSessionDetails = _endedEnterpriseAdminSessionDetails;
@synthesize endedEnterpriseAdminSessionDeprecatedDetails = _endedEnterpriseAdminSessionDeprecatedDetails;
@synthesize enterpriseSettingsLockingDetails = _enterpriseSettingsLockingDetails;
@synthesize guestAdminChangeStatusDetails = _guestAdminChangeStatusDetails;
@synthesize startedEnterpriseAdminSessionDetails = _startedEnterpriseAdminSessionDetails;
@synthesize teamMergeRequestAcceptedDetails = _teamMergeRequestAcceptedDetails;
@synthesize teamMergeRequestAcceptedShownToPrimaryTeamDetails = _teamMergeRequestAcceptedShownToPrimaryTeamDetails;
@synthesize teamMergeRequestAcceptedShownToSecondaryTeamDetails = _teamMergeRequestAcceptedShownToSecondaryTeamDetails;
@synthesize teamMergeRequestAutoCanceledDetails = _teamMergeRequestAutoCanceledDetails;
@synthesize teamMergeRequestCanceledDetails = _teamMergeRequestCanceledDetails;
@synthesize teamMergeRequestCanceledShownToPrimaryTeamDetails = _teamMergeRequestCanceledShownToPrimaryTeamDetails;
@synthesize teamMergeRequestCanceledShownToSecondaryTeamDetails = _teamMergeRequestCanceledShownToSecondaryTeamDetails;
@synthesize teamMergeRequestExpiredDetails = _teamMergeRequestExpiredDetails;
@synthesize teamMergeRequestExpiredShownToPrimaryTeamDetails = _teamMergeRequestExpiredShownToPrimaryTeamDetails;
@synthesize teamMergeRequestExpiredShownToSecondaryTeamDetails = _teamMergeRequestExpiredShownToSecondaryTeamDetails;
@synthesize teamMergeRequestRejectedShownToPrimaryTeamDetails = _teamMergeRequestRejectedShownToPrimaryTeamDetails;
@synthesize teamMergeRequestRejectedShownToSecondaryTeamDetails = _teamMergeRequestRejectedShownToSecondaryTeamDetails;
@synthesize teamMergeRequestReminderDetails = _teamMergeRequestReminderDetails;
@synthesize teamMergeRequestReminderShownToPrimaryTeamDetails = _teamMergeRequestReminderShownToPrimaryTeamDetails;
@synthesize teamMergeRequestReminderShownToSecondaryTeamDetails = _teamMergeRequestReminderShownToSecondaryTeamDetails;
@synthesize teamMergeRequestRevokedDetails = _teamMergeRequestRevokedDetails;
@synthesize teamMergeRequestSentShownToPrimaryTeamDetails = _teamMergeRequestSentShownToPrimaryTeamDetails;
@synthesize teamMergeRequestSentShownToSecondaryTeamDetails = _teamMergeRequestSentShownToSecondaryTeamDetails;
@synthesize missingDetails = _missingDetails;

#pragma mark - Constructors

- (instancetype)initWithAdminAlertingChangedAlertConfigDetails:
    (DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)adminAlertingChangedAlertConfigDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAdminAlertingChangedAlertConfigDetails;
    _adminAlertingChangedAlertConfigDetails = adminAlertingChangedAlertConfigDetails;
  }
  return self;
}

- (instancetype)initWithAdminAlertingTriggeredAlertDetails:
    (DBTEAMLOGAdminAlertingTriggeredAlertDetails *)adminAlertingTriggeredAlertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAdminAlertingTriggeredAlertDetails;
    _adminAlertingTriggeredAlertDetails = adminAlertingTriggeredAlertDetails;
  }
  return self;
}

- (instancetype)initWithAppLinkTeamDetails:(DBTEAMLOGAppLinkTeamDetails *)appLinkTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAppLinkTeamDetails;
    _appLinkTeamDetails = appLinkTeamDetails;
  }
  return self;
}

- (instancetype)initWithAppLinkUserDetails:(DBTEAMLOGAppLinkUserDetails *)appLinkUserDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAppLinkUserDetails;
    _appLinkUserDetails = appLinkUserDetails;
  }
  return self;
}

- (instancetype)initWithAppUnlinkTeamDetails:(DBTEAMLOGAppUnlinkTeamDetails *)appUnlinkTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAppUnlinkTeamDetails;
    _appUnlinkTeamDetails = appUnlinkTeamDetails;
  }
  return self;
}

- (instancetype)initWithAppUnlinkUserDetails:(DBTEAMLOGAppUnlinkUserDetails *)appUnlinkUserDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAppUnlinkUserDetails;
    _appUnlinkUserDetails = appUnlinkUserDetails;
  }
  return self;
}

- (instancetype)initWithIntegrationConnectedDetails:
    (DBTEAMLOGIntegrationConnectedDetails *)integrationConnectedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsIntegrationConnectedDetails;
    _integrationConnectedDetails = integrationConnectedDetails;
  }
  return self;
}

- (instancetype)initWithIntegrationDisconnectedDetails:
    (DBTEAMLOGIntegrationDisconnectedDetails *)integrationDisconnectedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsIntegrationDisconnectedDetails;
    _integrationDisconnectedDetails = integrationDisconnectedDetails;
  }
  return self;
}

- (instancetype)initWithFileAddCommentDetails:(DBTEAMLOGFileAddCommentDetails *)fileAddCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileAddCommentDetails;
    _fileAddCommentDetails = fileAddCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileChangeCommentSubscriptionDetails:
    (DBTEAMLOGFileChangeCommentSubscriptionDetails *)fileChangeCommentSubscriptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileChangeCommentSubscriptionDetails;
    _fileChangeCommentSubscriptionDetails = fileChangeCommentSubscriptionDetails;
  }
  return self;
}

- (instancetype)initWithFileDeleteCommentDetails:(DBTEAMLOGFileDeleteCommentDetails *)fileDeleteCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileDeleteCommentDetails;
    _fileDeleteCommentDetails = fileDeleteCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileEditCommentDetails:(DBTEAMLOGFileEditCommentDetails *)fileEditCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileEditCommentDetails;
    _fileEditCommentDetails = fileEditCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileLikeCommentDetails:(DBTEAMLOGFileLikeCommentDetails *)fileLikeCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileLikeCommentDetails;
    _fileLikeCommentDetails = fileLikeCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileResolveCommentDetails:(DBTEAMLOGFileResolveCommentDetails *)fileResolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileResolveCommentDetails;
    _fileResolveCommentDetails = fileResolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileUnlikeCommentDetails:(DBTEAMLOGFileUnlikeCommentDetails *)fileUnlikeCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileUnlikeCommentDetails;
    _fileUnlikeCommentDetails = fileUnlikeCommentDetails;
  }
  return self;
}

- (instancetype)initWithFileUnresolveCommentDetails:
    (DBTEAMLOGFileUnresolveCommentDetails *)fileUnresolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileUnresolveCommentDetails;
    _fileUnresolveCommentDetails = fileUnresolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyAddFoldersDetails:
    (DBTEAMLOGGovernancePolicyAddFoldersDetails *)governancePolicyAddFoldersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyAddFoldersDetails;
    _governancePolicyAddFoldersDetails = governancePolicyAddFoldersDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyAddFolderFailedDetails:
    (DBTEAMLOGGovernancePolicyAddFolderFailedDetails *)governancePolicyAddFolderFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyAddFolderFailedDetails;
    _governancePolicyAddFolderFailedDetails = governancePolicyAddFolderFailedDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyContentDisposedDetails:
    (DBTEAMLOGGovernancePolicyContentDisposedDetails *)governancePolicyContentDisposedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyContentDisposedDetails;
    _governancePolicyContentDisposedDetails = governancePolicyContentDisposedDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyCreateDetails:
    (DBTEAMLOGGovernancePolicyCreateDetails *)governancePolicyCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyCreateDetails;
    _governancePolicyCreateDetails = governancePolicyCreateDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyDeleteDetails:
    (DBTEAMLOGGovernancePolicyDeleteDetails *)governancePolicyDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyDeleteDetails;
    _governancePolicyDeleteDetails = governancePolicyDeleteDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyEditDetailsDetails:
    (DBTEAMLOGGovernancePolicyEditDetailsDetails *)governancePolicyEditDetailsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyEditDetailsDetails;
    _governancePolicyEditDetailsDetails = governancePolicyEditDetailsDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyEditDurationDetails:
    (DBTEAMLOGGovernancePolicyEditDurationDetails *)governancePolicyEditDurationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyEditDurationDetails;
    _governancePolicyEditDurationDetails = governancePolicyEditDurationDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyExportCreatedDetails:
    (DBTEAMLOGGovernancePolicyExportCreatedDetails *)governancePolicyExportCreatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyExportCreatedDetails;
    _governancePolicyExportCreatedDetails = governancePolicyExportCreatedDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyExportRemovedDetails:
    (DBTEAMLOGGovernancePolicyExportRemovedDetails *)governancePolicyExportRemovedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyExportRemovedDetails;
    _governancePolicyExportRemovedDetails = governancePolicyExportRemovedDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyRemoveFoldersDetails:
    (DBTEAMLOGGovernancePolicyRemoveFoldersDetails *)governancePolicyRemoveFoldersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyRemoveFoldersDetails;
    _governancePolicyRemoveFoldersDetails = governancePolicyRemoveFoldersDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyReportCreatedDetails:
    (DBTEAMLOGGovernancePolicyReportCreatedDetails *)governancePolicyReportCreatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyReportCreatedDetails;
    _governancePolicyReportCreatedDetails = governancePolicyReportCreatedDetails;
  }
  return self;
}

- (instancetype)initWithGovernancePolicyZipPartDownloadedDetails:
    (DBTEAMLOGGovernancePolicyZipPartDownloadedDetails *)governancePolicyZipPartDownloadedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGovernancePolicyZipPartDownloadedDetails;
    _governancePolicyZipPartDownloadedDetails = governancePolicyZipPartDownloadedDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsActivateAHoldDetails:
    (DBTEAMLOGLegalHoldsActivateAHoldDetails *)legalHoldsActivateAHoldDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsActivateAHoldDetails;
    _legalHoldsActivateAHoldDetails = legalHoldsActivateAHoldDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsAddMembersDetails:
    (DBTEAMLOGLegalHoldsAddMembersDetails *)legalHoldsAddMembersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsAddMembersDetails;
    _legalHoldsAddMembersDetails = legalHoldsAddMembersDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsChangeHoldDetailsDetails:
    (DBTEAMLOGLegalHoldsChangeHoldDetailsDetails *)legalHoldsChangeHoldDetailsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsChangeHoldDetailsDetails;
    _legalHoldsChangeHoldDetailsDetails = legalHoldsChangeHoldDetailsDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsChangeHoldNameDetails:
    (DBTEAMLOGLegalHoldsChangeHoldNameDetails *)legalHoldsChangeHoldNameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsChangeHoldNameDetails;
    _legalHoldsChangeHoldNameDetails = legalHoldsChangeHoldNameDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsExportAHoldDetails:
    (DBTEAMLOGLegalHoldsExportAHoldDetails *)legalHoldsExportAHoldDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsExportAHoldDetails;
    _legalHoldsExportAHoldDetails = legalHoldsExportAHoldDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsExportCancelledDetails:
    (DBTEAMLOGLegalHoldsExportCancelledDetails *)legalHoldsExportCancelledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsExportCancelledDetails;
    _legalHoldsExportCancelledDetails = legalHoldsExportCancelledDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsExportDownloadedDetails:
    (DBTEAMLOGLegalHoldsExportDownloadedDetails *)legalHoldsExportDownloadedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsExportDownloadedDetails;
    _legalHoldsExportDownloadedDetails = legalHoldsExportDownloadedDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsExportRemovedDetails:
    (DBTEAMLOGLegalHoldsExportRemovedDetails *)legalHoldsExportRemovedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsExportRemovedDetails;
    _legalHoldsExportRemovedDetails = legalHoldsExportRemovedDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsReleaseAHoldDetails:
    (DBTEAMLOGLegalHoldsReleaseAHoldDetails *)legalHoldsReleaseAHoldDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsReleaseAHoldDetails;
    _legalHoldsReleaseAHoldDetails = legalHoldsReleaseAHoldDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsRemoveMembersDetails:
    (DBTEAMLOGLegalHoldsRemoveMembersDetails *)legalHoldsRemoveMembersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsRemoveMembersDetails;
    _legalHoldsRemoveMembersDetails = legalHoldsRemoveMembersDetails;
  }
  return self;
}

- (instancetype)initWithLegalHoldsReportAHoldDetails:
    (DBTEAMLOGLegalHoldsReportAHoldDetails *)legalHoldsReportAHoldDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLegalHoldsReportAHoldDetails;
    _legalHoldsReportAHoldDetails = legalHoldsReportAHoldDetails;
  }
  return self;
}

- (instancetype)initWithDeviceChangeIpDesktopDetails:
    (DBTEAMLOGDeviceChangeIpDesktopDetails *)deviceChangeIpDesktopDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceChangeIpDesktopDetails;
    _deviceChangeIpDesktopDetails = deviceChangeIpDesktopDetails;
  }
  return self;
}

- (instancetype)initWithDeviceChangeIpMobileDetails:
    (DBTEAMLOGDeviceChangeIpMobileDetails *)deviceChangeIpMobileDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceChangeIpMobileDetails;
    _deviceChangeIpMobileDetails = deviceChangeIpMobileDetails;
  }
  return self;
}

- (instancetype)initWithDeviceChangeIpWebDetails:(DBTEAMLOGDeviceChangeIpWebDetails *)deviceChangeIpWebDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceChangeIpWebDetails;
    _deviceChangeIpWebDetails = deviceChangeIpWebDetails;
  }
  return self;
}

- (instancetype)initWithDeviceDeleteOnUnlinkFailDetails:
    (DBTEAMLOGDeviceDeleteOnUnlinkFailDetails *)deviceDeleteOnUnlinkFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceDeleteOnUnlinkFailDetails;
    _deviceDeleteOnUnlinkFailDetails = deviceDeleteOnUnlinkFailDetails;
  }
  return self;
}

- (instancetype)initWithDeviceDeleteOnUnlinkSuccessDetails:
    (DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)deviceDeleteOnUnlinkSuccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceDeleteOnUnlinkSuccessDetails;
    _deviceDeleteOnUnlinkSuccessDetails = deviceDeleteOnUnlinkSuccessDetails;
  }
  return self;
}

- (instancetype)initWithDeviceLinkFailDetails:(DBTEAMLOGDeviceLinkFailDetails *)deviceLinkFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceLinkFailDetails;
    _deviceLinkFailDetails = deviceLinkFailDetails;
  }
  return self;
}

- (instancetype)initWithDeviceLinkSuccessDetails:(DBTEAMLOGDeviceLinkSuccessDetails *)deviceLinkSuccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceLinkSuccessDetails;
    _deviceLinkSuccessDetails = deviceLinkSuccessDetails;
  }
  return self;
}

- (instancetype)initWithDeviceManagementDisabledDetails:
    (DBTEAMLOGDeviceManagementDisabledDetails *)deviceManagementDisabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceManagementDisabledDetails;
    _deviceManagementDisabledDetails = deviceManagementDisabledDetails;
  }
  return self;
}

- (instancetype)initWithDeviceManagementEnabledDetails:
    (DBTEAMLOGDeviceManagementEnabledDetails *)deviceManagementEnabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceManagementEnabledDetails;
    _deviceManagementEnabledDetails = deviceManagementEnabledDetails;
  }
  return self;
}

- (instancetype)initWithDeviceSyncBackupStatusChangedDetails:
    (DBTEAMLOGDeviceSyncBackupStatusChangedDetails *)deviceSyncBackupStatusChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceSyncBackupStatusChangedDetails;
    _deviceSyncBackupStatusChangedDetails = deviceSyncBackupStatusChangedDetails;
  }
  return self;
}

- (instancetype)initWithDeviceUnlinkDetails:(DBTEAMLOGDeviceUnlinkDetails *)deviceUnlinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceUnlinkDetails;
    _deviceUnlinkDetails = deviceUnlinkDetails;
  }
  return self;
}

- (instancetype)initWithDropboxPasswordsExportedDetails:
    (DBTEAMLOGDropboxPasswordsExportedDetails *)dropboxPasswordsExportedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDropboxPasswordsExportedDetails;
    _dropboxPasswordsExportedDetails = dropboxPasswordsExportedDetails;
  }
  return self;
}

- (instancetype)initWithDropboxPasswordsNewDeviceEnrolledDetails:
    (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)dropboxPasswordsNewDeviceEnrolledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDropboxPasswordsNewDeviceEnrolledDetails;
    _dropboxPasswordsNewDeviceEnrolledDetails = dropboxPasswordsNewDeviceEnrolledDetails;
  }
  return self;
}

- (instancetype)initWithEmmRefreshAuthTokenDetails:(DBTEAMLOGEmmRefreshAuthTokenDetails *)emmRefreshAuthTokenDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmRefreshAuthTokenDetails;
    _emmRefreshAuthTokenDetails = emmRefreshAuthTokenDetails;
  }
  return self;
}

- (instancetype)initWithAccountCaptureChangeAvailabilityDetails:
    (DBTEAMLOGAccountCaptureChangeAvailabilityDetails *)accountCaptureChangeAvailabilityDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountCaptureChangeAvailabilityDetails;
    _accountCaptureChangeAvailabilityDetails = accountCaptureChangeAvailabilityDetails;
  }
  return self;
}

- (instancetype)initWithAccountCaptureMigrateAccountDetails:
    (DBTEAMLOGAccountCaptureMigrateAccountDetails *)accountCaptureMigrateAccountDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountCaptureMigrateAccountDetails;
    _accountCaptureMigrateAccountDetails = accountCaptureMigrateAccountDetails;
  }
  return self;
}

- (instancetype)initWithAccountCaptureNotificationEmailsSentDetails:
    (DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)accountCaptureNotificationEmailsSentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountCaptureNotificationEmailsSentDetails;
    _accountCaptureNotificationEmailsSentDetails = accountCaptureNotificationEmailsSentDetails;
  }
  return self;
}

- (instancetype)initWithAccountCaptureRelinquishAccountDetails:
    (DBTEAMLOGAccountCaptureRelinquishAccountDetails *)accountCaptureRelinquishAccountDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountCaptureRelinquishAccountDetails;
    _accountCaptureRelinquishAccountDetails = accountCaptureRelinquishAccountDetails;
  }
  return self;
}

- (instancetype)initWithDisabledDomainInvitesDetails:
    (DBTEAMLOGDisabledDomainInvitesDetails *)disabledDomainInvitesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDisabledDomainInvitesDetails;
    _disabledDomainInvitesDetails = disabledDomainInvitesDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesApproveRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails *)domainInvitesApproveRequestToJoinTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesApproveRequestToJoinTeamDetails;
    _domainInvitesApproveRequestToJoinTeamDetails = domainInvitesApproveRequestToJoinTeamDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesDeclineRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails *)domainInvitesDeclineRequestToJoinTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesDeclineRequestToJoinTeamDetails;
    _domainInvitesDeclineRequestToJoinTeamDetails = domainInvitesDeclineRequestToJoinTeamDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesEmailExistingUsersDetails:
    (DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)domainInvitesEmailExistingUsersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesEmailExistingUsersDetails;
    _domainInvitesEmailExistingUsersDetails = domainInvitesEmailExistingUsersDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesRequestToJoinTeamDetails:
    (DBTEAMLOGDomainInvitesRequestToJoinTeamDetails *)domainInvitesRequestToJoinTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesRequestToJoinTeamDetails;
    _domainInvitesRequestToJoinTeamDetails = domainInvitesRequestToJoinTeamDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesSetInviteNewUserPrefToNoDetails:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails *)domainInvitesSetInviteNewUserPrefToNoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesSetInviteNewUserPrefToNoDetails;
    _domainInvitesSetInviteNewUserPrefToNoDetails = domainInvitesSetInviteNewUserPrefToNoDetails;
  }
  return self;
}

- (instancetype)initWithDomainInvitesSetInviteNewUserPrefToYesDetails:
    (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails *)domainInvitesSetInviteNewUserPrefToYesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainInvitesSetInviteNewUserPrefToYesDetails;
    _domainInvitesSetInviteNewUserPrefToYesDetails = domainInvitesSetInviteNewUserPrefToYesDetails;
  }
  return self;
}

- (instancetype)initWithDomainVerificationAddDomainFailDetails:
    (DBTEAMLOGDomainVerificationAddDomainFailDetails *)domainVerificationAddDomainFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainVerificationAddDomainFailDetails;
    _domainVerificationAddDomainFailDetails = domainVerificationAddDomainFailDetails;
  }
  return self;
}

- (instancetype)initWithDomainVerificationAddDomainSuccessDetails:
    (DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)domainVerificationAddDomainSuccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainVerificationAddDomainSuccessDetails;
    _domainVerificationAddDomainSuccessDetails = domainVerificationAddDomainSuccessDetails;
  }
  return self;
}

- (instancetype)initWithDomainVerificationRemoveDomainDetails:
    (DBTEAMLOGDomainVerificationRemoveDomainDetails *)domainVerificationRemoveDomainDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDomainVerificationRemoveDomainDetails;
    _domainVerificationRemoveDomainDetails = domainVerificationRemoveDomainDetails;
  }
  return self;
}

- (instancetype)initWithEnabledDomainInvitesDetails:
    (DBTEAMLOGEnabledDomainInvitesDetails *)enabledDomainInvitesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEnabledDomainInvitesDetails;
    _enabledDomainInvitesDetails = enabledDomainInvitesDetails;
  }
  return self;
}

- (instancetype)initWithCreateFolderDetails:(DBTEAMLOGCreateFolderDetails *)createFolderDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsCreateFolderDetails;
    _createFolderDetails = createFolderDetails;
  }
  return self;
}

- (instancetype)initWithFileAddDetails:(DBTEAMLOGFileAddDetails *)fileAddDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileAddDetails;
    _fileAddDetails = fileAddDetails;
  }
  return self;
}

- (instancetype)initWithFileCopyDetails:(DBTEAMLOGFileCopyDetails *)fileCopyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileCopyDetails;
    _fileCopyDetails = fileCopyDetails;
  }
  return self;
}

- (instancetype)initWithFileDeleteDetails:(DBTEAMLOGFileDeleteDetails *)fileDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileDeleteDetails;
    _fileDeleteDetails = fileDeleteDetails;
  }
  return self;
}

- (instancetype)initWithFileDownloadDetails:(DBTEAMLOGFileDownloadDetails *)fileDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileDownloadDetails;
    _fileDownloadDetails = fileDownloadDetails;
  }
  return self;
}

- (instancetype)initWithFileEditDetails:(DBTEAMLOGFileEditDetails *)fileEditDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileEditDetails;
    _fileEditDetails = fileEditDetails;
  }
  return self;
}

- (instancetype)initWithFileGetCopyReferenceDetails:
    (DBTEAMLOGFileGetCopyReferenceDetails *)fileGetCopyReferenceDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileGetCopyReferenceDetails;
    _fileGetCopyReferenceDetails = fileGetCopyReferenceDetails;
  }
  return self;
}

- (instancetype)initWithFileLockingLockStatusChangedDetails:
    (DBTEAMLOGFileLockingLockStatusChangedDetails *)fileLockingLockStatusChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileLockingLockStatusChangedDetails;
    _fileLockingLockStatusChangedDetails = fileLockingLockStatusChangedDetails;
  }
  return self;
}

- (instancetype)initWithFileMoveDetails:(DBTEAMLOGFileMoveDetails *)fileMoveDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileMoveDetails;
    _fileMoveDetails = fileMoveDetails;
  }
  return self;
}

- (instancetype)initWithFilePermanentlyDeleteDetails:
    (DBTEAMLOGFilePermanentlyDeleteDetails *)filePermanentlyDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFilePermanentlyDeleteDetails;
    _filePermanentlyDeleteDetails = filePermanentlyDeleteDetails;
  }
  return self;
}

- (instancetype)initWithFilePreviewDetails:(DBTEAMLOGFilePreviewDetails *)filePreviewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFilePreviewDetails;
    _filePreviewDetails = filePreviewDetails;
  }
  return self;
}

- (instancetype)initWithFileRenameDetails:(DBTEAMLOGFileRenameDetails *)fileRenameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRenameDetails;
    _fileRenameDetails = fileRenameDetails;
  }
  return self;
}

- (instancetype)initWithFileRestoreDetails:(DBTEAMLOGFileRestoreDetails *)fileRestoreDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRestoreDetails;
    _fileRestoreDetails = fileRestoreDetails;
  }
  return self;
}

- (instancetype)initWithFileRevertDetails:(DBTEAMLOGFileRevertDetails *)fileRevertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRevertDetails;
    _fileRevertDetails = fileRevertDetails;
  }
  return self;
}

- (instancetype)initWithFileRollbackChangesDetails:(DBTEAMLOGFileRollbackChangesDetails *)fileRollbackChangesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRollbackChangesDetails;
    _fileRollbackChangesDetails = fileRollbackChangesDetails;
  }
  return self;
}

- (instancetype)initWithFileSaveCopyReferenceDetails:
    (DBTEAMLOGFileSaveCopyReferenceDetails *)fileSaveCopyReferenceDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileSaveCopyReferenceDetails;
    _fileSaveCopyReferenceDetails = fileSaveCopyReferenceDetails;
  }
  return self;
}

- (instancetype)initWithFolderOverviewDescriptionChangedDetails:
    (DBTEAMLOGFolderOverviewDescriptionChangedDetails *)folderOverviewDescriptionChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFolderOverviewDescriptionChangedDetails;
    _folderOverviewDescriptionChangedDetails = folderOverviewDescriptionChangedDetails;
  }
  return self;
}

- (instancetype)initWithFolderOverviewItemPinnedDetails:
    (DBTEAMLOGFolderOverviewItemPinnedDetails *)folderOverviewItemPinnedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFolderOverviewItemPinnedDetails;
    _folderOverviewItemPinnedDetails = folderOverviewItemPinnedDetails;
  }
  return self;
}

- (instancetype)initWithFolderOverviewItemUnpinnedDetails:
    (DBTEAMLOGFolderOverviewItemUnpinnedDetails *)folderOverviewItemUnpinnedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFolderOverviewItemUnpinnedDetails;
    _folderOverviewItemUnpinnedDetails = folderOverviewItemUnpinnedDetails;
  }
  return self;
}

- (instancetype)initWithObjectLabelAddedDetails:(DBTEAMLOGObjectLabelAddedDetails *)objectLabelAddedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsObjectLabelAddedDetails;
    _objectLabelAddedDetails = objectLabelAddedDetails;
  }
  return self;
}

- (instancetype)initWithObjectLabelRemovedDetails:(DBTEAMLOGObjectLabelRemovedDetails *)objectLabelRemovedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsObjectLabelRemovedDetails;
    _objectLabelRemovedDetails = objectLabelRemovedDetails;
  }
  return self;
}

- (instancetype)initWithObjectLabelUpdatedValueDetails:
    (DBTEAMLOGObjectLabelUpdatedValueDetails *)objectLabelUpdatedValueDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsObjectLabelUpdatedValueDetails;
    _objectLabelUpdatedValueDetails = objectLabelUpdatedValueDetails;
  }
  return self;
}

- (instancetype)initWithRewindFolderDetails:(DBTEAMLOGRewindFolderDetails *)rewindFolderDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsRewindFolderDetails;
    _rewindFolderDetails = rewindFolderDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestChangeDetails:(DBTEAMLOGFileRequestChangeDetails *)fileRequestChangeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestChangeDetails;
    _fileRequestChangeDetails = fileRequestChangeDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestCloseDetails:(DBTEAMLOGFileRequestCloseDetails *)fileRequestCloseDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestCloseDetails;
    _fileRequestCloseDetails = fileRequestCloseDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestCreateDetails:(DBTEAMLOGFileRequestCreateDetails *)fileRequestCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestCreateDetails;
    _fileRequestCreateDetails = fileRequestCreateDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestDeleteDetails:(DBTEAMLOGFileRequestDeleteDetails *)fileRequestDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestDeleteDetails;
    _fileRequestDeleteDetails = fileRequestDeleteDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestReceiveFileDetails:
    (DBTEAMLOGFileRequestReceiveFileDetails *)fileRequestReceiveFileDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestReceiveFileDetails;
    _fileRequestReceiveFileDetails = fileRequestReceiveFileDetails;
  }
  return self;
}

- (instancetype)initWithGroupAddExternalIdDetails:(DBTEAMLOGGroupAddExternalIdDetails *)groupAddExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupAddExternalIdDetails;
    _groupAddExternalIdDetails = groupAddExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithGroupAddMemberDetails:(DBTEAMLOGGroupAddMemberDetails *)groupAddMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupAddMemberDetails;
    _groupAddMemberDetails = groupAddMemberDetails;
  }
  return self;
}

- (instancetype)initWithGroupChangeExternalIdDetails:
    (DBTEAMLOGGroupChangeExternalIdDetails *)groupChangeExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupChangeExternalIdDetails;
    _groupChangeExternalIdDetails = groupChangeExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithGroupChangeManagementTypeDetails:
    (DBTEAMLOGGroupChangeManagementTypeDetails *)groupChangeManagementTypeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupChangeManagementTypeDetails;
    _groupChangeManagementTypeDetails = groupChangeManagementTypeDetails;
  }
  return self;
}

- (instancetype)initWithGroupChangeMemberRoleDetails:
    (DBTEAMLOGGroupChangeMemberRoleDetails *)groupChangeMemberRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupChangeMemberRoleDetails;
    _groupChangeMemberRoleDetails = groupChangeMemberRoleDetails;
  }
  return self;
}

- (instancetype)initWithGroupCreateDetails:(DBTEAMLOGGroupCreateDetails *)groupCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupCreateDetails;
    _groupCreateDetails = groupCreateDetails;
  }
  return self;
}

- (instancetype)initWithGroupDeleteDetails:(DBTEAMLOGGroupDeleteDetails *)groupDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupDeleteDetails;
    _groupDeleteDetails = groupDeleteDetails;
  }
  return self;
}

- (instancetype)initWithGroupDescriptionUpdatedDetails:
    (DBTEAMLOGGroupDescriptionUpdatedDetails *)groupDescriptionUpdatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupDescriptionUpdatedDetails;
    _groupDescriptionUpdatedDetails = groupDescriptionUpdatedDetails;
  }
  return self;
}

- (instancetype)initWithGroupJoinPolicyUpdatedDetails:
    (DBTEAMLOGGroupJoinPolicyUpdatedDetails *)groupJoinPolicyUpdatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupJoinPolicyUpdatedDetails;
    _groupJoinPolicyUpdatedDetails = groupJoinPolicyUpdatedDetails;
  }
  return self;
}

- (instancetype)initWithGroupMovedDetails:(DBTEAMLOGGroupMovedDetails *)groupMovedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupMovedDetails;
    _groupMovedDetails = groupMovedDetails;
  }
  return self;
}

- (instancetype)initWithGroupRemoveExternalIdDetails:
    (DBTEAMLOGGroupRemoveExternalIdDetails *)groupRemoveExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupRemoveExternalIdDetails;
    _groupRemoveExternalIdDetails = groupRemoveExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithGroupRemoveMemberDetails:(DBTEAMLOGGroupRemoveMemberDetails *)groupRemoveMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupRemoveMemberDetails;
    _groupRemoveMemberDetails = groupRemoveMemberDetails;
  }
  return self;
}

- (instancetype)initWithGroupRenameDetails:(DBTEAMLOGGroupRenameDetails *)groupRenameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupRenameDetails;
    _groupRenameDetails = groupRenameDetails;
  }
  return self;
}

- (instancetype)initWithAccountLockOrUnlockedDetails:
    (DBTEAMLOGAccountLockOrUnlockedDetails *)accountLockOrUnlockedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountLockOrUnlockedDetails;
    _accountLockOrUnlockedDetails = accountLockOrUnlockedDetails;
  }
  return self;
}

- (instancetype)initWithEmmErrorDetails:(DBTEAMLOGEmmErrorDetails *)emmErrorDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmErrorDetails;
    _emmErrorDetails = emmErrorDetails;
  }
  return self;
}

- (instancetype)initWithGuestAdminSignedInViaTrustedTeamsDetails:
    (DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails *)guestAdminSignedInViaTrustedTeamsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGuestAdminSignedInViaTrustedTeamsDetails;
    _guestAdminSignedInViaTrustedTeamsDetails = guestAdminSignedInViaTrustedTeamsDetails;
  }
  return self;
}

- (instancetype)initWithGuestAdminSignedOutViaTrustedTeamsDetails:
    (DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails *)guestAdminSignedOutViaTrustedTeamsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGuestAdminSignedOutViaTrustedTeamsDetails;
    _guestAdminSignedOutViaTrustedTeamsDetails = guestAdminSignedOutViaTrustedTeamsDetails;
  }
  return self;
}

- (instancetype)initWithLoginFailDetails:(DBTEAMLOGLoginFailDetails *)loginFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLoginFailDetails;
    _loginFailDetails = loginFailDetails;
  }
  return self;
}

- (instancetype)initWithLoginSuccessDetails:(DBTEAMLOGLoginSuccessDetails *)loginSuccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLoginSuccessDetails;
    _loginSuccessDetails = loginSuccessDetails;
  }
  return self;
}

- (instancetype)initWithLogoutDetails:(DBTEAMLOGLogoutDetails *)logoutDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsLogoutDetails;
    _logoutDetails = logoutDetails;
  }
  return self;
}

- (instancetype)initWithResellerSupportSessionEndDetails:
    (DBTEAMLOGResellerSupportSessionEndDetails *)resellerSupportSessionEndDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsResellerSupportSessionEndDetails;
    _resellerSupportSessionEndDetails = resellerSupportSessionEndDetails;
  }
  return self;
}

- (instancetype)initWithResellerSupportSessionStartDetails:
    (DBTEAMLOGResellerSupportSessionStartDetails *)resellerSupportSessionStartDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsResellerSupportSessionStartDetails;
    _resellerSupportSessionStartDetails = resellerSupportSessionStartDetails;
  }
  return self;
}

- (instancetype)initWithSignInAsSessionEndDetails:(DBTEAMLOGSignInAsSessionEndDetails *)signInAsSessionEndDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSignInAsSessionEndDetails;
    _signInAsSessionEndDetails = signInAsSessionEndDetails;
  }
  return self;
}

- (instancetype)initWithSignInAsSessionStartDetails:
    (DBTEAMLOGSignInAsSessionStartDetails *)signInAsSessionStartDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSignInAsSessionStartDetails;
    _signInAsSessionStartDetails = signInAsSessionStartDetails;
  }
  return self;
}

- (instancetype)initWithSsoErrorDetails:(DBTEAMLOGSsoErrorDetails *)ssoErrorDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoErrorDetails;
    _ssoErrorDetails = ssoErrorDetails;
  }
  return self;
}

- (instancetype)initWithCreateTeamInviteLinkDetails:
    (DBTEAMLOGCreateTeamInviteLinkDetails *)createTeamInviteLinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsCreateTeamInviteLinkDetails;
    _createTeamInviteLinkDetails = createTeamInviteLinkDetails;
  }
  return self;
}

- (instancetype)initWithDeleteTeamInviteLinkDetails:
    (DBTEAMLOGDeleteTeamInviteLinkDetails *)deleteTeamInviteLinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeleteTeamInviteLinkDetails;
    _deleteTeamInviteLinkDetails = deleteTeamInviteLinkDetails;
  }
  return self;
}

- (instancetype)initWithMemberAddExternalIdDetails:(DBTEAMLOGMemberAddExternalIdDetails *)memberAddExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberAddExternalIdDetails;
    _memberAddExternalIdDetails = memberAddExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithMemberAddNameDetails:(DBTEAMLOGMemberAddNameDetails *)memberAddNameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberAddNameDetails;
    _memberAddNameDetails = memberAddNameDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeAdminRoleDetails:
    (DBTEAMLOGMemberChangeAdminRoleDetails *)memberChangeAdminRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeAdminRoleDetails;
    _memberChangeAdminRoleDetails = memberChangeAdminRoleDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeEmailDetails:(DBTEAMLOGMemberChangeEmailDetails *)memberChangeEmailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeEmailDetails;
    _memberChangeEmailDetails = memberChangeEmailDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeExternalIdDetails:
    (DBTEAMLOGMemberChangeExternalIdDetails *)memberChangeExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeExternalIdDetails;
    _memberChangeExternalIdDetails = memberChangeExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeMembershipTypeDetails:
    (DBTEAMLOGMemberChangeMembershipTypeDetails *)memberChangeMembershipTypeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeMembershipTypeDetails;
    _memberChangeMembershipTypeDetails = memberChangeMembershipTypeDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeNameDetails:(DBTEAMLOGMemberChangeNameDetails *)memberChangeNameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeNameDetails;
    _memberChangeNameDetails = memberChangeNameDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeResellerRoleDetails:
    (DBTEAMLOGMemberChangeResellerRoleDetails *)memberChangeResellerRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeResellerRoleDetails;
    _memberChangeResellerRoleDetails = memberChangeResellerRoleDetails;
  }
  return self;
}

- (instancetype)initWithMemberChangeStatusDetails:(DBTEAMLOGMemberChangeStatusDetails *)memberChangeStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberChangeStatusDetails;
    _memberChangeStatusDetails = memberChangeStatusDetails;
  }
  return self;
}

- (instancetype)initWithMemberDeleteManualContactsDetails:
    (DBTEAMLOGMemberDeleteManualContactsDetails *)memberDeleteManualContactsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberDeleteManualContactsDetails;
    _memberDeleteManualContactsDetails = memberDeleteManualContactsDetails;
  }
  return self;
}

- (instancetype)initWithMemberDeleteProfilePhotoDetails:
    (DBTEAMLOGMemberDeleteProfilePhotoDetails *)memberDeleteProfilePhotoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberDeleteProfilePhotoDetails;
    _memberDeleteProfilePhotoDetails = memberDeleteProfilePhotoDetails;
  }
  return self;
}

- (instancetype)initWithMemberPermanentlyDeleteAccountContentsDetails:
    (DBTEAMLOGMemberPermanentlyDeleteAccountContentsDetails *)memberPermanentlyDeleteAccountContentsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberPermanentlyDeleteAccountContentsDetails;
    _memberPermanentlyDeleteAccountContentsDetails = memberPermanentlyDeleteAccountContentsDetails;
  }
  return self;
}

- (instancetype)initWithMemberRemoveExternalIdDetails:
    (DBTEAMLOGMemberRemoveExternalIdDetails *)memberRemoveExternalIdDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberRemoveExternalIdDetails;
    _memberRemoveExternalIdDetails = memberRemoveExternalIdDetails;
  }
  return self;
}

- (instancetype)initWithMemberSetProfilePhotoDetails:
    (DBTEAMLOGMemberSetProfilePhotoDetails *)memberSetProfilePhotoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSetProfilePhotoDetails;
    _memberSetProfilePhotoDetails = memberSetProfilePhotoDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsAddCustomQuotaDetails:
    (DBTEAMLOGMemberSpaceLimitsAddCustomQuotaDetails *)memberSpaceLimitsAddCustomQuotaDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsAddCustomQuotaDetails;
    _memberSpaceLimitsAddCustomQuotaDetails = memberSpaceLimitsAddCustomQuotaDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsChangeCustomQuotaDetails:
    (DBTEAMLOGMemberSpaceLimitsChangeCustomQuotaDetails *)memberSpaceLimitsChangeCustomQuotaDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsChangeCustomQuotaDetails;
    _memberSpaceLimitsChangeCustomQuotaDetails = memberSpaceLimitsChangeCustomQuotaDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsChangeStatusDetails:
    (DBTEAMLOGMemberSpaceLimitsChangeStatusDetails *)memberSpaceLimitsChangeStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsChangeStatusDetails;
    _memberSpaceLimitsChangeStatusDetails = memberSpaceLimitsChangeStatusDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsRemoveCustomQuotaDetails:
    (DBTEAMLOGMemberSpaceLimitsRemoveCustomQuotaDetails *)memberSpaceLimitsRemoveCustomQuotaDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsRemoveCustomQuotaDetails;
    _memberSpaceLimitsRemoveCustomQuotaDetails = memberSpaceLimitsRemoveCustomQuotaDetails;
  }
  return self;
}

- (instancetype)initWithMemberSuggestDetails:(DBTEAMLOGMemberSuggestDetails *)memberSuggestDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSuggestDetails;
    _memberSuggestDetails = memberSuggestDetails;
  }
  return self;
}

- (instancetype)initWithMemberTransferAccountContentsDetails:
    (DBTEAMLOGMemberTransferAccountContentsDetails *)memberTransferAccountContentsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberTransferAccountContentsDetails;
    _memberTransferAccountContentsDetails = memberTransferAccountContentsDetails;
  }
  return self;
}

- (instancetype)initWithPendingSecondaryEmailAddedDetails:
    (DBTEAMLOGPendingSecondaryEmailAddedDetails *)pendingSecondaryEmailAddedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPendingSecondaryEmailAddedDetails;
    _pendingSecondaryEmailAddedDetails = pendingSecondaryEmailAddedDetails;
  }
  return self;
}

- (instancetype)initWithSecondaryEmailDeletedDetails:
    (DBTEAMLOGSecondaryEmailDeletedDetails *)secondaryEmailDeletedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSecondaryEmailDeletedDetails;
    _secondaryEmailDeletedDetails = secondaryEmailDeletedDetails;
  }
  return self;
}

- (instancetype)initWithSecondaryEmailVerifiedDetails:
    (DBTEAMLOGSecondaryEmailVerifiedDetails *)secondaryEmailVerifiedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSecondaryEmailVerifiedDetails;
    _secondaryEmailVerifiedDetails = secondaryEmailVerifiedDetails;
  }
  return self;
}

- (instancetype)initWithSecondaryMailsPolicyChangedDetails:
    (DBTEAMLOGSecondaryMailsPolicyChangedDetails *)secondaryMailsPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSecondaryMailsPolicyChangedDetails;
    _secondaryMailsPolicyChangedDetails = secondaryMailsPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithBinderAddPageDetails:(DBTEAMLOGBinderAddPageDetails *)binderAddPageDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderAddPageDetails;
    _binderAddPageDetails = binderAddPageDetails;
  }
  return self;
}

- (instancetype)initWithBinderAddSectionDetails:(DBTEAMLOGBinderAddSectionDetails *)binderAddSectionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderAddSectionDetails;
    _binderAddSectionDetails = binderAddSectionDetails;
  }
  return self;
}

- (instancetype)initWithBinderRemovePageDetails:(DBTEAMLOGBinderRemovePageDetails *)binderRemovePageDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderRemovePageDetails;
    _binderRemovePageDetails = binderRemovePageDetails;
  }
  return self;
}

- (instancetype)initWithBinderRemoveSectionDetails:(DBTEAMLOGBinderRemoveSectionDetails *)binderRemoveSectionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderRemoveSectionDetails;
    _binderRemoveSectionDetails = binderRemoveSectionDetails;
  }
  return self;
}

- (instancetype)initWithBinderRenamePageDetails:(DBTEAMLOGBinderRenamePageDetails *)binderRenamePageDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderRenamePageDetails;
    _binderRenamePageDetails = binderRenamePageDetails;
  }
  return self;
}

- (instancetype)initWithBinderRenameSectionDetails:(DBTEAMLOGBinderRenameSectionDetails *)binderRenameSectionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderRenameSectionDetails;
    _binderRenameSectionDetails = binderRenameSectionDetails;
  }
  return self;
}

- (instancetype)initWithBinderReorderPageDetails:(DBTEAMLOGBinderReorderPageDetails *)binderReorderPageDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderReorderPageDetails;
    _binderReorderPageDetails = binderReorderPageDetails;
  }
  return self;
}

- (instancetype)initWithBinderReorderSectionDetails:
    (DBTEAMLOGBinderReorderSectionDetails *)binderReorderSectionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsBinderReorderSectionDetails;
    _binderReorderSectionDetails = binderReorderSectionDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentAddMemberDetails:
    (DBTEAMLOGPaperContentAddMemberDetails *)paperContentAddMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentAddMemberDetails;
    _paperContentAddMemberDetails = paperContentAddMemberDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentAddToFolderDetails:
    (DBTEAMLOGPaperContentAddToFolderDetails *)paperContentAddToFolderDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentAddToFolderDetails;
    _paperContentAddToFolderDetails = paperContentAddToFolderDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentArchiveDetails:(DBTEAMLOGPaperContentArchiveDetails *)paperContentArchiveDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentArchiveDetails;
    _paperContentArchiveDetails = paperContentArchiveDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentCreateDetails:(DBTEAMLOGPaperContentCreateDetails *)paperContentCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentCreateDetails;
    _paperContentCreateDetails = paperContentCreateDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentPermanentlyDeleteDetails:
    (DBTEAMLOGPaperContentPermanentlyDeleteDetails *)paperContentPermanentlyDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentPermanentlyDeleteDetails;
    _paperContentPermanentlyDeleteDetails = paperContentPermanentlyDeleteDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentRemoveFromFolderDetails:
    (DBTEAMLOGPaperContentRemoveFromFolderDetails *)paperContentRemoveFromFolderDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentRemoveFromFolderDetails;
    _paperContentRemoveFromFolderDetails = paperContentRemoveFromFolderDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentRemoveMemberDetails:
    (DBTEAMLOGPaperContentRemoveMemberDetails *)paperContentRemoveMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentRemoveMemberDetails;
    _paperContentRemoveMemberDetails = paperContentRemoveMemberDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentRenameDetails:(DBTEAMLOGPaperContentRenameDetails *)paperContentRenameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentRenameDetails;
    _paperContentRenameDetails = paperContentRenameDetails;
  }
  return self;
}

- (instancetype)initWithPaperContentRestoreDetails:(DBTEAMLOGPaperContentRestoreDetails *)paperContentRestoreDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperContentRestoreDetails;
    _paperContentRestoreDetails = paperContentRestoreDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocAddCommentDetails:(DBTEAMLOGPaperDocAddCommentDetails *)paperDocAddCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocAddCommentDetails;
    _paperDocAddCommentDetails = paperDocAddCommentDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocChangeMemberRoleDetails:
    (DBTEAMLOGPaperDocChangeMemberRoleDetails *)paperDocChangeMemberRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocChangeMemberRoleDetails;
    _paperDocChangeMemberRoleDetails = paperDocChangeMemberRoleDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocChangeSharingPolicyDetails:
    (DBTEAMLOGPaperDocChangeSharingPolicyDetails *)paperDocChangeSharingPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocChangeSharingPolicyDetails;
    _paperDocChangeSharingPolicyDetails = paperDocChangeSharingPolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocChangeSubscriptionDetails:
    (DBTEAMLOGPaperDocChangeSubscriptionDetails *)paperDocChangeSubscriptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocChangeSubscriptionDetails;
    _paperDocChangeSubscriptionDetails = paperDocChangeSubscriptionDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocDeletedDetails:(DBTEAMLOGPaperDocDeletedDetails *)paperDocDeletedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocDeletedDetails;
    _paperDocDeletedDetails = paperDocDeletedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocDeleteCommentDetails:
    (DBTEAMLOGPaperDocDeleteCommentDetails *)paperDocDeleteCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocDeleteCommentDetails;
    _paperDocDeleteCommentDetails = paperDocDeleteCommentDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocDownloadDetails:(DBTEAMLOGPaperDocDownloadDetails *)paperDocDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocDownloadDetails;
    _paperDocDownloadDetails = paperDocDownloadDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocEditDetails:(DBTEAMLOGPaperDocEditDetails *)paperDocEditDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocEditDetails;
    _paperDocEditDetails = paperDocEditDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocEditCommentDetails:(DBTEAMLOGPaperDocEditCommentDetails *)paperDocEditCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocEditCommentDetails;
    _paperDocEditCommentDetails = paperDocEditCommentDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocFollowedDetails:(DBTEAMLOGPaperDocFollowedDetails *)paperDocFollowedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocFollowedDetails;
    _paperDocFollowedDetails = paperDocFollowedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocMentionDetails:(DBTEAMLOGPaperDocMentionDetails *)paperDocMentionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocMentionDetails;
    _paperDocMentionDetails = paperDocMentionDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocOwnershipChangedDetails:
    (DBTEAMLOGPaperDocOwnershipChangedDetails *)paperDocOwnershipChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocOwnershipChangedDetails;
    _paperDocOwnershipChangedDetails = paperDocOwnershipChangedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocRequestAccessDetails:
    (DBTEAMLOGPaperDocRequestAccessDetails *)paperDocRequestAccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocRequestAccessDetails;
    _paperDocRequestAccessDetails = paperDocRequestAccessDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocResolveCommentDetails:
    (DBTEAMLOGPaperDocResolveCommentDetails *)paperDocResolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocResolveCommentDetails;
    _paperDocResolveCommentDetails = paperDocResolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocRevertDetails:(DBTEAMLOGPaperDocRevertDetails *)paperDocRevertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocRevertDetails;
    _paperDocRevertDetails = paperDocRevertDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocSlackShareDetails:(DBTEAMLOGPaperDocSlackShareDetails *)paperDocSlackShareDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocSlackShareDetails;
    _paperDocSlackShareDetails = paperDocSlackShareDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocTeamInviteDetails:(DBTEAMLOGPaperDocTeamInviteDetails *)paperDocTeamInviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocTeamInviteDetails;
    _paperDocTeamInviteDetails = paperDocTeamInviteDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocTrashedDetails:(DBTEAMLOGPaperDocTrashedDetails *)paperDocTrashedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocTrashedDetails;
    _paperDocTrashedDetails = paperDocTrashedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocUnresolveCommentDetails:
    (DBTEAMLOGPaperDocUnresolveCommentDetails *)paperDocUnresolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocUnresolveCommentDetails;
    _paperDocUnresolveCommentDetails = paperDocUnresolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocUntrashedDetails:(DBTEAMLOGPaperDocUntrashedDetails *)paperDocUntrashedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocUntrashedDetails;
    _paperDocUntrashedDetails = paperDocUntrashedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDocViewDetails:(DBTEAMLOGPaperDocViewDetails *)paperDocViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDocViewDetails;
    _paperDocViewDetails = paperDocViewDetails;
  }
  return self;
}

- (instancetype)initWithPaperExternalViewAllowDetails:
    (DBTEAMLOGPaperExternalViewAllowDetails *)paperExternalViewAllowDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperExternalViewAllowDetails;
    _paperExternalViewAllowDetails = paperExternalViewAllowDetails;
  }
  return self;
}

- (instancetype)initWithPaperExternalViewDefaultTeamDetails:
    (DBTEAMLOGPaperExternalViewDefaultTeamDetails *)paperExternalViewDefaultTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperExternalViewDefaultTeamDetails;
    _paperExternalViewDefaultTeamDetails = paperExternalViewDefaultTeamDetails;
  }
  return self;
}

- (instancetype)initWithPaperExternalViewForbidDetails:
    (DBTEAMLOGPaperExternalViewForbidDetails *)paperExternalViewForbidDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperExternalViewForbidDetails;
    _paperExternalViewForbidDetails = paperExternalViewForbidDetails;
  }
  return self;
}

- (instancetype)initWithPaperFolderChangeSubscriptionDetails:
    (DBTEAMLOGPaperFolderChangeSubscriptionDetails *)paperFolderChangeSubscriptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperFolderChangeSubscriptionDetails;
    _paperFolderChangeSubscriptionDetails = paperFolderChangeSubscriptionDetails;
  }
  return self;
}

- (instancetype)initWithPaperFolderDeletedDetails:(DBTEAMLOGPaperFolderDeletedDetails *)paperFolderDeletedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperFolderDeletedDetails;
    _paperFolderDeletedDetails = paperFolderDeletedDetails;
  }
  return self;
}

- (instancetype)initWithPaperFolderFollowedDetails:(DBTEAMLOGPaperFolderFollowedDetails *)paperFolderFollowedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperFolderFollowedDetails;
    _paperFolderFollowedDetails = paperFolderFollowedDetails;
  }
  return self;
}

- (instancetype)initWithPaperFolderTeamInviteDetails:
    (DBTEAMLOGPaperFolderTeamInviteDetails *)paperFolderTeamInviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperFolderTeamInviteDetails;
    _paperFolderTeamInviteDetails = paperFolderTeamInviteDetails;
  }
  return self;
}

- (instancetype)initWithPaperPublishedLinkChangePermissionDetails:
    (DBTEAMLOGPaperPublishedLinkChangePermissionDetails *)paperPublishedLinkChangePermissionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperPublishedLinkChangePermissionDetails;
    _paperPublishedLinkChangePermissionDetails = paperPublishedLinkChangePermissionDetails;
  }
  return self;
}

- (instancetype)initWithPaperPublishedLinkCreateDetails:
    (DBTEAMLOGPaperPublishedLinkCreateDetails *)paperPublishedLinkCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperPublishedLinkCreateDetails;
    _paperPublishedLinkCreateDetails = paperPublishedLinkCreateDetails;
  }
  return self;
}

- (instancetype)initWithPaperPublishedLinkDisabledDetails:
    (DBTEAMLOGPaperPublishedLinkDisabledDetails *)paperPublishedLinkDisabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperPublishedLinkDisabledDetails;
    _paperPublishedLinkDisabledDetails = paperPublishedLinkDisabledDetails;
  }
  return self;
}

- (instancetype)initWithPaperPublishedLinkViewDetails:
    (DBTEAMLOGPaperPublishedLinkViewDetails *)paperPublishedLinkViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperPublishedLinkViewDetails;
    _paperPublishedLinkViewDetails = paperPublishedLinkViewDetails;
  }
  return self;
}

- (instancetype)initWithPasswordChangeDetails:(DBTEAMLOGPasswordChangeDetails *)passwordChangeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPasswordChangeDetails;
    _passwordChangeDetails = passwordChangeDetails;
  }
  return self;
}

- (instancetype)initWithPasswordResetDetails:(DBTEAMLOGPasswordResetDetails *)passwordResetDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPasswordResetDetails;
    _passwordResetDetails = passwordResetDetails;
  }
  return self;
}

- (instancetype)initWithPasswordResetAllDetails:(DBTEAMLOGPasswordResetAllDetails *)passwordResetAllDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPasswordResetAllDetails;
    _passwordResetAllDetails = passwordResetAllDetails;
  }
  return self;
}

- (instancetype)initWithClassificationCreateReportDetails:
    (DBTEAMLOGClassificationCreateReportDetails *)classificationCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsClassificationCreateReportDetails;
    _classificationCreateReportDetails = classificationCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithClassificationCreateReportFailDetails:
    (DBTEAMLOGClassificationCreateReportFailDetails *)classificationCreateReportFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsClassificationCreateReportFailDetails;
    _classificationCreateReportFailDetails = classificationCreateReportFailDetails;
  }
  return self;
}

- (instancetype)initWithEmmCreateExceptionsReportDetails:
    (DBTEAMLOGEmmCreateExceptionsReportDetails *)emmCreateExceptionsReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmCreateExceptionsReportDetails;
    _emmCreateExceptionsReportDetails = emmCreateExceptionsReportDetails;
  }
  return self;
}

- (instancetype)initWithEmmCreateUsageReportDetails:
    (DBTEAMLOGEmmCreateUsageReportDetails *)emmCreateUsageReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmCreateUsageReportDetails;
    _emmCreateUsageReportDetails = emmCreateUsageReportDetails;
  }
  return self;
}

- (instancetype)initWithExportMembersReportDetails:(DBTEAMLOGExportMembersReportDetails *)exportMembersReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsExportMembersReportDetails;
    _exportMembersReportDetails = exportMembersReportDetails;
  }
  return self;
}

- (instancetype)initWithExportMembersReportFailDetails:
    (DBTEAMLOGExportMembersReportFailDetails *)exportMembersReportFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsExportMembersReportFailDetails;
    _exportMembersReportFailDetails = exportMembersReportFailDetails;
  }
  return self;
}

- (instancetype)initWithExternalSharingCreateReportDetails:
    (DBTEAMLOGExternalSharingCreateReportDetails *)externalSharingCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsExternalSharingCreateReportDetails;
    _externalSharingCreateReportDetails = externalSharingCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithExternalSharingReportFailedDetails:
    (DBTEAMLOGExternalSharingReportFailedDetails *)externalSharingReportFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsExternalSharingReportFailedDetails;
    _externalSharingReportFailedDetails = externalSharingReportFailedDetails;
  }
  return self;
}

- (instancetype)initWithNoExpirationLinkGenCreateReportDetails:
    (DBTEAMLOGNoExpirationLinkGenCreateReportDetails *)noExpirationLinkGenCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoExpirationLinkGenCreateReportDetails;
    _noExpirationLinkGenCreateReportDetails = noExpirationLinkGenCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithNoExpirationLinkGenReportFailedDetails:
    (DBTEAMLOGNoExpirationLinkGenReportFailedDetails *)noExpirationLinkGenReportFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoExpirationLinkGenReportFailedDetails;
    _noExpirationLinkGenReportFailedDetails = noExpirationLinkGenReportFailedDetails;
  }
  return self;
}

- (instancetype)initWithNoPasswordLinkGenCreateReportDetails:
    (DBTEAMLOGNoPasswordLinkGenCreateReportDetails *)noPasswordLinkGenCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoPasswordLinkGenCreateReportDetails;
    _noPasswordLinkGenCreateReportDetails = noPasswordLinkGenCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithNoPasswordLinkGenReportFailedDetails:
    (DBTEAMLOGNoPasswordLinkGenReportFailedDetails *)noPasswordLinkGenReportFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoPasswordLinkGenReportFailedDetails;
    _noPasswordLinkGenReportFailedDetails = noPasswordLinkGenReportFailedDetails;
  }
  return self;
}

- (instancetype)initWithNoPasswordLinkViewCreateReportDetails:
    (DBTEAMLOGNoPasswordLinkViewCreateReportDetails *)noPasswordLinkViewCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoPasswordLinkViewCreateReportDetails;
    _noPasswordLinkViewCreateReportDetails = noPasswordLinkViewCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithNoPasswordLinkViewReportFailedDetails:
    (DBTEAMLOGNoPasswordLinkViewReportFailedDetails *)noPasswordLinkViewReportFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoPasswordLinkViewReportFailedDetails;
    _noPasswordLinkViewReportFailedDetails = noPasswordLinkViewReportFailedDetails;
  }
  return self;
}

- (instancetype)initWithOutdatedLinkViewCreateReportDetails:
    (DBTEAMLOGOutdatedLinkViewCreateReportDetails *)outdatedLinkViewCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsOutdatedLinkViewCreateReportDetails;
    _outdatedLinkViewCreateReportDetails = outdatedLinkViewCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithOutdatedLinkViewReportFailedDetails:
    (DBTEAMLOGOutdatedLinkViewReportFailedDetails *)outdatedLinkViewReportFailedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsOutdatedLinkViewReportFailedDetails;
    _outdatedLinkViewReportFailedDetails = outdatedLinkViewReportFailedDetails;
  }
  return self;
}

- (instancetype)initWithPaperAdminExportStartDetails:
    (DBTEAMLOGPaperAdminExportStartDetails *)paperAdminExportStartDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperAdminExportStartDetails;
    _paperAdminExportStartDetails = paperAdminExportStartDetails;
  }
  return self;
}

- (instancetype)initWithSmartSyncCreateAdminPrivilegeReportDetails:
    (DBTEAMLOGSmartSyncCreateAdminPrivilegeReportDetails *)smartSyncCreateAdminPrivilegeReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSmartSyncCreateAdminPrivilegeReportDetails;
    _smartSyncCreateAdminPrivilegeReportDetails = smartSyncCreateAdminPrivilegeReportDetails;
  }
  return self;
}

- (instancetype)initWithTeamActivityCreateReportDetails:
    (DBTEAMLOGTeamActivityCreateReportDetails *)teamActivityCreateReportDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamActivityCreateReportDetails;
    _teamActivityCreateReportDetails = teamActivityCreateReportDetails;
  }
  return self;
}

- (instancetype)initWithTeamActivityCreateReportFailDetails:
    (DBTEAMLOGTeamActivityCreateReportFailDetails *)teamActivityCreateReportFailDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamActivityCreateReportFailDetails;
    _teamActivityCreateReportFailDetails = teamActivityCreateReportFailDetails;
  }
  return self;
}

- (instancetype)initWithCollectionShareDetails:(DBTEAMLOGCollectionShareDetails *)collectionShareDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsCollectionShareDetails;
    _collectionShareDetails = collectionShareDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersFileAddDetails:
    (DBTEAMLOGFileTransfersFileAddDetails *)fileTransfersFileAddDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersFileAddDetails;
    _fileTransfersFileAddDetails = fileTransfersFileAddDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersTransferDeleteDetails:
    (DBTEAMLOGFileTransfersTransferDeleteDetails *)fileTransfersTransferDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersTransferDeleteDetails;
    _fileTransfersTransferDeleteDetails = fileTransfersTransferDeleteDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersTransferDownloadDetails:
    (DBTEAMLOGFileTransfersTransferDownloadDetails *)fileTransfersTransferDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersTransferDownloadDetails;
    _fileTransfersTransferDownloadDetails = fileTransfersTransferDownloadDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersTransferSendDetails:
    (DBTEAMLOGFileTransfersTransferSendDetails *)fileTransfersTransferSendDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersTransferSendDetails;
    _fileTransfersTransferSendDetails = fileTransfersTransferSendDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersTransferViewDetails:
    (DBTEAMLOGFileTransfersTransferViewDetails *)fileTransfersTransferViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersTransferViewDetails;
    _fileTransfersTransferViewDetails = fileTransfersTransferViewDetails;
  }
  return self;
}

- (instancetype)initWithNoteAclInviteOnlyDetails:(DBTEAMLOGNoteAclInviteOnlyDetails *)noteAclInviteOnlyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoteAclInviteOnlyDetails;
    _noteAclInviteOnlyDetails = noteAclInviteOnlyDetails;
  }
  return self;
}

- (instancetype)initWithNoteAclLinkDetails:(DBTEAMLOGNoteAclLinkDetails *)noteAclLinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoteAclLinkDetails;
    _noteAclLinkDetails = noteAclLinkDetails;
  }
  return self;
}

- (instancetype)initWithNoteAclTeamLinkDetails:(DBTEAMLOGNoteAclTeamLinkDetails *)noteAclTeamLinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoteAclTeamLinkDetails;
    _noteAclTeamLinkDetails = noteAclTeamLinkDetails;
  }
  return self;
}

- (instancetype)initWithNoteSharedDetails:(DBTEAMLOGNoteSharedDetails *)noteSharedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoteSharedDetails;
    _noteSharedDetails = noteSharedDetails;
  }
  return self;
}

- (instancetype)initWithNoteShareReceiveDetails:(DBTEAMLOGNoteShareReceiveDetails *)noteShareReceiveDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNoteShareReceiveDetails;
    _noteShareReceiveDetails = noteShareReceiveDetails;
  }
  return self;
}

- (instancetype)initWithOpenNoteSharedDetails:(DBTEAMLOGOpenNoteSharedDetails *)openNoteSharedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsOpenNoteSharedDetails;
    _openNoteSharedDetails = openNoteSharedDetails;
  }
  return self;
}

- (instancetype)initWithSfAddGroupDetails:(DBTEAMLOGSfAddGroupDetails *)sfAddGroupDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfAddGroupDetails;
    _sfAddGroupDetails = sfAddGroupDetails;
  }
  return self;
}

- (instancetype)initWithSfAllowNonMembersToViewSharedLinksDetails:
    (DBTEAMLOGSfAllowNonMembersToViewSharedLinksDetails *)sfAllowNonMembersToViewSharedLinksDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfAllowNonMembersToViewSharedLinksDetails;
    _sfAllowNonMembersToViewSharedLinksDetails = sfAllowNonMembersToViewSharedLinksDetails;
  }
  return self;
}

- (instancetype)initWithSfExternalInviteWarnDetails:
    (DBTEAMLOGSfExternalInviteWarnDetails *)sfExternalInviteWarnDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfExternalInviteWarnDetails;
    _sfExternalInviteWarnDetails = sfExternalInviteWarnDetails;
  }
  return self;
}

- (instancetype)initWithSfFbInviteDetails:(DBTEAMLOGSfFbInviteDetails *)sfFbInviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfFbInviteDetails;
    _sfFbInviteDetails = sfFbInviteDetails;
  }
  return self;
}

- (instancetype)initWithSfFbInviteChangeRoleDetails:
    (DBTEAMLOGSfFbInviteChangeRoleDetails *)sfFbInviteChangeRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfFbInviteChangeRoleDetails;
    _sfFbInviteChangeRoleDetails = sfFbInviteChangeRoleDetails;
  }
  return self;
}

- (instancetype)initWithSfFbUninviteDetails:(DBTEAMLOGSfFbUninviteDetails *)sfFbUninviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfFbUninviteDetails;
    _sfFbUninviteDetails = sfFbUninviteDetails;
  }
  return self;
}

- (instancetype)initWithSfInviteGroupDetails:(DBTEAMLOGSfInviteGroupDetails *)sfInviteGroupDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfInviteGroupDetails;
    _sfInviteGroupDetails = sfInviteGroupDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamGrantAccessDetails:(DBTEAMLOGSfTeamGrantAccessDetails *)sfTeamGrantAccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamGrantAccessDetails;
    _sfTeamGrantAccessDetails = sfTeamGrantAccessDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamInviteDetails:(DBTEAMLOGSfTeamInviteDetails *)sfTeamInviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamInviteDetails;
    _sfTeamInviteDetails = sfTeamInviteDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamInviteChangeRoleDetails:
    (DBTEAMLOGSfTeamInviteChangeRoleDetails *)sfTeamInviteChangeRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamInviteChangeRoleDetails;
    _sfTeamInviteChangeRoleDetails = sfTeamInviteChangeRoleDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamJoinDetails:(DBTEAMLOGSfTeamJoinDetails *)sfTeamJoinDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamJoinDetails;
    _sfTeamJoinDetails = sfTeamJoinDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamJoinFromOobLinkDetails:
    (DBTEAMLOGSfTeamJoinFromOobLinkDetails *)sfTeamJoinFromOobLinkDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamJoinFromOobLinkDetails;
    _sfTeamJoinFromOobLinkDetails = sfTeamJoinFromOobLinkDetails;
  }
  return self;
}

- (instancetype)initWithSfTeamUninviteDetails:(DBTEAMLOGSfTeamUninviteDetails *)sfTeamUninviteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSfTeamUninviteDetails;
    _sfTeamUninviteDetails = sfTeamUninviteDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentAddInviteesDetails:
    (DBTEAMLOGSharedContentAddInviteesDetails *)sharedContentAddInviteesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentAddInviteesDetails;
    _sharedContentAddInviteesDetails = sharedContentAddInviteesDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentAddLinkExpiryDetails:
    (DBTEAMLOGSharedContentAddLinkExpiryDetails *)sharedContentAddLinkExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentAddLinkExpiryDetails;
    _sharedContentAddLinkExpiryDetails = sharedContentAddLinkExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentAddLinkPasswordDetails:
    (DBTEAMLOGSharedContentAddLinkPasswordDetails *)sharedContentAddLinkPasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentAddLinkPasswordDetails;
    _sharedContentAddLinkPasswordDetails = sharedContentAddLinkPasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentAddMemberDetails:
    (DBTEAMLOGSharedContentAddMemberDetails *)sharedContentAddMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentAddMemberDetails;
    _sharedContentAddMemberDetails = sharedContentAddMemberDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeDownloadsPolicyDetails:
    (DBTEAMLOGSharedContentChangeDownloadsPolicyDetails *)sharedContentChangeDownloadsPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeDownloadsPolicyDetails;
    _sharedContentChangeDownloadsPolicyDetails = sharedContentChangeDownloadsPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeInviteeRoleDetails:
    (DBTEAMLOGSharedContentChangeInviteeRoleDetails *)sharedContentChangeInviteeRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeInviteeRoleDetails;
    _sharedContentChangeInviteeRoleDetails = sharedContentChangeInviteeRoleDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeLinkAudienceDetails:
    (DBTEAMLOGSharedContentChangeLinkAudienceDetails *)sharedContentChangeLinkAudienceDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeLinkAudienceDetails;
    _sharedContentChangeLinkAudienceDetails = sharedContentChangeLinkAudienceDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeLinkExpiryDetails:
    (DBTEAMLOGSharedContentChangeLinkExpiryDetails *)sharedContentChangeLinkExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeLinkExpiryDetails;
    _sharedContentChangeLinkExpiryDetails = sharedContentChangeLinkExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeLinkPasswordDetails:
    (DBTEAMLOGSharedContentChangeLinkPasswordDetails *)sharedContentChangeLinkPasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeLinkPasswordDetails;
    _sharedContentChangeLinkPasswordDetails = sharedContentChangeLinkPasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeMemberRoleDetails:
    (DBTEAMLOGSharedContentChangeMemberRoleDetails *)sharedContentChangeMemberRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeMemberRoleDetails;
    _sharedContentChangeMemberRoleDetails = sharedContentChangeMemberRoleDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentChangeViewerInfoPolicyDetails:
    (DBTEAMLOGSharedContentChangeViewerInfoPolicyDetails *)sharedContentChangeViewerInfoPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentChangeViewerInfoPolicyDetails;
    _sharedContentChangeViewerInfoPolicyDetails = sharedContentChangeViewerInfoPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentClaimInvitationDetails:
    (DBTEAMLOGSharedContentClaimInvitationDetails *)sharedContentClaimInvitationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentClaimInvitationDetails;
    _sharedContentClaimInvitationDetails = sharedContentClaimInvitationDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentCopyDetails:(DBTEAMLOGSharedContentCopyDetails *)sharedContentCopyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentCopyDetails;
    _sharedContentCopyDetails = sharedContentCopyDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentDownloadDetails:
    (DBTEAMLOGSharedContentDownloadDetails *)sharedContentDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentDownloadDetails;
    _sharedContentDownloadDetails = sharedContentDownloadDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRelinquishMembershipDetails:
    (DBTEAMLOGSharedContentRelinquishMembershipDetails *)sharedContentRelinquishMembershipDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRelinquishMembershipDetails;
    _sharedContentRelinquishMembershipDetails = sharedContentRelinquishMembershipDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRemoveInviteesDetails:
    (DBTEAMLOGSharedContentRemoveInviteesDetails *)sharedContentRemoveInviteesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRemoveInviteesDetails;
    _sharedContentRemoveInviteesDetails = sharedContentRemoveInviteesDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRemoveLinkExpiryDetails:
    (DBTEAMLOGSharedContentRemoveLinkExpiryDetails *)sharedContentRemoveLinkExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRemoveLinkExpiryDetails;
    _sharedContentRemoveLinkExpiryDetails = sharedContentRemoveLinkExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRemoveLinkPasswordDetails:
    (DBTEAMLOGSharedContentRemoveLinkPasswordDetails *)sharedContentRemoveLinkPasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRemoveLinkPasswordDetails;
    _sharedContentRemoveLinkPasswordDetails = sharedContentRemoveLinkPasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRemoveMemberDetails:
    (DBTEAMLOGSharedContentRemoveMemberDetails *)sharedContentRemoveMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRemoveMemberDetails;
    _sharedContentRemoveMemberDetails = sharedContentRemoveMemberDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRequestAccessDetails:
    (DBTEAMLOGSharedContentRequestAccessDetails *)sharedContentRequestAccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRequestAccessDetails;
    _sharedContentRequestAccessDetails = sharedContentRequestAccessDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRestoreInviteesDetails:
    (DBTEAMLOGSharedContentRestoreInviteesDetails *)sharedContentRestoreInviteesDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRestoreInviteesDetails;
    _sharedContentRestoreInviteesDetails = sharedContentRestoreInviteesDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentRestoreMemberDetails:
    (DBTEAMLOGSharedContentRestoreMemberDetails *)sharedContentRestoreMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentRestoreMemberDetails;
    _sharedContentRestoreMemberDetails = sharedContentRestoreMemberDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentUnshareDetails:
    (DBTEAMLOGSharedContentUnshareDetails *)sharedContentUnshareDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentUnshareDetails;
    _sharedContentUnshareDetails = sharedContentUnshareDetails;
  }
  return self;
}

- (instancetype)initWithSharedContentViewDetails:(DBTEAMLOGSharedContentViewDetails *)sharedContentViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedContentViewDetails;
    _sharedContentViewDetails = sharedContentViewDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderChangeLinkPolicyDetails:
    (DBTEAMLOGSharedFolderChangeLinkPolicyDetails *)sharedFolderChangeLinkPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderChangeLinkPolicyDetails;
    _sharedFolderChangeLinkPolicyDetails = sharedFolderChangeLinkPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderChangeMembersInheritancePolicyDetails:
    (DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails *)sharedFolderChangeMembersInheritancePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderChangeMembersInheritancePolicyDetails;
    _sharedFolderChangeMembersInheritancePolicyDetails = sharedFolderChangeMembersInheritancePolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderChangeMembersManagementPolicyDetails:
    (DBTEAMLOGSharedFolderChangeMembersManagementPolicyDetails *)sharedFolderChangeMembersManagementPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderChangeMembersManagementPolicyDetails;
    _sharedFolderChangeMembersManagementPolicyDetails = sharedFolderChangeMembersManagementPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderChangeMembersPolicyDetails:
    (DBTEAMLOGSharedFolderChangeMembersPolicyDetails *)sharedFolderChangeMembersPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderChangeMembersPolicyDetails;
    _sharedFolderChangeMembersPolicyDetails = sharedFolderChangeMembersPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderCreateDetails:(DBTEAMLOGSharedFolderCreateDetails *)sharedFolderCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderCreateDetails;
    _sharedFolderCreateDetails = sharedFolderCreateDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderDeclineInvitationDetails:
    (DBTEAMLOGSharedFolderDeclineInvitationDetails *)sharedFolderDeclineInvitationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderDeclineInvitationDetails;
    _sharedFolderDeclineInvitationDetails = sharedFolderDeclineInvitationDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderMountDetails:(DBTEAMLOGSharedFolderMountDetails *)sharedFolderMountDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderMountDetails;
    _sharedFolderMountDetails = sharedFolderMountDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderNestDetails:(DBTEAMLOGSharedFolderNestDetails *)sharedFolderNestDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderNestDetails;
    _sharedFolderNestDetails = sharedFolderNestDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderTransferOwnershipDetails:
    (DBTEAMLOGSharedFolderTransferOwnershipDetails *)sharedFolderTransferOwnershipDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderTransferOwnershipDetails;
    _sharedFolderTransferOwnershipDetails = sharedFolderTransferOwnershipDetails;
  }
  return self;
}

- (instancetype)initWithSharedFolderUnmountDetails:(DBTEAMLOGSharedFolderUnmountDetails *)sharedFolderUnmountDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedFolderUnmountDetails;
    _sharedFolderUnmountDetails = sharedFolderUnmountDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkAddExpiryDetails:(DBTEAMLOGSharedLinkAddExpiryDetails *)sharedLinkAddExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkAddExpiryDetails;
    _sharedLinkAddExpiryDetails = sharedLinkAddExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkChangeExpiryDetails:
    (DBTEAMLOGSharedLinkChangeExpiryDetails *)sharedLinkChangeExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkChangeExpiryDetails;
    _sharedLinkChangeExpiryDetails = sharedLinkChangeExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkChangeVisibilityDetails:
    (DBTEAMLOGSharedLinkChangeVisibilityDetails *)sharedLinkChangeVisibilityDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkChangeVisibilityDetails;
    _sharedLinkChangeVisibilityDetails = sharedLinkChangeVisibilityDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkCopyDetails:(DBTEAMLOGSharedLinkCopyDetails *)sharedLinkCopyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkCopyDetails;
    _sharedLinkCopyDetails = sharedLinkCopyDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkCreateDetails:(DBTEAMLOGSharedLinkCreateDetails *)sharedLinkCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkCreateDetails;
    _sharedLinkCreateDetails = sharedLinkCreateDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkDisableDetails:(DBTEAMLOGSharedLinkDisableDetails *)sharedLinkDisableDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkDisableDetails;
    _sharedLinkDisableDetails = sharedLinkDisableDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkDownloadDetails:(DBTEAMLOGSharedLinkDownloadDetails *)sharedLinkDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkDownloadDetails;
    _sharedLinkDownloadDetails = sharedLinkDownloadDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkRemoveExpiryDetails:
    (DBTEAMLOGSharedLinkRemoveExpiryDetails *)sharedLinkRemoveExpiryDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkRemoveExpiryDetails;
    _sharedLinkRemoveExpiryDetails = sharedLinkRemoveExpiryDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsAddExpirationDetails:
    (DBTEAMLOGSharedLinkSettingsAddExpirationDetails *)sharedLinkSettingsAddExpirationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsAddExpirationDetails;
    _sharedLinkSettingsAddExpirationDetails = sharedLinkSettingsAddExpirationDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsAddPasswordDetails:
    (DBTEAMLOGSharedLinkSettingsAddPasswordDetails *)sharedLinkSettingsAddPasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsAddPasswordDetails;
    _sharedLinkSettingsAddPasswordDetails = sharedLinkSettingsAddPasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsAllowDownloadDisabledDetails:
    (DBTEAMLOGSharedLinkSettingsAllowDownloadDisabledDetails *)sharedLinkSettingsAllowDownloadDisabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsAllowDownloadDisabledDetails;
    _sharedLinkSettingsAllowDownloadDisabledDetails = sharedLinkSettingsAllowDownloadDisabledDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsAllowDownloadEnabledDetails:
    (DBTEAMLOGSharedLinkSettingsAllowDownloadEnabledDetails *)sharedLinkSettingsAllowDownloadEnabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsAllowDownloadEnabledDetails;
    _sharedLinkSettingsAllowDownloadEnabledDetails = sharedLinkSettingsAllowDownloadEnabledDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsChangeAudienceDetails:
    (DBTEAMLOGSharedLinkSettingsChangeAudienceDetails *)sharedLinkSettingsChangeAudienceDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsChangeAudienceDetails;
    _sharedLinkSettingsChangeAudienceDetails = sharedLinkSettingsChangeAudienceDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsChangeExpirationDetails:
    (DBTEAMLOGSharedLinkSettingsChangeExpirationDetails *)sharedLinkSettingsChangeExpirationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsChangeExpirationDetails;
    _sharedLinkSettingsChangeExpirationDetails = sharedLinkSettingsChangeExpirationDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsChangePasswordDetails:
    (DBTEAMLOGSharedLinkSettingsChangePasswordDetails *)sharedLinkSettingsChangePasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsChangePasswordDetails;
    _sharedLinkSettingsChangePasswordDetails = sharedLinkSettingsChangePasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsRemoveExpirationDetails:
    (DBTEAMLOGSharedLinkSettingsRemoveExpirationDetails *)sharedLinkSettingsRemoveExpirationDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsRemoveExpirationDetails;
    _sharedLinkSettingsRemoveExpirationDetails = sharedLinkSettingsRemoveExpirationDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkSettingsRemovePasswordDetails:
    (DBTEAMLOGSharedLinkSettingsRemovePasswordDetails *)sharedLinkSettingsRemovePasswordDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkSettingsRemovePasswordDetails;
    _sharedLinkSettingsRemovePasswordDetails = sharedLinkSettingsRemovePasswordDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkShareDetails:(DBTEAMLOGSharedLinkShareDetails *)sharedLinkShareDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkShareDetails;
    _sharedLinkShareDetails = sharedLinkShareDetails;
  }
  return self;
}

- (instancetype)initWithSharedLinkViewDetails:(DBTEAMLOGSharedLinkViewDetails *)sharedLinkViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedLinkViewDetails;
    _sharedLinkViewDetails = sharedLinkViewDetails;
  }
  return self;
}

- (instancetype)initWithSharedNoteOpenedDetails:(DBTEAMLOGSharedNoteOpenedDetails *)sharedNoteOpenedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharedNoteOpenedDetails;
    _sharedNoteOpenedDetails = sharedNoteOpenedDetails;
  }
  return self;
}

- (instancetype)initWithShmodelDisableDownloadsDetails:
    (DBTEAMLOGShmodelDisableDownloadsDetails *)shmodelDisableDownloadsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShmodelDisableDownloadsDetails;
    _shmodelDisableDownloadsDetails = shmodelDisableDownloadsDetails;
  }
  return self;
}

- (instancetype)initWithShmodelEnableDownloadsDetails:
    (DBTEAMLOGShmodelEnableDownloadsDetails *)shmodelEnableDownloadsDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShmodelEnableDownloadsDetails;
    _shmodelEnableDownloadsDetails = shmodelEnableDownloadsDetails;
  }
  return self;
}

- (instancetype)initWithShmodelGroupShareDetails:(DBTEAMLOGShmodelGroupShareDetails *)shmodelGroupShareDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShmodelGroupShareDetails;
    _shmodelGroupShareDetails = shmodelGroupShareDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseAccessGrantedDetails:
    (DBTEAMLOGShowcaseAccessGrantedDetails *)showcaseAccessGrantedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseAccessGrantedDetails;
    _showcaseAccessGrantedDetails = showcaseAccessGrantedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseAddMemberDetails:(DBTEAMLOGShowcaseAddMemberDetails *)showcaseAddMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseAddMemberDetails;
    _showcaseAddMemberDetails = showcaseAddMemberDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseArchivedDetails:(DBTEAMLOGShowcaseArchivedDetails *)showcaseArchivedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseArchivedDetails;
    _showcaseArchivedDetails = showcaseArchivedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseCreatedDetails:(DBTEAMLOGShowcaseCreatedDetails *)showcaseCreatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseCreatedDetails;
    _showcaseCreatedDetails = showcaseCreatedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseDeleteCommentDetails:
    (DBTEAMLOGShowcaseDeleteCommentDetails *)showcaseDeleteCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseDeleteCommentDetails;
    _showcaseDeleteCommentDetails = showcaseDeleteCommentDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseEditedDetails:(DBTEAMLOGShowcaseEditedDetails *)showcaseEditedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseEditedDetails;
    _showcaseEditedDetails = showcaseEditedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseEditCommentDetails:(DBTEAMLOGShowcaseEditCommentDetails *)showcaseEditCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseEditCommentDetails;
    _showcaseEditCommentDetails = showcaseEditCommentDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseFileAddedDetails:(DBTEAMLOGShowcaseFileAddedDetails *)showcaseFileAddedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseFileAddedDetails;
    _showcaseFileAddedDetails = showcaseFileAddedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseFileDownloadDetails:
    (DBTEAMLOGShowcaseFileDownloadDetails *)showcaseFileDownloadDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseFileDownloadDetails;
    _showcaseFileDownloadDetails = showcaseFileDownloadDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseFileRemovedDetails:(DBTEAMLOGShowcaseFileRemovedDetails *)showcaseFileRemovedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseFileRemovedDetails;
    _showcaseFileRemovedDetails = showcaseFileRemovedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseFileViewDetails:(DBTEAMLOGShowcaseFileViewDetails *)showcaseFileViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseFileViewDetails;
    _showcaseFileViewDetails = showcaseFileViewDetails;
  }
  return self;
}

- (instancetype)initWithShowcasePermanentlyDeletedDetails:
    (DBTEAMLOGShowcasePermanentlyDeletedDetails *)showcasePermanentlyDeletedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcasePermanentlyDeletedDetails;
    _showcasePermanentlyDeletedDetails = showcasePermanentlyDeletedDetails;
  }
  return self;
}

- (instancetype)initWithShowcasePostCommentDetails:(DBTEAMLOGShowcasePostCommentDetails *)showcasePostCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcasePostCommentDetails;
    _showcasePostCommentDetails = showcasePostCommentDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseRemoveMemberDetails:
    (DBTEAMLOGShowcaseRemoveMemberDetails *)showcaseRemoveMemberDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseRemoveMemberDetails;
    _showcaseRemoveMemberDetails = showcaseRemoveMemberDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseRenamedDetails:(DBTEAMLOGShowcaseRenamedDetails *)showcaseRenamedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseRenamedDetails;
    _showcaseRenamedDetails = showcaseRenamedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseRequestAccessDetails:
    (DBTEAMLOGShowcaseRequestAccessDetails *)showcaseRequestAccessDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseRequestAccessDetails;
    _showcaseRequestAccessDetails = showcaseRequestAccessDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseResolveCommentDetails:
    (DBTEAMLOGShowcaseResolveCommentDetails *)showcaseResolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseResolveCommentDetails;
    _showcaseResolveCommentDetails = showcaseResolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseRestoredDetails:(DBTEAMLOGShowcaseRestoredDetails *)showcaseRestoredDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseRestoredDetails;
    _showcaseRestoredDetails = showcaseRestoredDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseTrashedDetails:(DBTEAMLOGShowcaseTrashedDetails *)showcaseTrashedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseTrashedDetails;
    _showcaseTrashedDetails = showcaseTrashedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseTrashedDeprecatedDetails:
    (DBTEAMLOGShowcaseTrashedDeprecatedDetails *)showcaseTrashedDeprecatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseTrashedDeprecatedDetails;
    _showcaseTrashedDeprecatedDetails = showcaseTrashedDeprecatedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseUnresolveCommentDetails:
    (DBTEAMLOGShowcaseUnresolveCommentDetails *)showcaseUnresolveCommentDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseUnresolveCommentDetails;
    _showcaseUnresolveCommentDetails = showcaseUnresolveCommentDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseUntrashedDetails:(DBTEAMLOGShowcaseUntrashedDetails *)showcaseUntrashedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseUntrashedDetails;
    _showcaseUntrashedDetails = showcaseUntrashedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseUntrashedDeprecatedDetails:
    (DBTEAMLOGShowcaseUntrashedDeprecatedDetails *)showcaseUntrashedDeprecatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseUntrashedDeprecatedDetails;
    _showcaseUntrashedDeprecatedDetails = showcaseUntrashedDeprecatedDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseViewDetails:(DBTEAMLOGShowcaseViewDetails *)showcaseViewDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseViewDetails;
    _showcaseViewDetails = showcaseViewDetails;
  }
  return self;
}

- (instancetype)initWithSsoAddCertDetails:(DBTEAMLOGSsoAddCertDetails *)ssoAddCertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoAddCertDetails;
    _ssoAddCertDetails = ssoAddCertDetails;
  }
  return self;
}

- (instancetype)initWithSsoAddLoginUrlDetails:(DBTEAMLOGSsoAddLoginUrlDetails *)ssoAddLoginUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoAddLoginUrlDetails;
    _ssoAddLoginUrlDetails = ssoAddLoginUrlDetails;
  }
  return self;
}

- (instancetype)initWithSsoAddLogoutUrlDetails:(DBTEAMLOGSsoAddLogoutUrlDetails *)ssoAddLogoutUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoAddLogoutUrlDetails;
    _ssoAddLogoutUrlDetails = ssoAddLogoutUrlDetails;
  }
  return self;
}

- (instancetype)initWithSsoChangeCertDetails:(DBTEAMLOGSsoChangeCertDetails *)ssoChangeCertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoChangeCertDetails;
    _ssoChangeCertDetails = ssoChangeCertDetails;
  }
  return self;
}

- (instancetype)initWithSsoChangeLoginUrlDetails:(DBTEAMLOGSsoChangeLoginUrlDetails *)ssoChangeLoginUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoChangeLoginUrlDetails;
    _ssoChangeLoginUrlDetails = ssoChangeLoginUrlDetails;
  }
  return self;
}

- (instancetype)initWithSsoChangeLogoutUrlDetails:(DBTEAMLOGSsoChangeLogoutUrlDetails *)ssoChangeLogoutUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoChangeLogoutUrlDetails;
    _ssoChangeLogoutUrlDetails = ssoChangeLogoutUrlDetails;
  }
  return self;
}

- (instancetype)initWithSsoChangeSamlIdentityModeDetails:
    (DBTEAMLOGSsoChangeSamlIdentityModeDetails *)ssoChangeSamlIdentityModeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoChangeSamlIdentityModeDetails;
    _ssoChangeSamlIdentityModeDetails = ssoChangeSamlIdentityModeDetails;
  }
  return self;
}

- (instancetype)initWithSsoRemoveCertDetails:(DBTEAMLOGSsoRemoveCertDetails *)ssoRemoveCertDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoRemoveCertDetails;
    _ssoRemoveCertDetails = ssoRemoveCertDetails;
  }
  return self;
}

- (instancetype)initWithSsoRemoveLoginUrlDetails:(DBTEAMLOGSsoRemoveLoginUrlDetails *)ssoRemoveLoginUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoRemoveLoginUrlDetails;
    _ssoRemoveLoginUrlDetails = ssoRemoveLoginUrlDetails;
  }
  return self;
}

- (instancetype)initWithSsoRemoveLogoutUrlDetails:(DBTEAMLOGSsoRemoveLogoutUrlDetails *)ssoRemoveLogoutUrlDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoRemoveLogoutUrlDetails;
    _ssoRemoveLogoutUrlDetails = ssoRemoveLogoutUrlDetails;
  }
  return self;
}

- (instancetype)initWithTeamFolderChangeStatusDetails:
    (DBTEAMLOGTeamFolderChangeStatusDetails *)teamFolderChangeStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamFolderChangeStatusDetails;
    _teamFolderChangeStatusDetails = teamFolderChangeStatusDetails;
  }
  return self;
}

- (instancetype)initWithTeamFolderCreateDetails:(DBTEAMLOGTeamFolderCreateDetails *)teamFolderCreateDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamFolderCreateDetails;
    _teamFolderCreateDetails = teamFolderCreateDetails;
  }
  return self;
}

- (instancetype)initWithTeamFolderDowngradeDetails:(DBTEAMLOGTeamFolderDowngradeDetails *)teamFolderDowngradeDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamFolderDowngradeDetails;
    _teamFolderDowngradeDetails = teamFolderDowngradeDetails;
  }
  return self;
}

- (instancetype)initWithTeamFolderPermanentlyDeleteDetails:
    (DBTEAMLOGTeamFolderPermanentlyDeleteDetails *)teamFolderPermanentlyDeleteDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamFolderPermanentlyDeleteDetails;
    _teamFolderPermanentlyDeleteDetails = teamFolderPermanentlyDeleteDetails;
  }
  return self;
}

- (instancetype)initWithTeamFolderRenameDetails:(DBTEAMLOGTeamFolderRenameDetails *)teamFolderRenameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamFolderRenameDetails;
    _teamFolderRenameDetails = teamFolderRenameDetails;
  }
  return self;
}

- (instancetype)initWithTeamSelectiveSyncSettingsChangedDetails:
    (DBTEAMLOGTeamSelectiveSyncSettingsChangedDetails *)teamSelectiveSyncSettingsChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamSelectiveSyncSettingsChangedDetails;
    _teamSelectiveSyncSettingsChangedDetails = teamSelectiveSyncSettingsChangedDetails;
  }
  return self;
}

- (instancetype)initWithAccountCaptureChangePolicyDetails:
    (DBTEAMLOGAccountCaptureChangePolicyDetails *)accountCaptureChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAccountCaptureChangePolicyDetails;
    _accountCaptureChangePolicyDetails = accountCaptureChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithAllowDownloadDisabledDetails:
    (DBTEAMLOGAllowDownloadDisabledDetails *)allowDownloadDisabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAllowDownloadDisabledDetails;
    _allowDownloadDisabledDetails = allowDownloadDisabledDetails;
  }
  return self;
}

- (instancetype)initWithAllowDownloadEnabledDetails:
    (DBTEAMLOGAllowDownloadEnabledDetails *)allowDownloadEnabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsAllowDownloadEnabledDetails;
    _allowDownloadEnabledDetails = allowDownloadEnabledDetails;
  }
  return self;
}

- (instancetype)initWithCameraUploadsPolicyChangedDetails:
    (DBTEAMLOGCameraUploadsPolicyChangedDetails *)cameraUploadsPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsCameraUploadsPolicyChangedDetails;
    _cameraUploadsPolicyChangedDetails = cameraUploadsPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithClassificationChangePolicyDetails:
    (DBTEAMLOGClassificationChangePolicyDetails *)classificationChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsClassificationChangePolicyDetails;
    _classificationChangePolicyDetails = classificationChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithComputerBackupPolicyChangedDetails:
    (DBTEAMLOGComputerBackupPolicyChangedDetails *)computerBackupPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsComputerBackupPolicyChangedDetails;
    _computerBackupPolicyChangedDetails = computerBackupPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithContentAdministrationPolicyChangedDetails:
    (DBTEAMLOGContentAdministrationPolicyChangedDetails *)contentAdministrationPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsContentAdministrationPolicyChangedDetails;
    _contentAdministrationPolicyChangedDetails = contentAdministrationPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithDataPlacementRestrictionChangePolicyDetails:
    (DBTEAMLOGDataPlacementRestrictionChangePolicyDetails *)dataPlacementRestrictionChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDataPlacementRestrictionChangePolicyDetails;
    _dataPlacementRestrictionChangePolicyDetails = dataPlacementRestrictionChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithDataPlacementRestrictionSatisfyPolicyDetails:
    (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails *)dataPlacementRestrictionSatisfyPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDataPlacementRestrictionSatisfyPolicyDetails;
    _dataPlacementRestrictionSatisfyPolicyDetails = dataPlacementRestrictionSatisfyPolicyDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsAddExceptionDetails:
    (DBTEAMLOGDeviceApprovalsAddExceptionDetails *)deviceApprovalsAddExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsAddExceptionDetails;
    _deviceApprovalsAddExceptionDetails = deviceApprovalsAddExceptionDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsChangeDesktopPolicyDetails:
    (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails *)deviceApprovalsChangeDesktopPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsChangeDesktopPolicyDetails;
    _deviceApprovalsChangeDesktopPolicyDetails = deviceApprovalsChangeDesktopPolicyDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsChangeMobilePolicyDetails:
    (DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)deviceApprovalsChangeMobilePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsChangeMobilePolicyDetails;
    _deviceApprovalsChangeMobilePolicyDetails = deviceApprovalsChangeMobilePolicyDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsChangeOverageActionDetails:
    (DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)deviceApprovalsChangeOverageActionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsChangeOverageActionDetails;
    _deviceApprovalsChangeOverageActionDetails = deviceApprovalsChangeOverageActionDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsChangeUnlinkActionDetails:
    (DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)deviceApprovalsChangeUnlinkActionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsChangeUnlinkActionDetails;
    _deviceApprovalsChangeUnlinkActionDetails = deviceApprovalsChangeUnlinkActionDetails;
  }
  return self;
}

- (instancetype)initWithDeviceApprovalsRemoveExceptionDetails:
    (DBTEAMLOGDeviceApprovalsRemoveExceptionDetails *)deviceApprovalsRemoveExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDeviceApprovalsRemoveExceptionDetails;
    _deviceApprovalsRemoveExceptionDetails = deviceApprovalsRemoveExceptionDetails;
  }
  return self;
}

- (instancetype)initWithDirectoryRestrictionsAddMembersDetails:
    (DBTEAMLOGDirectoryRestrictionsAddMembersDetails *)directoryRestrictionsAddMembersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDirectoryRestrictionsAddMembersDetails;
    _directoryRestrictionsAddMembersDetails = directoryRestrictionsAddMembersDetails;
  }
  return self;
}

- (instancetype)initWithDirectoryRestrictionsRemoveMembersDetails:
    (DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails *)directoryRestrictionsRemoveMembersDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsDirectoryRestrictionsRemoveMembersDetails;
    _directoryRestrictionsRemoveMembersDetails = directoryRestrictionsRemoveMembersDetails;
  }
  return self;
}

- (instancetype)initWithEmmAddExceptionDetails:(DBTEAMLOGEmmAddExceptionDetails *)emmAddExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmAddExceptionDetails;
    _emmAddExceptionDetails = emmAddExceptionDetails;
  }
  return self;
}

- (instancetype)initWithEmmChangePolicyDetails:(DBTEAMLOGEmmChangePolicyDetails *)emmChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmChangePolicyDetails;
    _emmChangePolicyDetails = emmChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithEmmRemoveExceptionDetails:(DBTEAMLOGEmmRemoveExceptionDetails *)emmRemoveExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEmmRemoveExceptionDetails;
    _emmRemoveExceptionDetails = emmRemoveExceptionDetails;
  }
  return self;
}

- (instancetype)initWithExtendedVersionHistoryChangePolicyDetails:
    (DBTEAMLOGExtendedVersionHistoryChangePolicyDetails *)extendedVersionHistoryChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsExtendedVersionHistoryChangePolicyDetails;
    _extendedVersionHistoryChangePolicyDetails = extendedVersionHistoryChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithFileCommentsChangePolicyDetails:
    (DBTEAMLOGFileCommentsChangePolicyDetails *)fileCommentsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileCommentsChangePolicyDetails;
    _fileCommentsChangePolicyDetails = fileCommentsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithFileLockingPolicyChangedDetails:
    (DBTEAMLOGFileLockingPolicyChangedDetails *)fileLockingPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileLockingPolicyChangedDetails;
    _fileLockingPolicyChangedDetails = fileLockingPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestsChangePolicyDetails:
    (DBTEAMLOGFileRequestsChangePolicyDetails *)fileRequestsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestsChangePolicyDetails;
    _fileRequestsChangePolicyDetails = fileRequestsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestsEmailsEnabledDetails:
    (DBTEAMLOGFileRequestsEmailsEnabledDetails *)fileRequestsEmailsEnabledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestsEmailsEnabledDetails;
    _fileRequestsEmailsEnabledDetails = fileRequestsEmailsEnabledDetails;
  }
  return self;
}

- (instancetype)initWithFileRequestsEmailsRestrictedToTeamOnlyDetails:
    (DBTEAMLOGFileRequestsEmailsRestrictedToTeamOnlyDetails *)fileRequestsEmailsRestrictedToTeamOnlyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileRequestsEmailsRestrictedToTeamOnlyDetails;
    _fileRequestsEmailsRestrictedToTeamOnlyDetails = fileRequestsEmailsRestrictedToTeamOnlyDetails;
  }
  return self;
}

- (instancetype)initWithFileTransfersPolicyChangedDetails:
    (DBTEAMLOGFileTransfersPolicyChangedDetails *)fileTransfersPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsFileTransfersPolicyChangedDetails;
    _fileTransfersPolicyChangedDetails = fileTransfersPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithGoogleSsoChangePolicyDetails:
    (DBTEAMLOGGoogleSsoChangePolicyDetails *)googleSsoChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGoogleSsoChangePolicyDetails;
    _googleSsoChangePolicyDetails = googleSsoChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithGroupUserManagementChangePolicyDetails:
    (DBTEAMLOGGroupUserManagementChangePolicyDetails *)groupUserManagementChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGroupUserManagementChangePolicyDetails;
    _groupUserManagementChangePolicyDetails = groupUserManagementChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithIntegrationPolicyChangedDetails:
    (DBTEAMLOGIntegrationPolicyChangedDetails *)integrationPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsIntegrationPolicyChangedDetails;
    _integrationPolicyChangedDetails = integrationPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithMemberRequestsChangePolicyDetails:
    (DBTEAMLOGMemberRequestsChangePolicyDetails *)memberRequestsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberRequestsChangePolicyDetails;
    _memberRequestsChangePolicyDetails = memberRequestsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithMemberSendInvitePolicyChangedDetails:
    (DBTEAMLOGMemberSendInvitePolicyChangedDetails *)memberSendInvitePolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSendInvitePolicyChangedDetails;
    _memberSendInvitePolicyChangedDetails = memberSendInvitePolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsAddExceptionDetails:
    (DBTEAMLOGMemberSpaceLimitsAddExceptionDetails *)memberSpaceLimitsAddExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsAddExceptionDetails;
    _memberSpaceLimitsAddExceptionDetails = memberSpaceLimitsAddExceptionDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsChangeCapsTypePolicyDetails:
    (DBTEAMLOGMemberSpaceLimitsChangeCapsTypePolicyDetails *)memberSpaceLimitsChangeCapsTypePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsChangeCapsTypePolicyDetails;
    _memberSpaceLimitsChangeCapsTypePolicyDetails = memberSpaceLimitsChangeCapsTypePolicyDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsChangePolicyDetails:
    (DBTEAMLOGMemberSpaceLimitsChangePolicyDetails *)memberSpaceLimitsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsChangePolicyDetails;
    _memberSpaceLimitsChangePolicyDetails = memberSpaceLimitsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithMemberSpaceLimitsRemoveExceptionDetails:
    (DBTEAMLOGMemberSpaceLimitsRemoveExceptionDetails *)memberSpaceLimitsRemoveExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSpaceLimitsRemoveExceptionDetails;
    _memberSpaceLimitsRemoveExceptionDetails = memberSpaceLimitsRemoveExceptionDetails;
  }
  return self;
}

- (instancetype)initWithMemberSuggestionsChangePolicyDetails:
    (DBTEAMLOGMemberSuggestionsChangePolicyDetails *)memberSuggestionsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMemberSuggestionsChangePolicyDetails;
    _memberSuggestionsChangePolicyDetails = memberSuggestionsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithMicrosoftOfficeAddinChangePolicyDetails:
    (DBTEAMLOGMicrosoftOfficeAddinChangePolicyDetails *)microsoftOfficeAddinChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMicrosoftOfficeAddinChangePolicyDetails;
    _microsoftOfficeAddinChangePolicyDetails = microsoftOfficeAddinChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithNetworkControlChangePolicyDetails:
    (DBTEAMLOGNetworkControlChangePolicyDetails *)networkControlChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsNetworkControlChangePolicyDetails;
    _networkControlChangePolicyDetails = networkControlChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperChangeDeploymentPolicyDetails:
    (DBTEAMLOGPaperChangeDeploymentPolicyDetails *)paperChangeDeploymentPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperChangeDeploymentPolicyDetails;
    _paperChangeDeploymentPolicyDetails = paperChangeDeploymentPolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperChangeMemberLinkPolicyDetails:
    (DBTEAMLOGPaperChangeMemberLinkPolicyDetails *)paperChangeMemberLinkPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperChangeMemberLinkPolicyDetails;
    _paperChangeMemberLinkPolicyDetails = paperChangeMemberLinkPolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperChangeMemberPolicyDetails:
    (DBTEAMLOGPaperChangeMemberPolicyDetails *)paperChangeMemberPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperChangeMemberPolicyDetails;
    _paperChangeMemberPolicyDetails = paperChangeMemberPolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperChangePolicyDetails:(DBTEAMLOGPaperChangePolicyDetails *)paperChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperChangePolicyDetails;
    _paperChangePolicyDetails = paperChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithPaperDefaultFolderPolicyChangedDetails:
    (DBTEAMLOGPaperDefaultFolderPolicyChangedDetails *)paperDefaultFolderPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDefaultFolderPolicyChangedDetails;
    _paperDefaultFolderPolicyChangedDetails = paperDefaultFolderPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithPaperDesktopPolicyChangedDetails:
    (DBTEAMLOGPaperDesktopPolicyChangedDetails *)paperDesktopPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperDesktopPolicyChangedDetails;
    _paperDesktopPolicyChangedDetails = paperDesktopPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithPaperEnabledUsersGroupAdditionDetails:
    (DBTEAMLOGPaperEnabledUsersGroupAdditionDetails *)paperEnabledUsersGroupAdditionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperEnabledUsersGroupAdditionDetails;
    _paperEnabledUsersGroupAdditionDetails = paperEnabledUsersGroupAdditionDetails;
  }
  return self;
}

- (instancetype)initWithPaperEnabledUsersGroupRemovalDetails:
    (DBTEAMLOGPaperEnabledUsersGroupRemovalDetails *)paperEnabledUsersGroupRemovalDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPaperEnabledUsersGroupRemovalDetails;
    _paperEnabledUsersGroupRemovalDetails = paperEnabledUsersGroupRemovalDetails;
  }
  return self;
}

- (instancetype)initWithPasswordStrengthRequirementsChangePolicyDetails:
    (DBTEAMLOGPasswordStrengthRequirementsChangePolicyDetails *)passwordStrengthRequirementsChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPasswordStrengthRequirementsChangePolicyDetails;
    _passwordStrengthRequirementsChangePolicyDetails = passwordStrengthRequirementsChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithPermanentDeleteChangePolicyDetails:
    (DBTEAMLOGPermanentDeleteChangePolicyDetails *)permanentDeleteChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsPermanentDeleteChangePolicyDetails;
    _permanentDeleteChangePolicyDetails = permanentDeleteChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithResellerSupportChangePolicyDetails:
    (DBTEAMLOGResellerSupportChangePolicyDetails *)resellerSupportChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsResellerSupportChangePolicyDetails;
    _resellerSupportChangePolicyDetails = resellerSupportChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithRewindPolicyChangedDetails:(DBTEAMLOGRewindPolicyChangedDetails *)rewindPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsRewindPolicyChangedDetails;
    _rewindPolicyChangedDetails = rewindPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithSendForSignaturePolicyChangedDetails:
    (DBTEAMLOGSendForSignaturePolicyChangedDetails *)sendForSignaturePolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSendForSignaturePolicyChangedDetails;
    _sendForSignaturePolicyChangedDetails = sendForSignaturePolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithSharingChangeFolderJoinPolicyDetails:
    (DBTEAMLOGSharingChangeFolderJoinPolicyDetails *)sharingChangeFolderJoinPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharingChangeFolderJoinPolicyDetails;
    _sharingChangeFolderJoinPolicyDetails = sharingChangeFolderJoinPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharingChangeLinkPolicyDetails:
    (DBTEAMLOGSharingChangeLinkPolicyDetails *)sharingChangeLinkPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharingChangeLinkPolicyDetails;
    _sharingChangeLinkPolicyDetails = sharingChangeLinkPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSharingChangeMemberPolicyDetails:
    (DBTEAMLOGSharingChangeMemberPolicyDetails *)sharingChangeMemberPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSharingChangeMemberPolicyDetails;
    _sharingChangeMemberPolicyDetails = sharingChangeMemberPolicyDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseChangeDownloadPolicyDetails:
    (DBTEAMLOGShowcaseChangeDownloadPolicyDetails *)showcaseChangeDownloadPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseChangeDownloadPolicyDetails;
    _showcaseChangeDownloadPolicyDetails = showcaseChangeDownloadPolicyDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseChangeEnabledPolicyDetails:
    (DBTEAMLOGShowcaseChangeEnabledPolicyDetails *)showcaseChangeEnabledPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseChangeEnabledPolicyDetails;
    _showcaseChangeEnabledPolicyDetails = showcaseChangeEnabledPolicyDetails;
  }
  return self;
}

- (instancetype)initWithShowcaseChangeExternalSharingPolicyDetails:
    (DBTEAMLOGShowcaseChangeExternalSharingPolicyDetails *)showcaseChangeExternalSharingPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsShowcaseChangeExternalSharingPolicyDetails;
    _showcaseChangeExternalSharingPolicyDetails = showcaseChangeExternalSharingPolicyDetails;
  }
  return self;
}

- (instancetype)initWithSmarterSmartSyncPolicyChangedDetails:
    (DBTEAMLOGSmarterSmartSyncPolicyChangedDetails *)smarterSmartSyncPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSmarterSmartSyncPolicyChangedDetails;
    _smarterSmartSyncPolicyChangedDetails = smarterSmartSyncPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithSmartSyncChangePolicyDetails:
    (DBTEAMLOGSmartSyncChangePolicyDetails *)smartSyncChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSmartSyncChangePolicyDetails;
    _smartSyncChangePolicyDetails = smartSyncChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithSmartSyncNotOptOutDetails:(DBTEAMLOGSmartSyncNotOptOutDetails *)smartSyncNotOptOutDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSmartSyncNotOptOutDetails;
    _smartSyncNotOptOutDetails = smartSyncNotOptOutDetails;
  }
  return self;
}

- (instancetype)initWithSmartSyncOptOutDetails:(DBTEAMLOGSmartSyncOptOutDetails *)smartSyncOptOutDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSmartSyncOptOutDetails;
    _smartSyncOptOutDetails = smartSyncOptOutDetails;
  }
  return self;
}

- (instancetype)initWithSsoChangePolicyDetails:(DBTEAMLOGSsoChangePolicyDetails *)ssoChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsSsoChangePolicyDetails;
    _ssoChangePolicyDetails = ssoChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithTeamBrandingPolicyChangedDetails:
    (DBTEAMLOGTeamBrandingPolicyChangedDetails *)teamBrandingPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamBrandingPolicyChangedDetails;
    _teamBrandingPolicyChangedDetails = teamBrandingPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithTeamExtensionsPolicyChangedDetails:
    (DBTEAMLOGTeamExtensionsPolicyChangedDetails *)teamExtensionsPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamExtensionsPolicyChangedDetails;
    _teamExtensionsPolicyChangedDetails = teamExtensionsPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithTeamSelectiveSyncPolicyChangedDetails:
    (DBTEAMLOGTeamSelectiveSyncPolicyChangedDetails *)teamSelectiveSyncPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamSelectiveSyncPolicyChangedDetails;
    _teamSelectiveSyncPolicyChangedDetails = teamSelectiveSyncPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithTeamSharingWhitelistSubjectsChangedDetails:
    (DBTEAMLOGTeamSharingWhitelistSubjectsChangedDetails *)teamSharingWhitelistSubjectsChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamSharingWhitelistSubjectsChangedDetails;
    _teamSharingWhitelistSubjectsChangedDetails = teamSharingWhitelistSubjectsChangedDetails;
  }
  return self;
}

- (instancetype)initWithTfaAddExceptionDetails:(DBTEAMLOGTfaAddExceptionDetails *)tfaAddExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaAddExceptionDetails;
    _tfaAddExceptionDetails = tfaAddExceptionDetails;
  }
  return self;
}

- (instancetype)initWithTfaChangePolicyDetails:(DBTEAMLOGTfaChangePolicyDetails *)tfaChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaChangePolicyDetails;
    _tfaChangePolicyDetails = tfaChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithTfaRemoveExceptionDetails:(DBTEAMLOGTfaRemoveExceptionDetails *)tfaRemoveExceptionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaRemoveExceptionDetails;
    _tfaRemoveExceptionDetails = tfaRemoveExceptionDetails;
  }
  return self;
}

- (instancetype)initWithTwoAccountChangePolicyDetails:
    (DBTEAMLOGTwoAccountChangePolicyDetails *)twoAccountChangePolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTwoAccountChangePolicyDetails;
    _twoAccountChangePolicyDetails = twoAccountChangePolicyDetails;
  }
  return self;
}

- (instancetype)initWithViewerInfoPolicyChangedDetails:
    (DBTEAMLOGViewerInfoPolicyChangedDetails *)viewerInfoPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsViewerInfoPolicyChangedDetails;
    _viewerInfoPolicyChangedDetails = viewerInfoPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithWatermarkingPolicyChangedDetails:
    (DBTEAMLOGWatermarkingPolicyChangedDetails *)watermarkingPolicyChangedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsWatermarkingPolicyChangedDetails;
    _watermarkingPolicyChangedDetails = watermarkingPolicyChangedDetails;
  }
  return self;
}

- (instancetype)initWithWebSessionsChangeActiveSessionLimitDetails:
    (DBTEAMLOGWebSessionsChangeActiveSessionLimitDetails *)webSessionsChangeActiveSessionLimitDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsWebSessionsChangeActiveSessionLimitDetails;
    _webSessionsChangeActiveSessionLimitDetails = webSessionsChangeActiveSessionLimitDetails;
  }
  return self;
}

- (instancetype)initWithWebSessionsChangeFixedLengthPolicyDetails:
    (DBTEAMLOGWebSessionsChangeFixedLengthPolicyDetails *)webSessionsChangeFixedLengthPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsWebSessionsChangeFixedLengthPolicyDetails;
    _webSessionsChangeFixedLengthPolicyDetails = webSessionsChangeFixedLengthPolicyDetails;
  }
  return self;
}

- (instancetype)initWithWebSessionsChangeIdleLengthPolicyDetails:
    (DBTEAMLOGWebSessionsChangeIdleLengthPolicyDetails *)webSessionsChangeIdleLengthPolicyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsWebSessionsChangeIdleLengthPolicyDetails;
    _webSessionsChangeIdleLengthPolicyDetails = webSessionsChangeIdleLengthPolicyDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeFromDetails:(DBTEAMLOGTeamMergeFromDetails *)teamMergeFromDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeFromDetails;
    _teamMergeFromDetails = teamMergeFromDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeToDetails:(DBTEAMLOGTeamMergeToDetails *)teamMergeToDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeToDetails;
    _teamMergeToDetails = teamMergeToDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileAddBackgroundDetails:
    (DBTEAMLOGTeamProfileAddBackgroundDetails *)teamProfileAddBackgroundDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileAddBackgroundDetails;
    _teamProfileAddBackgroundDetails = teamProfileAddBackgroundDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileAddLogoDetails:(DBTEAMLOGTeamProfileAddLogoDetails *)teamProfileAddLogoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileAddLogoDetails;
    _teamProfileAddLogoDetails = teamProfileAddLogoDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileChangeBackgroundDetails:
    (DBTEAMLOGTeamProfileChangeBackgroundDetails *)teamProfileChangeBackgroundDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileChangeBackgroundDetails;
    _teamProfileChangeBackgroundDetails = teamProfileChangeBackgroundDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileChangeDefaultLanguageDetails:
    (DBTEAMLOGTeamProfileChangeDefaultLanguageDetails *)teamProfileChangeDefaultLanguageDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileChangeDefaultLanguageDetails;
    _teamProfileChangeDefaultLanguageDetails = teamProfileChangeDefaultLanguageDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileChangeLogoDetails:
    (DBTEAMLOGTeamProfileChangeLogoDetails *)teamProfileChangeLogoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileChangeLogoDetails;
    _teamProfileChangeLogoDetails = teamProfileChangeLogoDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileChangeNameDetails:
    (DBTEAMLOGTeamProfileChangeNameDetails *)teamProfileChangeNameDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileChangeNameDetails;
    _teamProfileChangeNameDetails = teamProfileChangeNameDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileRemoveBackgroundDetails:
    (DBTEAMLOGTeamProfileRemoveBackgroundDetails *)teamProfileRemoveBackgroundDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileRemoveBackgroundDetails;
    _teamProfileRemoveBackgroundDetails = teamProfileRemoveBackgroundDetails;
  }
  return self;
}

- (instancetype)initWithTeamProfileRemoveLogoDetails:
    (DBTEAMLOGTeamProfileRemoveLogoDetails *)teamProfileRemoveLogoDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamProfileRemoveLogoDetails;
    _teamProfileRemoveLogoDetails = teamProfileRemoveLogoDetails;
  }
  return self;
}

- (instancetype)initWithTfaAddBackupPhoneDetails:(DBTEAMLOGTfaAddBackupPhoneDetails *)tfaAddBackupPhoneDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaAddBackupPhoneDetails;
    _tfaAddBackupPhoneDetails = tfaAddBackupPhoneDetails;
  }
  return self;
}

- (instancetype)initWithTfaAddSecurityKeyDetails:(DBTEAMLOGTfaAddSecurityKeyDetails *)tfaAddSecurityKeyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaAddSecurityKeyDetails;
    _tfaAddSecurityKeyDetails = tfaAddSecurityKeyDetails;
  }
  return self;
}

- (instancetype)initWithTfaChangeBackupPhoneDetails:
    (DBTEAMLOGTfaChangeBackupPhoneDetails *)tfaChangeBackupPhoneDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaChangeBackupPhoneDetails;
    _tfaChangeBackupPhoneDetails = tfaChangeBackupPhoneDetails;
  }
  return self;
}

- (instancetype)initWithTfaChangeStatusDetails:(DBTEAMLOGTfaChangeStatusDetails *)tfaChangeStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaChangeStatusDetails;
    _tfaChangeStatusDetails = tfaChangeStatusDetails;
  }
  return self;
}

- (instancetype)initWithTfaRemoveBackupPhoneDetails:
    (DBTEAMLOGTfaRemoveBackupPhoneDetails *)tfaRemoveBackupPhoneDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaRemoveBackupPhoneDetails;
    _tfaRemoveBackupPhoneDetails = tfaRemoveBackupPhoneDetails;
  }
  return self;
}

- (instancetype)initWithTfaRemoveSecurityKeyDetails:
    (DBTEAMLOGTfaRemoveSecurityKeyDetails *)tfaRemoveSecurityKeyDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaRemoveSecurityKeyDetails;
    _tfaRemoveSecurityKeyDetails = tfaRemoveSecurityKeyDetails;
  }
  return self;
}

- (instancetype)initWithTfaResetDetails:(DBTEAMLOGTfaResetDetails *)tfaResetDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTfaResetDetails;
    _tfaResetDetails = tfaResetDetails;
  }
  return self;
}

- (instancetype)initWithChangedEnterpriseAdminRoleDetails:
    (DBTEAMLOGChangedEnterpriseAdminRoleDetails *)changedEnterpriseAdminRoleDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsChangedEnterpriseAdminRoleDetails;
    _changedEnterpriseAdminRoleDetails = changedEnterpriseAdminRoleDetails;
  }
  return self;
}

- (instancetype)initWithChangedEnterpriseConnectedTeamStatusDetails:
    (DBTEAMLOGChangedEnterpriseConnectedTeamStatusDetails *)changedEnterpriseConnectedTeamStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsChangedEnterpriseConnectedTeamStatusDetails;
    _changedEnterpriseConnectedTeamStatusDetails = changedEnterpriseConnectedTeamStatusDetails;
  }
  return self;
}

- (instancetype)initWithEndedEnterpriseAdminSessionDetails:
    (DBTEAMLOGEndedEnterpriseAdminSessionDetails *)endedEnterpriseAdminSessionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEndedEnterpriseAdminSessionDetails;
    _endedEnterpriseAdminSessionDetails = endedEnterpriseAdminSessionDetails;
  }
  return self;
}

- (instancetype)initWithEndedEnterpriseAdminSessionDeprecatedDetails:
    (DBTEAMLOGEndedEnterpriseAdminSessionDeprecatedDetails *)endedEnterpriseAdminSessionDeprecatedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEndedEnterpriseAdminSessionDeprecatedDetails;
    _endedEnterpriseAdminSessionDeprecatedDetails = endedEnterpriseAdminSessionDeprecatedDetails;
  }
  return self;
}

- (instancetype)initWithEnterpriseSettingsLockingDetails:
    (DBTEAMLOGEnterpriseSettingsLockingDetails *)enterpriseSettingsLockingDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsEnterpriseSettingsLockingDetails;
    _enterpriseSettingsLockingDetails = enterpriseSettingsLockingDetails;
  }
  return self;
}

- (instancetype)initWithGuestAdminChangeStatusDetails:
    (DBTEAMLOGGuestAdminChangeStatusDetails *)guestAdminChangeStatusDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsGuestAdminChangeStatusDetails;
    _guestAdminChangeStatusDetails = guestAdminChangeStatusDetails;
  }
  return self;
}

- (instancetype)initWithStartedEnterpriseAdminSessionDetails:
    (DBTEAMLOGStartedEnterpriseAdminSessionDetails *)startedEnterpriseAdminSessionDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsStartedEnterpriseAdminSessionDetails;
    _startedEnterpriseAdminSessionDetails = startedEnterpriseAdminSessionDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestAcceptedDetails:
    (DBTEAMLOGTeamMergeRequestAcceptedDetails *)teamMergeRequestAcceptedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestAcceptedDetails;
    _teamMergeRequestAcceptedDetails = teamMergeRequestAcceptedDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestAcceptedShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestAcceptedShownToPrimaryTeamDetails *)teamMergeRequestAcceptedShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestAcceptedShownToPrimaryTeamDetails;
    _teamMergeRequestAcceptedShownToPrimaryTeamDetails = teamMergeRequestAcceptedShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestAcceptedShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestAcceptedShownToSecondaryTeamDetails *)
        teamMergeRequestAcceptedShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestAcceptedShownToSecondaryTeamDetails;
    _teamMergeRequestAcceptedShownToSecondaryTeamDetails = teamMergeRequestAcceptedShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestAutoCanceledDetails:
    (DBTEAMLOGTeamMergeRequestAutoCanceledDetails *)teamMergeRequestAutoCanceledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestAutoCanceledDetails;
    _teamMergeRequestAutoCanceledDetails = teamMergeRequestAutoCanceledDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestCanceledDetails:
    (DBTEAMLOGTeamMergeRequestCanceledDetails *)teamMergeRequestCanceledDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestCanceledDetails;
    _teamMergeRequestCanceledDetails = teamMergeRequestCanceledDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestCanceledShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestCanceledShownToPrimaryTeamDetails *)teamMergeRequestCanceledShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestCanceledShownToPrimaryTeamDetails;
    _teamMergeRequestCanceledShownToPrimaryTeamDetails = teamMergeRequestCanceledShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestCanceledShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestCanceledShownToSecondaryTeamDetails *)
        teamMergeRequestCanceledShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestCanceledShownToSecondaryTeamDetails;
    _teamMergeRequestCanceledShownToSecondaryTeamDetails = teamMergeRequestCanceledShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestExpiredDetails:
    (DBTEAMLOGTeamMergeRequestExpiredDetails *)teamMergeRequestExpiredDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestExpiredDetails;
    _teamMergeRequestExpiredDetails = teamMergeRequestExpiredDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestExpiredShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestExpiredShownToPrimaryTeamDetails *)teamMergeRequestExpiredShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestExpiredShownToPrimaryTeamDetails;
    _teamMergeRequestExpiredShownToPrimaryTeamDetails = teamMergeRequestExpiredShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestExpiredShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestExpiredShownToSecondaryTeamDetails *)teamMergeRequestExpiredShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestExpiredShownToSecondaryTeamDetails;
    _teamMergeRequestExpiredShownToSecondaryTeamDetails = teamMergeRequestExpiredShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestRejectedShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestRejectedShownToPrimaryTeamDetails *)teamMergeRequestRejectedShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestRejectedShownToPrimaryTeamDetails;
    _teamMergeRequestRejectedShownToPrimaryTeamDetails = teamMergeRequestRejectedShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestRejectedShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestRejectedShownToSecondaryTeamDetails *)
        teamMergeRequestRejectedShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestRejectedShownToSecondaryTeamDetails;
    _teamMergeRequestRejectedShownToSecondaryTeamDetails = teamMergeRequestRejectedShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestReminderDetails:
    (DBTEAMLOGTeamMergeRequestReminderDetails *)teamMergeRequestReminderDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestReminderDetails;
    _teamMergeRequestReminderDetails = teamMergeRequestReminderDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestReminderShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestReminderShownToPrimaryTeamDetails *)teamMergeRequestReminderShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestReminderShownToPrimaryTeamDetails;
    _teamMergeRequestReminderShownToPrimaryTeamDetails = teamMergeRequestReminderShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestReminderShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestReminderShownToSecondaryTeamDetails *)
        teamMergeRequestReminderShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestReminderShownToSecondaryTeamDetails;
    _teamMergeRequestReminderShownToSecondaryTeamDetails = teamMergeRequestReminderShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestRevokedDetails:
    (DBTEAMLOGTeamMergeRequestRevokedDetails *)teamMergeRequestRevokedDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestRevokedDetails;
    _teamMergeRequestRevokedDetails = teamMergeRequestRevokedDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestSentShownToPrimaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestSentShownToPrimaryTeamDetails *)teamMergeRequestSentShownToPrimaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestSentShownToPrimaryTeamDetails;
    _teamMergeRequestSentShownToPrimaryTeamDetails = teamMergeRequestSentShownToPrimaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithTeamMergeRequestSentShownToSecondaryTeamDetails:
    (DBTEAMLOGTeamMergeRequestSentShownToSecondaryTeamDetails *)teamMergeRequestSentShownToSecondaryTeamDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsTeamMergeRequestSentShownToSecondaryTeamDetails;
    _teamMergeRequestSentShownToSecondaryTeamDetails = teamMergeRequestSentShownToSecondaryTeamDetails;
  }
  return self;
}

- (instancetype)initWithMissingDetails:(DBTEAMLOGMissingDetails *)missingDetails {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsMissingDetails;
    _missingDetails = missingDetails;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBTEAMLOGEventDetailsOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBTEAMLOGAdminAlertingChangedAlertConfigDetails *)adminAlertingChangedAlertConfigDetails {
  if (![self isAdminAlertingChangedAlertConfigDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAdminAlertingChangedAlertConfigDetails, but was %@.",
               [self tagName]];
  }
  return _adminAlertingChangedAlertConfigDetails;
}

- (DBTEAMLOGAdminAlertingTriggeredAlertDetails *)adminAlertingTriggeredAlertDetails {
  if (![self isAdminAlertingTriggeredAlertDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAdminAlertingTriggeredAlertDetails, but was %@.",
                       [self tagName]];
  }
  return _adminAlertingTriggeredAlertDetails;
}

- (DBTEAMLOGAppLinkTeamDetails *)appLinkTeamDetails {
  if (![self isAppLinkTeamDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAppLinkTeamDetails, but was %@.", [self tagName]];
  }
  return _appLinkTeamDetails;
}

- (DBTEAMLOGAppLinkUserDetails *)appLinkUserDetails {
  if (![self isAppLinkUserDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAppLinkUserDetails, but was %@.", [self tagName]];
  }
  return _appLinkUserDetails;
}

- (DBTEAMLOGAppUnlinkTeamDetails *)appUnlinkTeamDetails {
  if (![self isAppUnlinkTeamDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAppUnlinkTeamDetails, but was %@.", [self tagName]];
  }
  return _appUnlinkTeamDetails;
}

- (DBTEAMLOGAppUnlinkUserDetails *)appUnlinkUserDetails {
  if (![self isAppUnlinkUserDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAppUnlinkUserDetails, but was %@.", [self tagName]];
  }
  return _appUnlinkUserDetails;
}

- (DBTEAMLOGIntegrationConnectedDetails *)integrationConnectedDetails {
  if (![self isIntegrationConnectedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsIntegrationConnectedDetails, but was %@.", [self tagName]];
  }
  return _integrationConnectedDetails;
}

- (DBTEAMLOGIntegrationDisconnectedDetails *)integrationDisconnectedDetails {
  if (![self isIntegrationDisconnectedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsIntegrationDisconnectedDetails, but was %@.",
                       [self tagName]];
  }
  return _integrationDisconnectedDetails;
}

- (DBTEAMLOGFileAddCommentDetails *)fileAddCommentDetails {
  if (![self isFileAddCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileAddCommentDetails, but was %@.", [self tagName]];
  }
  return _fileAddCommentDetails;
}

- (DBTEAMLOGFileChangeCommentSubscriptionDetails *)fileChangeCommentSubscriptionDetails {
  if (![self isFileChangeCommentSubscriptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileChangeCommentSubscriptionDetails, but was %@.",
                       [self tagName]];
  }
  return _fileChangeCommentSubscriptionDetails;
}

- (DBTEAMLOGFileDeleteCommentDetails *)fileDeleteCommentDetails {
  if (![self isFileDeleteCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileDeleteCommentDetails, but was %@.", [self tagName]];
  }
  return _fileDeleteCommentDetails;
}

- (DBTEAMLOGFileEditCommentDetails *)fileEditCommentDetails {
  if (![self isFileEditCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileEditCommentDetails, but was %@.", [self tagName]];
  }
  return _fileEditCommentDetails;
}

- (DBTEAMLOGFileLikeCommentDetails *)fileLikeCommentDetails {
  if (![self isFileLikeCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileLikeCommentDetails, but was %@.", [self tagName]];
  }
  return _fileLikeCommentDetails;
}

- (DBTEAMLOGFileResolveCommentDetails *)fileResolveCommentDetails {
  if (![self isFileResolveCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileResolveCommentDetails, but was %@.", [self tagName]];
  }
  return _fileResolveCommentDetails;
}

- (DBTEAMLOGFileUnlikeCommentDetails *)fileUnlikeCommentDetails {
  if (![self isFileUnlikeCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileUnlikeCommentDetails, but was %@.", [self tagName]];
  }
  return _fileUnlikeCommentDetails;
}

- (DBTEAMLOGFileUnresolveCommentDetails *)fileUnresolveCommentDetails {
  if (![self isFileUnresolveCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileUnresolveCommentDetails, but was %@.", [self tagName]];
  }
  return _fileUnresolveCommentDetails;
}

- (DBTEAMLOGGovernancePolicyAddFoldersDetails *)governancePolicyAddFoldersDetails {
  if (![self isGovernancePolicyAddFoldersDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyAddFoldersDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyAddFoldersDetails;
}

- (DBTEAMLOGGovernancePolicyAddFolderFailedDetails *)governancePolicyAddFolderFailedDetails {
  if (![self isGovernancePolicyAddFolderFailedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyAddFolderFailedDetails, but was %@.",
               [self tagName]];
  }
  return _governancePolicyAddFolderFailedDetails;
}

- (DBTEAMLOGGovernancePolicyContentDisposedDetails *)governancePolicyContentDisposedDetails {
  if (![self isGovernancePolicyContentDisposedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyContentDisposedDetails, but was %@.",
               [self tagName]];
  }
  return _governancePolicyContentDisposedDetails;
}

- (DBTEAMLOGGovernancePolicyCreateDetails *)governancePolicyCreateDetails {
  if (![self isGovernancePolicyCreateDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyCreateDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyCreateDetails;
}

- (DBTEAMLOGGovernancePolicyDeleteDetails *)governancePolicyDeleteDetails {
  if (![self isGovernancePolicyDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyDeleteDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyDeleteDetails;
}

- (DBTEAMLOGGovernancePolicyEditDetailsDetails *)governancePolicyEditDetailsDetails {
  if (![self isGovernancePolicyEditDetailsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyEditDetailsDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyEditDetailsDetails;
}

- (DBTEAMLOGGovernancePolicyEditDurationDetails *)governancePolicyEditDurationDetails {
  if (![self isGovernancePolicyEditDurationDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyEditDurationDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyEditDurationDetails;
}

- (DBTEAMLOGGovernancePolicyExportCreatedDetails *)governancePolicyExportCreatedDetails {
  if (![self isGovernancePolicyExportCreatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyExportCreatedDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyExportCreatedDetails;
}

- (DBTEAMLOGGovernancePolicyExportRemovedDetails *)governancePolicyExportRemovedDetails {
  if (![self isGovernancePolicyExportRemovedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyExportRemovedDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyExportRemovedDetails;
}

- (DBTEAMLOGGovernancePolicyRemoveFoldersDetails *)governancePolicyRemoveFoldersDetails {
  if (![self isGovernancePolicyRemoveFoldersDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyRemoveFoldersDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyRemoveFoldersDetails;
}

- (DBTEAMLOGGovernancePolicyReportCreatedDetails *)governancePolicyReportCreatedDetails {
  if (![self isGovernancePolicyReportCreatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyReportCreatedDetails, but was %@.",
                       [self tagName]];
  }
  return _governancePolicyReportCreatedDetails;
}

- (DBTEAMLOGGovernancePolicyZipPartDownloadedDetails *)governancePolicyZipPartDownloadedDetails {
  if (![self isGovernancePolicyZipPartDownloadedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGovernancePolicyZipPartDownloadedDetails, but was %@.",
               [self tagName]];
  }
  return _governancePolicyZipPartDownloadedDetails;
}

- (DBTEAMLOGLegalHoldsActivateAHoldDetails *)legalHoldsActivateAHoldDetails {
  if (![self isLegalHoldsActivateAHoldDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsActivateAHoldDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsActivateAHoldDetails;
}

- (DBTEAMLOGLegalHoldsAddMembersDetails *)legalHoldsAddMembersDetails {
  if (![self isLegalHoldsAddMembersDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsAddMembersDetails, but was %@.", [self tagName]];
  }
  return _legalHoldsAddMembersDetails;
}

- (DBTEAMLOGLegalHoldsChangeHoldDetailsDetails *)legalHoldsChangeHoldDetailsDetails {
  if (![self isLegalHoldsChangeHoldDetailsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsChangeHoldDetailsDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsChangeHoldDetailsDetails;
}

- (DBTEAMLOGLegalHoldsChangeHoldNameDetails *)legalHoldsChangeHoldNameDetails {
  if (![self isLegalHoldsChangeHoldNameDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsChangeHoldNameDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsChangeHoldNameDetails;
}

- (DBTEAMLOGLegalHoldsExportAHoldDetails *)legalHoldsExportAHoldDetails {
  if (![self isLegalHoldsExportAHoldDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsExportAHoldDetails, but was %@.", [self tagName]];
  }
  return _legalHoldsExportAHoldDetails;
}

- (DBTEAMLOGLegalHoldsExportCancelledDetails *)legalHoldsExportCancelledDetails {
  if (![self isLegalHoldsExportCancelledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsExportCancelledDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsExportCancelledDetails;
}

- (DBTEAMLOGLegalHoldsExportDownloadedDetails *)legalHoldsExportDownloadedDetails {
  if (![self isLegalHoldsExportDownloadedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsExportDownloadedDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsExportDownloadedDetails;
}

- (DBTEAMLOGLegalHoldsExportRemovedDetails *)legalHoldsExportRemovedDetails {
  if (![self isLegalHoldsExportRemovedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsExportRemovedDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsExportRemovedDetails;
}

- (DBTEAMLOGLegalHoldsReleaseAHoldDetails *)legalHoldsReleaseAHoldDetails {
  if (![self isLegalHoldsReleaseAHoldDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsReleaseAHoldDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsReleaseAHoldDetails;
}

- (DBTEAMLOGLegalHoldsRemoveMembersDetails *)legalHoldsRemoveMembersDetails {
  if (![self isLegalHoldsRemoveMembersDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsRemoveMembersDetails, but was %@.",
                       [self tagName]];
  }
  return _legalHoldsRemoveMembersDetails;
}

- (DBTEAMLOGLegalHoldsReportAHoldDetails *)legalHoldsReportAHoldDetails {
  if (![self isLegalHoldsReportAHoldDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsLegalHoldsReportAHoldDetails, but was %@.", [self tagName]];
  }
  return _legalHoldsReportAHoldDetails;
}

- (DBTEAMLOGDeviceChangeIpDesktopDetails *)deviceChangeIpDesktopDetails {
  if (![self isDeviceChangeIpDesktopDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceChangeIpDesktopDetails, but was %@.", [self tagName]];
  }
  return _deviceChangeIpDesktopDetails;
}

- (DBTEAMLOGDeviceChangeIpMobileDetails *)deviceChangeIpMobileDetails {
  if (![self isDeviceChangeIpMobileDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceChangeIpMobileDetails, but was %@.", [self tagName]];
  }
  return _deviceChangeIpMobileDetails;
}

- (DBTEAMLOGDeviceChangeIpWebDetails *)deviceChangeIpWebDetails {
  if (![self isDeviceChangeIpWebDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceChangeIpWebDetails, but was %@.", [self tagName]];
  }
  return _deviceChangeIpWebDetails;
}

- (DBTEAMLOGDeviceDeleteOnUnlinkFailDetails *)deviceDeleteOnUnlinkFailDetails {
  if (![self isDeviceDeleteOnUnlinkFailDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceDeleteOnUnlinkFailDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceDeleteOnUnlinkFailDetails;
}

- (DBTEAMLOGDeviceDeleteOnUnlinkSuccessDetails *)deviceDeleteOnUnlinkSuccessDetails {
  if (![self isDeviceDeleteOnUnlinkSuccessDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceDeleteOnUnlinkSuccessDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceDeleteOnUnlinkSuccessDetails;
}

- (DBTEAMLOGDeviceLinkFailDetails *)deviceLinkFailDetails {
  if (![self isDeviceLinkFailDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceLinkFailDetails, but was %@.", [self tagName]];
  }
  return _deviceLinkFailDetails;
}

- (DBTEAMLOGDeviceLinkSuccessDetails *)deviceLinkSuccessDetails {
  if (![self isDeviceLinkSuccessDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceLinkSuccessDetails, but was %@.", [self tagName]];
  }
  return _deviceLinkSuccessDetails;
}

- (DBTEAMLOGDeviceManagementDisabledDetails *)deviceManagementDisabledDetails {
  if (![self isDeviceManagementDisabledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceManagementDisabledDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceManagementDisabledDetails;
}

- (DBTEAMLOGDeviceManagementEnabledDetails *)deviceManagementEnabledDetails {
  if (![self isDeviceManagementEnabledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceManagementEnabledDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceManagementEnabledDetails;
}

- (DBTEAMLOGDeviceSyncBackupStatusChangedDetails *)deviceSyncBackupStatusChangedDetails {
  if (![self isDeviceSyncBackupStatusChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceSyncBackupStatusChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceSyncBackupStatusChangedDetails;
}

- (DBTEAMLOGDeviceUnlinkDetails *)deviceUnlinkDetails {
  if (![self isDeviceUnlinkDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceUnlinkDetails, but was %@.", [self tagName]];
  }
  return _deviceUnlinkDetails;
}

- (DBTEAMLOGDropboxPasswordsExportedDetails *)dropboxPasswordsExportedDetails {
  if (![self isDropboxPasswordsExportedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDropboxPasswordsExportedDetails, but was %@.",
                       [self tagName]];
  }
  return _dropboxPasswordsExportedDetails;
}

- (DBTEAMLOGDropboxPasswordsNewDeviceEnrolledDetails *)dropboxPasswordsNewDeviceEnrolledDetails {
  if (![self isDropboxPasswordsNewDeviceEnrolledDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDropboxPasswordsNewDeviceEnrolledDetails, but was %@.",
               [self tagName]];
  }
  return _dropboxPasswordsNewDeviceEnrolledDetails;
}

- (DBTEAMLOGEmmRefreshAuthTokenDetails *)emmRefreshAuthTokenDetails {
  if (![self isEmmRefreshAuthTokenDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmRefreshAuthTokenDetails, but was %@.", [self tagName]];
  }
  return _emmRefreshAuthTokenDetails;
}

- (DBTEAMLOGAccountCaptureChangeAvailabilityDetails *)accountCaptureChangeAvailabilityDetails {
  if (![self isAccountCaptureChangeAvailabilityDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountCaptureChangeAvailabilityDetails, but was %@.",
               [self tagName]];
  }
  return _accountCaptureChangeAvailabilityDetails;
}

- (DBTEAMLOGAccountCaptureMigrateAccountDetails *)accountCaptureMigrateAccountDetails {
  if (![self isAccountCaptureMigrateAccountDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountCaptureMigrateAccountDetails, but was %@.",
                       [self tagName]];
  }
  return _accountCaptureMigrateAccountDetails;
}

- (DBTEAMLOGAccountCaptureNotificationEmailsSentDetails *)accountCaptureNotificationEmailsSentDetails {
  if (![self isAccountCaptureNotificationEmailsSentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountCaptureNotificationEmailsSentDetails, but was %@.",
               [self tagName]];
  }
  return _accountCaptureNotificationEmailsSentDetails;
}

- (DBTEAMLOGAccountCaptureRelinquishAccountDetails *)accountCaptureRelinquishAccountDetails {
  if (![self isAccountCaptureRelinquishAccountDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountCaptureRelinquishAccountDetails, but was %@.",
               [self tagName]];
  }
  return _accountCaptureRelinquishAccountDetails;
}

- (DBTEAMLOGDisabledDomainInvitesDetails *)disabledDomainInvitesDetails {
  if (![self isDisabledDomainInvitesDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDisabledDomainInvitesDetails, but was %@.", [self tagName]];
  }
  return _disabledDomainInvitesDetails;
}

- (DBTEAMLOGDomainInvitesApproveRequestToJoinTeamDetails *)domainInvitesApproveRequestToJoinTeamDetails {
  if (![self isDomainInvitesApproveRequestToJoinTeamDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesApproveRequestToJoinTeamDetails, but was %@.",
               [self tagName]];
  }
  return _domainInvitesApproveRequestToJoinTeamDetails;
}

- (DBTEAMLOGDomainInvitesDeclineRequestToJoinTeamDetails *)domainInvitesDeclineRequestToJoinTeamDetails {
  if (![self isDomainInvitesDeclineRequestToJoinTeamDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesDeclineRequestToJoinTeamDetails, but was %@.",
               [self tagName]];
  }
  return _domainInvitesDeclineRequestToJoinTeamDetails;
}

- (DBTEAMLOGDomainInvitesEmailExistingUsersDetails *)domainInvitesEmailExistingUsersDetails {
  if (![self isDomainInvitesEmailExistingUsersDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesEmailExistingUsersDetails, but was %@.",
               [self tagName]];
  }
  return _domainInvitesEmailExistingUsersDetails;
}

- (DBTEAMLOGDomainInvitesRequestToJoinTeamDetails *)domainInvitesRequestToJoinTeamDetails {
  if (![self isDomainInvitesRequestToJoinTeamDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesRequestToJoinTeamDetails, but was %@.",
                       [self tagName]];
  }
  return _domainInvitesRequestToJoinTeamDetails;
}

- (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToNoDetails *)domainInvitesSetInviteNewUserPrefToNoDetails {
  if (![self isDomainInvitesSetInviteNewUserPrefToNoDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesSetInviteNewUserPrefToNoDetails, but was %@.",
               [self tagName]];
  }
  return _domainInvitesSetInviteNewUserPrefToNoDetails;
}

- (DBTEAMLOGDomainInvitesSetInviteNewUserPrefToYesDetails *)domainInvitesSetInviteNewUserPrefToYesDetails {
  if (![self isDomainInvitesSetInviteNewUserPrefToYesDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainInvitesSetInviteNewUserPrefToYesDetails, but was %@.",
               [self tagName]];
  }
  return _domainInvitesSetInviteNewUserPrefToYesDetails;
}

- (DBTEAMLOGDomainVerificationAddDomainFailDetails *)domainVerificationAddDomainFailDetails {
  if (![self isDomainVerificationAddDomainFailDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainVerificationAddDomainFailDetails, but was %@.",
               [self tagName]];
  }
  return _domainVerificationAddDomainFailDetails;
}

- (DBTEAMLOGDomainVerificationAddDomainSuccessDetails *)domainVerificationAddDomainSuccessDetails {
  if (![self isDomainVerificationAddDomainSuccessDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainVerificationAddDomainSuccessDetails, but was %@.",
               [self tagName]];
  }
  return _domainVerificationAddDomainSuccessDetails;
}

- (DBTEAMLOGDomainVerificationRemoveDomainDetails *)domainVerificationRemoveDomainDetails {
  if (![self isDomainVerificationRemoveDomainDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDomainVerificationRemoveDomainDetails, but was %@.",
                       [self tagName]];
  }
  return _domainVerificationRemoveDomainDetails;
}

- (DBTEAMLOGEnabledDomainInvitesDetails *)enabledDomainInvitesDetails {
  if (![self isEnabledDomainInvitesDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEnabledDomainInvitesDetails, but was %@.", [self tagName]];
  }
  return _enabledDomainInvitesDetails;
}

- (DBTEAMLOGCreateFolderDetails *)createFolderDetails {
  if (![self isCreateFolderDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsCreateFolderDetails, but was %@.", [self tagName]];
  }
  return _createFolderDetails;
}

- (DBTEAMLOGFileAddDetails *)fileAddDetails {
  if (![self isFileAddDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileAddDetails, but was %@.", [self tagName]];
  }
  return _fileAddDetails;
}

- (DBTEAMLOGFileCopyDetails *)fileCopyDetails {
  if (![self isFileCopyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileCopyDetails, but was %@.", [self tagName]];
  }
  return _fileCopyDetails;
}

- (DBTEAMLOGFileDeleteDetails *)fileDeleteDetails {
  if (![self isFileDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileDeleteDetails, but was %@.", [self tagName]];
  }
  return _fileDeleteDetails;
}

- (DBTEAMLOGFileDownloadDetails *)fileDownloadDetails {
  if (![self isFileDownloadDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileDownloadDetails, but was %@.", [self tagName]];
  }
  return _fileDownloadDetails;
}

- (DBTEAMLOGFileEditDetails *)fileEditDetails {
  if (![self isFileEditDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileEditDetails, but was %@.", [self tagName]];
  }
  return _fileEditDetails;
}

- (DBTEAMLOGFileGetCopyReferenceDetails *)fileGetCopyReferenceDetails {
  if (![self isFileGetCopyReferenceDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileGetCopyReferenceDetails, but was %@.", [self tagName]];
  }
  return _fileGetCopyReferenceDetails;
}

- (DBTEAMLOGFileLockingLockStatusChangedDetails *)fileLockingLockStatusChangedDetails {
  if (![self isFileLockingLockStatusChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileLockingLockStatusChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _fileLockingLockStatusChangedDetails;
}

- (DBTEAMLOGFileMoveDetails *)fileMoveDetails {
  if (![self isFileMoveDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileMoveDetails, but was %@.", [self tagName]];
  }
  return _fileMoveDetails;
}

- (DBTEAMLOGFilePermanentlyDeleteDetails *)filePermanentlyDeleteDetails {
  if (![self isFilePermanentlyDeleteDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFilePermanentlyDeleteDetails, but was %@.", [self tagName]];
  }
  return _filePermanentlyDeleteDetails;
}

- (DBTEAMLOGFilePreviewDetails *)filePreviewDetails {
  if (![self isFilePreviewDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFilePreviewDetails, but was %@.", [self tagName]];
  }
  return _filePreviewDetails;
}

- (DBTEAMLOGFileRenameDetails *)fileRenameDetails {
  if (![self isFileRenameDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRenameDetails, but was %@.", [self tagName]];
  }
  return _fileRenameDetails;
}

- (DBTEAMLOGFileRestoreDetails *)fileRestoreDetails {
  if (![self isFileRestoreDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRestoreDetails, but was %@.", [self tagName]];
  }
  return _fileRestoreDetails;
}

- (DBTEAMLOGFileRevertDetails *)fileRevertDetails {
  if (![self isFileRevertDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRevertDetails, but was %@.", [self tagName]];
  }
  return _fileRevertDetails;
}

- (DBTEAMLOGFileRollbackChangesDetails *)fileRollbackChangesDetails {
  if (![self isFileRollbackChangesDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRollbackChangesDetails, but was %@.", [self tagName]];
  }
  return _fileRollbackChangesDetails;
}

- (DBTEAMLOGFileSaveCopyReferenceDetails *)fileSaveCopyReferenceDetails {
  if (![self isFileSaveCopyReferenceDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileSaveCopyReferenceDetails, but was %@.", [self tagName]];
  }
  return _fileSaveCopyReferenceDetails;
}

- (DBTEAMLOGFolderOverviewDescriptionChangedDetails *)folderOverviewDescriptionChangedDetails {
  if (![self isFolderOverviewDescriptionChangedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFolderOverviewDescriptionChangedDetails, but was %@.",
               [self tagName]];
  }
  return _folderOverviewDescriptionChangedDetails;
}

- (DBTEAMLOGFolderOverviewItemPinnedDetails *)folderOverviewItemPinnedDetails {
  if (![self isFolderOverviewItemPinnedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFolderOverviewItemPinnedDetails, but was %@.",
                       [self tagName]];
  }
  return _folderOverviewItemPinnedDetails;
}

- (DBTEAMLOGFolderOverviewItemUnpinnedDetails *)folderOverviewItemUnpinnedDetails {
  if (![self isFolderOverviewItemUnpinnedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFolderOverviewItemUnpinnedDetails, but was %@.",
                       [self tagName]];
  }
  return _folderOverviewItemUnpinnedDetails;
}

- (DBTEAMLOGObjectLabelAddedDetails *)objectLabelAddedDetails {
  if (![self isObjectLabelAddedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsObjectLabelAddedDetails, but was %@.", [self tagName]];
  }
  return _objectLabelAddedDetails;
}

- (DBTEAMLOGObjectLabelRemovedDetails *)objectLabelRemovedDetails {
  if (![self isObjectLabelRemovedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsObjectLabelRemovedDetails, but was %@.", [self tagName]];
  }
  return _objectLabelRemovedDetails;
}

- (DBTEAMLOGObjectLabelUpdatedValueDetails *)objectLabelUpdatedValueDetails {
  if (![self isObjectLabelUpdatedValueDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsObjectLabelUpdatedValueDetails, but was %@.",
                       [self tagName]];
  }
  return _objectLabelUpdatedValueDetails;
}

- (DBTEAMLOGRewindFolderDetails *)rewindFolderDetails {
  if (![self isRewindFolderDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsRewindFolderDetails, but was %@.", [self tagName]];
  }
  return _rewindFolderDetails;
}

- (DBTEAMLOGFileRequestChangeDetails *)fileRequestChangeDetails {
  if (![self isFileRequestChangeDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestChangeDetails, but was %@.", [self tagName]];
  }
  return _fileRequestChangeDetails;
}

- (DBTEAMLOGFileRequestCloseDetails *)fileRequestCloseDetails {
  if (![self isFileRequestCloseDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestCloseDetails, but was %@.", [self tagName]];
  }
  return _fileRequestCloseDetails;
}

- (DBTEAMLOGFileRequestCreateDetails *)fileRequestCreateDetails {
  if (![self isFileRequestCreateDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestCreateDetails, but was %@.", [self tagName]];
  }
  return _fileRequestCreateDetails;
}

- (DBTEAMLOGFileRequestDeleteDetails *)fileRequestDeleteDetails {
  if (![self isFileRequestDeleteDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestDeleteDetails, but was %@.", [self tagName]];
  }
  return _fileRequestDeleteDetails;
}

- (DBTEAMLOGFileRequestReceiveFileDetails *)fileRequestReceiveFileDetails {
  if (![self isFileRequestReceiveFileDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestReceiveFileDetails, but was %@.",
                       [self tagName]];
  }
  return _fileRequestReceiveFileDetails;
}

- (DBTEAMLOGGroupAddExternalIdDetails *)groupAddExternalIdDetails {
  if (![self isGroupAddExternalIdDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupAddExternalIdDetails, but was %@.", [self tagName]];
  }
  return _groupAddExternalIdDetails;
}

- (DBTEAMLOGGroupAddMemberDetails *)groupAddMemberDetails {
  if (![self isGroupAddMemberDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupAddMemberDetails, but was %@.", [self tagName]];
  }
  return _groupAddMemberDetails;
}

- (DBTEAMLOGGroupChangeExternalIdDetails *)groupChangeExternalIdDetails {
  if (![self isGroupChangeExternalIdDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupChangeExternalIdDetails, but was %@.", [self tagName]];
  }
  return _groupChangeExternalIdDetails;
}

- (DBTEAMLOGGroupChangeManagementTypeDetails *)groupChangeManagementTypeDetails {
  if (![self isGroupChangeManagementTypeDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupChangeManagementTypeDetails, but was %@.",
                       [self tagName]];
  }
  return _groupChangeManagementTypeDetails;
}

- (DBTEAMLOGGroupChangeMemberRoleDetails *)groupChangeMemberRoleDetails {
  if (![self isGroupChangeMemberRoleDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupChangeMemberRoleDetails, but was %@.", [self tagName]];
  }
  return _groupChangeMemberRoleDetails;
}

- (DBTEAMLOGGroupCreateDetails *)groupCreateDetails {
  if (![self isGroupCreateDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupCreateDetails, but was %@.", [self tagName]];
  }
  return _groupCreateDetails;
}

- (DBTEAMLOGGroupDeleteDetails *)groupDeleteDetails {
  if (![self isGroupDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupDeleteDetails, but was %@.", [self tagName]];
  }
  return _groupDeleteDetails;
}

- (DBTEAMLOGGroupDescriptionUpdatedDetails *)groupDescriptionUpdatedDetails {
  if (![self isGroupDescriptionUpdatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupDescriptionUpdatedDetails, but was %@.",
                       [self tagName]];
  }
  return _groupDescriptionUpdatedDetails;
}

- (DBTEAMLOGGroupJoinPolicyUpdatedDetails *)groupJoinPolicyUpdatedDetails {
  if (![self isGroupJoinPolicyUpdatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupJoinPolicyUpdatedDetails, but was %@.",
                       [self tagName]];
  }
  return _groupJoinPolicyUpdatedDetails;
}

- (DBTEAMLOGGroupMovedDetails *)groupMovedDetails {
  if (![self isGroupMovedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupMovedDetails, but was %@.", [self tagName]];
  }
  return _groupMovedDetails;
}

- (DBTEAMLOGGroupRemoveExternalIdDetails *)groupRemoveExternalIdDetails {
  if (![self isGroupRemoveExternalIdDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupRemoveExternalIdDetails, but was %@.", [self tagName]];
  }
  return _groupRemoveExternalIdDetails;
}

- (DBTEAMLOGGroupRemoveMemberDetails *)groupRemoveMemberDetails {
  if (![self isGroupRemoveMemberDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupRemoveMemberDetails, but was %@.", [self tagName]];
  }
  return _groupRemoveMemberDetails;
}

- (DBTEAMLOGGroupRenameDetails *)groupRenameDetails {
  if (![self isGroupRenameDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupRenameDetails, but was %@.", [self tagName]];
  }
  return _groupRenameDetails;
}

- (DBTEAMLOGAccountLockOrUnlockedDetails *)accountLockOrUnlockedDetails {
  if (![self isAccountLockOrUnlockedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountLockOrUnlockedDetails, but was %@.", [self tagName]];
  }
  return _accountLockOrUnlockedDetails;
}

- (DBTEAMLOGEmmErrorDetails *)emmErrorDetails {
  if (![self isEmmErrorDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmErrorDetails, but was %@.", [self tagName]];
  }
  return _emmErrorDetails;
}

- (DBTEAMLOGGuestAdminSignedInViaTrustedTeamsDetails *)guestAdminSignedInViaTrustedTeamsDetails {
  if (![self isGuestAdminSignedInViaTrustedTeamsDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGuestAdminSignedInViaTrustedTeamsDetails, but was %@.",
               [self tagName]];
  }
  return _guestAdminSignedInViaTrustedTeamsDetails;
}

- (DBTEAMLOGGuestAdminSignedOutViaTrustedTeamsDetails *)guestAdminSignedOutViaTrustedTeamsDetails {
  if (![self isGuestAdminSignedOutViaTrustedTeamsDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGuestAdminSignedOutViaTrustedTeamsDetails, but was %@.",
               [self tagName]];
  }
  return _guestAdminSignedOutViaTrustedTeamsDetails;
}

- (DBTEAMLOGLoginFailDetails *)loginFailDetails {
  if (![self isLoginFailDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLoginFailDetails, but was %@.", [self tagName]];
  }
  return _loginFailDetails;
}

- (DBTEAMLOGLoginSuccessDetails *)loginSuccessDetails {
  if (![self isLoginSuccessDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLoginSuccessDetails, but was %@.", [self tagName]];
  }
  return _loginSuccessDetails;
}

- (DBTEAMLOGLogoutDetails *)logoutDetails {
  if (![self isLogoutDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsLogoutDetails, but was %@.", [self tagName]];
  }
  return _logoutDetails;
}

- (DBTEAMLOGResellerSupportSessionEndDetails *)resellerSupportSessionEndDetails {
  if (![self isResellerSupportSessionEndDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsResellerSupportSessionEndDetails, but was %@.",
                       [self tagName]];
  }
  return _resellerSupportSessionEndDetails;
}

- (DBTEAMLOGResellerSupportSessionStartDetails *)resellerSupportSessionStartDetails {
  if (![self isResellerSupportSessionStartDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsResellerSupportSessionStartDetails, but was %@.",
                       [self tagName]];
  }
  return _resellerSupportSessionStartDetails;
}

- (DBTEAMLOGSignInAsSessionEndDetails *)signInAsSessionEndDetails {
  if (![self isSignInAsSessionEndDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSignInAsSessionEndDetails, but was %@.", [self tagName]];
  }
  return _signInAsSessionEndDetails;
}

- (DBTEAMLOGSignInAsSessionStartDetails *)signInAsSessionStartDetails {
  if (![self isSignInAsSessionStartDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSignInAsSessionStartDetails, but was %@.", [self tagName]];
  }
  return _signInAsSessionStartDetails;
}

- (DBTEAMLOGSsoErrorDetails *)ssoErrorDetails {
  if (![self isSsoErrorDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoErrorDetails, but was %@.", [self tagName]];
  }
  return _ssoErrorDetails;
}

- (DBTEAMLOGCreateTeamInviteLinkDetails *)createTeamInviteLinkDetails {
  if (![self isCreateTeamInviteLinkDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsCreateTeamInviteLinkDetails, but was %@.", [self tagName]];
  }
  return _createTeamInviteLinkDetails;
}

- (DBTEAMLOGDeleteTeamInviteLinkDetails *)deleteTeamInviteLinkDetails {
  if (![self isDeleteTeamInviteLinkDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeleteTeamInviteLinkDetails, but was %@.", [self tagName]];
  }
  return _deleteTeamInviteLinkDetails;
}

- (DBTEAMLOGMemberAddExternalIdDetails *)memberAddExternalIdDetails {
  if (![self isMemberAddExternalIdDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberAddExternalIdDetails, but was %@.", [self tagName]];
  }
  return _memberAddExternalIdDetails;
}

- (DBTEAMLOGMemberAddNameDetails *)memberAddNameDetails {
  if (![self isMemberAddNameDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberAddNameDetails, but was %@.", [self tagName]];
  }
  return _memberAddNameDetails;
}

- (DBTEAMLOGMemberChangeAdminRoleDetails *)memberChangeAdminRoleDetails {
  if (![self isMemberChangeAdminRoleDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeAdminRoleDetails, but was %@.", [self tagName]];
  }
  return _memberChangeAdminRoleDetails;
}

- (DBTEAMLOGMemberChangeEmailDetails *)memberChangeEmailDetails {
  if (![self isMemberChangeEmailDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeEmailDetails, but was %@.", [self tagName]];
  }
  return _memberChangeEmailDetails;
}

- (DBTEAMLOGMemberChangeExternalIdDetails *)memberChangeExternalIdDetails {
  if (![self isMemberChangeExternalIdDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeExternalIdDetails, but was %@.",
                       [self tagName]];
  }
  return _memberChangeExternalIdDetails;
}

- (DBTEAMLOGMemberChangeMembershipTypeDetails *)memberChangeMembershipTypeDetails {
  if (![self isMemberChangeMembershipTypeDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeMembershipTypeDetails, but was %@.",
                       [self tagName]];
  }
  return _memberChangeMembershipTypeDetails;
}

- (DBTEAMLOGMemberChangeNameDetails *)memberChangeNameDetails {
  if (![self isMemberChangeNameDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeNameDetails, but was %@.", [self tagName]];
  }
  return _memberChangeNameDetails;
}

- (DBTEAMLOGMemberChangeResellerRoleDetails *)memberChangeResellerRoleDetails {
  if (![self isMemberChangeResellerRoleDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeResellerRoleDetails, but was %@.",
                       [self tagName]];
  }
  return _memberChangeResellerRoleDetails;
}

- (DBTEAMLOGMemberChangeStatusDetails *)memberChangeStatusDetails {
  if (![self isMemberChangeStatusDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberChangeStatusDetails, but was %@.", [self tagName]];
  }
  return _memberChangeStatusDetails;
}

- (DBTEAMLOGMemberDeleteManualContactsDetails *)memberDeleteManualContactsDetails {
  if (![self isMemberDeleteManualContactsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberDeleteManualContactsDetails, but was %@.",
                       [self tagName]];
  }
  return _memberDeleteManualContactsDetails;
}

- (DBTEAMLOGMemberDeleteProfilePhotoDetails *)memberDeleteProfilePhotoDetails {
  if (![self isMemberDeleteProfilePhotoDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberDeleteProfilePhotoDetails, but was %@.",
                       [self tagName]];
  }
  return _memberDeleteProfilePhotoDetails;
}

- (DBTEAMLOGMemberPermanentlyDeleteAccountContentsDetails *)memberPermanentlyDeleteAccountContentsDetails {
  if (![self isMemberPermanentlyDeleteAccountContentsDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberPermanentlyDeleteAccountContentsDetails, but was %@.",
               [self tagName]];
  }
  return _memberPermanentlyDeleteAccountContentsDetails;
}

- (DBTEAMLOGMemberRemoveExternalIdDetails *)memberRemoveExternalIdDetails {
  if (![self isMemberRemoveExternalIdDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberRemoveExternalIdDetails, but was %@.",
                       [self tagName]];
  }
  return _memberRemoveExternalIdDetails;
}

- (DBTEAMLOGMemberSetProfilePhotoDetails *)memberSetProfilePhotoDetails {
  if (![self isMemberSetProfilePhotoDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSetProfilePhotoDetails, but was %@.", [self tagName]];
  }
  return _memberSetProfilePhotoDetails;
}

- (DBTEAMLOGMemberSpaceLimitsAddCustomQuotaDetails *)memberSpaceLimitsAddCustomQuotaDetails {
  if (![self isMemberSpaceLimitsAddCustomQuotaDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsAddCustomQuotaDetails, but was %@.",
               [self tagName]];
  }
  return _memberSpaceLimitsAddCustomQuotaDetails;
}

- (DBTEAMLOGMemberSpaceLimitsChangeCustomQuotaDetails *)memberSpaceLimitsChangeCustomQuotaDetails {
  if (![self isMemberSpaceLimitsChangeCustomQuotaDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsChangeCustomQuotaDetails, but was %@.",
               [self tagName]];
  }
  return _memberSpaceLimitsChangeCustomQuotaDetails;
}

- (DBTEAMLOGMemberSpaceLimitsChangeStatusDetails *)memberSpaceLimitsChangeStatusDetails {
  if (![self isMemberSpaceLimitsChangeStatusDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsChangeStatusDetails, but was %@.",
                       [self tagName]];
  }
  return _memberSpaceLimitsChangeStatusDetails;
}

- (DBTEAMLOGMemberSpaceLimitsRemoveCustomQuotaDetails *)memberSpaceLimitsRemoveCustomQuotaDetails {
  if (![self isMemberSpaceLimitsRemoveCustomQuotaDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsRemoveCustomQuotaDetails, but was %@.",
               [self tagName]];
  }
  return _memberSpaceLimitsRemoveCustomQuotaDetails;
}

- (DBTEAMLOGMemberSuggestDetails *)memberSuggestDetails {
  if (![self isMemberSuggestDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSuggestDetails, but was %@.", [self tagName]];
  }
  return _memberSuggestDetails;
}

- (DBTEAMLOGMemberTransferAccountContentsDetails *)memberTransferAccountContentsDetails {
  if (![self isMemberTransferAccountContentsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberTransferAccountContentsDetails, but was %@.",
                       [self tagName]];
  }
  return _memberTransferAccountContentsDetails;
}

- (DBTEAMLOGPendingSecondaryEmailAddedDetails *)pendingSecondaryEmailAddedDetails {
  if (![self isPendingSecondaryEmailAddedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPendingSecondaryEmailAddedDetails, but was %@.",
                       [self tagName]];
  }
  return _pendingSecondaryEmailAddedDetails;
}

- (DBTEAMLOGSecondaryEmailDeletedDetails *)secondaryEmailDeletedDetails {
  if (![self isSecondaryEmailDeletedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSecondaryEmailDeletedDetails, but was %@.", [self tagName]];
  }
  return _secondaryEmailDeletedDetails;
}

- (DBTEAMLOGSecondaryEmailVerifiedDetails *)secondaryEmailVerifiedDetails {
  if (![self isSecondaryEmailVerifiedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSecondaryEmailVerifiedDetails, but was %@.",
                       [self tagName]];
  }
  return _secondaryEmailVerifiedDetails;
}

- (DBTEAMLOGSecondaryMailsPolicyChangedDetails *)secondaryMailsPolicyChangedDetails {
  if (![self isSecondaryMailsPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSecondaryMailsPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _secondaryMailsPolicyChangedDetails;
}

- (DBTEAMLOGBinderAddPageDetails *)binderAddPageDetails {
  if (![self isBinderAddPageDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderAddPageDetails, but was %@.", [self tagName]];
  }
  return _binderAddPageDetails;
}

- (DBTEAMLOGBinderAddSectionDetails *)binderAddSectionDetails {
  if (![self isBinderAddSectionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderAddSectionDetails, but was %@.", [self tagName]];
  }
  return _binderAddSectionDetails;
}

- (DBTEAMLOGBinderRemovePageDetails *)binderRemovePageDetails {
  if (![self isBinderRemovePageDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderRemovePageDetails, but was %@.", [self tagName]];
  }
  return _binderRemovePageDetails;
}

- (DBTEAMLOGBinderRemoveSectionDetails *)binderRemoveSectionDetails {
  if (![self isBinderRemoveSectionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderRemoveSectionDetails, but was %@.", [self tagName]];
  }
  return _binderRemoveSectionDetails;
}

- (DBTEAMLOGBinderRenamePageDetails *)binderRenamePageDetails {
  if (![self isBinderRenamePageDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderRenamePageDetails, but was %@.", [self tagName]];
  }
  return _binderRenamePageDetails;
}

- (DBTEAMLOGBinderRenameSectionDetails *)binderRenameSectionDetails {
  if (![self isBinderRenameSectionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderRenameSectionDetails, but was %@.", [self tagName]];
  }
  return _binderRenameSectionDetails;
}

- (DBTEAMLOGBinderReorderPageDetails *)binderReorderPageDetails {
  if (![self isBinderReorderPageDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderReorderPageDetails, but was %@.", [self tagName]];
  }
  return _binderReorderPageDetails;
}

- (DBTEAMLOGBinderReorderSectionDetails *)binderReorderSectionDetails {
  if (![self isBinderReorderSectionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsBinderReorderSectionDetails, but was %@.", [self tagName]];
  }
  return _binderReorderSectionDetails;
}

- (DBTEAMLOGPaperContentAddMemberDetails *)paperContentAddMemberDetails {
  if (![self isPaperContentAddMemberDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentAddMemberDetails, but was %@.", [self tagName]];
  }
  return _paperContentAddMemberDetails;
}

- (DBTEAMLOGPaperContentAddToFolderDetails *)paperContentAddToFolderDetails {
  if (![self isPaperContentAddToFolderDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentAddToFolderDetails, but was %@.",
                       [self tagName]];
  }
  return _paperContentAddToFolderDetails;
}

- (DBTEAMLOGPaperContentArchiveDetails *)paperContentArchiveDetails {
  if (![self isPaperContentArchiveDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentArchiveDetails, but was %@.", [self tagName]];
  }
  return _paperContentArchiveDetails;
}

- (DBTEAMLOGPaperContentCreateDetails *)paperContentCreateDetails {
  if (![self isPaperContentCreateDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentCreateDetails, but was %@.", [self tagName]];
  }
  return _paperContentCreateDetails;
}

- (DBTEAMLOGPaperContentPermanentlyDeleteDetails *)paperContentPermanentlyDeleteDetails {
  if (![self isPaperContentPermanentlyDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentPermanentlyDeleteDetails, but was %@.",
                       [self tagName]];
  }
  return _paperContentPermanentlyDeleteDetails;
}

- (DBTEAMLOGPaperContentRemoveFromFolderDetails *)paperContentRemoveFromFolderDetails {
  if (![self isPaperContentRemoveFromFolderDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentRemoveFromFolderDetails, but was %@.",
                       [self tagName]];
  }
  return _paperContentRemoveFromFolderDetails;
}

- (DBTEAMLOGPaperContentRemoveMemberDetails *)paperContentRemoveMemberDetails {
  if (![self isPaperContentRemoveMemberDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentRemoveMemberDetails, but was %@.",
                       [self tagName]];
  }
  return _paperContentRemoveMemberDetails;
}

- (DBTEAMLOGPaperContentRenameDetails *)paperContentRenameDetails {
  if (![self isPaperContentRenameDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentRenameDetails, but was %@.", [self tagName]];
  }
  return _paperContentRenameDetails;
}

- (DBTEAMLOGPaperContentRestoreDetails *)paperContentRestoreDetails {
  if (![self isPaperContentRestoreDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperContentRestoreDetails, but was %@.", [self tagName]];
  }
  return _paperContentRestoreDetails;
}

- (DBTEAMLOGPaperDocAddCommentDetails *)paperDocAddCommentDetails {
  if (![self isPaperDocAddCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocAddCommentDetails, but was %@.", [self tagName]];
  }
  return _paperDocAddCommentDetails;
}

- (DBTEAMLOGPaperDocChangeMemberRoleDetails *)paperDocChangeMemberRoleDetails {
  if (![self isPaperDocChangeMemberRoleDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocChangeMemberRoleDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocChangeMemberRoleDetails;
}

- (DBTEAMLOGPaperDocChangeSharingPolicyDetails *)paperDocChangeSharingPolicyDetails {
  if (![self isPaperDocChangeSharingPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocChangeSharingPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocChangeSharingPolicyDetails;
}

- (DBTEAMLOGPaperDocChangeSubscriptionDetails *)paperDocChangeSubscriptionDetails {
  if (![self isPaperDocChangeSubscriptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocChangeSubscriptionDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocChangeSubscriptionDetails;
}

- (DBTEAMLOGPaperDocDeletedDetails *)paperDocDeletedDetails {
  if (![self isPaperDocDeletedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocDeletedDetails, but was %@.", [self tagName]];
  }
  return _paperDocDeletedDetails;
}

- (DBTEAMLOGPaperDocDeleteCommentDetails *)paperDocDeleteCommentDetails {
  if (![self isPaperDocDeleteCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocDeleteCommentDetails, but was %@.", [self tagName]];
  }
  return _paperDocDeleteCommentDetails;
}

- (DBTEAMLOGPaperDocDownloadDetails *)paperDocDownloadDetails {
  if (![self isPaperDocDownloadDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocDownloadDetails, but was %@.", [self tagName]];
  }
  return _paperDocDownloadDetails;
}

- (DBTEAMLOGPaperDocEditDetails *)paperDocEditDetails {
  if (![self isPaperDocEditDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocEditDetails, but was %@.", [self tagName]];
  }
  return _paperDocEditDetails;
}

- (DBTEAMLOGPaperDocEditCommentDetails *)paperDocEditCommentDetails {
  if (![self isPaperDocEditCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocEditCommentDetails, but was %@.", [self tagName]];
  }
  return _paperDocEditCommentDetails;
}

- (DBTEAMLOGPaperDocFollowedDetails *)paperDocFollowedDetails {
  if (![self isPaperDocFollowedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocFollowedDetails, but was %@.", [self tagName]];
  }
  return _paperDocFollowedDetails;
}

- (DBTEAMLOGPaperDocMentionDetails *)paperDocMentionDetails {
  if (![self isPaperDocMentionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocMentionDetails, but was %@.", [self tagName]];
  }
  return _paperDocMentionDetails;
}

- (DBTEAMLOGPaperDocOwnershipChangedDetails *)paperDocOwnershipChangedDetails {
  if (![self isPaperDocOwnershipChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocOwnershipChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocOwnershipChangedDetails;
}

- (DBTEAMLOGPaperDocRequestAccessDetails *)paperDocRequestAccessDetails {
  if (![self isPaperDocRequestAccessDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocRequestAccessDetails, but was %@.", [self tagName]];
  }
  return _paperDocRequestAccessDetails;
}

- (DBTEAMLOGPaperDocResolveCommentDetails *)paperDocResolveCommentDetails {
  if (![self isPaperDocResolveCommentDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocResolveCommentDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocResolveCommentDetails;
}

- (DBTEAMLOGPaperDocRevertDetails *)paperDocRevertDetails {
  if (![self isPaperDocRevertDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocRevertDetails, but was %@.", [self tagName]];
  }
  return _paperDocRevertDetails;
}

- (DBTEAMLOGPaperDocSlackShareDetails *)paperDocSlackShareDetails {
  if (![self isPaperDocSlackShareDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocSlackShareDetails, but was %@.", [self tagName]];
  }
  return _paperDocSlackShareDetails;
}

- (DBTEAMLOGPaperDocTeamInviteDetails *)paperDocTeamInviteDetails {
  if (![self isPaperDocTeamInviteDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocTeamInviteDetails, but was %@.", [self tagName]];
  }
  return _paperDocTeamInviteDetails;
}

- (DBTEAMLOGPaperDocTrashedDetails *)paperDocTrashedDetails {
  if (![self isPaperDocTrashedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocTrashedDetails, but was %@.", [self tagName]];
  }
  return _paperDocTrashedDetails;
}

- (DBTEAMLOGPaperDocUnresolveCommentDetails *)paperDocUnresolveCommentDetails {
  if (![self isPaperDocUnresolveCommentDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocUnresolveCommentDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDocUnresolveCommentDetails;
}

- (DBTEAMLOGPaperDocUntrashedDetails *)paperDocUntrashedDetails {
  if (![self isPaperDocUntrashedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocUntrashedDetails, but was %@.", [self tagName]];
  }
  return _paperDocUntrashedDetails;
}

- (DBTEAMLOGPaperDocViewDetails *)paperDocViewDetails {
  if (![self isPaperDocViewDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDocViewDetails, but was %@.", [self tagName]];
  }
  return _paperDocViewDetails;
}

- (DBTEAMLOGPaperExternalViewAllowDetails *)paperExternalViewAllowDetails {
  if (![self isPaperExternalViewAllowDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperExternalViewAllowDetails, but was %@.",
                       [self tagName]];
  }
  return _paperExternalViewAllowDetails;
}

- (DBTEAMLOGPaperExternalViewDefaultTeamDetails *)paperExternalViewDefaultTeamDetails {
  if (![self isPaperExternalViewDefaultTeamDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperExternalViewDefaultTeamDetails, but was %@.",
                       [self tagName]];
  }
  return _paperExternalViewDefaultTeamDetails;
}

- (DBTEAMLOGPaperExternalViewForbidDetails *)paperExternalViewForbidDetails {
  if (![self isPaperExternalViewForbidDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperExternalViewForbidDetails, but was %@.",
                       [self tagName]];
  }
  return _paperExternalViewForbidDetails;
}

- (DBTEAMLOGPaperFolderChangeSubscriptionDetails *)paperFolderChangeSubscriptionDetails {
  if (![self isPaperFolderChangeSubscriptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperFolderChangeSubscriptionDetails, but was %@.",
                       [self tagName]];
  }
  return _paperFolderChangeSubscriptionDetails;
}

- (DBTEAMLOGPaperFolderDeletedDetails *)paperFolderDeletedDetails {
  if (![self isPaperFolderDeletedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperFolderDeletedDetails, but was %@.", [self tagName]];
  }
  return _paperFolderDeletedDetails;
}

- (DBTEAMLOGPaperFolderFollowedDetails *)paperFolderFollowedDetails {
  if (![self isPaperFolderFollowedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperFolderFollowedDetails, but was %@.", [self tagName]];
  }
  return _paperFolderFollowedDetails;
}

- (DBTEAMLOGPaperFolderTeamInviteDetails *)paperFolderTeamInviteDetails {
  if (![self isPaperFolderTeamInviteDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperFolderTeamInviteDetails, but was %@.", [self tagName]];
  }
  return _paperFolderTeamInviteDetails;
}

- (DBTEAMLOGPaperPublishedLinkChangePermissionDetails *)paperPublishedLinkChangePermissionDetails {
  if (![self isPaperPublishedLinkChangePermissionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperPublishedLinkChangePermissionDetails, but was %@.",
               [self tagName]];
  }
  return _paperPublishedLinkChangePermissionDetails;
}

- (DBTEAMLOGPaperPublishedLinkCreateDetails *)paperPublishedLinkCreateDetails {
  if (![self isPaperPublishedLinkCreateDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperPublishedLinkCreateDetails, but was %@.",
                       [self tagName]];
  }
  return _paperPublishedLinkCreateDetails;
}

- (DBTEAMLOGPaperPublishedLinkDisabledDetails *)paperPublishedLinkDisabledDetails {
  if (![self isPaperPublishedLinkDisabledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperPublishedLinkDisabledDetails, but was %@.",
                       [self tagName]];
  }
  return _paperPublishedLinkDisabledDetails;
}

- (DBTEAMLOGPaperPublishedLinkViewDetails *)paperPublishedLinkViewDetails {
  if (![self isPaperPublishedLinkViewDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperPublishedLinkViewDetails, but was %@.",
                       [self tagName]];
  }
  return _paperPublishedLinkViewDetails;
}

- (DBTEAMLOGPasswordChangeDetails *)passwordChangeDetails {
  if (![self isPasswordChangeDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPasswordChangeDetails, but was %@.", [self tagName]];
  }
  return _passwordChangeDetails;
}

- (DBTEAMLOGPasswordResetDetails *)passwordResetDetails {
  if (![self isPasswordResetDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPasswordResetDetails, but was %@.", [self tagName]];
  }
  return _passwordResetDetails;
}

- (DBTEAMLOGPasswordResetAllDetails *)passwordResetAllDetails {
  if (![self isPasswordResetAllDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPasswordResetAllDetails, but was %@.", [self tagName]];
  }
  return _passwordResetAllDetails;
}

- (DBTEAMLOGClassificationCreateReportDetails *)classificationCreateReportDetails {
  if (![self isClassificationCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsClassificationCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _classificationCreateReportDetails;
}

- (DBTEAMLOGClassificationCreateReportFailDetails *)classificationCreateReportFailDetails {
  if (![self isClassificationCreateReportFailDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsClassificationCreateReportFailDetails, but was %@.",
                       [self tagName]];
  }
  return _classificationCreateReportFailDetails;
}

- (DBTEAMLOGEmmCreateExceptionsReportDetails *)emmCreateExceptionsReportDetails {
  if (![self isEmmCreateExceptionsReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmCreateExceptionsReportDetails, but was %@.",
                       [self tagName]];
  }
  return _emmCreateExceptionsReportDetails;
}

- (DBTEAMLOGEmmCreateUsageReportDetails *)emmCreateUsageReportDetails {
  if (![self isEmmCreateUsageReportDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmCreateUsageReportDetails, but was %@.", [self tagName]];
  }
  return _emmCreateUsageReportDetails;
}

- (DBTEAMLOGExportMembersReportDetails *)exportMembersReportDetails {
  if (![self isExportMembersReportDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsExportMembersReportDetails, but was %@.", [self tagName]];
  }
  return _exportMembersReportDetails;
}

- (DBTEAMLOGExportMembersReportFailDetails *)exportMembersReportFailDetails {
  if (![self isExportMembersReportFailDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsExportMembersReportFailDetails, but was %@.",
                       [self tagName]];
  }
  return _exportMembersReportFailDetails;
}

- (DBTEAMLOGExternalSharingCreateReportDetails *)externalSharingCreateReportDetails {
  if (![self isExternalSharingCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsExternalSharingCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _externalSharingCreateReportDetails;
}

- (DBTEAMLOGExternalSharingReportFailedDetails *)externalSharingReportFailedDetails {
  if (![self isExternalSharingReportFailedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsExternalSharingReportFailedDetails, but was %@.",
                       [self tagName]];
  }
  return _externalSharingReportFailedDetails;
}

- (DBTEAMLOGNoExpirationLinkGenCreateReportDetails *)noExpirationLinkGenCreateReportDetails {
  if (![self isNoExpirationLinkGenCreateReportDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsNoExpirationLinkGenCreateReportDetails, but was %@.",
               [self tagName]];
  }
  return _noExpirationLinkGenCreateReportDetails;
}

- (DBTEAMLOGNoExpirationLinkGenReportFailedDetails *)noExpirationLinkGenReportFailedDetails {
  if (![self isNoExpirationLinkGenReportFailedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsNoExpirationLinkGenReportFailedDetails, but was %@.",
               [self tagName]];
  }
  return _noExpirationLinkGenReportFailedDetails;
}

- (DBTEAMLOGNoPasswordLinkGenCreateReportDetails *)noPasswordLinkGenCreateReportDetails {
  if (![self isNoPasswordLinkGenCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoPasswordLinkGenCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _noPasswordLinkGenCreateReportDetails;
}

- (DBTEAMLOGNoPasswordLinkGenReportFailedDetails *)noPasswordLinkGenReportFailedDetails {
  if (![self isNoPasswordLinkGenReportFailedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoPasswordLinkGenReportFailedDetails, but was %@.",
                       [self tagName]];
  }
  return _noPasswordLinkGenReportFailedDetails;
}

- (DBTEAMLOGNoPasswordLinkViewCreateReportDetails *)noPasswordLinkViewCreateReportDetails {
  if (![self isNoPasswordLinkViewCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoPasswordLinkViewCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _noPasswordLinkViewCreateReportDetails;
}

- (DBTEAMLOGNoPasswordLinkViewReportFailedDetails *)noPasswordLinkViewReportFailedDetails {
  if (![self isNoPasswordLinkViewReportFailedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoPasswordLinkViewReportFailedDetails, but was %@.",
                       [self tagName]];
  }
  return _noPasswordLinkViewReportFailedDetails;
}

- (DBTEAMLOGOutdatedLinkViewCreateReportDetails *)outdatedLinkViewCreateReportDetails {
  if (![self isOutdatedLinkViewCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsOutdatedLinkViewCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _outdatedLinkViewCreateReportDetails;
}

- (DBTEAMLOGOutdatedLinkViewReportFailedDetails *)outdatedLinkViewReportFailedDetails {
  if (![self isOutdatedLinkViewReportFailedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsOutdatedLinkViewReportFailedDetails, but was %@.",
                       [self tagName]];
  }
  return _outdatedLinkViewReportFailedDetails;
}

- (DBTEAMLOGPaperAdminExportStartDetails *)paperAdminExportStartDetails {
  if (![self isPaperAdminExportStartDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperAdminExportStartDetails, but was %@.", [self tagName]];
  }
  return _paperAdminExportStartDetails;
}

- (DBTEAMLOGSmartSyncCreateAdminPrivilegeReportDetails *)smartSyncCreateAdminPrivilegeReportDetails {
  if (![self isSmartSyncCreateAdminPrivilegeReportDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSmartSyncCreateAdminPrivilegeReportDetails, but was %@.",
               [self tagName]];
  }
  return _smartSyncCreateAdminPrivilegeReportDetails;
}

- (DBTEAMLOGTeamActivityCreateReportDetails *)teamActivityCreateReportDetails {
  if (![self isTeamActivityCreateReportDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamActivityCreateReportDetails, but was %@.",
                       [self tagName]];
  }
  return _teamActivityCreateReportDetails;
}

- (DBTEAMLOGTeamActivityCreateReportFailDetails *)teamActivityCreateReportFailDetails {
  if (![self isTeamActivityCreateReportFailDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamActivityCreateReportFailDetails, but was %@.",
                       [self tagName]];
  }
  return _teamActivityCreateReportFailDetails;
}

- (DBTEAMLOGCollectionShareDetails *)collectionShareDetails {
  if (![self isCollectionShareDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsCollectionShareDetails, but was %@.", [self tagName]];
  }
  return _collectionShareDetails;
}

- (DBTEAMLOGFileTransfersFileAddDetails *)fileTransfersFileAddDetails {
  if (![self isFileTransfersFileAddDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersFileAddDetails, but was %@.", [self tagName]];
  }
  return _fileTransfersFileAddDetails;
}

- (DBTEAMLOGFileTransfersTransferDeleteDetails *)fileTransfersTransferDeleteDetails {
  if (![self isFileTransfersTransferDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersTransferDeleteDetails, but was %@.",
                       [self tagName]];
  }
  return _fileTransfersTransferDeleteDetails;
}

- (DBTEAMLOGFileTransfersTransferDownloadDetails *)fileTransfersTransferDownloadDetails {
  if (![self isFileTransfersTransferDownloadDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersTransferDownloadDetails, but was %@.",
                       [self tagName]];
  }
  return _fileTransfersTransferDownloadDetails;
}

- (DBTEAMLOGFileTransfersTransferSendDetails *)fileTransfersTransferSendDetails {
  if (![self isFileTransfersTransferSendDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersTransferSendDetails, but was %@.",
                       [self tagName]];
  }
  return _fileTransfersTransferSendDetails;
}

- (DBTEAMLOGFileTransfersTransferViewDetails *)fileTransfersTransferViewDetails {
  if (![self isFileTransfersTransferViewDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersTransferViewDetails, but was %@.",
                       [self tagName]];
  }
  return _fileTransfersTransferViewDetails;
}

- (DBTEAMLOGNoteAclInviteOnlyDetails *)noteAclInviteOnlyDetails {
  if (![self isNoteAclInviteOnlyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsNoteAclInviteOnlyDetails, but was %@.", [self tagName]];
  }
  return _noteAclInviteOnlyDetails;
}

- (DBTEAMLOGNoteAclLinkDetails *)noteAclLinkDetails {
  if (![self isNoteAclLinkDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoteAclLinkDetails, but was %@.", [self tagName]];
  }
  return _noteAclLinkDetails;
}

- (DBTEAMLOGNoteAclTeamLinkDetails *)noteAclTeamLinkDetails {
  if (![self isNoteAclTeamLinkDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsNoteAclTeamLinkDetails, but was %@.", [self tagName]];
  }
  return _noteAclTeamLinkDetails;
}

- (DBTEAMLOGNoteSharedDetails *)noteSharedDetails {
  if (![self isNoteSharedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNoteSharedDetails, but was %@.", [self tagName]];
  }
  return _noteSharedDetails;
}

- (DBTEAMLOGNoteShareReceiveDetails *)noteShareReceiveDetails {
  if (![self isNoteShareReceiveDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsNoteShareReceiveDetails, but was %@.", [self tagName]];
  }
  return _noteShareReceiveDetails;
}

- (DBTEAMLOGOpenNoteSharedDetails *)openNoteSharedDetails {
  if (![self isOpenNoteSharedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsOpenNoteSharedDetails, but was %@.", [self tagName]];
  }
  return _openNoteSharedDetails;
}

- (DBTEAMLOGSfAddGroupDetails *)sfAddGroupDetails {
  if (![self isSfAddGroupDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfAddGroupDetails, but was %@.", [self tagName]];
  }
  return _sfAddGroupDetails;
}

- (DBTEAMLOGSfAllowNonMembersToViewSharedLinksDetails *)sfAllowNonMembersToViewSharedLinksDetails {
  if (![self isSfAllowNonMembersToViewSharedLinksDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfAllowNonMembersToViewSharedLinksDetails, but was %@.",
               [self tagName]];
  }
  return _sfAllowNonMembersToViewSharedLinksDetails;
}

- (DBTEAMLOGSfExternalInviteWarnDetails *)sfExternalInviteWarnDetails {
  if (![self isSfExternalInviteWarnDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfExternalInviteWarnDetails, but was %@.", [self tagName]];
  }
  return _sfExternalInviteWarnDetails;
}

- (DBTEAMLOGSfFbInviteDetails *)sfFbInviteDetails {
  if (![self isSfFbInviteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfFbInviteDetails, but was %@.", [self tagName]];
  }
  return _sfFbInviteDetails;
}

- (DBTEAMLOGSfFbInviteChangeRoleDetails *)sfFbInviteChangeRoleDetails {
  if (![self isSfFbInviteChangeRoleDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfFbInviteChangeRoleDetails, but was %@.", [self tagName]];
  }
  return _sfFbInviteChangeRoleDetails;
}

- (DBTEAMLOGSfFbUninviteDetails *)sfFbUninviteDetails {
  if (![self isSfFbUninviteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfFbUninviteDetails, but was %@.", [self tagName]];
  }
  return _sfFbUninviteDetails;
}

- (DBTEAMLOGSfInviteGroupDetails *)sfInviteGroupDetails {
  if (![self isSfInviteGroupDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfInviteGroupDetails, but was %@.", [self tagName]];
  }
  return _sfInviteGroupDetails;
}

- (DBTEAMLOGSfTeamGrantAccessDetails *)sfTeamGrantAccessDetails {
  if (![self isSfTeamGrantAccessDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamGrantAccessDetails, but was %@.", [self tagName]];
  }
  return _sfTeamGrantAccessDetails;
}

- (DBTEAMLOGSfTeamInviteDetails *)sfTeamInviteDetails {
  if (![self isSfTeamInviteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamInviteDetails, but was %@.", [self tagName]];
  }
  return _sfTeamInviteDetails;
}

- (DBTEAMLOGSfTeamInviteChangeRoleDetails *)sfTeamInviteChangeRoleDetails {
  if (![self isSfTeamInviteChangeRoleDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamInviteChangeRoleDetails, but was %@.",
                       [self tagName]];
  }
  return _sfTeamInviteChangeRoleDetails;
}

- (DBTEAMLOGSfTeamJoinDetails *)sfTeamJoinDetails {
  if (![self isSfTeamJoinDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamJoinDetails, but was %@.", [self tagName]];
  }
  return _sfTeamJoinDetails;
}

- (DBTEAMLOGSfTeamJoinFromOobLinkDetails *)sfTeamJoinFromOobLinkDetails {
  if (![self isSfTeamJoinFromOobLinkDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamJoinFromOobLinkDetails, but was %@.", [self tagName]];
  }
  return _sfTeamJoinFromOobLinkDetails;
}

- (DBTEAMLOGSfTeamUninviteDetails *)sfTeamUninviteDetails {
  if (![self isSfTeamUninviteDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSfTeamUninviteDetails, but was %@.", [self tagName]];
  }
  return _sfTeamUninviteDetails;
}

- (DBTEAMLOGSharedContentAddInviteesDetails *)sharedContentAddInviteesDetails {
  if (![self isSharedContentAddInviteesDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentAddInviteesDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentAddInviteesDetails;
}

- (DBTEAMLOGSharedContentAddLinkExpiryDetails *)sharedContentAddLinkExpiryDetails {
  if (![self isSharedContentAddLinkExpiryDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentAddLinkExpiryDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentAddLinkExpiryDetails;
}

- (DBTEAMLOGSharedContentAddLinkPasswordDetails *)sharedContentAddLinkPasswordDetails {
  if (![self isSharedContentAddLinkPasswordDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentAddLinkPasswordDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentAddLinkPasswordDetails;
}

- (DBTEAMLOGSharedContentAddMemberDetails *)sharedContentAddMemberDetails {
  if (![self isSharedContentAddMemberDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentAddMemberDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentAddMemberDetails;
}

- (DBTEAMLOGSharedContentChangeDownloadsPolicyDetails *)sharedContentChangeDownloadsPolicyDetails {
  if (![self isSharedContentChangeDownloadsPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeDownloadsPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentChangeDownloadsPolicyDetails;
}

- (DBTEAMLOGSharedContentChangeInviteeRoleDetails *)sharedContentChangeInviteeRoleDetails {
  if (![self isSharedContentChangeInviteeRoleDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeInviteeRoleDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentChangeInviteeRoleDetails;
}

- (DBTEAMLOGSharedContentChangeLinkAudienceDetails *)sharedContentChangeLinkAudienceDetails {
  if (![self isSharedContentChangeLinkAudienceDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeLinkAudienceDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentChangeLinkAudienceDetails;
}

- (DBTEAMLOGSharedContentChangeLinkExpiryDetails *)sharedContentChangeLinkExpiryDetails {
  if (![self isSharedContentChangeLinkExpiryDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeLinkExpiryDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentChangeLinkExpiryDetails;
}

- (DBTEAMLOGSharedContentChangeLinkPasswordDetails *)sharedContentChangeLinkPasswordDetails {
  if (![self isSharedContentChangeLinkPasswordDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeLinkPasswordDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentChangeLinkPasswordDetails;
}

- (DBTEAMLOGSharedContentChangeMemberRoleDetails *)sharedContentChangeMemberRoleDetails {
  if (![self isSharedContentChangeMemberRoleDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeMemberRoleDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentChangeMemberRoleDetails;
}

- (DBTEAMLOGSharedContentChangeViewerInfoPolicyDetails *)sharedContentChangeViewerInfoPolicyDetails {
  if (![self isSharedContentChangeViewerInfoPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentChangeViewerInfoPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentChangeViewerInfoPolicyDetails;
}

- (DBTEAMLOGSharedContentClaimInvitationDetails *)sharedContentClaimInvitationDetails {
  if (![self isSharedContentClaimInvitationDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentClaimInvitationDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentClaimInvitationDetails;
}

- (DBTEAMLOGSharedContentCopyDetails *)sharedContentCopyDetails {
  if (![self isSharedContentCopyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentCopyDetails, but was %@.", [self tagName]];
  }
  return _sharedContentCopyDetails;
}

- (DBTEAMLOGSharedContentDownloadDetails *)sharedContentDownloadDetails {
  if (![self isSharedContentDownloadDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentDownloadDetails, but was %@.", [self tagName]];
  }
  return _sharedContentDownloadDetails;
}

- (DBTEAMLOGSharedContentRelinquishMembershipDetails *)sharedContentRelinquishMembershipDetails {
  if (![self isSharedContentRelinquishMembershipDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRelinquishMembershipDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentRelinquishMembershipDetails;
}

- (DBTEAMLOGSharedContentRemoveInviteesDetails *)sharedContentRemoveInviteesDetails {
  if (![self isSharedContentRemoveInviteesDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRemoveInviteesDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRemoveInviteesDetails;
}

- (DBTEAMLOGSharedContentRemoveLinkExpiryDetails *)sharedContentRemoveLinkExpiryDetails {
  if (![self isSharedContentRemoveLinkExpiryDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRemoveLinkExpiryDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRemoveLinkExpiryDetails;
}

- (DBTEAMLOGSharedContentRemoveLinkPasswordDetails *)sharedContentRemoveLinkPasswordDetails {
  if (![self isSharedContentRemoveLinkPasswordDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRemoveLinkPasswordDetails, but was %@.",
               [self tagName]];
  }
  return _sharedContentRemoveLinkPasswordDetails;
}

- (DBTEAMLOGSharedContentRemoveMemberDetails *)sharedContentRemoveMemberDetails {
  if (![self isSharedContentRemoveMemberDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRemoveMemberDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRemoveMemberDetails;
}

- (DBTEAMLOGSharedContentRequestAccessDetails *)sharedContentRequestAccessDetails {
  if (![self isSharedContentRequestAccessDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRequestAccessDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRequestAccessDetails;
}

- (DBTEAMLOGSharedContentRestoreInviteesDetails *)sharedContentRestoreInviteesDetails {
  if (![self isSharedContentRestoreInviteesDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRestoreInviteesDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRestoreInviteesDetails;
}

- (DBTEAMLOGSharedContentRestoreMemberDetails *)sharedContentRestoreMemberDetails {
  if (![self isSharedContentRestoreMemberDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentRestoreMemberDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedContentRestoreMemberDetails;
}

- (DBTEAMLOGSharedContentUnshareDetails *)sharedContentUnshareDetails {
  if (![self isSharedContentUnshareDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentUnshareDetails, but was %@.", [self tagName]];
  }
  return _sharedContentUnshareDetails;
}

- (DBTEAMLOGSharedContentViewDetails *)sharedContentViewDetails {
  if (![self isSharedContentViewDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedContentViewDetails, but was %@.", [self tagName]];
  }
  return _sharedContentViewDetails;
}

- (DBTEAMLOGSharedFolderChangeLinkPolicyDetails *)sharedFolderChangeLinkPolicyDetails {
  if (![self isSharedFolderChangeLinkPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderChangeLinkPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedFolderChangeLinkPolicyDetails;
}

- (DBTEAMLOGSharedFolderChangeMembersInheritancePolicyDetails *)sharedFolderChangeMembersInheritancePolicyDetails {
  if (![self isSharedFolderChangeMembersInheritancePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderChangeMembersInheritancePolicyDetails, "
                       @"but was %@.",
                       [self tagName]];
  }
  return _sharedFolderChangeMembersInheritancePolicyDetails;
}

- (DBTEAMLOGSharedFolderChangeMembersManagementPolicyDetails *)sharedFolderChangeMembersManagementPolicyDetails {
  if (![self isSharedFolderChangeMembersManagementPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderChangeMembersManagementPolicyDetails, "
                       @"but was %@.",
                       [self tagName]];
  }
  return _sharedFolderChangeMembersManagementPolicyDetails;
}

- (DBTEAMLOGSharedFolderChangeMembersPolicyDetails *)sharedFolderChangeMembersPolicyDetails {
  if (![self isSharedFolderChangeMembersPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderChangeMembersPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _sharedFolderChangeMembersPolicyDetails;
}

- (DBTEAMLOGSharedFolderCreateDetails *)sharedFolderCreateDetails {
  if (![self isSharedFolderCreateDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderCreateDetails, but was %@.", [self tagName]];
  }
  return _sharedFolderCreateDetails;
}

- (DBTEAMLOGSharedFolderDeclineInvitationDetails *)sharedFolderDeclineInvitationDetails {
  if (![self isSharedFolderDeclineInvitationDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderDeclineInvitationDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedFolderDeclineInvitationDetails;
}

- (DBTEAMLOGSharedFolderMountDetails *)sharedFolderMountDetails {
  if (![self isSharedFolderMountDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderMountDetails, but was %@.", [self tagName]];
  }
  return _sharedFolderMountDetails;
}

- (DBTEAMLOGSharedFolderNestDetails *)sharedFolderNestDetails {
  if (![self isSharedFolderNestDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderNestDetails, but was %@.", [self tagName]];
  }
  return _sharedFolderNestDetails;
}

- (DBTEAMLOGSharedFolderTransferOwnershipDetails *)sharedFolderTransferOwnershipDetails {
  if (![self isSharedFolderTransferOwnershipDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderTransferOwnershipDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedFolderTransferOwnershipDetails;
}

- (DBTEAMLOGSharedFolderUnmountDetails *)sharedFolderUnmountDetails {
  if (![self isSharedFolderUnmountDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedFolderUnmountDetails, but was %@.", [self tagName]];
  }
  return _sharedFolderUnmountDetails;
}

- (DBTEAMLOGSharedLinkAddExpiryDetails *)sharedLinkAddExpiryDetails {
  if (![self isSharedLinkAddExpiryDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkAddExpiryDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkAddExpiryDetails;
}

- (DBTEAMLOGSharedLinkChangeExpiryDetails *)sharedLinkChangeExpiryDetails {
  if (![self isSharedLinkChangeExpiryDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkChangeExpiryDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedLinkChangeExpiryDetails;
}

- (DBTEAMLOGSharedLinkChangeVisibilityDetails *)sharedLinkChangeVisibilityDetails {
  if (![self isSharedLinkChangeVisibilityDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkChangeVisibilityDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedLinkChangeVisibilityDetails;
}

- (DBTEAMLOGSharedLinkCopyDetails *)sharedLinkCopyDetails {
  if (![self isSharedLinkCopyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkCopyDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkCopyDetails;
}

- (DBTEAMLOGSharedLinkCreateDetails *)sharedLinkCreateDetails {
  if (![self isSharedLinkCreateDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkCreateDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkCreateDetails;
}

- (DBTEAMLOGSharedLinkDisableDetails *)sharedLinkDisableDetails {
  if (![self isSharedLinkDisableDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkDisableDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkDisableDetails;
}

- (DBTEAMLOGSharedLinkDownloadDetails *)sharedLinkDownloadDetails {
  if (![self isSharedLinkDownloadDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkDownloadDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkDownloadDetails;
}

- (DBTEAMLOGSharedLinkRemoveExpiryDetails *)sharedLinkRemoveExpiryDetails {
  if (![self isSharedLinkRemoveExpiryDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkRemoveExpiryDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedLinkRemoveExpiryDetails;
}

- (DBTEAMLOGSharedLinkSettingsAddExpirationDetails *)sharedLinkSettingsAddExpirationDetails {
  if (![self isSharedLinkSettingsAddExpirationDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsAddExpirationDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsAddExpirationDetails;
}

- (DBTEAMLOGSharedLinkSettingsAddPasswordDetails *)sharedLinkSettingsAddPasswordDetails {
  if (![self isSharedLinkSettingsAddPasswordDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsAddPasswordDetails, but was %@.",
                       [self tagName]];
  }
  return _sharedLinkSettingsAddPasswordDetails;
}

- (DBTEAMLOGSharedLinkSettingsAllowDownloadDisabledDetails *)sharedLinkSettingsAllowDownloadDisabledDetails {
  if (![self isSharedLinkSettingsAllowDownloadDisabledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsAllowDownloadDisabledDetails, "
                       @"but was %@.",
                       [self tagName]];
  }
  return _sharedLinkSettingsAllowDownloadDisabledDetails;
}

- (DBTEAMLOGSharedLinkSettingsAllowDownloadEnabledDetails *)sharedLinkSettingsAllowDownloadEnabledDetails {
  if (![self isSharedLinkSettingsAllowDownloadEnabledDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsAllowDownloadEnabledDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsAllowDownloadEnabledDetails;
}

- (DBTEAMLOGSharedLinkSettingsChangeAudienceDetails *)sharedLinkSettingsChangeAudienceDetails {
  if (![self isSharedLinkSettingsChangeAudienceDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsChangeAudienceDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsChangeAudienceDetails;
}

- (DBTEAMLOGSharedLinkSettingsChangeExpirationDetails *)sharedLinkSettingsChangeExpirationDetails {
  if (![self isSharedLinkSettingsChangeExpirationDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsChangeExpirationDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsChangeExpirationDetails;
}

- (DBTEAMLOGSharedLinkSettingsChangePasswordDetails *)sharedLinkSettingsChangePasswordDetails {
  if (![self isSharedLinkSettingsChangePasswordDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsChangePasswordDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsChangePasswordDetails;
}

- (DBTEAMLOGSharedLinkSettingsRemoveExpirationDetails *)sharedLinkSettingsRemoveExpirationDetails {
  if (![self isSharedLinkSettingsRemoveExpirationDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsRemoveExpirationDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsRemoveExpirationDetails;
}

- (DBTEAMLOGSharedLinkSettingsRemovePasswordDetails *)sharedLinkSettingsRemovePasswordDetails {
  if (![self isSharedLinkSettingsRemovePasswordDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkSettingsRemovePasswordDetails, but was %@.",
               [self tagName]];
  }
  return _sharedLinkSettingsRemovePasswordDetails;
}

- (DBTEAMLOGSharedLinkShareDetails *)sharedLinkShareDetails {
  if (![self isSharedLinkShareDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkShareDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkShareDetails;
}

- (DBTEAMLOGSharedLinkViewDetails *)sharedLinkViewDetails {
  if (![self isSharedLinkViewDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedLinkViewDetails, but was %@.", [self tagName]];
  }
  return _sharedLinkViewDetails;
}

- (DBTEAMLOGSharedNoteOpenedDetails *)sharedNoteOpenedDetails {
  if (![self isSharedNoteOpenedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSharedNoteOpenedDetails, but was %@.", [self tagName]];
  }
  return _sharedNoteOpenedDetails;
}

- (DBTEAMLOGShmodelDisableDownloadsDetails *)shmodelDisableDownloadsDetails {
  if (![self isShmodelDisableDownloadsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShmodelDisableDownloadsDetails, but was %@.",
                       [self tagName]];
  }
  return _shmodelDisableDownloadsDetails;
}

- (DBTEAMLOGShmodelEnableDownloadsDetails *)shmodelEnableDownloadsDetails {
  if (![self isShmodelEnableDownloadsDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShmodelEnableDownloadsDetails, but was %@.",
                       [self tagName]];
  }
  return _shmodelEnableDownloadsDetails;
}

- (DBTEAMLOGShmodelGroupShareDetails *)shmodelGroupShareDetails {
  if (![self isShmodelGroupShareDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShmodelGroupShareDetails, but was %@.", [self tagName]];
  }
  return _shmodelGroupShareDetails;
}

- (DBTEAMLOGShowcaseAccessGrantedDetails *)showcaseAccessGrantedDetails {
  if (![self isShowcaseAccessGrantedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseAccessGrantedDetails, but was %@.", [self tagName]];
  }
  return _showcaseAccessGrantedDetails;
}

- (DBTEAMLOGShowcaseAddMemberDetails *)showcaseAddMemberDetails {
  if (![self isShowcaseAddMemberDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseAddMemberDetails, but was %@.", [self tagName]];
  }
  return _showcaseAddMemberDetails;
}

- (DBTEAMLOGShowcaseArchivedDetails *)showcaseArchivedDetails {
  if (![self isShowcaseArchivedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseArchivedDetails, but was %@.", [self tagName]];
  }
  return _showcaseArchivedDetails;
}

- (DBTEAMLOGShowcaseCreatedDetails *)showcaseCreatedDetails {
  if (![self isShowcaseCreatedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseCreatedDetails, but was %@.", [self tagName]];
  }
  return _showcaseCreatedDetails;
}

- (DBTEAMLOGShowcaseDeleteCommentDetails *)showcaseDeleteCommentDetails {
  if (![self isShowcaseDeleteCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseDeleteCommentDetails, but was %@.", [self tagName]];
  }
  return _showcaseDeleteCommentDetails;
}

- (DBTEAMLOGShowcaseEditedDetails *)showcaseEditedDetails {
  if (![self isShowcaseEditedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseEditedDetails, but was %@.", [self tagName]];
  }
  return _showcaseEditedDetails;
}

- (DBTEAMLOGShowcaseEditCommentDetails *)showcaseEditCommentDetails {
  if (![self isShowcaseEditCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseEditCommentDetails, but was %@.", [self tagName]];
  }
  return _showcaseEditCommentDetails;
}

- (DBTEAMLOGShowcaseFileAddedDetails *)showcaseFileAddedDetails {
  if (![self isShowcaseFileAddedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseFileAddedDetails, but was %@.", [self tagName]];
  }
  return _showcaseFileAddedDetails;
}

- (DBTEAMLOGShowcaseFileDownloadDetails *)showcaseFileDownloadDetails {
  if (![self isShowcaseFileDownloadDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseFileDownloadDetails, but was %@.", [self tagName]];
  }
  return _showcaseFileDownloadDetails;
}

- (DBTEAMLOGShowcaseFileRemovedDetails *)showcaseFileRemovedDetails {
  if (![self isShowcaseFileRemovedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseFileRemovedDetails, but was %@.", [self tagName]];
  }
  return _showcaseFileRemovedDetails;
}

- (DBTEAMLOGShowcaseFileViewDetails *)showcaseFileViewDetails {
  if (![self isShowcaseFileViewDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseFileViewDetails, but was %@.", [self tagName]];
  }
  return _showcaseFileViewDetails;
}

- (DBTEAMLOGShowcasePermanentlyDeletedDetails *)showcasePermanentlyDeletedDetails {
  if (![self isShowcasePermanentlyDeletedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcasePermanentlyDeletedDetails, but was %@.",
                       [self tagName]];
  }
  return _showcasePermanentlyDeletedDetails;
}

- (DBTEAMLOGShowcasePostCommentDetails *)showcasePostCommentDetails {
  if (![self isShowcasePostCommentDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcasePostCommentDetails, but was %@.", [self tagName]];
  }
  return _showcasePostCommentDetails;
}

- (DBTEAMLOGShowcaseRemoveMemberDetails *)showcaseRemoveMemberDetails {
  if (![self isShowcaseRemoveMemberDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseRemoveMemberDetails, but was %@.", [self tagName]];
  }
  return _showcaseRemoveMemberDetails;
}

- (DBTEAMLOGShowcaseRenamedDetails *)showcaseRenamedDetails {
  if (![self isShowcaseRenamedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseRenamedDetails, but was %@.", [self tagName]];
  }
  return _showcaseRenamedDetails;
}

- (DBTEAMLOGShowcaseRequestAccessDetails *)showcaseRequestAccessDetails {
  if (![self isShowcaseRequestAccessDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseRequestAccessDetails, but was %@.", [self tagName]];
  }
  return _showcaseRequestAccessDetails;
}

- (DBTEAMLOGShowcaseResolveCommentDetails *)showcaseResolveCommentDetails {
  if (![self isShowcaseResolveCommentDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseResolveCommentDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseResolveCommentDetails;
}

- (DBTEAMLOGShowcaseRestoredDetails *)showcaseRestoredDetails {
  if (![self isShowcaseRestoredDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseRestoredDetails, but was %@.", [self tagName]];
  }
  return _showcaseRestoredDetails;
}

- (DBTEAMLOGShowcaseTrashedDetails *)showcaseTrashedDetails {
  if (![self isShowcaseTrashedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseTrashedDetails, but was %@.", [self tagName]];
  }
  return _showcaseTrashedDetails;
}

- (DBTEAMLOGShowcaseTrashedDeprecatedDetails *)showcaseTrashedDeprecatedDetails {
  if (![self isShowcaseTrashedDeprecatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseTrashedDeprecatedDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseTrashedDeprecatedDetails;
}

- (DBTEAMLOGShowcaseUnresolveCommentDetails *)showcaseUnresolveCommentDetails {
  if (![self isShowcaseUnresolveCommentDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseUnresolveCommentDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseUnresolveCommentDetails;
}

- (DBTEAMLOGShowcaseUntrashedDetails *)showcaseUntrashedDetails {
  if (![self isShowcaseUntrashedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseUntrashedDetails, but was %@.", [self tagName]];
  }
  return _showcaseUntrashedDetails;
}

- (DBTEAMLOGShowcaseUntrashedDeprecatedDetails *)showcaseUntrashedDeprecatedDetails {
  if (![self isShowcaseUntrashedDeprecatedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseUntrashedDeprecatedDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseUntrashedDeprecatedDetails;
}

- (DBTEAMLOGShowcaseViewDetails *)showcaseViewDetails {
  if (![self isShowcaseViewDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseViewDetails, but was %@.", [self tagName]];
  }
  return _showcaseViewDetails;
}

- (DBTEAMLOGSsoAddCertDetails *)ssoAddCertDetails {
  if (![self isSsoAddCertDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoAddCertDetails, but was %@.", [self tagName]];
  }
  return _ssoAddCertDetails;
}

- (DBTEAMLOGSsoAddLoginUrlDetails *)ssoAddLoginUrlDetails {
  if (![self isSsoAddLoginUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoAddLoginUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoAddLoginUrlDetails;
}

- (DBTEAMLOGSsoAddLogoutUrlDetails *)ssoAddLogoutUrlDetails {
  if (![self isSsoAddLogoutUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoAddLogoutUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoAddLogoutUrlDetails;
}

- (DBTEAMLOGSsoChangeCertDetails *)ssoChangeCertDetails {
  if (![self isSsoChangeCertDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoChangeCertDetails, but was %@.", [self tagName]];
  }
  return _ssoChangeCertDetails;
}

- (DBTEAMLOGSsoChangeLoginUrlDetails *)ssoChangeLoginUrlDetails {
  if (![self isSsoChangeLoginUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoChangeLoginUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoChangeLoginUrlDetails;
}

- (DBTEAMLOGSsoChangeLogoutUrlDetails *)ssoChangeLogoutUrlDetails {
  if (![self isSsoChangeLogoutUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoChangeLogoutUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoChangeLogoutUrlDetails;
}

- (DBTEAMLOGSsoChangeSamlIdentityModeDetails *)ssoChangeSamlIdentityModeDetails {
  if (![self isSsoChangeSamlIdentityModeDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoChangeSamlIdentityModeDetails, but was %@.",
                       [self tagName]];
  }
  return _ssoChangeSamlIdentityModeDetails;
}

- (DBTEAMLOGSsoRemoveCertDetails *)ssoRemoveCertDetails {
  if (![self isSsoRemoveCertDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoRemoveCertDetails, but was %@.", [self tagName]];
  }
  return _ssoRemoveCertDetails;
}

- (DBTEAMLOGSsoRemoveLoginUrlDetails *)ssoRemoveLoginUrlDetails {
  if (![self isSsoRemoveLoginUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoRemoveLoginUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoRemoveLoginUrlDetails;
}

- (DBTEAMLOGSsoRemoveLogoutUrlDetails *)ssoRemoveLogoutUrlDetails {
  if (![self isSsoRemoveLogoutUrlDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoRemoveLogoutUrlDetails, but was %@.", [self tagName]];
  }
  return _ssoRemoveLogoutUrlDetails;
}

- (DBTEAMLOGTeamFolderChangeStatusDetails *)teamFolderChangeStatusDetails {
  if (![self isTeamFolderChangeStatusDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamFolderChangeStatusDetails, but was %@.",
                       [self tagName]];
  }
  return _teamFolderChangeStatusDetails;
}

- (DBTEAMLOGTeamFolderCreateDetails *)teamFolderCreateDetails {
  if (![self isTeamFolderCreateDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamFolderCreateDetails, but was %@.", [self tagName]];
  }
  return _teamFolderCreateDetails;
}

- (DBTEAMLOGTeamFolderDowngradeDetails *)teamFolderDowngradeDetails {
  if (![self isTeamFolderDowngradeDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamFolderDowngradeDetails, but was %@.", [self tagName]];
  }
  return _teamFolderDowngradeDetails;
}

- (DBTEAMLOGTeamFolderPermanentlyDeleteDetails *)teamFolderPermanentlyDeleteDetails {
  if (![self isTeamFolderPermanentlyDeleteDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamFolderPermanentlyDeleteDetails, but was %@.",
                       [self tagName]];
  }
  return _teamFolderPermanentlyDeleteDetails;
}

- (DBTEAMLOGTeamFolderRenameDetails *)teamFolderRenameDetails {
  if (![self isTeamFolderRenameDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamFolderRenameDetails, but was %@.", [self tagName]];
  }
  return _teamFolderRenameDetails;
}

- (DBTEAMLOGTeamSelectiveSyncSettingsChangedDetails *)teamSelectiveSyncSettingsChangedDetails {
  if (![self isTeamSelectiveSyncSettingsChangedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamSelectiveSyncSettingsChangedDetails, but was %@.",
               [self tagName]];
  }
  return _teamSelectiveSyncSettingsChangedDetails;
}

- (DBTEAMLOGAccountCaptureChangePolicyDetails *)accountCaptureChangePolicyDetails {
  if (![self isAccountCaptureChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsAccountCaptureChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _accountCaptureChangePolicyDetails;
}

- (DBTEAMLOGAllowDownloadDisabledDetails *)allowDownloadDisabledDetails {
  if (![self isAllowDownloadDisabledDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAllowDownloadDisabledDetails, but was %@.", [self tagName]];
  }
  return _allowDownloadDisabledDetails;
}

- (DBTEAMLOGAllowDownloadEnabledDetails *)allowDownloadEnabledDetails {
  if (![self isAllowDownloadEnabledDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsAllowDownloadEnabledDetails, but was %@.", [self tagName]];
  }
  return _allowDownloadEnabledDetails;
}

- (DBTEAMLOGCameraUploadsPolicyChangedDetails *)cameraUploadsPolicyChangedDetails {
  if (![self isCameraUploadsPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsCameraUploadsPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _cameraUploadsPolicyChangedDetails;
}

- (DBTEAMLOGClassificationChangePolicyDetails *)classificationChangePolicyDetails {
  if (![self isClassificationChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsClassificationChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _classificationChangePolicyDetails;
}

- (DBTEAMLOGComputerBackupPolicyChangedDetails *)computerBackupPolicyChangedDetails {
  if (![self isComputerBackupPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsComputerBackupPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _computerBackupPolicyChangedDetails;
}

- (DBTEAMLOGContentAdministrationPolicyChangedDetails *)contentAdministrationPolicyChangedDetails {
  if (![self isContentAdministrationPolicyChangedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsContentAdministrationPolicyChangedDetails, but was %@.",
               [self tagName]];
  }
  return _contentAdministrationPolicyChangedDetails;
}

- (DBTEAMLOGDataPlacementRestrictionChangePolicyDetails *)dataPlacementRestrictionChangePolicyDetails {
  if (![self isDataPlacementRestrictionChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDataPlacementRestrictionChangePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _dataPlacementRestrictionChangePolicyDetails;
}

- (DBTEAMLOGDataPlacementRestrictionSatisfyPolicyDetails *)dataPlacementRestrictionSatisfyPolicyDetails {
  if (![self isDataPlacementRestrictionSatisfyPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDataPlacementRestrictionSatisfyPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _dataPlacementRestrictionSatisfyPolicyDetails;
}

- (DBTEAMLOGDeviceApprovalsAddExceptionDetails *)deviceApprovalsAddExceptionDetails {
  if (![self isDeviceApprovalsAddExceptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsAddExceptionDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceApprovalsAddExceptionDetails;
}

- (DBTEAMLOGDeviceApprovalsChangeDesktopPolicyDetails *)deviceApprovalsChangeDesktopPolicyDetails {
  if (![self isDeviceApprovalsChangeDesktopPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsChangeDesktopPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _deviceApprovalsChangeDesktopPolicyDetails;
}

- (DBTEAMLOGDeviceApprovalsChangeMobilePolicyDetails *)deviceApprovalsChangeMobilePolicyDetails {
  if (![self isDeviceApprovalsChangeMobilePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsChangeMobilePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _deviceApprovalsChangeMobilePolicyDetails;
}

- (DBTEAMLOGDeviceApprovalsChangeOverageActionDetails *)deviceApprovalsChangeOverageActionDetails {
  if (![self isDeviceApprovalsChangeOverageActionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsChangeOverageActionDetails, but was %@.",
               [self tagName]];
  }
  return _deviceApprovalsChangeOverageActionDetails;
}

- (DBTEAMLOGDeviceApprovalsChangeUnlinkActionDetails *)deviceApprovalsChangeUnlinkActionDetails {
  if (![self isDeviceApprovalsChangeUnlinkActionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsChangeUnlinkActionDetails, but was %@.",
               [self tagName]];
  }
  return _deviceApprovalsChangeUnlinkActionDetails;
}

- (DBTEAMLOGDeviceApprovalsRemoveExceptionDetails *)deviceApprovalsRemoveExceptionDetails {
  if (![self isDeviceApprovalsRemoveExceptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsDeviceApprovalsRemoveExceptionDetails, but was %@.",
                       [self tagName]];
  }
  return _deviceApprovalsRemoveExceptionDetails;
}

- (DBTEAMLOGDirectoryRestrictionsAddMembersDetails *)directoryRestrictionsAddMembersDetails {
  if (![self isDirectoryRestrictionsAddMembersDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDirectoryRestrictionsAddMembersDetails, but was %@.",
               [self tagName]];
  }
  return _directoryRestrictionsAddMembersDetails;
}

- (DBTEAMLOGDirectoryRestrictionsRemoveMembersDetails *)directoryRestrictionsRemoveMembersDetails {
  if (![self isDirectoryRestrictionsRemoveMembersDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsDirectoryRestrictionsRemoveMembersDetails, but was %@.",
               [self tagName]];
  }
  return _directoryRestrictionsRemoveMembersDetails;
}

- (DBTEAMLOGEmmAddExceptionDetails *)emmAddExceptionDetails {
  if (![self isEmmAddExceptionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmAddExceptionDetails, but was %@.", [self tagName]];
  }
  return _emmAddExceptionDetails;
}

- (DBTEAMLOGEmmChangePolicyDetails *)emmChangePolicyDetails {
  if (![self isEmmChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmChangePolicyDetails, but was %@.", [self tagName]];
  }
  return _emmChangePolicyDetails;
}

- (DBTEAMLOGEmmRemoveExceptionDetails *)emmRemoveExceptionDetails {
  if (![self isEmmRemoveExceptionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsEmmRemoveExceptionDetails, but was %@.", [self tagName]];
  }
  return _emmRemoveExceptionDetails;
}

- (DBTEAMLOGExtendedVersionHistoryChangePolicyDetails *)extendedVersionHistoryChangePolicyDetails {
  if (![self isExtendedVersionHistoryChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsExtendedVersionHistoryChangePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _extendedVersionHistoryChangePolicyDetails;
}

- (DBTEAMLOGFileCommentsChangePolicyDetails *)fileCommentsChangePolicyDetails {
  if (![self isFileCommentsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileCommentsChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _fileCommentsChangePolicyDetails;
}

- (DBTEAMLOGFileLockingPolicyChangedDetails *)fileLockingPolicyChangedDetails {
  if (![self isFileLockingPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileLockingPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _fileLockingPolicyChangedDetails;
}

- (DBTEAMLOGFileRequestsChangePolicyDetails *)fileRequestsChangePolicyDetails {
  if (![self isFileRequestsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestsChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _fileRequestsChangePolicyDetails;
}

- (DBTEAMLOGFileRequestsEmailsEnabledDetails *)fileRequestsEmailsEnabledDetails {
  if (![self isFileRequestsEmailsEnabledDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestsEmailsEnabledDetails, but was %@.",
                       [self tagName]];
  }
  return _fileRequestsEmailsEnabledDetails;
}

- (DBTEAMLOGFileRequestsEmailsRestrictedToTeamOnlyDetails *)fileRequestsEmailsRestrictedToTeamOnlyDetails {
  if (![self isFileRequestsEmailsRestrictedToTeamOnlyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsFileRequestsEmailsRestrictedToTeamOnlyDetails, but was %@.",
               [self tagName]];
  }
  return _fileRequestsEmailsRestrictedToTeamOnlyDetails;
}

- (DBTEAMLOGFileTransfersPolicyChangedDetails *)fileTransfersPolicyChangedDetails {
  if (![self isFileTransfersPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsFileTransfersPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _fileTransfersPolicyChangedDetails;
}

- (DBTEAMLOGGoogleSsoChangePolicyDetails *)googleSsoChangePolicyDetails {
  if (![self isGoogleSsoChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGoogleSsoChangePolicyDetails, but was %@.", [self tagName]];
  }
  return _googleSsoChangePolicyDetails;
}

- (DBTEAMLOGGroupUserManagementChangePolicyDetails *)groupUserManagementChangePolicyDetails {
  if (![self isGroupUserManagementChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsGroupUserManagementChangePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _groupUserManagementChangePolicyDetails;
}

- (DBTEAMLOGIntegrationPolicyChangedDetails *)integrationPolicyChangedDetails {
  if (![self isIntegrationPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsIntegrationPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _integrationPolicyChangedDetails;
}

- (DBTEAMLOGMemberRequestsChangePolicyDetails *)memberRequestsChangePolicyDetails {
  if (![self isMemberRequestsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberRequestsChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _memberRequestsChangePolicyDetails;
}

- (DBTEAMLOGMemberSendInvitePolicyChangedDetails *)memberSendInvitePolicyChangedDetails {
  if (![self isMemberSendInvitePolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSendInvitePolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _memberSendInvitePolicyChangedDetails;
}

- (DBTEAMLOGMemberSpaceLimitsAddExceptionDetails *)memberSpaceLimitsAddExceptionDetails {
  if (![self isMemberSpaceLimitsAddExceptionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsAddExceptionDetails, but was %@.",
                       [self tagName]];
  }
  return _memberSpaceLimitsAddExceptionDetails;
}

- (DBTEAMLOGMemberSpaceLimitsChangeCapsTypePolicyDetails *)memberSpaceLimitsChangeCapsTypePolicyDetails {
  if (![self isMemberSpaceLimitsChangeCapsTypePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsChangeCapsTypePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _memberSpaceLimitsChangeCapsTypePolicyDetails;
}

- (DBTEAMLOGMemberSpaceLimitsChangePolicyDetails *)memberSpaceLimitsChangePolicyDetails {
  if (![self isMemberSpaceLimitsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _memberSpaceLimitsChangePolicyDetails;
}

- (DBTEAMLOGMemberSpaceLimitsRemoveExceptionDetails *)memberSpaceLimitsRemoveExceptionDetails {
  if (![self isMemberSpaceLimitsRemoveExceptionDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSpaceLimitsRemoveExceptionDetails, but was %@.",
               [self tagName]];
  }
  return _memberSpaceLimitsRemoveExceptionDetails;
}

- (DBTEAMLOGMemberSuggestionsChangePolicyDetails *)memberSuggestionsChangePolicyDetails {
  if (![self isMemberSuggestionsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsMemberSuggestionsChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _memberSuggestionsChangePolicyDetails;
}

- (DBTEAMLOGMicrosoftOfficeAddinChangePolicyDetails *)microsoftOfficeAddinChangePolicyDetails {
  if (![self isMicrosoftOfficeAddinChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsMicrosoftOfficeAddinChangePolicyDetails, but was %@.",
               [self tagName]];
  }
  return _microsoftOfficeAddinChangePolicyDetails;
}

- (DBTEAMLOGNetworkControlChangePolicyDetails *)networkControlChangePolicyDetails {
  if (![self isNetworkControlChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsNetworkControlChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _networkControlChangePolicyDetails;
}

- (DBTEAMLOGPaperChangeDeploymentPolicyDetails *)paperChangeDeploymentPolicyDetails {
  if (![self isPaperChangeDeploymentPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperChangeDeploymentPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _paperChangeDeploymentPolicyDetails;
}

- (DBTEAMLOGPaperChangeMemberLinkPolicyDetails *)paperChangeMemberLinkPolicyDetails {
  if (![self isPaperChangeMemberLinkPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperChangeMemberLinkPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _paperChangeMemberLinkPolicyDetails;
}

- (DBTEAMLOGPaperChangeMemberPolicyDetails *)paperChangeMemberPolicyDetails {
  if (![self isPaperChangeMemberPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperChangeMemberPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _paperChangeMemberPolicyDetails;
}

- (DBTEAMLOGPaperChangePolicyDetails *)paperChangePolicyDetails {
  if (![self isPaperChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperChangePolicyDetails, but was %@.", [self tagName]];
  }
  return _paperChangePolicyDetails;
}

- (DBTEAMLOGPaperDefaultFolderPolicyChangedDetails *)paperDefaultFolderPolicyChangedDetails {
  if (![self isPaperDefaultFolderPolicyChangedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDefaultFolderPolicyChangedDetails, but was %@.",
               [self tagName]];
  }
  return _paperDefaultFolderPolicyChangedDetails;
}

- (DBTEAMLOGPaperDesktopPolicyChangedDetails *)paperDesktopPolicyChangedDetails {
  if (![self isPaperDesktopPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperDesktopPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _paperDesktopPolicyChangedDetails;
}

- (DBTEAMLOGPaperEnabledUsersGroupAdditionDetails *)paperEnabledUsersGroupAdditionDetails {
  if (![self isPaperEnabledUsersGroupAdditionDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperEnabledUsersGroupAdditionDetails, but was %@.",
                       [self tagName]];
  }
  return _paperEnabledUsersGroupAdditionDetails;
}

- (DBTEAMLOGPaperEnabledUsersGroupRemovalDetails *)paperEnabledUsersGroupRemovalDetails {
  if (![self isPaperEnabledUsersGroupRemovalDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPaperEnabledUsersGroupRemovalDetails, but was %@.",
                       [self tagName]];
  }
  return _paperEnabledUsersGroupRemovalDetails;
}

- (DBTEAMLOGPasswordStrengthRequirementsChangePolicyDetails *)passwordStrengthRequirementsChangePolicyDetails {
  if (![self isPasswordStrengthRequirementsChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPasswordStrengthRequirementsChangePolicyDetails, "
                       @"but was %@.",
                       [self tagName]];
  }
  return _passwordStrengthRequirementsChangePolicyDetails;
}

- (DBTEAMLOGPermanentDeleteChangePolicyDetails *)permanentDeleteChangePolicyDetails {
  if (![self isPermanentDeleteChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsPermanentDeleteChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _permanentDeleteChangePolicyDetails;
}

- (DBTEAMLOGResellerSupportChangePolicyDetails *)resellerSupportChangePolicyDetails {
  if (![self isResellerSupportChangePolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsResellerSupportChangePolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _resellerSupportChangePolicyDetails;
}

- (DBTEAMLOGRewindPolicyChangedDetails *)rewindPolicyChangedDetails {
  if (![self isRewindPolicyChangedDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsRewindPolicyChangedDetails, but was %@.", [self tagName]];
  }
  return _rewindPolicyChangedDetails;
}

- (DBTEAMLOGSendForSignaturePolicyChangedDetails *)sendForSignaturePolicyChangedDetails {
  if (![self isSendForSignaturePolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSendForSignaturePolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _sendForSignaturePolicyChangedDetails;
}

- (DBTEAMLOGSharingChangeFolderJoinPolicyDetails *)sharingChangeFolderJoinPolicyDetails {
  if (![self isSharingChangeFolderJoinPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharingChangeFolderJoinPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _sharingChangeFolderJoinPolicyDetails;
}

- (DBTEAMLOGSharingChangeLinkPolicyDetails *)sharingChangeLinkPolicyDetails {
  if (![self isSharingChangeLinkPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharingChangeLinkPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _sharingChangeLinkPolicyDetails;
}

- (DBTEAMLOGSharingChangeMemberPolicyDetails *)sharingChangeMemberPolicyDetails {
  if (![self isSharingChangeMemberPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSharingChangeMemberPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _sharingChangeMemberPolicyDetails;
}

- (DBTEAMLOGShowcaseChangeDownloadPolicyDetails *)showcaseChangeDownloadPolicyDetails {
  if (![self isShowcaseChangeDownloadPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseChangeDownloadPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseChangeDownloadPolicyDetails;
}

- (DBTEAMLOGShowcaseChangeEnabledPolicyDetails *)showcaseChangeEnabledPolicyDetails {
  if (![self isShowcaseChangeEnabledPolicyDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseChangeEnabledPolicyDetails, but was %@.",
                       [self tagName]];
  }
  return _showcaseChangeEnabledPolicyDetails;
}

- (DBTEAMLOGShowcaseChangeExternalSharingPolicyDetails *)showcaseChangeExternalSharingPolicyDetails {
  if (![self isShowcaseChangeExternalSharingPolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsShowcaseChangeExternalSharingPolicyDetails, but was %@.",
               [self tagName]];
  }
  return _showcaseChangeExternalSharingPolicyDetails;
}

- (DBTEAMLOGSmarterSmartSyncPolicyChangedDetails *)smarterSmartSyncPolicyChangedDetails {
  if (![self isSmarterSmartSyncPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsSmarterSmartSyncPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _smarterSmartSyncPolicyChangedDetails;
}

- (DBTEAMLOGSmartSyncChangePolicyDetails *)smartSyncChangePolicyDetails {
  if (![self isSmartSyncChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSmartSyncChangePolicyDetails, but was %@.", [self tagName]];
  }
  return _smartSyncChangePolicyDetails;
}

- (DBTEAMLOGSmartSyncNotOptOutDetails *)smartSyncNotOptOutDetails {
  if (![self isSmartSyncNotOptOutDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSmartSyncNotOptOutDetails, but was %@.", [self tagName]];
  }
  return _smartSyncNotOptOutDetails;
}

- (DBTEAMLOGSmartSyncOptOutDetails *)smartSyncOptOutDetails {
  if (![self isSmartSyncOptOutDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSmartSyncOptOutDetails, but was %@.", [self tagName]];
  }
  return _smartSyncOptOutDetails;
}

- (DBTEAMLOGSsoChangePolicyDetails *)ssoChangePolicyDetails {
  if (![self isSsoChangePolicyDetails]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBTEAMLOGEventDetailsSsoChangePolicyDetails, but was %@.", [self tagName]];
  }
  return _ssoChangePolicyDetails;
}

- (DBTEAMLOGTeamBrandingPolicyChangedDetails *)teamBrandingPolicyChangedDetails {
  if (![self isTeamBrandingPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamBrandingPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _teamBrandingPolicyChangedDetails;
}

- (DBTEAMLOGTeamExtensionsPolicyChangedDetails *)teamExtensionsPolicyChangedDetails {
  if (![self isTeamExtensionsPolicyChangedDetails]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBTEAMLOGEventDetailsTeamExtensionsPolicyChangedDetails, but was %@.",
                       [self tagName]];
  }
  return _teamExtensionsPolicyChang