///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMUploadApiRateLimitValue;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `UploadApiRateLimitValue` union.
///
/// The value for `uploadApiRateLimit` in `DBTEAMFeature`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMUploadApiRateLimitValue : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMUploadApiRateLimitValueTag` enum type represents the possible tag
/// states with which the `DBTEAMUploadApiRateLimitValue` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMUploadApiRateLimitValueTag){
    /// This team has unlimited upload API quota. So far both server version
    /// account and legacy  account type have unlimited monthly upload api
    /// quota.
    DBTEAMUploadApiRateLimitValueUnlimited,

    /// The number of upload API calls allowed per month.
    DBTEAMUploadApiRateLimitValueLimit,

    /// (no description).
    DBTEAMUploadApiRateLimitValueOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMUploadApiRateLimitValueTag tag;

/// The number of upload API calls allowed per month. @note Ensure the `isLimit`
/// method returns true before accessing, otherwise a runtime exception will be
/// raised.
@property (nonatomic, readonly) NSNumber *limit;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "unlimited".
///
/// Description of the "unlimited" tag state: This team has unlimited upload API
/// quota. So far both server version account and legacy  account type have
/// unlimited monthly upload api quota.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnlimited;

///
/// Initializes union class with tag state of "limit".
///
/// Description of the "limit" tag state: The number of upload API calls allowed
/// per month.
///
/// @param limit The number of upload API calls allowed per month.
///
/// @return An initialized instance.
///
- (instancetype)initWithLimit:(NSNumber *)limit;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "unlimited".
///
/// @return Whether the union's current tag state has value "unlimited".
///
- (BOOL)isUnlimited;

///
/// Retrieves whether the union's current tag state has value "limit".
///
/// @note Call this method and ensure it returns true before accessing the
/// `limit` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "limit".
///
- (BOOL)isLimit;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMUploadApiRateLimitValue` union.
///
@interface DBTEAMUploadApiRateLimitValueSerializer : NSObject

///
/// Serializes `DBTEAMUploadApiRateLimitValue` instances.
///
/// @param instance An instance of the `DBTEAMUploadApiRateLimitValue` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMUploadApiRateLimitValue` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMUploadApiRateLimitValue *)instance;

///
/// Deserializes `DBTEAMUploadApiRateLimitValue` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMUploadApiRateLimitValue` API object.
///
/// @return An instantiation of the `DBTEAMUploadApiRateLimitValue` object.
///
+ (DBTEAMUploadApiRateLimitValue *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
