///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"
#import "DBTEAMMembersDeactivateBaseArg.h"

@class DBTEAMMembersDeactivateArg;
@class DBTEAMUserSelectorArg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MembersDeactivateArg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMembersDeactivateArg : DBTEAMMembersDeactivateBaseArg <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// If provided, controls if the user's data will be deleted on their linked
/// devices.
@property (nonatomic, readonly) NSNumber *wipeData;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param user Identity of user to remove/suspend/have their files moved.
/// @param wipeData If provided, controls if the user's data will be deleted on
/// their linked devices.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user wipeData:(nullable NSNumber *)wipeData;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param user Identity of user to remove/suspend/have their files moved.
///
/// @return An initialized instance.
///
- (instancetype)initWithUser:(DBTEAMUserSelectorArg *)user;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MembersDeactivateArg` struct.
///
@interface DBTEAMMembersDeactivateArgSerializer : NSObject

///
/// Serializes `DBTEAMMembersDeactivateArg` instances.
///
/// @param instance An instance of the `DBTEAMMembersDeactivateArg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMembersDeactivateArg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMembersDeactivateArg *)instance;

///
/// Deserializes `DBTEAMMembersDeactivateArg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMembersDeactivateArg` API object.
///
/// @return An instantiation of the `DBTEAMMembersDeactivateArg` object.
///
+ (DBTEAMMembersDeactivateArg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
