///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSECONDARYEMAILSSecondaryEmail;
@class DBTEAMMemberProfile;
@class DBTEAMTeamMemberStatus;
@class DBTEAMTeamMembershipType;
@class DBUSERSName;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `MemberProfile` struct.
///
/// Basic member profile.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMMemberProfile : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// ID of user as a member of a team.
@property (nonatomic, readonly, copy) NSString *teamMemberId;

/// External ID that a team can attach to the user. An application using the API
/// may find it easier to use their own IDs instead of Dropbox IDs like
/// account_id or team_member_id.
@property (nonatomic, readonly, copy, nullable) NSString *externalId;

/// A user's account identifier.
@property (nonatomic, readonly, copy, nullable) NSString *accountId;

/// Email address of user.
@property (nonatomic, readonly, copy) NSString *email;

/// Is true if the user's email is verified to be owned by the user.
@property (nonatomic, readonly) NSNumber *emailVerified;

/// Secondary emails of a user.
@property (nonatomic, readonly, nullable) NSArray<DBSECONDARYEMAILSSecondaryEmail *> *secondaryEmails;

/// The user's status as a member of a specific team.
@property (nonatomic, readonly) DBTEAMTeamMemberStatus *status;

/// Representations for a person's name.
@property (nonatomic, readonly) DBUSERSName *name;

/// The user's membership type: full (normal team member) vs limited (does not
/// use a license; no access to the team's shared quota).
@property (nonatomic, readonly) DBTEAMTeamMembershipType *membershipType;

/// The date and time the user was invited to the team (contains value only when
/// the member's status matches `invited` in `DBTEAMTeamMemberStatus`).
@property (nonatomic, readonly, nullable) NSDate *invitedOn;

/// The date and time the user joined as a member of a specific team.
@property (nonatomic, readonly, nullable) NSDate *joinedOn;

/// The date and time the user was suspended from the team (contains value only
/// when the member's status matches `suspended` in `DBTEAMTeamMemberStatus`).
@property (nonatomic, readonly, nullable) NSDate *suspendedOn;

/// Persistent ID that a team can attach to the user. The persistent ID is
/// unique ID to be used for SAML authentication.
@property (nonatomic, readonly, copy, nullable) NSString *persistentId;

/// Whether the user is a directory restricted user.
@property (nonatomic, readonly, nullable) NSNumber *isDirectoryRestricted;

/// URL for the photo representing the user, if one is set.
@property (nonatomic, readonly, copy, nullable) NSString *profilePhotoUrl;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param teamMemberId ID of user as a member of a team.
/// @param email Email address of user.
/// @param emailVerified Is true if the user's email is verified to be owned by
/// the user.
/// @param status The user's status as a member of a specific team.
/// @param name Representations for a person's name.
/// @param membershipType The user's membership type: full (normal team member)
/// vs limited (does not use a license; no access to the team's shared quota).
/// @param externalId External ID that a team can attach to the user. An
/// application using the API may find it easier to use their own IDs instead of
/// Dropbox IDs like account_id or team_member_id.
/// @param accountId A user's account identifier.
/// @param secondaryEmails Secondary emails of a user.
/// @param invitedOn The date and time the user was invited to the team
/// (contains value only when the member's status matches `invited` in
/// `DBTEAMTeamMemberStatus`).
/// @param joinedOn The date and time the user joined as a member of a specific
/// team.
/// @param suspendedOn The date and time the user was suspended from the team
/// (contains value only when the member's status matches `suspended` in
/// `DBTEAMTeamMemberStatus`).
/// @param persistentId Persistent ID that a team can attach to the user. The
/// persistent ID is unique ID to be used for SAML authentication.
/// @param isDirectoryRestricted Whether the user is a directory restricted
/// user.
/// @param profilePhotoUrl URL for the photo representing the user, if one is
/// set.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                               email:(NSString *)email
                       emailVerified:(NSNumber *)emailVerified
                              status:(DBTEAMTeamMemberStatus *)status
                                name:(DBUSERSName *)name
                      membershipType:(DBTEAMTeamMembershipType *)membershipType
                          externalId:(nullable NSString *)externalId
                           accountId:(nullable NSString *)accountId
                     secondaryEmails:(nullable NSArray<DBSECONDARYEMAILSSecondaryEmail *> *)secondaryEmails
                           invitedOn:(nullable NSDate *)invitedOn
                            joinedOn:(nullable NSDate *)joinedOn
                         suspendedOn:(nullable NSDate *)suspendedOn
                        persistentId:(nullable NSString *)persistentId
               isDirectoryRestricted:(nullable NSNumber *)isDirectoryRestricted
                     profilePhotoUrl:(nullable NSString *)profilePhotoUrl;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param teamMemberId ID of user as a member of a team.
/// @param email Email address of user.
/// @param emailVerified Is true if the user's email is verified to be owned by
/// the user.
/// @param status The user's status as a member of a specific team.
/// @param name Representations for a person's name.
/// @param membershipType The user's membership type: full (normal team member)
/// vs limited (does not use a license; no access to the team's shared quota).
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamMemberId:(NSString *)teamMemberId
                               email:(NSString *)email
                       emailVerified:(NSNumber *)emailVerified
                              status:(DBTEAMTeamMemberStatus *)status
                                name:(DBUSERSName *)name
                      membershipType:(DBTEAMTeamMembershipType *)membershipType;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `MemberProfile` struct.
///
@interface DBTEAMMemberProfileSerializer : NSObject

///
/// Serializes `DBTEAMMemberProfile` instances.
///
/// @param instance An instance of the `DBTEAMMemberProfile` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMMemberProfile` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMMemberProfile *)instance;

///
/// Deserializes `DBTEAMMemberProfile` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMMemberProfile` API object.
///
/// @return An instantiation of the `DBTEAMMemberProfile` object.
///
+ (DBTEAMMemberProfile *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
