///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLegalHoldsPolicyUpdateError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldsPolicyUpdateError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLegalHoldsPolicyUpdateError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBTEAMLegalHoldsPolicyUpdateErrorTag` enum type represents the possible
/// tag states with which the `DBTEAMLegalHoldsPolicyUpdateError` union can
/// exist.
typedef NS_CLOSED_ENUM(NSInteger, DBTEAMLegalHoldsPolicyUpdateErrorTag){
    /// There has been an unknown legal hold error.
    DBTEAMLegalHoldsPolicyUpdateErrorUnknownLegalHoldError,

    /// You don't have permissions to perform this action.
    DBTEAMLegalHoldsPolicyUpdateErrorInsufficientPermissions,

    /// (no description).
    DBTEAMLegalHoldsPolicyUpdateErrorOther,

    /// Temporary infrastructure failure, please retry.
    DBTEAMLegalHoldsPolicyUpdateErrorTransientError,

    /// Trying to release an inactive legal hold.
    DBTEAMLegalHoldsPolicyUpdateErrorInactiveLegalHold,

    /// Legal hold is currently performing another operation.
    DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPerformingAnotherOperation,

    /// Some members in the members list are not valid to be placed under legal
    /// hold.
    DBTEAMLegalHoldsPolicyUpdateErrorInvalidMembers,

    /// You cannot add more than 5 users in a legal hold.
    DBTEAMLegalHoldsPolicyUpdateErrorNumberOfUsersOnHoldIsGreaterThanHoldLimitation,

    /// The users list must have at least one user.
    DBTEAMLegalHoldsPolicyUpdateErrorEmptyMembersList,

    /// The name provided is already in use by another legal hold.
    DBTEAMLegalHoldsPolicyUpdateErrorNameMustBeUnique,

    /// Legal hold policy does not exist for `id_` in
    /// `DBTEAMLegalHoldsPolicyUpdateArg`.
    DBTEAMLegalHoldsPolicyUpdateErrorLegalHoldPolicyNotFound,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBTEAMLegalHoldsPolicyUpdateErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "unknown_legal_hold_error".
///
/// Description of the "unknown_legal_hold_error" tag state: There has been an
/// unknown legal hold error.
///
/// @return An initialized instance.
///
- (instancetype)initWithUnknownLegalHoldError;

///
/// Initializes union class with tag state of "insufficient_permissions".
///
/// Description of the "insufficient_permissions" tag state: You don't have
/// permissions to perform this action.
///
/// @return An initialized instance.
///
- (instancetype)initWithInsufficientPermissions;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

///
/// Initializes union class with tag state of "transient_error".
///
/// Description of the "transient_error" tag state: Temporary infrastructure
/// failure, please retry.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransientError;

///
/// Initializes union class with tag state of "inactive_legal_hold".
///
/// Description of the "inactive_legal_hold" tag state: Trying to release an
/// inactive legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithInactiveLegalHold;

///
/// Initializes union class with tag state of
/// "legal_hold_performing_another_operation".
///
/// Description of the "legal_hold_performing_another_operation" tag state:
/// Legal hold is currently performing another operation.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldPerformingAnotherOperation;

///
/// Initializes union class with tag state of "invalid_members".
///
/// Description of the "invalid_members" tag state: Some members in the members
/// list are not valid to be placed under legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidMembers;

///
/// Initializes union class with tag state of
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
/// Description of the "number_of_users_on_hold_is_greater_than_hold_limitation"
/// tag state: You cannot add more than 5 users in a legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithNumberOfUsersOnHoldIsGreaterThanHoldLimitation;

///
/// Initializes union class with tag state of "empty_members_list".
///
/// Description of the "empty_members_list" tag state: The users list must have
/// at least one user.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmptyMembersList;

///
/// Initializes union class with tag state of "name_must_be_unique".
///
/// Description of the "name_must_be_unique" tag state: The name provided is
/// already in use by another legal hold.
///
/// @return An initialized instance.
///
- (instancetype)initWithNameMustBeUnique;

///
/// Initializes union class with tag state of "legal_hold_policy_not_found".
///
/// Description of the "legal_hold_policy_not_found" tag state: Legal hold
/// policy does not exist for `id_` in `DBTEAMLegalHoldsPolicyUpdateArg`.
///
/// @return An initialized instance.
///
- (instancetype)initWithLegalHoldPolicyNotFound;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "unknown_legal_hold_error".
///
/// @return Whether the union's current tag state has value
/// "unknown_legal_hold_error".
///
- (BOOL)isUnknownLegalHoldError;

///
/// Retrieves whether the union's current tag state has value
/// "insufficient_permissions".
///
/// @return Whether the union's current tag state has value
/// "insufficient_permissions".
///
- (BOOL)isInsufficientPermissions;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves whether the union's current tag state has value "transient_error".
///
/// @return Whether the union's current tag state has value "transient_error".
///
- (BOOL)isTransientError;

///
/// Retrieves whether the union's current tag state has value
/// "inactive_legal_hold".
///
/// @return Whether the union's current tag state has value
/// "inactive_legal_hold".
///
- (BOOL)isInactiveLegalHold;

///
/// Retrieves whether the union's current tag state has value
/// "legal_hold_performing_another_operation".
///
/// @return Whether the union's current tag state has value
/// "legal_hold_performing_another_operation".
///
- (BOOL)isLegalHoldPerformingAnotherOperation;

///
/// Retrieves whether the union's current tag state has value "invalid_members".
///
/// @return Whether the union's current tag state has value "invalid_members".
///
- (BOOL)isInvalidMembers;

///
/// Retrieves whether the union's current tag state has value
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
/// @return Whether the union's current tag state has value
/// "number_of_users_on_hold_is_greater_than_hold_limitation".
///
- (BOOL)isNumberOfUsersOnHoldIsGreaterThanHoldLimitation;

///
/// Retrieves whether the union's current tag state has value
/// "empty_members_list".
///
/// @return Whether the union's current tag state has value
/// "empty_members_list".
///
- (BOOL)isEmptyMembersList;

///
/// Retrieves whether the union's current tag state has value
/// "name_must_be_unique".
///
/// @return Whether the union's current tag state has value
/// "name_must_be_unique".
///
- (BOOL)isNameMustBeUnique;

///
/// Retrieves whether the union's current tag state has value
/// "legal_hold_policy_not_found".
///
/// @return Whether the union's current tag state has value
/// "legal_hold_policy_not_found".
///
- (BOOL)isLegalHoldPolicyNotFound;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBTEAMLegalHoldsPolicyUpdateError` union.
///
@interface DBTEAMLegalHoldsPolicyUpdateErrorSerializer : NSObject

///
/// Serializes `DBTEAMLegalHoldsPolicyUpdateError` instances.
///
/// @param instance An instance of the `DBTEAMLegalHoldsPolicyUpdateError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldsPolicyUpdateError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldsPolicyUpdateError *)instance;

///
/// Deserializes `DBTEAMLegalHoldsPolicyUpdateError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldsPolicyUpdateError` API object.
///
/// @return An instantiation of the `DBTEAMLegalHoldsPolicyUpdateError` object.
///
+ (DBTEAMLegalHoldsPolicyUpdateError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
