///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBTEAMLegalHoldPolicy;
@class DBTEAMLegalHoldStatus;
@class DBTEAMMembersInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `LegalHoldPolicy` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMLegalHoldPolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The legal hold id.
@property (nonatomic, readonly, copy) NSString *id_;

/// Policy name.
@property (nonatomic, readonly, copy) NSString *name;

/// A description of the legal hold policy.
@property (nonatomic, readonly, copy, nullable) NSString *description_;

/// The time at which the legal hold was activated.
@property (nonatomic, readonly, nullable) NSDate *activationTime;

/// Team members IDs and number of permanetly deleted members under hold.
@property (nonatomic, readonly) DBTEAMMembersInfo *members;

/// The current state of the hold.
@property (nonatomic, readonly) DBTEAMLegalHoldStatus *status;

/// Start date of the legal hold policy.
@property (nonatomic, readonly) NSDate *startDate;

/// End date of the legal hold policy.
@property (nonatomic, readonly, nullable) NSDate *endDate;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param id_ The legal hold id.
/// @param name Policy name.
/// @param members Team members IDs and number of permanetly deleted members
/// under hold.
/// @param status The current state of the hold.
/// @param startDate Start date of the legal hold policy.
/// @param description_ A description of the legal hold policy.
/// @param activationTime The time at which the legal hold was activated.
/// @param endDate End date of the legal hold policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                    members:(DBTEAMMembersInfo *)members
                     status:(DBTEAMLegalHoldStatus *)status
                  startDate:(NSDate *)startDate
               description_:(nullable NSString *)description_
             activationTime:(nullable NSDate *)activationTime
                    endDate:(nullable NSDate *)endDate;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param id_ The legal hold id.
/// @param name Policy name.
/// @param members Team members IDs and number of permanetly deleted members
/// under hold.
/// @param status The current state of the hold.
/// @param startDate Start date of the legal hold policy.
///
/// @return An initialized instance.
///
- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                    members:(DBTEAMMembersInfo *)members
                     status:(DBTEAMLegalHoldStatus *)status
                  startDate:(NSDate *)startDate;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `LegalHoldPolicy` struct.
///
@interface DBTEAMLegalHoldPolicySerializer : NSObject

///
/// Serializes `DBTEAMLegalHoldPolicy` instances.
///
/// @param instance An instance of the `DBTEAMLegalHoldPolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldPolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMLegalHoldPolicy *)instance;

///
/// Deserializes `DBTEAMLegalHoldPolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMLegalHoldPolicy` API object.
///
/// @return An instantiation of the `DBTEAMLegalHoldPolicy` object.
///
+ (DBTEAMLegalHoldPolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
