///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"
#import "DBTEAMBaseDfbReport.h"

@class DBTEAMGetActivityReport;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `GetActivityReport` struct.
///
/// Activity Report Result. Each of the items in the storage report is an array
/// of values, one value per day. If there is no data for a day, then the value
/// will be None.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBTEAMGetActivityReport : DBTEAMBaseDfbReport <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Array of total number of adds by team members.
@property (nonatomic, readonly) NSArray<NSNumber *> *adds;

/// Array of number of edits by team members. If the same user edits the same
/// file multiple times this is counted as a single edit.
@property (nonatomic, readonly) NSArray<NSNumber *> *edits;

/// Array of total number of deletes by team members.
@property (nonatomic, readonly) NSArray<NSNumber *> *deletes;

/// Array of the number of users who have been active in the last 28 days.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeUsers28Day;

/// Array of the number of users who have been active in the last week.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeUsers7Day;

/// Array of the number of users who have been active in the last day.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeUsers1Day;

/// Array of the number of shared folders with some activity in the last 28
/// days.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeSharedFolders28Day;

/// Array of the number of shared folders with some activity in the last week.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeSharedFolders7Day;

/// Array of the number of shared folders with some activity in the last day.
@property (nonatomic, readonly) NSArray<NSNumber *> *activeSharedFolders1Day;

/// Array of the number of shared links created.
@property (nonatomic, readonly) NSArray<NSNumber *> *sharedLinksCreated;

/// Array of the number of views by team users to shared links created by the
/// team.
@property (nonatomic, readonly) NSArray<NSNumber *> *sharedLinksViewedByTeam;

/// Array of the number of views by users outside of the team to shared links
/// created by the team.
@property (nonatomic, readonly) NSArray<NSNumber *> *sharedLinksViewedByOutsideUser;

/// Array of the number of views by non-logged-in users to shared links created
/// by the team.
@property (nonatomic, readonly) NSArray<NSNumber *> *sharedLinksViewedByNotLoggedIn;

/// Array of the total number of views to shared links created by the team.
@property (nonatomic, readonly) NSArray<NSNumber *> *sharedLinksViewedTotal;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param startDate First date present in the results as 'YYYY-MM-DD' or None.
/// @param adds Array of total number of adds by team members.
/// @param edits Array of number of edits by team members. If the same user
/// edits the same file multiple times this is counted as a single edit.
/// @param deletes Array of total number of deletes by team members.
/// @param activeUsers28Day Array of the number of users who have been active in
/// the last 28 days.
/// @param activeUsers7Day Array of the number of users who have been active in
/// the last week.
/// @param activeUsers1Day Array of the number of users who have been active in
/// the last day.
/// @param activeSharedFolders28Day Array of the number of shared folders with
/// some activity in the last 28 days.
/// @param activeSharedFolders7Day Array of the number of shared folders with
/// some activity in the last week.
/// @param activeSharedFolders1Day Array of the number of shared folders with
/// some activity in the last day.
/// @param sharedLinksCreated Array of the number of shared links created.
/// @param sharedLinksViewedByTeam Array of the number of views by team users to
/// shared links created by the team.
/// @param sharedLinksViewedByOutsideUser Array of the number of views by users
/// outside of the team to shared links created by the team.
/// @param sharedLinksViewedByNotLoggedIn Array of the number of views by
/// non-logged-in users to shared links created by the team.
/// @param sharedLinksViewedTotal Array of the total number of views to shared
/// links created by the team.
///
/// @return An initialized instance.
///
- (instancetype)initWithStartDate:(NSString *)startDate
                              adds:(NSArray<NSNumber *> *)adds
                             edits:(NSArray<NSNumber *> *)edits
                           deletes:(NSArray<NSNumber *> *)deletes
                  activeUsers28Day:(NSArray<NSNumber *> *)activeUsers28Day
                   activeUsers7Day:(NSArray<NSNumber *> *)activeUsers7Day
                   activeUsers1Day:(NSArray<NSNumber *> *)activeUsers1Day
          activeSharedFolders28Day:(NSArray<NSNumber *> *)activeSharedFolders28Day
           activeSharedFolders7Day:(NSArray<NSNumber *> *)activeSharedFolders7Day
           activeSharedFolders1Day:(NSArray<NSNumber *> *)activeSharedFolders1Day
                sharedLinksCreated:(NSArray<NSNumber *> *)sharedLinksCreated
           sharedLinksViewedByTeam:(NSArray<NSNumber *> *)sharedLinksViewedByTeam
    sharedLinksViewedByOutsideUser:(NSArray<NSNumber *> *)sharedLinksViewedByOutsideUser
    sharedLinksViewedByNotLoggedIn:(NSArray<NSNumber *> *)sharedLinksViewedByNotLoggedIn
            sharedLinksViewedTotal:(NSArray<NSNumber *> *)sharedLinksViewedTotal;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `GetActivityReport` struct.
///
@interface DBTEAMGetActivityReportSerializer : NSObject

///
/// Serializes `DBTEAMGetActivityReport` instances.
///
/// @param instance An instance of the `DBTEAMGetActivityReport` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBTEAMGetActivityReport` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBTEAMGetActivityReport *)instance;

///
/// Deserializes `DBTEAMGetActivityReport` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBTEAMGetActivityReport` API object.
///
/// @return An instantiation of the `DBTEAMGetActivityReport` object.
///
+ (DBTEAMGetActivityReport *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
