///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGSharedLinkAccessFailureReason;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedLinkAccessFailureReason` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGSharedLinkAccessFailureReason : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGSharedLinkAccessFailureReasonTag` enum type represents the
/// possible tag states with which the `DBSHARINGSharedLinkAccessFailureReason`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGSharedLinkAccessFailureReasonTag){
    /// User is not logged in.
    DBSHARINGSharedLinkAccessFailureReasonLoginRequired,

    /// This user's email address is not verified. This functionality is only
    /// available on accounts with a verified email address. Users can verify
    /// their email address here https://www.dropbox.com/help/317.
    DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired,

    /// The link is password protected.
    DBSHARINGSharedLinkAccessFailureReasonPasswordRequired,

    /// Access is allowed for team members only.
    DBSHARINGSharedLinkAccessFailureReasonTeamOnly,

    /// Access is allowed for the shared link's owner only.
    DBSHARINGSharedLinkAccessFailureReasonOwnerOnly,

    /// (no description).
    DBSHARINGSharedLinkAccessFailureReasonOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGSharedLinkAccessFailureReasonTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "login_required".
///
/// Description of the "login_required" tag state: User is not logged in.
///
/// @return An initialized instance.
///
- (instancetype)initWithLoginRequired;

///
/// Initializes union class with tag state of "email_verify_required".
///
/// Description of the "email_verify_required" tag state: This user's email
/// address is not verified. This functionality is only available on accounts
/// with a verified email address. Users can verify their email address here
/// https://www.dropbox.com/help/317.
///
/// @return An initialized instance.
///
- (instancetype)initWithEmailVerifyRequired;

///
/// Initializes union class with tag state of "password_required".
///
/// Description of the "password_required" tag state: The link is password
/// protected.
///
/// @return An initialized instance.
///
- (instancetype)initWithPasswordRequired;

///
/// Initializes union class with tag state of "team_only".
///
/// Description of the "team_only" tag state: Access is allowed for team members
/// only.
///
/// @return An initialized instance.
///
- (instancetype)initWithTeamOnly;

///
/// Initializes union class with tag state of "owner_only".
///
/// Description of the "owner_only" tag state: Access is allowed for the shared
/// link's owner only.
///
/// @return An initialized instance.
///
- (instancetype)initWithOwnerOnly;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "login_required".
///
/// @return Whether the union's current tag state has value "login_required".
///
- (BOOL)isLoginRequired;

///
/// Retrieves whether the union's current tag state has value
/// "email_verify_required".
///
/// @return Whether the union's current tag state has value
/// "email_verify_required".
///
- (BOOL)isEmailVerifyRequired;

///
/// Retrieves whether the union's current tag state has value
/// "password_required".
///
/// @return Whether the union's current tag state has value "password_required".
///
- (BOOL)isPasswordRequired;

///
/// Retrieves whether the union's current tag state has value "team_only".
///
/// @return Whether the union's current tag state has value "team_only".
///
- (BOOL)isTeamOnly;

///
/// Retrieves whether the union's current tag state has value "owner_only".
///
/// @return Whether the union's current tag state has value "owner_only".
///
- (BOOL)isOwnerOnly;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGSharedLinkAccessFailureReason`
/// union.
///
@interface DBSHARINGSharedLinkAccessFailureReasonSerializer : NSObject

///
/// Serializes `DBSHARINGSharedLinkAccessFailureReason` instances.
///
/// @param instance An instance of the `DBSHARINGSharedLinkAccessFailureReason`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGSharedLinkAccessFailureReason` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkAccessFailureReason *)instance;

///
/// Deserializes `DBSHARINGSharedLinkAccessFailureReason` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGSharedLinkAccessFailureReason` API object.
///
/// @return An instantiation of the `DBSHARINGSharedLinkAccessFailureReason`
/// object.
///
+ (DBSHARINGSharedLinkAccessFailureReason *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
