///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;
@class DBSHARINGAudienceRestrictingSharedFolder;
@class DBSHARINGLinkAudience;
@class DBSHARINGLinkPermission;
@class DBSHARINGSharedContentLinkMetadataBase;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SharedContentLinkMetadataBase` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGSharedContentLinkMetadataBase : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The access level on the link for this file.
@property (nonatomic, readonly, nullable) DBSHARINGAccessLevel *accessLevel;

/// The audience options that are available for the content. Some audience
/// options may be unavailable. For example, team_only may be unavailable if the
/// content is not owned by a user on a team. The 'default' audience option is
/// always available if the user can modify link settings.
@property (nonatomic, readonly) NSArray<DBSHARINGLinkAudience *> *audienceOptions;

/// The shared folder that prevents the link audience for this link from being
/// more restrictive.
@property (nonatomic, readonly, nullable) DBSHARINGAudienceRestrictingSharedFolder *audienceRestrictingSharedFolder;

/// The current audience of the link.
@property (nonatomic, readonly) DBSHARINGLinkAudience *currentAudience;

/// Whether the link has an expiry set on it. A link with an expiry will have
/// its  audience changed to members when the expiry is reached.
@property (nonatomic, readonly, nullable) NSDate *expiry;

/// A list of permissions for actions you can perform on the link.
@property (nonatomic, readonly) NSArray<DBSHARINGLinkPermission *> *linkPermissions;

/// Whether the link is protected by a password.
@property (nonatomic, readonly) NSNumber *passwordProtected;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param audienceOptions The audience options that are available for the
/// content. Some audience options may be unavailable. For example, team_only
/// may be unavailable if the content is not owned by a user on a team. The
/// 'default' audience option is always available if the user can modify link
/// settings.
/// @param currentAudience The current audience of the link.
/// @param linkPermissions A list of permissions for actions you can perform on
/// the link.
/// @param passwordProtected Whether the link is protected by a password.
/// @param accessLevel The access level on the link for this file.
/// @param audienceRestrictingSharedFolder The shared folder that prevents the
/// link audience for this link from being more restrictive.
/// @param expiry Whether the link has an expiry set on it. A link with an
/// expiry will have its  audience changed to members when the expiry is
/// reached.
///
/// @return An initialized instance.
///
- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected
                            accessLevel:(nullable DBSHARINGAccessLevel *)accessLevel
        audienceRestrictingSharedFolder:
            (nullable DBSHARINGAudienceRestrictingSharedFolder *)audienceRestrictingSharedFolder
                                 expiry:(nullable NSDate *)expiry;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param audienceOptions The audience options that are available for the
/// content. Some audience options may be unavailable. For example, team_only
/// may be unavailable if the content is not owned by a user on a team. The
/// 'default' audience option is always available if the user can modify link
/// settings.
/// @param currentAudience The current audience of the link.
/// @param linkPermissions A list of permissions for actions you can perform on
/// the link.
/// @param passwordProtected Whether the link is protected by a password.
///
/// @return An initialized instance.
///
- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SharedContentLinkMetadataBase` struct.
///
@interface DBSHARINGSharedContentLinkMetadataBaseSerializer : NSObject

///
/// Serializes `DBSHARINGSharedContentLinkMetadataBase` instances.
///
/// @param instance An instance of the `DBSHARINGSharedContentLinkMetadataBase`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGSharedContentLinkMetadataBase` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedContentLinkMetadataBase *)instance;

///
/// Deserializes `DBSHARINGSharedContentLinkMetadataBase` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGSharedContentLinkMetadataBase` API object.
///
/// @return An instantiation of the `DBSHARINGSharedContentLinkMetadataBase`
/// object.
///
+ (DBSHARINGSharedContentLinkMetadataBase *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
