///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGListFolderMembersContinueError;
@class DBSHARINGSharedFolderAccessError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListFolderMembersContinueError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGListFolderMembersContinueError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGListFolderMembersContinueErrorTag` enum type represents the
/// possible tag states with which the `DBSHARINGListFolderMembersContinueError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGListFolderMembersContinueErrorTag){
    /// (no description).
    DBSHARINGListFolderMembersContinueErrorAccessError,

    /// `cursor` in `DBSHARINGListFolderMembersContinueArg` is invalid.
    DBSHARINGListFolderMembersContinueErrorInvalidCursor,

    /// (no description).
    DBSHARINGListFolderMembersContinueErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGListFolderMembersContinueErrorTag tag;

/// (no description). @note Ensure the `isAccessError` method returns true
/// before accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBSHARINGSharedFolderAccessError *accessError;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "access_error".
///
/// @param accessError (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError;

///
/// Initializes union class with tag state of "invalid_cursor".
///
/// Description of the "invalid_cursor" tag state: `cursor` in
/// `DBSHARINGListFolderMembersContinueArg` is invalid.
///
/// @return An initialized instance.
///
- (instancetype)initWithInvalidCursor;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "access_error".
///
/// @note Call this method and ensure it returns true before accessing the
/// `accessError` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "access_error".
///
- (BOOL)isAccessError;

///
/// Retrieves whether the union's current tag state has value "invalid_cursor".
///
/// @return Whether the union's current tag state has value "invalid_cursor".
///
- (BOOL)isInvalidCursor;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGListFolderMembersContinueError`
/// union.
///
@interface DBSHARINGListFolderMembersContinueErrorSerializer : NSObject

///
/// Serializes `DBSHARINGListFolderMembersContinueError` instances.
///
/// @param instance An instance of the `DBSHARINGListFolderMembersContinueError`
/// API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGListFolderMembersContinueError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFolderMembersContinueError *)instance;

///
/// Deserializes `DBSHARINGListFolderMembersContinueError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGListFolderMembersContinueError` API object.
///
/// @return An instantiation of the `DBSHARINGListFolderMembersContinueError`
/// object.
///
+ (DBSHARINGListFolderMembersContinueError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
