///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGListFileMembersBatchResult;
@class DBSHARINGListFileMembersIndividualResult;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListFileMembersBatchResult` struct.
///
/// Per-file result for `listFileMembersBatch`.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGListFileMembersBatchResult : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// This is the input file identifier, whether an ID or a path.
@property (nonatomic, readonly, copy) NSString *file;

/// The result for this particular file.
@property (nonatomic, readonly) DBSHARINGListFileMembersIndividualResult *result;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param file This is the input file identifier, whether an ID or a path.
/// @param result The result for this particular file.
///
/// @return An initialized instance.
///
- (instancetype)initWithFile:(NSString *)file result:(DBSHARINGListFileMembersIndividualResult *)result;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListFileMembersBatchResult` struct.
///
@interface DBSHARINGListFileMembersBatchResultSerializer : NSObject

///
/// Serializes `DBSHARINGListFileMembersBatchResult` instances.
///
/// @param instance An instance of the `DBSHARINGListFileMembersBatchResult` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGListFileMembersBatchResult` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersBatchResult *)instance;

///
/// Deserializes `DBSHARINGListFileMembersBatchResult` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGListFileMembersBatchResult` API object.
///
/// @return An instantiation of the `DBSHARINGListFileMembersBatchResult`
/// object.
///
+ (DBSHARINGListFileMembersBatchResult *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
