///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBSHARINGAccessLevel;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `AccessLevel` union.
///
/// Defines the access levels for collaborators.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBSHARINGAccessLevel : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBSHARINGAccessLevelTag` enum type represents the possible tag states
/// with which the `DBSHARINGAccessLevel` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBSHARINGAccessLevelTag){
    /// The collaborator is the owner of the shared folder. Owners can view and
    /// edit the shared folder as well as set the folder's policies using
    /// `updateFolderPolicy`.
    DBSHARINGAccessLevelOwner,

    /// The collaborator can both view and edit the shared folder.
    DBSHARINGAccessLevelEditor,

    /// The collaborator can only view the shared folder.
    DBSHARINGAccessLevelViewer,

    /// The collaborator can only view the shared folder and does not have any
    /// access to comments.
    DBSHARINGAccessLevelViewerNoComment,

    /// (no description).
    DBSHARINGAccessLevelOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBSHARINGAccessLevelTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "owner".
///
/// Description of the "owner" tag state: The collaborator is the owner of the
/// shared folder. Owners can view and edit the shared folder as well as set the
/// folder's policies using `updateFolderPolicy`.
///
/// @return An initialized instance.
///
- (instancetype)initWithOwner;

///
/// Initializes union class with tag state of "editor".
///
/// Description of the "editor" tag state: The collaborator can both view and
/// edit the shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithEditor;

///
/// Initializes union class with tag state of "viewer".
///
/// Description of the "viewer" tag state: The collaborator can only view the
/// shared folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithViewer;

///
/// Initializes union class with tag state of "viewer_no_comment".
///
/// Description of the "viewer_no_comment" tag state: The collaborator can only
/// view the shared folder and does not have any access to comments.
///
/// @return An initialized instance.
///
- (instancetype)initWithViewerNoComment;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "owner".
///
/// @return Whether the union's current tag state has value "owner".
///
- (BOOL)isOwner;

///
/// Retrieves whether the union's current tag state has value "editor".
///
/// @return Whether the union's current tag state has value "editor".
///
- (BOOL)isEditor;

///
/// Retrieves whether the union's current tag state has value "viewer".
///
/// @return Whether the union's current tag state has value "viewer".
///
- (BOOL)isViewer;

///
/// Retrieves whether the union's current tag state has value
/// "viewer_no_comment".
///
/// @return Whether the union's current tag state has value "viewer_no_comment".
///
- (BOOL)isViewerNoComment;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBSHARINGAccessLevel` union.
///
@interface DBSHARINGAccessLevelSerializer : NSObject

///
/// Serializes `DBSHARINGAccessLevel` instances.
///
/// @param instance An instance of the `DBSHARINGAccessLevel` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBSHARINGAccessLevel` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBSHARINGAccessLevel *)instance;

///
/// Deserializes `DBSHARINGAccessLevel` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBSHARINGAccessLevel` API object.
///
/// @return An instantiation of the `DBSHARINGAccessLevel` object.
///
+ (DBSHARINGAccessLevel *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
