///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Sharing` namespace.

#import "DBSHARINGAccessInheritance.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAccessInheritance

#pragma mark - Constructors

- (instancetype)initWithInherit {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessInheritanceInherit;
  }
  return self;
}

- (instancetype)initWithNoInherit {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessInheritanceNoInherit;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessInheritanceOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInherit {
  return _tag == DBSHARINGAccessInheritanceInherit;
}

- (BOOL)isNoInherit {
  return _tag == DBSHARINGAccessInheritanceNoInherit;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAccessInheritanceOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAccessInheritanceInherit:
    return @"DBSHARINGAccessInheritanceInherit";
  case DBSHARINGAccessInheritanceNoInherit:
    return @"DBSHARINGAccessInheritanceNoInherit";
  case DBSHARINGAccessInheritanceOther:
    return @"DBSHARINGAccessInheritanceOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAccessInheritanceSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAccessInheritanceSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAccessInheritanceSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAccessInheritanceInherit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessInheritanceNoInherit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessInheritanceOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccessInheritance:other];
}

- (BOOL)isEqualToAccessInheritance:(DBSHARINGAccessInheritance *)anAccessInheritance {
  if (self == anAccessInheritance) {
    return YES;
  }
  if (self.tag != anAccessInheritance.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAccessInheritanceInherit:
    return [[self tagName] isEqual:[anAccessInheritance tagName]];
  case DBSHARINGAccessInheritanceNoInherit:
    return [[self tagName] isEqual:[anAccessInheritance tagName]];
  case DBSHARINGAccessInheritanceOther:
    return [[self tagName] isEqual:[anAccessInheritance tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAccessInheritanceSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAccessInheritance *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInherit]) {
    jsonDict[@".tag"] = @"inherit";
  } else if ([valueObj isNoInherit]) {
    jsonDict[@".tag"] = @"no_inherit";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAccessInheritance *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"inherit"]) {
    return [[DBSHARINGAccessInheritance alloc] initWithInherit];
  } else if ([tag isEqualToString:@"no_inherit"]) {
    return [[DBSHARINGAccessInheritance alloc] initWithNoInherit];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAccessInheritance alloc] initWithOther];
  } else {
    return [[DBSHARINGAccessInheritance alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAccessLevel

#pragma mark - Constructors

- (instancetype)initWithOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessLevelOwner;
  }
  return self;
}

- (instancetype)initWithEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessLevelEditor;
  }
  return self;
}

- (instancetype)initWithViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessLevelViewer;
  }
  return self;
}

- (instancetype)initWithViewerNoComment {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessLevelViewerNoComment;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAccessLevelOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOwner {
  return _tag == DBSHARINGAccessLevelOwner;
}

- (BOOL)isEditor {
  return _tag == DBSHARINGAccessLevelEditor;
}

- (BOOL)isViewer {
  return _tag == DBSHARINGAccessLevelViewer;
}

- (BOOL)isViewerNoComment {
  return _tag == DBSHARINGAccessLevelViewerNoComment;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAccessLevelOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAccessLevelOwner:
    return @"DBSHARINGAccessLevelOwner";
  case DBSHARINGAccessLevelEditor:
    return @"DBSHARINGAccessLevelEditor";
  case DBSHARINGAccessLevelViewer:
    return @"DBSHARINGAccessLevelViewer";
  case DBSHARINGAccessLevelViewerNoComment:
    return @"DBSHARINGAccessLevelViewerNoComment";
  case DBSHARINGAccessLevelOther:
    return @"DBSHARINGAccessLevelOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAccessLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAccessLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAccessLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAccessLevelOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessLevelEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessLevelViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessLevelViewerNoComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAccessLevelOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAccessLevel:other];
}

- (BOOL)isEqualToAccessLevel:(DBSHARINGAccessLevel *)anAccessLevel {
  if (self == anAccessLevel) {
    return YES;
  }
  if (self.tag != anAccessLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAccessLevelOwner:
    return [[self tagName] isEqual:[anAccessLevel tagName]];
  case DBSHARINGAccessLevelEditor:
    return [[self tagName] isEqual:[anAccessLevel tagName]];
  case DBSHARINGAccessLevelViewer:
    return [[self tagName] isEqual:[anAccessLevel tagName]];
  case DBSHARINGAccessLevelViewerNoComment:
    return [[self tagName] isEqual:[anAccessLevel tagName]];
  case DBSHARINGAccessLevelOther:
    return [[self tagName] isEqual:[anAccessLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAccessLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAccessLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOwner]) {
    jsonDict[@".tag"] = @"owner";
  } else if ([valueObj isEditor]) {
    jsonDict[@".tag"] = @"editor";
  } else if ([valueObj isViewer]) {
    jsonDict[@".tag"] = @"viewer";
  } else if ([valueObj isViewerNoComment]) {
    jsonDict[@".tag"] = @"viewer_no_comment";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAccessLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"owner"]) {
    return [[DBSHARINGAccessLevel alloc] initWithOwner];
  } else if ([tag isEqualToString:@"editor"]) {
    return [[DBSHARINGAccessLevel alloc] initWithEditor];
  } else if ([tag isEqualToString:@"viewer"]) {
    return [[DBSHARINGAccessLevel alloc] initWithViewer];
  } else if ([tag isEqualToString:@"viewer_no_comment"]) {
    return [[DBSHARINGAccessLevel alloc] initWithViewerNoComment];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAccessLevel alloc] initWithOther];
  } else {
    return [[DBSHARINGAccessLevel alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAclUpdatePolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAclUpdatePolicy

#pragma mark - Constructors

- (instancetype)initWithOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAclUpdatePolicyOwner;
  }
  return self;
}

- (instancetype)initWithEditors {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAclUpdatePolicyEditors;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAclUpdatePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOwner {
  return _tag == DBSHARINGAclUpdatePolicyOwner;
}

- (BOOL)isEditors {
  return _tag == DBSHARINGAclUpdatePolicyEditors;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAclUpdatePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAclUpdatePolicyOwner:
    return @"DBSHARINGAclUpdatePolicyOwner";
  case DBSHARINGAclUpdatePolicyEditors:
    return @"DBSHARINGAclUpdatePolicyEditors";
  case DBSHARINGAclUpdatePolicyOther:
    return @"DBSHARINGAclUpdatePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAclUpdatePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAclUpdatePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAclUpdatePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAclUpdatePolicyOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAclUpdatePolicyEditors:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAclUpdatePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAclUpdatePolicy:other];
}

- (BOOL)isEqualToAclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)anAclUpdatePolicy {
  if (self == anAclUpdatePolicy) {
    return YES;
  }
  if (self.tag != anAclUpdatePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAclUpdatePolicyOwner:
    return [[self tagName] isEqual:[anAclUpdatePolicy tagName]];
  case DBSHARINGAclUpdatePolicyEditors:
    return [[self tagName] isEqual:[anAclUpdatePolicy tagName]];
  case DBSHARINGAclUpdatePolicyOther:
    return [[self tagName] isEqual:[anAclUpdatePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAclUpdatePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAclUpdatePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOwner]) {
    jsonDict[@".tag"] = @"owner";
  } else if ([valueObj isEditors]) {
    jsonDict[@".tag"] = @"editors";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAclUpdatePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"owner"]) {
    return [[DBSHARINGAclUpdatePolicy alloc] initWithOwner];
  } else if ([tag isEqualToString:@"editors"]) {
    return [[DBSHARINGAclUpdatePolicy alloc] initWithEditors];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAclUpdatePolicy alloc] initWithOther];
  } else {
    return [[DBSHARINGAclUpdatePolicy alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGAddFileMemberArgs.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddFileMemberArgs

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file
                     members:(NSArray<DBSHARINGMemberSelector *> *)members
               customMessage:(NSString *)customMessage
                       quiet:(NSNumber *)quiet
                 accessLevel:(DBSHARINGAccessLevel *)accessLevel
         addMessageAsComment:(NSNumber *)addMessageAsComment {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super init];
  if (self) {
    _file = file;
    _members = members;
    _customMessage = customMessage;
    _quiet = quiet ?: @NO;
    _accessLevel = accessLevel ?: [[DBSHARINGAccessLevel alloc] initWithViewer];
    _addMessageAsComment = addMessageAsComment ?: @NO;
  }
  return self;
}

- (instancetype)initWithFile:(NSString *)file members:(NSArray<DBSHARINGMemberSelector *> *)members {
  return [self initWithFile:file members:members customMessage:nil quiet:nil accessLevel:nil addMessageAsComment:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddFileMemberArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddFileMemberArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddFileMemberArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.members hash];
  if (self.customMessage != nil) {
    result = prime * result + [self.customMessage hash];
  }
  result = prime * result + [self.quiet hash];
  result = prime * result + [self.accessLevel hash];
  result = prime * result + [self.addMessageAsComment hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddFileMemberArgs:other];
}

- (BOOL)isEqualToAddFileMemberArgs:(DBSHARINGAddFileMemberArgs *)anAddFileMemberArgs {
  if (self == anAddFileMemberArgs) {
    return YES;
  }
  if (![self.file isEqual:anAddFileMemberArgs.file]) {
    return NO;
  }
  if (![self.members isEqual:anAddFileMemberArgs.members]) {
    return NO;
  }
  if (self.customMessage) {
    if (![self.customMessage isEqual:anAddFileMemberArgs.customMessage]) {
      return NO;
    }
  }
  if (![self.quiet isEqual:anAddFileMemberArgs.quiet]) {
    return NO;
  }
  if (![self.accessLevel isEqual:anAddFileMemberArgs.accessLevel]) {
    return NO;
  }
  if (![self.addMessageAsComment isEqual:anAddFileMemberArgs.addMessageAsComment]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddFileMemberArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddFileMemberArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBSHARINGMemberSelectorSerializer serialize:elem0];
                                            }];
  if (valueObj.customMessage) {
    jsonDict[@"custom_message"] = valueObj.customMessage;
  }
  jsonDict[@"quiet"] = valueObj.quiet;
  jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  jsonDict[@"add_message_as_comment"] = valueObj.addMessageAsComment;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddFileMemberArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  NSArray<DBSHARINGMemberSelector *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGMemberSelectorSerializer deserialize:elem0];
                           }];
  NSString *customMessage = valueDict[@"custom_message"] ?: nil;
  NSNumber *quiet = valueDict[@"quiet"] ?: @NO;
  DBSHARINGAccessLevel *accessLevel = valueDict[@"access_level"]
                                          ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]]
                                          : [[DBSHARINGAccessLevel alloc] initWithViewer];
  NSNumber *addMessageAsComment = valueDict[@"add_message_as_comment"] ?: @NO;

  return [[DBSHARINGAddFileMemberArgs alloc] initWithFile:file
                                                  members:members
                                            customMessage:customMessage
                                                    quiet:quiet
                                              accessLevel:accessLevel
                                      addMessageAsComment:addMessageAsComment];
}

@end

#import "DBSHARINGAddFileMemberError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddFileMemberError

@synthesize userError = _userError;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFileMemberErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFileMemberErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithRateLimit {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFileMemberErrorRateLimit;
  }
  return self;
}

- (instancetype)initWithInvalidComment {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFileMemberErrorInvalidComment;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFileMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddFileMemberErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddFileMemberErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGAddFileMemberErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGAddFileMemberErrorAccessError;
}

- (BOOL)isRateLimit {
  return _tag == DBSHARINGAddFileMemberErrorRateLimit;
}

- (BOOL)isInvalidComment {
  return _tag == DBSHARINGAddFileMemberErrorInvalidComment;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAddFileMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAddFileMemberErrorUserError:
    return @"DBSHARINGAddFileMemberErrorUserError";
  case DBSHARINGAddFileMemberErrorAccessError:
    return @"DBSHARINGAddFileMemberErrorAccessError";
  case DBSHARINGAddFileMemberErrorRateLimit:
    return @"DBSHARINGAddFileMemberErrorRateLimit";
  case DBSHARINGAddFileMemberErrorInvalidComment:
    return @"DBSHARINGAddFileMemberErrorInvalidComment";
  case DBSHARINGAddFileMemberErrorOther:
    return @"DBSHARINGAddFileMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddFileMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddFileMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddFileMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAddFileMemberErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGAddFileMemberErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGAddFileMemberErrorRateLimit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFileMemberErrorInvalidComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFileMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddFileMemberError:other];
}

- (BOOL)isEqualToAddFileMemberError:(DBSHARINGAddFileMemberError *)anAddFileMemberError {
  if (self == anAddFileMemberError) {
    return YES;
  }
  if (self.tag != anAddFileMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAddFileMemberErrorUserError:
    return [self.userError isEqual:anAddFileMemberError.userError];
  case DBSHARINGAddFileMemberErrorAccessError:
    return [self.accessError isEqual:anAddFileMemberError.accessError];
  case DBSHARINGAddFileMemberErrorRateLimit:
    return [[self tagName] isEqual:[anAddFileMemberError tagName]];
  case DBSHARINGAddFileMemberErrorInvalidComment:
    return [[self tagName] isEqual:[anAddFileMemberError tagName]];
  case DBSHARINGAddFileMemberErrorOther:
    return [[self tagName] isEqual:[anAddFileMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddFileMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddFileMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isRateLimit]) {
    jsonDict[@".tag"] = @"rate_limit";
  } else if ([valueObj isInvalidComment]) {
    jsonDict[@".tag"] = @"invalid_comment";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddFileMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGAddFileMemberError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGAddFileMemberError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"rate_limit"]) {
    return [[DBSHARINGAddFileMemberError alloc] initWithRateLimit];
  } else if ([tag isEqualToString:@"invalid_comment"]) {
    return [[DBSHARINGAddFileMemberError alloc] initWithInvalidComment];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAddFileMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGAddFileMemberError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAddFolderMemberArg.h"
#import "DBSHARINGAddMember.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddFolderMemberArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                               members:(NSArray<DBSHARINGAddMember *> *)members
                                 quiet:(NSNumber *)quiet
                         customMessage:(NSString *)customMessage {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](customMessage);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _members = members;
    _quiet = quiet ?: @NO;
    _customMessage = customMessage;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId members:(NSArray<DBSHARINGAddMember *> *)members {
  return [self initWithSharedFolderId:sharedFolderId members:members quiet:nil customMessage:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddFolderMemberArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddFolderMemberArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddFolderMemberArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.members hash];
  result = prime * result + [self.quiet hash];
  if (self.customMessage != nil) {
    result = prime * result + [self.customMessage hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddFolderMemberArg:other];
}

- (BOOL)isEqualToAddFolderMemberArg:(DBSHARINGAddFolderMemberArg *)anAddFolderMemberArg {
  if (self == anAddFolderMemberArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anAddFolderMemberArg.sharedFolderId]) {
    return NO;
  }
  if (![self.members isEqual:anAddFolderMemberArg.members]) {
    return NO;
  }
  if (![self.quiet isEqual:anAddFolderMemberArg.quiet]) {
    return NO;
  }
  if (self.customMessage) {
    if (![self.customMessage isEqual:anAddFolderMemberArg.customMessage]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddFolderMemberArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddFolderMemberArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBSHARINGAddMemberSerializer serialize:elem0];
                                            }];
  jsonDict[@"quiet"] = valueObj.quiet;
  if (valueObj.customMessage) {
    jsonDict[@"custom_message"] = valueObj.customMessage;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddFolderMemberArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSArray<DBSHARINGAddMember *> *members =
      [DBArraySerializer deserialize:valueDict[@"members"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGAddMemberSerializer deserialize:elem0];
                           }];
  NSNumber *quiet = valueDict[@"quiet"] ?: @NO;
  NSString *customMessage = valueDict[@"custom_message"] ?: nil;

  return [[DBSHARINGAddFolderMemberArg alloc] initWithSharedFolderId:sharedFolderId
                                                             members:members
                                                               quiet:quiet
                                                       customMessage:customMessage];
}

@end

#import "DBSHARINGAddFolderMemberError.h"
#import "DBSHARINGAddMemberSelectorError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddFolderMemberError

@synthesize accessError = _accessError;
@synthesize badMember = _badMember;
@synthesize tooManyMembers = _tooManyMembers;
@synthesize tooManyPendingInvites = _tooManyPendingInvites;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithBannedMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorBannedMember;
  }
  return self;
}

- (instancetype)initWithBadMember:(DBSHARINGAddMemberSelectorError *)badMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorBadMember;
    _badMember = badMember;
  }
  return self;
}

- (instancetype)initWithCantShareOutsideTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorCantShareOutsideTeam;
  }
  return self;
}

- (instancetype)initWithTooManyMembers:(NSNumber *)tooManyMembers {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorTooManyMembers;
    _tooManyMembers = tooManyMembers;
  }
  return self;
}

- (instancetype)initWithTooManyPendingInvites:(NSNumber *)tooManyPendingInvites {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorTooManyPendingInvites;
    _tooManyPendingInvites = tooManyPendingInvites;
  }
  return self;
}

- (instancetype)initWithRateLimit {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorRateLimit;
  }
  return self;
}

- (instancetype)initWithTooManyInvitees {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorTooManyInvitees;
  }
  return self;
}

- (instancetype)initWithInsufficientPlan {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorInsufficientPlan;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithInvalidSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorInvalidSharedFolder;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddFolderMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddFolderMemberErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGAddMemberSelectorError *)badMember {
  if (![self isBadMember]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddFolderMemberErrorBadMember, but was %@.", [self tagName]];
  }
  return _badMember;
}

- (NSNumber *)tooManyMembers {
  if (![self isTooManyMembers]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGAddFolderMemberErrorTooManyMembers, but was %@.", [self tagName]];
  }
  return _tooManyMembers;
}

- (NSNumber *)tooManyPendingInvites {
  if (![self isTooManyPendingInvites]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddFolderMemberErrorTooManyPendingInvites, but was %@.",
                       [self tagName]];
  }
  return _tooManyPendingInvites;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGAddFolderMemberErrorAccessError;
}

- (BOOL)isEmailUnverified {
  return _tag == DBSHARINGAddFolderMemberErrorEmailUnverified;
}

- (BOOL)isBannedMember {
  return _tag == DBSHARINGAddFolderMemberErrorBannedMember;
}

- (BOOL)isBadMember {
  return _tag == DBSHARINGAddFolderMemberErrorBadMember;
}

- (BOOL)isCantShareOutsideTeam {
  return _tag == DBSHARINGAddFolderMemberErrorCantShareOutsideTeam;
}

- (BOOL)isTooManyMembers {
  return _tag == DBSHARINGAddFolderMemberErrorTooManyMembers;
}

- (BOOL)isTooManyPendingInvites {
  return _tag == DBSHARINGAddFolderMemberErrorTooManyPendingInvites;
}

- (BOOL)isRateLimit {
  return _tag == DBSHARINGAddFolderMemberErrorRateLimit;
}

- (BOOL)isTooManyInvitees {
  return _tag == DBSHARINGAddFolderMemberErrorTooManyInvitees;
}

- (BOOL)isInsufficientPlan {
  return _tag == DBSHARINGAddFolderMemberErrorInsufficientPlan;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGAddFolderMemberErrorTeamFolder;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGAddFolderMemberErrorNoPermission;
}

- (BOOL)isInvalidSharedFolder {
  return _tag == DBSHARINGAddFolderMemberErrorInvalidSharedFolder;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAddFolderMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAddFolderMemberErrorAccessError:
    return @"DBSHARINGAddFolderMemberErrorAccessError";
  case DBSHARINGAddFolderMemberErrorEmailUnverified:
    return @"DBSHARINGAddFolderMemberErrorEmailUnverified";
  case DBSHARINGAddFolderMemberErrorBannedMember:
    return @"DBSHARINGAddFolderMemberErrorBannedMember";
  case DBSHARINGAddFolderMemberErrorBadMember:
    return @"DBSHARINGAddFolderMemberErrorBadMember";
  case DBSHARINGAddFolderMemberErrorCantShareOutsideTeam:
    return @"DBSHARINGAddFolderMemberErrorCantShareOutsideTeam";
  case DBSHARINGAddFolderMemberErrorTooManyMembers:
    return @"DBSHARINGAddFolderMemberErrorTooManyMembers";
  case DBSHARINGAddFolderMemberErrorTooManyPendingInvites:
    return @"DBSHARINGAddFolderMemberErrorTooManyPendingInvites";
  case DBSHARINGAddFolderMemberErrorRateLimit:
    return @"DBSHARINGAddFolderMemberErrorRateLimit";
  case DBSHARINGAddFolderMemberErrorTooManyInvitees:
    return @"DBSHARINGAddFolderMemberErrorTooManyInvitees";
  case DBSHARINGAddFolderMemberErrorInsufficientPlan:
    return @"DBSHARINGAddFolderMemberErrorInsufficientPlan";
  case DBSHARINGAddFolderMemberErrorTeamFolder:
    return @"DBSHARINGAddFolderMemberErrorTeamFolder";
  case DBSHARINGAddFolderMemberErrorNoPermission:
    return @"DBSHARINGAddFolderMemberErrorNoPermission";
  case DBSHARINGAddFolderMemberErrorInvalidSharedFolder:
    return @"DBSHARINGAddFolderMemberErrorInvalidSharedFolder";
  case DBSHARINGAddFolderMemberErrorOther:
    return @"DBSHARINGAddFolderMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddFolderMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddFolderMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddFolderMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAddFolderMemberErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGAddFolderMemberErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorBannedMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorBadMember:
    result = prime * result + [self.badMember hash];
    break;
  case DBSHARINGAddFolderMemberErrorCantShareOutsideTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorTooManyMembers:
    result = prime * result + [self.tooManyMembers hash];
    break;
  case DBSHARINGAddFolderMemberErrorTooManyPendingInvites:
    result = prime * result + [self.tooManyPendingInvites hash];
    break;
  case DBSHARINGAddFolderMemberErrorRateLimit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorTooManyInvitees:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorInsufficientPlan:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorInvalidSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddFolderMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddFolderMemberError:other];
}

- (BOOL)isEqualToAddFolderMemberError:(DBSHARINGAddFolderMemberError *)anAddFolderMemberError {
  if (self == anAddFolderMemberError) {
    return YES;
  }
  if (self.tag != anAddFolderMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAddFolderMemberErrorAccessError:
    return [self.accessError isEqual:anAddFolderMemberError.accessError];
  case DBSHARINGAddFolderMemberErrorEmailUnverified:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorBannedMember:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorBadMember:
    return [self.badMember isEqual:anAddFolderMemberError.badMember];
  case DBSHARINGAddFolderMemberErrorCantShareOutsideTeam:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorTooManyMembers:
    return [self.tooManyMembers isEqual:anAddFolderMemberError.tooManyMembers];
  case DBSHARINGAddFolderMemberErrorTooManyPendingInvites:
    return [self.tooManyPendingInvites isEqual:anAddFolderMemberError.tooManyPendingInvites];
  case DBSHARINGAddFolderMemberErrorRateLimit:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorTooManyInvitees:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorInsufficientPlan:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorTeamFolder:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorNoPermission:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorInvalidSharedFolder:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  case DBSHARINGAddFolderMemberErrorOther:
    return [[self tagName] isEqual:[anAddFolderMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddFolderMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddFolderMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isBannedMember]) {
    jsonDict[@".tag"] = @"banned_member";
  } else if ([valueObj isBadMember]) {
    jsonDict[@"bad_member"] = [[DBSHARINGAddMemberSelectorErrorSerializer serialize:valueObj.badMember] mutableCopy];
    jsonDict[@".tag"] = @"bad_member";
  } else if ([valueObj isCantShareOutsideTeam]) {
    jsonDict[@".tag"] = @"cant_share_outside_team";
  } else if ([valueObj isTooManyMembers]) {
    jsonDict[@"too_many_members"] = valueObj.tooManyMembers;
    jsonDict[@".tag"] = @"too_many_members";
  } else if ([valueObj isTooManyPendingInvites]) {
    jsonDict[@"too_many_pending_invites"] = valueObj.tooManyPendingInvites;
    jsonDict[@".tag"] = @"too_many_pending_invites";
  } else if ([valueObj isRateLimit]) {
    jsonDict[@".tag"] = @"rate_limit";
  } else if ([valueObj isTooManyInvitees]) {
    jsonDict[@".tag"] = @"too_many_invitees";
  } else if ([valueObj isInsufficientPlan]) {
    jsonDict[@".tag"] = @"insufficient_plan";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isInvalidSharedFolder]) {
    jsonDict[@".tag"] = @"invalid_shared_folder";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddFolderMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGAddFolderMemberError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"banned_member"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithBannedMember];
  } else if ([tag isEqualToString:@"bad_member"]) {
    DBSHARINGAddMemberSelectorError *badMember =
        [DBSHARINGAddMemberSelectorErrorSerializer deserialize:valueDict[@"bad_member"]];
    return [[DBSHARINGAddFolderMemberError alloc] initWithBadMember:badMember];
  } else if ([tag isEqualToString:@"cant_share_outside_team"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithCantShareOutsideTeam];
  } else if ([tag isEqualToString:@"too_many_members"]) {
    NSNumber *tooManyMembers = valueDict[@"too_many_members"];
    return [[DBSHARINGAddFolderMemberError alloc] initWithTooManyMembers:tooManyMembers];
  } else if ([tag isEqualToString:@"too_many_pending_invites"]) {
    NSNumber *tooManyPendingInvites = valueDict[@"too_many_pending_invites"];
    return [[DBSHARINGAddFolderMemberError alloc] initWithTooManyPendingInvites:tooManyPendingInvites];
  } else if ([tag isEqualToString:@"rate_limit"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithRateLimit];
  } else if ([tag isEqualToString:@"too_many_invitees"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithTooManyInvitees];
  } else if ([tag isEqualToString:@"insufficient_plan"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithInsufficientPlan];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"invalid_shared_folder"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithInvalidSharedFolder];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAddFolderMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGAddFolderMemberError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGAddMember.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddMember

#pragma mark - Constructors

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member accessLevel:(DBSHARINGAccessLevel *)accessLevel {
  [DBStoneValidators nonnullValidator:nil](member);

  self = [super init];
  if (self) {
    _member = member;
    _accessLevel = accessLevel ?: [[DBSHARINGAccessLevel alloc] initWithViewer];
  }
  return self;
}

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member {
  return [self initWithMember:member accessLevel:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddMemberSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddMemberSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddMemberSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.member hash];
  result = prime * result + [self.accessLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddMember:other];
}

- (BOOL)isEqualToAddMember:(DBSHARINGAddMember *)anAddMember {
  if (self == anAddMember) {
    return YES;
  }
  if (![self.member isEqual:anAddMember.member]) {
    return NO;
  }
  if (![self.accessLevel isEqual:anAddMember.accessLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddMemberSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddMember *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddMember *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBSHARINGAccessLevel *accessLevel = valueDict[@"access_level"]
                                          ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]]
                                          : [[DBSHARINGAccessLevel alloc] initWithViewer];

  return [[DBSHARINGAddMember alloc] initWithMember:member accessLevel:accessLevel];
}

@end

#import "DBSHARINGAddMemberSelectorError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAddMemberSelectorError

@synthesize invalidDropboxId = _invalidDropboxId;
@synthesize invalidEmail = _invalidEmail;
@synthesize unverifiedDropboxId = _unverifiedDropboxId;

#pragma mark - Constructors

- (instancetype)initWithAutomaticGroup {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorAutomaticGroup;
  }
  return self;
}

- (instancetype)initWithInvalidDropboxId:(NSString *)invalidDropboxId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorInvalidDropboxId;
    _invalidDropboxId = invalidDropboxId;
  }
  return self;
}

- (instancetype)initWithInvalidEmail:(NSString *)invalidEmail {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorInvalidEmail;
    _invalidEmail = invalidEmail;
  }
  return self;
}

- (instancetype)initWithUnverifiedDropboxId:(NSString *)unverifiedDropboxId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId;
    _unverifiedDropboxId = unverifiedDropboxId;
  }
  return self;
}

- (instancetype)initWithGroupDeleted {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorGroupDeleted;
  }
  return self;
}

- (instancetype)initWithGroupNotOnTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorGroupNotOnTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGAddMemberSelectorErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)invalidDropboxId {
  if (![self isInvalidDropboxId]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGAddMemberSelectorErrorInvalidDropboxId, but was %@.", [self tagName]];
  }
  return _invalidDropboxId;
}

- (NSString *)invalidEmail {
  if (![self isInvalidEmail]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGAddMemberSelectorErrorInvalidEmail, but was %@.", [self tagName]];
  }
  return _invalidEmail;
}

- (NSString *)unverifiedDropboxId {
  if (![self isUnverifiedDropboxId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId, but was %@.",
                       [self tagName]];
  }
  return _unverifiedDropboxId;
}

#pragma mark - Tag state methods

- (BOOL)isAutomaticGroup {
  return _tag == DBSHARINGAddMemberSelectorErrorAutomaticGroup;
}

- (BOOL)isInvalidDropboxId {
  return _tag == DBSHARINGAddMemberSelectorErrorInvalidDropboxId;
}

- (BOOL)isInvalidEmail {
  return _tag == DBSHARINGAddMemberSelectorErrorInvalidEmail;
}

- (BOOL)isUnverifiedDropboxId {
  return _tag == DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId;
}

- (BOOL)isGroupDeleted {
  return _tag == DBSHARINGAddMemberSelectorErrorGroupDeleted;
}

- (BOOL)isGroupNotOnTeam {
  return _tag == DBSHARINGAddMemberSelectorErrorGroupNotOnTeam;
}

- (BOOL)isOther {
  return _tag == DBSHARINGAddMemberSelectorErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGAddMemberSelectorErrorAutomaticGroup:
    return @"DBSHARINGAddMemberSelectorErrorAutomaticGroup";
  case DBSHARINGAddMemberSelectorErrorInvalidDropboxId:
    return @"DBSHARINGAddMemberSelectorErrorInvalidDropboxId";
  case DBSHARINGAddMemberSelectorErrorInvalidEmail:
    return @"DBSHARINGAddMemberSelectorErrorInvalidEmail";
  case DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId:
    return @"DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId";
  case DBSHARINGAddMemberSelectorErrorGroupDeleted:
    return @"DBSHARINGAddMemberSelectorErrorGroupDeleted";
  case DBSHARINGAddMemberSelectorErrorGroupNotOnTeam:
    return @"DBSHARINGAddMemberSelectorErrorGroupNotOnTeam";
  case DBSHARINGAddMemberSelectorErrorOther:
    return @"DBSHARINGAddMemberSelectorErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAddMemberSelectorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAddMemberSelectorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAddMemberSelectorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGAddMemberSelectorErrorAutomaticGroup:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddMemberSelectorErrorInvalidDropboxId:
    result = prime * result + [self.invalidDropboxId hash];
    break;
  case DBSHARINGAddMemberSelectorErrorInvalidEmail:
    result = prime * result + [self.invalidEmail hash];
    break;
  case DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId:
    result = prime * result + [self.unverifiedDropboxId hash];
    break;
  case DBSHARINGAddMemberSelectorErrorGroupDeleted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddMemberSelectorErrorGroupNotOnTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGAddMemberSelectorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddMemberSelectorError:other];
}

- (BOOL)isEqualToAddMemberSelectorError:(DBSHARINGAddMemberSelectorError *)anAddMemberSelectorError {
  if (self == anAddMemberSelectorError) {
    return YES;
  }
  if (self.tag != anAddMemberSelectorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGAddMemberSelectorErrorAutomaticGroup:
    return [[self tagName] isEqual:[anAddMemberSelectorError tagName]];
  case DBSHARINGAddMemberSelectorErrorInvalidDropboxId:
    return [self.invalidDropboxId isEqual:anAddMemberSelectorError.invalidDropboxId];
  case DBSHARINGAddMemberSelectorErrorInvalidEmail:
    return [self.invalidEmail isEqual:anAddMemberSelectorError.invalidEmail];
  case DBSHARINGAddMemberSelectorErrorUnverifiedDropboxId:
    return [self.unverifiedDropboxId isEqual:anAddMemberSelectorError.unverifiedDropboxId];
  case DBSHARINGAddMemberSelectorErrorGroupDeleted:
    return [[self tagName] isEqual:[anAddMemberSelectorError tagName]];
  case DBSHARINGAddMemberSelectorErrorGroupNotOnTeam:
    return [[self tagName] isEqual:[anAddMemberSelectorError tagName]];
  case DBSHARINGAddMemberSelectorErrorOther:
    return [[self tagName] isEqual:[anAddMemberSelectorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAddMemberSelectorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAddMemberSelectorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAutomaticGroup]) {
    jsonDict[@".tag"] = @"automatic_group";
  } else if ([valueObj isInvalidDropboxId]) {
    jsonDict[@"invalid_dropbox_id"] = valueObj.invalidDropboxId;
    jsonDict[@".tag"] = @"invalid_dropbox_id";
  } else if ([valueObj isInvalidEmail]) {
    jsonDict[@"invalid_email"] = valueObj.invalidEmail;
    jsonDict[@".tag"] = @"invalid_email";
  } else if ([valueObj isUnverifiedDropboxId]) {
    jsonDict[@"unverified_dropbox_id"] = valueObj.unverifiedDropboxId;
    jsonDict[@".tag"] = @"unverified_dropbox_id";
  } else if ([valueObj isGroupDeleted]) {
    jsonDict[@".tag"] = @"group_deleted";
  } else if ([valueObj isGroupNotOnTeam]) {
    jsonDict[@".tag"] = @"group_not_on_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAddMemberSelectorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"automatic_group"]) {
    return [[DBSHARINGAddMemberSelectorError alloc] initWithAutomaticGroup];
  } else if ([tag isEqualToString:@"invalid_dropbox_id"]) {
    NSString *invalidDropboxId = valueDict[@"invalid_dropbox_id"];
    return [[DBSHARINGAddMemberSelectorError alloc] initWithInvalidDropboxId:invalidDropboxId];
  } else if ([tag isEqualToString:@"invalid_email"]) {
    NSString *invalidEmail = valueDict[@"invalid_email"];
    return [[DBSHARINGAddMemberSelectorError alloc] initWithInvalidEmail:invalidEmail];
  } else if ([tag isEqualToString:@"unverified_dropbox_id"]) {
    NSString *unverifiedDropboxId = valueDict[@"unverified_dropbox_id"];
    return [[DBSHARINGAddMemberSelectorError alloc] initWithUnverifiedDropboxId:unverifiedDropboxId];
  } else if ([tag isEqualToString:@"group_deleted"]) {
    return [[DBSHARINGAddMemberSelectorError alloc] initWithGroupDeleted];
  } else if ([tag isEqualToString:@"group_not_on_team"]) {
    return [[DBSHARINGAddMemberSelectorError alloc] initWithGroupNotOnTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGAddMemberSelectorError alloc] initWithOther];
  } else {
    return [[DBSHARINGAddMemberSelectorError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAudienceExceptionContentInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAudienceExceptionContentInfo

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name {
  [DBStoneValidators nonnullValidator:nil](name);

  self = [super init];
  if (self) {
    _name = name;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAudienceExceptionContentInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAudienceExceptionContentInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAudienceExceptionContentInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAudienceExceptionContentInfo:other];
}

- (BOOL)isEqualToAudienceExceptionContentInfo:(DBSHARINGAudienceExceptionContentInfo *)anAudienceExceptionContentInfo {
  if (self == anAudienceExceptionContentInfo) {
    return YES;
  }
  if (![self.name isEqual:anAudienceExceptionContentInfo.name]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAudienceExceptionContentInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAudienceExceptionContentInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAudienceExceptionContentInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];

  return [[DBSHARINGAudienceExceptionContentInfo alloc] initWithName:name];
}

@end

#import "DBSHARINGAudienceExceptionContentInfo.h"
#import "DBSHARINGAudienceExceptions.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAudienceExceptions

#pragma mark - Constructors

- (instancetype)initWithCount:(NSNumber *)count
                   exceptions:(NSArray<DBSHARINGAudienceExceptionContentInfo *> *)exceptions {
  [DBStoneValidators nonnullValidator:nil](count);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](exceptions);

  self = [super init];
  if (self) {
    _count = count;
    _exceptions = exceptions;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAudienceExceptionsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAudienceExceptionsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAudienceExceptionsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.count hash];
  result = prime * result + [self.exceptions hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAudienceExceptions:other];
}

- (BOOL)isEqualToAudienceExceptions:(DBSHARINGAudienceExceptions *)anAudienceExceptions {
  if (self == anAudienceExceptions) {
    return YES;
  }
  if (![self.count isEqual:anAudienceExceptions.count]) {
    return NO;
  }
  if (![self.exceptions isEqual:anAudienceExceptions.exceptions]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAudienceExceptionsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAudienceExceptions *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"count"] = valueObj.count;
  jsonDict[@"exceptions"] =
      [DBArraySerializer serialize:valueObj.exceptions
                         withBlock:^id(id elem0) {
                           return [DBSHARINGAudienceExceptionContentInfoSerializer serialize:elem0];
                         }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAudienceExceptions *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *count = valueDict[@"count"];
  NSArray<DBSHARINGAudienceExceptionContentInfo *> *exceptions =
      [DBArraySerializer deserialize:valueDict[@"exceptions"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGAudienceExceptionContentInfoSerializer deserialize:elem0];
                           }];

  return [[DBSHARINGAudienceExceptions alloc] initWithCount:count exceptions:exceptions];
}

@end

#import "DBSHARINGAudienceRestrictingSharedFolder.h"
#import "DBSHARINGLinkAudience.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGAudienceRestrictingSharedFolder

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                                  name:(NSString *)name
                              audience:(DBSHARINGLinkAudience *)audience {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](audience);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _name = name;
    _audience = audience;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGAudienceRestrictingSharedFolderSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGAudienceRestrictingSharedFolderSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGAudienceRestrictingSharedFolderSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.audience hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAudienceRestrictingSharedFolder:other];
}

- (BOOL)isEqualToAudienceRestrictingSharedFolder:
    (DBSHARINGAudienceRestrictingSharedFolder *)anAudienceRestrictingSharedFolder {
  if (self == anAudienceRestrictingSharedFolder) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anAudienceRestrictingSharedFolder.sharedFolderId]) {
    return NO;
  }
  if (![self.name isEqual:anAudienceRestrictingSharedFolder.name]) {
    return NO;
  }
  if (![self.audience isEqual:anAudienceRestrictingSharedFolder.audience]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGAudienceRestrictingSharedFolderSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGAudienceRestrictingSharedFolder *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.audience];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGAudienceRestrictingSharedFolder *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSString *name = valueDict[@"name"];
  DBSHARINGLinkAudience *audience = [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"audience"]];

  return [[DBSHARINGAudienceRestrictingSharedFolder alloc] initWithSharedFolderId:sharedFolderId
                                                                             name:name
                                                                         audience:audience];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGChangeFileMemberAccessArgs.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGChangeFileMemberAccessArgs

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file
                      member:(DBSHARINGMemberSelector *)member
                 accessLevel:(DBSHARINGAccessLevel *)accessLevel {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](accessLevel);

  self = [super init];
  if (self) {
    _file = file;
    _member = member;
    _accessLevel = accessLevel;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGChangeFileMemberAccessArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGChangeFileMemberAccessArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGChangeFileMemberAccessArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.member hash];
  result = prime * result + [self.accessLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToChangeFileMemberAccessArgs:other];
}

- (BOOL)isEqualToChangeFileMemberAccessArgs:(DBSHARINGChangeFileMemberAccessArgs *)aChangeFileMemberAccessArgs {
  if (self == aChangeFileMemberAccessArgs) {
    return YES;
  }
  if (![self.file isEqual:aChangeFileMemberAccessArgs.file]) {
    return NO;
  }
  if (![self.member isEqual:aChangeFileMemberAccessArgs.member]) {
    return NO;
  }
  if (![self.accessLevel isEqual:aChangeFileMemberAccessArgs.accessLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGChangeFileMemberAccessArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGChangeFileMemberAccessArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGChangeFileMemberAccessArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBSHARINGAccessLevel *accessLevel = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]];

  return [[DBSHARINGChangeFileMemberAccessArgs alloc] initWithFile:file member:member accessLevel:accessLevel];
}

@end

#import "DBSHARINGCollectionLinkMetadata.h"
#import "DBSHARINGLinkMetadata.h"
#import "DBSHARINGPathLinkMetadata.h"
#import "DBSHARINGVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url visibility:(DBSHARINGVisibility *)visibility expires:(NSDate *)expires {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](visibility);

  self = [super init];
  if (self) {
    _url = url;
    _visibility = visibility;
    _expires = expires;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url visibility:(DBSHARINGVisibility *)visibility {
  return [self initWithUrl:url visibility:visibility expires:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.visibility hash];
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkMetadata:other];
}

- (BOOL)isEqualToLinkMetadata:(DBSHARINGLinkMetadata *)aLinkMetadata {
  if (self == aLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aLinkMetadata.url]) {
    return NO;
  }
  if (![self.visibility isEqual:aLinkMetadata.visibility]) {
    return NO;
  }
  if (self.expires) {
    if (![self.expires isEqual:aLinkMetadata.expires]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"visibility"] = [DBSHARINGVisibilitySerializer serialize:valueObj.visibility];
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  if ([valueObj isKindOfClass:[DBSHARINGPathLinkMetadata class]]) {
    NSDictionary *subTypeFields = [DBSHARINGPathLinkMetadataSerializer serialize:(DBSHARINGPathLinkMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isKindOfClass:[DBSHARINGCollectionLinkMetadata class]]) {
    NSDictionary *subTypeFields =
        [DBSHARINGCollectionLinkMetadataSerializer serialize:(DBSHARINGCollectionLinkMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"collection";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"path"]) {
    return [DBSHARINGPathLinkMetadataSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"collection"]) {
    return [DBSHARINGCollectionLinkMetadataSerializer deserialize:valueDict];
  }

  NSString *url = valueDict[@"url"];
  DBSHARINGVisibility *visibility = [DBSHARINGVisibilitySerializer deserialize:valueDict[@"visibility"]];
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBSHARINGLinkMetadata alloc] initWithUrl:url visibility:visibility expires:expires];
}

@end

#import "DBSHARINGCollectionLinkMetadata.h"
#import "DBSHARINGLinkMetadata.h"
#import "DBSHARINGVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGCollectionLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url visibility:(DBSHARINGVisibility *)visibility expires:(NSDate *)expires {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](visibility);

  self = [super initWithUrl:url visibility:visibility expires:expires];
  if (self) {
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url visibility:(DBSHARINGVisibility *)visibility {
  return [self initWithUrl:url visibility:visibility expires:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGCollectionLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGCollectionLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGCollectionLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.visibility hash];
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCollectionLinkMetadata:other];
}

- (BOOL)isEqualToCollectionLinkMetadata:(DBSHARINGCollectionLinkMetadata *)aCollectionLinkMetadata {
  if (self == aCollectionLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aCollectionLinkMetadata.url]) {
    return NO;
  }
  if (![self.visibility isEqual:aCollectionLinkMetadata.visibility]) {
    return NO;
  }
  if (self.expires) {
    if (![self.expires isEqual:aCollectionLinkMetadata.expires]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGCollectionLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGCollectionLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"visibility"] = [DBSHARINGVisibilitySerializer serialize:valueObj.visibility];
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGCollectionLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  DBSHARINGVisibility *visibility = [DBSHARINGVisibilitySerializer deserialize:valueDict[@"visibility"]];
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBSHARINGCollectionLinkMetadata alloc] initWithUrl:url visibility:visibility expires:expires];
}

@end

#import "DBSHARINGCreateSharedLinkArg.h"
#import "DBSHARINGPendingUploadMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGCreateSharedLinkArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
                    shortUrl:(NSNumber *)shortUrl
               pendingUpload:(DBSHARINGPendingUploadMode *)pendingUpload {
  [DBStoneValidators nonnullValidator:nil](path);

  self = [super init];
  if (self) {
    _path = path;
    _shortUrl = shortUrl ?: @NO;
    _pendingUpload = pendingUpload;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path shortUrl:nil pendingUpload:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGCreateSharedLinkArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGCreateSharedLinkArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGCreateSharedLinkArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  result = prime * result + [self.shortUrl hash];
  if (self.pendingUpload != nil) {
    result = prime * result + [self.pendingUpload hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateSharedLinkArg:other];
}

- (BOOL)isEqualToCreateSharedLinkArg:(DBSHARINGCreateSharedLinkArg *)aCreateSharedLinkArg {
  if (self == aCreateSharedLinkArg) {
    return YES;
  }
  if (![self.path isEqual:aCreateSharedLinkArg.path]) {
    return NO;
  }
  if (![self.shortUrl isEqual:aCreateSharedLinkArg.shortUrl]) {
    return NO;
  }
  if (self.pendingUpload) {
    if (![self.pendingUpload isEqual:aCreateSharedLinkArg.pendingUpload]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGCreateSharedLinkArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGCreateSharedLinkArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  jsonDict[@"short_url"] = valueObj.shortUrl;
  if (valueObj.pendingUpload) {
    jsonDict[@"pending_upload"] = [DBSHARINGPendingUploadModeSerializer serialize:valueObj.pendingUpload];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGCreateSharedLinkArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  NSNumber *shortUrl = valueDict[@"short_url"] ?: @NO;
  DBSHARINGPendingUploadMode *pendingUpload =
      valueDict[@"pending_upload"] ? [DBSHARINGPendingUploadModeSerializer deserialize:valueDict[@"pending_upload"]]
                                   : nil;

  return [[DBSHARINGCreateSharedLinkArg alloc] initWithPath:path shortUrl:shortUrl pendingUpload:pendingUpload];
}

@end

#import "DBFILESLookupError.h"
#import "DBSHARINGCreateSharedLinkError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGCreateSharedLinkError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGCreateSharedLinkErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBSHARINGCreateSharedLinkErrorPath;
}

- (BOOL)isOther {
  return _tag == DBSHARINGCreateSharedLinkErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGCreateSharedLinkErrorPath:
    return @"DBSHARINGCreateSharedLinkErrorPath";
  case DBSHARINGCreateSharedLinkErrorOther:
    return @"DBSHARINGCreateSharedLinkErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGCreateSharedLinkErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGCreateSharedLinkErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGCreateSharedLinkErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGCreateSharedLinkErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBSHARINGCreateSharedLinkErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateSharedLinkError:other];
}

- (BOOL)isEqualToCreateSharedLinkError:(DBSHARINGCreateSharedLinkError *)aCreateSharedLinkError {
  if (self == aCreateSharedLinkError) {
    return YES;
  }
  if (self.tag != aCreateSharedLinkError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGCreateSharedLinkErrorPath:
    return [self.path isEqual:aCreateSharedLinkError.path];
  case DBSHARINGCreateSharedLinkErrorOther:
    return [[self tagName] isEqual:[aCreateSharedLinkError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGCreateSharedLinkErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGCreateSharedLinkError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGCreateSharedLinkError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBSHARINGCreateSharedLinkError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGCreateSharedLinkError alloc] initWithOther];
  } else {
    return [[DBSHARINGCreateSharedLinkError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGCreateSharedLinkWithSettingsArg.h"
#import "DBSHARINGSharedLinkSettings.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGCreateSharedLinkWithSettingsArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path settings:(DBSHARINGSharedLinkSettings *)settings {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        stringValidator:nil
                              maxLength:nil
                                pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _settings = settings;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path settings:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGCreateSharedLinkWithSettingsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGCreateSharedLinkWithSettingsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGCreateSharedLinkWithSettingsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.settings != nil) {
    result = prime * result + [self.settings hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateSharedLinkWithSettingsArg:other];
}

- (BOOL)isEqualToCreateSharedLinkWithSettingsArg:
    (DBSHARINGCreateSharedLinkWithSettingsArg *)aCreateSharedLinkWithSettingsArg {
  if (self == aCreateSharedLinkWithSettingsArg) {
    return YES;
  }
  if (![self.path isEqual:aCreateSharedLinkWithSettingsArg.path]) {
    return NO;
  }
  if (self.settings) {
    if (![self.settings isEqual:aCreateSharedLinkWithSettingsArg.settings]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGCreateSharedLinkWithSettingsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGCreateSharedLinkWithSettingsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.settings) {
    jsonDict[@"settings"] = [DBSHARINGSharedLinkSettingsSerializer serialize:valueObj.settings];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGCreateSharedLinkWithSettingsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBSHARINGSharedLinkSettings *settings =
      valueDict[@"settings"] ? [DBSHARINGSharedLinkSettingsSerializer deserialize:valueDict[@"settings"]] : nil;

  return [[DBSHARINGCreateSharedLinkWithSettingsArg alloc] initWithPath:path settings:settings];
}

@end

#import "DBFILESLookupError.h"
#import "DBSHARINGCreateSharedLinkWithSettingsError.h"
#import "DBSHARINGSharedLinkAlreadyExistsMetadata.h"
#import "DBSHARINGSharedLinkSettingsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGCreateSharedLinkWithSettingsError

@synthesize path = _path;
@synthesize sharedLinkAlreadyExists = _sharedLinkAlreadyExists;
@synthesize settingsError = _settingsError;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkWithSettingsErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithEmailNotVerified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified;
  }
  return self;
}

- (instancetype)initWithSharedLinkAlreadyExists:(DBSHARINGSharedLinkAlreadyExistsMetadata *)sharedLinkAlreadyExists {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists;
    _sharedLinkAlreadyExists = sharedLinkAlreadyExists;
  }
  return self;
}

- (instancetype)initWithSettingsError:(DBSHARINGSharedLinkSettingsError *)settingsError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError;
    _settingsError = settingsError;
  }
  return self;
}

- (instancetype)initWithAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGCreateSharedLinkWithSettingsErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

- (DBSHARINGSharedLinkAlreadyExistsMetadata *)sharedLinkAlreadyExists {
  if (![self isSharedLinkAlreadyExists]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists, but was %@.",
               [self tagName]];
  }
  return _sharedLinkAlreadyExists;
}

- (DBSHARINGSharedLinkSettingsError *)settingsError {
  if (![self isSettingsError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError, but was %@.",
                       [self tagName]];
  }
  return _settingsError;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBSHARINGCreateSharedLinkWithSettingsErrorPath;
}

- (BOOL)isEmailNotVerified {
  return _tag == DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified;
}

- (BOOL)isSharedLinkAlreadyExists {
  return _tag == DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists;
}

- (BOOL)isSettingsError {
  return _tag == DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError;
}

- (BOOL)isAccessDenied {
  return _tag == DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGCreateSharedLinkWithSettingsErrorPath:
    return @"DBSHARINGCreateSharedLinkWithSettingsErrorPath";
  case DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified:
    return @"DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified";
  case DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists:
    return @"DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists";
  case DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError:
    return @"DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError";
  case DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied:
    return @"DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGCreateSharedLinkWithSettingsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGCreateSharedLinkWithSettingsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGCreateSharedLinkWithSettingsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGCreateSharedLinkWithSettingsErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists:
    if (self.sharedLinkAlreadyExists != nil) {
      result = prime * result + [self.sharedLinkAlreadyExists hash];
    }
    break;
  case DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError:
    result = prime * result + [self.settingsError hash];
    break;
  case DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateSharedLinkWithSettingsError:other];
}

- (BOOL)isEqualToCreateSharedLinkWithSettingsError:
    (DBSHARINGCreateSharedLinkWithSettingsError *)aCreateSharedLinkWithSettingsError {
  if (self == aCreateSharedLinkWithSettingsError) {
    return YES;
  }
  if (self.tag != aCreateSharedLinkWithSettingsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGCreateSharedLinkWithSettingsErrorPath:
    return [self.path isEqual:aCreateSharedLinkWithSettingsError.path];
  case DBSHARINGCreateSharedLinkWithSettingsErrorEmailNotVerified:
    return [[self tagName] isEqual:[aCreateSharedLinkWithSettingsError tagName]];
  case DBSHARINGCreateSharedLinkWithSettingsErrorSharedLinkAlreadyExists:
    if (self.sharedLinkAlreadyExists) {
      return [self.sharedLinkAlreadyExists isEqual:aCreateSharedLinkWithSettingsError.sharedLinkAlreadyExists];
    }
  case DBSHARINGCreateSharedLinkWithSettingsErrorSettingsError:
    return [self.settingsError isEqual:aCreateSharedLinkWithSettingsError.settingsError];
  case DBSHARINGCreateSharedLinkWithSettingsErrorAccessDenied:
    return [[self tagName] isEqual:[aCreateSharedLinkWithSettingsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGCreateSharedLinkWithSettingsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGCreateSharedLinkWithSettingsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isEmailNotVerified]) {
    jsonDict[@".tag"] = @"email_not_verified";
  } else if ([valueObj isSharedLinkAlreadyExists]) {
    if (valueObj.sharedLinkAlreadyExists) {
      jsonDict[@"shared_link_already_exists"] =
          [[DBSHARINGSharedLinkAlreadyExistsMetadataSerializer serialize:valueObj.sharedLinkAlreadyExists] mutableCopy];
    }
    jsonDict[@".tag"] = @"shared_link_already_exists";
  } else if ([valueObj isSettingsError]) {
    jsonDict[@"settings_error"] =
        [[DBSHARINGSharedLinkSettingsErrorSerializer serialize:valueObj.settingsError] mutableCopy];
    jsonDict[@".tag"] = @"settings_error";
  } else if ([valueObj isAccessDenied]) {
    jsonDict[@".tag"] = @"access_denied";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGCreateSharedLinkWithSettingsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBSHARINGCreateSharedLinkWithSettingsError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"email_not_verified"]) {
    return [[DBSHARINGCreateSharedLinkWithSettingsError alloc] initWithEmailNotVerified];
  } else if ([tag isEqualToString:@"shared_link_already_exists"]) {
    DBSHARINGSharedLinkAlreadyExistsMetadata *sharedLinkAlreadyExists =
        valueDict[@"shared_link_already_exists"]
            ? [DBSHARINGSharedLinkAlreadyExistsMetadataSerializer deserialize:valueDict[@"shared_link_already_exists"]]
            : nil;
    return [[DBSHARINGCreateSharedLinkWithSettingsError alloc] initWithSharedLinkAlreadyExists:sharedLinkAlreadyExists];
  } else if ([tag isEqualToString:@"settings_error"]) {
    DBSHARINGSharedLinkSettingsError *settingsError =
        [DBSHARINGSharedLinkSettingsErrorSerializer deserialize:valueDict[@"settings_error"]];
    return [[DBSHARINGCreateSharedLinkWithSettingsError alloc] initWithSettingsError:settingsError];
  } else if ([tag isEqualToString:@"access_denied"]) {
    return [[DBSHARINGCreateSharedLinkWithSettingsError alloc] initWithAccessDenied];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGAudienceRestrictingSharedFolder.h"
#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGLinkPermission.h"
#import "DBSHARINGSharedContentLinkMetadataBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedContentLinkMetadataBase

#pragma mark - Constructors

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected
                            accessLevel:(DBSHARINGAccessLevel *)accessLevel
        audienceRestrictingSharedFolder:(DBSHARINGAudienceRestrictingSharedFolder *)audienceRestrictingSharedFolder
                                 expiry:(NSDate *)expiry {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](audienceOptions);
  [DBStoneValidators nonnullValidator:nil](currentAudience);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](linkPermissions);
  [DBStoneValidators nonnullValidator:nil](passwordProtected);

  self = [super init];
  if (self) {
    _accessLevel = accessLevel;
    _audienceOptions = audienceOptions;
    _audienceRestrictingSharedFolder = audienceRestrictingSharedFolder;
    _currentAudience = currentAudience;
    _expiry = expiry;
    _linkPermissions = linkPermissions;
    _passwordProtected = passwordProtected;
  }
  return self;
}

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected {
  return [self initWithAudienceOptions:audienceOptions
                       currentAudience:currentAudience
                       linkPermissions:linkPermissions
                     passwordProtected:passwordProtected
                           accessLevel:nil
       audienceRestrictingSharedFolder:nil
                                expiry:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedContentLinkMetadataBaseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedContentLinkMetadataBaseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedContentLinkMetadataBaseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.audienceOptions hash];
  result = prime * result + [self.currentAudience hash];
  result = prime * result + [self.linkPermissions hash];
  result = prime * result + [self.passwordProtected hash];
  if (self.accessLevel != nil) {
    result = prime * result + [self.accessLevel hash];
  }
  if (self.audienceRestrictingSharedFolder != nil) {
    result = prime * result + [self.audienceRestrictingSharedFolder hash];
  }
  if (self.expiry != nil) {
    result = prime * result + [self.expiry hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedContentLinkMetadataBase:other];
}

- (BOOL)isEqualToSharedContentLinkMetadataBase:
    (DBSHARINGSharedContentLinkMetadataBase *)aSharedContentLinkMetadataBase {
  if (self == aSharedContentLinkMetadataBase) {
    return YES;
  }
  if (![self.audienceOptions isEqual:aSharedContentLinkMetadataBase.audienceOptions]) {
    return NO;
  }
  if (![self.currentAudience isEqual:aSharedContentLinkMetadataBase.currentAudience]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:aSharedContentLinkMetadataBase.linkPermissions]) {
    return NO;
  }
  if (![self.passwordProtected isEqual:aSharedContentLinkMetadataBase.passwordProtected]) {
    return NO;
  }
  if (self.accessLevel) {
    if (![self.accessLevel isEqual:aSharedContentLinkMetadataBase.accessLevel]) {
      return NO;
    }
  }
  if (self.audienceRestrictingSharedFolder) {
    if (![self.audienceRestrictingSharedFolder
            isEqual:aSharedContentLinkMetadataBase.audienceRestrictingSharedFolder]) {
      return NO;
    }
  }
  if (self.expiry) {
    if (![self.expiry isEqual:aSharedContentLinkMetadataBase.expiry]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedContentLinkMetadataBaseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedContentLinkMetadataBase *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"audience_options"] = [DBArraySerializer serialize:valueObj.audienceOptions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkAudienceSerializer serialize:elem0];
                                                     }];
  jsonDict[@"current_audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.currentAudience];
  jsonDict[@"link_permissions"] = [DBArraySerializer serialize:valueObj.linkPermissions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkPermissionSerializer serialize:elem0];
                                                     }];
  jsonDict[@"password_protected"] = valueObj.passwordProtected;
  if (valueObj.accessLevel) {
    jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  }
  if (valueObj.audienceRestrictingSharedFolder) {
    jsonDict[@"audience_restricting_shared_folder"] =
        [DBSHARINGAudienceRestrictingSharedFolderSerializer serialize:valueObj.audienceRestrictingSharedFolder];
  }
  if (valueObj.expiry) {
    jsonDict[@"expiry"] = [DBNSDateSerializer serialize:valueObj.expiry dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedContentLinkMetadataBase *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGLinkAudience *> *audienceOptions =
      [DBArraySerializer deserialize:valueDict[@"audience_options"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkAudienceSerializer deserialize:elem0];
                           }];
  DBSHARINGLinkAudience *currentAudience = [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"current_audience"]];
  NSArray<DBSHARINGLinkPermission *> *linkPermissions =
      [DBArraySerializer deserialize:valueDict[@"link_permissions"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkPermissionSerializer deserialize:elem0];
                           }];
  NSNumber *passwordProtected = valueDict[@"password_protected"];
  DBSHARINGAccessLevel *accessLevel =
      valueDict[@"access_level"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]] : nil;
  DBSHARINGAudienceRestrictingSharedFolder *audienceRestrictingSharedFolder =
      valueDict[@"audience_restricting_shared_folder"]
          ? [DBSHARINGAudienceRestrictingSharedFolderSerializer
                deserialize:valueDict[@"audience_restricting_shared_folder"]]
          : nil;
  NSDate *expiry = valueDict[@"expiry"]
                       ? [DBNSDateSerializer deserialize:valueDict[@"expiry"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                       : nil;

  return [[DBSHARINGSharedContentLinkMetadataBase alloc] initWithAudienceOptions:audienceOptions
                                                                 currentAudience:currentAudience
                                                                 linkPermissions:linkPermissions
                                                               passwordProtected:passwordProtected
                                                                     accessLevel:accessLevel
                                                 audienceRestrictingSharedFolder:audienceRestrictingSharedFolder
                                                                          expiry:expiry];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGAudienceRestrictingSharedFolder.h"
#import "DBSHARINGExpectedSharedContentLinkMetadata.h"
#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGLinkPermission.h"
#import "DBSHARINGSharedContentLinkMetadataBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGExpectedSharedContentLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected
                            accessLevel:(DBSHARINGAccessLevel *)accessLevel
        audienceRestrictingSharedFolder:(DBSHARINGAudienceRestrictingSharedFolder *)audienceRestrictingSharedFolder
                                 expiry:(NSDate *)expiry {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](audienceOptions);
  [DBStoneValidators nonnullValidator:nil](currentAudience);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](linkPermissions);
  [DBStoneValidators nonnullValidator:nil](passwordProtected);

  self = [super initWithAudienceOptions:audienceOptions
                        currentAudience:currentAudience
                        linkPermissions:linkPermissions
                      passwordProtected:passwordProtected
                            accessLevel:accessLevel
        audienceRestrictingSharedFolder:audienceRestrictingSharedFolder
                                 expiry:expiry];
  if (self) {
  }
  return self;
}

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected {
  return [self initWithAudienceOptions:audienceOptions
                       currentAudience:currentAudience
                       linkPermissions:linkPermissions
                     passwordProtected:passwordProtected
                           accessLevel:nil
       audienceRestrictingSharedFolder:nil
                                expiry:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGExpectedSharedContentLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGExpectedSharedContentLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGExpectedSharedContentLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.audienceOptions hash];
  result = prime * result + [self.currentAudience hash];
  result = prime * result + [self.linkPermissions hash];
  result = prime * result + [self.passwordProtected hash];
  if (self.accessLevel != nil) {
    result = prime * result + [self.accessLevel hash];
  }
  if (self.audienceRestrictingSharedFolder != nil) {
    result = prime * result + [self.audienceRestrictingSharedFolder hash];
  }
  if (self.expiry != nil) {
    result = prime * result + [self.expiry hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExpectedSharedContentLinkMetadata:other];
}

- (BOOL)isEqualToExpectedSharedContentLinkMetadata:
    (DBSHARINGExpectedSharedContentLinkMetadata *)anExpectedSharedContentLinkMetadata {
  if (self == anExpectedSharedContentLinkMetadata) {
    return YES;
  }
  if (![self.audienceOptions isEqual:anExpectedSharedContentLinkMetadata.audienceOptions]) {
    return NO;
  }
  if (![self.currentAudience isEqual:anExpectedSharedContentLinkMetadata.currentAudience]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:anExpectedSharedContentLinkMetadata.linkPermissions]) {
    return NO;
  }
  if (![self.passwordProtected isEqual:anExpectedSharedContentLinkMetadata.passwordProtected]) {
    return NO;
  }
  if (self.accessLevel) {
    if (![self.accessLevel isEqual:anExpectedSharedContentLinkMetadata.accessLevel]) {
      return NO;
    }
  }
  if (self.audienceRestrictingSharedFolder) {
    if (![self.audienceRestrictingSharedFolder
            isEqual:anExpectedSharedContentLinkMetadata.audienceRestrictingSharedFolder]) {
      return NO;
    }
  }
  if (self.expiry) {
    if (![self.expiry isEqual:anExpectedSharedContentLinkMetadata.expiry]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGExpectedSharedContentLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGExpectedSharedContentLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"audience_options"] = [DBArraySerializer serialize:valueObj.audienceOptions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkAudienceSerializer serialize:elem0];
                                                     }];
  jsonDict[@"current_audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.currentAudience];
  jsonDict[@"link_permissions"] = [DBArraySerializer serialize:valueObj.linkPermissions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkPermissionSerializer serialize:elem0];
                                                     }];
  jsonDict[@"password_protected"] = valueObj.passwordProtected;
  if (valueObj.accessLevel) {
    jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  }
  if (valueObj.audienceRestrictingSharedFolder) {
    jsonDict[@"audience_restricting_shared_folder"] =
        [DBSHARINGAudienceRestrictingSharedFolderSerializer serialize:valueObj.audienceRestrictingSharedFolder];
  }
  if (valueObj.expiry) {
    jsonDict[@"expiry"] = [DBNSDateSerializer serialize:valueObj.expiry dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGExpectedSharedContentLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGLinkAudience *> *audienceOptions =
      [DBArraySerializer deserialize:valueDict[@"audience_options"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkAudienceSerializer deserialize:elem0];
                           }];
  DBSHARINGLinkAudience *currentAudience = [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"current_audience"]];
  NSArray<DBSHARINGLinkPermission *> *linkPermissions =
      [DBArraySerializer deserialize:valueDict[@"link_permissions"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkPermissionSerializer deserialize:elem0];
                           }];
  NSNumber *passwordProtected = valueDict[@"password_protected"];
  DBSHARINGAccessLevel *accessLevel =
      valueDict[@"access_level"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]] : nil;
  DBSHARINGAudienceRestrictingSharedFolder *audienceRestrictingSharedFolder =
      valueDict[@"audience_restricting_shared_folder"]
          ? [DBSHARINGAudienceRestrictingSharedFolderSerializer
                deserialize:valueDict[@"audience_restricting_shared_folder"]]
          : nil;
  NSDate *expiry = valueDict[@"expiry"]
                       ? [DBNSDateSerializer deserialize:valueDict[@"expiry"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                       : nil;

  return [[DBSHARINGExpectedSharedContentLinkMetadata alloc] initWithAudienceOptions:audienceOptions
                                                                     currentAudience:currentAudience
                                                                     linkPermissions:linkPermissions
                                                                   passwordProtected:passwordProtected
                                                                         accessLevel:accessLevel
                                                     audienceRestrictingSharedFolder:audienceRestrictingSharedFolder
                                                                              expiry:expiry];
}

@end

#import "DBSHARINGFileAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileAction

#pragma mark - Constructors

- (instancetype)initWithDisableViewerInfo {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionDisableViewerInfo;
  }
  return self;
}

- (instancetype)initWithEditContents {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionEditContents;
  }
  return self;
}

- (instancetype)initWithEnableViewerInfo {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionEnableViewerInfo;
  }
  return self;
}

- (instancetype)initWithInviteViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionInviteViewer;
  }
  return self;
}

- (instancetype)initWithInviteViewerNoComment {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionInviteViewerNoComment;
  }
  return self;
}

- (instancetype)initWithInviteEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionInviteEditor;
  }
  return self;
}

- (instancetype)initWithUnshare {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionUnshare;
  }
  return self;
}

- (instancetype)initWithRelinquishMembership {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionRelinquishMembership;
  }
  return self;
}

- (instancetype)initWithShareLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionShareLink;
  }
  return self;
}

- (instancetype)initWithCreateLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionCreateLink;
  }
  return self;
}

- (instancetype)initWithCreateViewLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionCreateViewLink;
  }
  return self;
}

- (instancetype)initWithCreateEditLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionCreateEditLink;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileActionOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisableViewerInfo {
  return _tag == DBSHARINGFileActionDisableViewerInfo;
}

- (BOOL)isEditContents {
  return _tag == DBSHARINGFileActionEditContents;
}

- (BOOL)isEnableViewerInfo {
  return _tag == DBSHARINGFileActionEnableViewerInfo;
}

- (BOOL)isInviteViewer {
  return _tag == DBSHARINGFileActionInviteViewer;
}

- (BOOL)isInviteViewerNoComment {
  return _tag == DBSHARINGFileActionInviteViewerNoComment;
}

- (BOOL)isInviteEditor {
  return _tag == DBSHARINGFileActionInviteEditor;
}

- (BOOL)isUnshare {
  return _tag == DBSHARINGFileActionUnshare;
}

- (BOOL)isRelinquishMembership {
  return _tag == DBSHARINGFileActionRelinquishMembership;
}

- (BOOL)isShareLink {
  return _tag == DBSHARINGFileActionShareLink;
}

- (BOOL)isCreateLink {
  return _tag == DBSHARINGFileActionCreateLink;
}

- (BOOL)isCreateViewLink {
  return _tag == DBSHARINGFileActionCreateViewLink;
}

- (BOOL)isCreateEditLink {
  return _tag == DBSHARINGFileActionCreateEditLink;
}

- (BOOL)isOther {
  return _tag == DBSHARINGFileActionOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFileActionDisableViewerInfo:
    return @"DBSHARINGFileActionDisableViewerInfo";
  case DBSHARINGFileActionEditContents:
    return @"DBSHARINGFileActionEditContents";
  case DBSHARINGFileActionEnableViewerInfo:
    return @"DBSHARINGFileActionEnableViewerInfo";
  case DBSHARINGFileActionInviteViewer:
    return @"DBSHARINGFileActionInviteViewer";
  case DBSHARINGFileActionInviteViewerNoComment:
    return @"DBSHARINGFileActionInviteViewerNoComment";
  case DBSHARINGFileActionInviteEditor:
    return @"DBSHARINGFileActionInviteEditor";
  case DBSHARINGFileActionUnshare:
    return @"DBSHARINGFileActionUnshare";
  case DBSHARINGFileActionRelinquishMembership:
    return @"DBSHARINGFileActionRelinquishMembership";
  case DBSHARINGFileActionShareLink:
    return @"DBSHARINGFileActionShareLink";
  case DBSHARINGFileActionCreateLink:
    return @"DBSHARINGFileActionCreateLink";
  case DBSHARINGFileActionCreateViewLink:
    return @"DBSHARINGFileActionCreateViewLink";
  case DBSHARINGFileActionCreateEditLink:
    return @"DBSHARINGFileActionCreateEditLink";
  case DBSHARINGFileActionOther:
    return @"DBSHARINGFileActionOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileActionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileActionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileActionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFileActionDisableViewerInfo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionEditContents:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionEnableViewerInfo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionInviteViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionInviteViewerNoComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionInviteEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionUnshare:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionRelinquishMembership:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionShareLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionCreateLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionCreateViewLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionCreateEditLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileActionOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileAction:other];
}

- (BOOL)isEqualToFileAction:(DBSHARINGFileAction *)aFileAction {
  if (self == aFileAction) {
    return YES;
  }
  if (self.tag != aFileAction.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFileActionDisableViewerInfo:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionEditContents:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionEnableViewerInfo:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionInviteViewer:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionInviteViewerNoComment:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionInviteEditor:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionUnshare:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionRelinquishMembership:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionShareLink:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionCreateLink:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionCreateViewLink:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionCreateEditLink:
    return [[self tagName] isEqual:[aFileAction tagName]];
  case DBSHARINGFileActionOther:
    return [[self tagName] isEqual:[aFileAction tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileActionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileAction *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisableViewerInfo]) {
    jsonDict[@".tag"] = @"disable_viewer_info";
  } else if ([valueObj isEditContents]) {
    jsonDict[@".tag"] = @"edit_contents";
  } else if ([valueObj isEnableViewerInfo]) {
    jsonDict[@".tag"] = @"enable_viewer_info";
  } else if ([valueObj isInviteViewer]) {
    jsonDict[@".tag"] = @"invite_viewer";
  } else if ([valueObj isInviteViewerNoComment]) {
    jsonDict[@".tag"] = @"invite_viewer_no_comment";
  } else if ([valueObj isInviteEditor]) {
    jsonDict[@".tag"] = @"invite_editor";
  } else if ([valueObj isUnshare]) {
    jsonDict[@".tag"] = @"unshare";
  } else if ([valueObj isRelinquishMembership]) {
    jsonDict[@".tag"] = @"relinquish_membership";
  } else if ([valueObj isShareLink]) {
    jsonDict[@".tag"] = @"share_link";
  } else if ([valueObj isCreateLink]) {
    jsonDict[@".tag"] = @"create_link";
  } else if ([valueObj isCreateViewLink]) {
    jsonDict[@".tag"] = @"create_view_link";
  } else if ([valueObj isCreateEditLink]) {
    jsonDict[@".tag"] = @"create_edit_link";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileAction *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disable_viewer_info"]) {
    return [[DBSHARINGFileAction alloc] initWithDisableViewerInfo];
  } else if ([tag isEqualToString:@"edit_contents"]) {
    return [[DBSHARINGFileAction alloc] initWithEditContents];
  } else if ([tag isEqualToString:@"enable_viewer_info"]) {
    return [[DBSHARINGFileAction alloc] initWithEnableViewerInfo];
  } else if ([tag isEqualToString:@"invite_viewer"]) {
    return [[DBSHARINGFileAction alloc] initWithInviteViewer];
  } else if ([tag isEqualToString:@"invite_viewer_no_comment"]) {
    return [[DBSHARINGFileAction alloc] initWithInviteViewerNoComment];
  } else if ([tag isEqualToString:@"invite_editor"]) {
    return [[DBSHARINGFileAction alloc] initWithInviteEditor];
  } else if ([tag isEqualToString:@"unshare"]) {
    return [[DBSHARINGFileAction alloc] initWithUnshare];
  } else if ([tag isEqualToString:@"relinquish_membership"]) {
    return [[DBSHARINGFileAction alloc] initWithRelinquishMembership];
  } else if ([tag isEqualToString:@"share_link"]) {
    return [[DBSHARINGFileAction alloc] initWithShareLink];
  } else if ([tag isEqualToString:@"create_link"]) {
    return [[DBSHARINGFileAction alloc] initWithCreateLink];
  } else if ([tag isEqualToString:@"create_view_link"]) {
    return [[DBSHARINGFileAction alloc] initWithCreateViewLink];
  } else if ([tag isEqualToString:@"create_edit_link"]) {
    return [[DBSHARINGFileAction alloc] initWithCreateEditLink];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGFileAction alloc] initWithOther];
  } else {
    return [[DBSHARINGFileAction alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFileErrorResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileErrorResult

@synthesize fileNotFoundError = _fileNotFoundError;
@synthesize invalidFileActionError = _invalidFileActionError;
@synthesize permissionDeniedError = _permissionDeniedError;

#pragma mark - Constructors

- (instancetype)initWithFileNotFoundError:(NSString *)fileNotFoundError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileErrorResultFileNotFoundError;
    _fileNotFoundError = fileNotFoundError;
  }
  return self;
}

- (instancetype)initWithInvalidFileActionError:(NSString *)invalidFileActionError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileErrorResultInvalidFileActionError;
    _invalidFileActionError = invalidFileActionError;
  }
  return self;
}

- (instancetype)initWithPermissionDeniedError:(NSString *)permissionDeniedError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileErrorResultPermissionDeniedError;
    _permissionDeniedError = permissionDeniedError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileErrorResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)fileNotFoundError {
  if (![self isFileNotFoundError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGFileErrorResultFileNotFoundError, but was %@.", [self tagName]];
  }
  return _fileNotFoundError;
}

- (NSString *)invalidFileActionError {
  if (![self isInvalidFileActionError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileErrorResultInvalidFileActionError, but was %@.", [self tagName]];
  }
  return _invalidFileActionError;
}

- (NSString *)permissionDeniedError {
  if (![self isPermissionDeniedError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileErrorResultPermissionDeniedError, but was %@.", [self tagName]];
  }
  return _permissionDeniedError;
}

#pragma mark - Tag state methods

- (BOOL)isFileNotFoundError {
  return _tag == DBSHARINGFileErrorResultFileNotFoundError;
}

- (BOOL)isInvalidFileActionError {
  return _tag == DBSHARINGFileErrorResultInvalidFileActionError;
}

- (BOOL)isPermissionDeniedError {
  return _tag == DBSHARINGFileErrorResultPermissionDeniedError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGFileErrorResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFileErrorResultFileNotFoundError:
    return @"DBSHARINGFileErrorResultFileNotFoundError";
  case DBSHARINGFileErrorResultInvalidFileActionError:
    return @"DBSHARINGFileErrorResultInvalidFileActionError";
  case DBSHARINGFileErrorResultPermissionDeniedError:
    return @"DBSHARINGFileErrorResultPermissionDeniedError";
  case DBSHARINGFileErrorResultOther:
    return @"DBSHARINGFileErrorResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileErrorResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileErrorResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileErrorResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFileErrorResultFileNotFoundError:
    result = prime * result + [self.fileNotFoundError hash];
    break;
  case DBSHARINGFileErrorResultInvalidFileActionError:
    result = prime * result + [self.invalidFileActionError hash];
    break;
  case DBSHARINGFileErrorResultPermissionDeniedError:
    result = prime * result + [self.permissionDeniedError hash];
    break;
  case DBSHARINGFileErrorResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileErrorResult:other];
}

- (BOOL)isEqualToFileErrorResult:(DBSHARINGFileErrorResult *)aFileErrorResult {
  if (self == aFileErrorResult) {
    return YES;
  }
  if (self.tag != aFileErrorResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFileErrorResultFileNotFoundError:
    return [self.fileNotFoundError isEqual:aFileErrorResult.fileNotFoundError];
  case DBSHARINGFileErrorResultInvalidFileActionError:
    return [self.invalidFileActionError isEqual:aFileErrorResult.invalidFileActionError];
  case DBSHARINGFileErrorResultPermissionDeniedError:
    return [self.permissionDeniedError isEqual:aFileErrorResult.permissionDeniedError];
  case DBSHARINGFileErrorResultOther:
    return [[self tagName] isEqual:[aFileErrorResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileErrorResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileErrorResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFileNotFoundError]) {
    jsonDict[@"file_not_found_error"] = valueObj.fileNotFoundError;
    jsonDict[@".tag"] = @"file_not_found_error";
  } else if ([valueObj isInvalidFileActionError]) {
    jsonDict[@"invalid_file_action_error"] = valueObj.invalidFileActionError;
    jsonDict[@".tag"] = @"invalid_file_action_error";
  } else if ([valueObj isPermissionDeniedError]) {
    jsonDict[@"permission_denied_error"] = valueObj.permissionDeniedError;
    jsonDict[@".tag"] = @"permission_denied_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileErrorResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"file_not_found_error"]) {
    NSString *fileNotFoundError = valueDict[@"file_not_found_error"];
    return [[DBSHARINGFileErrorResult alloc] initWithFileNotFoundError:fileNotFoundError];
  } else if ([tag isEqualToString:@"invalid_file_action_error"]) {
    NSString *invalidFileActionError = valueDict[@"invalid_file_action_error"];
    return [[DBSHARINGFileErrorResult alloc] initWithInvalidFileActionError:invalidFileActionError];
  } else if ([tag isEqualToString:@"permission_denied_error"]) {
    NSString *permissionDeniedError = valueDict[@"permission_denied_error"];
    return [[DBSHARINGFileErrorResult alloc] initWithPermissionDeniedError:permissionDeniedError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGFileErrorResult alloc] initWithOther];
  } else {
    return [[DBSHARINGFileErrorResult alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFileLinkMetadata.h"
#import "DBSHARINGFolderLinkMetadata.h"
#import "DBSHARINGLinkPermissions.h"
#import "DBSHARINGSharedLinkMetadata.h"
#import "DBSHARINGTeamMemberInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions
                        id_:(NSString *)id_
                    expires:(NSDate *)expires
                  pathLower:(NSString *)pathLower
             teamMemberInfo:(DBSHARINGTeamMemberInfo *)teamMemberInfo
       contentOwnerTeamInfo:(DBUSERSTeam *)contentOwnerTeamInfo {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](linkPermissions);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);

  self = [super init];
  if (self) {
    _url = url;
    _id_ = id_;
    _name = name;
    _expires = expires;
    _pathLower = pathLower;
    _linkPermissions = linkPermissions;
    _teamMemberInfo = teamMemberInfo;
    _contentOwnerTeamInfo = contentOwnerTeamInfo;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions {
  return [self initWithUrl:url
                      name:name
           linkPermissions:linkPermissions
                       id_:nil
                   expires:nil
                 pathLower:nil
            teamMemberInfo:nil
      contentOwnerTeamInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.linkPermissions hash];
  if (self.id_ != nil) {
    result = prime * result + [self.id_ hash];
  }
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.teamMemberInfo != nil) {
    result = prime * result + [self.teamMemberInfo hash];
  }
  if (self.contentOwnerTeamInfo != nil) {
    result = prime * result + [self.contentOwnerTeamInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkMetadata:other];
}

- (BOOL)isEqualToSharedLinkMetadata:(DBSHARINGSharedLinkMetadata *)aSharedLinkMetadata {
  if (self == aSharedLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aSharedLinkMetadata.url]) {
    return NO;
  }
  if (![self.name isEqual:aSharedLinkMetadata.name]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:aSharedLinkMetadata.linkPermissions]) {
    return NO;
  }
  if (self.id_) {
    if (![self.id_ isEqual:aSharedLinkMetadata.id_]) {
      return NO;
    }
  }
  if (self.expires) {
    if (![self.expires isEqual:aSharedLinkMetadata.expires]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aSharedLinkMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.teamMemberInfo) {
    if (![self.teamMemberInfo isEqual:aSharedLinkMetadata.teamMemberInfo]) {
      return NO;
    }
  }
  if (self.contentOwnerTeamInfo) {
    if (![self.contentOwnerTeamInfo isEqual:aSharedLinkMetadata.contentOwnerTeamInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"link_permissions"] = [DBSHARINGLinkPermissionsSerializer serialize:valueObj.linkPermissions];
  if (valueObj.id_) {
    jsonDict[@"id"] = valueObj.id_;
  }
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.teamMemberInfo) {
    jsonDict[@"team_member_info"] = [DBSHARINGTeamMemberInfoSerializer serialize:valueObj.teamMemberInfo];
  }
  if (valueObj.contentOwnerTeamInfo) {
    jsonDict[@"content_owner_team_info"] = [DBUSERSTeamSerializer serialize:valueObj.contentOwnerTeamInfo];
  }

  if ([valueObj isKindOfClass:[DBSHARINGFileLinkMetadata class]]) {
    NSDictionary *subTypeFields = [DBSHARINGFileLinkMetadataSerializer serialize:(DBSHARINGFileLinkMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"file";
  } else if ([valueObj isKindOfClass:[DBSHARINGFolderLinkMetadata class]]) {
    NSDictionary *subTypeFields =
        [DBSHARINGFolderLinkMetadataSerializer serialize:(DBSHARINGFolderLinkMetadata *)valueObj];
    for (NSString *key in subTypeFields) {
      jsonDict[key] = subTypeFields[key];
    }
    jsonDict[@".tag"] = @"folder";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  if ([valueDict[@".tag"] isEqualToString:@"file"]) {
    return [DBSHARINGFileLinkMetadataSerializer deserialize:valueDict];
  }
  if ([valueDict[@".tag"] isEqualToString:@"folder"]) {
    return [DBSHARINGFolderLinkMetadataSerializer deserialize:valueDict];
  }

  NSString *url = valueDict[@"url"];
  NSString *name = valueDict[@"name"];
  DBSHARINGLinkPermissions *linkPermissions =
      [DBSHARINGLinkPermissionsSerializer deserialize:valueDict[@"link_permissions"]];
  NSString *id_ = valueDict[@"id"] ?: nil;
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  DBSHARINGTeamMemberInfo *teamMemberInfo =
      valueDict[@"team_member_info"] ? [DBSHARINGTeamMemberInfoSerializer deserialize:valueDict[@"team_member_info"]]
                                     : nil;
  DBUSERSTeam *contentOwnerTeamInfo = valueDict[@"content_owner_team_info"]
                                          ? [DBUSERSTeamSerializer deserialize:valueDict[@"content_owner_team_info"]]
                                          : nil;

  return [[DBSHARINGSharedLinkMetadata alloc] initWithUrl:url
                                                     name:name
                                          linkPermissions:linkPermissions
                                                      id_:id_
                                                  expires:expires
                                                pathLower:pathLower
                                           teamMemberInfo:teamMemberInfo
                                     contentOwnerTeamInfo:contentOwnerTeamInfo];
}

@end

#import "DBSHARINGFileLinkMetadata.h"
#import "DBSHARINGLinkPermissions.h"
#import "DBSHARINGSharedLinkMetadata.h"
#import "DBSHARINGTeamMemberInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGFileLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions
             clientModified:(NSDate *)clientModified
             serverModified:(NSDate *)serverModified
                        rev:(NSString *)rev
                       size:(NSNumber *)size
                        id_:(NSString *)id_
                    expires:(NSDate *)expires
                  pathLower:(NSString *)pathLower
             teamMemberInfo:(DBSHARINGTeamMemberInfo *)teamMemberInfo
       contentOwnerTeamInfo:(DBUSERSTeam *)contentOwnerTeamInfo {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](linkPermissions);
  [DBStoneValidators nonnullValidator:nil](clientModified);
  [DBStoneValidators nonnullValidator:nil](serverModified);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(9) maxLength:nil pattern:@"[0-9a-f]+"]](rev);
  [DBStoneValidators nonnullValidator:nil](size);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);

  self = [super initWithUrl:url
                       name:name
            linkPermissions:linkPermissions
                        id_:id_
                    expires:expires
                  pathLower:pathLower
             teamMemberInfo:teamMemberInfo
       contentOwnerTeamInfo:contentOwnerTeamInfo];
  if (self) {
    _clientModified = clientModified;
    _serverModified = serverModified;
    _rev = rev;
    _size = size;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions
             clientModified:(NSDate *)clientModified
             serverModified:(NSDate *)serverModified
                        rev:(NSString *)rev
                       size:(NSNumber *)size {
  return [self initWithUrl:url
                      name:name
           linkPermissions:linkPermissions
            clientModified:clientModified
            serverModified:serverModified
                       rev:rev
                      size:size
                       id_:nil
                   expires:nil
                 pathLower:nil
            teamMemberInfo:nil
      contentOwnerTeamInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.linkPermissions hash];
  result = prime * result + [self.clientModified hash];
  result = prime * result + [self.serverModified hash];
  result = prime * result + [self.rev hash];
  result = prime * result + [self.size hash];
  if (self.id_ != nil) {
    result = prime * result + [self.id_ hash];
  }
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.teamMemberInfo != nil) {
    result = prime * result + [self.teamMemberInfo hash];
  }
  if (self.contentOwnerTeamInfo != nil) {
    result = prime * result + [self.contentOwnerTeamInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileLinkMetadata:other];
}

- (BOOL)isEqualToFileLinkMetadata:(DBSHARINGFileLinkMetadata *)aFileLinkMetadata {
  if (self == aFileLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aFileLinkMetadata.url]) {
    return NO;
  }
  if (![self.name isEqual:aFileLinkMetadata.name]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:aFileLinkMetadata.linkPermissions]) {
    return NO;
  }
  if (![self.clientModified isEqual:aFileLinkMetadata.clientModified]) {
    return NO;
  }
  if (![self.serverModified isEqual:aFileLinkMetadata.serverModified]) {
    return NO;
  }
  if (![self.rev isEqual:aFileLinkMetadata.rev]) {
    return NO;
  }
  if (![self.size isEqual:aFileLinkMetadata.size]) {
    return NO;
  }
  if (self.id_) {
    if (![self.id_ isEqual:aFileLinkMetadata.id_]) {
      return NO;
    }
  }
  if (self.expires) {
    if (![self.expires isEqual:aFileLinkMetadata.expires]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aFileLinkMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.teamMemberInfo) {
    if (![self.teamMemberInfo isEqual:aFileLinkMetadata.teamMemberInfo]) {
      return NO;
    }
  }
  if (self.contentOwnerTeamInfo) {
    if (![self.contentOwnerTeamInfo isEqual:aFileLinkMetadata.contentOwnerTeamInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"link_permissions"] = [DBSHARINGLinkPermissionsSerializer serialize:valueObj.linkPermissions];
  jsonDict[@"client_modified"] =
      [DBNSDateSerializer serialize:valueObj.clientModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"server_modified"] =
      [DBNSDateSerializer serialize:valueObj.serverModified dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"rev"] = valueObj.rev;
  jsonDict[@"size"] = valueObj.size;
  if (valueObj.id_) {
    jsonDict[@"id"] = valueObj.id_;
  }
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.teamMemberInfo) {
    jsonDict[@"team_member_info"] = [DBSHARINGTeamMemberInfoSerializer serialize:valueObj.teamMemberInfo];
  }
  if (valueObj.contentOwnerTeamInfo) {
    jsonDict[@"content_owner_team_info"] = [DBUSERSTeamSerializer serialize:valueObj.contentOwnerTeamInfo];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *name = valueDict[@"name"];
  DBSHARINGLinkPermissions *linkPermissions =
      [DBSHARINGLinkPermissionsSerializer deserialize:valueDict[@"link_permissions"]];
  NSDate *clientModified =
      [DBNSDateSerializer deserialize:valueDict[@"client_modified"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSDate *serverModified =
      [DBNSDateSerializer deserialize:valueDict[@"server_modified"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSString *rev = valueDict[@"rev"];
  NSNumber *size = valueDict[@"size"];
  NSString *id_ = valueDict[@"id"] ?: nil;
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  DBSHARINGTeamMemberInfo *teamMemberInfo =
      valueDict[@"team_member_info"] ? [DBSHARINGTeamMemberInfoSerializer deserialize:valueDict[@"team_member_info"]]
                                     : nil;
  DBUSERSTeam *contentOwnerTeamInfo = valueDict[@"content_owner_team_info"]
                                          ? [DBUSERSTeamSerializer deserialize:valueDict[@"content_owner_team_info"]]
                                          : nil;

  return [[DBSHARINGFileLinkMetadata alloc] initWithUrl:url
                                                   name:name
                                        linkPermissions:linkPermissions
                                         clientModified:clientModified
                                         serverModified:serverModified
                                                    rev:rev
                                                   size:size
                                                    id_:id_
                                                expires:expires
                                              pathLower:pathLower
                                         teamMemberInfo:teamMemberInfo
                                   contentOwnerTeamInfo:contentOwnerTeamInfo];
}

@end

#import "DBSHARINGFileMemberActionError.h"
#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileMemberActionError

@synthesize accessError = _accessError;
@synthesize noExplicitAccess = _noExplicitAccess;

#pragma mark - Constructors

- (instancetype)initWithInvalidMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionErrorInvalidMember;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithNoExplicitAccess:(DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionErrorNoExplicitAccess;
    _noExplicitAccess = noExplicitAccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGFileMemberActionErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  if (![self isNoExplicitAccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileMemberActionErrorNoExplicitAccess, but was %@.", [self tagName]];
  }
  return _noExplicitAccess;
}

#pragma mark - Tag state methods

- (BOOL)isInvalidMember {
  return _tag == DBSHARINGFileMemberActionErrorInvalidMember;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGFileMemberActionErrorNoPermission;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGFileMemberActionErrorAccessError;
}

- (BOOL)isNoExplicitAccess {
  return _tag == DBSHARINGFileMemberActionErrorNoExplicitAccess;
}

- (BOOL)isOther {
  return _tag == DBSHARINGFileMemberActionErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFileMemberActionErrorInvalidMember:
    return @"DBSHARINGFileMemberActionErrorInvalidMember";
  case DBSHARINGFileMemberActionErrorNoPermission:
    return @"DBSHARINGFileMemberActionErrorNoPermission";
  case DBSHARINGFileMemberActionErrorAccessError:
    return @"DBSHARINGFileMemberActionErrorAccessError";
  case DBSHARINGFileMemberActionErrorNoExplicitAccess:
    return @"DBSHARINGFileMemberActionErrorNoExplicitAccess";
  case DBSHARINGFileMemberActionErrorOther:
    return @"DBSHARINGFileMemberActionErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileMemberActionErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileMemberActionErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileMemberActionErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFileMemberActionErrorInvalidMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileMemberActionErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFileMemberActionErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGFileMemberActionErrorNoExplicitAccess:
    result = prime * result + [self.noExplicitAccess hash];
    break;
  case DBSHARINGFileMemberActionErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileMemberActionError:other];
}

- (BOOL)isEqualToFileMemberActionError:(DBSHARINGFileMemberActionError *)aFileMemberActionError {
  if (self == aFileMemberActionError) {
    return YES;
  }
  if (self.tag != aFileMemberActionError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFileMemberActionErrorInvalidMember:
    return [[self tagName] isEqual:[aFileMemberActionError tagName]];
  case DBSHARINGFileMemberActionErrorNoPermission:
    return [[self tagName] isEqual:[aFileMemberActionError tagName]];
  case DBSHARINGFileMemberActionErrorAccessError:
    return [self.accessError isEqual:aFileMemberActionError.accessError];
  case DBSHARINGFileMemberActionErrorNoExplicitAccess:
    return [self.noExplicitAccess isEqual:aFileMemberActionError.noExplicitAccess];
  case DBSHARINGFileMemberActionErrorOther:
    return [[self tagName] isEqual:[aFileMemberActionError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileMemberActionErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileMemberActionError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidMember]) {
    jsonDict[@".tag"] = @"invalid_member";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isNoExplicitAccess]) {
    jsonDict = [[DBSHARINGMemberAccessLevelResultSerializer serialize:valueObj.noExplicitAccess] mutableCopy];
    jsonDict[@".tag"] = @"no_explicit_access";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileMemberActionError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_member"]) {
    return [[DBSHARINGFileMemberActionError alloc] initWithInvalidMember];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGFileMemberActionError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGFileMemberActionError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"no_explicit_access"]) {
    DBSHARINGMemberAccessLevelResult *noExplicitAccess =
        [DBSHARINGMemberAccessLevelResultSerializer deserialize:valueDict];
    return [[DBSHARINGFileMemberActionError alloc] initWithNoExplicitAccess:noExplicitAccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGFileMemberActionError alloc] initWithOther];
  } else {
    return [[DBSHARINGFileMemberActionError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGFileMemberActionError.h"
#import "DBSHARINGFileMemberActionIndividualResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileMemberActionIndividualResult

@synthesize success = _success;
@synthesize memberError = _memberError;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBSHARINGAccessLevel *)success {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionIndividualResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithMemberError:(DBSHARINGFileMemberActionError *)memberError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberActionIndividualResultMemberError;
    _memberError = memberError;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGAccessLevel *)success {
  if (![self isSuccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileMemberActionIndividualResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBSHARINGFileMemberActionError *)memberError {
  if (![self isMemberError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGFileMemberActionIndividualResultMemberError, but was %@.",
                       [self tagName]];
  }
  return _memberError;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBSHARINGFileMemberActionIndividualResultSuccess;
}

- (BOOL)isMemberError {
  return _tag == DBSHARINGFileMemberActionIndividualResultMemberError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFileMemberActionIndividualResultSuccess:
    return @"DBSHARINGFileMemberActionIndividualResultSuccess";
  case DBSHARINGFileMemberActionIndividualResultMemberError:
    return @"DBSHARINGFileMemberActionIndividualResultMemberError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileMemberActionIndividualResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileMemberActionIndividualResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileMemberActionIndividualResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFileMemberActionIndividualResultSuccess:
    if (self.success != nil) {
      result = prime * result + [self.success hash];
    }
    break;
  case DBSHARINGFileMemberActionIndividualResultMemberError:
    result = prime * result + [self.memberError hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileMemberActionIndividualResult:other];
}

- (BOOL)isEqualToFileMemberActionIndividualResult:
    (DBSHARINGFileMemberActionIndividualResult *)aFileMemberActionIndividualResult {
  if (self == aFileMemberActionIndividualResult) {
    return YES;
  }
  if (self.tag != aFileMemberActionIndividualResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFileMemberActionIndividualResultSuccess:
    if (self.success) {
      return [self.success isEqual:aFileMemberActionIndividualResult.success];
    }
  case DBSHARINGFileMemberActionIndividualResultMemberError:
    return [self.memberError isEqual:aFileMemberActionIndividualResult.memberError];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileMemberActionIndividualResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileMemberActionIndividualResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    if (valueObj.success) {
      jsonDict[@"success"] = [[DBSHARINGAccessLevelSerializer serialize:valueObj.success] mutableCopy];
    }
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isMemberError]) {
    jsonDict[@"member_error"] = [[DBSHARINGFileMemberActionErrorSerializer serialize:valueObj.memberError] mutableCopy];
    jsonDict[@".tag"] = @"member_error";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileMemberActionIndividualResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBSHARINGAccessLevel *success =
        valueDict[@"success"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"success"]] : nil;
    return [[DBSHARINGFileMemberActionIndividualResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"member_error"]) {
    DBSHARINGFileMemberActionError *memberError =
        [DBSHARINGFileMemberActionErrorSerializer deserialize:valueDict[@"member_error"]];
    return [[DBSHARINGFileMemberActionIndividualResult alloc] initWithMemberError:memberError];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGFileMemberActionIndividualResult.h"
#import "DBSHARINGFileMemberActionResult.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileMemberActionResult

#pragma mark - Constructors

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member
                        result:(DBSHARINGFileMemberActionIndividualResult *)result {
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](result);

  self = [super init];
  if (self) {
    _member = member;
    _result = result;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileMemberActionResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileMemberActionResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileMemberActionResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.member hash];
  result = prime * result + [self.result hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileMemberActionResult:other];
}

- (BOOL)isEqualToFileMemberActionResult:(DBSHARINGFileMemberActionResult *)aFileMemberActionResult {
  if (self == aFileMemberActionResult) {
    return YES;
  }
  if (![self.member isEqual:aFileMemberActionResult.member]) {
    return NO;
  }
  if (![self.result isEqual:aFileMemberActionResult.result]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileMemberActionResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileMemberActionResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"result"] = [DBSHARINGFileMemberActionIndividualResultSerializer serialize:valueObj.result];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileMemberActionResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBSHARINGFileMemberActionIndividualResult *result =
      [DBSHARINGFileMemberActionIndividualResultSerializer deserialize:valueDict[@"result"]];

  return [[DBSHARINGFileMemberActionResult alloc] initWithMember:member result:result];
}

@end

#import "DBSHARINGFileMemberActionError.h"
#import "DBSHARINGFileMemberRemoveActionResult.h"
#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFileMemberRemoveActionResult

@synthesize success = _success;
@synthesize memberError = _memberError;

#pragma mark - Constructors

- (instancetype)initWithSuccess:(DBSHARINGMemberAccessLevelResult *)success {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberRemoveActionResultSuccess;
    _success = success;
  }
  return self;
}

- (instancetype)initWithMemberError:(DBSHARINGFileMemberActionError *)memberError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberRemoveActionResultMemberError;
    _memberError = memberError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFileMemberRemoveActionResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGMemberAccessLevelResult *)success {
  if (![self isSuccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileMemberRemoveActionResultSuccess, but was %@.", [self tagName]];
  }
  return _success;
}

- (DBSHARINGFileMemberActionError *)memberError {
  if (![self isMemberError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGFileMemberRemoveActionResultMemberError, but was %@.", [self tagName]];
  }
  return _memberError;
}

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBSHARINGFileMemberRemoveActionResultSuccess;
}

- (BOOL)isMemberError {
  return _tag == DBSHARINGFileMemberRemoveActionResultMemberError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGFileMemberRemoveActionResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFileMemberRemoveActionResultSuccess:
    return @"DBSHARINGFileMemberRemoveActionResultSuccess";
  case DBSHARINGFileMemberRemoveActionResultMemberError:
    return @"DBSHARINGFileMemberRemoveActionResultMemberError";
  case DBSHARINGFileMemberRemoveActionResultOther:
    return @"DBSHARINGFileMemberRemoveActionResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFileMemberRemoveActionResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFileMemberRemoveActionResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFileMemberRemoveActionResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFileMemberRemoveActionResultSuccess:
    result = prime * result + [self.success hash];
    break;
  case DBSHARINGFileMemberRemoveActionResultMemberError:
    result = prime * result + [self.memberError hash];
    break;
  case DBSHARINGFileMemberRemoveActionResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileMemberRemoveActionResult:other];
}

- (BOOL)isEqualToFileMemberRemoveActionResult:(DBSHARINGFileMemberRemoveActionResult *)aFileMemberRemoveActionResult {
  if (self == aFileMemberRemoveActionResult) {
    return YES;
  }
  if (self.tag != aFileMemberRemoveActionResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFileMemberRemoveActionResultSuccess:
    return [self.success isEqual:aFileMemberRemoveActionResult.success];
  case DBSHARINGFileMemberRemoveActionResultMemberError:
    return [self.memberError isEqual:aFileMemberRemoveActionResult.memberError];
  case DBSHARINGFileMemberRemoveActionResultOther:
    return [[self tagName] isEqual:[aFileMemberRemoveActionResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFileMemberRemoveActionResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFileMemberRemoveActionResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict = [[DBSHARINGMemberAccessLevelResultSerializer serialize:valueObj.success] mutableCopy];
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isMemberError]) {
    jsonDict[@"member_error"] = [[DBSHARINGFileMemberActionErrorSerializer serialize:valueObj.memberError] mutableCopy];
    jsonDict[@".tag"] = @"member_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFileMemberRemoveActionResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    DBSHARINGMemberAccessLevelResult *success = [DBSHARINGMemberAccessLevelResultSerializer deserialize:valueDict];
    return [[DBSHARINGFileMemberRemoveActionResult alloc] initWithSuccess:success];
  } else if ([tag isEqualToString:@"member_error"]) {
    DBSHARINGFileMemberActionError *memberError =
        [DBSHARINGFileMemberActionErrorSerializer deserialize:valueDict[@"member_error"]];
    return [[DBSHARINGFileMemberRemoveActionResult alloc] initWithMemberError:memberError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGFileMemberRemoveActionResult alloc] initWithOther];
  } else {
    return [[DBSHARINGFileMemberRemoveActionResult alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFileAction.h"
#import "DBSHARINGFilePermission.h"
#import "DBSHARINGPermissionDeniedReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFilePermission

#pragma mark - Constructors

- (instancetype)initWithAction:(DBSHARINGFileAction *)action
                         allow:(NSNumber *)allow
                        reason:(DBSHARINGPermissionDeniedReason *)reason {
  [DBStoneValidators nonnullValidator:nil](action);
  [DBStoneValidators nonnullValidator:nil](allow);

  self = [super init];
  if (self) {
    _action = action;
    _allow = allow;
    _reason = reason;
  }
  return self;
}

- (instancetype)initWithAction:(DBSHARINGFileAction *)action allow:(NSNumber *)allow {
  return [self initWithAction:action allow:allow reason:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFilePermissionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFilePermissionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFilePermissionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.action hash];
  result = prime * result + [self.allow hash];
  if (self.reason != nil) {
    result = prime * result + [self.reason hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFilePermission:other];
}

- (BOOL)isEqualToFilePermission:(DBSHARINGFilePermission *)aFilePermission {
  if (self == aFilePermission) {
    return YES;
  }
  if (![self.action isEqual:aFilePermission.action]) {
    return NO;
  }
  if (![self.allow isEqual:aFilePermission.allow]) {
    return NO;
  }
  if (self.reason) {
    if (![self.reason isEqual:aFilePermission.reason]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFilePermissionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFilePermission *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"action"] = [DBSHARINGFileActionSerializer serialize:valueObj.action];
  jsonDict[@"allow"] = valueObj.allow;
  if (valueObj.reason) {
    jsonDict[@"reason"] = [DBSHARINGPermissionDeniedReasonSerializer serialize:valueObj.reason];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFilePermission *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGFileAction *action = [DBSHARINGFileActionSerializer deserialize:valueDict[@"action"]];
  NSNumber *allow = valueDict[@"allow"];
  DBSHARINGPermissionDeniedReason *reason =
      valueDict[@"reason"] ? [DBSHARINGPermissionDeniedReasonSerializer deserialize:valueDict[@"reason"]] : nil;

  return [[DBSHARINGFilePermission alloc] initWithAction:action allow:allow reason:reason];
}

@end

#import "DBSHARINGFolderAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFolderAction

#pragma mark - Constructors

- (instancetype)initWithChangeOptions {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionChangeOptions;
  }
  return self;
}

- (instancetype)initWithDisableViewerInfo {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionDisableViewerInfo;
  }
  return self;
}

- (instancetype)initWithEditContents {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionEditContents;
  }
  return self;
}

- (instancetype)initWithEnableViewerInfo {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionEnableViewerInfo;
  }
  return self;
}

- (instancetype)initWithInviteEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionInviteEditor;
  }
  return self;
}

- (instancetype)initWithInviteViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionInviteViewer;
  }
  return self;
}

- (instancetype)initWithInviteViewerNoComment {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionInviteViewerNoComment;
  }
  return self;
}

- (instancetype)initWithRelinquishMembership {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionRelinquishMembership;
  }
  return self;
}

- (instancetype)initWithUnmount {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionUnmount;
  }
  return self;
}

- (instancetype)initWithUnshare {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionUnshare;
  }
  return self;
}

- (instancetype)initWithLeaveACopy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionLeaveACopy;
  }
  return self;
}

- (instancetype)initWithShareLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionShareLink;
  }
  return self;
}

- (instancetype)initWithCreateLink {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionCreateLink;
  }
  return self;
}

- (instancetype)initWithSetAccessInheritance {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionSetAccessInheritance;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGFolderActionOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isChangeOptions {
  return _tag == DBSHARINGFolderActionChangeOptions;
}

- (BOOL)isDisableViewerInfo {
  return _tag == DBSHARINGFolderActionDisableViewerInfo;
}

- (BOOL)isEditContents {
  return _tag == DBSHARINGFolderActionEditContents;
}

- (BOOL)isEnableViewerInfo {
  return _tag == DBSHARINGFolderActionEnableViewerInfo;
}

- (BOOL)isInviteEditor {
  return _tag == DBSHARINGFolderActionInviteEditor;
}

- (BOOL)isInviteViewer {
  return _tag == DBSHARINGFolderActionInviteViewer;
}

- (BOOL)isInviteViewerNoComment {
  return _tag == DBSHARINGFolderActionInviteViewerNoComment;
}

- (BOOL)isRelinquishMembership {
  return _tag == DBSHARINGFolderActionRelinquishMembership;
}

- (BOOL)isUnmount {
  return _tag == DBSHARINGFolderActionUnmount;
}

- (BOOL)isUnshare {
  return _tag == DBSHARINGFolderActionUnshare;
}

- (BOOL)isLeaveACopy {
  return _tag == DBSHARINGFolderActionLeaveACopy;
}

- (BOOL)isShareLink {
  return _tag == DBSHARINGFolderActionShareLink;
}

- (BOOL)isCreateLink {
  return _tag == DBSHARINGFolderActionCreateLink;
}

- (BOOL)isSetAccessInheritance {
  return _tag == DBSHARINGFolderActionSetAccessInheritance;
}

- (BOOL)isOther {
  return _tag == DBSHARINGFolderActionOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGFolderActionChangeOptions:
    return @"DBSHARINGFolderActionChangeOptions";
  case DBSHARINGFolderActionDisableViewerInfo:
    return @"DBSHARINGFolderActionDisableViewerInfo";
  case DBSHARINGFolderActionEditContents:
    return @"DBSHARINGFolderActionEditContents";
  case DBSHARINGFolderActionEnableViewerInfo:
    return @"DBSHARINGFolderActionEnableViewerInfo";
  case DBSHARINGFolderActionInviteEditor:
    return @"DBSHARINGFolderActionInviteEditor";
  case DBSHARINGFolderActionInviteViewer:
    return @"DBSHARINGFolderActionInviteViewer";
  case DBSHARINGFolderActionInviteViewerNoComment:
    return @"DBSHARINGFolderActionInviteViewerNoComment";
  case DBSHARINGFolderActionRelinquishMembership:
    return @"DBSHARINGFolderActionRelinquishMembership";
  case DBSHARINGFolderActionUnmount:
    return @"DBSHARINGFolderActionUnmount";
  case DBSHARINGFolderActionUnshare:
    return @"DBSHARINGFolderActionUnshare";
  case DBSHARINGFolderActionLeaveACopy:
    return @"DBSHARINGFolderActionLeaveACopy";
  case DBSHARINGFolderActionShareLink:
    return @"DBSHARINGFolderActionShareLink";
  case DBSHARINGFolderActionCreateLink:
    return @"DBSHARINGFolderActionCreateLink";
  case DBSHARINGFolderActionSetAccessInheritance:
    return @"DBSHARINGFolderActionSetAccessInheritance";
  case DBSHARINGFolderActionOther:
    return @"DBSHARINGFolderActionOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFolderActionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFolderActionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFolderActionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGFolderActionChangeOptions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionDisableViewerInfo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionEditContents:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionEnableViewerInfo:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionInviteEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionInviteViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionInviteViewerNoComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionRelinquishMembership:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionUnmount:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionUnshare:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionLeaveACopy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionShareLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionCreateLink:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionSetAccessInheritance:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGFolderActionOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderAction:other];
}

- (BOOL)isEqualToFolderAction:(DBSHARINGFolderAction *)aFolderAction {
  if (self == aFolderAction) {
    return YES;
  }
  if (self.tag != aFolderAction.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGFolderActionChangeOptions:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionDisableViewerInfo:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionEditContents:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionEnableViewerInfo:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionInviteEditor:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionInviteViewer:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionInviteViewerNoComment:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionRelinquishMembership:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionUnmount:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionUnshare:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionLeaveACopy:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionShareLink:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionCreateLink:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionSetAccessInheritance:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  case DBSHARINGFolderActionOther:
    return [[self tagName] isEqual:[aFolderAction tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFolderActionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFolderAction *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isChangeOptions]) {
    jsonDict[@".tag"] = @"change_options";
  } else if ([valueObj isDisableViewerInfo]) {
    jsonDict[@".tag"] = @"disable_viewer_info";
  } else if ([valueObj isEditContents]) {
    jsonDict[@".tag"] = @"edit_contents";
  } else if ([valueObj isEnableViewerInfo]) {
    jsonDict[@".tag"] = @"enable_viewer_info";
  } else if ([valueObj isInviteEditor]) {
    jsonDict[@".tag"] = @"invite_editor";
  } else if ([valueObj isInviteViewer]) {
    jsonDict[@".tag"] = @"invite_viewer";
  } else if ([valueObj isInviteViewerNoComment]) {
    jsonDict[@".tag"] = @"invite_viewer_no_comment";
  } else if ([valueObj isRelinquishMembership]) {
    jsonDict[@".tag"] = @"relinquish_membership";
  } else if ([valueObj isUnmount]) {
    jsonDict[@".tag"] = @"unmount";
  } else if ([valueObj isUnshare]) {
    jsonDict[@".tag"] = @"unshare";
  } else if ([valueObj isLeaveACopy]) {
    jsonDict[@".tag"] = @"leave_a_copy";
  } else if ([valueObj isShareLink]) {
    jsonDict[@".tag"] = @"share_link";
  } else if ([valueObj isCreateLink]) {
    jsonDict[@".tag"] = @"create_link";
  } else if ([valueObj isSetAccessInheritance]) {
    jsonDict[@".tag"] = @"set_access_inheritance";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFolderAction *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"change_options"]) {
    return [[DBSHARINGFolderAction alloc] initWithChangeOptions];
  } else if ([tag isEqualToString:@"disable_viewer_info"]) {
    return [[DBSHARINGFolderAction alloc] initWithDisableViewerInfo];
  } else if ([tag isEqualToString:@"edit_contents"]) {
    return [[DBSHARINGFolderAction alloc] initWithEditContents];
  } else if ([tag isEqualToString:@"enable_viewer_info"]) {
    return [[DBSHARINGFolderAction alloc] initWithEnableViewerInfo];
  } else if ([tag isEqualToString:@"invite_editor"]) {
    return [[DBSHARINGFolderAction alloc] initWithInviteEditor];
  } else if ([tag isEqualToString:@"invite_viewer"]) {
    return [[DBSHARINGFolderAction alloc] initWithInviteViewer];
  } else if ([tag isEqualToString:@"invite_viewer_no_comment"]) {
    return [[DBSHARINGFolderAction alloc] initWithInviteViewerNoComment];
  } else if ([tag isEqualToString:@"relinquish_membership"]) {
    return [[DBSHARINGFolderAction alloc] initWithRelinquishMembership];
  } else if ([tag isEqualToString:@"unmount"]) {
    return [[DBSHARINGFolderAction alloc] initWithUnmount];
  } else if ([tag isEqualToString:@"unshare"]) {
    return [[DBSHARINGFolderAction alloc] initWithUnshare];
  } else if ([tag isEqualToString:@"leave_a_copy"]) {
    return [[DBSHARINGFolderAction alloc] initWithLeaveACopy];
  } else if ([tag isEqualToString:@"share_link"]) {
    return [[DBSHARINGFolderAction alloc] initWithShareLink];
  } else if ([tag isEqualToString:@"create_link"]) {
    return [[DBSHARINGFolderAction alloc] initWithCreateLink];
  } else if ([tag isEqualToString:@"set_access_inheritance"]) {
    return [[DBSHARINGFolderAction alloc] initWithSetAccessInheritance];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGFolderAction alloc] initWithOther];
  } else {
    return [[DBSHARINGFolderAction alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFolderLinkMetadata.h"
#import "DBSHARINGLinkPermissions.h"
#import "DBSHARINGSharedLinkMetadata.h"
#import "DBSHARINGTeamMemberInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGFolderLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions
                        id_:(NSString *)id_
                    expires:(NSDate *)expires
                  pathLower:(NSString *)pathLower
             teamMemberInfo:(DBSHARINGTeamMemberInfo *)teamMemberInfo
       contentOwnerTeamInfo:(DBUSERSTeam *)contentOwnerTeamInfo {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](linkPermissions);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](id_);

  self = [super initWithUrl:url
                       name:name
            linkPermissions:linkPermissions
                        id_:id_
                    expires:expires
                  pathLower:pathLower
             teamMemberInfo:teamMemberInfo
       contentOwnerTeamInfo:contentOwnerTeamInfo];
  if (self) {
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url
                       name:(NSString *)name
            linkPermissions:(DBSHARINGLinkPermissions *)linkPermissions {
  return [self initWithUrl:url
                      name:name
           linkPermissions:linkPermissions
                       id_:nil
                   expires:nil
                 pathLower:nil
            teamMemberInfo:nil
      contentOwnerTeamInfo:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFolderLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFolderLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFolderLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.linkPermissions hash];
  if (self.id_ != nil) {
    result = prime * result + [self.id_ hash];
  }
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.teamMemberInfo != nil) {
    result = prime * result + [self.teamMemberInfo hash];
  }
  if (self.contentOwnerTeamInfo != nil) {
    result = prime * result + [self.contentOwnerTeamInfo hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderLinkMetadata:other];
}

- (BOOL)isEqualToFolderLinkMetadata:(DBSHARINGFolderLinkMetadata *)aFolderLinkMetadata {
  if (self == aFolderLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aFolderLinkMetadata.url]) {
    return NO;
  }
  if (![self.name isEqual:aFolderLinkMetadata.name]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:aFolderLinkMetadata.linkPermissions]) {
    return NO;
  }
  if (self.id_) {
    if (![self.id_ isEqual:aFolderLinkMetadata.id_]) {
      return NO;
    }
  }
  if (self.expires) {
    if (![self.expires isEqual:aFolderLinkMetadata.expires]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aFolderLinkMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.teamMemberInfo) {
    if (![self.teamMemberInfo isEqual:aFolderLinkMetadata.teamMemberInfo]) {
      return NO;
    }
  }
  if (self.contentOwnerTeamInfo) {
    if (![self.contentOwnerTeamInfo isEqual:aFolderLinkMetadata.contentOwnerTeamInfo]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFolderLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFolderLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"link_permissions"] = [DBSHARINGLinkPermissionsSerializer serialize:valueObj.linkPermissions];
  if (valueObj.id_) {
    jsonDict[@"id"] = valueObj.id_;
  }
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.teamMemberInfo) {
    jsonDict[@"team_member_info"] = [DBSHARINGTeamMemberInfoSerializer serialize:valueObj.teamMemberInfo];
  }
  if (valueObj.contentOwnerTeamInfo) {
    jsonDict[@"content_owner_team_info"] = [DBUSERSTeamSerializer serialize:valueObj.contentOwnerTeamInfo];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFolderLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *name = valueDict[@"name"];
  DBSHARINGLinkPermissions *linkPermissions =
      [DBSHARINGLinkPermissionsSerializer deserialize:valueDict[@"link_permissions"]];
  NSString *id_ = valueDict[@"id"] ?: nil;
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  DBSHARINGTeamMemberInfo *teamMemberInfo =
      valueDict[@"team_member_info"] ? [DBSHARINGTeamMemberInfoSerializer deserialize:valueDict[@"team_member_info"]]
                                     : nil;
  DBUSERSTeam *contentOwnerTeamInfo = valueDict[@"content_owner_team_info"]
                                          ? [DBUSERSTeamSerializer deserialize:valueDict[@"content_owner_team_info"]]
                                          : nil;

  return [[DBSHARINGFolderLinkMetadata alloc] initWithUrl:url
                                                     name:name
                                          linkPermissions:linkPermissions
                                                      id_:id_
                                                  expires:expires
                                                pathLower:pathLower
                                           teamMemberInfo:teamMemberInfo
                                     contentOwnerTeamInfo:contentOwnerTeamInfo];
}

@end

#import "DBSHARINGFolderAction.h"
#import "DBSHARINGFolderPermission.h"
#import "DBSHARINGPermissionDeniedReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFolderPermission

#pragma mark - Constructors

- (instancetype)initWithAction:(DBSHARINGFolderAction *)action
                         allow:(NSNumber *)allow
                        reason:(DBSHARINGPermissionDeniedReason *)reason {
  [DBStoneValidators nonnullValidator:nil](action);
  [DBStoneValidators nonnullValidator:nil](allow);

  self = [super init];
  if (self) {
    _action = action;
    _allow = allow;
    _reason = reason;
  }
  return self;
}

- (instancetype)initWithAction:(DBSHARINGFolderAction *)action allow:(NSNumber *)allow {
  return [self initWithAction:action allow:allow reason:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFolderPermissionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFolderPermissionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFolderPermissionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.action hash];
  result = prime * result + [self.allow hash];
  if (self.reason != nil) {
    result = prime * result + [self.reason hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderPermission:other];
}

- (BOOL)isEqualToFolderPermission:(DBSHARINGFolderPermission *)aFolderPermission {
  if (self == aFolderPermission) {
    return YES;
  }
  if (![self.action isEqual:aFolderPermission.action]) {
    return NO;
  }
  if (![self.allow isEqual:aFolderPermission.allow]) {
    return NO;
  }
  if (self.reason) {
    if (![self.reason isEqual:aFolderPermission.reason]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFolderPermissionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFolderPermission *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"action"] = [DBSHARINGFolderActionSerializer serialize:valueObj.action];
  jsonDict[@"allow"] = valueObj.allow;
  if (valueObj.reason) {
    jsonDict[@"reason"] = [DBSHARINGPermissionDeniedReasonSerializer serialize:valueObj.reason];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFolderPermission *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGFolderAction *action = [DBSHARINGFolderActionSerializer deserialize:valueDict[@"action"]];
  NSNumber *allow = valueDict[@"allow"];
  DBSHARINGPermissionDeniedReason *reason =
      valueDict[@"reason"] ? [DBSHARINGPermissionDeniedReasonSerializer deserialize:valueDict[@"reason"]] : nil;

  return [[DBSHARINGFolderPermission alloc] initWithAction:action allow:allow reason:reason];
}

@end

#import "DBSHARINGAclUpdatePolicy.h"
#import "DBSHARINGFolderPolicy.h"
#import "DBSHARINGMemberPolicy.h"
#import "DBSHARINGSharedLinkPolicy.h"
#import "DBSHARINGViewerInfoPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGFolderPolicy

#pragma mark - Constructors

- (instancetype)initWithAclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                       sharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
                           memberPolicy:(DBSHARINGMemberPolicy *)memberPolicy
                   resolvedMemberPolicy:(DBSHARINGMemberPolicy *)resolvedMemberPolicy
                       viewerInfoPolicy:(DBSHARINGViewerInfoPolicy *)viewerInfoPolicy {
  [DBStoneValidators nonnullValidator:nil](aclUpdatePolicy);
  [DBStoneValidators nonnullValidator:nil](sharedLinkPolicy);

  self = [super init];
  if (self) {
    _memberPolicy = memberPolicy;
    _resolvedMemberPolicy = resolvedMemberPolicy;
    _aclUpdatePolicy = aclUpdatePolicy;
    _sharedLinkPolicy = sharedLinkPolicy;
    _viewerInfoPolicy = viewerInfoPolicy;
  }
  return self;
}

- (instancetype)initWithAclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                       sharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)sharedLinkPolicy {
  return [self initWithAclUpdatePolicy:aclUpdatePolicy
                      sharedLinkPolicy:sharedLinkPolicy
                          memberPolicy:nil
                  resolvedMemberPolicy:nil
                      viewerInfoPolicy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGFolderPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGFolderPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGFolderPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.aclUpdatePolicy hash];
  result = prime * result + [self.sharedLinkPolicy hash];
  if (self.memberPolicy != nil) {
    result = prime * result + [self.memberPolicy hash];
  }
  if (self.resolvedMemberPolicy != nil) {
    result = prime * result + [self.resolvedMemberPolicy hash];
  }
  if (self.viewerInfoPolicy != nil) {
    result = prime * result + [self.viewerInfoPolicy hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderPolicy:other];
}

- (BOOL)isEqualToFolderPolicy:(DBSHARINGFolderPolicy *)aFolderPolicy {
  if (self == aFolderPolicy) {
    return YES;
  }
  if (![self.aclUpdatePolicy isEqual:aFolderPolicy.aclUpdatePolicy]) {
    return NO;
  }
  if (![self.sharedLinkPolicy isEqual:aFolderPolicy.sharedLinkPolicy]) {
    return NO;
  }
  if (self.memberPolicy) {
    if (![self.memberPolicy isEqual:aFolderPolicy.memberPolicy]) {
      return NO;
    }
  }
  if (self.resolvedMemberPolicy) {
    if (![self.resolvedMemberPolicy isEqual:aFolderPolicy.resolvedMemberPolicy]) {
      return NO;
    }
  }
  if (self.viewerInfoPolicy) {
    if (![self.viewerInfoPolicy isEqual:aFolderPolicy.viewerInfoPolicy]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGFolderPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGFolderPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"acl_update_policy"] = [DBSHARINGAclUpdatePolicySerializer serialize:valueObj.aclUpdatePolicy];
  jsonDict[@"shared_link_policy"] = [DBSHARINGSharedLinkPolicySerializer serialize:valueObj.sharedLinkPolicy];
  if (valueObj.memberPolicy) {
    jsonDict[@"member_policy"] = [DBSHARINGMemberPolicySerializer serialize:valueObj.memberPolicy];
  }
  if (valueObj.resolvedMemberPolicy) {
    jsonDict[@"resolved_member_policy"] = [DBSHARINGMemberPolicySerializer serialize:valueObj.resolvedMemberPolicy];
  }
  if (valueObj.viewerInfoPolicy) {
    jsonDict[@"viewer_info_policy"] = [DBSHARINGViewerInfoPolicySerializer serialize:valueObj.viewerInfoPolicy];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGFolderPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAclUpdatePolicy *aclUpdatePolicy =
      [DBSHARINGAclUpdatePolicySerializer deserialize:valueDict[@"acl_update_policy"]];
  DBSHARINGSharedLinkPolicy *sharedLinkPolicy =
      [DBSHARINGSharedLinkPolicySerializer deserialize:valueDict[@"shared_link_policy"]];
  DBSHARINGMemberPolicy *memberPolicy =
      valueDict[@"member_policy"] ? [DBSHARINGMemberPolicySerializer deserialize:valueDict[@"member_policy"]] : nil;
  DBSHARINGMemberPolicy *resolvedMemberPolicy =
      valueDict[@"resolved_member_policy"]
          ? [DBSHARINGMemberPolicySerializer deserialize:valueDict[@"resolved_member_policy"]]
          : nil;
  DBSHARINGViewerInfoPolicy *viewerInfoPolicy =
      valueDict[@"viewer_info_policy"]
          ? [DBSHARINGViewerInfoPolicySerializer deserialize:valueDict[@"viewer_info_policy"]]
          : nil;

  return [[DBSHARINGFolderPolicy alloc] initWithAclUpdatePolicy:aclUpdatePolicy
                                               sharedLinkPolicy:sharedLinkPolicy
                                                   memberPolicy:memberPolicy
                                           resolvedMemberPolicy:resolvedMemberPolicy
                                               viewerInfoPolicy:viewerInfoPolicy];
}

@end

#import "DBSHARINGFileAction.h"
#import "DBSHARINGGetFileMetadataArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetFileMetadataArg

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file actions:(NSArray<DBSHARINGFileAction *> *)actions {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _file = file;
    _actions = actions;
  }
  return self;
}

- (instancetype)initWithFile:(NSString *)file {
  return [self initWithFile:file actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetFileMetadataArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetFileMetadataArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetFileMetadataArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileMetadataArg:other];
}

- (BOOL)isEqualToGetFileMetadataArg:(DBSHARINGGetFileMetadataArg *)aGetFileMetadataArg {
  if (self == aGetFileMetadataArg) {
    return YES;
  }
  if (![self.file isEqual:aGetFileMetadataArg.file]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aGetFileMetadataArg.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetFileMetadataArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetFileMetadataArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFileActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetFileMetadataArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  NSArray<DBSHARINGFileAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFileActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGGetFileMetadataArg alloc] initWithFile:file actions:actions];
}

@end

#import "DBSHARINGFileAction.h"
#import "DBSHARINGGetFileMetadataBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetFileMetadataBatchArg

#pragma mark - Constructors

- (instancetype)initWithFiles:(NSArray<NSString *> *)files actions:(NSArray<DBSHARINGFileAction *> *)actions {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:nil
                              maxItems:@(100)
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators
                                                                stringValidator:@(1)
                                                                      maxLength:nil
                                                                        pattern:@"((/"
                                                                                @"|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+("
                                                                                @"/.*)?"]]]](files);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _files = files;
    _actions = actions;
  }
  return self;
}

- (instancetype)initWithFiles:(NSArray<NSString *> *)files {
  return [self initWithFiles:files actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetFileMetadataBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetFileMetadataBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetFileMetadataBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.files hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileMetadataBatchArg:other];
}

- (BOOL)isEqualToGetFileMetadataBatchArg:(DBSHARINGGetFileMetadataBatchArg *)aGetFileMetadataBatchArg {
  if (self == aGetFileMetadataBatchArg) {
    return YES;
  }
  if (![self.files isEqual:aGetFileMetadataBatchArg.files]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aGetFileMetadataBatchArg.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetFileMetadataBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetFileMetadataBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"files"] = [DBArraySerializer serialize:valueObj.files
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFileActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetFileMetadataBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *files = [DBArraySerializer deserialize:valueDict[@"files"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSArray<DBSHARINGFileAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFileActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGGetFileMetadataBatchArg alloc] initWithFiles:files actions:actions];
}

@end

#import "DBSHARINGGetFileMetadataBatchResult.h"
#import "DBSHARINGGetFileMetadataIndividualResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetFileMetadataBatchResult

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file result:(DBSHARINGGetFileMetadataIndividualResult *)result {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators nonnullValidator:nil](result);

  self = [super init];
  if (self) {
    _file = file;
    _result = result;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetFileMetadataBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetFileMetadataBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetFileMetadataBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.result hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileMetadataBatchResult:other];
}

- (BOOL)isEqualToGetFileMetadataBatchResult:(DBSHARINGGetFileMetadataBatchResult *)aGetFileMetadataBatchResult {
  if (self == aGetFileMetadataBatchResult) {
    return YES;
  }
  if (![self.file isEqual:aGetFileMetadataBatchResult.file]) {
    return NO;
  }
  if (![self.result isEqual:aGetFileMetadataBatchResult.result]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetFileMetadataBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetFileMetadataBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"result"] = [DBSHARINGGetFileMetadataIndividualResultSerializer serialize:valueObj.result];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetFileMetadataBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  DBSHARINGGetFileMetadataIndividualResult *result =
      [DBSHARINGGetFileMetadataIndividualResultSerializer deserialize:valueDict[@"result"]];

  return [[DBSHARINGGetFileMetadataBatchResult alloc] initWithFile:file result:result];
}

@end

#import "DBSHARINGGetFileMetadataError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetFileMetadataError

@synthesize userError = _userError;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGGetFileMetadataErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGGetFileMetadataErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGGetFileMetadataErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGGetFileMetadataErrorAccessError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGGetFileMetadataErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGGetFileMetadataErrorUserError:
    return @"DBSHARINGGetFileMetadataErrorUserError";
  case DBSHARINGGetFileMetadataErrorAccessError:
    return @"DBSHARINGGetFileMetadataErrorAccessError";
  case DBSHARINGGetFileMetadataErrorOther:
    return @"DBSHARINGGetFileMetadataErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetFileMetadataErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetFileMetadataErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetFileMetadataErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGGetFileMetadataErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGGetFileMetadataErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGGetFileMetadataErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileMetadataError:other];
}

- (BOOL)isEqualToGetFileMetadataError:(DBSHARINGGetFileMetadataError *)aGetFileMetadataError {
  if (self == aGetFileMetadataError) {
    return YES;
  }
  if (self.tag != aGetFileMetadataError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGGetFileMetadataErrorUserError:
    return [self.userError isEqual:aGetFileMetadataError.userError];
  case DBSHARINGGetFileMetadataErrorAccessError:
    return [self.accessError isEqual:aGetFileMetadataError.accessError];
  case DBSHARINGGetFileMetadataErrorOther:
    return [[self tagName] isEqual:[aGetFileMetadataError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetFileMetadataErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetFileMetadataError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetFileMetadataError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGGetFileMetadataError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGGetFileMetadataError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGGetFileMetadataError alloc] initWithOther];
  } else {
    return [[DBSHARINGGetFileMetadataError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGGetFileMetadataIndividualResult.h"
#import "DBSHARINGSharedFileMetadata.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetFileMetadataIndividualResult

@synthesize metadata = _metadata;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBSHARINGSharedFileMetadata *)metadata {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataIndividualResultMetadata;
    _metadata = metadata;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataIndividualResultAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetFileMetadataIndividualResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFileMetadata *)metadata {
  if (![self isMetadata]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGGetFileMetadataIndividualResultMetadata, but was %@.", [self tagName]];
  }
  return _metadata;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGGetFileMetadataIndividualResultAccessError, but was %@.",
                       [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isMetadata {
  return _tag == DBSHARINGGetFileMetadataIndividualResultMetadata;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGGetFileMetadataIndividualResultAccessError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGGetFileMetadataIndividualResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGGetFileMetadataIndividualResultMetadata:
    return @"DBSHARINGGetFileMetadataIndividualResultMetadata";
  case DBSHARINGGetFileMetadataIndividualResultAccessError:
    return @"DBSHARINGGetFileMetadataIndividualResultAccessError";
  case DBSHARINGGetFileMetadataIndividualResultOther:
    return @"DBSHARINGGetFileMetadataIndividualResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetFileMetadataIndividualResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetFileMetadataIndividualResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetFileMetadataIndividualResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGGetFileMetadataIndividualResultMetadata:
    result = prime * result + [self.metadata hash];
    break;
  case DBSHARINGGetFileMetadataIndividualResultAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGGetFileMetadataIndividualResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileMetadataIndividualResult:other];
}

- (BOOL)isEqualToGetFileMetadataIndividualResult:
    (DBSHARINGGetFileMetadataIndividualResult *)aGetFileMetadataIndividualResult {
  if (self == aGetFileMetadataIndividualResult) {
    return YES;
  }
  if (self.tag != aGetFileMetadataIndividualResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGGetFileMetadataIndividualResultMetadata:
    return [self.metadata isEqual:aGetFileMetadataIndividualResult.metadata];
  case DBSHARINGGetFileMetadataIndividualResultAccessError:
    return [self.accessError isEqual:aGetFileMetadataIndividualResult.accessError];
  case DBSHARINGGetFileMetadataIndividualResultOther:
    return [[self tagName] isEqual:[aGetFileMetadataIndividualResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetFileMetadataIndividualResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetFileMetadataIndividualResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMetadata]) {
    jsonDict = [[DBSHARINGSharedFileMetadataSerializer serialize:valueObj.metadata] mutableCopy];
    jsonDict[@".tag"] = @"metadata";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetFileMetadataIndividualResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"metadata"]) {
    DBSHARINGSharedFileMetadata *metadata = [DBSHARINGSharedFileMetadataSerializer deserialize:valueDict];
    return [[DBSHARINGGetFileMetadataIndividualResult alloc] initWithMetadata:metadata];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGGetFileMetadataIndividualResult alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGGetFileMetadataIndividualResult alloc] initWithOther];
  } else {
    return [[DBSHARINGGetFileMetadataIndividualResult alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFolderAction.h"
#import "DBSHARINGGetMetadataArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetMetadataArgs

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId actions:(NSArray<DBSHARINGFolderAction *> *)actions {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _actions = actions;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetMetadataArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetMetadataArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetMetadataArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetMetadataArgs:other];
}

- (BOOL)isEqualToGetMetadataArgs:(DBSHARINGGetMetadataArgs *)aGetMetadataArgs {
  if (self == aGetMetadataArgs) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aGetMetadataArgs.sharedFolderId]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aGetMetadataArgs.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetMetadataArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetMetadataArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFolderActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetMetadataArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSArray<DBSHARINGFolderAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFolderActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGGetMetadataArgs alloc] initWithSharedFolderId:sharedFolderId actions:actions];
}

@end

#import "DBSHARINGSharedLinkError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkError

#pragma mark - Constructors

- (instancetype)initWithSharedLinkNotFound {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkErrorSharedLinkNotFound;
  }
  return self;
}

- (instancetype)initWithSharedLinkAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkErrorSharedLinkAccessDenied;
  }
  return self;
}

- (instancetype)initWithUnsupportedLinkType {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkErrorUnsupportedLinkType;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSharedLinkNotFound {
  return _tag == DBSHARINGSharedLinkErrorSharedLinkNotFound;
}

- (BOOL)isSharedLinkAccessDenied {
  return _tag == DBSHARINGSharedLinkErrorSharedLinkAccessDenied;
}

- (BOOL)isUnsupportedLinkType {
  return _tag == DBSHARINGSharedLinkErrorUnsupportedLinkType;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedLinkErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedLinkErrorSharedLinkNotFound:
    return @"DBSHARINGSharedLinkErrorSharedLinkNotFound";
  case DBSHARINGSharedLinkErrorSharedLinkAccessDenied:
    return @"DBSHARINGSharedLinkErrorSharedLinkAccessDenied";
  case DBSHARINGSharedLinkErrorUnsupportedLinkType:
    return @"DBSHARINGSharedLinkErrorUnsupportedLinkType";
  case DBSHARINGSharedLinkErrorOther:
    return @"DBSHARINGSharedLinkErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedLinkErrorSharedLinkNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkErrorSharedLinkAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkErrorUnsupportedLinkType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkError:other];
}

- (BOOL)isEqualToSharedLinkError:(DBSHARINGSharedLinkError *)aSharedLinkError {
  if (self == aSharedLinkError) {
    return YES;
  }
  if (self.tag != aSharedLinkError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedLinkErrorSharedLinkNotFound:
    return [[self tagName] isEqual:[aSharedLinkError tagName]];
  case DBSHARINGSharedLinkErrorSharedLinkAccessDenied:
    return [[self tagName] isEqual:[aSharedLinkError tagName]];
  case DBSHARINGSharedLinkErrorUnsupportedLinkType:
    return [[self tagName] isEqual:[aSharedLinkError tagName]];
  case DBSHARINGSharedLinkErrorOther:
    return [[self tagName] isEqual:[aSharedLinkError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSharedLinkNotFound]) {
    jsonDict[@".tag"] = @"shared_link_not_found";
  } else if ([valueObj isSharedLinkAccessDenied]) {
    jsonDict[@".tag"] = @"shared_link_access_denied";
  } else if ([valueObj isUnsupportedLinkType]) {
    jsonDict[@".tag"] = @"unsupported_link_type";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"shared_link_not_found"]) {
    return [[DBSHARINGSharedLinkError alloc] initWithSharedLinkNotFound];
  } else if ([tag isEqualToString:@"shared_link_access_denied"]) {
    return [[DBSHARINGSharedLinkError alloc] initWithSharedLinkAccessDenied];
  } else if ([tag isEqualToString:@"unsupported_link_type"]) {
    return [[DBSHARINGSharedLinkError alloc] initWithUnsupportedLinkType];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedLinkError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedLinkError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGGetSharedLinkFileError.h"
#import "DBSHARINGSharedLinkError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetSharedLinkFileError

#pragma mark - Constructors

- (instancetype)initWithSharedLinkNotFound {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound;
  }
  return self;
}

- (instancetype)initWithSharedLinkAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied;
  }
  return self;
}

- (instancetype)initWithUnsupportedLinkType {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinkFileErrorOther;
  }
  return self;
}

- (instancetype)initWithSharedLinkIsDirectory {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSharedLinkNotFound {
  return _tag == DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound;
}

- (BOOL)isSharedLinkAccessDenied {
  return _tag == DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied;
}

- (BOOL)isUnsupportedLinkType {
  return _tag == DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType;
}

- (BOOL)isOther {
  return _tag == DBSHARINGGetSharedLinkFileErrorOther;
}

- (BOOL)isSharedLinkIsDirectory {
  return _tag == DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound:
    return @"DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound";
  case DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied:
    return @"DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied";
  case DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType:
    return @"DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType";
  case DBSHARINGGetSharedLinkFileErrorOther:
    return @"DBSHARINGGetSharedLinkFileErrorOther";
  case DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory:
    return @"DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetSharedLinkFileErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetSharedLinkFileErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetSharedLinkFileErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGGetSharedLinkFileErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetSharedLinkFileError:other];
}

- (BOOL)isEqualToGetSharedLinkFileError:(DBSHARINGGetSharedLinkFileError *)aGetSharedLinkFileError {
  if (self == aGetSharedLinkFileError) {
    return YES;
  }
  if (self.tag != aGetSharedLinkFileError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGGetSharedLinkFileErrorSharedLinkNotFound:
    return [[self tagName] isEqual:[aGetSharedLinkFileError tagName]];
  case DBSHARINGGetSharedLinkFileErrorSharedLinkAccessDenied:
    return [[self tagName] isEqual:[aGetSharedLinkFileError tagName]];
  case DBSHARINGGetSharedLinkFileErrorUnsupportedLinkType:
    return [[self tagName] isEqual:[aGetSharedLinkFileError tagName]];
  case DBSHARINGGetSharedLinkFileErrorOther:
    return [[self tagName] isEqual:[aGetSharedLinkFileError tagName]];
  case DBSHARINGGetSharedLinkFileErrorSharedLinkIsDirectory:
    return [[self tagName] isEqual:[aGetSharedLinkFileError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetSharedLinkFileErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetSharedLinkFileError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSharedLinkNotFound]) {
    jsonDict[@".tag"] = @"shared_link_not_found";
  } else if ([valueObj isSharedLinkAccessDenied]) {
    jsonDict[@".tag"] = @"shared_link_access_denied";
  } else if ([valueObj isUnsupportedLinkType]) {
    jsonDict[@".tag"] = @"unsupported_link_type";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSharedLinkIsDirectory]) {
    jsonDict[@".tag"] = @"shared_link_is_directory";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetSharedLinkFileError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"shared_link_not_found"]) {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithSharedLinkNotFound];
  } else if ([tag isEqualToString:@"shared_link_access_denied"]) {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithSharedLinkAccessDenied];
  } else if ([tag isEqualToString:@"unsupported_link_type"]) {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithUnsupportedLinkType];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithOther];
  } else if ([tag isEqualToString:@"shared_link_is_directory"]) {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithSharedLinkIsDirectory];
  } else {
    return [[DBSHARINGGetSharedLinkFileError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGGetSharedLinkMetadataArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetSharedLinkMetadataArg

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url path:(NSString *)path linkPassword:(NSString *)linkPassword {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](path);

  self = [super init];
  if (self) {
    _url = url;
    _path = path;
    _linkPassword = linkPassword;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url {
  return [self initWithUrl:url path:nil linkPassword:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetSharedLinkMetadataArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetSharedLinkMetadataArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetSharedLinkMetadataArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }
  if (self.linkPassword != nil) {
    result = prime * result + [self.linkPassword hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetSharedLinkMetadataArg:other];
}

- (BOOL)isEqualToGetSharedLinkMetadataArg:(DBSHARINGGetSharedLinkMetadataArg *)aGetSharedLinkMetadataArg {
  if (self == aGetSharedLinkMetadataArg) {
    return YES;
  }
  if (![self.url isEqual:aGetSharedLinkMetadataArg.url]) {
    return NO;
  }
  if (self.path) {
    if (![self.path isEqual:aGetSharedLinkMetadataArg.path]) {
      return NO;
    }
  }
  if (self.linkPassword) {
    if (![self.linkPassword isEqual:aGetSharedLinkMetadataArg.linkPassword]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetSharedLinkMetadataArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetSharedLinkMetadataArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }
  if (valueObj.linkPassword) {
    jsonDict[@"link_password"] = valueObj.linkPassword;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetSharedLinkMetadataArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  NSString *path = valueDict[@"path"] ?: nil;
  NSString *linkPassword = valueDict[@"link_password"] ?: nil;

  return [[DBSHARINGGetSharedLinkMetadataArg alloc] initWithUrl:url path:path linkPassword:linkPassword];
}

@end

#import "DBSHARINGGetSharedLinksArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetSharedLinksArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {

  self = [super init];
  if (self) {
    _path = path;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithPath:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetSharedLinksArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetSharedLinksArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetSharedLinksArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetSharedLinksArg:other];
}

- (BOOL)isEqualToGetSharedLinksArg:(DBSHARINGGetSharedLinksArg *)aGetSharedLinksArg {
  if (self == aGetSharedLinksArg) {
    return YES;
  }
  if (self.path) {
    if (![self.path isEqual:aGetSharedLinksArg.path]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetSharedLinksArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetSharedLinksArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetSharedLinksArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"] ?: nil;

  return [[DBSHARINGGetSharedLinksArg alloc] initWithPath:path];
}

@end

#import "DBSHARINGGetSharedLinksError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetSharedLinksError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinksErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGGetSharedLinksErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGGetSharedLinksErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBSHARINGGetSharedLinksErrorPath;
}

- (BOOL)isOther {
  return _tag == DBSHARINGGetSharedLinksErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGGetSharedLinksErrorPath:
    return @"DBSHARINGGetSharedLinksErrorPath";
  case DBSHARINGGetSharedLinksErrorOther:
    return @"DBSHARINGGetSharedLinksErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetSharedLinksErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetSharedLinksErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetSharedLinksErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGGetSharedLinksErrorPath:
    if (self.path != nil) {
      result = prime * result + [self.path hash];
    }
    break;
  case DBSHARINGGetSharedLinksErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetSharedLinksError:other];
}

- (BOOL)isEqualToGetSharedLinksError:(DBSHARINGGetSharedLinksError *)aGetSharedLinksError {
  if (self == aGetSharedLinksError) {
    return YES;
  }
  if (self.tag != aGetSharedLinksError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGGetSharedLinksErrorPath:
    if (self.path) {
      return [self.path isEqual:aGetSharedLinksError.path];
    }
  case DBSHARINGGetSharedLinksErrorOther:
    return [[self tagName] isEqual:[aGetSharedLinksError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetSharedLinksErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetSharedLinksError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    if (valueObj.path) {
      jsonDict[@"path"] = valueObj.path;
    }
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetSharedLinksError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    NSString *path = valueDict[@"path"] ? valueDict[@"path"] : nil;
    return [[DBSHARINGGetSharedLinksError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGGetSharedLinksError alloc] initWithOther];
  } else {
    return [[DBSHARINGGetSharedLinksError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGGetSharedLinksResult.h"
#import "DBSHARINGLinkMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGetSharedLinksResult

#pragma mark - Constructors

- (instancetype)initWithLinks:(NSArray<DBSHARINGLinkMetadata *> *)links {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](links);

  self = [super init];
  if (self) {
    _links = links;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGetSharedLinksResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGetSharedLinksResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGetSharedLinksResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.links hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetSharedLinksResult:other];
}

- (BOOL)isEqualToGetSharedLinksResult:(DBSHARINGGetSharedLinksResult *)aGetSharedLinksResult {
  if (self == aGetSharedLinksResult) {
    return YES;
  }
  if (![self.links isEqual:aGetSharedLinksResult.links]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGetSharedLinksResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGetSharedLinksResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"links"] = [DBArraySerializer serialize:valueObj.links
                                          withBlock:^id(id elem0) {
                                            return [DBSHARINGLinkMetadataSerializer serialize:elem0];
                                          }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGetSharedLinksResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGLinkMetadata *> *links =
      [DBArraySerializer deserialize:valueDict[@"links"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkMetadataSerializer deserialize:elem0];
                           }];

  return [[DBSHARINGGetSharedLinksResult alloc] initWithLinks:links];
}

@end

#import "DBSHARINGGroupInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBTEAMCOMMONGroupManagementType.h"
#import "DBTEAMCOMMONGroupSummary.h"
#import "DBTEAMCOMMONGroupType.h"

#pragma mark - API Object

@implementation DBSHARINGGroupInfo

#pragma mark - Constructors

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType
                        groupType:(DBTEAMCOMMONGroupType *)groupType
                         isMember:(NSNumber *)isMember
                          isOwner:(NSNumber *)isOwner
                         sameTeam:(NSNumber *)sameTeam
                  groupExternalId:(NSString *)groupExternalId
                      memberCount:(NSNumber *)memberCount {
  [DBStoneValidators nonnullValidator:nil](groupName);
  [DBStoneValidators nonnullValidator:nil](groupId);
  [DBStoneValidators nonnullValidator:nil](groupManagementType);
  [DBStoneValidators nonnullValidator:nil](groupType);
  [DBStoneValidators nonnullValidator:nil](isMember);
  [DBStoneValidators nonnullValidator:nil](isOwner);
  [DBStoneValidators nonnullValidator:nil](sameTeam);

  self = [super initWithGroupName:groupName
                          groupId:groupId
              groupManagementType:groupManagementType
                  groupExternalId:groupExternalId
                      memberCount:memberCount];
  if (self) {
    _groupType = groupType;
    _isMember = isMember;
    _isOwner = isOwner;
    _sameTeam = sameTeam;
  }
  return self;
}

- (instancetype)initWithGroupName:(NSString *)groupName
                          groupId:(NSString *)groupId
              groupManagementType:(DBTEAMCOMMONGroupManagementType *)groupManagementType
                        groupType:(DBTEAMCOMMONGroupType *)groupType
                         isMember:(NSNumber *)isMember
                          isOwner:(NSNumber *)isOwner
                         sameTeam:(NSNumber *)sameTeam {
  return [self initWithGroupName:groupName
                         groupId:groupId
             groupManagementType:groupManagementType
                       groupType:groupType
                        isMember:isMember
                         isOwner:isOwner
                        sameTeam:sameTeam
                 groupExternalId:nil
                     memberCount:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGroupInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGroupInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGroupInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.groupName hash];
  result = prime * result + [self.groupId hash];
  result = prime * result + [self.groupManagementType hash];
  result = prime * result + [self.groupType hash];
  result = prime * result + [self.isMember hash];
  result = prime * result + [self.isOwner hash];
  result = prime * result + [self.sameTeam hash];
  if (self.groupExternalId != nil) {
    result = prime * result + [self.groupExternalId hash];
  }
  if (self.memberCount != nil) {
    result = prime * result + [self.memberCount hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupInfo:other];
}

- (BOOL)isEqualToGroupInfo:(DBSHARINGGroupInfo *)aGroupInfo {
  if (self == aGroupInfo) {
    return YES;
  }
  if (![self.groupName isEqual:aGroupInfo.groupName]) {
    return NO;
  }
  if (![self.groupId isEqual:aGroupInfo.groupId]) {
    return NO;
  }
  if (![self.groupManagementType isEqual:aGroupInfo.groupManagementType]) {
    return NO;
  }
  if (![self.groupType isEqual:aGroupInfo.groupType]) {
    return NO;
  }
  if (![self.isMember isEqual:aGroupInfo.isMember]) {
    return NO;
  }
  if (![self.isOwner isEqual:aGroupInfo.isOwner]) {
    return NO;
  }
  if (![self.sameTeam isEqual:aGroupInfo.sameTeam]) {
    return NO;
  }
  if (self.groupExternalId) {
    if (![self.groupExternalId isEqual:aGroupInfo.groupExternalId]) {
      return NO;
    }
  }
  if (self.memberCount) {
    if (![self.memberCount isEqual:aGroupInfo.memberCount]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGroupInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGroupInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"group_name"] = valueObj.groupName;
  jsonDict[@"group_id"] = valueObj.groupId;
  jsonDict[@"group_management_type"] =
      [DBTEAMCOMMONGroupManagementTypeSerializer serialize:valueObj.groupManagementType];
  jsonDict[@"group_type"] = [DBTEAMCOMMONGroupTypeSerializer serialize:valueObj.groupType];
  jsonDict[@"is_member"] = valueObj.isMember;
  jsonDict[@"is_owner"] = valueObj.isOwner;
  jsonDict[@"same_team"] = valueObj.sameTeam;
  if (valueObj.groupExternalId) {
    jsonDict[@"group_external_id"] = valueObj.groupExternalId;
  }
  if (valueObj.memberCount) {
    jsonDict[@"member_count"] = valueObj.memberCount;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGroupInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *groupName = valueDict[@"group_name"];
  NSString *groupId = valueDict[@"group_id"];
  DBTEAMCOMMONGroupManagementType *groupManagementType =
      [DBTEAMCOMMONGroupManagementTypeSerializer deserialize:valueDict[@"group_management_type"]];
  DBTEAMCOMMONGroupType *groupType = [DBTEAMCOMMONGroupTypeSerializer deserialize:valueDict[@"group_type"]];
  NSNumber *isMember = valueDict[@"is_member"];
  NSNumber *isOwner = valueDict[@"is_owner"];
  NSNumber *sameTeam = valueDict[@"same_team"];
  NSString *groupExternalId = valueDict[@"group_external_id"] ?: nil;
  NSNumber *memberCount = valueDict[@"member_count"] ?: nil;

  return [[DBSHARINGGroupInfo alloc] initWithGroupName:groupName
                                               groupId:groupId
                                   groupManagementType:groupManagementType
                                             groupType:groupType
                                              isMember:isMember
                                               isOwner:isOwner
                                              sameTeam:sameTeam
                                       groupExternalId:groupExternalId
                                           memberCount:memberCount];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMembershipInfo

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(NSString *)initials
                       isInherited:(NSNumber *)isInherited {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super init];
  if (self) {
    _accessType = accessType;
    _permissions = permissions;
    _initials = initials;
    _isInherited = isInherited ?: @NO;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType {
  return [self initWithAccessType:accessType permissions:nil initials:nil isInherited:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMembershipInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMembershipInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMembershipInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.initials != nil) {
    result = prime * result + [self.initials hash];
  }
  result = prime * result + [self.isInherited hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMembershipInfo:other];
}

- (BOOL)isEqualToMembershipInfo:(DBSHARINGMembershipInfo *)aMembershipInfo {
  if (self == aMembershipInfo) {
    return YES;
  }
  if (![self.accessType isEqual:aMembershipInfo.accessType]) {
    return NO;
  }
  if (self.permissions) {
    if (![self.permissions isEqual:aMembershipInfo.permissions]) {
      return NO;
    }
  }
  if (self.initials) {
    if (![self.initials isEqual:aMembershipInfo.initials]) {
      return NO;
    }
  }
  if (![self.isInherited isEqual:aMembershipInfo.isInherited]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMembershipInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMembershipInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.initials) {
    jsonDict[@"initials"] = valueObj.initials;
  }
  jsonDict[@"is_inherited"] = valueObj.isInherited;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSString *initials = valueDict[@"initials"] ?: nil;
  NSNumber *isInherited = valueDict[@"is_inherited"] ?: @NO;

  return [[DBSHARINGMembershipInfo alloc] initWithAccessType:accessType
                                                 permissions:permissions
                                                    initials:initials
                                                 isInherited:isInherited];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGGroupInfo.h"
#import "DBSHARINGGroupMembershipInfo.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGGroupMembershipInfo

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                             group:(DBSHARINGGroupInfo *)group
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(NSString *)initials
                       isInherited:(NSNumber *)isInherited {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](group);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super initWithAccessType:accessType permissions:permissions initials:initials isInherited:isInherited];
  if (self) {
    _group = group;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType group:(DBSHARINGGroupInfo *)group {
  return [self initWithAccessType:accessType group:group permissions:nil initials:nil isInherited:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGGroupMembershipInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGGroupMembershipInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGGroupMembershipInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.group hash];
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.initials != nil) {
    result = prime * result + [self.initials hash];
  }
  result = prime * result + [self.isInherited hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGroupMembershipInfo:other];
}

- (BOOL)isEqualToGroupMembershipInfo:(DBSHARINGGroupMembershipInfo *)aGroupMembershipInfo {
  if (self == aGroupMembershipInfo) {
    return YES;
  }
  if (![self.accessType isEqual:aGroupMembershipInfo.accessType]) {
    return NO;
  }
  if (![self.group isEqual:aGroupMembershipInfo.group]) {
    return NO;
  }
  if (self.permissions) {
    if (![self.permissions isEqual:aGroupMembershipInfo.permissions]) {
      return NO;
    }
  }
  if (self.initials) {
    if (![self.initials isEqual:aGroupMembershipInfo.initials]) {
      return NO;
    }
  }
  if (![self.isInherited isEqual:aGroupMembershipInfo.isInherited]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGGroupMembershipInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGGroupMembershipInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"group"] = [DBSHARINGGroupInfoSerializer serialize:valueObj.group];
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.initials) {
    jsonDict[@"initials"] = valueObj.initials;
  }
  jsonDict[@"is_inherited"] = valueObj.isInherited;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGGroupMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  DBSHARINGGroupInfo *group = [DBSHARINGGroupInfoSerializer deserialize:valueDict[@"group"]];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSString *initials = valueDict[@"initials"] ?: nil;
  NSNumber *isInherited = valueDict[@"is_inherited"] ?: @NO;

  return [[DBSHARINGGroupMembershipInfo alloc] initWithAccessType:accessType
                                                            group:group
                                                      permissions:permissions
                                                         initials:initials
                                                      isInherited:isInherited];
}

@end

#import "DBSHARINGInsufficientPlan.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGInsufficientPlan

#pragma mark - Constructors

- (instancetype)initWithMessage:(NSString *)message upsellUrl:(NSString *)upsellUrl {
  [DBStoneValidators nonnullValidator:nil](message);

  self = [super init];
  if (self) {
    _message = message;
    _upsellUrl = upsellUrl;
  }
  return self;
}

- (instancetype)initWithMessage:(NSString *)message {
  return [self initWithMessage:message upsellUrl:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGInsufficientPlanSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGInsufficientPlanSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGInsufficientPlanSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.message hash];
  if (self.upsellUrl != nil) {
    result = prime * result + [self.upsellUrl hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToInsufficientPlan:other];
}

- (BOOL)isEqualToInsufficientPlan:(DBSHARINGInsufficientPlan *)anInsufficientPlan {
  if (self == anInsufficientPlan) {
    return YES;
  }
  if (![self.message isEqual:anInsufficientPlan.message]) {
    return NO;
  }
  if (self.upsellUrl) {
    if (![self.upsellUrl isEqual:anInsufficientPlan.upsellUrl]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGInsufficientPlanSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGInsufficientPlan *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"message"] = valueObj.message;
  if (valueObj.upsellUrl) {
    jsonDict[@"upsell_url"] = valueObj.upsellUrl;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGInsufficientPlan *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *message = valueDict[@"message"];
  NSString *upsellUrl = valueDict[@"upsell_url"] ?: nil;

  return [[DBSHARINGInsufficientPlan alloc] initWithMessage:message upsellUrl:upsellUrl];
}

@end

#import "DBSHARINGInsufficientQuotaAmounts.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGInsufficientQuotaAmounts

#pragma mark - Constructors

- (instancetype)initWithSpaceNeeded:(NSNumber *)spaceNeeded
                      spaceShortage:(NSNumber *)spaceShortage
                          spaceLeft:(NSNumber *)spaceLeft {
  [DBStoneValidators nonnullValidator:nil](spaceNeeded);
  [DBStoneValidators nonnullValidator:nil](spaceShortage);
  [DBStoneValidators nonnullValidator:nil](spaceLeft);

  self = [super init];
  if (self) {
    _spaceNeeded = spaceNeeded;
    _spaceShortage = spaceShortage;
    _spaceLeft = spaceLeft;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGInsufficientQuotaAmountsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGInsufficientQuotaAmountsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGInsufficientQuotaAmountsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.spaceNeeded hash];
  result = prime * result + [self.spaceShortage hash];
  result = prime * result + [self.spaceLeft hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToInsufficientQuotaAmounts:other];
}

- (BOOL)isEqualToInsufficientQuotaAmounts:(DBSHARINGInsufficientQuotaAmounts *)anInsufficientQuotaAmounts {
  if (self == anInsufficientQuotaAmounts) {
    return YES;
  }
  if (![self.spaceNeeded isEqual:anInsufficientQuotaAmounts.spaceNeeded]) {
    return NO;
  }
  if (![self.spaceShortage isEqual:anInsufficientQuotaAmounts.spaceShortage]) {
    return NO;
  }
  if (![self.spaceLeft isEqual:anInsufficientQuotaAmounts.spaceLeft]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGInsufficientQuotaAmountsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGInsufficientQuotaAmounts *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"space_needed"] = valueObj.spaceNeeded;
  jsonDict[@"space_shortage"] = valueObj.spaceShortage;
  jsonDict[@"space_left"] = valueObj.spaceLeft;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGInsufficientQuotaAmounts *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *spaceNeeded = valueDict[@"space_needed"];
  NSNumber *spaceShortage = valueDict[@"space_shortage"];
  NSNumber *spaceLeft = valueDict[@"space_left"];

  return [[DBSHARINGInsufficientQuotaAmounts alloc] initWithSpaceNeeded:spaceNeeded
                                                          spaceShortage:spaceShortage
                                                              spaceLeft:spaceLeft];
}

@end

#import "DBSHARINGInviteeInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGInviteeInfo

@synthesize email = _email;

#pragma mark - Constructors

- (instancetype)initWithEmail:(NSString *)email {
  self = [super init];
  if (self) {
    _tag = DBSHARINGInviteeInfoEmail;
    _email = email;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGInviteeInfoOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)email {
  if (![self isEmail]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGInviteeInfoEmail, but was %@.", [self tagName]];
  }
  return _email;
}

#pragma mark - Tag state methods

- (BOOL)isEmail {
  return _tag == DBSHARINGInviteeInfoEmail;
}

- (BOOL)isOther {
  return _tag == DBSHARINGInviteeInfoOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGInviteeInfoEmail:
    return @"DBSHARINGInviteeInfoEmail";
  case DBSHARINGInviteeInfoOther:
    return @"DBSHARINGInviteeInfoOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGInviteeInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGInviteeInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGInviteeInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGInviteeInfoEmail:
    result = prime * result + [self.email hash];
    break;
  case DBSHARINGInviteeInfoOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToInviteeInfo:other];
}

- (BOOL)isEqualToInviteeInfo:(DBSHARINGInviteeInfo *)anInviteeInfo {
  if (self == anInviteeInfo) {
    return YES;
  }
  if (self.tag != anInviteeInfo.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGInviteeInfoEmail:
    return [self.email isEqual:anInviteeInfo.email];
  case DBSHARINGInviteeInfoOther:
    return [[self tagName] isEqual:[anInviteeInfo tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGInviteeInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGInviteeInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmail]) {
    jsonDict[@"email"] = valueObj.email;
    jsonDict[@".tag"] = @"email";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGInviteeInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"email"]) {
    NSString *email = valueDict[@"email"];
    return [[DBSHARINGInviteeInfo alloc] initWithEmail:email];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGInviteeInfo alloc] initWithOther];
  } else {
    return [[DBSHARINGInviteeInfo alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGInviteeInfo.h"
#import "DBSHARINGInviteeMembershipInfo.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGMembershipInfo.h"
#import "DBSHARINGUserInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGInviteeMembershipInfo

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                           invitee:(DBSHARINGInviteeInfo *)invitee
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(NSString *)initials
                       isInherited:(NSNumber *)isInherited
                              user:(DBSHARINGUserInfo *)user {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](invitee);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super initWithAccessType:accessType permissions:permissions initials:initials isInherited:isInherited];
  if (self) {
    _invitee = invitee;
    _user = user;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType invitee:(DBSHARINGInviteeInfo *)invitee {
  return [self initWithAccessType:accessType invitee:invitee permissions:nil initials:nil isInherited:nil user:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGInviteeMembershipInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGInviteeMembershipInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGInviteeMembershipInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.invitee hash];
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.initials != nil) {
    result = prime * result + [self.initials hash];
  }
  result = prime * result + [self.isInherited hash];
  if (self.user != nil) {
    result = prime * result + [self.user hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToInviteeMembershipInfo:other];
}

- (BOOL)isEqualToInviteeMembershipInfo:(DBSHARINGInviteeMembershipInfo *)anInviteeMembershipInfo {
  if (self == anInviteeMembershipInfo) {
    return YES;
  }
  if (![self.accessType isEqual:anInviteeMembershipInfo.accessType]) {
    return NO;
  }
  if (![self.invitee isEqual:anInviteeMembershipInfo.invitee]) {
    return NO;
  }
  if (self.permissions) {
    if (![self.permissions isEqual:anInviteeMembershipInfo.permissions]) {
      return NO;
    }
  }
  if (self.initials) {
    if (![self.initials isEqual:anInviteeMembershipInfo.initials]) {
      return NO;
    }
  }
  if (![self.isInherited isEqual:anInviteeMembershipInfo.isInherited]) {
    return NO;
  }
  if (self.user) {
    if (![self.user isEqual:anInviteeMembershipInfo.user]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGInviteeMembershipInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGInviteeMembershipInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"invitee"] = [DBSHARINGInviteeInfoSerializer serialize:valueObj.invitee];
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.initials) {
    jsonDict[@"initials"] = valueObj.initials;
  }
  jsonDict[@"is_inherited"] = valueObj.isInherited;
  if (valueObj.user) {
    jsonDict[@"user"] = [DBSHARINGUserInfoSerializer serialize:valueObj.user];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGInviteeMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  DBSHARINGInviteeInfo *invitee = [DBSHARINGInviteeInfoSerializer deserialize:valueDict[@"invitee"]];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSString *initials = valueDict[@"initials"] ?: nil;
  NSNumber *isInherited = valueDict[@"is_inherited"] ?: @NO;
  DBSHARINGUserInfo *user = valueDict[@"user"] ? [DBSHARINGUserInfoSerializer deserialize:valueDict[@"user"]] : nil;

  return [[DBSHARINGInviteeMembershipInfo alloc] initWithAccessType:accessType
                                                            invitee:invitee
                                                        permissions:permissions
                                                           initials:initials
                                                        isInherited:isInherited
                                                               user:user];
}

@end

#import "DBSHARINGJobError.h"
#import "DBSHARINGRelinquishFolderMembershipError.h"
#import "DBSHARINGRemoveFolderMemberError.h"
#import "DBSHARINGUnshareFolderError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGJobError

@synthesize unshareFolderError = _unshareFolderError;
@synthesize removeFolderMemberError = _removeFolderMemberError;
@synthesize relinquishFolderMembershipError = _relinquishFolderMembershipError;

#pragma mark - Constructors

- (instancetype)initWithUnshareFolderError:(DBSHARINGUnshareFolderError *)unshareFolderError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobErrorUnshareFolderError;
    _unshareFolderError = unshareFolderError;
  }
  return self;
}

- (instancetype)initWithRemoveFolderMemberError:(DBSHARINGRemoveFolderMemberError *)removeFolderMemberError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobErrorRemoveFolderMemberError;
    _removeFolderMemberError = removeFolderMemberError;
  }
  return self;
}

- (instancetype)initWithRelinquishFolderMembershipError:
    (DBSHARINGRelinquishFolderMembershipError *)relinquishFolderMembershipError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobErrorRelinquishFolderMembershipError;
    _relinquishFolderMembershipError = relinquishFolderMembershipError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGUnshareFolderError *)unshareFolderError {
  if (![self isUnshareFolderError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGJobErrorUnshareFolderError, but was %@.", [self tagName]];
  }
  return _unshareFolderError;
}

- (DBSHARINGRemoveFolderMemberError *)removeFolderMemberError {
  if (![self isRemoveFolderMemberError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGJobErrorRemoveFolderMemberError, but was %@.", [self tagName]];
  }
  return _removeFolderMemberError;
}

- (DBSHARINGRelinquishFolderMembershipError *)relinquishFolderMembershipError {
  if (![self isRelinquishFolderMembershipError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGJobErrorRelinquishFolderMembershipError, but was %@.", [self tagName]];
  }
  return _relinquishFolderMembershipError;
}

#pragma mark - Tag state methods

- (BOOL)isUnshareFolderError {
  return _tag == DBSHARINGJobErrorUnshareFolderError;
}

- (BOOL)isRemoveFolderMemberError {
  return _tag == DBSHARINGJobErrorRemoveFolderMemberError;
}

- (BOOL)isRelinquishFolderMembershipError {
  return _tag == DBSHARINGJobErrorRelinquishFolderMembershipError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGJobErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGJobErrorUnshareFolderError:
    return @"DBSHARINGJobErrorUnshareFolderError";
  case DBSHARINGJobErrorRemoveFolderMemberError:
    return @"DBSHARINGJobErrorRemoveFolderMemberError";
  case DBSHARINGJobErrorRelinquishFolderMembershipError:
    return @"DBSHARINGJobErrorRelinquishFolderMembershipError";
  case DBSHARINGJobErrorOther:
    return @"DBSHARINGJobErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGJobErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGJobErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGJobErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGJobErrorUnshareFolderError:
    result = prime * result + [self.unshareFolderError hash];
    break;
  case DBSHARINGJobErrorRemoveFolderMemberError:
    result = prime * result + [self.removeFolderMemberError hash];
    break;
  case DBSHARINGJobErrorRelinquishFolderMembershipError:
    result = prime * result + [self.relinquishFolderMembershipError hash];
    break;
  case DBSHARINGJobErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToJobError:other];
}

- (BOOL)isEqualToJobError:(DBSHARINGJobError *)aJobError {
  if (self == aJobError) {
    return YES;
  }
  if (self.tag != aJobError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGJobErrorUnshareFolderError:
    return [self.unshareFolderError isEqual:aJobError.unshareFolderError];
  case DBSHARINGJobErrorRemoveFolderMemberError:
    return [self.removeFolderMemberError isEqual:aJobError.removeFolderMemberError];
  case DBSHARINGJobErrorRelinquishFolderMembershipError:
    return [self.relinquishFolderMembershipError isEqual:aJobError.relinquishFolderMembershipError];
  case DBSHARINGJobErrorOther:
    return [[self tagName] isEqual:[aJobError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGJobErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGJobError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUnshareFolderError]) {
    jsonDict[@"unshare_folder_error"] =
        [[DBSHARINGUnshareFolderErrorSerializer serialize:valueObj.unshareFolderError] mutableCopy];
    jsonDict[@".tag"] = @"unshare_folder_error";
  } else if ([valueObj isRemoveFolderMemberError]) {
    jsonDict[@"remove_folder_member_error"] =
        [[DBSHARINGRemoveFolderMemberErrorSerializer serialize:valueObj.removeFolderMemberError] mutableCopy];
    jsonDict[@".tag"] = @"remove_folder_member_error";
  } else if ([valueObj isRelinquishFolderMembershipError]) {
    jsonDict[@"relinquish_folder_membership_error"] = [[DBSHARINGRelinquishFolderMembershipErrorSerializer
        serialize:valueObj.relinquishFolderMembershipError] mutableCopy];
    jsonDict[@".tag"] = @"relinquish_folder_membership_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGJobError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"unshare_folder_error"]) {
    DBSHARINGUnshareFolderError *unshareFolderError =
        [DBSHARINGUnshareFolderErrorSerializer deserialize:valueDict[@"unshare_folder_error"]];
    return [[DBSHARINGJobError alloc] initWithUnshareFolderError:unshareFolderError];
  } else if ([tag isEqualToString:@"remove_folder_member_error"]) {
    DBSHARINGRemoveFolderMemberError *removeFolderMemberError =
        [DBSHARINGRemoveFolderMemberErrorSerializer deserialize:valueDict[@"remove_folder_member_error"]];
    return [[DBSHARINGJobError alloc] initWithRemoveFolderMemberError:removeFolderMemberError];
  } else if ([tag isEqualToString:@"relinquish_folder_membership_error"]) {
    DBSHARINGRelinquishFolderMembershipError *relinquishFolderMembershipError =
        [DBSHARINGRelinquishFolderMembershipErrorSerializer
            deserialize:valueDict[@"relinquish_folder_membership_error"]];
    return [[DBSHARINGJobError alloc] initWithRelinquishFolderMembershipError:relinquishFolderMembershipError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGJobError alloc] initWithOther];
  } else {
    return [[DBSHARINGJobError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBSHARINGJobError.h"
#import "DBSHARINGJobStatus.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGJobStatus

@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobStatusComplete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBSHARINGJobError *)failed {
  self = [super init];
  if (self) {
    _tag = DBSHARINGJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGJobError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBSHARINGJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBSHARINGJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBSHARINGJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGJobStatusInProgress:
    return @"DBSHARINGJobStatusInProgress";
  case DBSHARINGJobStatusComplete:
    return @"DBSHARINGJobStatusComplete";
  case DBSHARINGJobStatusFailed:
    return @"DBSHARINGJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGJobStatusComplete:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToJobStatus:other];
}

- (BOOL)isEqualToJobStatus:(DBSHARINGJobStatus *)aJobStatus {
  if (self == aJobStatus) {
    return YES;
  }
  if (self.tag != aJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGJobStatusInProgress:
    return [[self tagName] isEqual:[aJobStatus tagName]];
  case DBSHARINGJobStatusComplete:
    return [[self tagName] isEqual:[aJobStatus tagName]];
  case DBSHARINGJobStatusFailed:
    return [self.failed isEqual:aJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBSHARINGJobErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBSHARINGJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    return [[DBSHARINGJobStatus alloc] initWithComplete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBSHARINGJobError *failed = [DBSHARINGJobErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBSHARINGJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGLinkAccessLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkAccessLevel

#pragma mark - Constructors

- (instancetype)initWithViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAccessLevelViewer;
  }
  return self;
}

- (instancetype)initWithEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAccessLevelEditor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAccessLevelOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isViewer {
  return _tag == DBSHARINGLinkAccessLevelViewer;
}

- (BOOL)isEditor {
  return _tag == DBSHARINGLinkAccessLevelEditor;
}

- (BOOL)isOther {
  return _tag == DBSHARINGLinkAccessLevelOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGLinkAccessLevelViewer:
    return @"DBSHARINGLinkAccessLevelViewer";
  case DBSHARINGLinkAccessLevelEditor:
    return @"DBSHARINGLinkAccessLevelEditor";
  case DBSHARINGLinkAccessLevelOther:
    return @"DBSHARINGLinkAccessLevelOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkAccessLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkAccessLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkAccessLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGLinkAccessLevelViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAccessLevelEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAccessLevelOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkAccessLevel:other];
}

- (BOOL)isEqualToLinkAccessLevel:(DBSHARINGLinkAccessLevel *)aLinkAccessLevel {
  if (self == aLinkAccessLevel) {
    return YES;
  }
  if (self.tag != aLinkAccessLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGLinkAccessLevelViewer:
    return [[self tagName] isEqual:[aLinkAccessLevel tagName]];
  case DBSHARINGLinkAccessLevelEditor:
    return [[self tagName] isEqual:[aLinkAccessLevel tagName]];
  case DBSHARINGLinkAccessLevelOther:
    return [[self tagName] isEqual:[aLinkAccessLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkAccessLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkAccessLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isViewer]) {
    jsonDict[@".tag"] = @"viewer";
  } else if ([valueObj isEditor]) {
    jsonDict[@".tag"] = @"editor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkAccessLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"viewer"]) {
    return [[DBSHARINGLinkAccessLevel alloc] initWithViewer];
  } else if ([tag isEqualToString:@"editor"]) {
    return [[DBSHARINGLinkAccessLevel alloc] initWithEditor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGLinkAccessLevel alloc] initWithOther];
  } else {
    return [[DBSHARINGLinkAccessLevel alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkAction

#pragma mark - Constructors

- (instancetype)initWithChangeAccessLevel {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionChangeAccessLevel;
  }
  return self;
}

- (instancetype)initWithChangeAudience {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionChangeAudience;
  }
  return self;
}

- (instancetype)initWithRemoveExpiry {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionRemoveExpiry;
  }
  return self;
}

- (instancetype)initWithRemovePassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionRemovePassword;
  }
  return self;
}

- (instancetype)initWithSetExpiry {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionSetExpiry;
  }
  return self;
}

- (instancetype)initWithSetPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionSetPassword;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkActionOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isChangeAccessLevel {
  return _tag == DBSHARINGLinkActionChangeAccessLevel;
}

- (BOOL)isChangeAudience {
  return _tag == DBSHARINGLinkActionChangeAudience;
}

- (BOOL)isRemoveExpiry {
  return _tag == DBSHARINGLinkActionRemoveExpiry;
}

- (BOOL)isRemovePassword {
  return _tag == DBSHARINGLinkActionRemovePassword;
}

- (BOOL)isSetExpiry {
  return _tag == DBSHARINGLinkActionSetExpiry;
}

- (BOOL)isSetPassword {
  return _tag == DBSHARINGLinkActionSetPassword;
}

- (BOOL)isOther {
  return _tag == DBSHARINGLinkActionOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGLinkActionChangeAccessLevel:
    return @"DBSHARINGLinkActionChangeAccessLevel";
  case DBSHARINGLinkActionChangeAudience:
    return @"DBSHARINGLinkActionChangeAudience";
  case DBSHARINGLinkActionRemoveExpiry:
    return @"DBSHARINGLinkActionRemoveExpiry";
  case DBSHARINGLinkActionRemovePassword:
    return @"DBSHARINGLinkActionRemovePassword";
  case DBSHARINGLinkActionSetExpiry:
    return @"DBSHARINGLinkActionSetExpiry";
  case DBSHARINGLinkActionSetPassword:
    return @"DBSHARINGLinkActionSetPassword";
  case DBSHARINGLinkActionOther:
    return @"DBSHARINGLinkActionOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkActionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkActionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkActionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGLinkActionChangeAccessLevel:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionChangeAudience:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionRemoveExpiry:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionRemovePassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionSetExpiry:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionSetPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkActionOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkAction:other];
}

- (BOOL)isEqualToLinkAction:(DBSHARINGLinkAction *)aLinkAction {
  if (self == aLinkAction) {
    return YES;
  }
  if (self.tag != aLinkAction.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGLinkActionChangeAccessLevel:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionChangeAudience:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionRemoveExpiry:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionRemovePassword:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionSetExpiry:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionSetPassword:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  case DBSHARINGLinkActionOther:
    return [[self tagName] isEqual:[aLinkAction tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkActionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkAction *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isChangeAccessLevel]) {
    jsonDict[@".tag"] = @"change_access_level";
  } else if ([valueObj isChangeAudience]) {
    jsonDict[@".tag"] = @"change_audience";
  } else if ([valueObj isRemoveExpiry]) {
    jsonDict[@".tag"] = @"remove_expiry";
  } else if ([valueObj isRemovePassword]) {
    jsonDict[@".tag"] = @"remove_password";
  } else if ([valueObj isSetExpiry]) {
    jsonDict[@".tag"] = @"set_expiry";
  } else if ([valueObj isSetPassword]) {
    jsonDict[@".tag"] = @"set_password";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkAction *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"change_access_level"]) {
    return [[DBSHARINGLinkAction alloc] initWithChangeAccessLevel];
  } else if ([tag isEqualToString:@"change_audience"]) {
    return [[DBSHARINGLinkAction alloc] initWithChangeAudience];
  } else if ([tag isEqualToString:@"remove_expiry"]) {
    return [[DBSHARINGLinkAction alloc] initWithRemoveExpiry];
  } else if ([tag isEqualToString:@"remove_password"]) {
    return [[DBSHARINGLinkAction alloc] initWithRemovePassword];
  } else if ([tag isEqualToString:@"set_expiry"]) {
    return [[DBSHARINGLinkAction alloc] initWithSetExpiry];
  } else if ([tag isEqualToString:@"set_password"]) {
    return [[DBSHARINGLinkAction alloc] initWithSetPassword];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGLinkAction alloc] initWithOther];
  } else {
    return [[DBSHARINGLinkAction alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkAudience.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkAudience

#pragma mark - Constructors

- (instancetype)initWithPublic {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudiencePublic;
  }
  return self;
}

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudienceTeam;
  }
  return self;
}

- (instancetype)initWithNoOne {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudienceNoOne;
  }
  return self;
}

- (instancetype)initWithPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudiencePassword;
  }
  return self;
}

- (instancetype)initWithMembers {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudienceMembers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkAudienceOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPublic {
  return _tag == DBSHARINGLinkAudiencePublic;
}

- (BOOL)isTeam {
  return _tag == DBSHARINGLinkAudienceTeam;
}

- (BOOL)isNoOne {
  return _tag == DBSHARINGLinkAudienceNoOne;
}

- (BOOL)isPassword {
  return _tag == DBSHARINGLinkAudiencePassword;
}

- (BOOL)isMembers {
  return _tag == DBSHARINGLinkAudienceMembers;
}

- (BOOL)isOther {
  return _tag == DBSHARINGLinkAudienceOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGLinkAudiencePublic:
    return @"DBSHARINGLinkAudiencePublic";
  case DBSHARINGLinkAudienceTeam:
    return @"DBSHARINGLinkAudienceTeam";
  case DBSHARINGLinkAudienceNoOne:
    return @"DBSHARINGLinkAudienceNoOne";
  case DBSHARINGLinkAudiencePassword:
    return @"DBSHARINGLinkAudiencePassword";
  case DBSHARINGLinkAudienceMembers:
    return @"DBSHARINGLinkAudienceMembers";
  case DBSHARINGLinkAudienceOther:
    return @"DBSHARINGLinkAudienceOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkAudienceSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkAudienceSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkAudienceSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGLinkAudiencePublic:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAudienceTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAudienceNoOne:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAudiencePassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAudienceMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkAudienceOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkAudience:other];
}

- (BOOL)isEqualToLinkAudience:(DBSHARINGLinkAudience *)aLinkAudience {
  if (self == aLinkAudience) {
    return YES;
  }
  if (self.tag != aLinkAudience.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGLinkAudiencePublic:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  case DBSHARINGLinkAudienceTeam:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  case DBSHARINGLinkAudienceNoOne:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  case DBSHARINGLinkAudiencePassword:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  case DBSHARINGLinkAudienceMembers:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  case DBSHARINGLinkAudienceOther:
    return [[self tagName] isEqual:[aLinkAudience tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkAudienceSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkAudience *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPublic]) {
    jsonDict[@".tag"] = @"public";
  } else if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isNoOne]) {
    jsonDict[@".tag"] = @"no_one";
  } else if ([valueObj isPassword]) {
    jsonDict[@".tag"] = @"password";
  } else if ([valueObj isMembers]) {
    jsonDict[@".tag"] = @"members";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkAudience *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"public"]) {
    return [[DBSHARINGLinkAudience alloc] initWithPublic];
  } else if ([tag isEqualToString:@"team"]) {
    return [[DBSHARINGLinkAudience alloc] initWithTeam];
  } else if ([tag isEqualToString:@"no_one"]) {
    return [[DBSHARINGLinkAudience alloc] initWithNoOne];
  } else if ([tag isEqualToString:@"password"]) {
    return [[DBSHARINGLinkAudience alloc] initWithPassword];
  } else if ([tag isEqualToString:@"members"]) {
    return [[DBSHARINGLinkAudience alloc] initWithMembers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGLinkAudience alloc] initWithOther];
  } else {
    return [[DBSHARINGLinkAudience alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkExpiry.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkExpiry

@synthesize setExpiry = _setExpiry;

#pragma mark - Constructors

- (instancetype)initWithRemoveExpiry {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkExpiryRemoveExpiry;
  }
  return self;
}

- (instancetype)initWithSetExpiry:(NSDate *)setExpiry {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkExpirySetExpiry;
    _setExpiry = setExpiry;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkExpiryOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSDate *)setExpiry {
  if (![self isSetExpiry]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGLinkExpirySetExpiry, but was %@.", [self tagName]];
  }
  return _setExpiry;
}

#pragma mark - Tag state methods

- (BOOL)isRemoveExpiry {
  return _tag == DBSHARINGLinkExpiryRemoveExpiry;
}

- (BOOL)isSetExpiry {
  return _tag == DBSHARINGLinkExpirySetExpiry;
}

- (BOOL)isOther {
  return _tag == DBSHARINGLinkExpiryOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGLinkExpiryRemoveExpiry:
    return @"DBSHARINGLinkExpiryRemoveExpiry";
  case DBSHARINGLinkExpirySetExpiry:
    return @"DBSHARINGLinkExpirySetExpiry";
  case DBSHARINGLinkExpiryOther:
    return @"DBSHARINGLinkExpiryOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkExpirySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkExpirySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkExpirySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGLinkExpiryRemoveExpiry:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkExpirySetExpiry:
    result = prime * result + [self.setExpiry hash];
    break;
  case DBSHARINGLinkExpiryOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkExpiry:other];
}

- (BOOL)isEqualToLinkExpiry:(DBSHARINGLinkExpiry *)aLinkExpiry {
  if (self == aLinkExpiry) {
    return YES;
  }
  if (self.tag != aLinkExpiry.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGLinkExpiryRemoveExpiry:
    return [[self tagName] isEqual:[aLinkExpiry tagName]];
  case DBSHARINGLinkExpirySetExpiry:
    return [self.setExpiry isEqual:aLinkExpiry.setExpiry];
  case DBSHARINGLinkExpiryOther:
    return [[self tagName] isEqual:[aLinkExpiry tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkExpirySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkExpiry *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRemoveExpiry]) {
    jsonDict[@".tag"] = @"remove_expiry";
  } else if ([valueObj isSetExpiry]) {
    jsonDict[@"set_expiry"] = [DBNSDateSerializer serialize:valueObj.setExpiry dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
    jsonDict[@".tag"] = @"set_expiry";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkExpiry *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"remove_expiry"]) {
    return [[DBSHARINGLinkExpiry alloc] initWithRemoveExpiry];
  } else if ([tag isEqualToString:@"set_expiry"]) {
    NSDate *setExpiry = [DBNSDateSerializer deserialize:valueDict[@"set_expiry"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
    return [[DBSHARINGLinkExpiry alloc] initWithSetExpiry:setExpiry];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGLinkExpiry alloc] initWithOther];
  } else {
    return [[DBSHARINGLinkExpiry alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkPassword.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkPassword

@synthesize setPassword = _setPassword;

#pragma mark - Constructors

- (instancetype)initWithRemovePassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkPasswordRemovePassword;
  }
  return self;
}

- (instancetype)initWithSetPassword:(NSString *)setPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkPasswordSetPassword;
    _setPassword = setPassword;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGLinkPasswordOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)setPassword {
  if (![self isSetPassword]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGLinkPasswordSetPassword, but was %@.", [self tagName]];
  }
  return _setPassword;
}

#pragma mark - Tag state methods

- (BOOL)isRemovePassword {
  return _tag == DBSHARINGLinkPasswordRemovePassword;
}

- (BOOL)isSetPassword {
  return _tag == DBSHARINGLinkPasswordSetPassword;
}

- (BOOL)isOther {
  return _tag == DBSHARINGLinkPasswordOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGLinkPasswordRemovePassword:
    return @"DBSHARINGLinkPasswordRemovePassword";
  case DBSHARINGLinkPasswordSetPassword:
    return @"DBSHARINGLinkPasswordSetPassword";
  case DBSHARINGLinkPasswordOther:
    return @"DBSHARINGLinkPasswordOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkPasswordSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkPasswordSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkPasswordSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGLinkPasswordRemovePassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGLinkPasswordSetPassword:
    result = prime * result + [self.setPassword hash];
    break;
  case DBSHARINGLinkPasswordOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkPassword:other];
}

- (BOOL)isEqualToLinkPassword:(DBSHARINGLinkPassword *)aLinkPassword {
  if (self == aLinkPassword) {
    return YES;
  }
  if (self.tag != aLinkPassword.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGLinkPasswordRemovePassword:
    return [[self tagName] isEqual:[aLinkPassword tagName]];
  case DBSHARINGLinkPasswordSetPassword:
    return [self.setPassword isEqual:aLinkPassword.setPassword];
  case DBSHARINGLinkPasswordOther:
    return [[self tagName] isEqual:[aLinkPassword tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkPasswordSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkPassword *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isRemovePassword]) {
    jsonDict[@".tag"] = @"remove_password";
  } else if ([valueObj isSetPassword]) {
    jsonDict[@"set_password"] = valueObj.setPassword;
    jsonDict[@".tag"] = @"set_password";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkPassword *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"remove_password"]) {
    return [[DBSHARINGLinkPassword alloc] initWithRemovePassword];
  } else if ([tag isEqualToString:@"set_password"]) {
    NSString *setPassword = valueDict[@"set_password"];
    return [[DBSHARINGLinkPassword alloc] initWithSetPassword:setPassword];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGLinkPassword alloc] initWithOther];
  } else {
    return [[DBSHARINGLinkPassword alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkAction.h"
#import "DBSHARINGLinkPermission.h"
#import "DBSHARINGPermissionDeniedReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkPermission

#pragma mark - Constructors

- (instancetype)initWithAction:(DBSHARINGLinkAction *)action
                         allow:(NSNumber *)allow
                        reason:(DBSHARINGPermissionDeniedReason *)reason {
  [DBStoneValidators nonnullValidator:nil](action);
  [DBStoneValidators nonnullValidator:nil](allow);

  self = [super init];
  if (self) {
    _action = action;
    _allow = allow;
    _reason = reason;
  }
  return self;
}

- (instancetype)initWithAction:(DBSHARINGLinkAction *)action allow:(NSNumber *)allow {
  return [self initWithAction:action allow:allow reason:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkPermissionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkPermissionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkPermissionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.action hash];
  result = prime * result + [self.allow hash];
  if (self.reason != nil) {
    result = prime * result + [self.reason hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkPermission:other];
}

- (BOOL)isEqualToLinkPermission:(DBSHARINGLinkPermission *)aLinkPermission {
  if (self == aLinkPermission) {
    return YES;
  }
  if (![self.action isEqual:aLinkPermission.action]) {
    return NO;
  }
  if (![self.allow isEqual:aLinkPermission.allow]) {
    return NO;
  }
  if (self.reason) {
    if (![self.reason isEqual:aLinkPermission.reason]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkPermissionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkPermission *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"action"] = [DBSHARINGLinkActionSerializer serialize:valueObj.action];
  jsonDict[@"allow"] = valueObj.allow;
  if (valueObj.reason) {
    jsonDict[@"reason"] = [DBSHARINGPermissionDeniedReasonSerializer serialize:valueObj.reason];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkPermission *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGLinkAction *action = [DBSHARINGLinkActionSerializer deserialize:valueDict[@"action"]];
  NSNumber *allow = valueDict[@"allow"];
  DBSHARINGPermissionDeniedReason *reason =
      valueDict[@"reason"] ? [DBSHARINGPermissionDeniedReasonSerializer deserialize:valueDict[@"reason"]] : nil;

  return [[DBSHARINGLinkPermission alloc] initWithAction:action allow:allow reason:reason];
}

@end

#import "DBSHARINGLinkAccessLevel.h"
#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGLinkPermissions.h"
#import "DBSHARINGRequestedVisibility.h"
#import "DBSHARINGResolvedVisibility.h"
#import "DBSHARINGSharedLinkAccessFailureReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkPermissions

#pragma mark - Constructors

- (instancetype)initWithCanRevoke:(NSNumber *)canRevoke
               resolvedVisibility:(DBSHARINGResolvedVisibility *)resolvedVisibility
              requestedVisibility:(DBSHARINGRequestedVisibility *)requestedVisibility
              revokeFailureReason:(DBSHARINGSharedLinkAccessFailureReason *)revokeFailureReason
                effectiveAudience:(DBSHARINGLinkAudience *)effectiveAudience
                  linkAccessLevel:(DBSHARINGLinkAccessLevel *)linkAccessLevel {
  [DBStoneValidators nonnullValidator:nil](canRevoke);

  self = [super init];
  if (self) {
    _resolvedVisibility = resolvedVisibility;
    _requestedVisibility = requestedVisibility;
    _canRevoke = canRevoke;
    _revokeFailureReason = revokeFailureReason;
    _effectiveAudience = effectiveAudience;
    _linkAccessLevel = linkAccessLevel;
  }
  return self;
}

- (instancetype)initWithCanRevoke:(NSNumber *)canRevoke {
  return [self initWithCanRevoke:canRevoke
              resolvedVisibility:nil
             requestedVisibility:nil
             revokeFailureReason:nil
               effectiveAudience:nil
                 linkAccessLevel:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkPermissionsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkPermissionsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkPermissionsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.canRevoke hash];
  if (self.resolvedVisibility != nil) {
    result = prime * result + [self.resolvedVisibility hash];
  }
  if (self.requestedVisibility != nil) {
    result = prime * result + [self.requestedVisibility hash];
  }
  if (self.revokeFailureReason != nil) {
    result = prime * result + [self.revokeFailureReason hash];
  }
  if (self.effectiveAudience != nil) {
    result = prime * result + [self.effectiveAudience hash];
  }
  if (self.linkAccessLevel != nil) {
    result = prime * result + [self.linkAccessLevel hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkPermissions:other];
}

- (BOOL)isEqualToLinkPermissions:(DBSHARINGLinkPermissions *)aLinkPermissions {
  if (self == aLinkPermissions) {
    return YES;
  }
  if (![self.canRevoke isEqual:aLinkPermissions.canRevoke]) {
    return NO;
  }
  if (self.resolvedVisibility) {
    if (![self.resolvedVisibility isEqual:aLinkPermissions.resolvedVisibility]) {
      return NO;
    }
  }
  if (self.requestedVisibility) {
    if (![self.requestedVisibility isEqual:aLinkPermissions.requestedVisibility]) {
      return NO;
    }
  }
  if (self.revokeFailureReason) {
    if (![self.revokeFailureReason isEqual:aLinkPermissions.revokeFailureReason]) {
      return NO;
    }
  }
  if (self.effectiveAudience) {
    if (![self.effectiveAudience isEqual:aLinkPermissions.effectiveAudience]) {
      return NO;
    }
  }
  if (self.linkAccessLevel) {
    if (![self.linkAccessLevel isEqual:aLinkPermissions.linkAccessLevel]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkPermissionsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkPermissions *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"can_revoke"] = valueObj.canRevoke;
  if (valueObj.resolvedVisibility) {
    jsonDict[@"resolved_visibility"] = [DBSHARINGResolvedVisibilitySerializer serialize:valueObj.resolvedVisibility];
  }
  if (valueObj.requestedVisibility) {
    jsonDict[@"requested_visibility"] = [DBSHARINGRequestedVisibilitySerializer serialize:valueObj.requestedVisibility];
  }
  if (valueObj.revokeFailureReason) {
    jsonDict[@"revoke_failure_reason"] =
        [DBSHARINGSharedLinkAccessFailureReasonSerializer serialize:valueObj.revokeFailureReason];
  }
  if (valueObj.effectiveAudience) {
    jsonDict[@"effective_audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.effectiveAudience];
  }
  if (valueObj.linkAccessLevel) {
    jsonDict[@"link_access_level"] = [DBSHARINGLinkAccessLevelSerializer serialize:valueObj.linkAccessLevel];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkPermissions *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *canRevoke = valueDict[@"can_revoke"];
  DBSHARINGResolvedVisibility *resolvedVisibility =
      valueDict[@"resolved_visibility"]
          ? [DBSHARINGResolvedVisibilitySerializer deserialize:valueDict[@"resolved_visibility"]]
          : nil;
  DBSHARINGRequestedVisibility *requestedVisibility =
      valueDict[@"requested_visibility"]
          ? [DBSHARINGRequestedVisibilitySerializer deserialize:valueDict[@"requested_visibility"]]
          : nil;
  DBSHARINGSharedLinkAccessFailureReason *revokeFailureReason =
      valueDict[@"revoke_failure_reason"]
          ? [DBSHARINGSharedLinkAccessFailureReasonSerializer deserialize:valueDict[@"revoke_failure_reason"]]
          : nil;
  DBSHARINGLinkAudience *effectiveAudience =
      valueDict[@"effective_audience"] ? [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"effective_audience"]]
                                       : nil;
  DBSHARINGLinkAccessLevel *linkAccessLevel =
      valueDict[@"link_access_level"] ? [DBSHARINGLinkAccessLevelSerializer deserialize:valueDict[@"link_access_level"]]
                                      : nil;

  return [[DBSHARINGLinkPermissions alloc] initWithCanRevoke:canRevoke
                                          resolvedVisibility:resolvedVisibility
                                         requestedVisibility:requestedVisibility
                                         revokeFailureReason:revokeFailureReason
                                           effectiveAudience:effectiveAudience
                                             linkAccessLevel:linkAccessLevel];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGLinkExpiry.h"
#import "DBSHARINGLinkPassword.h"
#import "DBSHARINGLinkSettings.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGLinkSettings

#pragma mark - Constructors

- (instancetype)initWithAccessLevel:(DBSHARINGAccessLevel *)accessLevel
                           audience:(DBSHARINGLinkAudience *)audience
                             expiry:(DBSHARINGLinkExpiry *)expiry
                           password:(DBSHARINGLinkPassword *)password {

  self = [super init];
  if (self) {
    _accessLevel = accessLevel;
    _audience = audience;
    _expiry = expiry;
    _password = password;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithAccessLevel:nil audience:nil expiry:nil password:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGLinkSettingsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGLinkSettingsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGLinkSettingsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.accessLevel != nil) {
    result = prime * result + [self.accessLevel hash];
  }
  if (self.audience != nil) {
    result = prime * result + [self.audience hash];
  }
  if (self.expiry != nil) {
    result = prime * result + [self.expiry hash];
  }
  if (self.password != nil) {
    result = prime * result + [self.password hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToLinkSettings:other];
}

- (BOOL)isEqualToLinkSettings:(DBSHARINGLinkSettings *)aLinkSettings {
  if (self == aLinkSettings) {
    return YES;
  }
  if (self.accessLevel) {
    if (![self.accessLevel isEqual:aLinkSettings.accessLevel]) {
      return NO;
    }
  }
  if (self.audience) {
    if (![self.audience isEqual:aLinkSettings.audience]) {
      return NO;
    }
  }
  if (self.expiry) {
    if (![self.expiry isEqual:aLinkSettings.expiry]) {
      return NO;
    }
  }
  if (self.password) {
    if (![self.password isEqual:aLinkSettings.password]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGLinkSettingsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGLinkSettings *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.accessLevel) {
    jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  }
  if (valueObj.audience) {
    jsonDict[@"audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.audience];
  }
  if (valueObj.expiry) {
    jsonDict[@"expiry"] = [DBSHARINGLinkExpirySerializer serialize:valueObj.expiry];
  }
  if (valueObj.password) {
    jsonDict[@"password"] = [DBSHARINGLinkPasswordSerializer serialize:valueObj.password];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGLinkSettings *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessLevel =
      valueDict[@"access_level"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]] : nil;
  DBSHARINGLinkAudience *audience =
      valueDict[@"audience"] ? [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"audience"]] : nil;
  DBSHARINGLinkExpiry *expiry =
      valueDict[@"expiry"] ? [DBSHARINGLinkExpirySerializer deserialize:valueDict[@"expiry"]] : nil;
  DBSHARINGLinkPassword *password =
      valueDict[@"password"] ? [DBSHARINGLinkPasswordSerializer deserialize:valueDict[@"password"]] : nil;

  return
      [[DBSHARINGLinkSettings alloc] initWithAccessLevel:accessLevel audience:audience expiry:expiry password:password];
}

@end

#import "DBSHARINGListFileMembersArg.h"
#import "DBSHARINGMemberAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersArg

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file
                     actions:(NSArray<DBSHARINGMemberAction *> *)actions
            includeInherited:(NSNumber *)includeInherited
                       limit:(NSNumber *)limit {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _file = file;
    _actions = actions;
    _includeInherited = includeInherited ?: @YES;
    _limit = limit ?: @(100);
  }
  return self;
}

- (instancetype)initWithFile:(NSString *)file {
  return [self initWithFile:file actions:nil includeInherited:nil limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }
  result = prime * result + [self.includeInherited hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersArg:other];
}

- (BOOL)isEqualToListFileMembersArg:(DBSHARINGListFileMembersArg *)aListFileMembersArg {
  if (self == aListFileMembersArg) {
    return YES;
  }
  if (![self.file isEqual:aListFileMembersArg.file]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aListFileMembersArg.actions]) {
      return NO;
    }
  }
  if (![self.includeInherited isEqual:aListFileMembersArg.includeInherited]) {
    return NO;
  }
  if (![self.limit isEqual:aListFileMembersArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGMemberActionSerializer serialize:elem0];
                                              }];
  }
  jsonDict[@"include_inherited"] = valueObj.includeInherited;
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  NSArray<DBSHARINGMemberAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGMemberActionSerializer deserialize:elem0];
                                                   }]
                            : nil;
  NSNumber *includeInherited = valueDict[@"include_inherited"] ?: @YES;
  NSNumber *limit = valueDict[@"limit"] ?: @(100);

  return [[DBSHARINGListFileMembersArg alloc] initWithFile:file
                                                   actions:actions
                                          includeInherited:includeInherited
                                                     limit:limit];
}

@end

#import "DBSHARINGListFileMembersBatchArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersBatchArg

#pragma mark - Constructors

- (instancetype)initWithFiles:(NSArray<NSString *> *)files limit:(NSNumber *)limit {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:nil
                              maxItems:@(100)
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators
                                                                stringValidator:@(1)
                                                                      maxLength:nil
                                                                        pattern:@"((/"
                                                                                @"|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+("
                                                                                @"/.*)?"]]]](files);

  self = [super init];
  if (self) {
    _files = files;
    _limit = limit ?: @(10);
  }
  return self;
}

- (instancetype)initWithFiles:(NSArray<NSString *> *)files {
  return [self initWithFiles:files limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersBatchArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersBatchArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersBatchArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.files hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersBatchArg:other];
}

- (BOOL)isEqualToListFileMembersBatchArg:(DBSHARINGListFileMembersBatchArg *)aListFileMembersBatchArg {
  if (self == aListFileMembersBatchArg) {
    return YES;
  }
  if (![self.files isEqual:aListFileMembersBatchArg.files]) {
    return NO;
  }
  if (![self.limit isEqual:aListFileMembersBatchArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersBatchArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersBatchArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"files"] = [DBArraySerializer serialize:valueObj.files
                                          withBlock:^id(id elem0) {
                                            return elem0;
                                          }];
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersBatchArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *files = [DBArraySerializer deserialize:valueDict[@"files"]
                                                    withBlock:^id(id elem0) {
                                                      return elem0;
                                                    }];
  NSNumber *limit = valueDict[@"limit"] ?: @(10);

  return [[DBSHARINGListFileMembersBatchArg alloc] initWithFiles:files limit:limit];
}

@end

#import "DBSHARINGListFileMembersBatchResult.h"
#import "DBSHARINGListFileMembersIndividualResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersBatchResult

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file result:(DBSHARINGListFileMembersIndividualResult *)result {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators nonnullValidator:nil](result);

  self = [super init];
  if (self) {
    _file = file;
    _result = result;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersBatchResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersBatchResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersBatchResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.result hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersBatchResult:other];
}

- (BOOL)isEqualToListFileMembersBatchResult:(DBSHARINGListFileMembersBatchResult *)aListFileMembersBatchResult {
  if (self == aListFileMembersBatchResult) {
    return YES;
  }
  if (![self.file isEqual:aListFileMembersBatchResult.file]) {
    return NO;
  }
  if (![self.result isEqual:aListFileMembersBatchResult.result]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersBatchResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersBatchResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"result"] = [DBSHARINGListFileMembersIndividualResultSerializer serialize:valueObj.result];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersBatchResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  DBSHARINGListFileMembersIndividualResult *result =
      [DBSHARINGListFileMembersIndividualResultSerializer deserialize:valueDict[@"result"]];

  return [[DBSHARINGListFileMembersBatchResult alloc] initWithFile:file result:result];
}

@end

#import "DBSHARINGListFileMembersContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersContinueArg:other];
}

- (BOOL)isEqualToListFileMembersContinueArg:(DBSHARINGListFileMembersContinueArg *)aListFileMembersContinueArg {
  if (self == aListFileMembersContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFileMembersContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBSHARINGListFileMembersContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBSHARINGListFileMembersContinueError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersContinueError

@synthesize userError = _userError;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersContinueErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersContinueErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGListFileMembersContinueErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGListFileMembersContinueErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGListFileMembersContinueErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGListFileMembersContinueErrorAccessError;
}

- (BOOL)isInvalidCursor {
  return _tag == DBSHARINGListFileMembersContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFileMembersContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFileMembersContinueErrorUserError:
    return @"DBSHARINGListFileMembersContinueErrorUserError";
  case DBSHARINGListFileMembersContinueErrorAccessError:
    return @"DBSHARINGListFileMembersContinueErrorAccessError";
  case DBSHARINGListFileMembersContinueErrorInvalidCursor:
    return @"DBSHARINGListFileMembersContinueErrorInvalidCursor";
  case DBSHARINGListFileMembersContinueErrorOther:
    return @"DBSHARINGListFileMembersContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFileMembersContinueErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGListFileMembersContinueErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGListFileMembersContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGListFileMembersContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersContinueError:other];
}

- (BOOL)isEqualToListFileMembersContinueError:(DBSHARINGListFileMembersContinueError *)aListFileMembersContinueError {
  if (self == aListFileMembersContinueError) {
    return YES;
  }
  if (self.tag != aListFileMembersContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFileMembersContinueErrorUserError:
    return [self.userError isEqual:aListFileMembersContinueError.userError];
  case DBSHARINGListFileMembersContinueErrorAccessError:
    return [self.accessError isEqual:aListFileMembersContinueError.accessError];
  case DBSHARINGListFileMembersContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aListFileMembersContinueError tagName]];
  case DBSHARINGListFileMembersContinueErrorOther:
    return [[self tagName] isEqual:[aListFileMembersContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGListFileMembersContinueError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGListFileMembersContinueError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBSHARINGListFileMembersContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFileMembersContinueError alloc] initWithOther];
  } else {
    return [[DBSHARINGListFileMembersContinueError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGListFileMembersCountResult.h"
#import "DBSHARINGSharedFileMembers.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersCountResult

#pragma mark - Constructors

- (instancetype)initWithMembers:(DBSHARINGSharedFileMembers *)members memberCount:(NSNumber *)memberCount {
  [DBStoneValidators nonnullValidator:nil](members);
  [DBStoneValidators nonnullValidator:nil](memberCount);

  self = [super init];
  if (self) {
    _members = members;
    _memberCount = memberCount;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersCountResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersCountResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersCountResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.members hash];
  result = prime * result + [self.memberCount hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersCountResult:other];
}

- (BOOL)isEqualToListFileMembersCountResult:(DBSHARINGListFileMembersCountResult *)aListFileMembersCountResult {
  if (self == aListFileMembersCountResult) {
    return YES;
  }
  if (![self.members isEqual:aListFileMembersCountResult.members]) {
    return NO;
  }
  if (![self.memberCount isEqual:aListFileMembersCountResult.memberCount]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersCountResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersCountResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"members"] = [DBSHARINGSharedFileMembersSerializer serialize:valueObj.members];
  jsonDict[@"member_count"] = valueObj.memberCount;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersCountResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGSharedFileMembers *members = [DBSHARINGSharedFileMembersSerializer deserialize:valueDict[@"members"]];
  NSNumber *memberCount = valueDict[@"member_count"];

  return [[DBSHARINGListFileMembersCountResult alloc] initWithMembers:members memberCount:memberCount];
}

@end

#import "DBSHARINGListFileMembersError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersError

@synthesize userError = _userError;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListFileMembersErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListFileMembersErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGListFileMembersErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGListFileMembersErrorAccessError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFileMembersErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFileMembersErrorUserError:
    return @"DBSHARINGListFileMembersErrorUserError";
  case DBSHARINGListFileMembersErrorAccessError:
    return @"DBSHARINGListFileMembersErrorAccessError";
  case DBSHARINGListFileMembersErrorOther:
    return @"DBSHARINGListFileMembersErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFileMembersErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGListFileMembersErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGListFileMembersErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersError:other];
}

- (BOOL)isEqualToListFileMembersError:(DBSHARINGListFileMembersError *)aListFileMembersError {
  if (self == aListFileMembersError) {
    return YES;
  }
  if (self.tag != aListFileMembersError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFileMembersErrorUserError:
    return [self.userError isEqual:aListFileMembersError.userError];
  case DBSHARINGListFileMembersErrorAccessError:
    return [self.accessError isEqual:aListFileMembersError.accessError];
  case DBSHARINGListFileMembersErrorOther:
    return [[self tagName] isEqual:[aListFileMembersError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGListFileMembersError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGListFileMembersError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFileMembersError alloc] initWithOther];
  } else {
    return [[DBSHARINGListFileMembersError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGListFileMembersCountResult.h"
#import "DBSHARINGListFileMembersIndividualResult.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFileMembersIndividualResult

@synthesize result = _result;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithResult:(DBSHARINGListFileMembersCountResult *)result {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersIndividualResultResult;
    _result = result;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersIndividualResultAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFileMembersIndividualResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGListFileMembersCountResult *)result {
  if (![self isResult]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGListFileMembersIndividualResultResult, but was %@.", [self tagName]];
  }
  return _result;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListFileMembersIndividualResultAccessError, but was %@.",
                       [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isResult {
  return _tag == DBSHARINGListFileMembersIndividualResultResult;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGListFileMembersIndividualResultAccessError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFileMembersIndividualResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFileMembersIndividualResultResult:
    return @"DBSHARINGListFileMembersIndividualResultResult";
  case DBSHARINGListFileMembersIndividualResultAccessError:
    return @"DBSHARINGListFileMembersIndividualResultAccessError";
  case DBSHARINGListFileMembersIndividualResultOther:
    return @"DBSHARINGListFileMembersIndividualResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFileMembersIndividualResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFileMembersIndividualResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFileMembersIndividualResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFileMembersIndividualResultResult:
    result = prime * result + [self.result hash];
    break;
  case DBSHARINGListFileMembersIndividualResultAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGListFileMembersIndividualResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileMembersIndividualResult:other];
}

- (BOOL)isEqualToListFileMembersIndividualResult:
    (DBSHARINGListFileMembersIndividualResult *)aListFileMembersIndividualResult {
  if (self == aListFileMembersIndividualResult) {
    return YES;
  }
  if (self.tag != aListFileMembersIndividualResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFileMembersIndividualResultResult:
    return [self.result isEqual:aListFileMembersIndividualResult.result];
  case DBSHARINGListFileMembersIndividualResultAccessError:
    return [self.accessError isEqual:aListFileMembersIndividualResult.accessError];
  case DBSHARINGListFileMembersIndividualResultOther:
    return [[self tagName] isEqual:[aListFileMembersIndividualResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFileMembersIndividualResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFileMembersIndividualResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isResult]) {
    jsonDict = [[DBSHARINGListFileMembersCountResultSerializer serialize:valueObj.result] mutableCopy];
    jsonDict[@".tag"] = @"result";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFileMembersIndividualResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"result"]) {
    DBSHARINGListFileMembersCountResult *result = [DBSHARINGListFileMembersCountResultSerializer deserialize:valueDict];
    return [[DBSHARINGListFileMembersIndividualResult alloc] initWithResult:result];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGListFileMembersIndividualResult alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFileMembersIndividualResult alloc] initWithOther];
  } else {
    return [[DBSHARINGListFileMembersIndividualResult alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFileAction.h"
#import "DBSHARINGListFilesArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFilesArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit actions:(NSArray<DBSHARINGFileAction *> *)actions {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _limit = limit ?: @(100);
    _actions = actions;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFilesArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFilesArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFilesArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFilesArg:other];
}

- (BOOL)isEqualToListFilesArg:(DBSHARINGListFilesArg *)aListFilesArg {
  if (self == aListFilesArg) {
    return YES;
  }
  if (![self.limit isEqual:aListFilesArg.limit]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aListFilesArg.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFilesArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFilesArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFileActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFilesArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(100);
  NSArray<DBSHARINGFileAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFileActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGListFilesArg alloc] initWithLimit:limit actions:actions];
}

@end

#import "DBSHARINGListFilesContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFilesContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFilesContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFilesContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFilesContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFilesContinueArg:other];
}

- (BOOL)isEqualToListFilesContinueArg:(DBSHARINGListFilesContinueArg *)aListFilesContinueArg {
  if (self == aListFilesContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFilesContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFilesContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFilesContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFilesContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBSHARINGListFilesContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBSHARINGListFilesContinueError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFilesContinueError

@synthesize userError = _userError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFilesContinueErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFilesContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFilesContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListFilesContinueErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGListFilesContinueErrorUserError;
}

- (BOOL)isInvalidCursor {
  return _tag == DBSHARINGListFilesContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFilesContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFilesContinueErrorUserError:
    return @"DBSHARINGListFilesContinueErrorUserError";
  case DBSHARINGListFilesContinueErrorInvalidCursor:
    return @"DBSHARINGListFilesContinueErrorInvalidCursor";
  case DBSHARINGListFilesContinueErrorOther:
    return @"DBSHARINGListFilesContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFilesContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFilesContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFilesContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFilesContinueErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGListFilesContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGListFilesContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFilesContinueError:other];
}

- (BOOL)isEqualToListFilesContinueError:(DBSHARINGListFilesContinueError *)aListFilesContinueError {
  if (self == aListFilesContinueError) {
    return YES;
  }
  if (self.tag != aListFilesContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFilesContinueErrorUserError:
    return [self.userError isEqual:aListFilesContinueError.userError];
  case DBSHARINGListFilesContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aListFilesContinueError tagName]];
  case DBSHARINGListFilesContinueErrorOther:
    return [[self tagName] isEqual:[aListFilesContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFilesContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFilesContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFilesContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGListFilesContinueError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBSHARINGListFilesContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFilesContinueError alloc] initWithOther];
  } else {
    return [[DBSHARINGListFilesContinueError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGListFilesResult.h"
#import "DBSHARINGSharedFileMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFilesResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBSHARINGSharedFileMetadata *> *)entries cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBSHARINGSharedFileMetadata *> *)entries {
  return [self initWithEntries:entries cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFilesResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFilesResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFilesResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFilesResult:other];
}

- (BOOL)isEqualToListFilesResult:(DBSHARINGListFilesResult *)aListFilesResult {
  if (self == aListFilesResult) {
    return YES;
  }
  if (![self.entries isEqual:aListFilesResult.entries]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListFilesResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFilesResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFilesResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBSHARINGSharedFileMetadataSerializer serialize:elem0];
                                            }];
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFilesResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGSharedFileMetadata *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGSharedFileMetadataSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBSHARINGListFilesResult alloc] initWithEntries:entries cursor:cursor];
}

@end

#import "DBSHARINGListFolderMembersCursorArg.h"
#import "DBSHARINGMemberAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFolderMembersCursorArg

#pragma mark - Constructors

- (instancetype)initWithActions:(NSArray<DBSHARINGMemberAction *> *)actions limit:(NSNumber *)limit {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _actions = actions;
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithActions:nil limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFolderMembersCursorArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFolderMembersCursorArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFolderMembersCursorArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderMembersCursorArg:other];
}

- (BOOL)isEqualToListFolderMembersCursorArg:(DBSHARINGListFolderMembersCursorArg *)aListFolderMembersCursorArg {
  if (self == aListFolderMembersCursorArg) {
    return YES;
  }
  if (self.actions) {
    if (![self.actions isEqual:aListFolderMembersCursorArg.actions]) {
      return NO;
    }
  }
  if (![self.limit isEqual:aListFolderMembersCursorArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFolderMembersCursorArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFolderMembersCursorArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGMemberActionSerializer serialize:elem0];
                                              }];
  }
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFolderMembersCursorArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGMemberAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGMemberActionSerializer deserialize:elem0];
                                                   }]
                            : nil;
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBSHARINGListFolderMembersCursorArg alloc] initWithActions:actions limit:limit];
}

@end

#import "DBSHARINGListFolderMembersArgs.h"
#import "DBSHARINGListFolderMembersCursorArg.h"
#import "DBSHARINGMemberAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFolderMembersArgs

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                               actions:(NSArray<DBSHARINGMemberAction *> *)actions
                                 limit:(NSNumber *)limit {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super initWithActions:actions limit:limit];
  if (self) {
    _sharedFolderId = sharedFolderId;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId actions:nil limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFolderMembersArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFolderMembersArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFolderMembersArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderMembersArgs:other];
}

- (BOOL)isEqualToListFolderMembersArgs:(DBSHARINGListFolderMembersArgs *)aListFolderMembersArgs {
  if (self == aListFolderMembersArgs) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aListFolderMembersArgs.sharedFolderId]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aListFolderMembersArgs.actions]) {
      return NO;
    }
  }
  if (![self.limit isEqual:aListFolderMembersArgs.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFolderMembersArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFolderMembersArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGMemberActionSerializer serialize:elem0];
                                              }];
  }
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFolderMembersArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSArray<DBSHARINGMemberAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGMemberActionSerializer deserialize:elem0];
                                                   }]
                            : nil;
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBSHARINGListFolderMembersArgs alloc] initWithSharedFolderId:sharedFolderId actions:actions limit:limit];
}

@end

#import "DBSHARINGListFolderMembersContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFolderMembersContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFolderMembersContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFolderMembersContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFolderMembersContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderMembersContinueArg:other];
}

- (BOOL)isEqualToListFolderMembersContinueArg:(DBSHARINGListFolderMembersContinueArg *)aListFolderMembersContinueArg {
  if (self == aListFolderMembersContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFolderMembersContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFolderMembersContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFolderMembersContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFolderMembersContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBSHARINGListFolderMembersContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBSHARINGListFolderMembersContinueError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFolderMembersContinueError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFolderMembersContinueErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFolderMembersContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFolderMembersContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListFolderMembersContinueErrorAccessError, but was %@.",
                       [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGListFolderMembersContinueErrorAccessError;
}

- (BOOL)isInvalidCursor {
  return _tag == DBSHARINGListFolderMembersContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFolderMembersContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFolderMembersContinueErrorAccessError:
    return @"DBSHARINGListFolderMembersContinueErrorAccessError";
  case DBSHARINGListFolderMembersContinueErrorInvalidCursor:
    return @"DBSHARINGListFolderMembersContinueErrorInvalidCursor";
  case DBSHARINGListFolderMembersContinueErrorOther:
    return @"DBSHARINGListFolderMembersContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFolderMembersContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFolderMembersContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFolderMembersContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFolderMembersContinueErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGListFolderMembersContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGListFolderMembersContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFolderMembersContinueError:other];
}

- (BOOL)isEqualToListFolderMembersContinueError:
    (DBSHARINGListFolderMembersContinueError *)aListFolderMembersContinueError {
  if (self == aListFolderMembersContinueError) {
    return YES;
  }
  if (self.tag != aListFolderMembersContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFolderMembersContinueErrorAccessError:
    return [self.accessError isEqual:aListFolderMembersContinueError.accessError];
  case DBSHARINGListFolderMembersContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aListFolderMembersContinueError tagName]];
  case DBSHARINGListFolderMembersContinueErrorOther:
    return [[self tagName] isEqual:[aListFolderMembersContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFolderMembersContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFolderMembersContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFolderMembersContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGListFolderMembersContinueError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBSHARINGListFolderMembersContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFolderMembersContinueError alloc] initWithOther];
  } else {
    return [[DBSHARINGListFolderMembersContinueError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGFolderAction.h"
#import "DBSHARINGListFoldersArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFoldersArgs

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit actions:(NSArray<DBSHARINGFolderAction *> *)actions {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
    _actions = actions;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFoldersArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFoldersArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFoldersArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFoldersArgs:other];
}

- (BOOL)isEqualToListFoldersArgs:(DBSHARINGListFoldersArgs *)aListFoldersArgs {
  if (self == aListFoldersArgs) {
    return YES;
  }
  if (![self.limit isEqual:aListFoldersArgs.limit]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aListFoldersArgs.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFoldersArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFoldersArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFolderActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFoldersArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);
  NSArray<DBSHARINGFolderAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFolderActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGListFoldersArgs alloc] initWithLimit:limit actions:actions];
}

@end

#import "DBSHARINGListFoldersContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFoldersContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFoldersContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFoldersContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFoldersContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFoldersContinueArg:other];
}

- (BOOL)isEqualToListFoldersContinueArg:(DBSHARINGListFoldersContinueArg *)aListFoldersContinueArg {
  if (self == aListFoldersContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFoldersContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFoldersContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFoldersContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFoldersContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBSHARINGListFoldersContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBSHARINGListFoldersContinueError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFoldersContinueError

#pragma mark - Constructors

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFoldersContinueErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListFoldersContinueErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidCursor {
  return _tag == DBSHARINGListFoldersContinueErrorInvalidCursor;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListFoldersContinueErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListFoldersContinueErrorInvalidCursor:
    return @"DBSHARINGListFoldersContinueErrorInvalidCursor";
  case DBSHARINGListFoldersContinueErrorOther:
    return @"DBSHARINGListFoldersContinueErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFoldersContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFoldersContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFoldersContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListFoldersContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGListFoldersContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFoldersContinueError:other];
}

- (BOOL)isEqualToListFoldersContinueError:(DBSHARINGListFoldersContinueError *)aListFoldersContinueError {
  if (self == aListFoldersContinueError) {
    return YES;
  }
  if (self.tag != aListFoldersContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListFoldersContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aListFoldersContinueError tagName]];
  case DBSHARINGListFoldersContinueErrorOther:
    return [[self tagName] isEqual:[aListFoldersContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFoldersContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFoldersContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFoldersContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBSHARINGListFoldersContinueError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListFoldersContinueError alloc] initWithOther];
  } else {
    return [[DBSHARINGListFoldersContinueError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGListFoldersResult.h"
#import "DBSHARINGSharedFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListFoldersResult

#pragma mark - Constructors

- (instancetype)initWithEntries:(NSArray<DBSHARINGSharedFolderMetadata *> *)entries cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](entries);

  self = [super init];
  if (self) {
    _entries = entries;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithEntries:(NSArray<DBSHARINGSharedFolderMetadata *> *)entries {
  return [self initWithEntries:entries cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListFoldersResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListFoldersResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListFoldersResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.entries hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFoldersResult:other];
}

- (BOOL)isEqualToListFoldersResult:(DBSHARINGListFoldersResult *)aListFoldersResult {
  if (self == aListFoldersResult) {
    return YES;
  }
  if (![self.entries isEqual:aListFoldersResult.entries]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListFoldersResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListFoldersResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListFoldersResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"entries"] = [DBArraySerializer serialize:valueObj.entries
                                            withBlock:^id(id elem0) {
                                              return [DBSHARINGSharedFolderMetadataSerializer serialize:elem0];
                                            }];
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListFoldersResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGSharedFolderMetadata *> *entries =
      [DBArraySerializer deserialize:valueDict[@"entries"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGSharedFolderMetadataSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBSHARINGListFoldersResult alloc] initWithEntries:entries cursor:cursor];
}

@end

#import "DBSHARINGListSharedLinksArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListSharedLinksArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path cursor:(NSString *)cursor directOnly:(NSNumber *)directOnly {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators
                         stringValidator:nil
                               maxLength:nil
                                 pattern:@"(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _path = path;
    _cursor = cursor;
    _directOnly = directOnly;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithPath:nil cursor:nil directOnly:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListSharedLinksArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListSharedLinksArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListSharedLinksArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.path != nil) {
    result = prime * result + [self.path hash];
  }
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }
  if (self.directOnly != nil) {
    result = prime * result + [self.directOnly hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListSharedLinksArg:other];
}

- (BOOL)isEqualToListSharedLinksArg:(DBSHARINGListSharedLinksArg *)aListSharedLinksArg {
  if (self == aListSharedLinksArg) {
    return YES;
  }
  if (self.path) {
    if (![self.path isEqual:aListSharedLinksArg.path]) {
      return NO;
    }
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListSharedLinksArg.cursor]) {
      return NO;
    }
  }
  if (self.directOnly) {
    if (![self.directOnly isEqual:aListSharedLinksArg.directOnly]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListSharedLinksArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListSharedLinksArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.path) {
    jsonDict[@"path"] = valueObj.path;
  }
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }
  if (valueObj.directOnly) {
    jsonDict[@"direct_only"] = valueObj.directOnly;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListSharedLinksArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"] ?: nil;
  NSString *cursor = valueDict[@"cursor"] ?: nil;
  NSNumber *directOnly = valueDict[@"direct_only"] ?: nil;

  return [[DBSHARINGListSharedLinksArg alloc] initWithPath:path cursor:cursor directOnly:directOnly];
}

@end

#import "DBFILESLookupError.h"
#import "DBSHARINGListSharedLinksError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListSharedLinksError

@synthesize path = _path;

#pragma mark - Constructors

- (instancetype)initWithPath:(DBFILESLookupError *)path {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListSharedLinksErrorPath;
    _path = path;
  }
  return self;
}

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListSharedLinksErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGListSharedLinksErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILESLookupError *)path {
  if (![self isPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGListSharedLinksErrorPath, but was %@.", [self tagName]];
  }
  return _path;
}

#pragma mark - Tag state methods

- (BOOL)isPath {
  return _tag == DBSHARINGListSharedLinksErrorPath;
}

- (BOOL)isReset {
  return _tag == DBSHARINGListSharedLinksErrorReset;
}

- (BOOL)isOther {
  return _tag == DBSHARINGListSharedLinksErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGListSharedLinksErrorPath:
    return @"DBSHARINGListSharedLinksErrorPath";
  case DBSHARINGListSharedLinksErrorReset:
    return @"DBSHARINGListSharedLinksErrorReset";
  case DBSHARINGListSharedLinksErrorOther:
    return @"DBSHARINGListSharedLinksErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListSharedLinksErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListSharedLinksErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListSharedLinksErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGListSharedLinksErrorPath:
    result = prime * result + [self.path hash];
    break;
  case DBSHARINGListSharedLinksErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGListSharedLinksErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListSharedLinksError:other];
}

- (BOOL)isEqualToListSharedLinksError:(DBSHARINGListSharedLinksError *)aListSharedLinksError {
  if (self == aListSharedLinksError) {
    return YES;
  }
  if (self.tag != aListSharedLinksError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGListSharedLinksErrorPath:
    return [self.path isEqual:aListSharedLinksError.path];
  case DBSHARINGListSharedLinksErrorReset:
    return [[self tagName] isEqual:[aListSharedLinksError tagName]];
  case DBSHARINGListSharedLinksErrorOther:
    return [[self tagName] isEqual:[aListSharedLinksError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListSharedLinksErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListSharedLinksError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPath]) {
    jsonDict[@"path"] = [[DBFILESLookupErrorSerializer serialize:valueObj.path] mutableCopy];
    jsonDict[@".tag"] = @"path";
  } else if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListSharedLinksError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"path"]) {
    DBFILESLookupError *path = [DBFILESLookupErrorSerializer deserialize:valueDict[@"path"]];
    return [[DBSHARINGListSharedLinksError alloc] initWithPath:path];
  } else if ([tag isEqualToString:@"reset"]) {
    return [[DBSHARINGListSharedLinksError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGListSharedLinksError alloc] initWithOther];
  } else {
    return [[DBSHARINGListSharedLinksError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGListSharedLinksResult.h"
#import "DBSHARINGSharedLinkMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGListSharedLinksResult

#pragma mark - Constructors

- (instancetype)initWithLinks:(NSArray<DBSHARINGSharedLinkMetadata *> *)links
                      hasMore:(NSNumber *)hasMore
                       cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](links);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _links = links;
    _hasMore = hasMore;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithLinks:(NSArray<DBSHARINGSharedLinkMetadata *> *)links hasMore:(NSNumber *)hasMore {
  return [self initWithLinks:links hasMore:hasMore cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGListSharedLinksResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGListSharedLinksResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGListSharedLinksResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.links hash];
  result = prime * result + [self.hasMore hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListSharedLinksResult:other];
}

- (BOOL)isEqualToListSharedLinksResult:(DBSHARINGListSharedLinksResult *)aListSharedLinksResult {
  if (self == aListSharedLinksResult) {
    return YES;
  }
  if (![self.links isEqual:aListSharedLinksResult.links]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListSharedLinksResult.hasMore]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aListSharedLinksResult.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGListSharedLinksResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGListSharedLinksResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"links"] = [DBArraySerializer serialize:valueObj.links
                                          withBlock:^id(id elem0) {
                                            return [DBSHARINGSharedLinkMetadataSerializer serialize:elem0];
                                          }];
  jsonDict[@"has_more"] = valueObj.hasMore;
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGListSharedLinksResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGSharedLinkMetadata *> *links =
      [DBArraySerializer deserialize:valueDict[@"links"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGSharedLinkMetadataSerializer deserialize:elem0];
                           }];
  NSNumber *hasMore = valueDict[@"has_more"];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBSHARINGListSharedLinksResult alloc] initWithLinks:links hasMore:hasMore cursor:cursor];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBSHARINGParentFolderAccessInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMemberAccessLevelResult

#pragma mark - Constructors

- (instancetype)initWithAccessLevel:(DBSHARINGAccessLevel *)accessLevel
                            warning:(NSString *)warning
                      accessDetails:(NSArray<DBSHARINGParentFolderAccessInfo *> *)accessDetails {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](accessDetails);

  self = [super init];
  if (self) {
    _accessLevel = accessLevel;
    _warning = warning;
    _accessDetails = accessDetails;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithAccessLevel:nil warning:nil accessDetails:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMemberAccessLevelResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMemberAccessLevelResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMemberAccessLevelResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.accessLevel != nil) {
    result = prime * result + [self.accessLevel hash];
  }
  if (self.warning != nil) {
    result = prime * result + [self.warning hash];
  }
  if (self.accessDetails != nil) {
    result = prime * result + [self.accessDetails hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberAccessLevelResult:other];
}

- (BOOL)isEqualToMemberAccessLevelResult:(DBSHARINGMemberAccessLevelResult *)aMemberAccessLevelResult {
  if (self == aMemberAccessLevelResult) {
    return YES;
  }
  if (self.accessLevel) {
    if (![self.accessLevel isEqual:aMemberAccessLevelResult.accessLevel]) {
      return NO;
    }
  }
  if (self.warning) {
    if (![self.warning isEqual:aMemberAccessLevelResult.warning]) {
      return NO;
    }
  }
  if (self.accessDetails) {
    if (![self.accessDetails isEqual:aMemberAccessLevelResult.accessDetails]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMemberAccessLevelResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberAccessLevelResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.accessLevel) {
    jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  }
  if (valueObj.warning) {
    jsonDict[@"warning"] = valueObj.warning;
  }
  if (valueObj.accessDetails) {
    jsonDict[@"access_details"] =
        [DBArraySerializer serialize:valueObj.accessDetails
                           withBlock:^id(id elem0) {
                             return [DBSHARINGParentFolderAccessInfoSerializer serialize:elem0];
                           }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMemberAccessLevelResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessLevel =
      valueDict[@"access_level"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]] : nil;
  NSString *warning = valueDict[@"warning"] ?: nil;
  NSArray<DBSHARINGParentFolderAccessInfo *> *accessDetails =
      valueDict[@"access_details"]
          ? [DBArraySerializer deserialize:valueDict[@"access_details"]
                                 withBlock:^id(id elem0) {
                                   return [DBSHARINGParentFolderAccessInfoSerializer deserialize:elem0];
                                 }]
          : nil;

  return [[DBSHARINGMemberAccessLevelResult alloc] initWithAccessLevel:accessLevel
                                                               warning:warning
                                                         accessDetails:accessDetails];
}

@end

#import "DBSHARINGMemberAction.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMemberAction

#pragma mark - Constructors

- (instancetype)initWithLeaveACopy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionLeaveACopy;
  }
  return self;
}

- (instancetype)initWithMakeEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionMakeEditor;
  }
  return self;
}

- (instancetype)initWithMakeOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionMakeOwner;
  }
  return self;
}

- (instancetype)initWithMakeViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionMakeViewer;
  }
  return self;
}

- (instancetype)initWithMakeViewerNoComment {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionMakeViewerNoComment;
  }
  return self;
}

- (instancetype)initWithRemove {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionRemove;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberActionOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isLeaveACopy {
  return _tag == DBSHARINGMemberActionLeaveACopy;
}

- (BOOL)isMakeEditor {
  return _tag == DBSHARINGMemberActionMakeEditor;
}

- (BOOL)isMakeOwner {
  return _tag == DBSHARINGMemberActionMakeOwner;
}

- (BOOL)isMakeViewer {
  return _tag == DBSHARINGMemberActionMakeViewer;
}

- (BOOL)isMakeViewerNoComment {
  return _tag == DBSHARINGMemberActionMakeViewerNoComment;
}

- (BOOL)isRemove {
  return _tag == DBSHARINGMemberActionRemove;
}

- (BOOL)isOther {
  return _tag == DBSHARINGMemberActionOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGMemberActionLeaveACopy:
    return @"DBSHARINGMemberActionLeaveACopy";
  case DBSHARINGMemberActionMakeEditor:
    return @"DBSHARINGMemberActionMakeEditor";
  case DBSHARINGMemberActionMakeOwner:
    return @"DBSHARINGMemberActionMakeOwner";
  case DBSHARINGMemberActionMakeViewer:
    return @"DBSHARINGMemberActionMakeViewer";
  case DBSHARINGMemberActionMakeViewerNoComment:
    return @"DBSHARINGMemberActionMakeViewerNoComment";
  case DBSHARINGMemberActionRemove:
    return @"DBSHARINGMemberActionRemove";
  case DBSHARINGMemberActionOther:
    return @"DBSHARINGMemberActionOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMemberActionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMemberActionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMemberActionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGMemberActionLeaveACopy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionMakeEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionMakeOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionMakeViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionMakeViewerNoComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionRemove:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberActionOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberAction:other];
}

- (BOOL)isEqualToMemberAction:(DBSHARINGMemberAction *)aMemberAction {
  if (self == aMemberAction) {
    return YES;
  }
  if (self.tag != aMemberAction.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGMemberActionLeaveACopy:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionMakeEditor:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionMakeOwner:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionMakeViewer:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionMakeViewerNoComment:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionRemove:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  case DBSHARINGMemberActionOther:
    return [[self tagName] isEqual:[aMemberAction tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMemberActionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberAction *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLeaveACopy]) {
    jsonDict[@".tag"] = @"leave_a_copy";
  } else if ([valueObj isMakeEditor]) {
    jsonDict[@".tag"] = @"make_editor";
  } else if ([valueObj isMakeOwner]) {
    jsonDict[@".tag"] = @"make_owner";
  } else if ([valueObj isMakeViewer]) {
    jsonDict[@".tag"] = @"make_viewer";
  } else if ([valueObj isMakeViewerNoComment]) {
    jsonDict[@".tag"] = @"make_viewer_no_comment";
  } else if ([valueObj isRemove]) {
    jsonDict[@".tag"] = @"remove";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMemberAction *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"leave_a_copy"]) {
    return [[DBSHARINGMemberAction alloc] initWithLeaveACopy];
  } else if ([tag isEqualToString:@"make_editor"]) {
    return [[DBSHARINGMemberAction alloc] initWithMakeEditor];
  } else if ([tag isEqualToString:@"make_owner"]) {
    return [[DBSHARINGMemberAction alloc] initWithMakeOwner];
  } else if ([tag isEqualToString:@"make_viewer"]) {
    return [[DBSHARINGMemberAction alloc] initWithMakeViewer];
  } else if ([tag isEqualToString:@"make_viewer_no_comment"]) {
    return [[DBSHARINGMemberAction alloc] initWithMakeViewerNoComment];
  } else if ([tag isEqualToString:@"remove"]) {
    return [[DBSHARINGMemberAction alloc] initWithRemove];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGMemberAction alloc] initWithOther];
  } else {
    return [[DBSHARINGMemberAction alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberAction.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGPermissionDeniedReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMemberPermission

#pragma mark - Constructors

- (instancetype)initWithAction:(DBSHARINGMemberAction *)action
                         allow:(NSNumber *)allow
                        reason:(DBSHARINGPermissionDeniedReason *)reason {
  [DBStoneValidators nonnullValidator:nil](action);
  [DBStoneValidators nonnullValidator:nil](allow);

  self = [super init];
  if (self) {
    _action = action;
    _allow = allow;
    _reason = reason;
  }
  return self;
}

- (instancetype)initWithAction:(DBSHARINGMemberAction *)action allow:(NSNumber *)allow {
  return [self initWithAction:action allow:allow reason:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMemberPermissionSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMemberPermissionSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMemberPermissionSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.action hash];
  result = prime * result + [self.allow hash];
  if (self.reason != nil) {
    result = prime * result + [self.reason hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberPermission:other];
}

- (BOOL)isEqualToMemberPermission:(DBSHARINGMemberPermission *)aMemberPermission {
  if (self == aMemberPermission) {
    return YES;
  }
  if (![self.action isEqual:aMemberPermission.action]) {
    return NO;
  }
  if (![self.allow isEqual:aMemberPermission.allow]) {
    return NO;
  }
  if (self.reason) {
    if (![self.reason isEqual:aMemberPermission.reason]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMemberPermissionSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberPermission *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"action"] = [DBSHARINGMemberActionSerializer serialize:valueObj.action];
  jsonDict[@"allow"] = valueObj.allow;
  if (valueObj.reason) {
    jsonDict[@"reason"] = [DBSHARINGPermissionDeniedReasonSerializer serialize:valueObj.reason];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMemberPermission *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGMemberAction *action = [DBSHARINGMemberActionSerializer deserialize:valueDict[@"action"]];
  NSNumber *allow = valueDict[@"allow"];
  DBSHARINGPermissionDeniedReason *reason =
      valueDict[@"reason"] ? [DBSHARINGPermissionDeniedReasonSerializer deserialize:valueDict[@"reason"]] : nil;

  return [[DBSHARINGMemberPermission alloc] initWithAction:action allow:allow reason:reason];
}

@end

#import "DBSHARINGMemberPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMemberPolicy

#pragma mark - Constructors

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberPolicyTeam;
  }
  return self;
}

- (instancetype)initWithAnyone {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberPolicyAnyone;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTeam {
  return _tag == DBSHARINGMemberPolicyTeam;
}

- (BOOL)isAnyone {
  return _tag == DBSHARINGMemberPolicyAnyone;
}

- (BOOL)isOther {
  return _tag == DBSHARINGMemberPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGMemberPolicyTeam:
    return @"DBSHARINGMemberPolicyTeam";
  case DBSHARINGMemberPolicyAnyone:
    return @"DBSHARINGMemberPolicyAnyone";
  case DBSHARINGMemberPolicyOther:
    return @"DBSHARINGMemberPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMemberPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMemberPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMemberPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGMemberPolicyTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberPolicyAnyone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMemberPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberPolicy:other];
}

- (BOOL)isEqualToMemberPolicy:(DBSHARINGMemberPolicy *)aMemberPolicy {
  if (self == aMemberPolicy) {
    return YES;
  }
  if (self.tag != aMemberPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGMemberPolicyTeam:
    return [[self tagName] isEqual:[aMemberPolicy tagName]];
  case DBSHARINGMemberPolicyAnyone:
    return [[self tagName] isEqual:[aMemberPolicy tagName]];
  case DBSHARINGMemberPolicyOther:
    return [[self tagName] isEqual:[aMemberPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMemberPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isAnyone]) {
    jsonDict[@".tag"] = @"anyone";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMemberPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"team"]) {
    return [[DBSHARINGMemberPolicy alloc] initWithTeam];
  } else if ([tag isEqualToString:@"anyone"]) {
    return [[DBSHARINGMemberPolicy alloc] initWithAnyone];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGMemberPolicy alloc] initWithOther];
  } else {
    return [[DBSHARINGMemberPolicy alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMemberSelector

@synthesize dropboxId = _dropboxId;
@synthesize email = _email;

#pragma mark - Constructors

- (instancetype)initWithDropboxId:(NSString *)dropboxId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberSelectorDropboxId;
    _dropboxId = dropboxId;
  }
  return self;
}

- (instancetype)initWithEmail:(NSString *)email {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberSelectorEmail;
    _email = email;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMemberSelectorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)dropboxId {
  if (![self isDropboxId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGMemberSelectorDropboxId, but was %@.", [self tagName]];
  }
  return _dropboxId;
}

- (NSString *)email {
  if (![self isEmail]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGMemberSelectorEmail, but was %@.", [self tagName]];
  }
  return _email;
}

#pragma mark - Tag state methods

- (BOOL)isDropboxId {
  return _tag == DBSHARINGMemberSelectorDropboxId;
}

- (BOOL)isEmail {
  return _tag == DBSHARINGMemberSelectorEmail;
}

- (BOOL)isOther {
  return _tag == DBSHARINGMemberSelectorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGMemberSelectorDropboxId:
    return @"DBSHARINGMemberSelectorDropboxId";
  case DBSHARINGMemberSelectorEmail:
    return @"DBSHARINGMemberSelectorEmail";
  case DBSHARINGMemberSelectorOther:
    return @"DBSHARINGMemberSelectorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMemberSelectorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMemberSelectorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMemberSelectorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGMemberSelectorDropboxId:
    result = prime * result + [self.dropboxId hash];
    break;
  case DBSHARINGMemberSelectorEmail:
    result = prime * result + [self.email hash];
    break;
  case DBSHARINGMemberSelectorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMemberSelector:other];
}

- (BOOL)isEqualToMemberSelector:(DBSHARINGMemberSelector *)aMemberSelector {
  if (self == aMemberSelector) {
    return YES;
  }
  if (self.tag != aMemberSelector.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGMemberSelectorDropboxId:
    return [self.dropboxId isEqual:aMemberSelector.dropboxId];
  case DBSHARINGMemberSelectorEmail:
    return [self.email isEqual:aMemberSelector.email];
  case DBSHARINGMemberSelectorOther:
    return [[self tagName] isEqual:[aMemberSelector tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMemberSelectorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMemberSelector *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDropboxId]) {
    jsonDict[@"dropbox_id"] = valueObj.dropboxId;
    jsonDict[@".tag"] = @"dropbox_id";
  } else if ([valueObj isEmail]) {
    jsonDict[@"email"] = valueObj.email;
    jsonDict[@".tag"] = @"email";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMemberSelector *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"dropbox_id"]) {
    NSString *dropboxId = valueDict[@"dropbox_id"];
    return [[DBSHARINGMemberSelector alloc] initWithDropboxId:dropboxId];
  } else if ([tag isEqualToString:@"email"]) {
    NSString *email = valueDict[@"email"];
    return [[DBSHARINGMemberSelector alloc] initWithEmail:email];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGMemberSelector alloc] initWithOther];
  } else {
    return [[DBSHARINGMemberSelector alloc] initWithOther];
  }
}

@end

#import "DBSHARINGModifySharedLinkSettingsArgs.h"
#import "DBSHARINGSharedLinkSettings.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGModifySharedLinkSettingsArgs

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                   settings:(DBSHARINGSharedLinkSettings *)settings
           removeExpiration:(NSNumber *)removeExpiration {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](settings);

  self = [super init];
  if (self) {
    _url = url;
    _settings = settings;
    _removeExpiration = removeExpiration ?: @NO;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url settings:(DBSHARINGSharedLinkSettings *)settings {
  return [self initWithUrl:url settings:settings removeExpiration:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGModifySharedLinkSettingsArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGModifySharedLinkSettingsArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGModifySharedLinkSettingsArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.settings hash];
  result = prime * result + [self.removeExpiration hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToModifySharedLinkSettingsArgs:other];
}

- (BOOL)isEqualToModifySharedLinkSettingsArgs:(DBSHARINGModifySharedLinkSettingsArgs *)aModifySharedLinkSettingsArgs {
  if (self == aModifySharedLinkSettingsArgs) {
    return YES;
  }
  if (![self.url isEqual:aModifySharedLinkSettingsArgs.url]) {
    return NO;
  }
  if (![self.settings isEqual:aModifySharedLinkSettingsArgs.settings]) {
    return NO;
  }
  if (![self.removeExpiration isEqual:aModifySharedLinkSettingsArgs.removeExpiration]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGModifySharedLinkSettingsArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGModifySharedLinkSettingsArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"settings"] = [DBSHARINGSharedLinkSettingsSerializer serialize:valueObj.settings];
  jsonDict[@"remove_expiration"] = valueObj.removeExpiration;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGModifySharedLinkSettingsArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  DBSHARINGSharedLinkSettings *settings = [DBSHARINGSharedLinkSettingsSerializer deserialize:valueDict[@"settings"]];
  NSNumber *removeExpiration = valueDict[@"remove_expiration"] ?: @NO;

  return [[DBSHARINGModifySharedLinkSettingsArgs alloc] initWithUrl:url
                                                           settings:settings
                                                   removeExpiration:removeExpiration];
}

@end

#import "DBSHARINGModifySharedLinkSettingsError.h"
#import "DBSHARINGSharedLinkError.h"
#import "DBSHARINGSharedLinkSettingsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGModifySharedLinkSettingsError

@synthesize settingsError = _settingsError;

#pragma mark - Constructors

- (instancetype)initWithSharedLinkNotFound {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound;
  }
  return self;
}

- (instancetype)initWithSharedLinkAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied;
  }
  return self;
}

- (instancetype)initWithUnsupportedLinkType {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorOther;
  }
  return self;
}

- (instancetype)initWithSettingsError:(DBSHARINGSharedLinkSettingsError *)settingsError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorSettingsError;
    _settingsError = settingsError;
  }
  return self;
}

- (instancetype)initWithEmailNotVerified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedLinkSettingsError *)settingsError {
  if (![self isSettingsError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGModifySharedLinkSettingsErrorSettingsError, but was %@.",
                       [self tagName]];
  }
  return _settingsError;
}

#pragma mark - Tag state methods

- (BOOL)isSharedLinkNotFound {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound;
}

- (BOOL)isSharedLinkAccessDenied {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied;
}

- (BOOL)isUnsupportedLinkType {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType;
}

- (BOOL)isOther {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorOther;
}

- (BOOL)isSettingsError {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorSettingsError;
}

- (BOOL)isEmailNotVerified {
  return _tag == DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound:
    return @"DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound";
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied:
    return @"DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied";
  case DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType:
    return @"DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType";
  case DBSHARINGModifySharedLinkSettingsErrorOther:
    return @"DBSHARINGModifySharedLinkSettingsErrorOther";
  case DBSHARINGModifySharedLinkSettingsErrorSettingsError:
    return @"DBSHARINGModifySharedLinkSettingsErrorSettingsError";
  case DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified:
    return @"DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGModifySharedLinkSettingsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGModifySharedLinkSettingsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGModifySharedLinkSettingsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGModifySharedLinkSettingsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGModifySharedLinkSettingsErrorSettingsError:
    result = prime * result + [self.settingsError hash];
    break;
  case DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToModifySharedLinkSettingsError:other];
}

- (BOOL)isEqualToModifySharedLinkSettingsError:
    (DBSHARINGModifySharedLinkSettingsError *)aModifySharedLinkSettingsError {
  if (self == aModifySharedLinkSettingsError) {
    return YES;
  }
  if (self.tag != aModifySharedLinkSettingsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkNotFound:
    return [[self tagName] isEqual:[aModifySharedLinkSettingsError tagName]];
  case DBSHARINGModifySharedLinkSettingsErrorSharedLinkAccessDenied:
    return [[self tagName] isEqual:[aModifySharedLinkSettingsError tagName]];
  case DBSHARINGModifySharedLinkSettingsErrorUnsupportedLinkType:
    return [[self tagName] isEqual:[aModifySharedLinkSettingsError tagName]];
  case DBSHARINGModifySharedLinkSettingsErrorOther:
    return [[self tagName] isEqual:[aModifySharedLinkSettingsError tagName]];
  case DBSHARINGModifySharedLinkSettingsErrorSettingsError:
    return [self.settingsError isEqual:aModifySharedLinkSettingsError.settingsError];
  case DBSHARINGModifySharedLinkSettingsErrorEmailNotVerified:
    return [[self tagName] isEqual:[aModifySharedLinkSettingsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGModifySharedLinkSettingsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGModifySharedLinkSettingsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSharedLinkNotFound]) {
    jsonDict[@".tag"] = @"shared_link_not_found";
  } else if ([valueObj isSharedLinkAccessDenied]) {
    jsonDict[@".tag"] = @"shared_link_access_denied";
  } else if ([valueObj isUnsupportedLinkType]) {
    jsonDict[@".tag"] = @"unsupported_link_type";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSettingsError]) {
    jsonDict[@"settings_error"] =
        [[DBSHARINGSharedLinkSettingsErrorSerializer serialize:valueObj.settingsError] mutableCopy];
    jsonDict[@".tag"] = @"settings_error";
  } else if ([valueObj isEmailNotVerified]) {
    jsonDict[@".tag"] = @"email_not_verified";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGModifySharedLinkSettingsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"shared_link_not_found"]) {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithSharedLinkNotFound];
  } else if ([tag isEqualToString:@"shared_link_access_denied"]) {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithSharedLinkAccessDenied];
  } else if ([tag isEqualToString:@"unsupported_link_type"]) {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithUnsupportedLinkType];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithOther];
  } else if ([tag isEqualToString:@"settings_error"]) {
    DBSHARINGSharedLinkSettingsError *settingsError =
        [DBSHARINGSharedLinkSettingsErrorSerializer deserialize:valueDict[@"settings_error"]];
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithSettingsError:settingsError];
  } else if ([tag isEqualToString:@"email_not_verified"]) {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithEmailNotVerified];
  } else {
    return [[DBSHARINGModifySharedLinkSettingsError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMountFolderArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMountFolderArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMountFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMountFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMountFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMountFolderArg:other];
}

- (BOOL)isEqualToMountFolderArg:(DBSHARINGMountFolderArg *)aMountFolderArg {
  if (self == aMountFolderArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aMountFolderArg.sharedFolderId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMountFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMountFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMountFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];

  return [[DBSHARINGMountFolderArg alloc] initWithSharedFolderId:sharedFolderId];
}

@end

#import "DBSHARINGInsufficientQuotaAmounts.h"
#import "DBSHARINGMountFolderError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGMountFolderError

@synthesize accessError = _accessError;
@synthesize insufficientQuota = _insufficientQuota;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithInsideSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorInsideSharedFolder;
  }
  return self;
}

- (instancetype)initWithInsufficientQuota:(DBSHARINGInsufficientQuotaAmounts *)insufficientQuota {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorInsufficientQuota;
    _insufficientQuota = insufficientQuota;
  }
  return self;
}

- (instancetype)initWithAlreadyMounted {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorAlreadyMounted;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithNotMountable {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorNotMountable;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGMountFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGMountFolderErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGInsufficientQuotaAmounts *)insufficientQuota {
  if (![self isInsufficientQuota]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGMountFolderErrorInsufficientQuota, but was %@.", [self tagName]];
  }
  return _insufficientQuota;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGMountFolderErrorAccessError;
}

- (BOOL)isInsideSharedFolder {
  return _tag == DBSHARINGMountFolderErrorInsideSharedFolder;
}

- (BOOL)isInsufficientQuota {
  return _tag == DBSHARINGMountFolderErrorInsufficientQuota;
}

- (BOOL)isAlreadyMounted {
  return _tag == DBSHARINGMountFolderErrorAlreadyMounted;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGMountFolderErrorNoPermission;
}

- (BOOL)isNotMountable {
  return _tag == DBSHARINGMountFolderErrorNotMountable;
}

- (BOOL)isOther {
  return _tag == DBSHARINGMountFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGMountFolderErrorAccessError:
    return @"DBSHARINGMountFolderErrorAccessError";
  case DBSHARINGMountFolderErrorInsideSharedFolder:
    return @"DBSHARINGMountFolderErrorInsideSharedFolder";
  case DBSHARINGMountFolderErrorInsufficientQuota:
    return @"DBSHARINGMountFolderErrorInsufficientQuota";
  case DBSHARINGMountFolderErrorAlreadyMounted:
    return @"DBSHARINGMountFolderErrorAlreadyMounted";
  case DBSHARINGMountFolderErrorNoPermission:
    return @"DBSHARINGMountFolderErrorNoPermission";
  case DBSHARINGMountFolderErrorNotMountable:
    return @"DBSHARINGMountFolderErrorNotMountable";
  case DBSHARINGMountFolderErrorOther:
    return @"DBSHARINGMountFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGMountFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGMountFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGMountFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGMountFolderErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGMountFolderErrorInsideSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMountFolderErrorInsufficientQuota:
    result = prime * result + [self.insufficientQuota hash];
    break;
  case DBSHARINGMountFolderErrorAlreadyMounted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMountFolderErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMountFolderErrorNotMountable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGMountFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToMountFolderError:other];
}

- (BOOL)isEqualToMountFolderError:(DBSHARINGMountFolderError *)aMountFolderError {
  if (self == aMountFolderError) {
    return YES;
  }
  if (self.tag != aMountFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGMountFolderErrorAccessError:
    return [self.accessError isEqual:aMountFolderError.accessError];
  case DBSHARINGMountFolderErrorInsideSharedFolder:
    return [[self tagName] isEqual:[aMountFolderError tagName]];
  case DBSHARINGMountFolderErrorInsufficientQuota:
    return [self.insufficientQuota isEqual:aMountFolderError.insufficientQuota];
  case DBSHARINGMountFolderErrorAlreadyMounted:
    return [[self tagName] isEqual:[aMountFolderError tagName]];
  case DBSHARINGMountFolderErrorNoPermission:
    return [[self tagName] isEqual:[aMountFolderError tagName]];
  case DBSHARINGMountFolderErrorNotMountable:
    return [[self tagName] isEqual:[aMountFolderError tagName]];
  case DBSHARINGMountFolderErrorOther:
    return [[self tagName] isEqual:[aMountFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGMountFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGMountFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isInsideSharedFolder]) {
    jsonDict[@".tag"] = @"inside_shared_folder";
  } else if ([valueObj isInsufficientQuota]) {
    jsonDict = [[DBSHARINGInsufficientQuotaAmountsSerializer serialize:valueObj.insufficientQuota] mutableCopy];
    jsonDict[@".tag"] = @"insufficient_quota";
  } else if ([valueObj isAlreadyMounted]) {
    jsonDict[@".tag"] = @"already_mounted";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isNotMountable]) {
    jsonDict[@".tag"] = @"not_mountable";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGMountFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGMountFolderError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"inside_shared_folder"]) {
    return [[DBSHARINGMountFolderError alloc] initWithInsideSharedFolder];
  } else if ([tag isEqualToString:@"insufficient_quota"]) {
    DBSHARINGInsufficientQuotaAmounts *insufficientQuota =
        [DBSHARINGInsufficientQuotaAmountsSerializer deserialize:valueDict];
    return [[DBSHARINGMountFolderError alloc] initWithInsufficientQuota:insufficientQuota];
  } else if ([tag isEqualToString:@"already_mounted"]) {
    return [[DBSHARINGMountFolderError alloc] initWithAlreadyMounted];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGMountFolderError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"not_mountable"]) {
    return [[DBSHARINGMountFolderError alloc] initWithNotMountable];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGMountFolderError alloc] initWithOther];
  } else {
    return [[DBSHARINGMountFolderError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGParentFolderAccessInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGParentFolderAccessInfo

#pragma mark - Constructors

- (instancetype)initWithFolderName:(NSString *)folderName
                    sharedFolderId:(NSString *)sharedFolderId
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                              path:(NSString *)path {
  [DBStoneValidators nonnullValidator:nil](folderName);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);
  [DBStoneValidators nonnullValidator:nil](path);

  self = [super init];
  if (self) {
    _folderName = folderName;
    _sharedFolderId = sharedFolderId;
    _permissions = permissions;
    _path = path;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGParentFolderAccessInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGParentFolderAccessInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGParentFolderAccessInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.folderName hash];
  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.permissions hash];
  result = prime * result + [self.path hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToParentFolderAccessInfo:other];
}

- (BOOL)isEqualToParentFolderAccessInfo:(DBSHARINGParentFolderAccessInfo *)aParentFolderAccessInfo {
  if (self == aParentFolderAccessInfo) {
    return YES;
  }
  if (![self.folderName isEqual:aParentFolderAccessInfo.folderName]) {
    return NO;
  }
  if (![self.sharedFolderId isEqual:aParentFolderAccessInfo.sharedFolderId]) {
    return NO;
  }
  if (![self.permissions isEqual:aParentFolderAccessInfo.permissions]) {
    return NO;
  }
  if (![self.path isEqual:aParentFolderAccessInfo.path]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGParentFolderAccessInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGParentFolderAccessInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"folder_name"] = valueObj.folderName;
  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                withBlock:^id(id elem0) {
                                                  return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                }];
  jsonDict[@"path"] = valueObj.path;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGParentFolderAccessInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *folderName = valueDict[@"folder_name"];
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      [DBArraySerializer deserialize:valueDict[@"permissions"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                           }];
  NSString *path = valueDict[@"path"];

  return [[DBSHARINGParentFolderAccessInfo alloc] initWithFolderName:folderName
                                                      sharedFolderId:sharedFolderId
                                                         permissions:permissions
                                                                path:path];
}

@end

#import "DBSHARINGLinkMetadata.h"
#import "DBSHARINGPathLinkMetadata.h"
#import "DBSHARINGVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGPathLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url
                 visibility:(DBSHARINGVisibility *)visibility
                       path:(NSString *)path
                    expires:(NSDate *)expires {
  [DBStoneValidators nonnullValidator:nil](url);
  [DBStoneValidators nonnullValidator:nil](visibility);
  [DBStoneValidators nonnullValidator:nil](path);

  self = [super initWithUrl:url visibility:visibility expires:expires];
  if (self) {
    _path = path;
  }
  return self;
}

- (instancetype)initWithUrl:(NSString *)url visibility:(DBSHARINGVisibility *)visibility path:(NSString *)path {
  return [self initWithUrl:url visibility:visibility path:path expires:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGPathLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGPathLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGPathLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];
  result = prime * result + [self.visibility hash];
  result = prime * result + [self.path hash];
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPathLinkMetadata:other];
}

- (BOOL)isEqualToPathLinkMetadata:(DBSHARINGPathLinkMetadata *)aPathLinkMetadata {
  if (self == aPathLinkMetadata) {
    return YES;
  }
  if (![self.url isEqual:aPathLinkMetadata.url]) {
    return NO;
  }
  if (![self.visibility isEqual:aPathLinkMetadata.visibility]) {
    return NO;
  }
  if (![self.path isEqual:aPathLinkMetadata.path]) {
    return NO;
  }
  if (self.expires) {
    if (![self.expires isEqual:aPathLinkMetadata.expires]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGPathLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGPathLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"visibility"] = [DBSHARINGVisibilitySerializer serialize:valueObj.visibility];
  jsonDict[@"path"] = valueObj.path;
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGPathLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];
  DBSHARINGVisibility *visibility = [DBSHARINGVisibilitySerializer deserialize:valueDict[@"visibility"]];
  NSString *path = valueDict[@"path"];
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;

  return [[DBSHARINGPathLinkMetadata alloc] initWithUrl:url visibility:visibility path:path expires:expires];
}

@end

#import "DBSHARINGPendingUploadMode.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGPendingUploadMode

#pragma mark - Constructors

- (instancetype)initWithFile {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPendingUploadModeFile;
  }
  return self;
}

- (instancetype)initWithFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPendingUploadModeFolder;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFile {
  return _tag == DBSHARINGPendingUploadModeFile;
}

- (BOOL)isFolder {
  return _tag == DBSHARINGPendingUploadModeFolder;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGPendingUploadModeFile:
    return @"DBSHARINGPendingUploadModeFile";
  case DBSHARINGPendingUploadModeFolder:
    return @"DBSHARINGPendingUploadModeFolder";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGPendingUploadModeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGPendingUploadModeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGPendingUploadModeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGPendingUploadModeFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPendingUploadModeFolder:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPendingUploadMode:other];
}

- (BOOL)isEqualToPendingUploadMode:(DBSHARINGPendingUploadMode *)aPendingUploadMode {
  if (self == aPendingUploadMode) {
    return YES;
  }
  if (self.tag != aPendingUploadMode.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGPendingUploadModeFile:
    return [[self tagName] isEqual:[aPendingUploadMode tagName]];
  case DBSHARINGPendingUploadModeFolder:
    return [[self tagName] isEqual:[aPendingUploadMode tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGPendingUploadModeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGPendingUploadMode *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFile]) {
    jsonDict[@".tag"] = @"file";
  } else if ([valueObj isFolder]) {
    jsonDict[@".tag"] = @"folder";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGPendingUploadMode *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"file"]) {
    return [[DBSHARINGPendingUploadMode alloc] initWithFile];
  } else if ([tag isEqualToString:@"folder"]) {
    return [[DBSHARINGPendingUploadMode alloc] initWithFolder];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGInsufficientPlan.h"
#import "DBSHARINGPermissionDeniedReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGPermissionDeniedReason

@synthesize insufficientPlan = _insufficientPlan;

#pragma mark - Constructors

- (instancetype)initWithUserNotSameTeamAsOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner;
  }
  return self;
}

- (instancetype)initWithUserNotAllowedByOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner;
  }
  return self;
}

- (instancetype)initWithTargetIsIndirectMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonTargetIsIndirectMember;
  }
  return self;
}

- (instancetype)initWithTargetIsOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonTargetIsOwner;
  }
  return self;
}

- (instancetype)initWithTargetIsSelf {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonTargetIsSelf;
  }
  return self;
}

- (instancetype)initWithTargetNotActive {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonTargetNotActive;
  }
  return self;
}

- (instancetype)initWithFolderIsLimitedTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder;
  }
  return self;
}

- (instancetype)initWithOwnerNotOnTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonOwnerNotOnTeam;
  }
  return self;
}

- (instancetype)initWithPermissionDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonPermissionDenied;
  }
  return self;
}

- (instancetype)initWithRestrictedByTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonRestrictedByTeam;
  }
  return self;
}

- (instancetype)initWithUserAccountType {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonUserAccountType;
  }
  return self;
}

- (instancetype)initWithUserNotOnTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonUserNotOnTeam;
  }
  return self;
}

- (instancetype)initWithFolderIsInsideSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder;
  }
  return self;
}

- (instancetype)initWithRestrictedByParentFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonRestrictedByParentFolder;
  }
  return self;
}

- (instancetype)initWithInsufficientPlan:(DBSHARINGInsufficientPlan *)insufficientPlan {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonInsufficientPlan;
    _insufficientPlan = insufficientPlan;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGPermissionDeniedReasonOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGInsufficientPlan *)insufficientPlan {
  if (![self isInsufficientPlan]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGPermissionDeniedReasonInsufficientPlan, but was %@.", [self tagName]];
  }
  return _insufficientPlan;
}

#pragma mark - Tag state methods

- (BOOL)isUserNotSameTeamAsOwner {
  return _tag == DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner;
}

- (BOOL)isUserNotAllowedByOwner {
  return _tag == DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner;
}

- (BOOL)isTargetIsIndirectMember {
  return _tag == DBSHARINGPermissionDeniedReasonTargetIsIndirectMember;
}

- (BOOL)isTargetIsOwner {
  return _tag == DBSHARINGPermissionDeniedReasonTargetIsOwner;
}

- (BOOL)isTargetIsSelf {
  return _tag == DBSHARINGPermissionDeniedReasonTargetIsSelf;
}

- (BOOL)isTargetNotActive {
  return _tag == DBSHARINGPermissionDeniedReasonTargetNotActive;
}

- (BOOL)isFolderIsLimitedTeamFolder {
  return _tag == DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder;
}

- (BOOL)isOwnerNotOnTeam {
  return _tag == DBSHARINGPermissionDeniedReasonOwnerNotOnTeam;
}

- (BOOL)isPermissionDenied {
  return _tag == DBSHARINGPermissionDeniedReasonPermissionDenied;
}

- (BOOL)isRestrictedByTeam {
  return _tag == DBSHARINGPermissionDeniedReasonRestrictedByTeam;
}

- (BOOL)isUserAccountType {
  return _tag == DBSHARINGPermissionDeniedReasonUserAccountType;
}

- (BOOL)isUserNotOnTeam {
  return _tag == DBSHARINGPermissionDeniedReasonUserNotOnTeam;
}

- (BOOL)isFolderIsInsideSharedFolder {
  return _tag == DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder;
}

- (BOOL)isRestrictedByParentFolder {
  return _tag == DBSHARINGPermissionDeniedReasonRestrictedByParentFolder;
}

- (BOOL)isInsufficientPlan {
  return _tag == DBSHARINGPermissionDeniedReasonInsufficientPlan;
}

- (BOOL)isOther {
  return _tag == DBSHARINGPermissionDeniedReasonOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner:
    return @"DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner";
  case DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner:
    return @"DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner";
  case DBSHARINGPermissionDeniedReasonTargetIsIndirectMember:
    return @"DBSHARINGPermissionDeniedReasonTargetIsIndirectMember";
  case DBSHARINGPermissionDeniedReasonTargetIsOwner:
    return @"DBSHARINGPermissionDeniedReasonTargetIsOwner";
  case DBSHARINGPermissionDeniedReasonTargetIsSelf:
    return @"DBSHARINGPermissionDeniedReasonTargetIsSelf";
  case DBSHARINGPermissionDeniedReasonTargetNotActive:
    return @"DBSHARINGPermissionDeniedReasonTargetNotActive";
  case DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder:
    return @"DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder";
  case DBSHARINGPermissionDeniedReasonOwnerNotOnTeam:
    return @"DBSHARINGPermissionDeniedReasonOwnerNotOnTeam";
  case DBSHARINGPermissionDeniedReasonPermissionDenied:
    return @"DBSHARINGPermissionDeniedReasonPermissionDenied";
  case DBSHARINGPermissionDeniedReasonRestrictedByTeam:
    return @"DBSHARINGPermissionDeniedReasonRestrictedByTeam";
  case DBSHARINGPermissionDeniedReasonUserAccountType:
    return @"DBSHARINGPermissionDeniedReasonUserAccountType";
  case DBSHARINGPermissionDeniedReasonUserNotOnTeam:
    return @"DBSHARINGPermissionDeniedReasonUserNotOnTeam";
  case DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder:
    return @"DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder";
  case DBSHARINGPermissionDeniedReasonRestrictedByParentFolder:
    return @"DBSHARINGPermissionDeniedReasonRestrictedByParentFolder";
  case DBSHARINGPermissionDeniedReasonInsufficientPlan:
    return @"DBSHARINGPermissionDeniedReasonInsufficientPlan";
  case DBSHARINGPermissionDeniedReasonOther:
    return @"DBSHARINGPermissionDeniedReasonOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGPermissionDeniedReasonSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGPermissionDeniedReasonSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGPermissionDeniedReasonSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonTargetIsIndirectMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonTargetIsOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonTargetIsSelf:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonTargetNotActive:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonOwnerNotOnTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonPermissionDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonRestrictedByTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonUserAccountType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonUserNotOnTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonRestrictedByParentFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGPermissionDeniedReasonInsufficientPlan:
    result = prime * result + [self.insufficientPlan hash];
    break;
  case DBSHARINGPermissionDeniedReasonOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPermissionDeniedReason:other];
}

- (BOOL)isEqualToPermissionDeniedReason:(DBSHARINGPermissionDeniedReason *)aPermissionDeniedReason {
  if (self == aPermissionDeniedReason) {
    return YES;
  }
  if (self.tag != aPermissionDeniedReason.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGPermissionDeniedReasonUserNotSameTeamAsOwner:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonUserNotAllowedByOwner:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonTargetIsIndirectMember:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonTargetIsOwner:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonTargetIsSelf:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonTargetNotActive:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonFolderIsLimitedTeamFolder:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonOwnerNotOnTeam:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonPermissionDenied:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonRestrictedByTeam:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonUserAccountType:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonUserNotOnTeam:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonFolderIsInsideSharedFolder:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonRestrictedByParentFolder:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  case DBSHARINGPermissionDeniedReasonInsufficientPlan:
    return [self.insufficientPlan isEqual:aPermissionDeniedReason.insufficientPlan];
  case DBSHARINGPermissionDeniedReasonOther:
    return [[self tagName] isEqual:[aPermissionDeniedReason tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGPermissionDeniedReasonSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGPermissionDeniedReason *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserNotSameTeamAsOwner]) {
    jsonDict[@".tag"] = @"user_not_same_team_as_owner";
  } else if ([valueObj isUserNotAllowedByOwner]) {
    jsonDict[@".tag"] = @"user_not_allowed_by_owner";
  } else if ([valueObj isTargetIsIndirectMember]) {
    jsonDict[@".tag"] = @"target_is_indirect_member";
  } else if ([valueObj isTargetIsOwner]) {
    jsonDict[@".tag"] = @"target_is_owner";
  } else if ([valueObj isTargetIsSelf]) {
    jsonDict[@".tag"] = @"target_is_self";
  } else if ([valueObj isTargetNotActive]) {
    jsonDict[@".tag"] = @"target_not_active";
  } else if ([valueObj isFolderIsLimitedTeamFolder]) {
    jsonDict[@".tag"] = @"folder_is_limited_team_folder";
  } else if ([valueObj isOwnerNotOnTeam]) {
    jsonDict[@".tag"] = @"owner_not_on_team";
  } else if ([valueObj isPermissionDenied]) {
    jsonDict[@".tag"] = @"permission_denied";
  } else if ([valueObj isRestrictedByTeam]) {
    jsonDict[@".tag"] = @"restricted_by_team";
  } else if ([valueObj isUserAccountType]) {
    jsonDict[@".tag"] = @"user_account_type";
  } else if ([valueObj isUserNotOnTeam]) {
    jsonDict[@".tag"] = @"user_not_on_team";
  } else if ([valueObj isFolderIsInsideSharedFolder]) {
    jsonDict[@".tag"] = @"folder_is_inside_shared_folder";
  } else if ([valueObj isRestrictedByParentFolder]) {
    jsonDict[@".tag"] = @"restricted_by_parent_folder";
  } else if ([valueObj isInsufficientPlan]) {
    jsonDict = [[DBSHARINGInsufficientPlanSerializer serialize:valueObj.insufficientPlan] mutableCopy];
    jsonDict[@".tag"] = @"insufficient_plan";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGPermissionDeniedReason *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_not_same_team_as_owner"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithUserNotSameTeamAsOwner];
  } else if ([tag isEqualToString:@"user_not_allowed_by_owner"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithUserNotAllowedByOwner];
  } else if ([tag isEqualToString:@"target_is_indirect_member"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithTargetIsIndirectMember];
  } else if ([tag isEqualToString:@"target_is_owner"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithTargetIsOwner];
  } else if ([tag isEqualToString:@"target_is_self"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithTargetIsSelf];
  } else if ([tag isEqualToString:@"target_not_active"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithTargetNotActive];
  } else if ([tag isEqualToString:@"folder_is_limited_team_folder"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithFolderIsLimitedTeamFolder];
  } else if ([tag isEqualToString:@"owner_not_on_team"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithOwnerNotOnTeam];
  } else if ([tag isEqualToString:@"permission_denied"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithPermissionDenied];
  } else if ([tag isEqualToString:@"restricted_by_team"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithRestrictedByTeam];
  } else if ([tag isEqualToString:@"user_account_type"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithUserAccountType];
  } else if ([tag isEqualToString:@"user_not_on_team"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithUserNotOnTeam];
  } else if ([tag isEqualToString:@"folder_is_inside_shared_folder"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithFolderIsInsideSharedFolder];
  } else if ([tag isEqualToString:@"restricted_by_parent_folder"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithRestrictedByParentFolder];
  } else if ([tag isEqualToString:@"insufficient_plan"]) {
    DBSHARINGInsufficientPlan *insufficientPlan = [DBSHARINGInsufficientPlanSerializer deserialize:valueDict];
    return [[DBSHARINGPermissionDeniedReason alloc] initWithInsufficientPlan:insufficientPlan];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithOther];
  } else {
    return [[DBSHARINGPermissionDeniedReason alloc] initWithOther];
  }
}

@end

#import "DBSHARINGRelinquishFileMembershipArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRelinquishFileMembershipArg

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);

  self = [super init];
  if (self) {
    _file = file;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRelinquishFileMembershipArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRelinquishFileMembershipArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRelinquishFileMembershipArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelinquishFileMembershipArg:other];
}

- (BOOL)isEqualToRelinquishFileMembershipArg:(DBSHARINGRelinquishFileMembershipArg *)aRelinquishFileMembershipArg {
  if (self == aRelinquishFileMembershipArg) {
    return YES;
  }
  if (![self.file isEqual:aRelinquishFileMembershipArg.file]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRelinquishFileMembershipArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRelinquishFileMembershipArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRelinquishFileMembershipArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];

  return [[DBSHARINGRelinquishFileMembershipArg alloc] initWithFile:file];
}

@end

#import "DBSHARINGRelinquishFileMembershipError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRelinquishFileMembershipError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFileMembershipErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithGroupAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFileMembershipErrorGroupAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFileMembershipErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFileMembershipErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGRelinquishFileMembershipErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGRelinquishFileMembershipErrorAccessError;
}

- (BOOL)isGroupAccess {
  return _tag == DBSHARINGRelinquishFileMembershipErrorGroupAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGRelinquishFileMembershipErrorNoPermission;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRelinquishFileMembershipErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRelinquishFileMembershipErrorAccessError:
    return @"DBSHARINGRelinquishFileMembershipErrorAccessError";
  case DBSHARINGRelinquishFileMembershipErrorGroupAccess:
    return @"DBSHARINGRelinquishFileMembershipErrorGroupAccess";
  case DBSHARINGRelinquishFileMembershipErrorNoPermission:
    return @"DBSHARINGRelinquishFileMembershipErrorNoPermission";
  case DBSHARINGRelinquishFileMembershipErrorOther:
    return @"DBSHARINGRelinquishFileMembershipErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRelinquishFileMembershipErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRelinquishFileMembershipErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRelinquishFileMembershipErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRelinquishFileMembershipErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGRelinquishFileMembershipErrorGroupAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFileMembershipErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFileMembershipErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelinquishFileMembershipError:other];
}

- (BOOL)isEqualToRelinquishFileMembershipError:
    (DBSHARINGRelinquishFileMembershipError *)aRelinquishFileMembershipError {
  if (self == aRelinquishFileMembershipError) {
    return YES;
  }
  if (self.tag != aRelinquishFileMembershipError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRelinquishFileMembershipErrorAccessError:
    return [self.accessError isEqual:aRelinquishFileMembershipError.accessError];
  case DBSHARINGRelinquishFileMembershipErrorGroupAccess:
    return [[self tagName] isEqual:[aRelinquishFileMembershipError tagName]];
  case DBSHARINGRelinquishFileMembershipErrorNoPermission:
    return [[self tagName] isEqual:[aRelinquishFileMembershipError tagName]];
  case DBSHARINGRelinquishFileMembershipErrorOther:
    return [[self tagName] isEqual:[aRelinquishFileMembershipError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRelinquishFileMembershipErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRelinquishFileMembershipError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isGroupAccess]) {
    jsonDict[@".tag"] = @"group_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRelinquishFileMembershipError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGRelinquishFileMembershipError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"group_access"]) {
    return [[DBSHARINGRelinquishFileMembershipError alloc] initWithGroupAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGRelinquishFileMembershipError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRelinquishFileMembershipError alloc] initWithOther];
  } else {
    return [[DBSHARINGRelinquishFileMembershipError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGRelinquishFolderMembershipArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRelinquishFolderMembershipArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId leaveACopy:(NSNumber *)leaveACopy {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _leaveACopy = leaveACopy ?: @NO;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId leaveACopy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRelinquishFolderMembershipArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRelinquishFolderMembershipArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRelinquishFolderMembershipArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.leaveACopy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelinquishFolderMembershipArg:other];
}

- (BOOL)isEqualToRelinquishFolderMembershipArg:
    (DBSHARINGRelinquishFolderMembershipArg *)aRelinquishFolderMembershipArg {
  if (self == aRelinquishFolderMembershipArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aRelinquishFolderMembershipArg.sharedFolderId]) {
    return NO;
  }
  if (![self.leaveACopy isEqual:aRelinquishFolderMembershipArg.leaveACopy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRelinquishFolderMembershipArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRelinquishFolderMembershipArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"leave_a_copy"] = valueObj.leaveACopy;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRelinquishFolderMembershipArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSNumber *leaveACopy = valueDict[@"leave_a_copy"] ?: @NO;

  return [[DBSHARINGRelinquishFolderMembershipArg alloc] initWithSharedFolderId:sharedFolderId leaveACopy:leaveACopy];
}

@end

#import "DBSHARINGRelinquishFolderMembershipError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRelinquishFolderMembershipError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithFolderOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorFolderOwner;
  }
  return self;
}

- (instancetype)initWithMounted {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorMounted;
  }
  return self;
}

- (instancetype)initWithGroupAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorGroupAccess;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithNoExplicitAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRelinquishFolderMembershipErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGRelinquishFolderMembershipErrorAccessError, but was %@.",
                       [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorAccessError;
}

- (BOOL)isFolderOwner {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorFolderOwner;
}

- (BOOL)isMounted {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorMounted;
}

- (BOOL)isGroupAccess {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorGroupAccess;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorTeamFolder;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorNoPermission;
}

- (BOOL)isNoExplicitAccess {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRelinquishFolderMembershipErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRelinquishFolderMembershipErrorAccessError:
    return @"DBSHARINGRelinquishFolderMembershipErrorAccessError";
  case DBSHARINGRelinquishFolderMembershipErrorFolderOwner:
    return @"DBSHARINGRelinquishFolderMembershipErrorFolderOwner";
  case DBSHARINGRelinquishFolderMembershipErrorMounted:
    return @"DBSHARINGRelinquishFolderMembershipErrorMounted";
  case DBSHARINGRelinquishFolderMembershipErrorGroupAccess:
    return @"DBSHARINGRelinquishFolderMembershipErrorGroupAccess";
  case DBSHARINGRelinquishFolderMembershipErrorTeamFolder:
    return @"DBSHARINGRelinquishFolderMembershipErrorTeamFolder";
  case DBSHARINGRelinquishFolderMembershipErrorNoPermission:
    return @"DBSHARINGRelinquishFolderMembershipErrorNoPermission";
  case DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess:
    return @"DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess";
  case DBSHARINGRelinquishFolderMembershipErrorOther:
    return @"DBSHARINGRelinquishFolderMembershipErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRelinquishFolderMembershipErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRelinquishFolderMembershipErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRelinquishFolderMembershipErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRelinquishFolderMembershipErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorFolderOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorMounted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorGroupAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRelinquishFolderMembershipErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRelinquishFolderMembershipError:other];
}

- (BOOL)isEqualToRelinquishFolderMembershipError:
    (DBSHARINGRelinquishFolderMembershipError *)aRelinquishFolderMembershipError {
  if (self == aRelinquishFolderMembershipError) {
    return YES;
  }
  if (self.tag != aRelinquishFolderMembershipError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRelinquishFolderMembershipErrorAccessError:
    return [self.accessError isEqual:aRelinquishFolderMembershipError.accessError];
  case DBSHARINGRelinquishFolderMembershipErrorFolderOwner:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorMounted:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorGroupAccess:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorTeamFolder:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorNoPermission:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorNoExplicitAccess:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  case DBSHARINGRelinquishFolderMembershipErrorOther:
    return [[self tagName] isEqual:[aRelinquishFolderMembershipError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRelinquishFolderMembershipErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRelinquishFolderMembershipError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isFolderOwner]) {
    jsonDict[@".tag"] = @"folder_owner";
  } else if ([valueObj isMounted]) {
    jsonDict[@".tag"] = @"mounted";
  } else if ([valueObj isGroupAccess]) {
    jsonDict[@".tag"] = @"group_access";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isNoExplicitAccess]) {
    jsonDict[@".tag"] = @"no_explicit_access";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRelinquishFolderMembershipError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"folder_owner"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithFolderOwner];
  } else if ([tag isEqualToString:@"mounted"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithMounted];
  } else if ([tag isEqualToString:@"group_access"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithGroupAccess];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"no_explicit_access"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithNoExplicitAccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithOther];
  } else {
    return [[DBSHARINGRelinquishFolderMembershipError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberSelector.h"
#import "DBSHARINGRemoveFileMemberArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRemoveFileMemberArg

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file member:(DBSHARINGMemberSelector *)member {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators nonnullValidator:nil](member);

  self = [super init];
  if (self) {
    _file = file;
    _member = member;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRemoveFileMemberArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRemoveFileMemberArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRemoveFileMemberArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.member hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveFileMemberArg:other];
}

- (BOOL)isEqualToRemoveFileMemberArg:(DBSHARINGRemoveFileMemberArg *)aRemoveFileMemberArg {
  if (self == aRemoveFileMemberArg) {
    return YES;
  }
  if (![self.file isEqual:aRemoveFileMemberArg.file]) {
    return NO;
  }
  if (![self.member isEqual:aRemoveFileMemberArg.member]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRemoveFileMemberArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveFileMemberArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRemoveFileMemberArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];

  return [[DBSHARINGRemoveFileMemberArg alloc] initWithFile:file member:member];
}

@end

#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBSHARINGRemoveFileMemberError.h"
#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRemoveFileMemberError

@synthesize userError = _userError;
@synthesize accessError = _accessError;
@synthesize noExplicitAccess = _noExplicitAccess;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFileMemberErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFileMemberErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithNoExplicitAccess:(DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFileMemberErrorNoExplicitAccess;
    _noExplicitAccess = noExplicitAccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFileMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGRemoveFileMemberErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGRemoveFileMemberErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  if (![self isNoExplicitAccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGRemoveFileMemberErrorNoExplicitAccess, but was %@.", [self tagName]];
  }
  return _noExplicitAccess;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGRemoveFileMemberErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGRemoveFileMemberErrorAccessError;
}

- (BOOL)isNoExplicitAccess {
  return _tag == DBSHARINGRemoveFileMemberErrorNoExplicitAccess;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRemoveFileMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRemoveFileMemberErrorUserError:
    return @"DBSHARINGRemoveFileMemberErrorUserError";
  case DBSHARINGRemoveFileMemberErrorAccessError:
    return @"DBSHARINGRemoveFileMemberErrorAccessError";
  case DBSHARINGRemoveFileMemberErrorNoExplicitAccess:
    return @"DBSHARINGRemoveFileMemberErrorNoExplicitAccess";
  case DBSHARINGRemoveFileMemberErrorOther:
    return @"DBSHARINGRemoveFileMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRemoveFileMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRemoveFileMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRemoveFileMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRemoveFileMemberErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGRemoveFileMemberErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGRemoveFileMemberErrorNoExplicitAccess:
    result = prime * result + [self.noExplicitAccess hash];
    break;
  case DBSHARINGRemoveFileMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveFileMemberError:other];
}

- (BOOL)isEqualToRemoveFileMemberError:(DBSHARINGRemoveFileMemberError *)aRemoveFileMemberError {
  if (self == aRemoveFileMemberError) {
    return YES;
  }
  if (self.tag != aRemoveFileMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRemoveFileMemberErrorUserError:
    return [self.userError isEqual:aRemoveFileMemberError.userError];
  case DBSHARINGRemoveFileMemberErrorAccessError:
    return [self.accessError isEqual:aRemoveFileMemberError.accessError];
  case DBSHARINGRemoveFileMemberErrorNoExplicitAccess:
    return [self.noExplicitAccess isEqual:aRemoveFileMemberError.noExplicitAccess];
  case DBSHARINGRemoveFileMemberErrorOther:
    return [[self tagName] isEqual:[aRemoveFileMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRemoveFileMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveFileMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isNoExplicitAccess]) {
    jsonDict = [[DBSHARINGMemberAccessLevelResultSerializer serialize:valueObj.noExplicitAccess] mutableCopy];
    jsonDict[@".tag"] = @"no_explicit_access";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRemoveFileMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGRemoveFileMemberError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGRemoveFileMemberError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"no_explicit_access"]) {
    DBSHARINGMemberAccessLevelResult *noExplicitAccess =
        [DBSHARINGMemberAccessLevelResultSerializer deserialize:valueDict];
    return [[DBSHARINGRemoveFileMemberError alloc] initWithNoExplicitAccess:noExplicitAccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRemoveFileMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGRemoveFileMemberError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberSelector.h"
#import "DBSHARINGRemoveFolderMemberArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRemoveFolderMemberArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                                member:(DBSHARINGMemberSelector *)member
                            leaveACopy:(NSNumber *)leaveACopy {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](leaveACopy);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _member = member;
    _leaveACopy = leaveACopy;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRemoveFolderMemberArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRemoveFolderMemberArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRemoveFolderMemberArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.member hash];
  result = prime * result + [self.leaveACopy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveFolderMemberArg:other];
}

- (BOOL)isEqualToRemoveFolderMemberArg:(DBSHARINGRemoveFolderMemberArg *)aRemoveFolderMemberArg {
  if (self == aRemoveFolderMemberArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aRemoveFolderMemberArg.sharedFolderId]) {
    return NO;
  }
  if (![self.member isEqual:aRemoveFolderMemberArg.member]) {
    return NO;
  }
  if (![self.leaveACopy isEqual:aRemoveFolderMemberArg.leaveACopy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRemoveFolderMemberArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveFolderMemberArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"leave_a_copy"] = valueObj.leaveACopy;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRemoveFolderMemberArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  NSNumber *leaveACopy = valueDict[@"leave_a_copy"];

  return [[DBSHARINGRemoveFolderMemberArg alloc] initWithSharedFolderId:sharedFolderId
                                                                 member:member
                                                             leaveACopy:leaveACopy];
}

@end

#import "DBSHARINGRemoveFolderMemberError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGSharedFolderMemberError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRemoveFolderMemberError

@synthesize accessError = _accessError;
@synthesize memberError = _memberError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithMemberError:(DBSHARINGSharedFolderMemberError *)memberError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorMemberError;
    _memberError = memberError;
  }
  return self;
}

- (instancetype)initWithFolderOwner {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorFolderOwner;
  }
  return self;
}

- (instancetype)initWithGroupAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorGroupAccess;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveFolderMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGRemoveFolderMemberErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGSharedFolderMemberError *)memberError {
  if (![self isMemberError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGRemoveFolderMemberErrorMemberError, but was %@.", [self tagName]];
  }
  return _memberError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGRemoveFolderMemberErrorAccessError;
}

- (BOOL)isMemberError {
  return _tag == DBSHARINGRemoveFolderMemberErrorMemberError;
}

- (BOOL)isFolderOwner {
  return _tag == DBSHARINGRemoveFolderMemberErrorFolderOwner;
}

- (BOOL)isGroupAccess {
  return _tag == DBSHARINGRemoveFolderMemberErrorGroupAccess;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGRemoveFolderMemberErrorTeamFolder;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGRemoveFolderMemberErrorNoPermission;
}

- (BOOL)isTooManyFiles {
  return _tag == DBSHARINGRemoveFolderMemberErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRemoveFolderMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRemoveFolderMemberErrorAccessError:
    return @"DBSHARINGRemoveFolderMemberErrorAccessError";
  case DBSHARINGRemoveFolderMemberErrorMemberError:
    return @"DBSHARINGRemoveFolderMemberErrorMemberError";
  case DBSHARINGRemoveFolderMemberErrorFolderOwner:
    return @"DBSHARINGRemoveFolderMemberErrorFolderOwner";
  case DBSHARINGRemoveFolderMemberErrorGroupAccess:
    return @"DBSHARINGRemoveFolderMemberErrorGroupAccess";
  case DBSHARINGRemoveFolderMemberErrorTeamFolder:
    return @"DBSHARINGRemoveFolderMemberErrorTeamFolder";
  case DBSHARINGRemoveFolderMemberErrorNoPermission:
    return @"DBSHARINGRemoveFolderMemberErrorNoPermission";
  case DBSHARINGRemoveFolderMemberErrorTooManyFiles:
    return @"DBSHARINGRemoveFolderMemberErrorTooManyFiles";
  case DBSHARINGRemoveFolderMemberErrorOther:
    return @"DBSHARINGRemoveFolderMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRemoveFolderMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRemoveFolderMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRemoveFolderMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRemoveFolderMemberErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorMemberError:
    result = prime * result + [self.memberError hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorFolderOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorGroupAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveFolderMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveFolderMemberError:other];
}

- (BOOL)isEqualToRemoveFolderMemberError:(DBSHARINGRemoveFolderMemberError *)aRemoveFolderMemberError {
  if (self == aRemoveFolderMemberError) {
    return YES;
  }
  if (self.tag != aRemoveFolderMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRemoveFolderMemberErrorAccessError:
    return [self.accessError isEqual:aRemoveFolderMemberError.accessError];
  case DBSHARINGRemoveFolderMemberErrorMemberError:
    return [self.memberError isEqual:aRemoveFolderMemberError.memberError];
  case DBSHARINGRemoveFolderMemberErrorFolderOwner:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  case DBSHARINGRemoveFolderMemberErrorGroupAccess:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  case DBSHARINGRemoveFolderMemberErrorTeamFolder:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  case DBSHARINGRemoveFolderMemberErrorNoPermission:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  case DBSHARINGRemoveFolderMemberErrorTooManyFiles:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  case DBSHARINGRemoveFolderMemberErrorOther:
    return [[self tagName] isEqual:[aRemoveFolderMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRemoveFolderMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveFolderMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isMemberError]) {
    jsonDict[@"member_error"] =
        [[DBSHARINGSharedFolderMemberErrorSerializer serialize:valueObj.memberError] mutableCopy];
    jsonDict[@".tag"] = @"member_error";
  } else if ([valueObj isFolderOwner]) {
    jsonDict[@".tag"] = @"folder_owner";
  } else if ([valueObj isGroupAccess]) {
    jsonDict[@".tag"] = @"group_access";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRemoveFolderMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"member_error"]) {
    DBSHARINGSharedFolderMemberError *memberError =
        [DBSHARINGSharedFolderMemberErrorSerializer deserialize:valueDict[@"member_error"]];
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithMemberError:memberError];
  } else if ([tag isEqualToString:@"folder_owner"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithFolderOwner];
  } else if ([tag isEqualToString:@"group_access"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithGroupAccess];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGRemoveFolderMemberError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBSHARINGRemoveFolderMemberError.h"
#import "DBSHARINGRemoveMemberJobStatus.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRemoveMemberJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveMemberJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBSHARINGMemberAccessLevelResult *)complete {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveMemberJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBSHARINGRemoveFolderMemberError *)failed {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRemoveMemberJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGMemberAccessLevelResult *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGRemoveMemberJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBSHARINGRemoveFolderMemberError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGRemoveMemberJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBSHARINGRemoveMemberJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBSHARINGRemoveMemberJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBSHARINGRemoveMemberJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRemoveMemberJobStatusInProgress:
    return @"DBSHARINGRemoveMemberJobStatusInProgress";
  case DBSHARINGRemoveMemberJobStatusComplete:
    return @"DBSHARINGRemoveMemberJobStatusComplete";
  case DBSHARINGRemoveMemberJobStatusFailed:
    return @"DBSHARINGRemoveMemberJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRemoveMemberJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRemoveMemberJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRemoveMemberJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRemoveMemberJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRemoveMemberJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBSHARINGRemoveMemberJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemoveMemberJobStatus:other];
}

- (BOOL)isEqualToRemoveMemberJobStatus:(DBSHARINGRemoveMemberJobStatus *)aRemoveMemberJobStatus {
  if (self == aRemoveMemberJobStatus) {
    return YES;
  }
  if (self.tag != aRemoveMemberJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRemoveMemberJobStatusInProgress:
    return [[self tagName] isEqual:[aRemoveMemberJobStatus tagName]];
  case DBSHARINGRemoveMemberJobStatusComplete:
    return [self.complete isEqual:aRemoveMemberJobStatus.complete];
  case DBSHARINGRemoveMemberJobStatusFailed:
    return [self.failed isEqual:aRemoveMemberJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRemoveMemberJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRemoveMemberJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBSHARINGMemberAccessLevelResultSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBSHARINGRemoveFolderMemberErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRemoveMemberJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBSHARINGRemoveMemberJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBSHARINGMemberAccessLevelResult *complete = [DBSHARINGMemberAccessLevelResultSerializer deserialize:valueDict];
    return [[DBSHARINGRemoveMemberJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBSHARINGRemoveFolderMemberError *failed =
        [DBSHARINGRemoveFolderMemberErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBSHARINGRemoveMemberJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGRequestedLinkAccessLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRequestedLinkAccessLevel

#pragma mark - Constructors

- (instancetype)initWithViewer {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedLinkAccessLevelViewer;
  }
  return self;
}

- (instancetype)initWithEditor {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedLinkAccessLevelEditor;
  }
  return self;
}

- (instancetype)initWithMax {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedLinkAccessLevelMax;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedLinkAccessLevelOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isViewer {
  return _tag == DBSHARINGRequestedLinkAccessLevelViewer;
}

- (BOOL)isEditor {
  return _tag == DBSHARINGRequestedLinkAccessLevelEditor;
}

- (BOOL)isMax {
  return _tag == DBSHARINGRequestedLinkAccessLevelMax;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRequestedLinkAccessLevelOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRequestedLinkAccessLevelViewer:
    return @"DBSHARINGRequestedLinkAccessLevelViewer";
  case DBSHARINGRequestedLinkAccessLevelEditor:
    return @"DBSHARINGRequestedLinkAccessLevelEditor";
  case DBSHARINGRequestedLinkAccessLevelMax:
    return @"DBSHARINGRequestedLinkAccessLevelMax";
  case DBSHARINGRequestedLinkAccessLevelOther:
    return @"DBSHARINGRequestedLinkAccessLevelOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRequestedLinkAccessLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRequestedLinkAccessLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRequestedLinkAccessLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRequestedLinkAccessLevelViewer:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRequestedLinkAccessLevelEditor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRequestedLinkAccessLevelMax:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRequestedLinkAccessLevelOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRequestedLinkAccessLevel:other];
}

- (BOOL)isEqualToRequestedLinkAccessLevel:(DBSHARINGRequestedLinkAccessLevel *)aRequestedLinkAccessLevel {
  if (self == aRequestedLinkAccessLevel) {
    return YES;
  }
  if (self.tag != aRequestedLinkAccessLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRequestedLinkAccessLevelViewer:
    return [[self tagName] isEqual:[aRequestedLinkAccessLevel tagName]];
  case DBSHARINGRequestedLinkAccessLevelEditor:
    return [[self tagName] isEqual:[aRequestedLinkAccessLevel tagName]];
  case DBSHARINGRequestedLinkAccessLevelMax:
    return [[self tagName] isEqual:[aRequestedLinkAccessLevel tagName]];
  case DBSHARINGRequestedLinkAccessLevelOther:
    return [[self tagName] isEqual:[aRequestedLinkAccessLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRequestedLinkAccessLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRequestedLinkAccessLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isViewer]) {
    jsonDict[@".tag"] = @"viewer";
  } else if ([valueObj isEditor]) {
    jsonDict[@".tag"] = @"editor";
  } else if ([valueObj isMax]) {
    jsonDict[@".tag"] = @"max";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRequestedLinkAccessLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"viewer"]) {
    return [[DBSHARINGRequestedLinkAccessLevel alloc] initWithViewer];
  } else if ([tag isEqualToString:@"editor"]) {
    return [[DBSHARINGRequestedLinkAccessLevel alloc] initWithEditor];
  } else if ([tag isEqualToString:@"max"]) {
    return [[DBSHARINGRequestedLinkAccessLevel alloc] initWithMax];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRequestedLinkAccessLevel alloc] initWithOther];
  } else {
    return [[DBSHARINGRequestedLinkAccessLevel alloc] initWithOther];
  }
}

@end

#import "DBSHARINGRequestedVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRequestedVisibility

#pragma mark - Constructors

- (instancetype)initWithPublic {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedVisibilityPublic;
  }
  return self;
}

- (instancetype)initWithTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedVisibilityTeamOnly;
  }
  return self;
}

- (instancetype)initWithPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRequestedVisibilityPassword;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPublic {
  return _tag == DBSHARINGRequestedVisibilityPublic;
}

- (BOOL)isTeamOnly {
  return _tag == DBSHARINGRequestedVisibilityTeamOnly;
}

- (BOOL)isPassword {
  return _tag == DBSHARINGRequestedVisibilityPassword;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRequestedVisibilityPublic:
    return @"DBSHARINGRequestedVisibilityPublic";
  case DBSHARINGRequestedVisibilityTeamOnly:
    return @"DBSHARINGRequestedVisibilityTeamOnly";
  case DBSHARINGRequestedVisibilityPassword:
    return @"DBSHARINGRequestedVisibilityPassword";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRequestedVisibilitySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRequestedVisibilitySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRequestedVisibilitySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRequestedVisibilityPublic:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRequestedVisibilityTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRequestedVisibilityPassword:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRequestedVisibility:other];
}

- (BOOL)isEqualToRequestedVisibility:(DBSHARINGRequestedVisibility *)aRequestedVisibility {
  if (self == aRequestedVisibility) {
    return YES;
  }
  if (self.tag != aRequestedVisibility.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRequestedVisibilityPublic:
    return [[self tagName] isEqual:[aRequestedVisibility tagName]];
  case DBSHARINGRequestedVisibilityTeamOnly:
    return [[self tagName] isEqual:[aRequestedVisibility tagName]];
  case DBSHARINGRequestedVisibilityPassword:
    return [[self tagName] isEqual:[aRequestedVisibility tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRequestedVisibilitySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRequestedVisibility *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPublic]) {
    jsonDict[@".tag"] = @"public";
  } else if ([valueObj isTeamOnly]) {
    jsonDict[@".tag"] = @"team_only";
  } else if ([valueObj isPassword]) {
    jsonDict[@".tag"] = @"password";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRequestedVisibility *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"public"]) {
    return [[DBSHARINGRequestedVisibility alloc] initWithPublic];
  } else if ([tag isEqualToString:@"team_only"]) {
    return [[DBSHARINGRequestedVisibility alloc] initWithTeamOnly];
  } else if ([tag isEqualToString:@"password"]) {
    return [[DBSHARINGRequestedVisibility alloc] initWithPassword];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGRequestedVisibility.h"
#import "DBSHARINGResolvedVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGResolvedVisibility

#pragma mark - Constructors

- (instancetype)initWithPublic {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilityPublic;
  }
  return self;
}

- (instancetype)initWithTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilityTeamOnly;
  }
  return self;
}

- (instancetype)initWithPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilityPassword;
  }
  return self;
}

- (instancetype)initWithTeamAndPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilityTeamAndPassword;
  }
  return self;
}

- (instancetype)initWithSharedFolderOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilitySharedFolderOnly;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGResolvedVisibilityOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPublic {
  return _tag == DBSHARINGResolvedVisibilityPublic;
}

- (BOOL)isTeamOnly {
  return _tag == DBSHARINGResolvedVisibilityTeamOnly;
}

- (BOOL)isPassword {
  return _tag == DBSHARINGResolvedVisibilityPassword;
}

- (BOOL)isTeamAndPassword {
  return _tag == DBSHARINGResolvedVisibilityTeamAndPassword;
}

- (BOOL)isSharedFolderOnly {
  return _tag == DBSHARINGResolvedVisibilitySharedFolderOnly;
}

- (BOOL)isOther {
  return _tag == DBSHARINGResolvedVisibilityOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGResolvedVisibilityPublic:
    return @"DBSHARINGResolvedVisibilityPublic";
  case DBSHARINGResolvedVisibilityTeamOnly:
    return @"DBSHARINGResolvedVisibilityTeamOnly";
  case DBSHARINGResolvedVisibilityPassword:
    return @"DBSHARINGResolvedVisibilityPassword";
  case DBSHARINGResolvedVisibilityTeamAndPassword:
    return @"DBSHARINGResolvedVisibilityTeamAndPassword";
  case DBSHARINGResolvedVisibilitySharedFolderOnly:
    return @"DBSHARINGResolvedVisibilitySharedFolderOnly";
  case DBSHARINGResolvedVisibilityOther:
    return @"DBSHARINGResolvedVisibilityOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGResolvedVisibilitySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGResolvedVisibilitySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGResolvedVisibilitySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGResolvedVisibilityPublic:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGResolvedVisibilityTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGResolvedVisibilityPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGResolvedVisibilityTeamAndPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGResolvedVisibilitySharedFolderOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGResolvedVisibilityOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToResolvedVisibility:other];
}

- (BOOL)isEqualToResolvedVisibility:(DBSHARINGResolvedVisibility *)aResolvedVisibility {
  if (self == aResolvedVisibility) {
    return YES;
  }
  if (self.tag != aResolvedVisibility.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGResolvedVisibilityPublic:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  case DBSHARINGResolvedVisibilityTeamOnly:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  case DBSHARINGResolvedVisibilityPassword:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  case DBSHARINGResolvedVisibilityTeamAndPassword:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  case DBSHARINGResolvedVisibilitySharedFolderOnly:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  case DBSHARINGResolvedVisibilityOther:
    return [[self tagName] isEqual:[aResolvedVisibility tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGResolvedVisibilitySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGResolvedVisibility *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPublic]) {
    jsonDict[@".tag"] = @"public";
  } else if ([valueObj isTeamOnly]) {
    jsonDict[@".tag"] = @"team_only";
  } else if ([valueObj isPassword]) {
    jsonDict[@".tag"] = @"password";
  } else if ([valueObj isTeamAndPassword]) {
    jsonDict[@".tag"] = @"team_and_password";
  } else if ([valueObj isSharedFolderOnly]) {
    jsonDict[@".tag"] = @"shared_folder_only";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGResolvedVisibility *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"public"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithPublic];
  } else if ([tag isEqualToString:@"team_only"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithTeamOnly];
  } else if ([tag isEqualToString:@"password"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithPassword];
  } else if ([tag isEqualToString:@"team_and_password"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithTeamAndPassword];
  } else if ([tag isEqualToString:@"shared_folder_only"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithSharedFolderOnly];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGResolvedVisibility alloc] initWithOther];
  } else {
    return [[DBSHARINGResolvedVisibility alloc] initWithOther];
  }
}

@end

#import "DBSHARINGRevokeSharedLinkArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRevokeSharedLinkArg

#pragma mark - Constructors

- (instancetype)initWithUrl:(NSString *)url {
  [DBStoneValidators nonnullValidator:nil](url);

  self = [super init];
  if (self) {
    _url = url;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRevokeSharedLinkArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRevokeSharedLinkArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRevokeSharedLinkArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.url hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeSharedLinkArg:other];
}

- (BOOL)isEqualToRevokeSharedLinkArg:(DBSHARINGRevokeSharedLinkArg *)aRevokeSharedLinkArg {
  if (self == aRevokeSharedLinkArg) {
    return YES;
  }
  if (![self.url isEqual:aRevokeSharedLinkArg.url]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRevokeSharedLinkArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRevokeSharedLinkArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"url"] = valueObj.url;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRevokeSharedLinkArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *url = valueDict[@"url"];

  return [[DBSHARINGRevokeSharedLinkArg alloc] initWithUrl:url];
}

@end

#import "DBSHARINGRevokeSharedLinkError.h"
#import "DBSHARINGSharedLinkError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGRevokeSharedLinkError

#pragma mark - Constructors

- (instancetype)initWithSharedLinkNotFound {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound;
  }
  return self;
}

- (instancetype)initWithSharedLinkAccessDenied {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied;
  }
  return self;
}

- (instancetype)initWithUnsupportedLinkType {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRevokeSharedLinkErrorOther;
  }
  return self;
}

- (instancetype)initWithSharedLinkMalformed {
  self = [super init];
  if (self) {
    _tag = DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSharedLinkNotFound {
  return _tag == DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound;
}

- (BOOL)isSharedLinkAccessDenied {
  return _tag == DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied;
}

- (BOOL)isUnsupportedLinkType {
  return _tag == DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType;
}

- (BOOL)isOther {
  return _tag == DBSHARINGRevokeSharedLinkErrorOther;
}

- (BOOL)isSharedLinkMalformed {
  return _tag == DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound:
    return @"DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound";
  case DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied:
    return @"DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied";
  case DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType:
    return @"DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType";
  case DBSHARINGRevokeSharedLinkErrorOther:
    return @"DBSHARINGRevokeSharedLinkErrorOther";
  case DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed:
    return @"DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGRevokeSharedLinkErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGRevokeSharedLinkErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGRevokeSharedLinkErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRevokeSharedLinkErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRevokeSharedLinkError:other];
}

- (BOOL)isEqualToRevokeSharedLinkError:(DBSHARINGRevokeSharedLinkError *)aRevokeSharedLinkError {
  if (self == aRevokeSharedLinkError) {
    return YES;
  }
  if (self.tag != aRevokeSharedLinkError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGRevokeSharedLinkErrorSharedLinkNotFound:
    return [[self tagName] isEqual:[aRevokeSharedLinkError tagName]];
  case DBSHARINGRevokeSharedLinkErrorSharedLinkAccessDenied:
    return [[self tagName] isEqual:[aRevokeSharedLinkError tagName]];
  case DBSHARINGRevokeSharedLinkErrorUnsupportedLinkType:
    return [[self tagName] isEqual:[aRevokeSharedLinkError tagName]];
  case DBSHARINGRevokeSharedLinkErrorOther:
    return [[self tagName] isEqual:[aRevokeSharedLinkError tagName]];
  case DBSHARINGRevokeSharedLinkErrorSharedLinkMalformed:
    return [[self tagName] isEqual:[aRevokeSharedLinkError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGRevokeSharedLinkErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGRevokeSharedLinkError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSharedLinkNotFound]) {
    jsonDict[@".tag"] = @"shared_link_not_found";
  } else if ([valueObj isSharedLinkAccessDenied]) {
    jsonDict[@".tag"] = @"shared_link_access_denied";
  } else if ([valueObj isUnsupportedLinkType]) {
    jsonDict[@".tag"] = @"unsupported_link_type";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isSharedLinkMalformed]) {
    jsonDict[@".tag"] = @"shared_link_malformed";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGRevokeSharedLinkError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"shared_link_not_found"]) {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithSharedLinkNotFound];
  } else if ([tag isEqualToString:@"shared_link_access_denied"]) {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithSharedLinkAccessDenied];
  } else if ([tag isEqualToString:@"unsupported_link_type"]) {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithUnsupportedLinkType];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithOther];
  } else if ([tag isEqualToString:@"shared_link_malformed"]) {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithSharedLinkMalformed];
  } else {
    return [[DBSHARINGRevokeSharedLinkError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessInheritance.h"
#import "DBSHARINGSetAccessInheritanceArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSetAccessInheritanceArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                     accessInheritance:(DBSHARINGAccessInheritance *)accessInheritance {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super init];
  if (self) {
    _accessInheritance = accessInheritance ?: [[DBSHARINGAccessInheritance alloc] initWithInherit];
    _sharedFolderId = sharedFolderId;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId accessInheritance:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSetAccessInheritanceArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSetAccessInheritanceArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSetAccessInheritanceArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.accessInheritance hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetAccessInheritanceArg:other];
}

- (BOOL)isEqualToSetAccessInheritanceArg:(DBSHARINGSetAccessInheritanceArg *)aSetAccessInheritanceArg {
  if (self == aSetAccessInheritanceArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aSetAccessInheritanceArg.sharedFolderId]) {
    return NO;
  }
  if (![self.accessInheritance isEqual:aSetAccessInheritanceArg.accessInheritance]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSetAccessInheritanceArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSetAccessInheritanceArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"access_inheritance"] = [DBSHARINGAccessInheritanceSerializer serialize:valueObj.accessInheritance];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSetAccessInheritanceArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  DBSHARINGAccessInheritance *accessInheritance =
      valueDict[@"access_inheritance"]
          ? [DBSHARINGAccessInheritanceSerializer deserialize:valueDict[@"access_inheritance"]]
          : [[DBSHARINGAccessInheritance alloc] initWithInherit];

  return [[DBSHARINGSetAccessInheritanceArg alloc] initWithSharedFolderId:sharedFolderId
                                                        accessInheritance:accessInheritance];
}

@end

#import "DBSHARINGSetAccessInheritanceError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSetAccessInheritanceError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSetAccessInheritanceErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSetAccessInheritanceErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSetAccessInheritanceErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGSetAccessInheritanceErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGSetAccessInheritanceErrorAccessError;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGSetAccessInheritanceErrorNoPermission;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSetAccessInheritanceErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSetAccessInheritanceErrorAccessError:
    return @"DBSHARINGSetAccessInheritanceErrorAccessError";
  case DBSHARINGSetAccessInheritanceErrorNoPermission:
    return @"DBSHARINGSetAccessInheritanceErrorNoPermission";
  case DBSHARINGSetAccessInheritanceErrorOther:
    return @"DBSHARINGSetAccessInheritanceErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSetAccessInheritanceErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSetAccessInheritanceErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSetAccessInheritanceErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSetAccessInheritanceErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGSetAccessInheritanceErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSetAccessInheritanceErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetAccessInheritanceError:other];
}

- (BOOL)isEqualToSetAccessInheritanceError:(DBSHARINGSetAccessInheritanceError *)aSetAccessInheritanceError {
  if (self == aSetAccessInheritanceError) {
    return YES;
  }
  if (self.tag != aSetAccessInheritanceError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSetAccessInheritanceErrorAccessError:
    return [self.accessError isEqual:aSetAccessInheritanceError.accessError];
  case DBSHARINGSetAccessInheritanceErrorNoPermission:
    return [[self tagName] isEqual:[aSetAccessInheritanceError tagName]];
  case DBSHARINGSetAccessInheritanceErrorOther:
    return [[self tagName] isEqual:[aSetAccessInheritanceError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSetAccessInheritanceErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSetAccessInheritanceError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSetAccessInheritanceError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGSetAccessInheritanceError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGSetAccessInheritanceError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSetAccessInheritanceError alloc] initWithOther];
  } else {
    return [[DBSHARINGSetAccessInheritanceError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessInheritance.h"
#import "DBSHARINGAclUpdatePolicy.h"
#import "DBSHARINGMemberPolicy.h"
#import "DBSHARINGShareFolderArgBase.h"
#import "DBSHARINGSharedLinkPolicy.h"
#import "DBSHARINGViewerInfoPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderArgBase

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
             aclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                  forceAsync:(NSNumber *)forceAsync
                memberPolicy:(DBSHARINGMemberPolicy *)memberPolicy
            sharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
            viewerInfoPolicy:(DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
           accessInheritance:(DBSHARINGAccessInheritance *)accessInheritance {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:nil
                                                                 pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)"]](path);

  self = [super init];
  if (self) {
    _aclUpdatePolicy = aclUpdatePolicy;
    _forceAsync = forceAsync ?: @NO;
    _memberPolicy = memberPolicy;
    _path = path;
    _sharedLinkPolicy = sharedLinkPolicy;
    _viewerInfoPolicy = viewerInfoPolicy;
    _accessInheritance = accessInheritance ?: [[DBSHARINGAccessInheritance alloc] initWithInherit];
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
            aclUpdatePolicy:nil
                 forceAsync:nil
               memberPolicy:nil
           sharedLinkPolicy:nil
           viewerInfoPolicy:nil
          accessInheritance:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderArgBaseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderArgBaseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderArgBaseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.aclUpdatePolicy != nil) {
    result = prime * result + [self.aclUpdatePolicy hash];
  }
  result = prime * result + [self.forceAsync hash];
  if (self.memberPolicy != nil) {
    result = prime * result + [self.memberPolicy hash];
  }
  if (self.sharedLinkPolicy != nil) {
    result = prime * result + [self.sharedLinkPolicy hash];
  }
  if (self.viewerInfoPolicy != nil) {
    result = prime * result + [self.viewerInfoPolicy hash];
  }
  result = prime * result + [self.accessInheritance hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderArgBase:other];
}

- (BOOL)isEqualToShareFolderArgBase:(DBSHARINGShareFolderArgBase *)aShareFolderArgBase {
  if (self == aShareFolderArgBase) {
    return YES;
  }
  if (![self.path isEqual:aShareFolderArgBase.path]) {
    return NO;
  }
  if (self.aclUpdatePolicy) {
    if (![self.aclUpdatePolicy isEqual:aShareFolderArgBase.aclUpdatePolicy]) {
      return NO;
    }
  }
  if (![self.forceAsync isEqual:aShareFolderArgBase.forceAsync]) {
    return NO;
  }
  if (self.memberPolicy) {
    if (![self.memberPolicy isEqual:aShareFolderArgBase.memberPolicy]) {
      return NO;
    }
  }
  if (self.sharedLinkPolicy) {
    if (![self.sharedLinkPolicy isEqual:aShareFolderArgBase.sharedLinkPolicy]) {
      return NO;
    }
  }
  if (self.viewerInfoPolicy) {
    if (![self.viewerInfoPolicy isEqual:aShareFolderArgBase.viewerInfoPolicy]) {
      return NO;
    }
  }
  if (![self.accessInheritance isEqual:aShareFolderArgBase.accessInheritance]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderArgBaseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderArgBase *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.aclUpdatePolicy) {
    jsonDict[@"acl_update_policy"] = [DBSHARINGAclUpdatePolicySerializer serialize:valueObj.aclUpdatePolicy];
  }
  jsonDict[@"force_async"] = valueObj.forceAsync;
  if (valueObj.memberPolicy) {
    jsonDict[@"member_policy"] = [DBSHARINGMemberPolicySerializer serialize:valueObj.memberPolicy];
  }
  if (valueObj.sharedLinkPolicy) {
    jsonDict[@"shared_link_policy"] = [DBSHARINGSharedLinkPolicySerializer serialize:valueObj.sharedLinkPolicy];
  }
  if (valueObj.viewerInfoPolicy) {
    jsonDict[@"viewer_info_policy"] = [DBSHARINGViewerInfoPolicySerializer serialize:valueObj.viewerInfoPolicy];
  }
  jsonDict[@"access_inheritance"] = [DBSHARINGAccessInheritanceSerializer serialize:valueObj.accessInheritance];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderArgBase *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBSHARINGAclUpdatePolicy *aclUpdatePolicy =
      valueDict[@"acl_update_policy"] ? [DBSHARINGAclUpdatePolicySerializer deserialize:valueDict[@"acl_update_policy"]]
                                      : nil;
  NSNumber *forceAsync = valueDict[@"force_async"] ?: @NO;
  DBSHARINGMemberPolicy *memberPolicy =
      valueDict[@"member_policy"] ? [DBSHARINGMemberPolicySerializer deserialize:valueDict[@"member_policy"]] : nil;
  DBSHARINGSharedLinkPolicy *sharedLinkPolicy =
      valueDict[@"shared_link_policy"]
          ? [DBSHARINGSharedLinkPolicySerializer deserialize:valueDict[@"shared_link_policy"]]
          : nil;
  DBSHARINGViewerInfoPolicy *viewerInfoPolicy =
      valueDict[@"viewer_info_policy"]
          ? [DBSHARINGViewerInfoPolicySerializer deserialize:valueDict[@"viewer_info_policy"]]
          : nil;
  DBSHARINGAccessInheritance *accessInheritance =
      valueDict[@"access_inheritance"]
          ? [DBSHARINGAccessInheritanceSerializer deserialize:valueDict[@"access_inheritance"]]
          : [[DBSHARINGAccessInheritance alloc] initWithInherit];

  return [[DBSHARINGShareFolderArgBase alloc] initWithPath:path
                                           aclUpdatePolicy:aclUpdatePolicy
                                                forceAsync:forceAsync
                                              memberPolicy:memberPolicy
                                          sharedLinkPolicy:sharedLinkPolicy
                                          viewerInfoPolicy:viewerInfoPolicy
                                         accessInheritance:accessInheritance];
}

@end

#import "DBSHARINGAccessInheritance.h"
#import "DBSHARINGAclUpdatePolicy.h"
#import "DBSHARINGFolderAction.h"
#import "DBSHARINGLinkSettings.h"
#import "DBSHARINGMemberPolicy.h"
#import "DBSHARINGShareFolderArg.h"
#import "DBSHARINGShareFolderArgBase.h"
#import "DBSHARINGSharedLinkPolicy.h"
#import "DBSHARINGViewerInfoPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderArg

#pragma mark - Constructors

- (instancetype)initWithPath:(NSString *)path
             aclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                  forceAsync:(NSNumber *)forceAsync
                memberPolicy:(DBSHARINGMemberPolicy *)memberPolicy
            sharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
            viewerInfoPolicy:(DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
           accessInheritance:(DBSHARINGAccessInheritance *)accessInheritance
                     actions:(NSArray<DBSHARINGFolderAction *> *)actions
                linkSettings:(DBSHARINGLinkSettings *)linkSettings {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:nil
                                                               maxLength:nil
                                                                 pattern:@"(/(.|[\\r\\n])*)|(ns:[0-9]+(/.*)?)"]](path);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super initWithPath:path
             aclUpdatePolicy:aclUpdatePolicy
                  forceAsync:forceAsync
                memberPolicy:memberPolicy
            sharedLinkPolicy:sharedLinkPolicy
            viewerInfoPolicy:viewerInfoPolicy
           accessInheritance:accessInheritance];
  if (self) {
    _actions = actions;
    _linkSettings = linkSettings;
  }
  return self;
}

- (instancetype)initWithPath:(NSString *)path {
  return [self initWithPath:path
            aclUpdatePolicy:nil
                 forceAsync:nil
               memberPolicy:nil
           sharedLinkPolicy:nil
           viewerInfoPolicy:nil
          accessInheritance:nil
                    actions:nil
               linkSettings:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.path hash];
  if (self.aclUpdatePolicy != nil) {
    result = prime * result + [self.aclUpdatePolicy hash];
  }
  result = prime * result + [self.forceAsync hash];
  if (self.memberPolicy != nil) {
    result = prime * result + [self.memberPolicy hash];
  }
  if (self.sharedLinkPolicy != nil) {
    result = prime * result + [self.sharedLinkPolicy hash];
  }
  if (self.viewerInfoPolicy != nil) {
    result = prime * result + [self.viewerInfoPolicy hash];
  }
  result = prime * result + [self.accessInheritance hash];
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }
  if (self.linkSettings != nil) {
    result = prime * result + [self.linkSettings hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderArg:other];
}

- (BOOL)isEqualToShareFolderArg:(DBSHARINGShareFolderArg *)aShareFolderArg {
  if (self == aShareFolderArg) {
    return YES;
  }
  if (![self.path isEqual:aShareFolderArg.path]) {
    return NO;
  }
  if (self.aclUpdatePolicy) {
    if (![self.aclUpdatePolicy isEqual:aShareFolderArg.aclUpdatePolicy]) {
      return NO;
    }
  }
  if (![self.forceAsync isEqual:aShareFolderArg.forceAsync]) {
    return NO;
  }
  if (self.memberPolicy) {
    if (![self.memberPolicy isEqual:aShareFolderArg.memberPolicy]) {
      return NO;
    }
  }
  if (self.sharedLinkPolicy) {
    if (![self.sharedLinkPolicy isEqual:aShareFolderArg.sharedLinkPolicy]) {
      return NO;
    }
  }
  if (self.viewerInfoPolicy) {
    if (![self.viewerInfoPolicy isEqual:aShareFolderArg.viewerInfoPolicy]) {
      return NO;
    }
  }
  if (![self.accessInheritance isEqual:aShareFolderArg.accessInheritance]) {
    return NO;
  }
  if (self.actions) {
    if (![self.actions isEqual:aShareFolderArg.actions]) {
      return NO;
    }
  }
  if (self.linkSettings) {
    if (![self.linkSettings isEqual:aShareFolderArg.linkSettings]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"path"] = valueObj.path;
  if (valueObj.aclUpdatePolicy) {
    jsonDict[@"acl_update_policy"] = [DBSHARINGAclUpdatePolicySerializer serialize:valueObj.aclUpdatePolicy];
  }
  jsonDict[@"force_async"] = valueObj.forceAsync;
  if (valueObj.memberPolicy) {
    jsonDict[@"member_policy"] = [DBSHARINGMemberPolicySerializer serialize:valueObj.memberPolicy];
  }
  if (valueObj.sharedLinkPolicy) {
    jsonDict[@"shared_link_policy"] = [DBSHARINGSharedLinkPolicySerializer serialize:valueObj.sharedLinkPolicy];
  }
  if (valueObj.viewerInfoPolicy) {
    jsonDict[@"viewer_info_policy"] = [DBSHARINGViewerInfoPolicySerializer serialize:valueObj.viewerInfoPolicy];
  }
  jsonDict[@"access_inheritance"] = [DBSHARINGAccessInheritanceSerializer serialize:valueObj.accessInheritance];
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFolderActionSerializer serialize:elem0];
                                              }];
  }
  if (valueObj.linkSettings) {
    jsonDict[@"link_settings"] = [DBSHARINGLinkSettingsSerializer serialize:valueObj.linkSettings];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *path = valueDict[@"path"];
  DBSHARINGAclUpdatePolicy *aclUpdatePolicy =
      valueDict[@"acl_update_policy"] ? [DBSHARINGAclUpdatePolicySerializer deserialize:valueDict[@"acl_update_policy"]]
                                      : nil;
  NSNumber *forceAsync = valueDict[@"force_async"] ?: @NO;
  DBSHARINGMemberPolicy *memberPolicy =
      valueDict[@"member_policy"] ? [DBSHARINGMemberPolicySerializer deserialize:valueDict[@"member_policy"]] : nil;
  DBSHARINGSharedLinkPolicy *sharedLinkPolicy =
      valueDict[@"shared_link_policy"]
          ? [DBSHARINGSharedLinkPolicySerializer deserialize:valueDict[@"shared_link_policy"]]
          : nil;
  DBSHARINGViewerInfoPolicy *viewerInfoPolicy =
      valueDict[@"viewer_info_policy"]
          ? [DBSHARINGViewerInfoPolicySerializer deserialize:valueDict[@"viewer_info_policy"]]
          : nil;
  DBSHARINGAccessInheritance *accessInheritance =
      valueDict[@"access_inheritance"]
          ? [DBSHARINGAccessInheritanceSerializer deserialize:valueDict[@"access_inheritance"]]
          : [[DBSHARINGAccessInheritance alloc] initWithInherit];
  NSArray<DBSHARINGFolderAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFolderActionSerializer deserialize:elem0];
                                                   }]
                            : nil;
  DBSHARINGLinkSettings *linkSettings =
      valueDict[@"link_settings"] ? [DBSHARINGLinkSettingsSerializer deserialize:valueDict[@"link_settings"]] : nil;

  return [[DBSHARINGShareFolderArg alloc] initWithPath:path
                                       aclUpdatePolicy:aclUpdatePolicy
                                            forceAsync:forceAsync
                                          memberPolicy:memberPolicy
                                      sharedLinkPolicy:sharedLinkPolicy
                                      viewerInfoPolicy:viewerInfoPolicy
                                     accessInheritance:accessInheritance
                                               actions:actions
                                          linkSettings:linkSettings];
}

@end

#import "DBSHARINGShareFolderErrorBase.h"
#import "DBSHARINGSharePathError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderErrorBase

@synthesize badPath = _badPath;

#pragma mark - Constructors

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBaseEmailUnverified;
  }
  return self;
}

- (instancetype)initWithBadPath:(DBSHARINGSharePathError *)badPath {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBaseBadPath;
    _badPath = badPath;
  }
  return self;
}

- (instancetype)initWithTeamPolicyDisallowsMemberPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy;
  }
  return self;
}

- (instancetype)initWithDisallowedSharedLinkPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBaseOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharePathError *)badPath {
  if (![self isBadPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderErrorBaseBadPath, but was %@.", [self tagName]];
  }
  return _badPath;
}

#pragma mark - Tag state methods

- (BOOL)isEmailUnverified {
  return _tag == DBSHARINGShareFolderErrorBaseEmailUnverified;
}

- (BOOL)isBadPath {
  return _tag == DBSHARINGShareFolderErrorBaseBadPath;
}

- (BOOL)isTeamPolicyDisallowsMemberPolicy {
  return _tag == DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy;
}

- (BOOL)isDisallowedSharedLinkPolicy {
  return _tag == DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy;
}

- (BOOL)isOther {
  return _tag == DBSHARINGShareFolderErrorBaseOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGShareFolderErrorBaseEmailUnverified:
    return @"DBSHARINGShareFolderErrorBaseEmailUnverified";
  case DBSHARINGShareFolderErrorBaseBadPath:
    return @"DBSHARINGShareFolderErrorBaseBadPath";
  case DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy:
    return @"DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy";
  case DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy:
    return @"DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy";
  case DBSHARINGShareFolderErrorBaseOther:
    return @"DBSHARINGShareFolderErrorBaseOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderErrorBaseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderErrorBaseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderErrorBaseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGShareFolderErrorBaseEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorBaseBadPath:
    result = prime * result + [self.badPath hash];
    break;
  case DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorBaseOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderErrorBase:other];
}

- (BOOL)isEqualToShareFolderErrorBase:(DBSHARINGShareFolderErrorBase *)aShareFolderErrorBase {
  if (self == aShareFolderErrorBase) {
    return YES;
  }
  if (self.tag != aShareFolderErrorBase.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGShareFolderErrorBaseEmailUnverified:
    return [[self tagName] isEqual:[aShareFolderErrorBase tagName]];
  case DBSHARINGShareFolderErrorBaseBadPath:
    return [self.badPath isEqual:aShareFolderErrorBase.badPath];
  case DBSHARINGShareFolderErrorBaseTeamPolicyDisallowsMemberPolicy:
    return [[self tagName] isEqual:[aShareFolderErrorBase tagName]];
  case DBSHARINGShareFolderErrorBaseDisallowedSharedLinkPolicy:
    return [[self tagName] isEqual:[aShareFolderErrorBase tagName]];
  case DBSHARINGShareFolderErrorBaseOther:
    return [[self tagName] isEqual:[aShareFolderErrorBase tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderErrorBaseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderErrorBase *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isBadPath]) {
    jsonDict[@"bad_path"] = [[DBSHARINGSharePathErrorSerializer serialize:valueObj.badPath] mutableCopy];
    jsonDict[@".tag"] = @"bad_path";
  } else if ([valueObj isTeamPolicyDisallowsMemberPolicy]) {
    jsonDict[@".tag"] = @"team_policy_disallows_member_policy";
  } else if ([valueObj isDisallowedSharedLinkPolicy]) {
    jsonDict[@".tag"] = @"disallowed_shared_link_policy";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderErrorBase *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBSHARINGShareFolderErrorBase alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"bad_path"]) {
    DBSHARINGSharePathError *badPath = [DBSHARINGSharePathErrorSerializer deserialize:valueDict[@"bad_path"]];
    return [[DBSHARINGShareFolderErrorBase alloc] initWithBadPath:badPath];
  } else if ([tag isEqualToString:@"team_policy_disallows_member_policy"]) {
    return [[DBSHARINGShareFolderErrorBase alloc] initWithTeamPolicyDisallowsMemberPolicy];
  } else if ([tag isEqualToString:@"disallowed_shared_link_policy"]) {
    return [[DBSHARINGShareFolderErrorBase alloc] initWithDisallowedSharedLinkPolicy];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGShareFolderErrorBase alloc] initWithOther];
  } else {
    return [[DBSHARINGShareFolderErrorBase alloc] initWithOther];
  }
}

@end

#import "DBSHARINGShareFolderError.h"
#import "DBSHARINGShareFolderErrorBase.h"
#import "DBSHARINGSharePathError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderError

@synthesize badPath = _badPath;

#pragma mark - Constructors

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithBadPath:(DBSHARINGSharePathError *)badPath {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorBadPath;
    _badPath = badPath;
  }
  return self;
}

- (instancetype)initWithTeamPolicyDisallowsMemberPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy;
  }
  return self;
}

- (instancetype)initWithDisallowedSharedLinkPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorOther;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderErrorNoPermission;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharePathError *)badPath {
  if (![self isBadPath]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderErrorBadPath, but was %@.", [self tagName]];
  }
  return _badPath;
}

#pragma mark - Tag state methods

- (BOOL)isEmailUnverified {
  return _tag == DBSHARINGShareFolderErrorEmailUnverified;
}

- (BOOL)isBadPath {
  return _tag == DBSHARINGShareFolderErrorBadPath;
}

- (BOOL)isTeamPolicyDisallowsMemberPolicy {
  return _tag == DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy;
}

- (BOOL)isDisallowedSharedLinkPolicy {
  return _tag == DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy;
}

- (BOOL)isOther {
  return _tag == DBSHARINGShareFolderErrorOther;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGShareFolderErrorNoPermission;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGShareFolderErrorEmailUnverified:
    return @"DBSHARINGShareFolderErrorEmailUnverified";
  case DBSHARINGShareFolderErrorBadPath:
    return @"DBSHARINGShareFolderErrorBadPath";
  case DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy:
    return @"DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy";
  case DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy:
    return @"DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy";
  case DBSHARINGShareFolderErrorOther:
    return @"DBSHARINGShareFolderErrorOther";
  case DBSHARINGShareFolderErrorNoPermission:
    return @"DBSHARINGShareFolderErrorNoPermission";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGShareFolderErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorBadPath:
    result = prime * result + [self.badPath hash];
    break;
  case DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderError:other];
}

- (BOOL)isEqualToShareFolderError:(DBSHARINGShareFolderError *)aShareFolderError {
  if (self == aShareFolderError) {
    return YES;
  }
  if (self.tag != aShareFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGShareFolderErrorEmailUnverified:
    return [[self tagName] isEqual:[aShareFolderError tagName]];
  case DBSHARINGShareFolderErrorBadPath:
    return [self.badPath isEqual:aShareFolderError.badPath];
  case DBSHARINGShareFolderErrorTeamPolicyDisallowsMemberPolicy:
    return [[self tagName] isEqual:[aShareFolderError tagName]];
  case DBSHARINGShareFolderErrorDisallowedSharedLinkPolicy:
    return [[self tagName] isEqual:[aShareFolderError tagName]];
  case DBSHARINGShareFolderErrorOther:
    return [[self tagName] isEqual:[aShareFolderError tagName]];
  case DBSHARINGShareFolderErrorNoPermission:
    return [[self tagName] isEqual:[aShareFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isBadPath]) {
    jsonDict[@"bad_path"] = [[DBSHARINGSharePathErrorSerializer serialize:valueObj.badPath] mutableCopy];
    jsonDict[@".tag"] = @"bad_path";
  } else if ([valueObj isTeamPolicyDisallowsMemberPolicy]) {
    jsonDict[@".tag"] = @"team_policy_disallows_member_policy";
  } else if ([valueObj isDisallowedSharedLinkPolicy]) {
    jsonDict[@".tag"] = @"disallowed_shared_link_policy";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBSHARINGShareFolderError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"bad_path"]) {
    DBSHARINGSharePathError *badPath = [DBSHARINGSharePathErrorSerializer deserialize:valueDict[@"bad_path"]];
    return [[DBSHARINGShareFolderError alloc] initWithBadPath:badPath];
  } else if ([tag isEqualToString:@"team_policy_disallows_member_policy"]) {
    return [[DBSHARINGShareFolderError alloc] initWithTeamPolicyDisallowsMemberPolicy];
  } else if ([tag isEqualToString:@"disallowed_shared_link_policy"]) {
    return [[DBSHARINGShareFolderError alloc] initWithDisallowedSharedLinkPolicy];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGShareFolderError alloc] initWithOther];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGShareFolderError alloc] initWithNoPermission];
  } else {
    return [[DBSHARINGShareFolderError alloc] initWithOther];
  }
}

@end

#import "DBASYNCPollResultBase.h"
#import "DBSHARINGShareFolderError.h"
#import "DBSHARINGShareFolderJobStatus.h"
#import "DBSHARINGSharedFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderJobStatus

@synthesize complete = _complete;
@synthesize failed = _failed;

#pragma mark - Constructors

- (instancetype)initWithInProgress {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderJobStatusInProgress;
  }
  return self;
}

- (instancetype)initWithComplete:(DBSHARINGSharedFolderMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderJobStatusComplete;
    _complete = complete;
  }
  return self;
}

- (instancetype)initWithFailed:(DBSHARINGShareFolderError *)failed {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderJobStatusFailed;
    _failed = failed;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderJobStatusComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

- (DBSHARINGShareFolderError *)failed {
  if (![self isFailed]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderJobStatusFailed, but was %@.", [self tagName]];
  }
  return _failed;
}

#pragma mark - Tag state methods

- (BOOL)isInProgress {
  return _tag == DBSHARINGShareFolderJobStatusInProgress;
}

- (BOOL)isComplete {
  return _tag == DBSHARINGShareFolderJobStatusComplete;
}

- (BOOL)isFailed {
  return _tag == DBSHARINGShareFolderJobStatusFailed;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGShareFolderJobStatusInProgress:
    return @"DBSHARINGShareFolderJobStatusInProgress";
  case DBSHARINGShareFolderJobStatusComplete:
    return @"DBSHARINGShareFolderJobStatusComplete";
  case DBSHARINGShareFolderJobStatusFailed:
    return @"DBSHARINGShareFolderJobStatusFailed";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderJobStatusSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderJobStatusSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderJobStatusSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGShareFolderJobStatusInProgress:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGShareFolderJobStatusComplete:
    result = prime * result + [self.complete hash];
    break;
  case DBSHARINGShareFolderJobStatusFailed:
    result = prime * result + [self.failed hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderJobStatus:other];
}

- (BOOL)isEqualToShareFolderJobStatus:(DBSHARINGShareFolderJobStatus *)aShareFolderJobStatus {
  if (self == aShareFolderJobStatus) {
    return YES;
  }
  if (self.tag != aShareFolderJobStatus.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGShareFolderJobStatusInProgress:
    return [[self tagName] isEqual:[aShareFolderJobStatus tagName]];
  case DBSHARINGShareFolderJobStatusComplete:
    return [self.complete isEqual:aShareFolderJobStatus.complete];
  case DBSHARINGShareFolderJobStatusFailed:
    return [self.failed isEqual:aShareFolderJobStatus.failed];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderJobStatusSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderJobStatus *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInProgress]) {
    jsonDict[@".tag"] = @"in_progress";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBSHARINGSharedFolderMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else if ([valueObj isFailed]) {
    jsonDict[@"failed"] = [[DBSHARINGShareFolderErrorSerializer serialize:valueObj.failed] mutableCopy];
    jsonDict[@".tag"] = @"failed";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderJobStatus *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"in_progress"]) {
    return [[DBSHARINGShareFolderJobStatus alloc] initWithInProgress];
  } else if ([tag isEqualToString:@"complete"]) {
    DBSHARINGSharedFolderMetadata *complete = [DBSHARINGSharedFolderMetadataSerializer deserialize:valueDict];
    return [[DBSHARINGShareFolderJobStatus alloc] initWithComplete:complete];
  } else if ([tag isEqualToString:@"failed"]) {
    DBSHARINGShareFolderError *failed = [DBSHARINGShareFolderErrorSerializer deserialize:valueDict[@"failed"]];
    return [[DBSHARINGShareFolderJobStatus alloc] initWithFailed:failed];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBASYNCLaunchResultBase.h"
#import "DBSHARINGShareFolderLaunch.h"
#import "DBSHARINGSharedFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGShareFolderLaunch

@synthesize asyncJobId = _asyncJobId;
@synthesize complete = _complete;

#pragma mark - Constructors

- (instancetype)initWithAsyncJobId:(NSString *)asyncJobId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderLaunchAsyncJobId;
    _asyncJobId = asyncJobId;
  }
  return self;
}

- (instancetype)initWithComplete:(DBSHARINGSharedFolderMetadata *)complete {
  self = [super init];
  if (self) {
    _tag = DBSHARINGShareFolderLaunchComplete;
    _complete = complete;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)asyncJobId {
  if (![self isAsyncJobId]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderLaunchAsyncJobId, but was %@.", [self tagName]];
  }
  return _asyncJobId;
}

- (DBSHARINGSharedFolderMetadata *)complete {
  if (![self isComplete]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGShareFolderLaunchComplete, but was %@.", [self tagName]];
  }
  return _complete;
}

#pragma mark - Tag state methods

- (BOOL)isAsyncJobId {
  return _tag == DBSHARINGShareFolderLaunchAsyncJobId;
}

- (BOOL)isComplete {
  return _tag == DBSHARINGShareFolderLaunchComplete;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGShareFolderLaunchAsyncJobId:
    return @"DBSHARINGShareFolderLaunchAsyncJobId";
  case DBSHARINGShareFolderLaunchComplete:
    return @"DBSHARINGShareFolderLaunchComplete";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGShareFolderLaunchSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGShareFolderLaunchSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGShareFolderLaunchSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGShareFolderLaunchAsyncJobId:
    result = prime * result + [self.asyncJobId hash];
    break;
  case DBSHARINGShareFolderLaunchComplete:
    result = prime * result + [self.complete hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToShareFolderLaunch:other];
}

- (BOOL)isEqualToShareFolderLaunch:(DBSHARINGShareFolderLaunch *)aShareFolderLaunch {
  if (self == aShareFolderLaunch) {
    return YES;
  }
  if (self.tag != aShareFolderLaunch.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGShareFolderLaunchAsyncJobId:
    return [self.asyncJobId isEqual:aShareFolderLaunch.asyncJobId];
  case DBSHARINGShareFolderLaunchComplete:
    return [self.complete isEqual:aShareFolderLaunch.complete];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGShareFolderLaunchSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGShareFolderLaunch *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAsyncJobId]) {
    jsonDict[@"async_job_id"] = valueObj.asyncJobId;
    jsonDict[@".tag"] = @"async_job_id";
  } else if ([valueObj isComplete]) {
    jsonDict = [[DBSHARINGSharedFolderMetadataSerializer serialize:valueObj.complete] mutableCopy];
    jsonDict[@".tag"] = @"complete";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGShareFolderLaunch *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"async_job_id"]) {
    NSString *asyncJobId = valueDict[@"async_job_id"];
    return [[DBSHARINGShareFolderLaunch alloc] initWithAsyncJobId:asyncJobId];
  } else if ([tag isEqualToString:@"complete"]) {
    DBSHARINGSharedFolderMetadata *complete = [DBSHARINGSharedFolderMetadataSerializer deserialize:valueDict];
    return [[DBSHARINGShareFolderLaunch alloc] initWithComplete:complete];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGSharePathError.h"
#import "DBSHARINGSharedFolderMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharePathError

@synthesize alreadyShared = _alreadyShared;

#pragma mark - Constructors

- (instancetype)initWithIsFile {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsFile;
  }
  return self;
}

- (instancetype)initWithInsideSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorInsideSharedFolder;
  }
  return self;
}

- (instancetype)initWithContainsSharedFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorContainsSharedFolder;
  }
  return self;
}

- (instancetype)initWithContainsAppFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorContainsAppFolder;
  }
  return self;
}

- (instancetype)initWithContainsTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorContainsTeamFolder;
  }
  return self;
}

- (instancetype)initWithIsAppFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsAppFolder;
  }
  return self;
}

- (instancetype)initWithInsideAppFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorInsideAppFolder;
  }
  return self;
}

- (instancetype)initWithIsPublicFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsPublicFolder;
  }
  return self;
}

- (instancetype)initWithInsidePublicFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorInsidePublicFolder;
  }
  return self;
}

- (instancetype)initWithAlreadyShared:(DBSHARINGSharedFolderMetadata *)alreadyShared {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorAlreadyShared;
    _alreadyShared = alreadyShared;
  }
  return self;
}

- (instancetype)initWithInvalidPath {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorInvalidPath;
  }
  return self;
}

- (instancetype)initWithIsOsxPackage {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsOsxPackage;
  }
  return self;
}

- (instancetype)initWithInsideOsxPackage {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorInsideOsxPackage;
  }
  return self;
}

- (instancetype)initWithIsVault {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsVault;
  }
  return self;
}

- (instancetype)initWithIsFamily {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorIsFamily;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharePathErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderMetadata *)alreadyShared {
  if (![self isAlreadyShared]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGSharePathErrorAlreadyShared, but was %@.", [self tagName]];
  }
  return _alreadyShared;
}

#pragma mark - Tag state methods

- (BOOL)isIsFile {
  return _tag == DBSHARINGSharePathErrorIsFile;
}

- (BOOL)isInsideSharedFolder {
  return _tag == DBSHARINGSharePathErrorInsideSharedFolder;
}

- (BOOL)isContainsSharedFolder {
  return _tag == DBSHARINGSharePathErrorContainsSharedFolder;
}

- (BOOL)isContainsAppFolder {
  return _tag == DBSHARINGSharePathErrorContainsAppFolder;
}

- (BOOL)isContainsTeamFolder {
  return _tag == DBSHARINGSharePathErrorContainsTeamFolder;
}

- (BOOL)isIsAppFolder {
  return _tag == DBSHARINGSharePathErrorIsAppFolder;
}

- (BOOL)isInsideAppFolder {
  return _tag == DBSHARINGSharePathErrorInsideAppFolder;
}

- (BOOL)isIsPublicFolder {
  return _tag == DBSHARINGSharePathErrorIsPublicFolder;
}

- (BOOL)isInsidePublicFolder {
  return _tag == DBSHARINGSharePathErrorInsidePublicFolder;
}

- (BOOL)isAlreadyShared {
  return _tag == DBSHARINGSharePathErrorAlreadyShared;
}

- (BOOL)isInvalidPath {
  return _tag == DBSHARINGSharePathErrorInvalidPath;
}

- (BOOL)isIsOsxPackage {
  return _tag == DBSHARINGSharePathErrorIsOsxPackage;
}

- (BOOL)isInsideOsxPackage {
  return _tag == DBSHARINGSharePathErrorInsideOsxPackage;
}

- (BOOL)isIsVault {
  return _tag == DBSHARINGSharePathErrorIsVault;
}

- (BOOL)isIsFamily {
  return _tag == DBSHARINGSharePathErrorIsFamily;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharePathErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharePathErrorIsFile:
    return @"DBSHARINGSharePathErrorIsFile";
  case DBSHARINGSharePathErrorInsideSharedFolder:
    return @"DBSHARINGSharePathErrorInsideSharedFolder";
  case DBSHARINGSharePathErrorContainsSharedFolder:
    return @"DBSHARINGSharePathErrorContainsSharedFolder";
  case DBSHARINGSharePathErrorContainsAppFolder:
    return @"DBSHARINGSharePathErrorContainsAppFolder";
  case DBSHARINGSharePathErrorContainsTeamFolder:
    return @"DBSHARINGSharePathErrorContainsTeamFolder";
  case DBSHARINGSharePathErrorIsAppFolder:
    return @"DBSHARINGSharePathErrorIsAppFolder";
  case DBSHARINGSharePathErrorInsideAppFolder:
    return @"DBSHARINGSharePathErrorInsideAppFolder";
  case DBSHARINGSharePathErrorIsPublicFolder:
    return @"DBSHARINGSharePathErrorIsPublicFolder";
  case DBSHARINGSharePathErrorInsidePublicFolder:
    return @"DBSHARINGSharePathErrorInsidePublicFolder";
  case DBSHARINGSharePathErrorAlreadyShared:
    return @"DBSHARINGSharePathErrorAlreadyShared";
  case DBSHARINGSharePathErrorInvalidPath:
    return @"DBSHARINGSharePathErrorInvalidPath";
  case DBSHARINGSharePathErrorIsOsxPackage:
    return @"DBSHARINGSharePathErrorIsOsxPackage";
  case DBSHARINGSharePathErrorInsideOsxPackage:
    return @"DBSHARINGSharePathErrorInsideOsxPackage";
  case DBSHARINGSharePathErrorIsVault:
    return @"DBSHARINGSharePathErrorIsVault";
  case DBSHARINGSharePathErrorIsFamily:
    return @"DBSHARINGSharePathErrorIsFamily";
  case DBSHARINGSharePathErrorOther:
    return @"DBSHARINGSharePathErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharePathErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharePathErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharePathErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharePathErrorIsFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorInsideSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorContainsSharedFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorContainsAppFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorContainsTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorIsAppFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorInsideAppFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorIsPublicFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorInsidePublicFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorAlreadyShared:
    result = prime * result + [self.alreadyShared hash];
    break;
  case DBSHARINGSharePathErrorInvalidPath:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorIsOsxPackage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorInsideOsxPackage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorIsVault:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorIsFamily:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharePathErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharePathError:other];
}

- (BOOL)isEqualToSharePathError:(DBSHARINGSharePathError *)aSharePathError {
  if (self == aSharePathError) {
    return YES;
  }
  if (self.tag != aSharePathError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharePathErrorIsFile:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorInsideSharedFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorContainsSharedFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorContainsAppFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorContainsTeamFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorIsAppFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorInsideAppFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorIsPublicFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorInsidePublicFolder:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorAlreadyShared:
    return [self.alreadyShared isEqual:aSharePathError.alreadyShared];
  case DBSHARINGSharePathErrorInvalidPath:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorIsOsxPackage:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorInsideOsxPackage:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorIsVault:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorIsFamily:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  case DBSHARINGSharePathErrorOther:
    return [[self tagName] isEqual:[aSharePathError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharePathErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharePathError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isIsFile]) {
    jsonDict[@".tag"] = @"is_file";
  } else if ([valueObj isInsideSharedFolder]) {
    jsonDict[@".tag"] = @"inside_shared_folder";
  } else if ([valueObj isContainsSharedFolder]) {
    jsonDict[@".tag"] = @"contains_shared_folder";
  } else if ([valueObj isContainsAppFolder]) {
    jsonDict[@".tag"] = @"contains_app_folder";
  } else if ([valueObj isContainsTeamFolder]) {
    jsonDict[@".tag"] = @"contains_team_folder";
  } else if ([valueObj isIsAppFolder]) {
    jsonDict[@".tag"] = @"is_app_folder";
  } else if ([valueObj isInsideAppFolder]) {
    jsonDict[@".tag"] = @"inside_app_folder";
  } else if ([valueObj isIsPublicFolder]) {
    jsonDict[@".tag"] = @"is_public_folder";
  } else if ([valueObj isInsidePublicFolder]) {
    jsonDict[@".tag"] = @"inside_public_folder";
  } else if ([valueObj isAlreadyShared]) {
    jsonDict = [[DBSHARINGSharedFolderMetadataSerializer serialize:valueObj.alreadyShared] mutableCopy];
    jsonDict[@".tag"] = @"already_shared";
  } else if ([valueObj isInvalidPath]) {
    jsonDict[@".tag"] = @"invalid_path";
  } else if ([valueObj isIsOsxPackage]) {
    jsonDict[@".tag"] = @"is_osx_package";
  } else if ([valueObj isInsideOsxPackage]) {
    jsonDict[@".tag"] = @"inside_osx_package";
  } else if ([valueObj isIsVault]) {
    jsonDict[@".tag"] = @"is_vault";
  } else if ([valueObj isIsFamily]) {
    jsonDict[@".tag"] = @"is_family";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharePathError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"is_file"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsFile];
  } else if ([tag isEqualToString:@"inside_shared_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithInsideSharedFolder];
  } else if ([tag isEqualToString:@"contains_shared_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithContainsSharedFolder];
  } else if ([tag isEqualToString:@"contains_app_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithContainsAppFolder];
  } else if ([tag isEqualToString:@"contains_team_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithContainsTeamFolder];
  } else if ([tag isEqualToString:@"is_app_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsAppFolder];
  } else if ([tag isEqualToString:@"inside_app_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithInsideAppFolder];
  } else if ([tag isEqualToString:@"is_public_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsPublicFolder];
  } else if ([tag isEqualToString:@"inside_public_folder"]) {
    return [[DBSHARINGSharePathError alloc] initWithInsidePublicFolder];
  } else if ([tag isEqualToString:@"already_shared"]) {
    DBSHARINGSharedFolderMetadata *alreadyShared = [DBSHARINGSharedFolderMetadataSerializer deserialize:valueDict];
    return [[DBSHARINGSharePathError alloc] initWithAlreadyShared:alreadyShared];
  } else if ([tag isEqualToString:@"invalid_path"]) {
    return [[DBSHARINGSharePathError alloc] initWithInvalidPath];
  } else if ([tag isEqualToString:@"is_osx_package"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsOsxPackage];
  } else if ([tag isEqualToString:@"inside_osx_package"]) {
    return [[DBSHARINGSharePathError alloc] initWithInsideOsxPackage];
  } else if ([tag isEqualToString:@"is_vault"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsVault];
  } else if ([tag isEqualToString:@"is_family"]) {
    return [[DBSHARINGSharePathError alloc] initWithIsFamily];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharePathError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharePathError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGAudienceExceptions.h"
#import "DBSHARINGAudienceRestrictingSharedFolder.h"
#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGLinkPermission.h"
#import "DBSHARINGSharedContentLinkMetadata.h"
#import "DBSHARINGSharedContentLinkMetadataBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedContentLinkMetadata

#pragma mark - Constructors

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected
                                    url:(NSString *)url
                            accessLevel:(DBSHARINGAccessLevel *)accessLevel
        audienceRestrictingSharedFolder:(DBSHARINGAudienceRestrictingSharedFolder *)audienceRestrictingSharedFolder
                                 expiry:(NSDate *)expiry
                     audienceExceptions:(DBSHARINGAudienceExceptions *)audienceExceptions {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](audienceOptions);
  [DBStoneValidators nonnullValidator:nil](currentAudience);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](linkPermissions);
  [DBStoneValidators nonnullValidator:nil](passwordProtected);
  [DBStoneValidators nonnullValidator:nil](url);

  self = [super initWithAudienceOptions:audienceOptions
                        currentAudience:currentAudience
                        linkPermissions:linkPermissions
                      passwordProtected:passwordProtected
                            accessLevel:accessLevel
        audienceRestrictingSharedFolder:audienceRestrictingSharedFolder
                                 expiry:expiry];
  if (self) {
    _audienceExceptions = audienceExceptions;
    _url = url;
  }
  return self;
}

- (instancetype)initWithAudienceOptions:(NSArray<DBSHARINGLinkAudience *> *)audienceOptions
                        currentAudience:(DBSHARINGLinkAudience *)currentAudience
                        linkPermissions:(NSArray<DBSHARINGLinkPermission *> *)linkPermissions
                      passwordProtected:(NSNumber *)passwordProtected
                                    url:(NSString *)url {
  return [self initWithAudienceOptions:audienceOptions
                       currentAudience:currentAudience
                       linkPermissions:linkPermissions
                     passwordProtected:passwordProtected
                                   url:url
                           accessLevel:nil
       audienceRestrictingSharedFolder:nil
                                expiry:nil
                    audienceExceptions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedContentLinkMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedContentLinkMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedContentLinkMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.audienceOptions hash];
  result = prime * result + [self.currentAudience hash];
  result = prime * result + [self.linkPermissions hash];
  result = prime * result + [self.passwordProtected hash];
  result = prime * result + [self.url hash];
  if (self.accessLevel != nil) {
    result = prime * result + [self.accessLevel hash];
  }
  if (self.audienceRestrictingSharedFolder != nil) {
    result = prime * result + [self.audienceRestrictingSharedFolder hash];
  }
  if (self.expiry != nil) {
    result = prime * result + [self.expiry hash];
  }
  if (self.audienceExceptions != nil) {
    result = prime * result + [self.audienceExceptions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedContentLinkMetadata:other];
}

- (BOOL)isEqualToSharedContentLinkMetadata:(DBSHARINGSharedContentLinkMetadata *)aSharedContentLinkMetadata {
  if (self == aSharedContentLinkMetadata) {
    return YES;
  }
  if (![self.audienceOptions isEqual:aSharedContentLinkMetadata.audienceOptions]) {
    return NO;
  }
  if (![self.currentAudience isEqual:aSharedContentLinkMetadata.currentAudience]) {
    return NO;
  }
  if (![self.linkPermissions isEqual:aSharedContentLinkMetadata.linkPermissions]) {
    return NO;
  }
  if (![self.passwordProtected isEqual:aSharedContentLinkMetadata.passwordProtected]) {
    return NO;
  }
  if (![self.url isEqual:aSharedContentLinkMetadata.url]) {
    return NO;
  }
  if (self.accessLevel) {
    if (![self.accessLevel isEqual:aSharedContentLinkMetadata.accessLevel]) {
      return NO;
    }
  }
  if (self.audienceRestrictingSharedFolder) {
    if (![self.audienceRestrictingSharedFolder isEqual:aSharedContentLinkMetadata.audienceRestrictingSharedFolder]) {
      return NO;
    }
  }
  if (self.expiry) {
    if (![self.expiry isEqual:aSharedContentLinkMetadata.expiry]) {
      return NO;
    }
  }
  if (self.audienceExceptions) {
    if (![self.audienceExceptions isEqual:aSharedContentLinkMetadata.audienceExceptions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedContentLinkMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedContentLinkMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"audience_options"] = [DBArraySerializer serialize:valueObj.audienceOptions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkAudienceSerializer serialize:elem0];
                                                     }];
  jsonDict[@"current_audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.currentAudience];
  jsonDict[@"link_permissions"] = [DBArraySerializer serialize:valueObj.linkPermissions
                                                     withBlock:^id(id elem0) {
                                                       return [DBSHARINGLinkPermissionSerializer serialize:elem0];
                                                     }];
  jsonDict[@"password_protected"] = valueObj.passwordProtected;
  jsonDict[@"url"] = valueObj.url;
  if (valueObj.accessLevel) {
    jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];
  }
  if (valueObj.audienceRestrictingSharedFolder) {
    jsonDict[@"audience_restricting_shared_folder"] =
        [DBSHARINGAudienceRestrictingSharedFolderSerializer serialize:valueObj.audienceRestrictingSharedFolder];
  }
  if (valueObj.expiry) {
    jsonDict[@"expiry"] = [DBNSDateSerializer serialize:valueObj.expiry dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.audienceExceptions) {
    jsonDict[@"audience_exceptions"] = [DBSHARINGAudienceExceptionsSerializer serialize:valueObj.audienceExceptions];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedContentLinkMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGLinkAudience *> *audienceOptions =
      [DBArraySerializer deserialize:valueDict[@"audience_options"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkAudienceSerializer deserialize:elem0];
                           }];
  DBSHARINGLinkAudience *currentAudience = [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"current_audience"]];
  NSArray<DBSHARINGLinkPermission *> *linkPermissions =
      [DBArraySerializer deserialize:valueDict[@"link_permissions"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGLinkPermissionSerializer deserialize:elem0];
                           }];
  NSNumber *passwordProtected = valueDict[@"password_protected"];
  NSString *url = valueDict[@"url"];
  DBSHARINGAccessLevel *accessLevel =
      valueDict[@"access_level"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]] : nil;
  DBSHARINGAudienceRestrictingSharedFolder *audienceRestrictingSharedFolder =
      valueDict[@"audience_restricting_shared_folder"]
          ? [DBSHARINGAudienceRestrictingSharedFolderSerializer
                deserialize:valueDict[@"audience_restricting_shared_folder"]]
          : nil;
  NSDate *expiry = valueDict[@"expiry"]
                       ? [DBNSDateSerializer deserialize:valueDict[@"expiry"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                       : nil;
  DBSHARINGAudienceExceptions *audienceExceptions =
      valueDict[@"audience_exceptions"]
          ? [DBSHARINGAudienceExceptionsSerializer deserialize:valueDict[@"audience_exceptions"]]
          : nil;

  return [[DBSHARINGSharedContentLinkMetadata alloc] initWithAudienceOptions:audienceOptions
                                                             currentAudience:currentAudience
                                                             linkPermissions:linkPermissions
                                                           passwordProtected:passwordProtected
                                                                         url:url
                                                                 accessLevel:accessLevel
                                             audienceRestrictingSharedFolder:audienceRestrictingSharedFolder
                                                                      expiry:expiry
                                                          audienceExceptions:audienceExceptions];
}

@end

#import "DBSHARINGGroupMembershipInfo.h"
#import "DBSHARINGInviteeMembershipInfo.h"
#import "DBSHARINGSharedFileMembers.h"
#import "DBSHARINGUserFileMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFileMembers

#pragma mark - Constructors

- (instancetype)initWithUsers:(NSArray<DBSHARINGUserFileMembershipInfo *> *)users
                       groups:(NSArray<DBSHARINGGroupMembershipInfo *> *)groups
                     invitees:(NSArray<DBSHARINGInviteeMembershipInfo *> *)invitees
                       cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](groups);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](invitees);

  self = [super init];
  if (self) {
    _users = users;
    _groups = groups;
    _invitees = invitees;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithUsers:(NSArray<DBSHARINGUserFileMembershipInfo *> *)users
                       groups:(NSArray<DBSHARINGGroupMembershipInfo *> *)groups
                     invitees:(NSArray<DBSHARINGInviteeMembershipInfo *> *)invitees {
  return [self initWithUsers:users groups:groups invitees:invitees cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFileMembersSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFileMembersSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFileMembersSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.users hash];
  result = prime * result + [self.groups hash];
  result = prime * result + [self.invitees hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFileMembers:other];
}

- (BOOL)isEqualToSharedFileMembers:(DBSHARINGSharedFileMembers *)aSharedFileMembers {
  if (self == aSharedFileMembers) {
    return YES;
  }
  if (![self.users isEqual:aSharedFileMembers.users]) {
    return NO;
  }
  if (![self.groups isEqual:aSharedFileMembers.groups]) {
    return NO;
  }
  if (![self.invitees isEqual:aSharedFileMembers.invitees]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aSharedFileMembers.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFileMembersSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFileMembers *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBSHARINGUserFileMembershipInfoSerializer serialize:elem0];
                                          }];
  jsonDict[@"groups"] = [DBArraySerializer serialize:valueObj.groups
                                           withBlock:^id(id elem0) {
                                             return [DBSHARINGGroupMembershipInfoSerializer serialize:elem0];
                                           }];
  jsonDict[@"invitees"] = [DBArraySerializer serialize:valueObj.invitees
                                             withBlock:^id(id elem0) {
                                               return [DBSHARINGInviteeMembershipInfoSerializer serialize:elem0];
                                             }];
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFileMembers *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGUserFileMembershipInfo *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGUserFileMembershipInfoSerializer deserialize:elem0];
                           }];
  NSArray<DBSHARINGGroupMembershipInfo *> *groups =
      [DBArraySerializer deserialize:valueDict[@"groups"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGGroupMembershipInfoSerializer deserialize:elem0];
                           }];
  NSArray<DBSHARINGInviteeMembershipInfo *> *invitees =
      [DBArraySerializer deserialize:valueDict[@"invitees"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGInviteeMembershipInfoSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBSHARINGSharedFileMembers alloc] initWithUsers:users groups:groups invitees:invitees cursor:cursor];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGExpectedSharedContentLinkMetadata.h"
#import "DBSHARINGFilePermission.h"
#import "DBSHARINGFolderPolicy.h"
#import "DBSHARINGSharedContentLinkMetadata.h"
#import "DBSHARINGSharedFileMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFileMetadata

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                     policy:(DBSHARINGFolderPolicy *)policy
                 previewUrl:(NSString *)previewUrl
                 accessType:(DBSHARINGAccessLevel *)accessType
       expectedLinkMetadata:(DBSHARINGExpectedSharedContentLinkMetadata *)expectedLinkMetadata
               linkMetadata:(DBSHARINGSharedContentLinkMetadata *)linkMetadata
          ownerDisplayNames:(NSArray<NSString *> *)ownerDisplayNames
                  ownerTeam:(DBUSERSTeam *)ownerTeam
       parentSharedFolderId:(NSString *)parentSharedFolderId
                pathDisplay:(NSString *)pathDisplay
                  pathLower:(NSString *)pathLower
                permissions:(NSArray<DBSHARINGFilePermission *> *)permissions
                timeInvited:(NSDate *)timeInvited {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(4) maxLength:nil pattern:@"id:.+"]](id_);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](policy);
  [DBStoneValidators nonnullValidator:nil](previewUrl);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](ownerDisplayNames);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super init];
  if (self) {
    _accessType = accessType;
    _id_ = id_;
    _expectedLinkMetadata = expectedLinkMetadata;
    _linkMetadata = linkMetadata;
    _name = name;
    _ownerDisplayNames = ownerDisplayNames;
    _ownerTeam = ownerTeam;
    _parentSharedFolderId = parentSharedFolderId;
    _pathDisplay = pathDisplay;
    _pathLower = pathLower;
    _permissions = permissions;
    _policy = policy;
    _previewUrl = previewUrl;
    _timeInvited = timeInvited;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_
                       name:(NSString *)name
                     policy:(DBSHARINGFolderPolicy *)policy
                 previewUrl:(NSString *)previewUrl {
  return [self initWithId_:id_
                      name:name
                    policy:policy
                previewUrl:previewUrl
                accessType:nil
      expectedLinkMetadata:nil
              linkMetadata:nil
         ownerDisplayNames:nil
                 ownerTeam:nil
      parentSharedFolderId:nil
               pathDisplay:nil
                 pathLower:nil
               permissions:nil
               timeInvited:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFileMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFileMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFileMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.policy hash];
  result = prime * result + [self.previewUrl hash];
  if (self.accessType != nil) {
    result = prime * result + [self.accessType hash];
  }
  if (self.expectedLinkMetadata != nil) {
    result = prime * result + [self.expectedLinkMetadata hash];
  }
  if (self.linkMetadata != nil) {
    result = prime * result + [self.linkMetadata hash];
  }
  if (self.ownerDisplayNames != nil) {
    result = prime * result + [self.ownerDisplayNames hash];
  }
  if (self.ownerTeam != nil) {
    result = prime * result + [self.ownerTeam hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.pathDisplay != nil) {
    result = prime * result + [self.pathDisplay hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.timeInvited != nil) {
    result = prime * result + [self.timeInvited hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFileMetadata:other];
}

- (BOOL)isEqualToSharedFileMetadata:(DBSHARINGSharedFileMetadata *)aSharedFileMetadata {
  if (self == aSharedFileMetadata) {
    return YES;
  }
  if (![self.id_ isEqual:aSharedFileMetadata.id_]) {
    return NO;
  }
  if (![self.name isEqual:aSharedFileMetadata.name]) {
    return NO;
  }
  if (![self.policy isEqual:aSharedFileMetadata.policy]) {
    return NO;
  }
  if (![self.previewUrl isEqual:aSharedFileMetadata.previewUrl]) {
    return NO;
  }
  if (self.accessType) {
    if (![self.accessType isEqual:aSharedFileMetadata.accessType]) {
      return NO;
    }
  }
  if (self.expectedLinkMetadata) {
    if (![self.expectedLinkMetadata isEqual:aSharedFileMetadata.expectedLinkMetadata]) {
      return NO;
    }
  }
  if (self.linkMetadata) {
    if (![self.linkMetadata isEqual:aSharedFileMetadata.linkMetadata]) {
      return NO;
    }
  }
  if (self.ownerDisplayNames) {
    if (![self.ownerDisplayNames isEqual:aSharedFileMetadata.ownerDisplayNames]) {
      return NO;
    }
  }
  if (self.ownerTeam) {
    if (![self.ownerTeam isEqual:aSharedFileMetadata.ownerTeam]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aSharedFileMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.pathDisplay) {
    if (![self.pathDisplay isEqual:aSharedFileMetadata.pathDisplay]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aSharedFileMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.permissions) {
    if (![self.permissions isEqual:aSharedFileMetadata.permissions]) {
      return NO;
    }
  }
  if (self.timeInvited) {
    if (![self.timeInvited isEqual:aSharedFileMetadata.timeInvited]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFileMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFileMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"policy"] = [DBSHARINGFolderPolicySerializer serialize:valueObj.policy];
  jsonDict[@"preview_url"] = valueObj.previewUrl;
  if (valueObj.accessType) {
    jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  }
  if (valueObj.expectedLinkMetadata) {
    jsonDict[@"expected_link_metadata"] =
        [DBSHARINGExpectedSharedContentLinkMetadataSerializer serialize:valueObj.expectedLinkMetadata];
  }
  if (valueObj.linkMetadata) {
    jsonDict[@"link_metadata"] = [DBSHARINGSharedContentLinkMetadataSerializer serialize:valueObj.linkMetadata];
  }
  if (valueObj.ownerDisplayNames) {
    jsonDict[@"owner_display_names"] = [DBArraySerializer serialize:valueObj.ownerDisplayNames
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
  }
  if (valueObj.ownerTeam) {
    jsonDict[@"owner_team"] = [DBUSERSTeamSerializer serialize:valueObj.ownerTeam];
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.pathDisplay) {
    jsonDict[@"path_display"] = valueObj.pathDisplay;
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGFilePermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.timeInvited) {
    jsonDict[@"time_invited"] = [DBNSDateSerializer serialize:valueObj.timeInvited dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFileMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"];
  DBSHARINGFolderPolicy *policy = [DBSHARINGFolderPolicySerializer deserialize:valueDict[@"policy"]];
  NSString *previewUrl = valueDict[@"preview_url"];
  DBSHARINGAccessLevel *accessType =
      valueDict[@"access_type"] ? [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]] : nil;
  DBSHARINGExpectedSharedContentLinkMetadata *expectedLinkMetadata =
      valueDict[@"expected_link_metadata"]
          ? [DBSHARINGExpectedSharedContentLinkMetadataSerializer deserialize:valueDict[@"expected_link_metadata"]]
          : nil;
  DBSHARINGSharedContentLinkMetadata *linkMetadata =
      valueDict[@"link_metadata"]
          ? [DBSHARINGSharedContentLinkMetadataSerializer deserialize:valueDict[@"link_metadata"]]
          : nil;
  NSArray<NSString *> *ownerDisplayNames = valueDict[@"owner_display_names"]
                                               ? [DBArraySerializer deserialize:valueDict[@"owner_display_names"]
                                                                      withBlock:^id(id elem0) {
                                                                        return elem0;
                                                                      }]
                                               : nil;
  DBUSERSTeam *ownerTeam =
      valueDict[@"owner_team"] ? [DBUSERSTeamSerializer deserialize:valueDict[@"owner_team"]] : nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  NSString *pathDisplay = valueDict[@"path_display"] ?: nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSArray<DBSHARINGFilePermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGFilePermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSDate *timeInvited = valueDict[@"time_invited"] ? [DBNSDateSerializer deserialize:valueDict[@"time_invited"]
                                                                          dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                   : nil;

  return [[DBSHARINGSharedFileMetadata alloc] initWithId_:id_
                                                     name:name
                                                   policy:policy
                                               previewUrl:previewUrl
                                               accessType:accessType
                                     expectedLinkMetadata:expectedLinkMetadata
                                             linkMetadata:linkMetadata
                                        ownerDisplayNames:ownerDisplayNames
                                                ownerTeam:ownerTeam
                                     parentSharedFolderId:parentSharedFolderId
                                              pathDisplay:pathDisplay
                                                pathLower:pathLower
                                              permissions:permissions
                                              timeInvited:timeInvited];
}

@end

#import "DBSHARINGSharedFolderAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFolderAccessError

#pragma mark - Constructors

- (instancetype)initWithInvalidId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderAccessErrorInvalidId;
  }
  return self;
}

- (instancetype)initWithNotAMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderAccessErrorNotAMember;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderAccessErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithUnmounted {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderAccessErrorUnmounted;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderAccessErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidId {
  return _tag == DBSHARINGSharedFolderAccessErrorInvalidId;
}

- (BOOL)isNotAMember {
  return _tag == DBSHARINGSharedFolderAccessErrorNotAMember;
}

- (BOOL)isEmailUnverified {
  return _tag == DBSHARINGSharedFolderAccessErrorEmailUnverified;
}

- (BOOL)isUnmounted {
  return _tag == DBSHARINGSharedFolderAccessErrorUnmounted;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedFolderAccessErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedFolderAccessErrorInvalidId:
    return @"DBSHARINGSharedFolderAccessErrorInvalidId";
  case DBSHARINGSharedFolderAccessErrorNotAMember:
    return @"DBSHARINGSharedFolderAccessErrorNotAMember";
  case DBSHARINGSharedFolderAccessErrorEmailUnverified:
    return @"DBSHARINGSharedFolderAccessErrorEmailUnverified";
  case DBSHARINGSharedFolderAccessErrorUnmounted:
    return @"DBSHARINGSharedFolderAccessErrorUnmounted";
  case DBSHARINGSharedFolderAccessErrorOther:
    return @"DBSHARINGSharedFolderAccessErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFolderAccessErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFolderAccessErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFolderAccessErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedFolderAccessErrorInvalidId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderAccessErrorNotAMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderAccessErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderAccessErrorUnmounted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderAccessErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderAccessError:other];
}

- (BOOL)isEqualToSharedFolderAccessError:(DBSHARINGSharedFolderAccessError *)aSharedFolderAccessError {
  if (self == aSharedFolderAccessError) {
    return YES;
  }
  if (self.tag != aSharedFolderAccessError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedFolderAccessErrorInvalidId:
    return [[self tagName] isEqual:[aSharedFolderAccessError tagName]];
  case DBSHARINGSharedFolderAccessErrorNotAMember:
    return [[self tagName] isEqual:[aSharedFolderAccessError tagName]];
  case DBSHARINGSharedFolderAccessErrorEmailUnverified:
    return [[self tagName] isEqual:[aSharedFolderAccessError tagName]];
  case DBSHARINGSharedFolderAccessErrorUnmounted:
    return [[self tagName] isEqual:[aSharedFolderAccessError tagName]];
  case DBSHARINGSharedFolderAccessErrorOther:
    return [[self tagName] isEqual:[aSharedFolderAccessError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFolderAccessErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFolderAccessError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidId]) {
    jsonDict[@".tag"] = @"invalid_id";
  } else if ([valueObj isNotAMember]) {
    jsonDict[@".tag"] = @"not_a_member";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isUnmounted]) {
    jsonDict[@".tag"] = @"unmounted";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFolderAccessError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_id"]) {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithInvalidId];
  } else if ([tag isEqualToString:@"not_a_member"]) {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithNotAMember];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"unmounted"]) {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithUnmounted];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedFolderAccessError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGMemberAccessLevelResult.h"
#import "DBSHARINGSharedFolderMemberError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFolderMemberError

@synthesize noExplicitAccess = _noExplicitAccess;

#pragma mark - Constructors

- (instancetype)initWithInvalidDropboxId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderMemberErrorInvalidDropboxId;
  }
  return self;
}

- (instancetype)initWithNotAMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderMemberErrorNotAMember;
  }
  return self;
}

- (instancetype)initWithNoExplicitAccess:(DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderMemberErrorNoExplicitAccess;
    _noExplicitAccess = noExplicitAccess;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedFolderMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGMemberAccessLevelResult *)noExplicitAccess {
  if (![self isNoExplicitAccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGSharedFolderMemberErrorNoExplicitAccess, but was %@.", [self tagName]];
  }
  return _noExplicitAccess;
}

#pragma mark - Tag state methods

- (BOOL)isInvalidDropboxId {
  return _tag == DBSHARINGSharedFolderMemberErrorInvalidDropboxId;
}

- (BOOL)isNotAMember {
  return _tag == DBSHARINGSharedFolderMemberErrorNotAMember;
}

- (BOOL)isNoExplicitAccess {
  return _tag == DBSHARINGSharedFolderMemberErrorNoExplicitAccess;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedFolderMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedFolderMemberErrorInvalidDropboxId:
    return @"DBSHARINGSharedFolderMemberErrorInvalidDropboxId";
  case DBSHARINGSharedFolderMemberErrorNotAMember:
    return @"DBSHARINGSharedFolderMemberErrorNotAMember";
  case DBSHARINGSharedFolderMemberErrorNoExplicitAccess:
    return @"DBSHARINGSharedFolderMemberErrorNoExplicitAccess";
  case DBSHARINGSharedFolderMemberErrorOther:
    return @"DBSHARINGSharedFolderMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFolderMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFolderMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFolderMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedFolderMemberErrorInvalidDropboxId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderMemberErrorNotAMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedFolderMemberErrorNoExplicitAccess:
    result = prime * result + [self.noExplicitAccess hash];
    break;
  case DBSHARINGSharedFolderMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderMemberError:other];
}

- (BOOL)isEqualToSharedFolderMemberError:(DBSHARINGSharedFolderMemberError *)aSharedFolderMemberError {
  if (self == aSharedFolderMemberError) {
    return YES;
  }
  if (self.tag != aSharedFolderMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedFolderMemberErrorInvalidDropboxId:
    return [[self tagName] isEqual:[aSharedFolderMemberError tagName]];
  case DBSHARINGSharedFolderMemberErrorNotAMember:
    return [[self tagName] isEqual:[aSharedFolderMemberError tagName]];
  case DBSHARINGSharedFolderMemberErrorNoExplicitAccess:
    return [self.noExplicitAccess isEqual:aSharedFolderMemberError.noExplicitAccess];
  case DBSHARINGSharedFolderMemberErrorOther:
    return [[self tagName] isEqual:[aSharedFolderMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFolderMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFolderMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidDropboxId]) {
    jsonDict[@".tag"] = @"invalid_dropbox_id";
  } else if ([valueObj isNotAMember]) {
    jsonDict[@".tag"] = @"not_a_member";
  } else if ([valueObj isNoExplicitAccess]) {
    jsonDict = [[DBSHARINGMemberAccessLevelResultSerializer serialize:valueObj.noExplicitAccess] mutableCopy];
    jsonDict[@".tag"] = @"no_explicit_access";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFolderMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_dropbox_id"]) {
    return [[DBSHARINGSharedFolderMemberError alloc] initWithInvalidDropboxId];
  } else if ([tag isEqualToString:@"not_a_member"]) {
    return [[DBSHARINGSharedFolderMemberError alloc] initWithNotAMember];
  } else if ([tag isEqualToString:@"no_explicit_access"]) {
    DBSHARINGMemberAccessLevelResult *noExplicitAccess =
        [DBSHARINGMemberAccessLevelResultSerializer deserialize:valueDict];
    return [[DBSHARINGSharedFolderMemberError alloc] initWithNoExplicitAccess:noExplicitAccess];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedFolderMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedFolderMemberError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGGroupMembershipInfo.h"
#import "DBSHARINGInviteeMembershipInfo.h"
#import "DBSHARINGSharedFolderMembers.h"
#import "DBSHARINGUserMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFolderMembers

#pragma mark - Constructors

- (instancetype)initWithUsers:(NSArray<DBSHARINGUserMembershipInfo *> *)users
                       groups:(NSArray<DBSHARINGGroupMembershipInfo *> *)groups
                     invitees:(NSArray<DBSHARINGInviteeMembershipInfo *> *)invitees
                       cursor:(NSString *)cursor {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](groups);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](invitees);

  self = [super init];
  if (self) {
    _users = users;
    _groups = groups;
    _invitees = invitees;
    _cursor = cursor;
  }
  return self;
}

- (instancetype)initWithUsers:(NSArray<DBSHARINGUserMembershipInfo *> *)users
                       groups:(NSArray<DBSHARINGGroupMembershipInfo *> *)groups
                     invitees:(NSArray<DBSHARINGInviteeMembershipInfo *> *)invitees {
  return [self initWithUsers:users groups:groups invitees:invitees cursor:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFolderMembersSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFolderMembersSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFolderMembersSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.users hash];
  result = prime * result + [self.groups hash];
  result = prime * result + [self.invitees hash];
  if (self.cursor != nil) {
    result = prime * result + [self.cursor hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderMembers:other];
}

- (BOOL)isEqualToSharedFolderMembers:(DBSHARINGSharedFolderMembers *)aSharedFolderMembers {
  if (self == aSharedFolderMembers) {
    return YES;
  }
  if (![self.users isEqual:aSharedFolderMembers.users]) {
    return NO;
  }
  if (![self.groups isEqual:aSharedFolderMembers.groups]) {
    return NO;
  }
  if (![self.invitees isEqual:aSharedFolderMembers.invitees]) {
    return NO;
  }
  if (self.cursor) {
    if (![self.cursor isEqual:aSharedFolderMembers.cursor]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFolderMembersSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFolderMembers *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBSHARINGUserMembershipInfoSerializer serialize:elem0];
                                          }];
  jsonDict[@"groups"] = [DBArraySerializer serialize:valueObj.groups
                                           withBlock:^id(id elem0) {
                                             return [DBSHARINGGroupMembershipInfoSerializer serialize:elem0];
                                           }];
  jsonDict[@"invitees"] = [DBArraySerializer serialize:valueObj.invitees
                                             withBlock:^id(id elem0) {
                                               return [DBSHARINGInviteeMembershipInfoSerializer serialize:elem0];
                                             }];
  if (valueObj.cursor) {
    jsonDict[@"cursor"] = valueObj.cursor;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFolderMembers *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGUserMembershipInfo *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGUserMembershipInfoSerializer deserialize:elem0];
                           }];
  NSArray<DBSHARINGGroupMembershipInfo *> *groups =
      [DBArraySerializer deserialize:valueDict[@"groups"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGGroupMembershipInfoSerializer deserialize:elem0];
                           }];
  NSArray<DBSHARINGInviteeMembershipInfo *> *invitees =
      [DBArraySerializer deserialize:valueDict[@"invitees"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGInviteeMembershipInfoSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"] ?: nil;

  return [[DBSHARINGSharedFolderMembers alloc] initWithUsers:users groups:groups invitees:invitees cursor:cursor];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGSharedFolderMetadataBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFolderMetadataBase

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                isInsideTeamFolder:(NSNumber *)isInsideTeamFolder
                      isTeamFolder:(NSNumber *)isTeamFolder
                 ownerDisplayNames:(NSArray<NSString *> *)ownerDisplayNames
                         ownerTeam:(DBUSERSTeam *)ownerTeam
              parentSharedFolderId:(NSString *)parentSharedFolderId
                         pathLower:(NSString *)pathLower
                  parentFolderName:(NSString *)parentFolderName {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](isInsideTeamFolder);
  [DBStoneValidators nonnullValidator:nil](isTeamFolder);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](ownerDisplayNames);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);

  self = [super init];
  if (self) {
    _accessType = accessType;
    _isInsideTeamFolder = isInsideTeamFolder;
    _isTeamFolder = isTeamFolder;
    _ownerDisplayNames = ownerDisplayNames;
    _ownerTeam = ownerTeam;
    _parentSharedFolderId = parentSharedFolderId;
    _pathLower = pathLower;
    _parentFolderName = parentFolderName;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                isInsideTeamFolder:(NSNumber *)isInsideTeamFolder
                      isTeamFolder:(NSNumber *)isTeamFolder {
  return [self initWithAccessType:accessType
               isInsideTeamFolder:isInsideTeamFolder
                     isTeamFolder:isTeamFolder
                ownerDisplayNames:nil
                        ownerTeam:nil
             parentSharedFolderId:nil
                        pathLower:nil
                 parentFolderName:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFolderMetadataBaseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFolderMetadataBaseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFolderMetadataBaseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.isInsideTeamFolder hash];
  result = prime * result + [self.isTeamFolder hash];
  if (self.ownerDisplayNames != nil) {
    result = prime * result + [self.ownerDisplayNames hash];
  }
  if (self.ownerTeam != nil) {
    result = prime * result + [self.ownerTeam hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.parentFolderName != nil) {
    result = prime * result + [self.parentFolderName hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderMetadataBase:other];
}

- (BOOL)isEqualToSharedFolderMetadataBase:(DBSHARINGSharedFolderMetadataBase *)aSharedFolderMetadataBase {
  if (self == aSharedFolderMetadataBase) {
    return YES;
  }
  if (![self.accessType isEqual:aSharedFolderMetadataBase.accessType]) {
    return NO;
  }
  if (![self.isInsideTeamFolder isEqual:aSharedFolderMetadataBase.isInsideTeamFolder]) {
    return NO;
  }
  if (![self.isTeamFolder isEqual:aSharedFolderMetadataBase.isTeamFolder]) {
    return NO;
  }
  if (self.ownerDisplayNames) {
    if (![self.ownerDisplayNames isEqual:aSharedFolderMetadataBase.ownerDisplayNames]) {
      return NO;
    }
  }
  if (self.ownerTeam) {
    if (![self.ownerTeam isEqual:aSharedFolderMetadataBase.ownerTeam]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aSharedFolderMetadataBase.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aSharedFolderMetadataBase.pathLower]) {
      return NO;
    }
  }
  if (self.parentFolderName) {
    if (![self.parentFolderName isEqual:aSharedFolderMetadataBase.parentFolderName]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFolderMetadataBaseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFolderMetadataBase *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"is_inside_team_folder"] = valueObj.isInsideTeamFolder;
  jsonDict[@"is_team_folder"] = valueObj.isTeamFolder;
  if (valueObj.ownerDisplayNames) {
    jsonDict[@"owner_display_names"] = [DBArraySerializer serialize:valueObj.ownerDisplayNames
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
  }
  if (valueObj.ownerTeam) {
    jsonDict[@"owner_team"] = [DBUSERSTeamSerializer serialize:valueObj.ownerTeam];
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.parentFolderName) {
    jsonDict[@"parent_folder_name"] = valueObj.parentFolderName;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFolderMetadataBase *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  NSNumber *isInsideTeamFolder = valueDict[@"is_inside_team_folder"];
  NSNumber *isTeamFolder = valueDict[@"is_team_folder"];
  NSArray<NSString *> *ownerDisplayNames = valueDict[@"owner_display_names"]
                                               ? [DBArraySerializer deserialize:valueDict[@"owner_display_names"]
                                                                      withBlock:^id(id elem0) {
                                                                        return elem0;
                                                                      }]
                                               : nil;
  DBUSERSTeam *ownerTeam =
      valueDict[@"owner_team"] ? [DBUSERSTeamSerializer deserialize:valueDict[@"owner_team"]] : nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSString *parentFolderName = valueDict[@"parent_folder_name"] ?: nil;

  return [[DBSHARINGSharedFolderMetadataBase alloc] initWithAccessType:accessType
                                                    isInsideTeamFolder:isInsideTeamFolder
                                                          isTeamFolder:isTeamFolder
                                                     ownerDisplayNames:ownerDisplayNames
                                                             ownerTeam:ownerTeam
                                                  parentSharedFolderId:parentSharedFolderId
                                                             pathLower:pathLower
                                                      parentFolderName:parentFolderName];
}

@end

#import "DBSHARINGAccessInheritance.h"
#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGFolderPermission.h"
#import "DBSHARINGFolderPolicy.h"
#import "DBSHARINGSharedContentLinkMetadata.h"
#import "DBSHARINGSharedFolderMetadata.h"
#import "DBSHARINGSharedFolderMetadataBase.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGSharedFolderMetadata

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                isInsideTeamFolder:(NSNumber *)isInsideTeamFolder
                      isTeamFolder:(NSNumber *)isTeamFolder
                              name:(NSString *)name
                            policy:(DBSHARINGFolderPolicy *)policy
                        previewUrl:(NSString *)previewUrl
                    sharedFolderId:(NSString *)sharedFolderId
                       timeInvited:(NSDate *)timeInvited
                 ownerDisplayNames:(NSArray<NSString *> *)ownerDisplayNames
                         ownerTeam:(DBUSERSTeam *)ownerTeam
              parentSharedFolderId:(NSString *)parentSharedFolderId
                         pathLower:(NSString *)pathLower
                  parentFolderName:(NSString *)parentFolderName
                      linkMetadata:(DBSHARINGSharedContentLinkMetadata *)linkMetadata
                       permissions:(NSArray<DBSHARINGFolderPermission *> *)permissions
                 accessInheritance:(DBSHARINGAccessInheritance *)accessInheritance {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](isInsideTeamFolder);
  [DBStoneValidators nonnullValidator:nil](isTeamFolder);
  [DBStoneValidators nonnullValidator:nil](name);
  [DBStoneValidators nonnullValidator:nil](policy);
  [DBStoneValidators nonnullValidator:nil](previewUrl);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators nonnullValidator:nil](timeInvited);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](ownerDisplayNames);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](
      parentSharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super initWithAccessType:accessType
                isInsideTeamFolder:isInsideTeamFolder
                      isTeamFolder:isTeamFolder
                 ownerDisplayNames:ownerDisplayNames
                         ownerTeam:ownerTeam
              parentSharedFolderId:parentSharedFolderId
                         pathLower:pathLower
                  parentFolderName:parentFolderName];
  if (self) {
    _linkMetadata = linkMetadata;
    _name = name;
    _permissions = permissions;
    _policy = policy;
    _previewUrl = previewUrl;
    _sharedFolderId = sharedFolderId;
    _timeInvited = timeInvited;
    _accessInheritance = accessInheritance ?: [[DBSHARINGAccessInheritance alloc] initWithInherit];
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                isInsideTeamFolder:(NSNumber *)isInsideTeamFolder
                      isTeamFolder:(NSNumber *)isTeamFolder
                              name:(NSString *)name
                            policy:(DBSHARINGFolderPolicy *)policy
                        previewUrl:(NSString *)previewUrl
                    sharedFolderId:(NSString *)sharedFolderId
                       timeInvited:(NSDate *)timeInvited {
  return [self initWithAccessType:accessType
               isInsideTeamFolder:isInsideTeamFolder
                     isTeamFolder:isTeamFolder
                             name:name
                           policy:policy
                       previewUrl:previewUrl
                   sharedFolderId:sharedFolderId
                      timeInvited:timeInvited
                ownerDisplayNames:nil
                        ownerTeam:nil
             parentSharedFolderId:nil
                        pathLower:nil
                 parentFolderName:nil
                     linkMetadata:nil
                      permissions:nil
                accessInheritance:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedFolderMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedFolderMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedFolderMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.isInsideTeamFolder hash];
  result = prime * result + [self.isTeamFolder hash];
  result = prime * result + [self.name hash];
  result = prime * result + [self.policy hash];
  result = prime * result + [self.previewUrl hash];
  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.timeInvited hash];
  if (self.ownerDisplayNames != nil) {
    result = prime * result + [self.ownerDisplayNames hash];
  }
  if (self.ownerTeam != nil) {
    result = prime * result + [self.ownerTeam hash];
  }
  if (self.parentSharedFolderId != nil) {
    result = prime * result + [self.parentSharedFolderId hash];
  }
  if (self.pathLower != nil) {
    result = prime * result + [self.pathLower hash];
  }
  if (self.parentFolderName != nil) {
    result = prime * result + [self.parentFolderName hash];
  }
  if (self.linkMetadata != nil) {
    result = prime * result + [self.linkMetadata hash];
  }
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  result = prime * result + [self.accessInheritance hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedFolderMetadata:other];
}

- (BOOL)isEqualToSharedFolderMetadata:(DBSHARINGSharedFolderMetadata *)aSharedFolderMetadata {
  if (self == aSharedFolderMetadata) {
    return YES;
  }
  if (![self.accessType isEqual:aSharedFolderMetadata.accessType]) {
    return NO;
  }
  if (![self.isInsideTeamFolder isEqual:aSharedFolderMetadata.isInsideTeamFolder]) {
    return NO;
  }
  if (![self.isTeamFolder isEqual:aSharedFolderMetadata.isTeamFolder]) {
    return NO;
  }
  if (![self.name isEqual:aSharedFolderMetadata.name]) {
    return NO;
  }
  if (![self.policy isEqual:aSharedFolderMetadata.policy]) {
    return NO;
  }
  if (![self.previewUrl isEqual:aSharedFolderMetadata.previewUrl]) {
    return NO;
  }
  if (![self.sharedFolderId isEqual:aSharedFolderMetadata.sharedFolderId]) {
    return NO;
  }
  if (![self.timeInvited isEqual:aSharedFolderMetadata.timeInvited]) {
    return NO;
  }
  if (self.ownerDisplayNames) {
    if (![self.ownerDisplayNames isEqual:aSharedFolderMetadata.ownerDisplayNames]) {
      return NO;
    }
  }
  if (self.ownerTeam) {
    if (![self.ownerTeam isEqual:aSharedFolderMetadata.ownerTeam]) {
      return NO;
    }
  }
  if (self.parentSharedFolderId) {
    if (![self.parentSharedFolderId isEqual:aSharedFolderMetadata.parentSharedFolderId]) {
      return NO;
    }
  }
  if (self.pathLower) {
    if (![self.pathLower isEqual:aSharedFolderMetadata.pathLower]) {
      return NO;
    }
  }
  if (self.parentFolderName) {
    if (![self.parentFolderName isEqual:aSharedFolderMetadata.parentFolderName]) {
      return NO;
    }
  }
  if (self.linkMetadata) {
    if (![self.linkMetadata isEqual:aSharedFolderMetadata.linkMetadata]) {
      return NO;
    }
  }
  if (self.permissions) {
    if (![self.permissions isEqual:aSharedFolderMetadata.permissions]) {
      return NO;
    }
  }
  if (![self.accessInheritance isEqual:aSharedFolderMetadata.accessInheritance]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedFolderMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedFolderMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"is_inside_team_folder"] = valueObj.isInsideTeamFolder;
  jsonDict[@"is_team_folder"] = valueObj.isTeamFolder;
  jsonDict[@"name"] = valueObj.name;
  jsonDict[@"policy"] = [DBSHARINGFolderPolicySerializer serialize:valueObj.policy];
  jsonDict[@"preview_url"] = valueObj.previewUrl;
  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"time_invited"] = [DBNSDateSerializer serialize:valueObj.timeInvited dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  if (valueObj.ownerDisplayNames) {
    jsonDict[@"owner_display_names"] = [DBArraySerializer serialize:valueObj.ownerDisplayNames
                                                          withBlock:^id(id elem0) {
                                                            return elem0;
                                                          }];
  }
  if (valueObj.ownerTeam) {
    jsonDict[@"owner_team"] = [DBUSERSTeamSerializer serialize:valueObj.ownerTeam];
  }
  if (valueObj.parentSharedFolderId) {
    jsonDict[@"parent_shared_folder_id"] = valueObj.parentSharedFolderId;
  }
  if (valueObj.pathLower) {
    jsonDict[@"path_lower"] = valueObj.pathLower;
  }
  if (valueObj.parentFolderName) {
    jsonDict[@"parent_folder_name"] = valueObj.parentFolderName;
  }
  if (valueObj.linkMetadata) {
    jsonDict[@"link_metadata"] = [DBSHARINGSharedContentLinkMetadataSerializer serialize:valueObj.linkMetadata];
  }
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGFolderPermissionSerializer serialize:elem0];
                                                  }];
  }
  jsonDict[@"access_inheritance"] = [DBSHARINGAccessInheritanceSerializer serialize:valueObj.accessInheritance];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedFolderMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  NSNumber *isInsideTeamFolder = valueDict[@"is_inside_team_folder"];
  NSNumber *isTeamFolder = valueDict[@"is_team_folder"];
  NSString *name = valueDict[@"name"];
  DBSHARINGFolderPolicy *policy = [DBSHARINGFolderPolicySerializer deserialize:valueDict[@"policy"]];
  NSString *previewUrl = valueDict[@"preview_url"];
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSDate *timeInvited = [DBNSDateSerializer deserialize:valueDict[@"time_invited"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSArray<NSString *> *ownerDisplayNames = valueDict[@"owner_display_names"]
                                               ? [DBArraySerializer deserialize:valueDict[@"owner_display_names"]
                                                                      withBlock:^id(id elem0) {
                                                                        return elem0;
                                                                      }]
                                               : nil;
  DBUSERSTeam *ownerTeam =
      valueDict[@"owner_team"] ? [DBUSERSTeamSerializer deserialize:valueDict[@"owner_team"]] : nil;
  NSString *parentSharedFolderId = valueDict[@"parent_shared_folder_id"] ?: nil;
  NSString *pathLower = valueDict[@"path_lower"] ?: nil;
  NSString *parentFolderName = valueDict[@"parent_folder_name"] ?: nil;
  DBSHARINGSharedContentLinkMetadata *linkMetadata =
      valueDict[@"link_metadata"]
          ? [DBSHARINGSharedContentLinkMetadataSerializer deserialize:valueDict[@"link_metadata"]]
          : nil;
  NSArray<DBSHARINGFolderPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGFolderPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  DBSHARINGAccessInheritance *accessInheritance =
      valueDict[@"access_inheritance"]
          ? [DBSHARINGAccessInheritanceSerializer deserialize:valueDict[@"access_inheritance"]]
          : [[DBSHARINGAccessInheritance alloc] initWithInherit];

  return [[DBSHARINGSharedFolderMetadata alloc] initWithAccessType:accessType
                                                isInsideTeamFolder:isInsideTeamFolder
                                                      isTeamFolder:isTeamFolder
                                                              name:name
                                                            policy:policy
                                                        previewUrl:previewUrl
                                                    sharedFolderId:sharedFolderId
                                                       timeInvited:timeInvited
                                                 ownerDisplayNames:ownerDisplayNames
                                                         ownerTeam:ownerTeam
                                              parentSharedFolderId:parentSharedFolderId
                                                         pathLower:pathLower
                                                  parentFolderName:parentFolderName
                                                      linkMetadata:linkMetadata
                                                       permissions:permissions
                                                 accessInheritance:accessInheritance];
}

@end

#import "DBSHARINGSharedLinkAccessFailureReason.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkAccessFailureReason

#pragma mark - Constructors

- (instancetype)initWithLoginRequired {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonLoginRequired;
  }
  return self;
}

- (instancetype)initWithEmailVerifyRequired {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired;
  }
  return self;
}

- (instancetype)initWithPasswordRequired {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonPasswordRequired;
  }
  return self;
}

- (instancetype)initWithTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonTeamOnly;
  }
  return self;
}

- (instancetype)initWithOwnerOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonOwnerOnly;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAccessFailureReasonOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isLoginRequired {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonLoginRequired;
}

- (BOOL)isEmailVerifyRequired {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired;
}

- (BOOL)isPasswordRequired {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonPasswordRequired;
}

- (BOOL)isTeamOnly {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonTeamOnly;
}

- (BOOL)isOwnerOnly {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonOwnerOnly;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedLinkAccessFailureReasonOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedLinkAccessFailureReasonLoginRequired:
    return @"DBSHARINGSharedLinkAccessFailureReasonLoginRequired";
  case DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired:
    return @"DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired";
  case DBSHARINGSharedLinkAccessFailureReasonPasswordRequired:
    return @"DBSHARINGSharedLinkAccessFailureReasonPasswordRequired";
  case DBSHARINGSharedLinkAccessFailureReasonTeamOnly:
    return @"DBSHARINGSharedLinkAccessFailureReasonTeamOnly";
  case DBSHARINGSharedLinkAccessFailureReasonOwnerOnly:
    return @"DBSHARINGSharedLinkAccessFailureReasonOwnerOnly";
  case DBSHARINGSharedLinkAccessFailureReasonOther:
    return @"DBSHARINGSharedLinkAccessFailureReasonOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkAccessFailureReasonSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkAccessFailureReasonSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkAccessFailureReasonSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedLinkAccessFailureReasonLoginRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkAccessFailureReasonPasswordRequired:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkAccessFailureReasonTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkAccessFailureReasonOwnerOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkAccessFailureReasonOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkAccessFailureReason:other];
}

- (BOOL)isEqualToSharedLinkAccessFailureReason:
    (DBSHARINGSharedLinkAccessFailureReason *)aSharedLinkAccessFailureReason {
  if (self == aSharedLinkAccessFailureReason) {
    return YES;
  }
  if (self.tag != aSharedLinkAccessFailureReason.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedLinkAccessFailureReasonLoginRequired:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  case DBSHARINGSharedLinkAccessFailureReasonEmailVerifyRequired:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  case DBSHARINGSharedLinkAccessFailureReasonPasswordRequired:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  case DBSHARINGSharedLinkAccessFailureReasonTeamOnly:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  case DBSHARINGSharedLinkAccessFailureReasonOwnerOnly:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  case DBSHARINGSharedLinkAccessFailureReasonOther:
    return [[self tagName] isEqual:[aSharedLinkAccessFailureReason tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkAccessFailureReasonSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkAccessFailureReason *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isLoginRequired]) {
    jsonDict[@".tag"] = @"login_required";
  } else if ([valueObj isEmailVerifyRequired]) {
    jsonDict[@".tag"] = @"email_verify_required";
  } else if ([valueObj isPasswordRequired]) {
    jsonDict[@".tag"] = @"password_required";
  } else if ([valueObj isTeamOnly]) {
    jsonDict[@".tag"] = @"team_only";
  } else if ([valueObj isOwnerOnly]) {
    jsonDict[@".tag"] = @"owner_only";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkAccessFailureReason *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"login_required"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithLoginRequired];
  } else if ([tag isEqualToString:@"email_verify_required"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithEmailVerifyRequired];
  } else if ([tag isEqualToString:@"password_required"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithPasswordRequired];
  } else if ([tag isEqualToString:@"team_only"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithTeamOnly];
  } else if ([tag isEqualToString:@"owner_only"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithOwnerOnly];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedLinkAccessFailureReason alloc] initWithOther];
  }
}

@end

#import "DBSHARINGSharedLinkAlreadyExistsMetadata.h"
#import "DBSHARINGSharedLinkMetadata.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkAlreadyExistsMetadata

@synthesize metadata = _metadata;

#pragma mark - Constructors

- (instancetype)initWithMetadata:(DBSHARINGSharedLinkMetadata *)metadata {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAlreadyExistsMetadataMetadata;
    _metadata = metadata;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkAlreadyExistsMetadataOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedLinkMetadata *)metadata {
  if (![self isMetadata]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGSharedLinkAlreadyExistsMetadataMetadata, but was %@.", [self tagName]];
  }
  return _metadata;
}

#pragma mark - Tag state methods

- (BOOL)isMetadata {
  return _tag == DBSHARINGSharedLinkAlreadyExistsMetadataMetadata;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedLinkAlreadyExistsMetadataOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedLinkAlreadyExistsMetadataMetadata:
    return @"DBSHARINGSharedLinkAlreadyExistsMetadataMetadata";
  case DBSHARINGSharedLinkAlreadyExistsMetadataOther:
    return @"DBSHARINGSharedLinkAlreadyExistsMetadataOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkAlreadyExistsMetadataSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkAlreadyExistsMetadataSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkAlreadyExistsMetadataSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedLinkAlreadyExistsMetadataMetadata:
    result = prime * result + [self.metadata hash];
    break;
  case DBSHARINGSharedLinkAlreadyExistsMetadataOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkAlreadyExistsMetadata:other];
}

- (BOOL)isEqualToSharedLinkAlreadyExistsMetadata:
    (DBSHARINGSharedLinkAlreadyExistsMetadata *)aSharedLinkAlreadyExistsMetadata {
  if (self == aSharedLinkAlreadyExistsMetadata) {
    return YES;
  }
  if (self.tag != aSharedLinkAlreadyExistsMetadata.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedLinkAlreadyExistsMetadataMetadata:
    return [self.metadata isEqual:aSharedLinkAlreadyExistsMetadata.metadata];
  case DBSHARINGSharedLinkAlreadyExistsMetadataOther:
    return [[self tagName] isEqual:[aSharedLinkAlreadyExistsMetadata tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkAlreadyExistsMetadataSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkAlreadyExistsMetadata *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isMetadata]) {
    jsonDict[@"metadata"] = [[DBSHARINGSharedLinkMetadataSerializer serialize:valueObj.metadata] mutableCopy];
    jsonDict[@".tag"] = @"metadata";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkAlreadyExistsMetadata *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"metadata"]) {
    DBSHARINGSharedLinkMetadata *metadata = [DBSHARINGSharedLinkMetadataSerializer deserialize:valueDict[@"metadata"]];
    return [[DBSHARINGSharedLinkAlreadyExistsMetadata alloc] initWithMetadata:metadata];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedLinkAlreadyExistsMetadata alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedLinkAlreadyExistsMetadata alloc] initWithOther];
  }
}

@end

#import "DBSHARINGSharedLinkPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkPolicy

#pragma mark - Constructors

- (instancetype)initWithAnyone {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkPolicyAnyone;
  }
  return self;
}

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkPolicyTeam;
  }
  return self;
}

- (instancetype)initWithMembers {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkPolicyMembers;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAnyone {
  return _tag == DBSHARINGSharedLinkPolicyAnyone;
}

- (BOOL)isTeam {
  return _tag == DBSHARINGSharedLinkPolicyTeam;
}

- (BOOL)isMembers {
  return _tag == DBSHARINGSharedLinkPolicyMembers;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharedLinkPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedLinkPolicyAnyone:
    return @"DBSHARINGSharedLinkPolicyAnyone";
  case DBSHARINGSharedLinkPolicyTeam:
    return @"DBSHARINGSharedLinkPolicyTeam";
  case DBSHARINGSharedLinkPolicyMembers:
    return @"DBSHARINGSharedLinkPolicyMembers";
  case DBSHARINGSharedLinkPolicyOther:
    return @"DBSHARINGSharedLinkPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedLinkPolicyAnyone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkPolicyTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkPolicyMembers:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkPolicy:other];
}

- (BOOL)isEqualToSharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)aSharedLinkPolicy {
  if (self == aSharedLinkPolicy) {
    return YES;
  }
  if (self.tag != aSharedLinkPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedLinkPolicyAnyone:
    return [[self tagName] isEqual:[aSharedLinkPolicy tagName]];
  case DBSHARINGSharedLinkPolicyTeam:
    return [[self tagName] isEqual:[aSharedLinkPolicy tagName]];
  case DBSHARINGSharedLinkPolicyMembers:
    return [[self tagName] isEqual:[aSharedLinkPolicy tagName]];
  case DBSHARINGSharedLinkPolicyOther:
    return [[self tagName] isEqual:[aSharedLinkPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAnyone]) {
    jsonDict[@".tag"] = @"anyone";
  } else if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isMembers]) {
    jsonDict[@".tag"] = @"members";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"anyone"]) {
    return [[DBSHARINGSharedLinkPolicy alloc] initWithAnyone];
  } else if ([tag isEqualToString:@"team"]) {
    return [[DBSHARINGSharedLinkPolicy alloc] initWithTeam];
  } else if ([tag isEqualToString:@"members"]) {
    return [[DBSHARINGSharedLinkPolicy alloc] initWithMembers];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharedLinkPolicy alloc] initWithOther];
  } else {
    return [[DBSHARINGSharedLinkPolicy alloc] initWithOther];
  }
}

@end

#import "DBSHARINGLinkAudience.h"
#import "DBSHARINGRequestedLinkAccessLevel.h"
#import "DBSHARINGRequestedVisibility.h"
#import "DBSHARINGSharedLinkSettings.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkSettings

#pragma mark - Constructors

- (instancetype)initWithRequestedVisibility:(DBSHARINGRequestedVisibility *)requestedVisibility
                               linkPassword:(NSString *)linkPassword
                                    expires:(NSDate *)expires
                                   audience:(DBSHARINGLinkAudience *)audience
                                     access:(DBSHARINGRequestedLinkAccessLevel *)access {

  self = [super init];
  if (self) {
    _requestedVisibility = requestedVisibility;
    _linkPassword = linkPassword;
    _expires = expires;
    _audience = audience;
    _access = access;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithRequestedVisibility:nil linkPassword:nil expires:nil audience:nil access:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkSettingsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkSettingsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkSettingsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.requestedVisibility != nil) {
    result = prime * result + [self.requestedVisibility hash];
  }
  if (self.linkPassword != nil) {
    result = prime * result + [self.linkPassword hash];
  }
  if (self.expires != nil) {
    result = prime * result + [self.expires hash];
  }
  if (self.audience != nil) {
    result = prime * result + [self.audience hash];
  }
  if (self.access != nil) {
    result = prime * result + [self.access hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkSettings:other];
}

- (BOOL)isEqualToSharedLinkSettings:(DBSHARINGSharedLinkSettings *)aSharedLinkSettings {
  if (self == aSharedLinkSettings) {
    return YES;
  }
  if (self.requestedVisibility) {
    if (![self.requestedVisibility isEqual:aSharedLinkSettings.requestedVisibility]) {
      return NO;
    }
  }
  if (self.linkPassword) {
    if (![self.linkPassword isEqual:aSharedLinkSettings.linkPassword]) {
      return NO;
    }
  }
  if (self.expires) {
    if (![self.expires isEqual:aSharedLinkSettings.expires]) {
      return NO;
    }
  }
  if (self.audience) {
    if (![self.audience isEqual:aSharedLinkSettings.audience]) {
      return NO;
    }
  }
  if (self.access) {
    if (![self.access isEqual:aSharedLinkSettings.access]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkSettingsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkSettings *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.requestedVisibility) {
    jsonDict[@"requested_visibility"] = [DBSHARINGRequestedVisibilitySerializer serialize:valueObj.requestedVisibility];
  }
  if (valueObj.linkPassword) {
    jsonDict[@"link_password"] = valueObj.linkPassword;
  }
  if (valueObj.expires) {
    jsonDict[@"expires"] = [DBNSDateSerializer serialize:valueObj.expires dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.audience) {
    jsonDict[@"audience"] = [DBSHARINGLinkAudienceSerializer serialize:valueObj.audience];
  }
  if (valueObj.access) {
    jsonDict[@"access"] = [DBSHARINGRequestedLinkAccessLevelSerializer serialize:valueObj.access];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkSettings *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGRequestedVisibility *requestedVisibility =
      valueDict[@"requested_visibility"]
          ? [DBSHARINGRequestedVisibilitySerializer deserialize:valueDict[@"requested_visibility"]]
          : nil;
  NSString *linkPassword = valueDict[@"link_password"] ?: nil;
  NSDate *expires = valueDict[@"expires"]
                        ? [DBNSDateSerializer deserialize:valueDict[@"expires"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                        : nil;
  DBSHARINGLinkAudience *audience =
      valueDict[@"audience"] ? [DBSHARINGLinkAudienceSerializer deserialize:valueDict[@"audience"]] : nil;
  DBSHARINGRequestedLinkAccessLevel *access =
      valueDict[@"access"] ? [DBSHARINGRequestedLinkAccessLevelSerializer deserialize:valueDict[@"access"]] : nil;

  return [[DBSHARINGSharedLinkSettings alloc] initWithRequestedVisibility:requestedVisibility
                                                             linkPassword:linkPassword
                                                                  expires:expires
                                                                 audience:audience
                                                                   access:access];
}

@end

#import "DBSHARINGSharedLinkSettingsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharedLinkSettingsError

#pragma mark - Constructors

- (instancetype)initWithInvalidSettings {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkSettingsErrorInvalidSettings;
  }
  return self;
}

- (instancetype)initWithNotAuthorized {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharedLinkSettingsErrorNotAuthorized;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInvalidSettings {
  return _tag == DBSHARINGSharedLinkSettingsErrorInvalidSettings;
}

- (BOOL)isNotAuthorized {
  return _tag == DBSHARINGSharedLinkSettingsErrorNotAuthorized;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharedLinkSettingsErrorInvalidSettings:
    return @"DBSHARINGSharedLinkSettingsErrorInvalidSettings";
  case DBSHARINGSharedLinkSettingsErrorNotAuthorized:
    return @"DBSHARINGSharedLinkSettingsErrorNotAuthorized";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharedLinkSettingsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharedLinkSettingsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharedLinkSettingsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharedLinkSettingsErrorInvalidSettings:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharedLinkSettingsErrorNotAuthorized:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharedLinkSettingsError:other];
}

- (BOOL)isEqualToSharedLinkSettingsError:(DBSHARINGSharedLinkSettingsError *)aSharedLinkSettingsError {
  if (self == aSharedLinkSettingsError) {
    return YES;
  }
  if (self.tag != aSharedLinkSettingsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharedLinkSettingsErrorInvalidSettings:
    return [[self tagName] isEqual:[aSharedLinkSettingsError tagName]];
  case DBSHARINGSharedLinkSettingsErrorNotAuthorized:
    return [[self tagName] isEqual:[aSharedLinkSettingsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharedLinkSettingsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharedLinkSettingsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInvalidSettings]) {
    jsonDict[@".tag"] = @"invalid_settings";
  } else if ([valueObj isNotAuthorized]) {
    jsonDict[@".tag"] = @"not_authorized";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharedLinkSettingsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"invalid_settings"]) {
    return [[DBSHARINGSharedLinkSettingsError alloc] initWithInvalidSettings];
  } else if ([tag isEqualToString:@"not_authorized"]) {
    return [[DBSHARINGSharedLinkSettingsError alloc] initWithNotAuthorized];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBSHARINGSharingFileAccessError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharingFileAccessError

#pragma mark - Constructors

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithInvalidFile {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorInvalidFile;
  }
  return self;
}

- (instancetype)initWithIsFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorIsFolder;
  }
  return self;
}

- (instancetype)initWithInsidePublicFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorInsidePublicFolder;
  }
  return self;
}

- (instancetype)initWithInsideOsxPackage {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorInsideOsxPackage;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingFileAccessErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isNoPermission {
  return _tag == DBSHARINGSharingFileAccessErrorNoPermission;
}

- (BOOL)isInvalidFile {
  return _tag == DBSHARINGSharingFileAccessErrorInvalidFile;
}

- (BOOL)isIsFolder {
  return _tag == DBSHARINGSharingFileAccessErrorIsFolder;
}

- (BOOL)isInsidePublicFolder {
  return _tag == DBSHARINGSharingFileAccessErrorInsidePublicFolder;
}

- (BOOL)isInsideOsxPackage {
  return _tag == DBSHARINGSharingFileAccessErrorInsideOsxPackage;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharingFileAccessErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharingFileAccessErrorNoPermission:
    return @"DBSHARINGSharingFileAccessErrorNoPermission";
  case DBSHARINGSharingFileAccessErrorInvalidFile:
    return @"DBSHARINGSharingFileAccessErrorInvalidFile";
  case DBSHARINGSharingFileAccessErrorIsFolder:
    return @"DBSHARINGSharingFileAccessErrorIsFolder";
  case DBSHARINGSharingFileAccessErrorInsidePublicFolder:
    return @"DBSHARINGSharingFileAccessErrorInsidePublicFolder";
  case DBSHARINGSharingFileAccessErrorInsideOsxPackage:
    return @"DBSHARINGSharingFileAccessErrorInsideOsxPackage";
  case DBSHARINGSharingFileAccessErrorOther:
    return @"DBSHARINGSharingFileAccessErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharingFileAccessErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharingFileAccessErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharingFileAccessErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharingFileAccessErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingFileAccessErrorInvalidFile:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingFileAccessErrorIsFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingFileAccessErrorInsidePublicFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingFileAccessErrorInsideOsxPackage:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingFileAccessErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingFileAccessError:other];
}

- (BOOL)isEqualToSharingFileAccessError:(DBSHARINGSharingFileAccessError *)aSharingFileAccessError {
  if (self == aSharingFileAccessError) {
    return YES;
  }
  if (self.tag != aSharingFileAccessError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharingFileAccessErrorNoPermission:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  case DBSHARINGSharingFileAccessErrorInvalidFile:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  case DBSHARINGSharingFileAccessErrorIsFolder:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  case DBSHARINGSharingFileAccessErrorInsidePublicFolder:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  case DBSHARINGSharingFileAccessErrorInsideOsxPackage:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  case DBSHARINGSharingFileAccessErrorOther:
    return [[self tagName] isEqual:[aSharingFileAccessError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharingFileAccessErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharingFileAccessError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isInvalidFile]) {
    jsonDict[@".tag"] = @"invalid_file";
  } else if ([valueObj isIsFolder]) {
    jsonDict[@".tag"] = @"is_folder";
  } else if ([valueObj isInsidePublicFolder]) {
    jsonDict[@".tag"] = @"inside_public_folder";
  } else if ([valueObj isInsideOsxPackage]) {
    jsonDict[@".tag"] = @"inside_osx_package";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharingFileAccessError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"invalid_file"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithInvalidFile];
  } else if ([tag isEqualToString:@"is_folder"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithIsFolder];
  } else if ([tag isEqualToString:@"inside_public_folder"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithInsidePublicFolder];
  } else if ([tag isEqualToString:@"inside_osx_package"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithInsideOsxPackage];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharingFileAccessError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharingFileAccessError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGSharingUserError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGSharingUserError

#pragma mark - Constructors

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingUserErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGSharingUserErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEmailUnverified {
  return _tag == DBSHARINGSharingUserErrorEmailUnverified;
}

- (BOOL)isOther {
  return _tag == DBSHARINGSharingUserErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGSharingUserErrorEmailUnverified:
    return @"DBSHARINGSharingUserErrorEmailUnverified";
  case DBSHARINGSharingUserErrorOther:
    return @"DBSHARINGSharingUserErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGSharingUserErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGSharingUserErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGSharingUserErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGSharingUserErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGSharingUserErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingUserError:other];
}

- (BOOL)isEqualToSharingUserError:(DBSHARINGSharingUserError *)aSharingUserError {
  if (self == aSharingUserError) {
    return YES;
  }
  if (self.tag != aSharingUserError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGSharingUserErrorEmailUnverified:
    return [[self tagName] isEqual:[aSharingUserError tagName]];
  case DBSHARINGSharingUserErrorOther:
    return [[self tagName] isEqual:[aSharingUserError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGSharingUserErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGSharingUserError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGSharingUserError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBSHARINGSharingUserError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGSharingUserError alloc] initWithOther];
  } else {
    return [[DBSHARINGSharingUserError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGTeamMemberInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"
#import "DBUSERSTeam.h"

#pragma mark - API Object

@implementation DBSHARINGTeamMemberInfo

#pragma mark - Constructors

- (instancetype)initWithTeamInfo:(DBUSERSTeam *)teamInfo
                     displayName:(NSString *)displayName
                        memberId:(NSString *)memberId {
  [DBStoneValidators nonnullValidator:nil](teamInfo);
  [DBStoneValidators nonnullValidator:nil](displayName);

  self = [super init];
  if (self) {
    _teamInfo = teamInfo;
    _displayName = displayName;
    _memberId = memberId;
  }
  return self;
}

- (instancetype)initWithTeamInfo:(DBUSERSTeam *)teamInfo displayName:(NSString *)displayName {
  return [self initWithTeamInfo:teamInfo displayName:displayName memberId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGTeamMemberInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGTeamMemberInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGTeamMemberInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.teamInfo hash];
  result = prime * result + [self.displayName hash];
  if (self.memberId != nil) {
    result = prime * result + [self.memberId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTeamMemberInfo:other];
}

- (BOOL)isEqualToTeamMemberInfo:(DBSHARINGTeamMemberInfo *)aTeamMemberInfo {
  if (self == aTeamMemberInfo) {
    return YES;
  }
  if (![self.teamInfo isEqual:aTeamMemberInfo.teamInfo]) {
    return NO;
  }
  if (![self.displayName isEqual:aTeamMemberInfo.displayName]) {
    return NO;
  }
  if (self.memberId) {
    if (![self.memberId isEqual:aTeamMemberInfo.memberId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGTeamMemberInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGTeamMemberInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"team_info"] = [DBUSERSTeamSerializer serialize:valueObj.teamInfo];
  jsonDict[@"display_name"] = valueObj.displayName;
  if (valueObj.memberId) {
    jsonDict[@"member_id"] = valueObj.memberId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGTeamMemberInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBUSERSTeam *teamInfo = [DBUSERSTeamSerializer deserialize:valueDict[@"team_info"]];
  NSString *displayName = valueDict[@"display_name"];
  NSString *memberId = valueDict[@"member_id"] ?: nil;

  return [[DBSHARINGTeamMemberInfo alloc] initWithTeamInfo:teamInfo displayName:displayName memberId:memberId];
}

@end

#import "DBSHARINGTransferFolderArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGTransferFolderArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId toDropboxId:(NSString *)toDropboxId {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](toDropboxId);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _toDropboxId = toDropboxId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGTransferFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGTransferFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGTransferFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.toDropboxId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTransferFolderArg:other];
}

- (BOOL)isEqualToTransferFolderArg:(DBSHARINGTransferFolderArg *)aTransferFolderArg {
  if (self == aTransferFolderArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:aTransferFolderArg.sharedFolderId]) {
    return NO;
  }
  if (![self.toDropboxId isEqual:aTransferFolderArg.toDropboxId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGTransferFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGTransferFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"to_dropbox_id"] = valueObj.toDropboxId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGTransferFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSString *toDropboxId = valueDict[@"to_dropbox_id"];

  return [[DBSHARINGTransferFolderArg alloc] initWithSharedFolderId:sharedFolderId toDropboxId:toDropboxId];
}

@end

#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGTransferFolderError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGTransferFolderError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithInvalidDropboxId {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorInvalidDropboxId;
  }
  return self;
}

- (instancetype)initWithDNewOwnerNotAMember {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorDNewOwnerNotAMember;
  }
  return self;
}

- (instancetype)initWithDNewOwnerUnmounted {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorDNewOwnerUnmounted;
  }
  return self;
}

- (instancetype)initWithDNewOwnerEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGTransferFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGTransferFolderErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGTransferFolderErrorAccessError;
}

- (BOOL)isInvalidDropboxId {
  return _tag == DBSHARINGTransferFolderErrorInvalidDropboxId;
}

- (BOOL)isDNewOwnerNotAMember {
  return _tag == DBSHARINGTransferFolderErrorDNewOwnerNotAMember;
}

- (BOOL)isDNewOwnerUnmounted {
  return _tag == DBSHARINGTransferFolderErrorDNewOwnerUnmounted;
}

- (BOOL)isDNewOwnerEmailUnverified {
  return _tag == DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGTransferFolderErrorTeamFolder;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGTransferFolderErrorNoPermission;
}

- (BOOL)isOther {
  return _tag == DBSHARINGTransferFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGTransferFolderErrorAccessError:
    return @"DBSHARINGTransferFolderErrorAccessError";
  case DBSHARINGTransferFolderErrorInvalidDropboxId:
    return @"DBSHARINGTransferFolderErrorInvalidDropboxId";
  case DBSHARINGTransferFolderErrorDNewOwnerNotAMember:
    return @"DBSHARINGTransferFolderErrorDNewOwnerNotAMember";
  case DBSHARINGTransferFolderErrorDNewOwnerUnmounted:
    return @"DBSHARINGTransferFolderErrorDNewOwnerUnmounted";
  case DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified:
    return @"DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified";
  case DBSHARINGTransferFolderErrorTeamFolder:
    return @"DBSHARINGTransferFolderErrorTeamFolder";
  case DBSHARINGTransferFolderErrorNoPermission:
    return @"DBSHARINGTransferFolderErrorNoPermission";
  case DBSHARINGTransferFolderErrorOther:
    return @"DBSHARINGTransferFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGTransferFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGTransferFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGTransferFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGTransferFolderErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGTransferFolderErrorInvalidDropboxId:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorDNewOwnerNotAMember:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorDNewOwnerUnmounted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGTransferFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToTransferFolderError:other];
}

- (BOOL)isEqualToTransferFolderError:(DBSHARINGTransferFolderError *)aTransferFolderError {
  if (self == aTransferFolderError) {
    return YES;
  }
  if (self.tag != aTransferFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGTransferFolderErrorAccessError:
    return [self.accessError isEqual:aTransferFolderError.accessError];
  case DBSHARINGTransferFolderErrorInvalidDropboxId:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorDNewOwnerNotAMember:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorDNewOwnerUnmounted:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorDNewOwnerEmailUnverified:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorTeamFolder:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorNoPermission:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  case DBSHARINGTransferFolderErrorOther:
    return [[self tagName] isEqual:[aTransferFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGTransferFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGTransferFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isInvalidDropboxId]) {
    jsonDict[@".tag"] = @"invalid_dropbox_id";
  } else if ([valueObj isDNewOwnerNotAMember]) {
    jsonDict[@".tag"] = @"new_owner_not_a_member";
  } else if ([valueObj isDNewOwnerUnmounted]) {
    jsonDict[@".tag"] = @"new_owner_unmounted";
  } else if ([valueObj isDNewOwnerEmailUnverified]) {
    jsonDict[@".tag"] = @"new_owner_email_unverified";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGTransferFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGTransferFolderError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"invalid_dropbox_id"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithInvalidDropboxId];
  } else if ([tag isEqualToString:@"new_owner_not_a_member"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithDNewOwnerNotAMember];
  } else if ([tag isEqualToString:@"new_owner_unmounted"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithDNewOwnerUnmounted];
  } else if ([tag isEqualToString:@"new_owner_email_unverified"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithDNewOwnerEmailUnverified];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGTransferFolderError alloc] initWithOther];
  } else {
    return [[DBSHARINGTransferFolderError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGUnmountFolderArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnmountFolderArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnmountFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnmountFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnmountFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnmountFolderArg:other];
}

- (BOOL)isEqualToUnmountFolderArg:(DBSHARINGUnmountFolderArg *)anUnmountFolderArg {
  if (self == anUnmountFolderArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anUnmountFolderArg.sharedFolderId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnmountFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnmountFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnmountFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];

  return [[DBSHARINGUnmountFolderArg alloc] initWithSharedFolderId:sharedFolderId];
}

@end

#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGUnmountFolderError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnmountFolderError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnmountFolderErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnmountFolderErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithNotUnmountable {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnmountFolderErrorNotUnmountable;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnmountFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGUnmountFolderErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGUnmountFolderErrorAccessError;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGUnmountFolderErrorNoPermission;
}

- (BOOL)isNotUnmountable {
  return _tag == DBSHARINGUnmountFolderErrorNotUnmountable;
}

- (BOOL)isOther {
  return _tag == DBSHARINGUnmountFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGUnmountFolderErrorAccessError:
    return @"DBSHARINGUnmountFolderErrorAccessError";
  case DBSHARINGUnmountFolderErrorNoPermission:
    return @"DBSHARINGUnmountFolderErrorNoPermission";
  case DBSHARINGUnmountFolderErrorNotUnmountable:
    return @"DBSHARINGUnmountFolderErrorNotUnmountable";
  case DBSHARINGUnmountFolderErrorOther:
    return @"DBSHARINGUnmountFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnmountFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnmountFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnmountFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGUnmountFolderErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGUnmountFolderErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUnmountFolderErrorNotUnmountable:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUnmountFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnmountFolderError:other];
}

- (BOOL)isEqualToUnmountFolderError:(DBSHARINGUnmountFolderError *)anUnmountFolderError {
  if (self == anUnmountFolderError) {
    return YES;
  }
  if (self.tag != anUnmountFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGUnmountFolderErrorAccessError:
    return [self.accessError isEqual:anUnmountFolderError.accessError];
  case DBSHARINGUnmountFolderErrorNoPermission:
    return [[self tagName] isEqual:[anUnmountFolderError tagName]];
  case DBSHARINGUnmountFolderErrorNotUnmountable:
    return [[self tagName] isEqual:[anUnmountFolderError tagName]];
  case DBSHARINGUnmountFolderErrorOther:
    return [[self tagName] isEqual:[anUnmountFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnmountFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnmountFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isNotUnmountable]) {
    jsonDict[@".tag"] = @"not_unmountable";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnmountFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGUnmountFolderError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGUnmountFolderError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"not_unmountable"]) {
    return [[DBSHARINGUnmountFolderError alloc] initWithNotUnmountable];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGUnmountFolderError alloc] initWithOther];
  } else {
    return [[DBSHARINGUnmountFolderError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGUnshareFileArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnshareFileArg

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);

  self = [super init];
  if (self) {
    _file = file;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnshareFileArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnshareFileArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnshareFileArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnshareFileArg:other];
}

- (BOOL)isEqualToUnshareFileArg:(DBSHARINGUnshareFileArg *)anUnshareFileArg {
  if (self == anUnshareFileArg) {
    return YES;
  }
  if (![self.file isEqual:anUnshareFileArg.file]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnshareFileArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnshareFileArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnshareFileArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];

  return [[DBSHARINGUnshareFileArg alloc] initWithFile:file];
}

@end

#import "DBSHARINGSharingFileAccessError.h"
#import "DBSHARINGSharingUserError.h"
#import "DBSHARINGUnshareFileError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnshareFileError

@synthesize userError = _userError;
@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithUserError:(DBSHARINGSharingUserError *)userError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFileErrorUserError;
    _userError = userError;
  }
  return self;
}

- (instancetype)initWithAccessError:(DBSHARINGSharingFileAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFileErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFileErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharingUserError *)userError {
  if (![self isUserError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGUnshareFileErrorUserError, but was %@.", [self tagName]];
  }
  return _userError;
}

- (DBSHARINGSharingFileAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGUnshareFileErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isUserError {
  return _tag == DBSHARINGUnshareFileErrorUserError;
}

- (BOOL)isAccessError {
  return _tag == DBSHARINGUnshareFileErrorAccessError;
}

- (BOOL)isOther {
  return _tag == DBSHARINGUnshareFileErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGUnshareFileErrorUserError:
    return @"DBSHARINGUnshareFileErrorUserError";
  case DBSHARINGUnshareFileErrorAccessError:
    return @"DBSHARINGUnshareFileErrorAccessError";
  case DBSHARINGUnshareFileErrorOther:
    return @"DBSHARINGUnshareFileErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnshareFileErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnshareFileErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnshareFileErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGUnshareFileErrorUserError:
    result = prime * result + [self.userError hash];
    break;
  case DBSHARINGUnshareFileErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGUnshareFileErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnshareFileError:other];
}

- (BOOL)isEqualToUnshareFileError:(DBSHARINGUnshareFileError *)anUnshareFileError {
  if (self == anUnshareFileError) {
    return YES;
  }
  if (self.tag != anUnshareFileError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGUnshareFileErrorUserError:
    return [self.userError isEqual:anUnshareFileError.userError];
  case DBSHARINGUnshareFileErrorAccessError:
    return [self.accessError isEqual:anUnshareFileError.accessError];
  case DBSHARINGUnshareFileErrorOther:
    return [[self tagName] isEqual:[anUnshareFileError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnshareFileErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnshareFileError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isUserError]) {
    jsonDict[@"user_error"] = [[DBSHARINGSharingUserErrorSerializer serialize:valueObj.userError] mutableCopy];
    jsonDict[@".tag"] = @"user_error";
  } else if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharingFileAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnshareFileError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"user_error"]) {
    DBSHARINGSharingUserError *userError = [DBSHARINGSharingUserErrorSerializer deserialize:valueDict[@"user_error"]];
    return [[DBSHARINGUnshareFileError alloc] initWithUserError:userError];
  } else if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharingFileAccessError *accessError =
        [DBSHARINGSharingFileAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGUnshareFileError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGUnshareFileError alloc] initWithOther];
  } else {
    return [[DBSHARINGUnshareFileError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGUnshareFolderArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnshareFolderArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId leaveACopy:(NSNumber *)leaveACopy {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _leaveACopy = leaveACopy ?: @NO;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId leaveACopy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnshareFolderArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnshareFolderArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnshareFolderArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.leaveACopy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnshareFolderArg:other];
}

- (BOOL)isEqualToUnshareFolderArg:(DBSHARINGUnshareFolderArg *)anUnshareFolderArg {
  if (self == anUnshareFolderArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anUnshareFolderArg.sharedFolderId]) {
    return NO;
  }
  if (![self.leaveACopy isEqual:anUnshareFolderArg.leaveACopy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnshareFolderArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnshareFolderArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"leave_a_copy"] = valueObj.leaveACopy;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnshareFolderArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  NSNumber *leaveACopy = valueDict[@"leave_a_copy"] ?: @NO;

  return [[DBSHARINGUnshareFolderArg alloc] initWithSharedFolderId:sharedFolderId leaveACopy:leaveACopy];
}

@end

#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGUnshareFolderError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUnshareFolderError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFolderErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFolderErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFolderErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithTooManyFiles {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFolderErrorTooManyFiles;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUnshareFolderErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBSHARINGUnshareFolderErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGUnshareFolderErrorAccessError;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGUnshareFolderErrorTeamFolder;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGUnshareFolderErrorNoPermission;
}

- (BOOL)isTooManyFiles {
  return _tag == DBSHARINGUnshareFolderErrorTooManyFiles;
}

- (BOOL)isOther {
  return _tag == DBSHARINGUnshareFolderErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGUnshareFolderErrorAccessError:
    return @"DBSHARINGUnshareFolderErrorAccessError";
  case DBSHARINGUnshareFolderErrorTeamFolder:
    return @"DBSHARINGUnshareFolderErrorTeamFolder";
  case DBSHARINGUnshareFolderErrorNoPermission:
    return @"DBSHARINGUnshareFolderErrorNoPermission";
  case DBSHARINGUnshareFolderErrorTooManyFiles:
    return @"DBSHARINGUnshareFolderErrorTooManyFiles";
  case DBSHARINGUnshareFolderErrorOther:
    return @"DBSHARINGUnshareFolderErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUnshareFolderErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUnshareFolderErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUnshareFolderErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGUnshareFolderErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGUnshareFolderErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUnshareFolderErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUnshareFolderErrorTooManyFiles:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUnshareFolderErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUnshareFolderError:other];
}

- (BOOL)isEqualToUnshareFolderError:(DBSHARINGUnshareFolderError *)anUnshareFolderError {
  if (self == anUnshareFolderError) {
    return YES;
  }
  if (self.tag != anUnshareFolderError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGUnshareFolderErrorAccessError:
    return [self.accessError isEqual:anUnshareFolderError.accessError];
  case DBSHARINGUnshareFolderErrorTeamFolder:
    return [[self tagName] isEqual:[anUnshareFolderError tagName]];
  case DBSHARINGUnshareFolderErrorNoPermission:
    return [[self tagName] isEqual:[anUnshareFolderError tagName]];
  case DBSHARINGUnshareFolderErrorTooManyFiles:
    return [[self tagName] isEqual:[anUnshareFolderError tagName]];
  case DBSHARINGUnshareFolderErrorOther:
    return [[self tagName] isEqual:[anUnshareFolderError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUnshareFolderErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUnshareFolderError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isTooManyFiles]) {
    jsonDict[@".tag"] = @"too_many_files";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUnshareFolderError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGUnshareFolderError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGUnshareFolderError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGUnshareFolderError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"too_many_files"]) {
    return [[DBSHARINGUnshareFolderError alloc] initWithTooManyFiles];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGUnshareFolderError alloc] initWithOther];
  } else {
    return [[DBSHARINGUnshareFolderError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGChangeFileMemberAccessArgs.h"
#import "DBSHARINGMemberSelector.h"
#import "DBSHARINGUpdateFileMemberArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUpdateFileMemberArgs

#pragma mark - Constructors

- (instancetype)initWithFile:(NSString *)file
                      member:(DBSHARINGMemberSelector *)member
                 accessLevel:(DBSHARINGAccessLevel *)accessLevel {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                             maxLength:nil
                                               pattern:@"((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?"]](file);
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](accessLevel);

  self = [super initWithFile:file member:member accessLevel:accessLevel];
  if (self) {
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUpdateFileMemberArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUpdateFileMemberArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUpdateFileMemberArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.file hash];
  result = prime * result + [self.member hash];
  result = prime * result + [self.accessLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFileMemberArgs:other];
}

- (BOOL)isEqualToUpdateFileMemberArgs:(DBSHARINGUpdateFileMemberArgs *)anUpdateFileMemberArgs {
  if (self == anUpdateFileMemberArgs) {
    return YES;
  }
  if (![self.file isEqual:anUpdateFileMemberArgs.file]) {
    return NO;
  }
  if (![self.member isEqual:anUpdateFileMemberArgs.member]) {
    return NO;
  }
  if (![self.accessLevel isEqual:anUpdateFileMemberArgs.accessLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUpdateFileMemberArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFileMemberArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file"] = valueObj.file;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUpdateFileMemberArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *file = valueDict[@"file"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBSHARINGAccessLevel *accessLevel = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]];

  return [[DBSHARINGUpdateFileMemberArgs alloc] initWithFile:file member:member accessLevel:accessLevel];
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGMemberSelector.h"
#import "DBSHARINGUpdateFolderMemberArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUpdateFolderMemberArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                                member:(DBSHARINGMemberSelector *)member
                           accessLevel:(DBSHARINGAccessLevel *)accessLevel {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](accessLevel);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _member = member;
    _accessLevel = accessLevel;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUpdateFolderMemberArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUpdateFolderMemberArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUpdateFolderMemberArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  result = prime * result + [self.member hash];
  result = prime * result + [self.accessLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFolderMemberArg:other];
}

- (BOOL)isEqualToUpdateFolderMemberArg:(DBSHARINGUpdateFolderMemberArg *)anUpdateFolderMemberArg {
  if (self == anUpdateFolderMemberArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anUpdateFolderMemberArg.sharedFolderId]) {
    return NO;
  }
  if (![self.member isEqual:anUpdateFolderMemberArg.member]) {
    return NO;
  }
  if (![self.accessLevel isEqual:anUpdateFolderMemberArg.accessLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUpdateFolderMemberArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderMemberArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"access_level"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUpdateFolderMemberArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBSHARINGAccessLevel *accessLevel = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_level"]];

  return [[DBSHARINGUpdateFolderMemberArg alloc] initWithSharedFolderId:sharedFolderId
                                                                 member:member
                                                            accessLevel:accessLevel];
}

@end

#import "DBSHARINGAddFolderMemberError.h"
#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGSharedFolderMemberError.h"
#import "DBSHARINGUpdateFolderMemberError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUpdateFolderMemberError

@synthesize accessError = _accessError;
@synthesize memberError = _memberError;
@synthesize noExplicitAccess = _noExplicitAccess;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithMemberError:(DBSHARINGSharedFolderMemberError *)memberError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorMemberError;
    _memberError = memberError;
  }
  return self;
}

- (instancetype)initWithNoExplicitAccess:(DBSHARINGAddFolderMemberError *)noExplicitAccess {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorNoExplicitAccess;
    _noExplicitAccess = noExplicitAccess;
  }
  return self;
}

- (instancetype)initWithInsufficientPlan {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorInsufficientPlan;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderMemberErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGUpdateFolderMemberErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

- (DBSHARINGSharedFolderMemberError *)memberError {
  if (![self isMemberError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGUpdateFolderMemberErrorMemberError, but was %@.", [self tagName]];
  }
  return _memberError;
}

- (DBSHARINGAddFolderMemberError *)noExplicitAccess {
  if (![self isNoExplicitAccess]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGUpdateFolderMemberErrorNoExplicitAccess, but was %@.", [self tagName]];
  }
  return _noExplicitAccess;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGUpdateFolderMemberErrorAccessError;
}

- (BOOL)isMemberError {
  return _tag == DBSHARINGUpdateFolderMemberErrorMemberError;
}

- (BOOL)isNoExplicitAccess {
  return _tag == DBSHARINGUpdateFolderMemberErrorNoExplicitAccess;
}

- (BOOL)isInsufficientPlan {
  return _tag == DBSHARINGUpdateFolderMemberErrorInsufficientPlan;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGUpdateFolderMemberErrorNoPermission;
}

- (BOOL)isOther {
  return _tag == DBSHARINGUpdateFolderMemberErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGUpdateFolderMemberErrorAccessError:
    return @"DBSHARINGUpdateFolderMemberErrorAccessError";
  case DBSHARINGUpdateFolderMemberErrorMemberError:
    return @"DBSHARINGUpdateFolderMemberErrorMemberError";
  case DBSHARINGUpdateFolderMemberErrorNoExplicitAccess:
    return @"DBSHARINGUpdateFolderMemberErrorNoExplicitAccess";
  case DBSHARINGUpdateFolderMemberErrorInsufficientPlan:
    return @"DBSHARINGUpdateFolderMemberErrorInsufficientPlan";
  case DBSHARINGUpdateFolderMemberErrorNoPermission:
    return @"DBSHARINGUpdateFolderMemberErrorNoPermission";
  case DBSHARINGUpdateFolderMemberErrorOther:
    return @"DBSHARINGUpdateFolderMemberErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUpdateFolderMemberErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUpdateFolderMemberErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUpdateFolderMemberErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGUpdateFolderMemberErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGUpdateFolderMemberErrorMemberError:
    result = prime * result + [self.memberError hash];
    break;
  case DBSHARINGUpdateFolderMemberErrorNoExplicitAccess:
    result = prime * result + [self.noExplicitAccess hash];
    break;
  case DBSHARINGUpdateFolderMemberErrorInsufficientPlan:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderMemberErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderMemberErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFolderMemberError:other];
}

- (BOOL)isEqualToUpdateFolderMemberError:(DBSHARINGUpdateFolderMemberError *)anUpdateFolderMemberError {
  if (self == anUpdateFolderMemberError) {
    return YES;
  }
  if (self.tag != anUpdateFolderMemberError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGUpdateFolderMemberErrorAccessError:
    return [self.accessError isEqual:anUpdateFolderMemberError.accessError];
  case DBSHARINGUpdateFolderMemberErrorMemberError:
    return [self.memberError isEqual:anUpdateFolderMemberError.memberError];
  case DBSHARINGUpdateFolderMemberErrorNoExplicitAccess:
    return [self.noExplicitAccess isEqual:anUpdateFolderMemberError.noExplicitAccess];
  case DBSHARINGUpdateFolderMemberErrorInsufficientPlan:
    return [[self tagName] isEqual:[anUpdateFolderMemberError tagName]];
  case DBSHARINGUpdateFolderMemberErrorNoPermission:
    return [[self tagName] isEqual:[anUpdateFolderMemberError tagName]];
  case DBSHARINGUpdateFolderMemberErrorOther:
    return [[self tagName] isEqual:[anUpdateFolderMemberError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUpdateFolderMemberErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderMemberError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isMemberError]) {
    jsonDict[@"member_error"] =
        [[DBSHARINGSharedFolderMemberErrorSerializer serialize:valueObj.memberError] mutableCopy];
    jsonDict[@".tag"] = @"member_error";
  } else if ([valueObj isNoExplicitAccess]) {
    jsonDict[@"no_explicit_access"] =
        [[DBSHARINGAddFolderMemberErrorSerializer serialize:valueObj.noExplicitAccess] mutableCopy];
    jsonDict[@".tag"] = @"no_explicit_access";
  } else if ([valueObj isInsufficientPlan]) {
    jsonDict[@".tag"] = @"insufficient_plan";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUpdateFolderMemberError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"member_error"]) {
    DBSHARINGSharedFolderMemberError *memberError =
        [DBSHARINGSharedFolderMemberErrorSerializer deserialize:valueDict[@"member_error"]];
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithMemberError:memberError];
  } else if ([tag isEqualToString:@"no_explicit_access"]) {
    DBSHARINGAddFolderMemberError *noExplicitAccess =
        [DBSHARINGAddFolderMemberErrorSerializer deserialize:valueDict[@"no_explicit_access"]];
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithNoExplicitAccess:noExplicitAccess];
  } else if ([tag isEqualToString:@"insufficient_plan"]) {
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithInsufficientPlan];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithOther];
  } else {
    return [[DBSHARINGUpdateFolderMemberError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAclUpdatePolicy.h"
#import "DBSHARINGFolderAction.h"
#import "DBSHARINGLinkSettings.h"
#import "DBSHARINGMemberPolicy.h"
#import "DBSHARINGSharedLinkPolicy.h"
#import "DBSHARINGUpdateFolderPolicyArg.h"
#import "DBSHARINGViewerInfoPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUpdateFolderPolicyArg

#pragma mark - Constructors

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId
                          memberPolicy:(DBSHARINGMemberPolicy *)memberPolicy
                       aclUpdatePolicy:(DBSHARINGAclUpdatePolicy *)aclUpdatePolicy
                      viewerInfoPolicy:(DBSHARINGViewerInfoPolicy *)viewerInfoPolicy
                      sharedLinkPolicy:(DBSHARINGSharedLinkPolicy *)sharedLinkPolicy
                          linkSettings:(DBSHARINGLinkSettings *)linkSettings
                               actions:(NSArray<DBSHARINGFolderAction *> *)actions {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"[-_0-9a-zA-Z:]+"]](sharedFolderId);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](actions);

  self = [super init];
  if (self) {
    _sharedFolderId = sharedFolderId;
    _memberPolicy = memberPolicy;
    _aclUpdatePolicy = aclUpdatePolicy;
    _viewerInfoPolicy = viewerInfoPolicy;
    _sharedLinkPolicy = sharedLinkPolicy;
    _linkSettings = linkSettings;
    _actions = actions;
  }
  return self;
}

- (instancetype)initWithSharedFolderId:(NSString *)sharedFolderId {
  return [self initWithSharedFolderId:sharedFolderId
                         memberPolicy:nil
                      aclUpdatePolicy:nil
                     viewerInfoPolicy:nil
                     sharedLinkPolicy:nil
                         linkSettings:nil
                              actions:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUpdateFolderPolicyArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUpdateFolderPolicyArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUpdateFolderPolicyArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.sharedFolderId hash];
  if (self.memberPolicy != nil) {
    result = prime * result + [self.memberPolicy hash];
  }
  if (self.aclUpdatePolicy != nil) {
    result = prime * result + [self.aclUpdatePolicy hash];
  }
  if (self.viewerInfoPolicy != nil) {
    result = prime * result + [self.viewerInfoPolicy hash];
  }
  if (self.sharedLinkPolicy != nil) {
    result = prime * result + [self.sharedLinkPolicy hash];
  }
  if (self.linkSettings != nil) {
    result = prime * result + [self.linkSettings hash];
  }
  if (self.actions != nil) {
    result = prime * result + [self.actions hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFolderPolicyArg:other];
}

- (BOOL)isEqualToUpdateFolderPolicyArg:(DBSHARINGUpdateFolderPolicyArg *)anUpdateFolderPolicyArg {
  if (self == anUpdateFolderPolicyArg) {
    return YES;
  }
  if (![self.sharedFolderId isEqual:anUpdateFolderPolicyArg.sharedFolderId]) {
    return NO;
  }
  if (self.memberPolicy) {
    if (![self.memberPolicy isEqual:anUpdateFolderPolicyArg.memberPolicy]) {
      return NO;
    }
  }
  if (self.aclUpdatePolicy) {
    if (![self.aclUpdatePolicy isEqual:anUpdateFolderPolicyArg.aclUpdatePolicy]) {
      return NO;
    }
  }
  if (self.viewerInfoPolicy) {
    if (![self.viewerInfoPolicy isEqual:anUpdateFolderPolicyArg.viewerInfoPolicy]) {
      return NO;
    }
  }
  if (self.sharedLinkPolicy) {
    if (![self.sharedLinkPolicy isEqual:anUpdateFolderPolicyArg.sharedLinkPolicy]) {
      return NO;
    }
  }
  if (self.linkSettings) {
    if (![self.linkSettings isEqual:anUpdateFolderPolicyArg.linkSettings]) {
      return NO;
    }
  }
  if (self.actions) {
    if (![self.actions isEqual:anUpdateFolderPolicyArg.actions]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUpdateFolderPolicyArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderPolicyArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"shared_folder_id"] = valueObj.sharedFolderId;
  if (valueObj.memberPolicy) {
    jsonDict[@"member_policy"] = [DBSHARINGMemberPolicySerializer serialize:valueObj.memberPolicy];
  }
  if (valueObj.aclUpdatePolicy) {
    jsonDict[@"acl_update_policy"] = [DBSHARINGAclUpdatePolicySerializer serialize:valueObj.aclUpdatePolicy];
  }
  if (valueObj.viewerInfoPolicy) {
    jsonDict[@"viewer_info_policy"] = [DBSHARINGViewerInfoPolicySerializer serialize:valueObj.viewerInfoPolicy];
  }
  if (valueObj.sharedLinkPolicy) {
    jsonDict[@"shared_link_policy"] = [DBSHARINGSharedLinkPolicySerializer serialize:valueObj.sharedLinkPolicy];
  }
  if (valueObj.linkSettings) {
    jsonDict[@"link_settings"] = [DBSHARINGLinkSettingsSerializer serialize:valueObj.linkSettings];
  }
  if (valueObj.actions) {
    jsonDict[@"actions"] = [DBArraySerializer serialize:valueObj.actions
                                              withBlock:^id(id elem0) {
                                                return [DBSHARINGFolderActionSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUpdateFolderPolicyArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *sharedFolderId = valueDict[@"shared_folder_id"];
  DBSHARINGMemberPolicy *memberPolicy =
      valueDict[@"member_policy"] ? [DBSHARINGMemberPolicySerializer deserialize:valueDict[@"member_policy"]] : nil;
  DBSHARINGAclUpdatePolicy *aclUpdatePolicy =
      valueDict[@"acl_update_policy"] ? [DBSHARINGAclUpdatePolicySerializer deserialize:valueDict[@"acl_update_policy"]]
                                      : nil;
  DBSHARINGViewerInfoPolicy *viewerInfoPolicy =
      valueDict[@"viewer_info_policy"]
          ? [DBSHARINGViewerInfoPolicySerializer deserialize:valueDict[@"viewer_info_policy"]]
          : nil;
  DBSHARINGSharedLinkPolicy *sharedLinkPolicy =
      valueDict[@"shared_link_policy"]
          ? [DBSHARINGSharedLinkPolicySerializer deserialize:valueDict[@"shared_link_policy"]]
          : nil;
  DBSHARINGLinkSettings *linkSettings =
      valueDict[@"link_settings"] ? [DBSHARINGLinkSettingsSerializer deserialize:valueDict[@"link_settings"]] : nil;
  NSArray<DBSHARINGFolderAction *> *actions =
      valueDict[@"actions"] ? [DBArraySerializer deserialize:valueDict[@"actions"]
                                                   withBlock:^id(id elem0) {
                                                     return [DBSHARINGFolderActionSerializer deserialize:elem0];
                                                   }]
                            : nil;

  return [[DBSHARINGUpdateFolderPolicyArg alloc] initWithSharedFolderId:sharedFolderId
                                                           memberPolicy:memberPolicy
                                                        aclUpdatePolicy:aclUpdatePolicy
                                                       viewerInfoPolicy:viewerInfoPolicy
                                                       sharedLinkPolicy:sharedLinkPolicy
                                                           linkSettings:linkSettings
                                                                actions:actions];
}

@end

#import "DBSHARINGSharedFolderAccessError.h"
#import "DBSHARINGUpdateFolderPolicyError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUpdateFolderPolicyError

@synthesize accessError = _accessError;

#pragma mark - Constructors

- (instancetype)initWithAccessError:(DBSHARINGSharedFolderAccessError *)accessError {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorAccessError;
    _accessError = accessError;
  }
  return self;
}

- (instancetype)initWithNotOnTeam {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorNotOnTeam;
  }
  return self;
}

- (instancetype)initWithTeamPolicyDisallowsMemberPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy;
  }
  return self;
}

- (instancetype)initWithDisallowedSharedLinkPolicy {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithTeamFolder {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorTeamFolder;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGUpdateFolderPolicyErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBSHARINGSharedFolderAccessError *)accessError {
  if (![self isAccessError]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBSHARINGUpdateFolderPolicyErrorAccessError, but was %@.", [self tagName]];
  }
  return _accessError;
}

#pragma mark - Tag state methods

- (BOOL)isAccessError {
  return _tag == DBSHARINGUpdateFolderPolicyErrorAccessError;
}

- (BOOL)isNotOnTeam {
  return _tag == DBSHARINGUpdateFolderPolicyErrorNotOnTeam;
}

- (BOOL)isTeamPolicyDisallowsMemberPolicy {
  return _tag == DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy;
}

- (BOOL)isDisallowedSharedLinkPolicy {
  return _tag == DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy;
}

- (BOOL)isNoPermission {
  return _tag == DBSHARINGUpdateFolderPolicyErrorNoPermission;
}

- (BOOL)isTeamFolder {
  return _tag == DBSHARINGUpdateFolderPolicyErrorTeamFolder;
}

- (BOOL)isOther {
  return _tag == DBSHARINGUpdateFolderPolicyErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGUpdateFolderPolicyErrorAccessError:
    return @"DBSHARINGUpdateFolderPolicyErrorAccessError";
  case DBSHARINGUpdateFolderPolicyErrorNotOnTeam:
    return @"DBSHARINGUpdateFolderPolicyErrorNotOnTeam";
  case DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy:
    return @"DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy";
  case DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy:
    return @"DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy";
  case DBSHARINGUpdateFolderPolicyErrorNoPermission:
    return @"DBSHARINGUpdateFolderPolicyErrorNoPermission";
  case DBSHARINGUpdateFolderPolicyErrorTeamFolder:
    return @"DBSHARINGUpdateFolderPolicyErrorTeamFolder";
  case DBSHARINGUpdateFolderPolicyErrorOther:
    return @"DBSHARINGUpdateFolderPolicyErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUpdateFolderPolicyErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUpdateFolderPolicyErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUpdateFolderPolicyErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGUpdateFolderPolicyErrorAccessError:
    result = prime * result + [self.accessError hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorNotOnTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorTeamFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGUpdateFolderPolicyErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFolderPolicyError:other];
}

- (BOOL)isEqualToUpdateFolderPolicyError:(DBSHARINGUpdateFolderPolicyError *)anUpdateFolderPolicyError {
  if (self == anUpdateFolderPolicyError) {
    return YES;
  }
  if (self.tag != anUpdateFolderPolicyError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGUpdateFolderPolicyErrorAccessError:
    return [self.accessError isEqual:anUpdateFolderPolicyError.accessError];
  case DBSHARINGUpdateFolderPolicyErrorNotOnTeam:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  case DBSHARINGUpdateFolderPolicyErrorTeamPolicyDisallowsMemberPolicy:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  case DBSHARINGUpdateFolderPolicyErrorDisallowedSharedLinkPolicy:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  case DBSHARINGUpdateFolderPolicyErrorNoPermission:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  case DBSHARINGUpdateFolderPolicyErrorTeamFolder:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  case DBSHARINGUpdateFolderPolicyErrorOther:
    return [[self tagName] isEqual:[anUpdateFolderPolicyError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUpdateFolderPolicyErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUpdateFolderPolicyError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessError]) {
    jsonDict[@"access_error"] =
        [[DBSHARINGSharedFolderAccessErrorSerializer serialize:valueObj.accessError] mutableCopy];
    jsonDict[@".tag"] = @"access_error";
  } else if ([valueObj isNotOnTeam]) {
    jsonDict[@".tag"] = @"not_on_team";
  } else if ([valueObj isTeamPolicyDisallowsMemberPolicy]) {
    jsonDict[@".tag"] = @"team_policy_disallows_member_policy";
  } else if ([valueObj isDisallowedSharedLinkPolicy]) {
    jsonDict[@".tag"] = @"disallowed_shared_link_policy";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isTeamFolder]) {
    jsonDict[@".tag"] = @"team_folder";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUpdateFolderPolicyError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"access_error"]) {
    DBSHARINGSharedFolderAccessError *accessError =
        [DBSHARINGSharedFolderAccessErrorSerializer deserialize:valueDict[@"access_error"]];
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithAccessError:accessError];
  } else if ([tag isEqualToString:@"not_on_team"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithNotOnTeam];
  } else if ([tag isEqualToString:@"team_policy_disallows_member_policy"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithTeamPolicyDisallowsMemberPolicy];
  } else if ([tag isEqualToString:@"disallowed_shared_link_policy"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithDisallowedSharedLinkPolicy];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"team_folder"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithTeamFolder];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithOther];
  } else {
    return [[DBSHARINGUpdateFolderPolicyError alloc] initWithOther];
  }
}

@end

#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGMembershipInfo.h"
#import "DBSHARINGUserInfo.h"
#import "DBSHARINGUserMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUserMembershipInfo

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                              user:(DBSHARINGUserInfo *)user
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(NSString *)initials
                       isInherited:(NSNumber *)isInherited {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self = [super initWithAccessType:accessType permissions:permissions initials:initials isInherited:isInherited];
  if (self) {
    _user = user;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType user:(DBSHARINGUserInfo *)user {
  return [self initWithAccessType:accessType user:user permissions:nil initials:nil isInherited:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUserMembershipInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUserMembershipInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUserMembershipInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.user hash];
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.initials != nil) {
    result = prime * result + [self.initials hash];
  }
  result = prime * result + [self.isInherited hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserMembershipInfo:other];
}

- (BOOL)isEqualToUserMembershipInfo:(DBSHARINGUserMembershipInfo *)anUserMembershipInfo {
  if (self == anUserMembershipInfo) {
    return YES;
  }
  if (![self.accessType isEqual:anUserMembershipInfo.accessType]) {
    return NO;
  }
  if (![self.user isEqual:anUserMembershipInfo.user]) {
    return NO;
  }
  if (self.permissions) {
    if (![self.permissions isEqual:anUserMembershipInfo.permissions]) {
      return NO;
    }
  }
  if (self.initials) {
    if (![self.initials isEqual:anUserMembershipInfo.initials]) {
      return NO;
    }
  }
  if (![self.isInherited isEqual:anUserMembershipInfo.isInherited]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUserMembershipInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUserMembershipInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"user"] = [DBSHARINGUserInfoSerializer serialize:valueObj.user];
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.initials) {
    jsonDict[@"initials"] = valueObj.initials;
  }
  jsonDict[@"is_inherited"] = valueObj.isInherited;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUserMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  DBSHARINGUserInfo *user = [DBSHARINGUserInfoSerializer deserialize:valueDict[@"user"]];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSString *initials = valueDict[@"initials"] ?: nil;
  NSNumber *isInherited = valueDict[@"is_inherited"] ?: @NO;

  return [[DBSHARINGUserMembershipInfo alloc] initWithAccessType:accessType
                                                            user:user
                                                     permissions:permissions
                                                        initials:initials
                                                     isInherited:isInherited];
}

@end

#import "DBSEENSTATEPlatformType.h"
#import "DBSHARINGAccessLevel.h"
#import "DBSHARINGMemberPermission.h"
#import "DBSHARINGUserFileMembershipInfo.h"
#import "DBSHARINGUserInfo.h"
#import "DBSHARINGUserMembershipInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUserFileMembershipInfo

#pragma mark - Constructors

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType
                              user:(DBSHARINGUserInfo *)user
                       permissions:(NSArray<DBSHARINGMemberPermission *> *)permissions
                          initials:(NSString *)initials
                       isInherited:(NSNumber *)isInherited
                      timeLastSeen:(NSDate *)timeLastSeen
                      platformType:(DBSEENSTATEPlatformType *)platformType {
  [DBStoneValidators nonnullValidator:nil](accessType);
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](permissions);

  self =
      [super initWithAccessType:accessType user:user permissions:permissions initials:initials isInherited:isInherited];
  if (self) {
    _timeLastSeen = timeLastSeen;
    _platformType = platformType;
  }
  return self;
}

- (instancetype)initWithAccessType:(DBSHARINGAccessLevel *)accessType user:(DBSHARINGUserInfo *)user {
  return [self initWithAccessType:accessType
                             user:user
                      permissions:nil
                         initials:nil
                      isInherited:nil
                     timeLastSeen:nil
                     platformType:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUserFileMembershipInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUserFileMembershipInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUserFileMembershipInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accessType hash];
  result = prime * result + [self.user hash];
  if (self.permissions != nil) {
    result = prime * result + [self.permissions hash];
  }
  if (self.initials != nil) {
    result = prime * result + [self.initials hash];
  }
  result = prime * result + [self.isInherited hash];
  if (self.timeLastSeen != nil) {
    result = prime * result + [self.timeLastSeen hash];
  }
  if (self.platformType != nil) {
    result = prime * result + [self.platformType hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserFileMembershipInfo:other];
}

- (BOOL)isEqualToUserFileMembershipInfo:(DBSHARINGUserFileMembershipInfo *)anUserFileMembershipInfo {
  if (self == anUserFileMembershipInfo) {
    return YES;
  }
  if (![self.accessType isEqual:anUserFileMembershipInfo.accessType]) {
    return NO;
  }
  if (![self.user isEqual:anUserFileMembershipInfo.user]) {
    return NO;
  }
  if (self.permissions) {
    if (![self.permissions isEqual:anUserFileMembershipInfo.permissions]) {
      return NO;
    }
  }
  if (self.initials) {
    if (![self.initials isEqual:anUserFileMembershipInfo.initials]) {
      return NO;
    }
  }
  if (![self.isInherited isEqual:anUserFileMembershipInfo.isInherited]) {
    return NO;
  }
  if (self.timeLastSeen) {
    if (![self.timeLastSeen isEqual:anUserFileMembershipInfo.timeLastSeen]) {
      return NO;
    }
  }
  if (self.platformType) {
    if (![self.platformType isEqual:anUserFileMembershipInfo.platformType]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUserFileMembershipInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUserFileMembershipInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"access_type"] = [DBSHARINGAccessLevelSerializer serialize:valueObj.accessType];
  jsonDict[@"user"] = [DBSHARINGUserInfoSerializer serialize:valueObj.user];
  if (valueObj.permissions) {
    jsonDict[@"permissions"] = [DBArraySerializer serialize:valueObj.permissions
                                                  withBlock:^id(id elem0) {
                                                    return [DBSHARINGMemberPermissionSerializer serialize:elem0];
                                                  }];
  }
  if (valueObj.initials) {
    jsonDict[@"initials"] = valueObj.initials;
  }
  jsonDict[@"is_inherited"] = valueObj.isInherited;
  if (valueObj.timeLastSeen) {
    jsonDict[@"time_last_seen"] = [DBNSDateSerializer serialize:valueObj.timeLastSeen dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }
  if (valueObj.platformType) {
    jsonDict[@"platform_type"] = [DBSEENSTATEPlatformTypeSerializer serialize:valueObj.platformType];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUserFileMembershipInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGAccessLevel *accessType = [DBSHARINGAccessLevelSerializer deserialize:valueDict[@"access_type"]];
  DBSHARINGUserInfo *user = [DBSHARINGUserInfoSerializer deserialize:valueDict[@"user"]];
  NSArray<DBSHARINGMemberPermission *> *permissions =
      valueDict[@"permissions"] ? [DBArraySerializer deserialize:valueDict[@"permissions"]
                                                       withBlock:^id(id elem0) {
                                                         return [DBSHARINGMemberPermissionSerializer deserialize:elem0];
                                                       }]
                                : nil;
  NSString *initials = valueDict[@"initials"] ?: nil;
  NSNumber *isInherited = valueDict[@"is_inherited"] ?: @NO;
  NSDate *timeLastSeen = valueDict[@"time_last_seen"] ? [DBNSDateSerializer deserialize:valueDict[@"time_last_seen"]
                                                                             dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                                                      : nil;
  DBSEENSTATEPlatformType *platformType =
      valueDict[@"platform_type"] ? [DBSEENSTATEPlatformTypeSerializer deserialize:valueDict[@"platform_type"]] : nil;

  return [[DBSHARINGUserFileMembershipInfo alloc] initWithAccessType:accessType
                                                                user:user
                                                         permissions:permissions
                                                            initials:initials
                                                         isInherited:isInherited
                                                        timeLastSeen:timeLastSeen
                                                        platformType:platformType];
}

@end

#import "DBSHARINGUserInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGUserInfo

#pragma mark - Constructors

- (instancetype)initWithAccountId:(NSString *)accountId
                            email:(NSString *)email
                      displayName:(NSString *)displayName
                         sameTeam:(NSNumber *)sameTeam
                     teamMemberId:(NSString *)teamMemberId {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(40) maxLength:@(40) pattern:nil]](accountId);
  [DBStoneValidators nonnullValidator:nil](email);
  [DBStoneValidators nonnullValidator:nil](displayName);
  [DBStoneValidators nonnullValidator:nil](sameTeam);

  self = [super init];
  if (self) {
    _accountId = accountId;
    _email = email;
    _displayName = displayName;
    _sameTeam = sameTeam;
    _teamMemberId = teamMemberId;
  }
  return self;
}

- (instancetype)initWithAccountId:(NSString *)accountId
                            email:(NSString *)email
                      displayName:(NSString *)displayName
                         sameTeam:(NSNumber *)sameTeam {
  return [self initWithAccountId:accountId email:email displayName:displayName sameTeam:sameTeam teamMemberId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGUserInfoSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGUserInfoSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGUserInfoSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.accountId hash];
  result = prime * result + [self.email hash];
  result = prime * result + [self.displayName hash];
  result = prime * result + [self.sameTeam hash];
  if (self.teamMemberId != nil) {
    result = prime * result + [self.teamMemberId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserInfo:other];
}

- (BOOL)isEqualToUserInfo:(DBSHARINGUserInfo *)anUserInfo {
  if (self == anUserInfo) {
    return YES;
  }
  if (![self.accountId isEqual:anUserInfo.accountId]) {
    return NO;
  }
  if (![self.email isEqual:anUserInfo.email]) {
    return NO;
  }
  if (![self.displayName isEqual:anUserInfo.displayName]) {
    return NO;
  }
  if (![self.sameTeam isEqual:anUserInfo.sameTeam]) {
    return NO;
  }
  if (self.teamMemberId) {
    if (![self.teamMemberId isEqual:anUserInfo.teamMemberId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGUserInfoSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGUserInfo *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"account_id"] = valueObj.accountId;
  jsonDict[@"email"] = valueObj.email;
  jsonDict[@"display_name"] = valueObj.displayName;
  jsonDict[@"same_team"] = valueObj.sameTeam;
  if (valueObj.teamMemberId) {
    jsonDict[@"team_member_id"] = valueObj.teamMemberId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGUserInfo *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *accountId = valueDict[@"account_id"];
  NSString *email = valueDict[@"email"];
  NSString *displayName = valueDict[@"display_name"];
  NSNumber *sameTeam = valueDict[@"same_team"];
  NSString *teamMemberId = valueDict[@"team_member_id"] ?: nil;

  return [[DBSHARINGUserInfo alloc] initWithAccountId:accountId
                                                email:email
                                          displayName:displayName
                                             sameTeam:sameTeam
                                         teamMemberId:teamMemberId];
}

@end

#import "DBSHARINGViewerInfoPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGViewerInfoPolicy

#pragma mark - Constructors

- (instancetype)initWithEnabled {
  self = [super init];
  if (self) {
    _tag = DBSHARINGViewerInfoPolicyEnabled;
  }
  return self;
}

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBSHARINGViewerInfoPolicyDisabled;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGViewerInfoPolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEnabled {
  return _tag == DBSHARINGViewerInfoPolicyEnabled;
}

- (BOOL)isDisabled {
  return _tag == DBSHARINGViewerInfoPolicyDisabled;
}

- (BOOL)isOther {
  return _tag == DBSHARINGViewerInfoPolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGViewerInfoPolicyEnabled:
    return @"DBSHARINGViewerInfoPolicyEnabled";
  case DBSHARINGViewerInfoPolicyDisabled:
    return @"DBSHARINGViewerInfoPolicyDisabled";
  case DBSHARINGViewerInfoPolicyOther:
    return @"DBSHARINGViewerInfoPolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGViewerInfoPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGViewerInfoPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGViewerInfoPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGViewerInfoPolicyEnabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGViewerInfoPolicyDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGViewerInfoPolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToViewerInfoPolicy:other];
}

- (BOOL)isEqualToViewerInfoPolicy:(DBSHARINGViewerInfoPolicy *)aViewerInfoPolicy {
  if (self == aViewerInfoPolicy) {
    return YES;
  }
  if (self.tag != aViewerInfoPolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGViewerInfoPolicyEnabled:
    return [[self tagName] isEqual:[aViewerInfoPolicy tagName]];
  case DBSHARINGViewerInfoPolicyDisabled:
    return [[self tagName] isEqual:[aViewerInfoPolicy tagName]];
  case DBSHARINGViewerInfoPolicyOther:
    return [[self tagName] isEqual:[aViewerInfoPolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGViewerInfoPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGViewerInfoPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEnabled]) {
    jsonDict[@".tag"] = @"enabled";
  } else if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGViewerInfoPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"enabled"]) {
    return [[DBSHARINGViewerInfoPolicy alloc] initWithEnabled];
  } else if ([tag isEqualToString:@"disabled"]) {
    return [[DBSHARINGViewerInfoPolicy alloc] initWithDisabled];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGViewerInfoPolicy alloc] initWithOther];
  } else {
    return [[DBSHARINGViewerInfoPolicy alloc] initWithOther];
  }
}

@end

#import "DBSHARINGVisibility.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBSHARINGVisibility

#pragma mark - Constructors

- (instancetype)initWithPublic {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilityPublic;
  }
  return self;
}

- (instancetype)initWithTeamOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilityTeamOnly;
  }
  return self;
}

- (instancetype)initWithPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilityPassword;
  }
  return self;
}

- (instancetype)initWithTeamAndPassword {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilityTeamAndPassword;
  }
  return self;
}

- (instancetype)initWithSharedFolderOnly {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilitySharedFolderOnly;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBSHARINGVisibilityOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPublic {
  return _tag == DBSHARINGVisibilityPublic;
}

- (BOOL)isTeamOnly {
  return _tag == DBSHARINGVisibilityTeamOnly;
}

- (BOOL)isPassword {
  return _tag == DBSHARINGVisibilityPassword;
}

- (BOOL)isTeamAndPassword {
  return _tag == DBSHARINGVisibilityTeamAndPassword;
}

- (BOOL)isSharedFolderOnly {
  return _tag == DBSHARINGVisibilitySharedFolderOnly;
}

- (BOOL)isOther {
  return _tag == DBSHARINGVisibilityOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBSHARINGVisibilityPublic:
    return @"DBSHARINGVisibilityPublic";
  case DBSHARINGVisibilityTeamOnly:
    return @"DBSHARINGVisibilityTeamOnly";
  case DBSHARINGVisibilityPassword:
    return @"DBSHARINGVisibilityPassword";
  case DBSHARINGVisibilityTeamAndPassword:
    return @"DBSHARINGVisibilityTeamAndPassword";
  case DBSHARINGVisibilitySharedFolderOnly:
    return @"DBSHARINGVisibilitySharedFolderOnly";
  case DBSHARINGVisibilityOther:
    return @"DBSHARINGVisibilityOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBSHARINGVisibilitySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBSHARINGVisibilitySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBSHARINGVisibilitySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBSHARINGVisibilityPublic:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGVisibilityTeamOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGVisibilityPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGVisibilityTeamAndPassword:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGVisibilitySharedFolderOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBSHARINGVisibilityOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToVisibility:other];
}

- (BOOL)isEqualToVisibility:(DBSHARINGVisibility *)aVisibility {
  if (self == aVisibility) {
    return YES;
  }
  if (self.tag != aVisibility.tag) {
    return NO;
  }
  switch (_tag) {
  case DBSHARINGVisibilityPublic:
    return [[self tagName] isEqual:[aVisibility tagName]];
  case DBSHARINGVisibilityTeamOnly:
    return [[self tagName] isEqual:[aVisibility tagName]];
  case DBSHARINGVisibilityPassword:
    return [[self tagName] isEqual:[aVisibility tagName]];
  case DBSHARINGVisibilityTeamAndPassword:
    return [[self tagName] isEqual:[aVisibility tagName]];
  case DBSHARINGVisibilitySharedFolderOnly:
    return [[self tagName] isEqual:[aVisibility tagName]];
  case DBSHARINGVisibilityOther:
    return [[self tagName] isEqual:[aVisibility tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBSHARINGVisibilitySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBSHARINGVisibility *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPublic]) {
    jsonDict[@".tag"] = @"public";
  } else if ([valueObj isTeamOnly]) {
    jsonDict[@".tag"] = @"team_only";
  } else if ([valueObj isPassword]) {
    jsonDict[@".tag"] = @"password";
  } else if ([valueObj isTeamAndPassword]) {
    jsonDict[@".tag"] = @"team_and_password";
  } else if ([valueObj isSharedFolderOnly]) {
    jsonDict[@".tag"] = @"shared_folder_only";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBSHARINGVisibility *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"public"]) {
    return [[DBSHARINGVisibility alloc] initWithPublic];
  } else if ([tag isEqualToString:@"team_only"]) {
    return [[DBSHARINGVisibility alloc] initWithTeamOnly];
  } else if ([tag isEqualToString:@"password"]) {
    return [[DBSHARINGVisibility alloc] initWithPassword];
  } else if ([tag isEqualToString:@"team_and_password"]) {
    return [[DBSHARINGVisibility alloc] initWithTeamAndPassword];
  } else if ([tag isEqualToString:@"shared_folder_only"]) {
    return [[DBSHARINGVisibility alloc] initWithSharedFolderOnly];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBSHARINGVisibility alloc] initWithOther];
  } else {
    return [[DBSHARINGVisibility alloc] initWithOther];
  }
}

@end
