///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBPAPERRefPaperDoc.h"
#import "DBSerializableProtocol.h"

@class DBPAPERListUsersOnFolderArgs;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `ListUsersOnFolderArgs` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBPAPERListUsersOnFolderArgs : DBPAPERRefPaperDoc <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// Size limit per batch. The maximum number of users that can be retrieved per
/// batch is 1000. Higher value results in invalid arguments error.
@property (nonatomic, readonly) NSNumber *limit;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param docId The Paper doc ID.
/// @param limit Size limit per batch. The maximum number of users that can be
/// retrieved per batch is 1000. Higher value results in invalid arguments
/// error.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocId:(NSString *)docId limit:(nullable NSNumber *)limit;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param docId The Paper doc ID.
///
/// @return An initialized instance.
///
- (instancetype)initWithDocId:(NSString *)docId;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `ListUsersOnFolderArgs` struct.
///
@interface DBPAPERListUsersOnFolderArgsSerializer : NSObject

///
/// Serializes `DBPAPERListUsersOnFolderArgs` instances.
///
/// @param instance An instance of the `DBPAPERListUsersOnFolderArgs` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBPAPERListUsersOnFolderArgs` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnFolderArgs *)instance;

///
/// Deserializes `DBPAPERListUsersOnFolderArgs` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBPAPERListUsersOnFolderArgs` API object.
///
/// @return An instantiation of the `DBPAPERListUsersOnFolderArgs` object.
///
+ (DBPAPERListUsersOnFolderArgs *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
