///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Paper` namespace.

#import "DBPAPERAddMember.h"
#import "DBPAPERPaperDocPermissionLevel.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERAddMember

#pragma mark - Constructors

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member
               permissionLevel:(DBPAPERPaperDocPermissionLevel *)permissionLevel {
  [DBStoneValidators nonnullValidator:nil](member);

  self = [super init];
  if (self) {
    _permissionLevel = permissionLevel ?: [[DBPAPERPaperDocPermissionLevel alloc] initWithEdit];
    _member = member;
  }
  return self;
}

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member {
  return [self initWithMember:member permissionLevel:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERAddMemberSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERAddMemberSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERAddMemberSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.member hash];
  result = prime * result + [self.permissionLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddMember:other];
}

- (BOOL)isEqualToAddMember:(DBPAPERAddMember *)anAddMember {
  if (self == anAddMember) {
    return YES;
  }
  if (![self.member isEqual:anAddMember.member]) {
    return NO;
  }
  if (![self.permissionLevel isEqual:anAddMember.permissionLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERAddMemberSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERAddMember *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"permission_level"] = [DBPAPERPaperDocPermissionLevelSerializer serialize:valueObj.permissionLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERAddMember *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBPAPERPaperDocPermissionLevel *permissionLevel =
      valueDict[@"permission_level"]
          ? [DBPAPERPaperDocPermissionLevelSerializer deserialize:valueDict[@"permission_level"]]
          : [[DBPAPERPaperDocPermissionLevel alloc] initWithEdit];

  return [[DBPAPERAddMember alloc] initWithMember:member permissionLevel:permissionLevel];
}

@end

#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERRefPaperDoc

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId {
  [DBStoneValidators nonnullValidator:nil](docId);

  self = [super init];
  if (self) {
    _docId = docId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERRefPaperDocSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERRefPaperDocSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERRefPaperDocSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRefPaperDoc:other];
}

- (BOOL)isEqualToRefPaperDoc:(DBPAPERRefPaperDoc *)aRefPaperDoc {
  if (self == aRefPaperDoc) {
    return YES;
  }
  if (![self.docId isEqual:aRefPaperDoc.docId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERRefPaperDocSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERRefPaperDoc *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERRefPaperDoc *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];

  return [[DBPAPERRefPaperDoc alloc] initWithDocId:docId];
}

@end

#import "DBPAPERAddMember.h"
#import "DBPAPERAddPaperDocUser.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERAddPaperDocUser

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId
                      members:(NSArray<DBPAPERAddMember *> *)members
                customMessage:(NSString *)customMessage
                        quiet:(NSNumber *)quiet {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:@(20)
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](members);

  self = [super initWithDocId:docId];
  if (self) {
    _members = members;
    _customMessage = customMessage;
    _quiet = quiet ?: @NO;
  }
  return self;
}

- (instancetype)initWithDocId:(NSString *)docId members:(NSArray<DBPAPERAddMember *> *)members {
  return [self initWithDocId:docId members:members customMessage:nil quiet:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERAddPaperDocUserSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERAddPaperDocUserSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERAddPaperDocUserSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.members hash];
  if (self.customMessage != nil) {
    result = prime * result + [self.customMessage hash];
  }
  result = prime * result + [self.quiet hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddPaperDocUser:other];
}

- (BOOL)isEqualToAddPaperDocUser:(DBPAPERAddPaperDocUser *)anAddPaperDocUser {
  if (self == anAddPaperDocUser) {
    return YES;
  }
  if (![self.docId isEqual:anAddPaperDocUser.docId]) {
    return NO;
  }
  if (![self.members isEqual:anAddPaperDocUser.members]) {
    return NO;
  }
  if (self.customMessage) {
    if (![self.customMessage isEqual:anAddPaperDocUser.customMessage]) {
      return NO;
    }
  }
  if (![self.quiet isEqual:anAddPaperDocUser.quiet]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERAddPaperDocUserSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERAddPaperDocUser *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"members"] = [DBArraySerializer serialize:valueObj.members
                                            withBlock:^id(id elem0) {
                                              return [DBPAPERAddMemberSerializer serialize:elem0];
                                            }];
  if (valueObj.customMessage) {
    jsonDict[@"custom_message"] = valueObj.customMessage;
  }
  jsonDict[@"quiet"] = valueObj.quiet;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERAddPaperDocUser *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSArray<DBPAPERAddMember *> *members = [DBArraySerializer deserialize:valueDict[@"members"]
                                                              withBlock:^id(id elem0) {
                                                                return [DBPAPERAddMemberSerializer deserialize:elem0];
                                                              }];
  NSString *customMessage = valueDict[@"custom_message"] ?: nil;
  NSNumber *quiet = valueDict[@"quiet"] ?: @NO;

  return [[DBPAPERAddPaperDocUser alloc] initWithDocId:docId members:members customMessage:customMessage quiet:quiet];
}

@end

#import "DBPAPERAddPaperDocUserMemberResult.h"
#import "DBPAPERAddPaperDocUserResult.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERAddPaperDocUserMemberResult

#pragma mark - Constructors

- (instancetype)initWithMember:(DBSHARINGMemberSelector *)member result:(DBPAPERAddPaperDocUserResult *)result {
  [DBStoneValidators nonnullValidator:nil](member);
  [DBStoneValidators nonnullValidator:nil](result);

  self = [super init];
  if (self) {
    _member = member;
    _result = result;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERAddPaperDocUserMemberResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERAddPaperDocUserMemberResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERAddPaperDocUserMemberResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.member hash];
  result = prime * result + [self.result hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddPaperDocUserMemberResult:other];
}

- (BOOL)isEqualToAddPaperDocUserMemberResult:(DBPAPERAddPaperDocUserMemberResult *)anAddPaperDocUserMemberResult {
  if (self == anAddPaperDocUserMemberResult) {
    return YES;
  }
  if (![self.member isEqual:anAddPaperDocUserMemberResult.member]) {
    return NO;
  }
  if (![self.result isEqual:anAddPaperDocUserMemberResult.result]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERAddPaperDocUserMemberResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERAddPaperDocUserMemberResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];
  jsonDict[@"result"] = [DBPAPERAddPaperDocUserResultSerializer serialize:valueObj.result];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERAddPaperDocUserMemberResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];
  DBPAPERAddPaperDocUserResult *result = [DBPAPERAddPaperDocUserResultSerializer deserialize:valueDict[@"result"]];

  return [[DBPAPERAddPaperDocUserMemberResult alloc] initWithMember:member result:result];
}

@end

#import "DBPAPERAddPaperDocUserResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERAddPaperDocUserResult

#pragma mark - Constructors

- (instancetype)initWithSuccess {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultSuccess;
  }
  return self;
}

- (instancetype)initWithUnknownError {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultUnknownError;
  }
  return self;
}

- (instancetype)initWithSharingOutsideTeamDisabled {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled;
  }
  return self;
}

- (instancetype)initWithDailyLimitReached {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultDailyLimitReached;
  }
  return self;
}

- (instancetype)initWithUserIsOwner {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultUserIsOwner;
  }
  return self;
}

- (instancetype)initWithFailedUserDataRetrieval {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultFailedUserDataRetrieval;
  }
  return self;
}

- (instancetype)initWithPermissionAlreadyGranted {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultPermissionAlreadyGranted;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERAddPaperDocUserResultOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isSuccess {
  return _tag == DBPAPERAddPaperDocUserResultSuccess;
}

- (BOOL)isUnknownError {
  return _tag == DBPAPERAddPaperDocUserResultUnknownError;
}

- (BOOL)isSharingOutsideTeamDisabled {
  return _tag == DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled;
}

- (BOOL)isDailyLimitReached {
  return _tag == DBPAPERAddPaperDocUserResultDailyLimitReached;
}

- (BOOL)isUserIsOwner {
  return _tag == DBPAPERAddPaperDocUserResultUserIsOwner;
}

- (BOOL)isFailedUserDataRetrieval {
  return _tag == DBPAPERAddPaperDocUserResultFailedUserDataRetrieval;
}

- (BOOL)isPermissionAlreadyGranted {
  return _tag == DBPAPERAddPaperDocUserResultPermissionAlreadyGranted;
}

- (BOOL)isOther {
  return _tag == DBPAPERAddPaperDocUserResultOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERAddPaperDocUserResultSuccess:
    return @"DBPAPERAddPaperDocUserResultSuccess";
  case DBPAPERAddPaperDocUserResultUnknownError:
    return @"DBPAPERAddPaperDocUserResultUnknownError";
  case DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled:
    return @"DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled";
  case DBPAPERAddPaperDocUserResultDailyLimitReached:
    return @"DBPAPERAddPaperDocUserResultDailyLimitReached";
  case DBPAPERAddPaperDocUserResultUserIsOwner:
    return @"DBPAPERAddPaperDocUserResultUserIsOwner";
  case DBPAPERAddPaperDocUserResultFailedUserDataRetrieval:
    return @"DBPAPERAddPaperDocUserResultFailedUserDataRetrieval";
  case DBPAPERAddPaperDocUserResultPermissionAlreadyGranted:
    return @"DBPAPERAddPaperDocUserResultPermissionAlreadyGranted";
  case DBPAPERAddPaperDocUserResultOther:
    return @"DBPAPERAddPaperDocUserResultOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERAddPaperDocUserResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERAddPaperDocUserResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERAddPaperDocUserResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERAddPaperDocUserResultSuccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultUnknownError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultDailyLimitReached:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultUserIsOwner:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultFailedUserDataRetrieval:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultPermissionAlreadyGranted:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERAddPaperDocUserResultOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToAddPaperDocUserResult:other];
}

- (BOOL)isEqualToAddPaperDocUserResult:(DBPAPERAddPaperDocUserResult *)anAddPaperDocUserResult {
  if (self == anAddPaperDocUserResult) {
    return YES;
  }
  if (self.tag != anAddPaperDocUserResult.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERAddPaperDocUserResultSuccess:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultUnknownError:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultSharingOutsideTeamDisabled:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultDailyLimitReached:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultUserIsOwner:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultFailedUserDataRetrieval:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultPermissionAlreadyGranted:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  case DBPAPERAddPaperDocUserResultOther:
    return [[self tagName] isEqual:[anAddPaperDocUserResult tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERAddPaperDocUserResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERAddPaperDocUserResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isSuccess]) {
    jsonDict[@".tag"] = @"success";
  } else if ([valueObj isUnknownError]) {
    jsonDict[@".tag"] = @"unknown_error";
  } else if ([valueObj isSharingOutsideTeamDisabled]) {
    jsonDict[@".tag"] = @"sharing_outside_team_disabled";
  } else if ([valueObj isDailyLimitReached]) {
    jsonDict[@".tag"] = @"daily_limit_reached";
  } else if ([valueObj isUserIsOwner]) {
    jsonDict[@".tag"] = @"user_is_owner";
  } else if ([valueObj isFailedUserDataRetrieval]) {
    jsonDict[@".tag"] = @"failed_user_data_retrieval";
  } else if ([valueObj isPermissionAlreadyGranted]) {
    jsonDict[@".tag"] = @"permission_already_granted";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERAddPaperDocUserResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"success"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithSuccess];
  } else if ([tag isEqualToString:@"unknown_error"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithUnknownError];
  } else if ([tag isEqualToString:@"sharing_outside_team_disabled"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithSharingOutsideTeamDisabled];
  } else if ([tag isEqualToString:@"daily_limit_reached"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithDailyLimitReached];
  } else if ([tag isEqualToString:@"user_is_owner"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithUserIsOwner];
  } else if ([tag isEqualToString:@"failed_user_data_retrieval"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithFailedUserDataRetrieval];
  } else if ([tag isEqualToString:@"permission_already_granted"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithPermissionAlreadyGranted];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithOther];
  } else {
    return [[DBPAPERAddPaperDocUserResult alloc] initWithOther];
  }
}

@end

#import "DBPAPERCursor.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERCursor

#pragma mark - Constructors

- (instancetype)initWithValue:(NSString *)value expiration:(NSDate *)expiration {
  [DBStoneValidators nonnullValidator:nil](value);

  self = [super init];
  if (self) {
    _value = value;
    _expiration = expiration;
  }
  return self;
}

- (instancetype)initWithValue:(NSString *)value {
  return [self initWithValue:value expiration:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERCursorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERCursorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERCursorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.value hash];
  if (self.expiration != nil) {
    result = prime * result + [self.expiration hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCursor:other];
}

- (BOOL)isEqualToCursor:(DBPAPERCursor *)aCursor {
  if (self == aCursor) {
    return YES;
  }
  if (![self.value isEqual:aCursor.value]) {
    return NO;
  }
  if (self.expiration) {
    if (![self.expiration isEqual:aCursor.expiration]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERCursorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERCursor *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"value"] = valueObj.value;
  if (valueObj.expiration) {
    jsonDict[@"expiration"] = [DBNSDateSerializer serialize:valueObj.expiration dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERCursor *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *value = valueDict[@"value"];
  NSDate *expiration = valueDict[@"expiration"]
                           ? [DBNSDateSerializer deserialize:valueDict[@"expiration"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"]
                           : nil;

  return [[DBPAPERCursor alloc] initWithValue:value expiration:expiration];
}

@end

#import "DBPAPERPaperApiBaseError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperApiBaseError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiBaseErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiBaseErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERPaperApiBaseErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperApiBaseErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperApiBaseErrorInsufficientPermissions:
    return @"DBPAPERPaperApiBaseErrorInsufficientPermissions";
  case DBPAPERPaperApiBaseErrorOther:
    return @"DBPAPERPaperApiBaseErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperApiBaseErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperApiBaseErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperApiBaseErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperApiBaseErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperApiBaseErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperApiBaseError:other];
}

- (BOOL)isEqualToPaperApiBaseError:(DBPAPERPaperApiBaseError *)aPaperApiBaseError {
  if (self == aPaperApiBaseError) {
    return YES;
  }
  if (self.tag != aPaperApiBaseError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperApiBaseErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperApiBaseError tagName]];
  case DBPAPERPaperApiBaseErrorOther:
    return [[self tagName] isEqual:[aPaperApiBaseError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperApiBaseErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperApiBaseError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperApiBaseError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERPaperApiBaseError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperApiBaseError alloc] initWithOther];
  } else {
    return [[DBPAPERPaperApiBaseError alloc] initWithOther];
  }
}

@end

#import "DBPAPERDocLookupError.h"
#import "DBPAPERPaperApiBaseError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERDocLookupError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocLookupErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocLookupErrorOther;
  }
  return self;
}

- (instancetype)initWithDocNotFound {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocLookupErrorDocNotFound;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERDocLookupErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERDocLookupErrorOther;
}

- (BOOL)isDocNotFound {
  return _tag == DBPAPERDocLookupErrorDocNotFound;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERDocLookupErrorInsufficientPermissions:
    return @"DBPAPERDocLookupErrorInsufficientPermissions";
  case DBPAPERDocLookupErrorOther:
    return @"DBPAPERDocLookupErrorOther";
  case DBPAPERDocLookupErrorDocNotFound:
    return @"DBPAPERDocLookupErrorDocNotFound";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERDocLookupErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERDocLookupErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERDocLookupErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERDocLookupErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERDocLookupErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERDocLookupErrorDocNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDocLookupError:other];
}

- (BOOL)isEqualToDocLookupError:(DBPAPERDocLookupError *)aDocLookupError {
  if (self == aDocLookupError) {
    return YES;
  }
  if (self.tag != aDocLookupError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERDocLookupErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aDocLookupError tagName]];
  case DBPAPERDocLookupErrorOther:
    return [[self tagName] isEqual:[aDocLookupError tagName]];
  case DBPAPERDocLookupErrorDocNotFound:
    return [[self tagName] isEqual:[aDocLookupError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERDocLookupErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERDocLookupError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isDocNotFound]) {
    jsonDict[@".tag"] = @"doc_not_found";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERDocLookupError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERDocLookupError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERDocLookupError alloc] initWithOther];
  } else if ([tag isEqualToString:@"doc_not_found"]) {
    return [[DBPAPERDocLookupError alloc] initWithDocNotFound];
  } else {
    return [[DBPAPERDocLookupError alloc] initWithOther];
  }
}

@end

#import "DBPAPERDocSubscriptionLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERDocSubscriptionLevel

#pragma mark - Constructors

- (instancetype)initWithDefault_ {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocSubscriptionLevelDefault_;
  }
  return self;
}

- (instancetype)initWithIgnore {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocSubscriptionLevelIgnore;
  }
  return self;
}

- (instancetype)initWithEvery {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocSubscriptionLevelEvery;
  }
  return self;
}

- (instancetype)initWithNoEmail {
  self = [super init];
  if (self) {
    _tag = DBPAPERDocSubscriptionLevelNoEmail;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDefault_ {
  return _tag == DBPAPERDocSubscriptionLevelDefault_;
}

- (BOOL)isIgnore {
  return _tag == DBPAPERDocSubscriptionLevelIgnore;
}

- (BOOL)isEvery {
  return _tag == DBPAPERDocSubscriptionLevelEvery;
}

- (BOOL)isNoEmail {
  return _tag == DBPAPERDocSubscriptionLevelNoEmail;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERDocSubscriptionLevelDefault_:
    return @"DBPAPERDocSubscriptionLevelDefault_";
  case DBPAPERDocSubscriptionLevelIgnore:
    return @"DBPAPERDocSubscriptionLevelIgnore";
  case DBPAPERDocSubscriptionLevelEvery:
    return @"DBPAPERDocSubscriptionLevelEvery";
  case DBPAPERDocSubscriptionLevelNoEmail:
    return @"DBPAPERDocSubscriptionLevelNoEmail";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERDocSubscriptionLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERDocSubscriptionLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERDocSubscriptionLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERDocSubscriptionLevelDefault_:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERDocSubscriptionLevelIgnore:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERDocSubscriptionLevelEvery:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERDocSubscriptionLevelNoEmail:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDocSubscriptionLevel:other];
}

- (BOOL)isEqualToDocSubscriptionLevel:(DBPAPERDocSubscriptionLevel *)aDocSubscriptionLevel {
  if (self == aDocSubscriptionLevel) {
    return YES;
  }
  if (self.tag != aDocSubscriptionLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERDocSubscriptionLevelDefault_:
    return [[self tagName] isEqual:[aDocSubscriptionLevel tagName]];
  case DBPAPERDocSubscriptionLevelIgnore:
    return [[self tagName] isEqual:[aDocSubscriptionLevel tagName]];
  case DBPAPERDocSubscriptionLevelEvery:
    return [[self tagName] isEqual:[aDocSubscriptionLevel tagName]];
  case DBPAPERDocSubscriptionLevelNoEmail:
    return [[self tagName] isEqual:[aDocSubscriptionLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERDocSubscriptionLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERDocSubscriptionLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDefault_]) {
    jsonDict[@".tag"] = @"default";
  } else if ([valueObj isIgnore]) {
    jsonDict[@".tag"] = @"ignore";
  } else if ([valueObj isEvery]) {
    jsonDict[@".tag"] = @"every";
  } else if ([valueObj isNoEmail]) {
    jsonDict[@".tag"] = @"no_email";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERDocSubscriptionLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"default"]) {
    return [[DBPAPERDocSubscriptionLevel alloc] initWithDefault_];
  } else if ([tag isEqualToString:@"ignore"]) {
    return [[DBPAPERDocSubscriptionLevel alloc] initWithIgnore];
  } else if ([tag isEqualToString:@"every"]) {
    return [[DBPAPERDocSubscriptionLevel alloc] initWithEvery];
  } else if ([tag isEqualToString:@"no_email"]) {
    return [[DBPAPERDocSubscriptionLevel alloc] initWithNoEmail];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBPAPERExportFormat.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERExportFormat

#pragma mark - Constructors

- (instancetype)initWithHtml {
  self = [super init];
  if (self) {
    _tag = DBPAPERExportFormatHtml;
  }
  return self;
}

- (instancetype)initWithMarkdown {
  self = [super init];
  if (self) {
    _tag = DBPAPERExportFormatMarkdown;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERExportFormatOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isHtml {
  return _tag == DBPAPERExportFormatHtml;
}

- (BOOL)isMarkdown {
  return _tag == DBPAPERExportFormatMarkdown;
}

- (BOOL)isOther {
  return _tag == DBPAPERExportFormatOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERExportFormatHtml:
    return @"DBPAPERExportFormatHtml";
  case DBPAPERExportFormatMarkdown:
    return @"DBPAPERExportFormatMarkdown";
  case DBPAPERExportFormatOther:
    return @"DBPAPERExportFormatOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERExportFormatSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERExportFormatSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERExportFormatSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERExportFormatHtml:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERExportFormatMarkdown:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERExportFormatOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToExportFormat:other];
}

- (BOOL)isEqualToExportFormat:(DBPAPERExportFormat *)anExportFormat {
  if (self == anExportFormat) {
    return YES;
  }
  if (self.tag != anExportFormat.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERExportFormatHtml:
    return [[self tagName] isEqual:[anExportFormat tagName]];
  case DBPAPERExportFormatMarkdown:
    return [[self tagName] isEqual:[anExportFormat tagName]];
  case DBPAPERExportFormatOther:
    return [[self tagName] isEqual:[anExportFormat tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERExportFormatSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERExportFormat *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHtml]) {
    jsonDict[@".tag"] = @"html";
  } else if ([valueObj isMarkdown]) {
    jsonDict[@".tag"] = @"markdown";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERExportFormat *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"html"]) {
    return [[DBPAPERExportFormat alloc] initWithHtml];
  } else if ([tag isEqualToString:@"markdown"]) {
    return [[DBPAPERExportFormat alloc] initWithMarkdown];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERExportFormat alloc] initWithOther];
  } else {
    return [[DBPAPERExportFormat alloc] initWithOther];
  }
}

@end

#import "DBPAPERFolder.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERFolder

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ name:(NSString *)name {
  [DBStoneValidators nonnullValidator:nil](id_);
  [DBStoneValidators nonnullValidator:nil](name);

  self = [super init];
  if (self) {
    _id_ = id_;
    _name = name;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERFolderSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERFolderSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERFolderSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.name hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolder:other];
}

- (BOOL)isEqualToFolder:(DBPAPERFolder *)aFolder {
  if (self == aFolder) {
    return YES;
  }
  if (![self.id_ isEqual:aFolder.id_]) {
    return NO;
  }
  if (![self.name isEqual:aFolder.name]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERFolderSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERFolder *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"name"] = valueObj.name;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERFolder *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *name = valueDict[@"name"];

  return [[DBPAPERFolder alloc] initWithId_:id_ name:name];
}

@end

#import "DBPAPERFolderSharingPolicyType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERFolderSharingPolicyType

#pragma mark - Constructors

- (instancetype)initWithTeam {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSharingPolicyTypeTeam;
  }
  return self;
}

- (instancetype)initWithInviteOnly {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSharingPolicyTypeInviteOnly;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isTeam {
  return _tag == DBPAPERFolderSharingPolicyTypeTeam;
}

- (BOOL)isInviteOnly {
  return _tag == DBPAPERFolderSharingPolicyTypeInviteOnly;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERFolderSharingPolicyTypeTeam:
    return @"DBPAPERFolderSharingPolicyTypeTeam";
  case DBPAPERFolderSharingPolicyTypeInviteOnly:
    return @"DBPAPERFolderSharingPolicyTypeInviteOnly";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERFolderSharingPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERFolderSharingPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERFolderSharingPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERFolderSharingPolicyTypeTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERFolderSharingPolicyTypeInviteOnly:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderSharingPolicyType:other];
}

- (BOOL)isEqualToFolderSharingPolicyType:(DBPAPERFolderSharingPolicyType *)aFolderSharingPolicyType {
  if (self == aFolderSharingPolicyType) {
    return YES;
  }
  if (self.tag != aFolderSharingPolicyType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERFolderSharingPolicyTypeTeam:
    return [[self tagName] isEqual:[aFolderSharingPolicyType tagName]];
  case DBPAPERFolderSharingPolicyTypeInviteOnly:
    return [[self tagName] isEqual:[aFolderSharingPolicyType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERFolderSharingPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERFolderSharingPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isTeam]) {
    jsonDict[@".tag"] = @"team";
  } else if ([valueObj isInviteOnly]) {
    jsonDict[@".tag"] = @"invite_only";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERFolderSharingPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"team"]) {
    return [[DBPAPERFolderSharingPolicyType alloc] initWithTeam];
  } else if ([tag isEqualToString:@"invite_only"]) {
    return [[DBPAPERFolderSharingPolicyType alloc] initWithInviteOnly];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBPAPERFolderSubscriptionLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERFolderSubscriptionLevel

#pragma mark - Constructors

- (instancetype)initWithNone {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSubscriptionLevelNone;
  }
  return self;
}

- (instancetype)initWithActivityOnly {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSubscriptionLevelActivityOnly;
  }
  return self;
}

- (instancetype)initWithDailyEmails {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSubscriptionLevelDailyEmails;
  }
  return self;
}

- (instancetype)initWithWeeklyEmails {
  self = [super init];
  if (self) {
    _tag = DBPAPERFolderSubscriptionLevelWeeklyEmails;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isNone {
  return _tag == DBPAPERFolderSubscriptionLevelNone;
}

- (BOOL)isActivityOnly {
  return _tag == DBPAPERFolderSubscriptionLevelActivityOnly;
}

- (BOOL)isDailyEmails {
  return _tag == DBPAPERFolderSubscriptionLevelDailyEmails;
}

- (BOOL)isWeeklyEmails {
  return _tag == DBPAPERFolderSubscriptionLevelWeeklyEmails;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERFolderSubscriptionLevelNone:
    return @"DBPAPERFolderSubscriptionLevelNone";
  case DBPAPERFolderSubscriptionLevelActivityOnly:
    return @"DBPAPERFolderSubscriptionLevelActivityOnly";
  case DBPAPERFolderSubscriptionLevelDailyEmails:
    return @"DBPAPERFolderSubscriptionLevelDailyEmails";
  case DBPAPERFolderSubscriptionLevelWeeklyEmails:
    return @"DBPAPERFolderSubscriptionLevelWeeklyEmails";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERFolderSubscriptionLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERFolderSubscriptionLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERFolderSubscriptionLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERFolderSubscriptionLevelNone:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERFolderSubscriptionLevelActivityOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERFolderSubscriptionLevelDailyEmails:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERFolderSubscriptionLevelWeeklyEmails:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFolderSubscriptionLevel:other];
}

- (BOOL)isEqualToFolderSubscriptionLevel:(DBPAPERFolderSubscriptionLevel *)aFolderSubscriptionLevel {
  if (self == aFolderSubscriptionLevel) {
    return YES;
  }
  if (self.tag != aFolderSubscriptionLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERFolderSubscriptionLevelNone:
    return [[self tagName] isEqual:[aFolderSubscriptionLevel tagName]];
  case DBPAPERFolderSubscriptionLevelActivityOnly:
    return [[self tagName] isEqual:[aFolderSubscriptionLevel tagName]];
  case DBPAPERFolderSubscriptionLevelDailyEmails:
    return [[self tagName] isEqual:[aFolderSubscriptionLevel tagName]];
  case DBPAPERFolderSubscriptionLevelWeeklyEmails:
    return [[self tagName] isEqual:[aFolderSubscriptionLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERFolderSubscriptionLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERFolderSubscriptionLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNone]) {
    jsonDict[@".tag"] = @"none";
  } else if ([valueObj isActivityOnly]) {
    jsonDict[@".tag"] = @"activity_only";
  } else if ([valueObj isDailyEmails]) {
    jsonDict[@".tag"] = @"daily_emails";
  } else if ([valueObj isWeeklyEmails]) {
    jsonDict[@".tag"] = @"weekly_emails";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERFolderSubscriptionLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"none"]) {
    return [[DBPAPERFolderSubscriptionLevel alloc] initWithNone];
  } else if ([tag isEqualToString:@"activity_only"]) {
    return [[DBPAPERFolderSubscriptionLevel alloc] initWithActivityOnly];
  } else if ([tag isEqualToString:@"daily_emails"]) {
    return [[DBPAPERFolderSubscriptionLevel alloc] initWithDailyEmails];
  } else if ([tag isEqualToString:@"weekly_emails"]) {
    return [[DBPAPERFolderSubscriptionLevel alloc] initWithWeeklyEmails];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBPAPERFolder.h"
#import "DBPAPERFolderSharingPolicyType.h"
#import "DBPAPERFoldersContainingPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERFoldersContainingPaperDoc

#pragma mark - Constructors

- (instancetype)initWithFolderSharingPolicyType:(DBPAPERFolderSharingPolicyType *)folderSharingPolicyType
                                        folders:(NSArray<DBPAPERFolder *> *)folders {
  [DBStoneValidators
   nullableValidator:[DBStoneValidators arrayValidator:nil
                                              maxItems:nil
                                         itemValidator:[DBStoneValidators nonnullValidator:nil]]](folders);

  self = [super init];
  if (self) {
    _folderSharingPolicyType = folderSharingPolicyType;
    _folders = folders;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithFolderSharingPolicyType:nil folders:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERFoldersContainingPaperDocSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERFoldersContainingPaperDocSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERFoldersContainingPaperDocSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.folderSharingPolicyType != nil) {
    result = prime * result + [self.folderSharingPolicyType hash];
  }
  if (self.folders != nil) {
    result = prime * result + [self.folders hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFoldersContainingPaperDoc:other];
}

- (BOOL)isEqualToFoldersContainingPaperDoc:(DBPAPERFoldersContainingPaperDoc *)aFoldersContainingPaperDoc {
  if (self == aFoldersContainingPaperDoc) {
    return YES;
  }
  if (self.folderSharingPolicyType) {
    if (![self.folderSharingPolicyType isEqual:aFoldersContainingPaperDoc.folderSharingPolicyType]) {
      return NO;
    }
  }
  if (self.folders) {
    if (![self.folders isEqual:aFoldersContainingPaperDoc.folders]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERFoldersContainingPaperDocSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERFoldersContainingPaperDoc *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.folderSharingPolicyType) {
    jsonDict[@"folder_sharing_policy_type"] =
        [DBPAPERFolderSharingPolicyTypeSerializer serialize:valueObj.folderSharingPolicyType];
  }
  if (valueObj.folders) {
    jsonDict[@"folders"] = [DBArraySerializer serialize:valueObj.folders
                                              withBlock:^id(id elem0) {
                                                return [DBPAPERFolderSerializer serialize:elem0];
                                              }];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERFoldersContainingPaperDoc *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBPAPERFolderSharingPolicyType *folderSharingPolicyType =
      valueDict[@"folder_sharing_policy_type"]
          ? [DBPAPERFolderSharingPolicyTypeSerializer deserialize:valueDict[@"folder_sharing_policy_type"]]
          : nil;
  NSArray<DBPAPERFolder *> *folders = valueDict[@"folders"]
                                          ? [DBArraySerializer deserialize:valueDict[@"folders"]
                                                                 withBlock:^id(id elem0) {
                                                                   return [DBPAPERFolderSerializer deserialize:elem0];
                                                                 }]
                                          : nil;

  return [[DBPAPERFoldersContainingPaperDoc alloc] initWithFolderSharingPolicyType:folderSharingPolicyType
                                                                           folders:folders];
}

@end

#import "DBPAPERImportFormat.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERImportFormat

#pragma mark - Constructors

- (instancetype)initWithHtml {
  self = [super init];
  if (self) {
    _tag = DBPAPERImportFormatHtml;
  }
  return self;
}

- (instancetype)initWithMarkdown {
  self = [super init];
  if (self) {
    _tag = DBPAPERImportFormatMarkdown;
  }
  return self;
}

- (instancetype)initWithPlainText {
  self = [super init];
  if (self) {
    _tag = DBPAPERImportFormatPlainText;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERImportFormatOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isHtml {
  return _tag == DBPAPERImportFormatHtml;
}

- (BOOL)isMarkdown {
  return _tag == DBPAPERImportFormatMarkdown;
}

- (BOOL)isPlainText {
  return _tag == DBPAPERImportFormatPlainText;
}

- (BOOL)isOther {
  return _tag == DBPAPERImportFormatOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERImportFormatHtml:
    return @"DBPAPERImportFormatHtml";
  case DBPAPERImportFormatMarkdown:
    return @"DBPAPERImportFormatMarkdown";
  case DBPAPERImportFormatPlainText:
    return @"DBPAPERImportFormatPlainText";
  case DBPAPERImportFormatOther:
    return @"DBPAPERImportFormatOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERImportFormatSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERImportFormatSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERImportFormatSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERImportFormatHtml:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERImportFormatMarkdown:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERImportFormatPlainText:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERImportFormatOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToImportFormat:other];
}

- (BOOL)isEqualToImportFormat:(DBPAPERImportFormat *)anImportFormat {
  if (self == anImportFormat) {
    return YES;
  }
  if (self.tag != anImportFormat.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERImportFormatHtml:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBPAPERImportFormatMarkdown:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBPAPERImportFormatPlainText:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  case DBPAPERImportFormatOther:
    return [[self tagName] isEqual:[anImportFormat tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERImportFormatSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERImportFormat *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isHtml]) {
    jsonDict[@".tag"] = @"html";
  } else if ([valueObj isMarkdown]) {
    jsonDict[@".tag"] = @"markdown";
  } else if ([valueObj isPlainText]) {
    jsonDict[@".tag"] = @"plain_text";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERImportFormat *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"html"]) {
    return [[DBPAPERImportFormat alloc] initWithHtml];
  } else if ([tag isEqualToString:@"markdown"]) {
    return [[DBPAPERImportFormat alloc] initWithMarkdown];
  } else if ([tag isEqualToString:@"plain_text"]) {
    return [[DBPAPERImportFormat alloc] initWithPlainText];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERImportFormat alloc] initWithOther];
  } else {
    return [[DBPAPERImportFormat alloc] initWithOther];
  }
}

@end

#import "DBPAPERInviteeInfoWithPermissionLevel.h"
#import "DBPAPERPaperDocPermissionLevel.h"
#import "DBSHARINGInviteeInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERInviteeInfoWithPermissionLevel

#pragma mark - Constructors

- (instancetype)initWithInvitee:(DBSHARINGInviteeInfo *)invitee
                permissionLevel:(DBPAPERPaperDocPermissionLevel *)permissionLevel {
  [DBStoneValidators nonnullValidator:nil](invitee);
  [DBStoneValidators nonnullValidator:nil](permissionLevel);

  self = [super init];
  if (self) {
    _invitee = invitee;
    _permissionLevel = permissionLevel;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERInviteeInfoWithPermissionLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERInviteeInfoWithPermissionLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERInviteeInfoWithPermissionLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.invitee hash];
  result = prime * result + [self.permissionLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToInviteeInfoWithPermissionLevel:other];
}

- (BOOL)isEqualToInviteeInfoWithPermissionLevel:
    (DBPAPERInviteeInfoWithPermissionLevel *)anInviteeInfoWithPermissionLevel {
  if (self == anInviteeInfoWithPermissionLevel) {
    return YES;
  }
  if (![self.invitee isEqual:anInviteeInfoWithPermissionLevel.invitee]) {
    return NO;
  }
  if (![self.permissionLevel isEqual:anInviteeInfoWithPermissionLevel.permissionLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERInviteeInfoWithPermissionLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERInviteeInfoWithPermissionLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"invitee"] = [DBSHARINGInviteeInfoSerializer serialize:valueObj.invitee];
  jsonDict[@"permission_level"] = [DBPAPERPaperDocPermissionLevelSerializer serialize:valueObj.permissionLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERInviteeInfoWithPermissionLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGInviteeInfo *invitee = [DBSHARINGInviteeInfoSerializer deserialize:valueDict[@"invitee"]];
  DBPAPERPaperDocPermissionLevel *permissionLevel =
      [DBPAPERPaperDocPermissionLevelSerializer deserialize:valueDict[@"permission_level"]];

  return [[DBPAPERInviteeInfoWithPermissionLevel alloc] initWithInvitee:invitee permissionLevel:permissionLevel];
}

@end

#import "DBPAPERListDocsCursorError.h"
#import "DBPAPERPaperApiCursorError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListDocsCursorError

@synthesize cursorError = _cursorError;

#pragma mark - Constructors

- (instancetype)initWithCursorError:(DBPAPERPaperApiCursorError *)cursorError {
  self = [super init];
  if (self) {
    _tag = DBPAPERListDocsCursorErrorCursorError;
    _cursorError = cursorError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERListDocsCursorErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBPAPERPaperApiCursorError *)cursorError {
  if (![self isCursorError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBPAPERListDocsCursorErrorCursorError, but was %@.", [self tagName]];
  }
  return _cursorError;
}

#pragma mark - Tag state methods

- (BOOL)isCursorError {
  return _tag == DBPAPERListDocsCursorErrorCursorError;
}

- (BOOL)isOther {
  return _tag == DBPAPERListDocsCursorErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERListDocsCursorErrorCursorError:
    return @"DBPAPERListDocsCursorErrorCursorError";
  case DBPAPERListDocsCursorErrorOther:
    return @"DBPAPERListDocsCursorErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListDocsCursorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListDocsCursorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListDocsCursorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERListDocsCursorErrorCursorError:
    result = prime * result + [self.cursorError hash];
    break;
  case DBPAPERListDocsCursorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListDocsCursorError:other];
}

- (BOOL)isEqualToListDocsCursorError:(DBPAPERListDocsCursorError *)aListDocsCursorError {
  if (self == aListDocsCursorError) {
    return YES;
  }
  if (self.tag != aListDocsCursorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERListDocsCursorErrorCursorError:
    return [self.cursorError isEqual:aListDocsCursorError.cursorError];
  case DBPAPERListDocsCursorErrorOther:
    return [[self tagName] isEqual:[aListDocsCursorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListDocsCursorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListDocsCursorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isCursorError]) {
    jsonDict[@"cursor_error"] = [[DBPAPERPaperApiCursorErrorSerializer serialize:valueObj.cursorError] mutableCopy];
    jsonDict[@".tag"] = @"cursor_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListDocsCursorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"cursor_error"]) {
    DBPAPERPaperApiCursorError *cursorError =
        [DBPAPERPaperApiCursorErrorSerializer deserialize:valueDict[@"cursor_error"]];
    return [[DBPAPERListDocsCursorError alloc] initWithCursorError:cursorError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERListDocsCursorError alloc] initWithOther];
  } else {
    return [[DBPAPERListDocsCursorError alloc] initWithOther];
  }
}

@end

#import "DBPAPERListPaperDocsArgs.h"
#import "DBPAPERListPaperDocsFilterBy.h"
#import "DBPAPERListPaperDocsSortBy.h"
#import "DBPAPERListPaperDocsSortOrder.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsArgs

#pragma mark - Constructors

- (instancetype)initWithFilterBy:(DBPAPERListPaperDocsFilterBy *)filterBy
                          sortBy:(DBPAPERListPaperDocsSortBy *)sortBy
                       sortOrder:(DBPAPERListPaperDocsSortOrder *)sortOrder
                           limit:(NSNumber *)limit {

  self = [super init];
  if (self) {
    _filterBy = filterBy ?: [[DBPAPERListPaperDocsFilterBy alloc] initWithDocsAccessed];
    _sortBy = sortBy ?: [[DBPAPERListPaperDocsSortBy alloc] initWithAccessed];
    _sortOrder = sortOrder ?: [[DBPAPERListPaperDocsSortOrder alloc] initWithAscending];
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithFilterBy:nil sortBy:nil sortOrder:nil limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.filterBy hash];
  result = prime * result + [self.sortBy hash];
  result = prime * result + [self.sortOrder hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsArgs:other];
}

- (BOOL)isEqualToListPaperDocsArgs:(DBPAPERListPaperDocsArgs *)aListPaperDocsArgs {
  if (self == aListPaperDocsArgs) {
    return YES;
  }
  if (![self.filterBy isEqual:aListPaperDocsArgs.filterBy]) {
    return NO;
  }
  if (![self.sortBy isEqual:aListPaperDocsArgs.sortBy]) {
    return NO;
  }
  if (![self.sortOrder isEqual:aListPaperDocsArgs.sortOrder]) {
    return NO;
  }
  if (![self.limit isEqual:aListPaperDocsArgs.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"filter_by"] = [DBPAPERListPaperDocsFilterBySerializer serialize:valueObj.filterBy];
  jsonDict[@"sort_by"] = [DBPAPERListPaperDocsSortBySerializer serialize:valueObj.sortBy];
  jsonDict[@"sort_order"] = [DBPAPERListPaperDocsSortOrderSerializer serialize:valueObj.sortOrder];
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBPAPERListPaperDocsFilterBy *filterBy =
      valueDict[@"filter_by"] ? [DBPAPERListPaperDocsFilterBySerializer deserialize:valueDict[@"filter_by"]]
                              : [[DBPAPERListPaperDocsFilterBy alloc] initWithDocsAccessed];
  DBPAPERListPaperDocsSortBy *sortBy = valueDict[@"sort_by"]
                                           ? [DBPAPERListPaperDocsSortBySerializer deserialize:valueDict[@"sort_by"]]
                                           : [[DBPAPERListPaperDocsSortBy alloc] initWithAccessed];
  DBPAPERListPaperDocsSortOrder *sortOrder =
      valueDict[@"sort_order"] ? [DBPAPERListPaperDocsSortOrderSerializer deserialize:valueDict[@"sort_order"]]
                               : [[DBPAPERListPaperDocsSortOrder alloc] initWithAscending];
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBPAPERListPaperDocsArgs alloc] initWithFilterBy:filterBy sortBy:sortBy sortOrder:sortOrder limit:limit];
}

@end

#import "DBPAPERListPaperDocsContinueArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsContinueArgs

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsContinueArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsContinueArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsContinueArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsContinueArgs:other];
}

- (BOOL)isEqualToListPaperDocsContinueArgs:(DBPAPERListPaperDocsContinueArgs *)aListPaperDocsContinueArgs {
  if (self == aListPaperDocsContinueArgs) {
    return YES;
  }
  if (![self.cursor isEqual:aListPaperDocsContinueArgs.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsContinueArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsContinueArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsContinueArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBPAPERListPaperDocsContinueArgs alloc] initWithCursor:cursor];
}

@end

#import "DBPAPERListPaperDocsFilterBy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsFilterBy

#pragma mark - Constructors

- (instancetype)initWithDocsAccessed {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsFilterByDocsAccessed;
  }
  return self;
}

- (instancetype)initWithDocsCreated {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsFilterByDocsCreated;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsFilterByOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDocsAccessed {
  return _tag == DBPAPERListPaperDocsFilterByDocsAccessed;
}

- (BOOL)isDocsCreated {
  return _tag == DBPAPERListPaperDocsFilterByDocsCreated;
}

- (BOOL)isOther {
  return _tag == DBPAPERListPaperDocsFilterByOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERListPaperDocsFilterByDocsAccessed:
    return @"DBPAPERListPaperDocsFilterByDocsAccessed";
  case DBPAPERListPaperDocsFilterByDocsCreated:
    return @"DBPAPERListPaperDocsFilterByDocsCreated";
  case DBPAPERListPaperDocsFilterByOther:
    return @"DBPAPERListPaperDocsFilterByOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsFilterBySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsFilterBySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsFilterBySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERListPaperDocsFilterByDocsAccessed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsFilterByDocsCreated:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsFilterByOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsFilterBy:other];
}

- (BOOL)isEqualToListPaperDocsFilterBy:(DBPAPERListPaperDocsFilterBy *)aListPaperDocsFilterBy {
  if (self == aListPaperDocsFilterBy) {
    return YES;
  }
  if (self.tag != aListPaperDocsFilterBy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERListPaperDocsFilterByDocsAccessed:
    return [[self tagName] isEqual:[aListPaperDocsFilterBy tagName]];
  case DBPAPERListPaperDocsFilterByDocsCreated:
    return [[self tagName] isEqual:[aListPaperDocsFilterBy tagName]];
  case DBPAPERListPaperDocsFilterByOther:
    return [[self tagName] isEqual:[aListPaperDocsFilterBy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsFilterBySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsFilterBy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDocsAccessed]) {
    jsonDict[@".tag"] = @"docs_accessed";
  } else if ([valueObj isDocsCreated]) {
    jsonDict[@".tag"] = @"docs_created";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsFilterBy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"docs_accessed"]) {
    return [[DBPAPERListPaperDocsFilterBy alloc] initWithDocsAccessed];
  } else if ([tag isEqualToString:@"docs_created"]) {
    return [[DBPAPERListPaperDocsFilterBy alloc] initWithDocsCreated];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERListPaperDocsFilterBy alloc] initWithOther];
  } else {
    return [[DBPAPERListPaperDocsFilterBy alloc] initWithOther];
  }
}

@end

#import "DBPAPERCursor.h"
#import "DBPAPERListPaperDocsResponse.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsResponse

#pragma mark - Constructors

- (instancetype)initWithDocIds:(NSArray<NSString *> *)docIds
                        cursor:(DBPAPERCursor *)cursor
                       hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](docIds);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _docIds = docIds;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsResponseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsResponseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsResponseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docIds hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsResponse:other];
}

- (BOOL)isEqualToListPaperDocsResponse:(DBPAPERListPaperDocsResponse *)aListPaperDocsResponse {
  if (self == aListPaperDocsResponse) {
    return YES;
  }
  if (![self.docIds isEqual:aListPaperDocsResponse.docIds]) {
    return NO;
  }
  if (![self.cursor isEqual:aListPaperDocsResponse.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListPaperDocsResponse.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsResponseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsResponse *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_ids"] = [DBArraySerializer serialize:valueObj.docIds
                                            withBlock:^id(id elem0) {
                                              return elem0;
                                            }];
  jsonDict[@"cursor"] = [DBPAPERCursorSerializer serialize:valueObj.cursor];
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsResponse *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *docIds = [DBArraySerializer deserialize:valueDict[@"doc_ids"]
                                                     withBlock:^id(id elem0) {
                                                       return elem0;
                                                     }];
  DBPAPERCursor *cursor = [DBPAPERCursorSerializer deserialize:valueDict[@"cursor"]];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBPAPERListPaperDocsResponse alloc] initWithDocIds:docIds cursor:cursor hasMore:hasMore];
}

@end

#import "DBPAPERListPaperDocsSortBy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsSortBy

#pragma mark - Constructors

- (instancetype)initWithAccessed {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortByAccessed;
  }
  return self;
}

- (instancetype)initWithModified {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortByModified;
  }
  return self;
}

- (instancetype)initWithCreated {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortByCreated;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortByOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAccessed {
  return _tag == DBPAPERListPaperDocsSortByAccessed;
}

- (BOOL)isModified {
  return _tag == DBPAPERListPaperDocsSortByModified;
}

- (BOOL)isCreated {
  return _tag == DBPAPERListPaperDocsSortByCreated;
}

- (BOOL)isOther {
  return _tag == DBPAPERListPaperDocsSortByOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERListPaperDocsSortByAccessed:
    return @"DBPAPERListPaperDocsSortByAccessed";
  case DBPAPERListPaperDocsSortByModified:
    return @"DBPAPERListPaperDocsSortByModified";
  case DBPAPERListPaperDocsSortByCreated:
    return @"DBPAPERListPaperDocsSortByCreated";
  case DBPAPERListPaperDocsSortByOther:
    return @"DBPAPERListPaperDocsSortByOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsSortBySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsSortBySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsSortBySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERListPaperDocsSortByAccessed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsSortByModified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsSortByCreated:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsSortByOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsSortBy:other];
}

- (BOOL)isEqualToListPaperDocsSortBy:(DBPAPERListPaperDocsSortBy *)aListPaperDocsSortBy {
  if (self == aListPaperDocsSortBy) {
    return YES;
  }
  if (self.tag != aListPaperDocsSortBy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERListPaperDocsSortByAccessed:
    return [[self tagName] isEqual:[aListPaperDocsSortBy tagName]];
  case DBPAPERListPaperDocsSortByModified:
    return [[self tagName] isEqual:[aListPaperDocsSortBy tagName]];
  case DBPAPERListPaperDocsSortByCreated:
    return [[self tagName] isEqual:[aListPaperDocsSortBy tagName]];
  case DBPAPERListPaperDocsSortByOther:
    return [[self tagName] isEqual:[aListPaperDocsSortBy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsSortBySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsSortBy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAccessed]) {
    jsonDict[@".tag"] = @"accessed";
  } else if ([valueObj isModified]) {
    jsonDict[@".tag"] = @"modified";
  } else if ([valueObj isCreated]) {
    jsonDict[@".tag"] = @"created";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsSortBy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"accessed"]) {
    return [[DBPAPERListPaperDocsSortBy alloc] initWithAccessed];
  } else if ([tag isEqualToString:@"modified"]) {
    return [[DBPAPERListPaperDocsSortBy alloc] initWithModified];
  } else if ([tag isEqualToString:@"created"]) {
    return [[DBPAPERListPaperDocsSortBy alloc] initWithCreated];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERListPaperDocsSortBy alloc] initWithOther];
  } else {
    return [[DBPAPERListPaperDocsSortBy alloc] initWithOther];
  }
}

@end

#import "DBPAPERListPaperDocsSortOrder.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListPaperDocsSortOrder

#pragma mark - Constructors

- (instancetype)initWithAscending {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortOrderAscending;
  }
  return self;
}

- (instancetype)initWithDescending {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortOrderDescending;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERListPaperDocsSortOrderOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAscending {
  return _tag == DBPAPERListPaperDocsSortOrderAscending;
}

- (BOOL)isDescending {
  return _tag == DBPAPERListPaperDocsSortOrderDescending;
}

- (BOOL)isOther {
  return _tag == DBPAPERListPaperDocsSortOrderOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERListPaperDocsSortOrderAscending:
    return @"DBPAPERListPaperDocsSortOrderAscending";
  case DBPAPERListPaperDocsSortOrderDescending:
    return @"DBPAPERListPaperDocsSortOrderDescending";
  case DBPAPERListPaperDocsSortOrderOther:
    return @"DBPAPERListPaperDocsSortOrderOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListPaperDocsSortOrderSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListPaperDocsSortOrderSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListPaperDocsSortOrderSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERListPaperDocsSortOrderAscending:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsSortOrderDescending:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListPaperDocsSortOrderOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListPaperDocsSortOrder:other];
}

- (BOOL)isEqualToListPaperDocsSortOrder:(DBPAPERListPaperDocsSortOrder *)aListPaperDocsSortOrder {
  if (self == aListPaperDocsSortOrder) {
    return YES;
  }
  if (self.tag != aListPaperDocsSortOrder.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERListPaperDocsSortOrderAscending:
    return [[self tagName] isEqual:[aListPaperDocsSortOrder tagName]];
  case DBPAPERListPaperDocsSortOrderDescending:
    return [[self tagName] isEqual:[aListPaperDocsSortOrder tagName]];
  case DBPAPERListPaperDocsSortOrderOther:
    return [[self tagName] isEqual:[aListPaperDocsSortOrder tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListPaperDocsSortOrderSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListPaperDocsSortOrder *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAscending]) {
    jsonDict[@".tag"] = @"ascending";
  } else if ([valueObj isDescending]) {
    jsonDict[@".tag"] = @"descending";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListPaperDocsSortOrder *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"ascending"]) {
    return [[DBPAPERListPaperDocsSortOrder alloc] initWithAscending];
  } else if ([tag isEqualToString:@"descending"]) {
    return [[DBPAPERListPaperDocsSortOrder alloc] initWithDescending];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERListPaperDocsSortOrder alloc] initWithOther];
  } else {
    return [[DBPAPERListPaperDocsSortOrder alloc] initWithOther];
  }
}

@end

#import "DBPAPERListUsersCursorError.h"
#import "DBPAPERPaperApiBaseError.h"
#import "DBPAPERPaperApiCursorError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersCursorError

@synthesize cursorError = _cursorError;

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERListUsersCursorErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERListUsersCursorErrorOther;
  }
  return self;
}

- (instancetype)initWithDocNotFound {
  self = [super init];
  if (self) {
    _tag = DBPAPERListUsersCursorErrorDocNotFound;
  }
  return self;
}

- (instancetype)initWithCursorError:(DBPAPERPaperApiCursorError *)cursorError {
  self = [super init];
  if (self) {
    _tag = DBPAPERListUsersCursorErrorCursorError;
    _cursorError = cursorError;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBPAPERPaperApiCursorError *)cursorError {
  if (![self isCursorError]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBPAPERListUsersCursorErrorCursorError, but was %@.", [self tagName]];
  }
  return _cursorError;
}

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERListUsersCursorErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERListUsersCursorErrorOther;
}

- (BOOL)isDocNotFound {
  return _tag == DBPAPERListUsersCursorErrorDocNotFound;
}

- (BOOL)isCursorError {
  return _tag == DBPAPERListUsersCursorErrorCursorError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERListUsersCursorErrorInsufficientPermissions:
    return @"DBPAPERListUsersCursorErrorInsufficientPermissions";
  case DBPAPERListUsersCursorErrorOther:
    return @"DBPAPERListUsersCursorErrorOther";
  case DBPAPERListUsersCursorErrorDocNotFound:
    return @"DBPAPERListUsersCursorErrorDocNotFound";
  case DBPAPERListUsersCursorErrorCursorError:
    return @"DBPAPERListUsersCursorErrorCursorError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersCursorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersCursorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersCursorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERListUsersCursorErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListUsersCursorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListUsersCursorErrorDocNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERListUsersCursorErrorCursorError:
    result = prime * result + [self.cursorError hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersCursorError:other];
}

- (BOOL)isEqualToListUsersCursorError:(DBPAPERListUsersCursorError *)aListUsersCursorError {
  if (self == aListUsersCursorError) {
    return YES;
  }
  if (self.tag != aListUsersCursorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERListUsersCursorErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aListUsersCursorError tagName]];
  case DBPAPERListUsersCursorErrorOther:
    return [[self tagName] isEqual:[aListUsersCursorError tagName]];
  case DBPAPERListUsersCursorErrorDocNotFound:
    return [[self tagName] isEqual:[aListUsersCursorError tagName]];
  case DBPAPERListUsersCursorErrorCursorError:
    return [self.cursorError isEqual:aListUsersCursorError.cursorError];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersCursorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersCursorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isDocNotFound]) {
    jsonDict[@".tag"] = @"doc_not_found";
  } else if ([valueObj isCursorError]) {
    jsonDict[@"cursor_error"] = [[DBPAPERPaperApiCursorErrorSerializer serialize:valueObj.cursorError] mutableCopy];
    jsonDict[@".tag"] = @"cursor_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersCursorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERListUsersCursorError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERListUsersCursorError alloc] initWithOther];
  } else if ([tag isEqualToString:@"doc_not_found"]) {
    return [[DBPAPERListUsersCursorError alloc] initWithDocNotFound];
  } else if ([tag isEqualToString:@"cursor_error"]) {
    DBPAPERPaperApiCursorError *cursorError =
        [DBPAPERPaperApiCursorErrorSerializer deserialize:valueDict[@"cursor_error"]];
    return [[DBPAPERListUsersCursorError alloc] initWithCursorError:cursorError];
  } else {
    return [[DBPAPERListUsersCursorError alloc] initWithOther];
  }
}

@end

#import "DBPAPERListUsersOnFolderArgs.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnFolderArgs

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId limit:(NSNumber *)limit {
  [DBStoneValidators nonnullValidator:nil](docId);

  self = [super initWithDocId:docId];
  if (self) {
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initWithDocId:(NSString *)docId {
  return [self initWithDocId:docId limit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnFolderArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnFolderArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnFolderArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnFolderArgs:other];
}

- (BOOL)isEqualToListUsersOnFolderArgs:(DBPAPERListUsersOnFolderArgs *)aListUsersOnFolderArgs {
  if (self == aListUsersOnFolderArgs) {
    return YES;
  }
  if (![self.docId isEqual:aListUsersOnFolderArgs.docId]) {
    return NO;
  }
  if (![self.limit isEqual:aListUsersOnFolderArgs.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnFolderArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnFolderArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnFolderArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBPAPERListUsersOnFolderArgs alloc] initWithDocId:docId limit:limit];
}

@end

#import "DBPAPERListUsersOnFolderContinueArgs.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnFolderContinueArgs

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId cursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super initWithDocId:docId];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnFolderContinueArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnFolderContinueArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnFolderContinueArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnFolderContinueArgs:other];
}

- (BOOL)isEqualToListUsersOnFolderContinueArgs:(DBPAPERListUsersOnFolderContinueArgs *)aListUsersOnFolderContinueArgs {
  if (self == aListUsersOnFolderContinueArgs) {
    return YES;
  }
  if (![self.docId isEqual:aListUsersOnFolderContinueArgs.docId]) {
    return NO;
  }
  if (![self.cursor isEqual:aListUsersOnFolderContinueArgs.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnFolderContinueArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnFolderContinueArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnFolderContinueArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSString *cursor = valueDict[@"cursor"];

  return [[DBPAPERListUsersOnFolderContinueArgs alloc] initWithDocId:docId cursor:cursor];
}

@end

#import "DBPAPERCursor.h"
#import "DBPAPERListUsersOnFolderResponse.h"
#import "DBSHARINGInviteeInfo.h"
#import "DBSHARINGUserInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnFolderResponse

#pragma mark - Constructors

- (instancetype)initWithInvitees:(NSArray<DBSHARINGInviteeInfo *> *)invitees
                           users:(NSArray<DBSHARINGUserInfo *> *)users
                          cursor:(DBPAPERCursor *)cursor
                         hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](invitees);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _invitees = invitees;
    _users = users;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnFolderResponseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnFolderResponseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnFolderResponseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.invitees hash];
  result = prime * result + [self.users hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnFolderResponse:other];
}

- (BOOL)isEqualToListUsersOnFolderResponse:(DBPAPERListUsersOnFolderResponse *)aListUsersOnFolderResponse {
  if (self == aListUsersOnFolderResponse) {
    return YES;
  }
  if (![self.invitees isEqual:aListUsersOnFolderResponse.invitees]) {
    return NO;
  }
  if (![self.users isEqual:aListUsersOnFolderResponse.users]) {
    return NO;
  }
  if (![self.cursor isEqual:aListUsersOnFolderResponse.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListUsersOnFolderResponse.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnFolderResponseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnFolderResponse *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"invitees"] = [DBArraySerializer serialize:valueObj.invitees
                                             withBlock:^id(id elem0) {
                                               return [DBSHARINGInviteeInfoSerializer serialize:elem0];
                                             }];
  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBSHARINGUserInfoSerializer serialize:elem0];
                                          }];
  jsonDict[@"cursor"] = [DBPAPERCursorSerializer serialize:valueObj.cursor];
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnFolderResponse *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBSHARINGInviteeInfo *> *invitees =
      [DBArraySerializer deserialize:valueDict[@"invitees"]
                           withBlock:^id(id elem0) {
                             return [DBSHARINGInviteeInfoSerializer deserialize:elem0];
                           }];
  NSArray<DBSHARINGUserInfo *> *users = [DBArraySerializer deserialize:valueDict[@"users"]
                                                             withBlock:^id(id elem0) {
                                                               return [DBSHARINGUserInfoSerializer deserialize:elem0];
                                                             }];
  DBPAPERCursor *cursor = [DBPAPERCursorSerializer deserialize:valueDict[@"cursor"]];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBPAPERListUsersOnFolderResponse alloc] initWithInvitees:invitees users:users cursor:cursor hasMore:hasMore];
}

@end

#import "DBPAPERListUsersOnPaperDocArgs.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBPAPERUserOnPaperDocFilter.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnPaperDocArgs

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId
                        limit:(NSNumber *)limit
                     filterBy:(DBPAPERUserOnPaperDocFilter *)filterBy {
  [DBStoneValidators nonnullValidator:nil](docId);

  self = [super initWithDocId:docId];
  if (self) {
    _limit = limit ?: @(1000);
    _filterBy = filterBy ?: [[DBPAPERUserOnPaperDocFilter alloc] initWithShared];
  }
  return self;
}

- (instancetype)initWithDocId:(NSString *)docId {
  return [self initWithDocId:docId limit:nil filterBy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnPaperDocArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnPaperDocArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnPaperDocArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.limit hash];
  result = prime * result + [self.filterBy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnPaperDocArgs:other];
}

- (BOOL)isEqualToListUsersOnPaperDocArgs:(DBPAPERListUsersOnPaperDocArgs *)aListUsersOnPaperDocArgs {
  if (self == aListUsersOnPaperDocArgs) {
    return YES;
  }
  if (![self.docId isEqual:aListUsersOnPaperDocArgs.docId]) {
    return NO;
  }
  if (![self.limit isEqual:aListUsersOnPaperDocArgs.limit]) {
    return NO;
  }
  if (![self.filterBy isEqual:aListUsersOnPaperDocArgs.filterBy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnPaperDocArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnPaperDocArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"limit"] = valueObj.limit;
  jsonDict[@"filter_by"] = [DBPAPERUserOnPaperDocFilterSerializer serialize:valueObj.filterBy];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnPaperDocArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);
  DBPAPERUserOnPaperDocFilter *filterBy =
      valueDict[@"filter_by"] ? [DBPAPERUserOnPaperDocFilterSerializer deserialize:valueDict[@"filter_by"]]
                              : [[DBPAPERUserOnPaperDocFilter alloc] initWithShared];

  return [[DBPAPERListUsersOnPaperDocArgs alloc] initWithDocId:docId limit:limit filterBy:filterBy];
}

@end

#import "DBPAPERListUsersOnPaperDocContinueArgs.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnPaperDocContinueArgs

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId cursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super initWithDocId:docId];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnPaperDocContinueArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnPaperDocContinueArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnPaperDocContinueArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnPaperDocContinueArgs:other];
}

- (BOOL)isEqualToListUsersOnPaperDocContinueArgs:
    (DBPAPERListUsersOnPaperDocContinueArgs *)aListUsersOnPaperDocContinueArgs {
  if (self == aListUsersOnPaperDocContinueArgs) {
    return YES;
  }
  if (![self.docId isEqual:aListUsersOnPaperDocContinueArgs.docId]) {
    return NO;
  }
  if (![self.cursor isEqual:aListUsersOnPaperDocContinueArgs.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnPaperDocContinueArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnPaperDocContinueArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnPaperDocContinueArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSString *cursor = valueDict[@"cursor"];

  return [[DBPAPERListUsersOnPaperDocContinueArgs alloc] initWithDocId:docId cursor:cursor];
}

@end

#import "DBPAPERCursor.h"
#import "DBPAPERInviteeInfoWithPermissionLevel.h"
#import "DBPAPERListUsersOnPaperDocResponse.h"
#import "DBPAPERUserInfoWithPermissionLevel.h"
#import "DBSHARINGUserInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERListUsersOnPaperDocResponse

#pragma mark - Constructors

- (instancetype)initWithInvitees:(NSArray<DBPAPERInviteeInfoWithPermissionLevel *> *)invitees
                           users:(NSArray<DBPAPERUserInfoWithPermissionLevel *> *)users
                        docOwner:(DBSHARINGUserInfo *)docOwner
                          cursor:(DBPAPERCursor *)cursor
                         hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](invitees);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](users);
  [DBStoneValidators nonnullValidator:nil](docOwner);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _invitees = invitees;
    _users = users;
    _docOwner = docOwner;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERListUsersOnPaperDocResponseSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERListUsersOnPaperDocResponseSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERListUsersOnPaperDocResponseSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.invitees hash];
  result = prime * result + [self.users hash];
  result = prime * result + [self.docOwner hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListUsersOnPaperDocResponse:other];
}

- (BOOL)isEqualToListUsersOnPaperDocResponse:(DBPAPERListUsersOnPaperDocResponse *)aListUsersOnPaperDocResponse {
  if (self == aListUsersOnPaperDocResponse) {
    return YES;
  }
  if (![self.invitees isEqual:aListUsersOnPaperDocResponse.invitees]) {
    return NO;
  }
  if (![self.users isEqual:aListUsersOnPaperDocResponse.users]) {
    return NO;
  }
  if (![self.docOwner isEqual:aListUsersOnPaperDocResponse.docOwner]) {
    return NO;
  }
  if (![self.cursor isEqual:aListUsersOnPaperDocResponse.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListUsersOnPaperDocResponse.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERListUsersOnPaperDocResponseSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERListUsersOnPaperDocResponse *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"invitees"] = [DBArraySerializer serialize:valueObj.invitees
                                             withBlock:^id(id elem0) {
                                               return [DBPAPERInviteeInfoWithPermissionLevelSerializer serialize:elem0];
                                             }];
  jsonDict[@"users"] = [DBArraySerializer serialize:valueObj.users
                                          withBlock:^id(id elem0) {
                                            return [DBPAPERUserInfoWithPermissionLevelSerializer serialize:elem0];
                                          }];
  jsonDict[@"doc_owner"] = [DBSHARINGUserInfoSerializer serialize:valueObj.docOwner];
  jsonDict[@"cursor"] = [DBPAPERCursorSerializer serialize:valueObj.cursor];
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERListUsersOnPaperDocResponse *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBPAPERInviteeInfoWithPermissionLevel *> *invitees =
      [DBArraySerializer deserialize:valueDict[@"invitees"]
                           withBlock:^id(id elem0) {
                             return [DBPAPERInviteeInfoWithPermissionLevelSerializer deserialize:elem0];
                           }];
  NSArray<DBPAPERUserInfoWithPermissionLevel *> *users =
      [DBArraySerializer deserialize:valueDict[@"users"]
                           withBlock:^id(id elem0) {
                             return [DBPAPERUserInfoWithPermissionLevelSerializer deserialize:elem0];
                           }];
  DBSHARINGUserInfo *docOwner = [DBSHARINGUserInfoSerializer deserialize:valueDict[@"doc_owner"]];
  DBPAPERCursor *cursor = [DBPAPERCursorSerializer deserialize:valueDict[@"cursor"]];
  NSNumber *hasMore = valueDict[@"has_more"];

  return [[DBPAPERListUsersOnPaperDocResponse alloc] initWithInvitees:invitees
                                                                users:users
                                                             docOwner:docOwner
                                                               cursor:cursor
                                                              hasMore:hasMore];
}

@end

#import "DBPAPERPaperApiCursorError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperApiCursorError

#pragma mark - Constructors

- (instancetype)initWithExpiredCursor {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiCursorErrorExpiredCursor;
  }
  return self;
}

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiCursorErrorInvalidCursor;
  }
  return self;
}

- (instancetype)initWithWrongUserInCursor {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiCursorErrorWrongUserInCursor;
  }
  return self;
}

- (instancetype)initWithReset {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiCursorErrorReset;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperApiCursorErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isExpiredCursor {
  return _tag == DBPAPERPaperApiCursorErrorExpiredCursor;
}

- (BOOL)isInvalidCursor {
  return _tag == DBPAPERPaperApiCursorErrorInvalidCursor;
}

- (BOOL)isWrongUserInCursor {
  return _tag == DBPAPERPaperApiCursorErrorWrongUserInCursor;
}

- (BOOL)isReset {
  return _tag == DBPAPERPaperApiCursorErrorReset;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperApiCursorErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperApiCursorErrorExpiredCursor:
    return @"DBPAPERPaperApiCursorErrorExpiredCursor";
  case DBPAPERPaperApiCursorErrorInvalidCursor:
    return @"DBPAPERPaperApiCursorErrorInvalidCursor";
  case DBPAPERPaperApiCursorErrorWrongUserInCursor:
    return @"DBPAPERPaperApiCursorErrorWrongUserInCursor";
  case DBPAPERPaperApiCursorErrorReset:
    return @"DBPAPERPaperApiCursorErrorReset";
  case DBPAPERPaperApiCursorErrorOther:
    return @"DBPAPERPaperApiCursorErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperApiCursorErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperApiCursorErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperApiCursorErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperApiCursorErrorExpiredCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperApiCursorErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperApiCursorErrorWrongUserInCursor:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperApiCursorErrorReset:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperApiCursorErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperApiCursorError:other];
}

- (BOOL)isEqualToPaperApiCursorError:(DBPAPERPaperApiCursorError *)aPaperApiCursorError {
  if (self == aPaperApiCursorError) {
    return YES;
  }
  if (self.tag != aPaperApiCursorError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperApiCursorErrorExpiredCursor:
    return [[self tagName] isEqual:[aPaperApiCursorError tagName]];
  case DBPAPERPaperApiCursorErrorInvalidCursor:
    return [[self tagName] isEqual:[aPaperApiCursorError tagName]];
  case DBPAPERPaperApiCursorErrorWrongUserInCursor:
    return [[self tagName] isEqual:[aPaperApiCursorError tagName]];
  case DBPAPERPaperApiCursorErrorReset:
    return [[self tagName] isEqual:[aPaperApiCursorError tagName]];
  case DBPAPERPaperApiCursorErrorOther:
    return [[self tagName] isEqual:[aPaperApiCursorError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperApiCursorErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperApiCursorError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isExpiredCursor]) {
    jsonDict[@".tag"] = @"expired_cursor";
  } else if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else if ([valueObj isWrongUserInCursor]) {
    jsonDict[@".tag"] = @"wrong_user_in_cursor";
  } else if ([valueObj isReset]) {
    jsonDict[@".tag"] = @"reset";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperApiCursorError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"expired_cursor"]) {
    return [[DBPAPERPaperApiCursorError alloc] initWithExpiredCursor];
  } else if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBPAPERPaperApiCursorError alloc] initWithInvalidCursor];
  } else if ([tag isEqualToString:@"wrong_user_in_cursor"]) {
    return [[DBPAPERPaperApiCursorError alloc] initWithWrongUserInCursor];
  } else if ([tag isEqualToString:@"reset"]) {
    return [[DBPAPERPaperApiCursorError alloc] initWithReset];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperApiCursorError alloc] initWithOther];
  } else {
    return [[DBPAPERPaperApiCursorError alloc] initWithOther];
  }
}

@end

#import "DBPAPERImportFormat.h"
#import "DBPAPERPaperDocCreateArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocCreateArgs

#pragma mark - Constructors

- (instancetype)initWithImportFormat:(DBPAPERImportFormat *)importFormat parentFolderId:(NSString *)parentFolderId {
  [DBStoneValidators nonnullValidator:nil](importFormat);

  self = [super init];
  if (self) {
    _parentFolderId = parentFolderId;
    _importFormat = importFormat;
  }
  return self;
}

- (instancetype)initWithImportFormat:(DBPAPERImportFormat *)importFormat {
  return [self initWithImportFormat:importFormat parentFolderId:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocCreateArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocCreateArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocCreateArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.importFormat hash];
  if (self.parentFolderId != nil) {
    result = prime * result + [self.parentFolderId hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocCreateArgs:other];
}

- (BOOL)isEqualToPaperDocCreateArgs:(DBPAPERPaperDocCreateArgs *)aPaperDocCreateArgs {
  if (self == aPaperDocCreateArgs) {
    return YES;
  }
  if (![self.importFormat isEqual:aPaperDocCreateArgs.importFormat]) {
    return NO;
  }
  if (self.parentFolderId) {
    if (![self.parentFolderId isEqual:aPaperDocCreateArgs.parentFolderId]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocCreateArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocCreateArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"import_format"] = [DBPAPERImportFormatSerializer serialize:valueObj.importFormat];
  if (valueObj.parentFolderId) {
    jsonDict[@"parent_folder_id"] = valueObj.parentFolderId;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocCreateArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBPAPERImportFormat *importFormat = [DBPAPERImportFormatSerializer deserialize:valueDict[@"import_format"]];
  NSString *parentFolderId = valueDict[@"parent_folder_id"] ?: nil;

  return [[DBPAPERPaperDocCreateArgs alloc] initWithImportFormat:importFormat parentFolderId:parentFolderId];
}

@end

#import "DBPAPERPaperApiBaseError.h"
#import "DBPAPERPaperDocCreateError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocCreateError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorOther;
  }
  return self;
}

- (instancetype)initWithContentMalformed {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorContentMalformed;
  }
  return self;
}

- (instancetype)initWithFolderNotFound {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorFolderNotFound;
  }
  return self;
}

- (instancetype)initWithDocLengthExceeded {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorDocLengthExceeded;
  }
  return self;
}

- (instancetype)initWithImageSizeExceeded {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocCreateErrorImageSizeExceeded;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERPaperDocCreateErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperDocCreateErrorOther;
}

- (BOOL)isContentMalformed {
  return _tag == DBPAPERPaperDocCreateErrorContentMalformed;
}

- (BOOL)isFolderNotFound {
  return _tag == DBPAPERPaperDocCreateErrorFolderNotFound;
}

- (BOOL)isDocLengthExceeded {
  return _tag == DBPAPERPaperDocCreateErrorDocLengthExceeded;
}

- (BOOL)isImageSizeExceeded {
  return _tag == DBPAPERPaperDocCreateErrorImageSizeExceeded;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperDocCreateErrorInsufficientPermissions:
    return @"DBPAPERPaperDocCreateErrorInsufficientPermissions";
  case DBPAPERPaperDocCreateErrorOther:
    return @"DBPAPERPaperDocCreateErrorOther";
  case DBPAPERPaperDocCreateErrorContentMalformed:
    return @"DBPAPERPaperDocCreateErrorContentMalformed";
  case DBPAPERPaperDocCreateErrorFolderNotFound:
    return @"DBPAPERPaperDocCreateErrorFolderNotFound";
  case DBPAPERPaperDocCreateErrorDocLengthExceeded:
    return @"DBPAPERPaperDocCreateErrorDocLengthExceeded";
  case DBPAPERPaperDocCreateErrorImageSizeExceeded:
    return @"DBPAPERPaperDocCreateErrorImageSizeExceeded";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperDocCreateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocCreateErrorContentMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocCreateErrorFolderNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocCreateErrorDocLengthExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocCreateErrorImageSizeExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocCreateError:other];
}

- (BOOL)isEqualToPaperDocCreateError:(DBPAPERPaperDocCreateError *)aPaperDocCreateError {
  if (self == aPaperDocCreateError) {
    return YES;
  }
  if (self.tag != aPaperDocCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperDocCreateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  case DBPAPERPaperDocCreateErrorOther:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  case DBPAPERPaperDocCreateErrorContentMalformed:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  case DBPAPERPaperDocCreateErrorFolderNotFound:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  case DBPAPERPaperDocCreateErrorDocLengthExceeded:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  case DBPAPERPaperDocCreateErrorImageSizeExceeded:
    return [[self tagName] isEqual:[aPaperDocCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isContentMalformed]) {
    jsonDict[@".tag"] = @"content_malformed";
  } else if ([valueObj isFolderNotFound]) {
    jsonDict[@".tag"] = @"folder_not_found";
  } else if ([valueObj isDocLengthExceeded]) {
    jsonDict[@".tag"] = @"doc_length_exceeded";
  } else if ([valueObj isImageSizeExceeded]) {
    jsonDict[@".tag"] = @"image_size_exceeded";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"content_malformed"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithContentMalformed];
  } else if ([tag isEqualToString:@"folder_not_found"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithFolderNotFound];
  } else if ([tag isEqualToString:@"doc_length_exceeded"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithDocLengthExceeded];
  } else if ([tag isEqualToString:@"image_size_exceeded"]) {
    return [[DBPAPERPaperDocCreateError alloc] initWithImageSizeExceeded];
  } else {
    return [[DBPAPERPaperDocCreateError alloc] initWithOther];
  }
}

@end

#import "DBPAPERPaperDocCreateUpdateResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocCreateUpdateResult

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId revision:(NSNumber *)revision title:(NSString *)title {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](revision);
  [DBStoneValidators nonnullValidator:nil](title);

  self = [super init];
  if (self) {
    _docId = docId;
    _revision = revision;
    _title = title;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocCreateUpdateResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocCreateUpdateResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocCreateUpdateResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.revision hash];
  result = prime * result + [self.title hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocCreateUpdateResult:other];
}

- (BOOL)isEqualToPaperDocCreateUpdateResult:(DBPAPERPaperDocCreateUpdateResult *)aPaperDocCreateUpdateResult {
  if (self == aPaperDocCreateUpdateResult) {
    return YES;
  }
  if (![self.docId isEqual:aPaperDocCreateUpdateResult.docId]) {
    return NO;
  }
  if (![self.revision isEqual:aPaperDocCreateUpdateResult.revision]) {
    return NO;
  }
  if (![self.title isEqual:aPaperDocCreateUpdateResult.title]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocCreateUpdateResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocCreateUpdateResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"revision"] = valueObj.revision;
  jsonDict[@"title"] = valueObj.title;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocCreateUpdateResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  NSNumber *revision = valueDict[@"revision"];
  NSString *title = valueDict[@"title"];

  return [[DBPAPERPaperDocCreateUpdateResult alloc] initWithDocId:docId revision:revision title:title];
}

@end

#import "DBPAPERExportFormat.h"
#import "DBPAPERPaperDocExport.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocExport

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId exportFormat:(DBPAPERExportFormat *)exportFormat {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](exportFormat);

  self = [super initWithDocId:docId];
  if (self) {
    _exportFormat = exportFormat;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocExportSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocExportSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocExportSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.exportFormat hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocExport:other];
}

- (BOOL)isEqualToPaperDocExport:(DBPAPERPaperDocExport *)aPaperDocExport {
  if (self == aPaperDocExport) {
    return YES;
  }
  if (![self.docId isEqual:aPaperDocExport.docId]) {
    return NO;
  }
  if (![self.exportFormat isEqual:aPaperDocExport.exportFormat]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocExportSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocExport *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"export_format"] = [DBPAPERExportFormatSerializer serialize:valueObj.exportFormat];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocExport *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  DBPAPERExportFormat *exportFormat = [DBPAPERExportFormatSerializer deserialize:valueDict[@"export_format"]];

  return [[DBPAPERPaperDocExport alloc] initWithDocId:docId exportFormat:exportFormat];
}

@end

#import "DBPAPERPaperDocExportResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocExportResult

#pragma mark - Constructors

- (instancetype)initWithOwner:(NSString *)owner
                        title:(NSString *)title
                     revision:(NSNumber *)revision
                     mimeType:(NSString *)mimeType {
  [DBStoneValidators nonnullValidator:nil](owner);
  [DBStoneValidators nonnullValidator:nil](title);
  [DBStoneValidators nonnullValidator:nil](revision);
  [DBStoneValidators nonnullValidator:nil](mimeType);

  self = [super init];
  if (self) {
    _owner = owner;
    _title = title;
    _revision = revision;
    _mimeType = mimeType;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocExportResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocExportResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocExportResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.owner hash];
  result = prime * result + [self.title hash];
  result = prime * result + [self.revision hash];
  result = prime * result + [self.mimeType hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocExportResult:other];
}

- (BOOL)isEqualToPaperDocExportResult:(DBPAPERPaperDocExportResult *)aPaperDocExportResult {
  if (self == aPaperDocExportResult) {
    return YES;
  }
  if (![self.owner isEqual:aPaperDocExportResult.owner]) {
    return NO;
  }
  if (![self.title isEqual:aPaperDocExportResult.title]) {
    return NO;
  }
  if (![self.revision isEqual:aPaperDocExportResult.revision]) {
    return NO;
  }
  if (![self.mimeType isEqual:aPaperDocExportResult.mimeType]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocExportResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocExportResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"owner"] = valueObj.owner;
  jsonDict[@"title"] = valueObj.title;
  jsonDict[@"revision"] = valueObj.revision;
  jsonDict[@"mime_type"] = valueObj.mimeType;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocExportResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *owner = valueDict[@"owner"];
  NSString *title = valueDict[@"title"];
  NSNumber *revision = valueDict[@"revision"];
  NSString *mimeType = valueDict[@"mime_type"];

  return [[DBPAPERPaperDocExportResult alloc] initWithOwner:owner title:title revision:revision mimeType:mimeType];
}

@end

#import "DBPAPERPaperDocPermissionLevel.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocPermissionLevel

#pragma mark - Constructors

- (instancetype)initWithEdit {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocPermissionLevelEdit;
  }
  return self;
}

- (instancetype)initWithViewAndComment {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocPermissionLevelViewAndComment;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocPermissionLevelOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isEdit {
  return _tag == DBPAPERPaperDocPermissionLevelEdit;
}

- (BOOL)isViewAndComment {
  return _tag == DBPAPERPaperDocPermissionLevelViewAndComment;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperDocPermissionLevelOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperDocPermissionLevelEdit:
    return @"DBPAPERPaperDocPermissionLevelEdit";
  case DBPAPERPaperDocPermissionLevelViewAndComment:
    return @"DBPAPERPaperDocPermissionLevelViewAndComment";
  case DBPAPERPaperDocPermissionLevelOther:
    return @"DBPAPERPaperDocPermissionLevelOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocPermissionLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocPermissionLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocPermissionLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperDocPermissionLevelEdit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocPermissionLevelViewAndComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocPermissionLevelOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocPermissionLevel:other];
}

- (BOOL)isEqualToPaperDocPermissionLevel:(DBPAPERPaperDocPermissionLevel *)aPaperDocPermissionLevel {
  if (self == aPaperDocPermissionLevel) {
    return YES;
  }
  if (self.tag != aPaperDocPermissionLevel.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperDocPermissionLevelEdit:
    return [[self tagName] isEqual:[aPaperDocPermissionLevel tagName]];
  case DBPAPERPaperDocPermissionLevelViewAndComment:
    return [[self tagName] isEqual:[aPaperDocPermissionLevel tagName]];
  case DBPAPERPaperDocPermissionLevelOther:
    return [[self tagName] isEqual:[aPaperDocPermissionLevel tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocPermissionLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocPermissionLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isEdit]) {
    jsonDict[@".tag"] = @"edit";
  } else if ([valueObj isViewAndComment]) {
    jsonDict[@".tag"] = @"view_and_comment";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocPermissionLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"edit"]) {
    return [[DBPAPERPaperDocPermissionLevel alloc] initWithEdit];
  } else if ([tag isEqualToString:@"view_and_comment"]) {
    return [[DBPAPERPaperDocPermissionLevel alloc] initWithViewAndComment];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperDocPermissionLevel alloc] initWithOther];
  } else {
    return [[DBPAPERPaperDocPermissionLevel alloc] initWithOther];
  }
}

@end

#import "DBPAPERPaperDocSharingPolicy.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBPAPERSharingPolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocSharingPolicy

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId sharingPolicy:(DBPAPERSharingPolicy *)sharingPolicy {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](sharingPolicy);

  self = [super initWithDocId:docId];
  if (self) {
    _sharingPolicy = sharingPolicy;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocSharingPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocSharingPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocSharingPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.sharingPolicy hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocSharingPolicy:other];
}

- (BOOL)isEqualToPaperDocSharingPolicy:(DBPAPERPaperDocSharingPolicy *)aPaperDocSharingPolicy {
  if (self == aPaperDocSharingPolicy) {
    return YES;
  }
  if (![self.docId isEqual:aPaperDocSharingPolicy.docId]) {
    return NO;
  }
  if (![self.sharingPolicy isEqual:aPaperDocSharingPolicy.sharingPolicy]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocSharingPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocSharingPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"sharing_policy"] = [DBPAPERSharingPolicySerializer serialize:valueObj.sharingPolicy];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocSharingPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  DBPAPERSharingPolicy *sharingPolicy = [DBPAPERSharingPolicySerializer deserialize:valueDict[@"sharing_policy"]];

  return [[DBPAPERPaperDocSharingPolicy alloc] initWithDocId:docId sharingPolicy:sharingPolicy];
}

@end

#import "DBPAPERImportFormat.h"
#import "DBPAPERPaperDocUpdateArgs.h"
#import "DBPAPERPaperDocUpdatePolicy.h"
#import "DBPAPERRefPaperDoc.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocUpdateArgs

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId
              docUpdatePolicy:(DBPAPERPaperDocUpdatePolicy *)docUpdatePolicy
                     revision:(NSNumber *)revision
                 importFormat:(DBPAPERImportFormat *)importFormat {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](docUpdatePolicy);
  [DBStoneValidators nonnullValidator:nil](revision);
  [DBStoneValidators nonnullValidator:nil](importFormat);

  self = [super initWithDocId:docId];
  if (self) {
    _docUpdatePolicy = docUpdatePolicy;
    _revision = revision;
    _importFormat = importFormat;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocUpdateArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocUpdateArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocUpdateArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.docUpdatePolicy hash];
  result = prime * result + [self.revision hash];
  result = prime * result + [self.importFormat hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocUpdateArgs:other];
}

- (BOOL)isEqualToPaperDocUpdateArgs:(DBPAPERPaperDocUpdateArgs *)aPaperDocUpdateArgs {
  if (self == aPaperDocUpdateArgs) {
    return YES;
  }
  if (![self.docId isEqual:aPaperDocUpdateArgs.docId]) {
    return NO;
  }
  if (![self.docUpdatePolicy isEqual:aPaperDocUpdateArgs.docUpdatePolicy]) {
    return NO;
  }
  if (![self.revision isEqual:aPaperDocUpdateArgs.revision]) {
    return NO;
  }
  if (![self.importFormat isEqual:aPaperDocUpdateArgs.importFormat]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocUpdateArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocUpdateArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"doc_update_policy"] = [DBPAPERPaperDocUpdatePolicySerializer serialize:valueObj.docUpdatePolicy];
  jsonDict[@"revision"] = valueObj.revision;
  jsonDict[@"import_format"] = [DBPAPERImportFormatSerializer serialize:valueObj.importFormat];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocUpdateArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  DBPAPERPaperDocUpdatePolicy *docUpdatePolicy =
      [DBPAPERPaperDocUpdatePolicySerializer deserialize:valueDict[@"doc_update_policy"]];
  NSNumber *revision = valueDict[@"revision"];
  DBPAPERImportFormat *importFormat = [DBPAPERImportFormatSerializer deserialize:valueDict[@"import_format"]];

  return [[DBPAPERPaperDocUpdateArgs alloc] initWithDocId:docId
                                          docUpdatePolicy:docUpdatePolicy
                                                 revision:revision
                                             importFormat:importFormat];
}

@end

#import "DBPAPERDocLookupError.h"
#import "DBPAPERPaperDocUpdateError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocUpdateError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorOther;
  }
  return self;
}

- (instancetype)initWithDocNotFound {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorDocNotFound;
  }
  return self;
}

- (instancetype)initWithContentMalformed {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorContentMalformed;
  }
  return self;
}

- (instancetype)initWithRevisionMismatch {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorRevisionMismatch;
  }
  return self;
}

- (instancetype)initWithDocLengthExceeded {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorDocLengthExceeded;
  }
  return self;
}

- (instancetype)initWithImageSizeExceeded {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorImageSizeExceeded;
  }
  return self;
}

- (instancetype)initWithDocArchived {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorDocArchived;
  }
  return self;
}

- (instancetype)initWithDocDeleted {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdateErrorDocDeleted;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERPaperDocUpdateErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperDocUpdateErrorOther;
}

- (BOOL)isDocNotFound {
  return _tag == DBPAPERPaperDocUpdateErrorDocNotFound;
}

- (BOOL)isContentMalformed {
  return _tag == DBPAPERPaperDocUpdateErrorContentMalformed;
}

- (BOOL)isRevisionMismatch {
  return _tag == DBPAPERPaperDocUpdateErrorRevisionMismatch;
}

- (BOOL)isDocLengthExceeded {
  return _tag == DBPAPERPaperDocUpdateErrorDocLengthExceeded;
}

- (BOOL)isImageSizeExceeded {
  return _tag == DBPAPERPaperDocUpdateErrorImageSizeExceeded;
}

- (BOOL)isDocArchived {
  return _tag == DBPAPERPaperDocUpdateErrorDocArchived;
}

- (BOOL)isDocDeleted {
  return _tag == DBPAPERPaperDocUpdateErrorDocDeleted;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperDocUpdateErrorInsufficientPermissions:
    return @"DBPAPERPaperDocUpdateErrorInsufficientPermissions";
  case DBPAPERPaperDocUpdateErrorOther:
    return @"DBPAPERPaperDocUpdateErrorOther";
  case DBPAPERPaperDocUpdateErrorDocNotFound:
    return @"DBPAPERPaperDocUpdateErrorDocNotFound";
  case DBPAPERPaperDocUpdateErrorContentMalformed:
    return @"DBPAPERPaperDocUpdateErrorContentMalformed";
  case DBPAPERPaperDocUpdateErrorRevisionMismatch:
    return @"DBPAPERPaperDocUpdateErrorRevisionMismatch";
  case DBPAPERPaperDocUpdateErrorDocLengthExceeded:
    return @"DBPAPERPaperDocUpdateErrorDocLengthExceeded";
  case DBPAPERPaperDocUpdateErrorImageSizeExceeded:
    return @"DBPAPERPaperDocUpdateErrorImageSizeExceeded";
  case DBPAPERPaperDocUpdateErrorDocArchived:
    return @"DBPAPERPaperDocUpdateErrorDocArchived";
  case DBPAPERPaperDocUpdateErrorDocDeleted:
    return @"DBPAPERPaperDocUpdateErrorDocDeleted";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocUpdateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocUpdateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocUpdateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperDocUpdateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorDocNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorContentMalformed:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorRevisionMismatch:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorDocLengthExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorImageSizeExceeded:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorDocArchived:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdateErrorDocDeleted:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocUpdateError:other];
}

- (BOOL)isEqualToPaperDocUpdateError:(DBPAPERPaperDocUpdateError *)aPaperDocUpdateError {
  if (self == aPaperDocUpdateError) {
    return YES;
  }
  if (self.tag != aPaperDocUpdateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperDocUpdateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorOther:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorDocNotFound:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorContentMalformed:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorRevisionMismatch:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorDocLengthExceeded:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorImageSizeExceeded:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorDocArchived:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  case DBPAPERPaperDocUpdateErrorDocDeleted:
    return [[self tagName] isEqual:[aPaperDocUpdateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocUpdateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocUpdateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isDocNotFound]) {
    jsonDict[@".tag"] = @"doc_not_found";
  } else if ([valueObj isContentMalformed]) {
    jsonDict[@".tag"] = @"content_malformed";
  } else if ([valueObj isRevisionMismatch]) {
    jsonDict[@".tag"] = @"revision_mismatch";
  } else if ([valueObj isDocLengthExceeded]) {
    jsonDict[@".tag"] = @"doc_length_exceeded";
  } else if ([valueObj isImageSizeExceeded]) {
    jsonDict[@".tag"] = @"image_size_exceeded";
  } else if ([valueObj isDocArchived]) {
    jsonDict[@".tag"] = @"doc_archived";
  } else if ([valueObj isDocDeleted]) {
    jsonDict[@".tag"] = @"doc_deleted";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocUpdateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"doc_not_found"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithDocNotFound];
  } else if ([tag isEqualToString:@"content_malformed"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithContentMalformed];
  } else if ([tag isEqualToString:@"revision_mismatch"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithRevisionMismatch];
  } else if ([tag isEqualToString:@"doc_length_exceeded"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithDocLengthExceeded];
  } else if ([tag isEqualToString:@"image_size_exceeded"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithImageSizeExceeded];
  } else if ([tag isEqualToString:@"doc_archived"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithDocArchived];
  } else if ([tag isEqualToString:@"doc_deleted"]) {
    return [[DBPAPERPaperDocUpdateError alloc] initWithDocDeleted];
  } else {
    return [[DBPAPERPaperDocUpdateError alloc] initWithOther];
  }
}

@end

#import "DBPAPERPaperDocUpdatePolicy.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperDocUpdatePolicy

#pragma mark - Constructors

- (instancetype)initWithAppend {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdatePolicyAppend;
  }
  return self;
}

- (instancetype)initWithPrepend {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdatePolicyPrepend;
  }
  return self;
}

- (instancetype)initWithOverwriteAll {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdatePolicyOverwriteAll;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperDocUpdatePolicyOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isAppend {
  return _tag == DBPAPERPaperDocUpdatePolicyAppend;
}

- (BOOL)isPrepend {
  return _tag == DBPAPERPaperDocUpdatePolicyPrepend;
}

- (BOOL)isOverwriteAll {
  return _tag == DBPAPERPaperDocUpdatePolicyOverwriteAll;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperDocUpdatePolicyOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperDocUpdatePolicyAppend:
    return @"DBPAPERPaperDocUpdatePolicyAppend";
  case DBPAPERPaperDocUpdatePolicyPrepend:
    return @"DBPAPERPaperDocUpdatePolicyPrepend";
  case DBPAPERPaperDocUpdatePolicyOverwriteAll:
    return @"DBPAPERPaperDocUpdatePolicyOverwriteAll";
  case DBPAPERPaperDocUpdatePolicyOther:
    return @"DBPAPERPaperDocUpdatePolicyOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperDocUpdatePolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperDocUpdatePolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperDocUpdatePolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperDocUpdatePolicyAppend:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdatePolicyPrepend:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdatePolicyOverwriteAll:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperDocUpdatePolicyOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperDocUpdatePolicy:other];
}

- (BOOL)isEqualToPaperDocUpdatePolicy:(DBPAPERPaperDocUpdatePolicy *)aPaperDocUpdatePolicy {
  if (self == aPaperDocUpdatePolicy) {
    return YES;
  }
  if (self.tag != aPaperDocUpdatePolicy.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperDocUpdatePolicyAppend:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBPAPERPaperDocUpdatePolicyPrepend:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBPAPERPaperDocUpdatePolicyOverwriteAll:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  case DBPAPERPaperDocUpdatePolicyOther:
    return [[self tagName] isEqual:[aPaperDocUpdatePolicy tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperDocUpdatePolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperDocUpdatePolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isAppend]) {
    jsonDict[@".tag"] = @"append";
  } else if ([valueObj isPrepend]) {
    jsonDict[@".tag"] = @"prepend";
  } else if ([valueObj isOverwriteAll]) {
    jsonDict[@".tag"] = @"overwrite_all";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperDocUpdatePolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"append"]) {
    return [[DBPAPERPaperDocUpdatePolicy alloc] initWithAppend];
  } else if ([tag isEqualToString:@"prepend"]) {
    return [[DBPAPERPaperDocUpdatePolicy alloc] initWithPrepend];
  } else if ([tag isEqualToString:@"overwrite_all"]) {
    return [[DBPAPERPaperDocUpdatePolicy alloc] initWithOverwriteAll];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperDocUpdatePolicy alloc] initWithOther];
  } else {
    return [[DBPAPERPaperDocUpdatePolicy alloc] initWithOther];
  }
}

@end

#import "DBPAPERPaperFolderCreateArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperFolderCreateArg

#pragma mark - Constructors

- (instancetype)initWithName:(NSString *)name
              parentFolderId:(NSString *)parentFolderId
                isTeamFolder:(NSNumber *)isTeamFolder {
  [DBStoneValidators nonnullValidator:nil](name);

  self = [super init];
  if (self) {
    _name = name;
    _parentFolderId = parentFolderId;
    _isTeamFolder = isTeamFolder;
  }
  return self;
}

- (instancetype)initWithName:(NSString *)name {
  return [self initWithName:name parentFolderId:nil isTeamFolder:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperFolderCreateArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperFolderCreateArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperFolderCreateArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.name hash];
  if (self.parentFolderId != nil) {
    result = prime * result + [self.parentFolderId hash];
  }
  if (self.isTeamFolder != nil) {
    result = prime * result + [self.isTeamFolder hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperFolderCreateArg:other];
}

- (BOOL)isEqualToPaperFolderCreateArg:(DBPAPERPaperFolderCreateArg *)aPaperFolderCreateArg {
  if (self == aPaperFolderCreateArg) {
    return YES;
  }
  if (![self.name isEqual:aPaperFolderCreateArg.name]) {
    return NO;
  }
  if (self.parentFolderId) {
    if (![self.parentFolderId isEqual:aPaperFolderCreateArg.parentFolderId]) {
      return NO;
    }
  }
  if (self.isTeamFolder) {
    if (![self.isTeamFolder isEqual:aPaperFolderCreateArg.isTeamFolder]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperFolderCreateArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperFolderCreateArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"name"] = valueObj.name;
  if (valueObj.parentFolderId) {
    jsonDict[@"parent_folder_id"] = valueObj.parentFolderId;
  }
  if (valueObj.isTeamFolder) {
    jsonDict[@"is_team_folder"] = valueObj.isTeamFolder;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperFolderCreateArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *name = valueDict[@"name"];
  NSString *parentFolderId = valueDict[@"parent_folder_id"] ?: nil;
  NSNumber *isTeamFolder = valueDict[@"is_team_folder"] ?: nil;

  return
      [[DBPAPERPaperFolderCreateArg alloc] initWithName:name parentFolderId:parentFolderId isTeamFolder:isTeamFolder];
}

@end

#import "DBPAPERPaperApiBaseError.h"
#import "DBPAPERPaperFolderCreateError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperFolderCreateError

#pragma mark - Constructors

- (instancetype)initWithInsufficientPermissions {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperFolderCreateErrorInsufficientPermissions;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperFolderCreateErrorOther;
  }
  return self;
}

- (instancetype)initWithFolderNotFound {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperFolderCreateErrorFolderNotFound;
  }
  return self;
}

- (instancetype)initWithInvalidFolderId {
  self = [super init];
  if (self) {
    _tag = DBPAPERPaperFolderCreateErrorInvalidFolderId;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isInsufficientPermissions {
  return _tag == DBPAPERPaperFolderCreateErrorInsufficientPermissions;
}

- (BOOL)isOther {
  return _tag == DBPAPERPaperFolderCreateErrorOther;
}

- (BOOL)isFolderNotFound {
  return _tag == DBPAPERPaperFolderCreateErrorFolderNotFound;
}

- (BOOL)isInvalidFolderId {
  return _tag == DBPAPERPaperFolderCreateErrorInvalidFolderId;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERPaperFolderCreateErrorInsufficientPermissions:
    return @"DBPAPERPaperFolderCreateErrorInsufficientPermissions";
  case DBPAPERPaperFolderCreateErrorOther:
    return @"DBPAPERPaperFolderCreateErrorOther";
  case DBPAPERPaperFolderCreateErrorFolderNotFound:
    return @"DBPAPERPaperFolderCreateErrorFolderNotFound";
  case DBPAPERPaperFolderCreateErrorInvalidFolderId:
    return @"DBPAPERPaperFolderCreateErrorInvalidFolderId";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperFolderCreateErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperFolderCreateErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperFolderCreateErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERPaperFolderCreateErrorInsufficientPermissions:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperFolderCreateErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperFolderCreateErrorFolderNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERPaperFolderCreateErrorInvalidFolderId:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperFolderCreateError:other];
}

- (BOOL)isEqualToPaperFolderCreateError:(DBPAPERPaperFolderCreateError *)aPaperFolderCreateError {
  if (self == aPaperFolderCreateError) {
    return YES;
  }
  if (self.tag != aPaperFolderCreateError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERPaperFolderCreateErrorInsufficientPermissions:
    return [[self tagName] isEqual:[aPaperFolderCreateError tagName]];
  case DBPAPERPaperFolderCreateErrorOther:
    return [[self tagName] isEqual:[aPaperFolderCreateError tagName]];
  case DBPAPERPaperFolderCreateErrorFolderNotFound:
    return [[self tagName] isEqual:[aPaperFolderCreateError tagName]];
  case DBPAPERPaperFolderCreateErrorInvalidFolderId:
    return [[self tagName] isEqual:[aPaperFolderCreateError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperFolderCreateErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperFolderCreateError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isInsufficientPermissions]) {
    jsonDict[@".tag"] = @"insufficient_permissions";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isFolderNotFound]) {
    jsonDict[@".tag"] = @"folder_not_found";
  } else if ([valueObj isInvalidFolderId]) {
    jsonDict[@".tag"] = @"invalid_folder_id";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperFolderCreateError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"insufficient_permissions"]) {
    return [[DBPAPERPaperFolderCreateError alloc] initWithInsufficientPermissions];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERPaperFolderCreateError alloc] initWithOther];
  } else if ([tag isEqualToString:@"folder_not_found"]) {
    return [[DBPAPERPaperFolderCreateError alloc] initWithFolderNotFound];
  } else if ([tag isEqualToString:@"invalid_folder_id"]) {
    return [[DBPAPERPaperFolderCreateError alloc] initWithInvalidFolderId];
  } else {
    return [[DBPAPERPaperFolderCreateError alloc] initWithOther];
  }
}

@end

#import "DBPAPERPaperFolderCreateResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERPaperFolderCreateResult

#pragma mark - Constructors

- (instancetype)initWithFolderId:(NSString *)folderId {
  [DBStoneValidators nonnullValidator:nil](folderId);

  self = [super init];
  if (self) {
    _folderId = folderId;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERPaperFolderCreateResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERPaperFolderCreateResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERPaperFolderCreateResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.folderId hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPaperFolderCreateResult:other];
}

- (BOOL)isEqualToPaperFolderCreateResult:(DBPAPERPaperFolderCreateResult *)aPaperFolderCreateResult {
  if (self == aPaperFolderCreateResult) {
    return YES;
  }
  if (![self.folderId isEqual:aPaperFolderCreateResult.folderId]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERPaperFolderCreateResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERPaperFolderCreateResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"folder_id"] = valueObj.folderId;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERPaperFolderCreateResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *folderId = valueDict[@"folder_id"];

  return [[DBPAPERPaperFolderCreateResult alloc] initWithFolderId:folderId];
}

@end

#import "DBPAPERRefPaperDoc.h"
#import "DBPAPERRemovePaperDocUser.h"
#import "DBSHARINGMemberSelector.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERRemovePaperDocUser

#pragma mark - Constructors

- (instancetype)initWithDocId:(NSString *)docId member:(DBSHARINGMemberSelector *)member {
  [DBStoneValidators nonnullValidator:nil](docId);
  [DBStoneValidators nonnullValidator:nil](member);

  self = [super initWithDocId:docId];
  if (self) {
    _member = member;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERRemovePaperDocUserSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERRemovePaperDocUserSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERRemovePaperDocUserSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.docId hash];
  result = prime * result + [self.member hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToRemovePaperDocUser:other];
}

- (BOOL)isEqualToRemovePaperDocUser:(DBPAPERRemovePaperDocUser *)aRemovePaperDocUser {
  if (self == aRemovePaperDocUser) {
    return YES;
  }
  if (![self.docId isEqual:aRemovePaperDocUser.docId]) {
    return NO;
  }
  if (![self.member isEqual:aRemovePaperDocUser.member]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERRemovePaperDocUserSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERRemovePaperDocUser *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"doc_id"] = valueObj.docId;
  jsonDict[@"member"] = [DBSHARINGMemberSelectorSerializer serialize:valueObj.member];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERRemovePaperDocUser *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *docId = valueDict[@"doc_id"];
  DBSHARINGMemberSelector *member = [DBSHARINGMemberSelectorSerializer deserialize:valueDict[@"member"]];

  return [[DBPAPERRemovePaperDocUser alloc] initWithDocId:docId member:member];
}

@end

#import "DBPAPERSharingPolicy.h"
#import "DBPAPERSharingPublicPolicyType.h"
#import "DBPAPERSharingTeamPolicyType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERSharingPolicy

#pragma mark - Constructors

- (instancetype)initWithPublicSharingPolicy:(DBPAPERSharingPublicPolicyType *)publicSharingPolicy
                          teamSharingPolicy:(DBPAPERSharingTeamPolicyType *)teamSharingPolicy {

  self = [super init];
  if (self) {
    _publicSharingPolicy = publicSharingPolicy;
    _teamSharingPolicy = teamSharingPolicy;
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithPublicSharingPolicy:nil teamSharingPolicy:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERSharingPolicySerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERSharingPolicySerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERSharingPolicySerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  if (self.publicSharingPolicy != nil) {
    result = prime * result + [self.publicSharingPolicy hash];
  }
  if (self.teamSharingPolicy != nil) {
    result = prime * result + [self.teamSharingPolicy hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingPolicy:other];
}

- (BOOL)isEqualToSharingPolicy:(DBPAPERSharingPolicy *)aSharingPolicy {
  if (self == aSharingPolicy) {
    return YES;
  }
  if (self.publicSharingPolicy) {
    if (![self.publicSharingPolicy isEqual:aSharingPolicy.publicSharingPolicy]) {
      return NO;
    }
  }
  if (self.teamSharingPolicy) {
    if (![self.teamSharingPolicy isEqual:aSharingPolicy.teamSharingPolicy]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERSharingPolicySerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERSharingPolicy *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if (valueObj.publicSharingPolicy) {
    jsonDict[@"public_sharing_policy"] =
        [DBPAPERSharingPublicPolicyTypeSerializer serialize:valueObj.publicSharingPolicy];
  }
  if (valueObj.teamSharingPolicy) {
    jsonDict[@"team_sharing_policy"] = [DBPAPERSharingTeamPolicyTypeSerializer serialize:valueObj.teamSharingPolicy];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERSharingPolicy *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBPAPERSharingPublicPolicyType *publicSharingPolicy =
      valueDict[@"public_sharing_policy"]
          ? [DBPAPERSharingPublicPolicyTypeSerializer deserialize:valueDict[@"public_sharing_policy"]]
          : nil;
  DBPAPERSharingTeamPolicyType *teamSharingPolicy =
      valueDict[@"team_sharing_policy"]
          ? [DBPAPERSharingTeamPolicyTypeSerializer deserialize:valueDict[@"team_sharing_policy"]]
          : nil;

  return [[DBPAPERSharingPolicy alloc] initWithPublicSharingPolicy:publicSharingPolicy
                                                 teamSharingPolicy:teamSharingPolicy];
}

@end

#import "DBPAPERSharingTeamPolicyType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERSharingTeamPolicyType

#pragma mark - Constructors

- (instancetype)initWithPeopleWithLinkCanEdit {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit;
  }
  return self;
}

- (instancetype)initWithPeopleWithLinkCanViewAndComment {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment;
  }
  return self;
}

- (instancetype)initWithInviteOnly {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingTeamPolicyTypeInviteOnly;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPeopleWithLinkCanEdit {
  return _tag == DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit;
}

- (BOOL)isPeopleWithLinkCanViewAndComment {
  return _tag == DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment;
}

- (BOOL)isInviteOnly {
  return _tag == DBPAPERSharingTeamPolicyTypeInviteOnly;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit:
    return @"DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit";
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment:
    return @"DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment";
  case DBPAPERSharingTeamPolicyTypeInviteOnly:
    return @"DBPAPERSharingTeamPolicyTypeInviteOnly";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERSharingTeamPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERSharingTeamPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERSharingTeamPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERSharingTeamPolicyTypeInviteOnly:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingTeamPolicyType:other];
}

- (BOOL)isEqualToSharingTeamPolicyType:(DBPAPERSharingTeamPolicyType *)aSharingTeamPolicyType {
  if (self == aSharingTeamPolicyType) {
    return YES;
  }
  if (self.tag != aSharingTeamPolicyType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanEdit:
    return [[self tagName] isEqual:[aSharingTeamPolicyType tagName]];
  case DBPAPERSharingTeamPolicyTypePeopleWithLinkCanViewAndComment:
    return [[self tagName] isEqual:[aSharingTeamPolicyType tagName]];
  case DBPAPERSharingTeamPolicyTypeInviteOnly:
    return [[self tagName] isEqual:[aSharingTeamPolicyType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERSharingTeamPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERSharingTeamPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPeopleWithLinkCanEdit]) {
    jsonDict[@".tag"] = @"people_with_link_can_edit";
  } else if ([valueObj isPeopleWithLinkCanViewAndComment]) {
    jsonDict[@".tag"] = @"people_with_link_can_view_and_comment";
  } else if ([valueObj isInviteOnly]) {
    jsonDict[@".tag"] = @"invite_only";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERSharingTeamPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"people_with_link_can_edit"]) {
    return [[DBPAPERSharingTeamPolicyType alloc] initWithPeopleWithLinkCanEdit];
  } else if ([tag isEqualToString:@"people_with_link_can_view_and_comment"]) {
    return [[DBPAPERSharingTeamPolicyType alloc] initWithPeopleWithLinkCanViewAndComment];
  } else if ([tag isEqualToString:@"invite_only"]) {
    return [[DBPAPERSharingTeamPolicyType alloc] initWithInviteOnly];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBPAPERSharingPublicPolicyType.h"
#import "DBPAPERSharingTeamPolicyType.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERSharingPublicPolicyType

#pragma mark - Constructors

- (instancetype)initWithPeopleWithLinkCanEdit {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit;
  }
  return self;
}

- (instancetype)initWithPeopleWithLinkCanViewAndComment {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment;
  }
  return self;
}

- (instancetype)initWithInviteOnly {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingPublicPolicyTypeInviteOnly;
  }
  return self;
}

- (instancetype)initWithDisabled {
  self = [super init];
  if (self) {
    _tag = DBPAPERSharingPublicPolicyTypeDisabled;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isPeopleWithLinkCanEdit {
  return _tag == DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit;
}

- (BOOL)isPeopleWithLinkCanViewAndComment {
  return _tag == DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment;
}

- (BOOL)isInviteOnly {
  return _tag == DBPAPERSharingPublicPolicyTypeInviteOnly;
}

- (BOOL)isDisabled {
  return _tag == DBPAPERSharingPublicPolicyTypeDisabled;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit:
    return @"DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit";
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment:
    return @"DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment";
  case DBPAPERSharingPublicPolicyTypeInviteOnly:
    return @"DBPAPERSharingPublicPolicyTypeInviteOnly";
  case DBPAPERSharingPublicPolicyTypeDisabled:
    return @"DBPAPERSharingPublicPolicyTypeDisabled";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERSharingPublicPolicyTypeSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERSharingPublicPolicyTypeSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERSharingPublicPolicyTypeSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERSharingPublicPolicyTypeInviteOnly:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERSharingPublicPolicyTypeDisabled:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSharingPublicPolicyType:other];
}

- (BOOL)isEqualToSharingPublicPolicyType:(DBPAPERSharingPublicPolicyType *)aSharingPublicPolicyType {
  if (self == aSharingPublicPolicyType) {
    return YES;
  }
  if (self.tag != aSharingPublicPolicyType.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanEdit:
    return [[self tagName] isEqual:[aSharingPublicPolicyType tagName]];
  case DBPAPERSharingPublicPolicyTypePeopleWithLinkCanViewAndComment:
    return [[self tagName] isEqual:[aSharingPublicPolicyType tagName]];
  case DBPAPERSharingPublicPolicyTypeInviteOnly:
    return [[self tagName] isEqual:[aSharingPublicPolicyType tagName]];
  case DBPAPERSharingPublicPolicyTypeDisabled:
    return [[self tagName] isEqual:[aSharingPublicPolicyType tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERSharingPublicPolicyTypeSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERSharingPublicPolicyType *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isPeopleWithLinkCanEdit]) {
    jsonDict[@".tag"] = @"people_with_link_can_edit";
  } else if ([valueObj isPeopleWithLinkCanViewAndComment]) {
    jsonDict[@".tag"] = @"people_with_link_can_view_and_comment";
  } else if ([valueObj isInviteOnly]) {
    jsonDict[@".tag"] = @"invite_only";
  } else if ([valueObj isDisabled]) {
    jsonDict[@".tag"] = @"disabled";
  } else {
    @throw([NSException exceptionWithName:@"InvalidTag"
                                   reason:@"Object not properly initialized. Tag has an unknown value."
                                 userInfo:nil]);
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERSharingPublicPolicyType *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"people_with_link_can_edit"]) {
    return [[DBPAPERSharingPublicPolicyType alloc] initWithPeopleWithLinkCanEdit];
  } else if ([tag isEqualToString:@"people_with_link_can_view_and_comment"]) {
    return [[DBPAPERSharingPublicPolicyType alloc] initWithPeopleWithLinkCanViewAndComment];
  } else if ([tag isEqualToString:@"invite_only"]) {
    return [[DBPAPERSharingPublicPolicyType alloc] initWithInviteOnly];
  } else if ([tag isEqualToString:@"disabled"]) {
    return [[DBPAPERSharingPublicPolicyType alloc] initWithDisabled];
  } else {
    @throw([NSException
        exceptionWithName:@"InvalidTag"
                   reason:[NSString stringWithFormat:@"Tag has an invalid value: \"%@\".", valueDict[@".tag"]]
                 userInfo:nil]);
  }
}

@end

#import "DBPAPERPaperDocPermissionLevel.h"
#import "DBPAPERUserInfoWithPermissionLevel.h"
#import "DBSHARINGUserInfo.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERUserInfoWithPermissionLevel

#pragma mark - Constructors

- (instancetype)initWithUser:(DBSHARINGUserInfo *)user
             permissionLevel:(DBPAPERPaperDocPermissionLevel *)permissionLevel {
  [DBStoneValidators nonnullValidator:nil](user);
  [DBStoneValidators nonnullValidator:nil](permissionLevel);

  self = [super init];
  if (self) {
    _user = user;
    _permissionLevel = permissionLevel;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERUserInfoWithPermissionLevelSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERUserInfoWithPermissionLevelSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERUserInfoWithPermissionLevelSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.user hash];
  result = prime * result + [self.permissionLevel hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserInfoWithPermissionLevel:other];
}

- (BOOL)isEqualToUserInfoWithPermissionLevel:(DBPAPERUserInfoWithPermissionLevel *)anUserInfoWithPermissionLevel {
  if (self == anUserInfoWithPermissionLevel) {
    return YES;
  }
  if (![self.user isEqual:anUserInfoWithPermissionLevel.user]) {
    return NO;
  }
  if (![self.permissionLevel isEqual:anUserInfoWithPermissionLevel.permissionLevel]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERUserInfoWithPermissionLevelSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERUserInfoWithPermissionLevel *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"user"] = [DBSHARINGUserInfoSerializer serialize:valueObj.user];
  jsonDict[@"permission_level"] = [DBPAPERPaperDocPermissionLevelSerializer serialize:valueObj.permissionLevel];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERUserInfoWithPermissionLevel *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBSHARINGUserInfo *user = [DBSHARINGUserInfoSerializer deserialize:valueDict[@"user"]];
  DBPAPERPaperDocPermissionLevel *permissionLevel =
      [DBPAPERPaperDocPermissionLevelSerializer deserialize:valueDict[@"permission_level"]];

  return [[DBPAPERUserInfoWithPermissionLevel alloc] initWithUser:user permissionLevel:permissionLevel];
}

@end

#import "DBPAPERUserOnPaperDocFilter.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBPAPERUserOnPaperDocFilter

#pragma mark - Constructors

- (instancetype)initWithVisited {
  self = [super init];
  if (self) {
    _tag = DBPAPERUserOnPaperDocFilterVisited;
  }
  return self;
}

- (instancetype)initWithShared {
  self = [super init];
  if (self) {
    _tag = DBPAPERUserOnPaperDocFilterShared;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBPAPERUserOnPaperDocFilterOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isVisited {
  return _tag == DBPAPERUserOnPaperDocFilterVisited;
}

- (BOOL)isShared {
  return _tag == DBPAPERUserOnPaperDocFilterShared;
}

- (BOOL)isOther {
  return _tag == DBPAPERUserOnPaperDocFilterOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBPAPERUserOnPaperDocFilterVisited:
    return @"DBPAPERUserOnPaperDocFilterVisited";
  case DBPAPERUserOnPaperDocFilterShared:
    return @"DBPAPERUserOnPaperDocFilterShared";
  case DBPAPERUserOnPaperDocFilterOther:
    return @"DBPAPERUserOnPaperDocFilterOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBPAPERUserOnPaperDocFilterSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBPAPERUserOnPaperDocFilterSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBPAPERUserOnPaperDocFilterSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBPAPERUserOnPaperDocFilterVisited:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERUserOnPaperDocFilterShared:
    result = prime * result + [[self tagName] hash];
    break;
  case DBPAPERUserOnPaperDocFilterOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUserOnPaperDocFilter:other];
}

- (BOOL)isEqualToUserOnPaperDocFilter:(DBPAPERUserOnPaperDocFilter *)anUserOnPaperDocFilter {
  if (self == anUserOnPaperDocFilter) {
    return YES;
  }
  if (self.tag != anUserOnPaperDocFilter.tag) {
    return NO;
  }
  switch (_tag) {
  case DBPAPERUserOnPaperDocFilterVisited:
    return [[self tagName] isEqual:[anUserOnPaperDocFilter tagName]];
  case DBPAPERUserOnPaperDocFilterShared:
    return [[self tagName] isEqual:[anUserOnPaperDocFilter tagName]];
  case DBPAPERUserOnPaperDocFilterOther:
    return [[self tagName] isEqual:[anUserOnPaperDocFilter tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBPAPERUserOnPaperDocFilterSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBPAPERUserOnPaperDocFilter *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isVisited]) {
    jsonDict[@".tag"] = @"visited";
  } else if ([valueObj isShared]) {
    jsonDict[@".tag"] = @"shared";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBPAPERUserOnPaperDocFilter *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"visited"]) {
    return [[DBPAPERUserOnPaperDocFilter alloc] initWithVisited];
  } else if ([tag isEqualToString:@"shared"]) {
    return [[DBPAPERUserOnPaperDocFilter alloc] initWithShared];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBPAPERUserOnPaperDocFilter alloc] initWithOther];
  } else {
    return [[DBPAPERUserOnPaperDocFilter alloc] initWithOther];
  }
}

@end
