///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSearchMatchFieldOptions;
@class DBFILESSearchOptions;
@class DBFILESSearchV2Arg;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchV2Arg` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchV2Arg : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The string to search for. May match across multiple fields based on the
/// request arguments.
@property (nonatomic, readonly, copy) NSString *query;

/// Options for more targeted search results.
@property (nonatomic, readonly, nullable) DBFILESSearchOptions *options;

/// Options for search results match fields.
@property (nonatomic, readonly, nullable) DBFILESSearchMatchFieldOptions *matchFieldOptions;

/// Deprecated and moved this option to SearchMatchFieldOptions.
@property (nonatomic, readonly, nullable) NSNumber *includeHighlights;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param query The string to search for. May match across multiple fields
/// based on the request arguments.
/// @param options Options for more targeted search results.
/// @param matchFieldOptions Options for search results match fields.
/// @param includeHighlights Deprecated and moved this option to
/// SearchMatchFieldOptions.
///
/// @return An initialized instance.
///
- (instancetype)initWithQuery:(NSString *)query
                      options:(nullable DBFILESSearchOptions *)options
            matchFieldOptions:(nullable DBFILESSearchMatchFieldOptions *)matchFieldOptions
            includeHighlights:(nullable NSNumber *)includeHighlights;

///
/// Convenience constructor (exposes only non-nullable instance variables with
/// no default value).
///
/// @param query The string to search for. May match across multiple fields
/// based on the request arguments.
///
/// @return An initialized instance.
///
- (instancetype)initWithQuery:(NSString *)query;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SearchV2Arg` struct.
///
@interface DBFILESSearchV2ArgSerializer : NSObject

///
/// Serializes `DBFILESSearchV2Arg` instances.
///
/// @param instance An instance of the `DBFILESSearchV2Arg` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchV2Arg` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchV2Arg *)instance;

///
/// Deserializes `DBFILESSearchV2Arg` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchV2Arg` API object.
///
/// @return An instantiation of the `DBFILESSearchV2Arg` object.
///
+ (DBFILESSearchV2Arg *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
