///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESSearchMatchTypeV2;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchMatchTypeV2` union.
///
/// Indicates what type of match was found for a given item.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchMatchTypeV2 : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESSearchMatchTypeV2Tag` enum type represents the possible tag
/// states with which the `DBFILESSearchMatchTypeV2` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESSearchMatchTypeV2Tag){
    /// This item was matched on its file or folder name.
    DBFILESSearchMatchTypeV2Filename,

    /// This item was matched based on its file contents.
    DBFILESSearchMatchTypeV2FileContent,

    /// This item was matched based on both its contents and its file name.
    DBFILESSearchMatchTypeV2FilenameAndContent,

    /// This item was matched on image content.
    DBFILESSearchMatchTypeV2ImageContent,

    /// (no description).
    DBFILESSearchMatchTypeV2Other,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESSearchMatchTypeV2Tag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "filename".
///
/// Description of the "filename" tag state: This item was matched on its file
/// or folder name.
///
/// @return An initialized instance.
///
- (instancetype)initWithFilename;

///
/// Initializes union class with tag state of "file_content".
///
/// Description of the "file_content" tag state: This item was matched based on
/// its file contents.
///
/// @return An initialized instance.
///
- (instancetype)initWithFileContent;

///
/// Initializes union class with tag state of "filename_and_content".
///
/// Description of the "filename_and_content" tag state: This item was matched
/// based on both its contents and its file name.
///
/// @return An initialized instance.
///
- (instancetype)initWithFilenameAndContent;

///
/// Initializes union class with tag state of "image_content".
///
/// Description of the "image_content" tag state: This item was matched on image
/// content.
///
/// @return An initialized instance.
///
- (instancetype)initWithImageContent;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "filename".
///
/// @return Whether the union's current tag state has value "filename".
///
- (BOOL)isFilename;

///
/// Retrieves whether the union's current tag state has value "file_content".
///
/// @return Whether the union's current tag state has value "file_content".
///
- (BOOL)isFileContent;

///
/// Retrieves whether the union's current tag state has value
/// "filename_and_content".
///
/// @return Whether the union's current tag state has value
/// "filename_and_content".
///
- (BOOL)isFilenameAndContent;

///
/// Retrieves whether the union's current tag state has value "image_content".
///
/// @return Whether the union's current tag state has value "image_content".
///
- (BOOL)isImageContent;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESSearchMatchTypeV2` union.
///
@interface DBFILESSearchMatchTypeV2Serializer : NSObject

///
/// Serializes `DBFILESSearchMatchTypeV2` instances.
///
/// @param instance An instance of the `DBFILESSearchMatchTypeV2` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchMatchTypeV2` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatchTypeV2 *)instance;

///
/// Deserializes `DBFILESSearchMatchTypeV2` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchMatchTypeV2` API object.
///
/// @return An instantiation of the `DBFILESSearchMatchTypeV2` object.
///
+ (DBFILESSearchMatchTypeV2 *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
