///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESMetadata;
@class DBFILESSearchMatch;
@class DBFILESSearchMatchType;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SearchMatch` struct.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESSearchMatch : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The type of the match.
@property (nonatomic, readonly) DBFILESSearchMatchType *matchType;

/// The metadata for the matched file or folder.
@property (nonatomic, readonly) DBFILESMetadata *metadata;

#pragma mark - Constructors

///
/// Full constructor for the struct (exposes all instance variables).
///
/// @param matchType The type of the match.
/// @param metadata The metadata for the matched file or folder.
///
/// @return An initialized instance.
///
- (instancetype)initWithMatchType:(DBFILESSearchMatchType *)matchType metadata:(DBFILESMetadata *)metadata;

- (instancetype)init NS_UNAVAILABLE;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `SearchMatch` struct.
///
@interface DBFILESSearchMatchSerializer : NSObject

///
/// Serializes `DBFILESSearchMatch` instances.
///
/// @param instance An instance of the `DBFILESSearchMatch` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESSearchMatch` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESSearchMatch *)instance;

///
/// Deserializes `DBFILESSearchMatch` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESSearchMatch` API object.
///
/// @return An instantiation of the `DBFILESSearchMatch` object.
///
+ (DBFILESSearchMatch *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
