///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESPathOrLink;
@class DBFILESSharedLinkFileInfo;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PathOrLink` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPathOrLink : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESPathOrLinkTag` enum type represents the possible tag states with
/// which the `DBFILESPathOrLink` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESPathOrLinkTag){
    /// (no description).
    DBFILESPathOrLinkPath,

    /// (no description).
    DBFILESPathOrLinkLink,

    /// (no description).
    DBFILESPathOrLinkOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESPathOrLinkTag tag;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly, copy) NSString *path;

/// (no description). @note Ensure the `isLink` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESSharedLinkFileInfo *link;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(NSString *)path;

///
/// Initializes union class with tag state of "link".
///
/// @param link (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithLink:(DBFILESSharedLinkFileInfo *)link;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value "link".
///
/// @note Call this method and ensure it returns true before accessing the
/// `link` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "link".
///
- (BOOL)isLink;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESPathOrLink` union.
///
@interface DBFILESPathOrLinkSerializer : NSObject

///
/// Serializes `DBFILESPathOrLink` instances.
///
/// @param instance An instance of the `DBFILESPathOrLink` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPathOrLink` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPathOrLink *)instance;

///
/// Deserializes `DBFILESPathOrLink` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPathOrLink` API object.
///
/// @return An instantiation of the `DBFILESPathOrLink` object.
///
+ (DBFILESPathOrLink *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
