///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESPaperDocUpdatePolicy;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `PaperDocUpdatePolicy` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESPaperDocUpdatePolicy : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESPaperDocUpdatePolicyTag` enum type represents the possible tag
/// states with which the `DBFILESPaperDocUpdatePolicy` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESPaperDocUpdatePolicyTag){
    /// Sets the doc content to the provided content if the provided
    /// paper_revision matches the latest doc revision. Otherwise, returns an
    /// error.
    DBFILESPaperDocUpdatePolicyUpdate,

    /// Sets the doc content to the provided content without checking
    /// paper_revision.
    DBFILESPaperDocUpdatePolicyOverwrite,

    /// Adds the provided content to the beginning of the doc without checking
    /// paper_revision.
    DBFILESPaperDocUpdatePolicyPrepend,

    /// Adds the provided content to the end of the doc without checking
    /// paper_revision.
    DBFILESPaperDocUpdatePolicyAppend,

    /// (no description).
    DBFILESPaperDocUpdatePolicyOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESPaperDocUpdatePolicyTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "update".
///
/// Description of the "update" tag state: Sets the doc content to the provided
/// content if the provided paper_revision matches the latest doc revision.
/// Otherwise, returns an error.
///
/// @return An initialized instance.
///
- (instancetype)initWithUpdate;

///
/// Initializes union class with tag state of "overwrite".
///
/// Description of the "overwrite" tag state: Sets the doc content to the
/// provided content without checking paper_revision.
///
/// @return An initialized instance.
///
- (instancetype)initWithOverwrite;

///
/// Initializes union class with tag state of "prepend".
///
/// Description of the "prepend" tag state: Adds the provided content to the
/// beginning of the doc without checking paper_revision.
///
/// @return An initialized instance.
///
- (instancetype)initWithPrepend;

///
/// Initializes union class with tag state of "append".
///
/// Description of the "append" tag state: Adds the provided content to the end
/// of the doc without checking paper_revision.
///
/// @return An initialized instance.
///
- (instancetype)initWithAppend;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "update".
///
/// @return Whether the union's current tag state has value "update".
///
- (BOOL)isUpdate;

///
/// Retrieves whether the union's current tag state has value "overwrite".
///
/// @return Whether the union's current tag state has value "overwrite".
///
- (BOOL)isOverwrite;

///
/// Retrieves whether the union's current tag state has value "prepend".
///
/// @return Whether the union's current tag state has value "prepend".
///
- (BOOL)isPrepend;

///
/// Retrieves whether the union's current tag state has value "append".
///
/// @return Whether the union's current tag state has value "append".
///
- (BOOL)isAppend;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESPaperDocUpdatePolicy` union.
///
@interface DBFILESPaperDocUpdatePolicySerializer : NSObject

///
/// Serializes `DBFILESPaperDocUpdatePolicy` instances.
///
/// @param instance An instance of the `DBFILESPaperDocUpdatePolicy` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESPaperDocUpdatePolicy` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESPaperDocUpdatePolicy *)instance;

///
/// Deserializes `DBFILESPaperDocUpdatePolicy` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESPaperDocUpdatePolicy` API object.
///
/// @return An instantiation of the `DBFILESPaperDocUpdatePolicy` object.
///
+ (DBFILESPaperDocUpdatePolicy *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
