///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBFILESDownloadZipError;
@class DBFILESLookupError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DownloadZipError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBFILESDownloadZipError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBFILESDownloadZipErrorTag` enum type represents the possible tag
/// states with which the `DBFILESDownloadZipError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBFILESDownloadZipErrorTag){
    /// (no description).
    DBFILESDownloadZipErrorPath,

    /// The folder or a file is too large to download.
    DBFILESDownloadZipErrorTooLarge,

    /// The folder has too many files to download.
    DBFILESDownloadZipErrorTooManyFiles,

    /// (no description).
    DBFILESDownloadZipErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBFILESDownloadZipErrorTag tag;

/// (no description). @note Ensure the `isPath` method returns true before
/// accessing, otherwise a runtime exception will be raised.
@property (nonatomic, readonly) DBFILESLookupError *path;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "path".
///
/// @param path (no description).
///
/// @return An initialized instance.
///
- (instancetype)initWithPath:(DBFILESLookupError *)path;

///
/// Initializes union class with tag state of "too_large".
///
/// Description of the "too_large" tag state: The folder or a file is too large
/// to download.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooLarge;

///
/// Initializes union class with tag state of "too_many_files".
///
/// Description of the "too_many_files" tag state: The folder has too many files
/// to download.
///
/// @return An initialized instance.
///
- (instancetype)initWithTooManyFiles;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "path".
///
/// @note Call this method and ensure it returns true before accessing the
/// `path` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value "path".
///
- (BOOL)isPath;

///
/// Retrieves whether the union's current tag state has value "too_large".
///
/// @return Whether the union's current tag state has value "too_large".
///
- (BOOL)isTooLarge;

///
/// Retrieves whether the union's current tag state has value "too_many_files".
///
/// @return Whether the union's current tag state has value "too_many_files".
///
- (BOOL)isTooManyFiles;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBFILESDownloadZipError` union.
///
@interface DBFILESDownloadZipErrorSerializer : NSObject

///
/// Serializes `DBFILESDownloadZipError` instances.
///
/// @param instance An instance of the `DBFILESDownloadZipError` API object.
///
/// @return A json-compatible dictionary representation of the
/// `DBFILESDownloadZipError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBFILESDownloadZipError *)instance;

///
/// Deserializes `DBFILESDownloadZipError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBFILESDownloadZipError` API object.
///
/// @return An instantiation of the `DBFILESDownloadZipError` object.
///
+ (DBFILESDownloadZipError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
