///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `FileRequests` namespace.

#import "DBFILEREQUESTSGeneralFileRequestsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSGeneralFileRequestsError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGeneralFileRequestsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSGeneralFileRequestsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam:
    return @"DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam";
  case DBFILEREQUESTSGeneralFileRequestsErrorOther:
    return @"DBFILEREQUESTSGeneralFileRequestsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSGeneralFileRequestsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSGeneralFileRequestsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSGeneralFileRequestsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGeneralFileRequestsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGeneralFileRequestsError:other];
}

- (BOOL)isEqualToGeneralFileRequestsError:(DBFILEREQUESTSGeneralFileRequestsError *)aGeneralFileRequestsError {
  if (self == aGeneralFileRequestsError) {
    return YES;
  }
  if (self.tag != aGeneralFileRequestsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSGeneralFileRequestsErrorDisabledForTeam:
    return [[self tagName] isEqual:[aGeneralFileRequestsError tagName]];
  case DBFILEREQUESTSGeneralFileRequestsErrorOther:
    return [[self tagName] isEqual:[aGeneralFileRequestsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSGeneralFileRequestsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSGeneralFileRequestsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSGeneralFileRequestsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSGeneralFileRequestsError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSGeneralFileRequestsError alloc] initWithOther];
  } else {
    return [[DBFILEREQUESTSGeneralFileRequestsError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSCountFileRequestsError.h"
#import "DBFILEREQUESTSGeneralFileRequestsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSCountFileRequestsError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCountFileRequestsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSCountFileRequestsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam:
    return @"DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam";
  case DBFILEREQUESTSCountFileRequestsErrorOther:
    return @"DBFILEREQUESTSCountFileRequestsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSCountFileRequestsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSCountFileRequestsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSCountFileRequestsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCountFileRequestsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCountFileRequestsError:other];
}

- (BOOL)isEqualToCountFileRequestsError:(DBFILEREQUESTSCountFileRequestsError *)aCountFileRequestsError {
  if (self == aCountFileRequestsError) {
    return YES;
  }
  if (self.tag != aCountFileRequestsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSCountFileRequestsErrorDisabledForTeam:
    return [[self tagName] isEqual:[aCountFileRequestsError tagName]];
  case DBFILEREQUESTSCountFileRequestsErrorOther:
    return [[self tagName] isEqual:[aCountFileRequestsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSCountFileRequestsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSCountFileRequestsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSCountFileRequestsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSCountFileRequestsError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSCountFileRequestsError alloc] initWithOther];
  } else {
    return [[DBFILEREQUESTSCountFileRequestsError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSCountFileRequestsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSCountFileRequestsResult

#pragma mark - Constructors

- (instancetype)initWithFileRequestCount:(NSNumber *)fileRequestCount {
  [DBStoneValidators nonnullValidator:nil](fileRequestCount);

  self = [super init];
  if (self) {
    _fileRequestCount = fileRequestCount;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSCountFileRequestsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSCountFileRequestsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSCountFileRequestsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fileRequestCount hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCountFileRequestsResult:other];
}

- (BOOL)isEqualToCountFileRequestsResult:(DBFILEREQUESTSCountFileRequestsResult *)aCountFileRequestsResult {
  if (self == aCountFileRequestsResult) {
    return YES;
  }
  if (![self.fileRequestCount isEqual:aCountFileRequestsResult.fileRequestCount]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSCountFileRequestsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSCountFileRequestsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file_request_count"] = valueObj.fileRequestCount;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSCountFileRequestsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *fileRequestCount = valueDict[@"file_request_count"];

  return [[DBFILEREQUESTSCountFileRequestsResult alloc] initWithFileRequestCount:fileRequestCount];
}

@end

#import "DBFILEREQUESTSCreateFileRequestArgs.h"
#import "DBFILEREQUESTSFileRequestDeadline.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSCreateFileRequestArgs

#pragma mark - Constructors

- (instancetype)initWithTitle:(NSString *)title
                  destination:(NSString *)destination
                     deadline:(DBFILEREQUESTSFileRequestDeadline *)deadline
                         open:(NSNumber *)open
                 description_:(NSString *)description_ {
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](title);
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](destination);

  self = [super init];
  if (self) {
    _title = title;
    _destination = destination;
    _deadline = deadline;
    _open = open ?: @YES;
    _description_ = description_;
  }
  return self;
}

- (instancetype)initWithTitle:(NSString *)title destination:(NSString *)destination {
  return [self initWithTitle:title destination:destination deadline:nil open:nil description_:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSCreateFileRequestArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSCreateFileRequestArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSCreateFileRequestArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.title hash];
  result = prime * result + [self.destination hash];
  if (self.deadline != nil) {
    result = prime * result + [self.deadline hash];
  }
  result = prime * result + [self.open hash];
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFileRequestArgs:other];
}

- (BOOL)isEqualToCreateFileRequestArgs:(DBFILEREQUESTSCreateFileRequestArgs *)aCreateFileRequestArgs {
  if (self == aCreateFileRequestArgs) {
    return YES;
  }
  if (![self.title isEqual:aCreateFileRequestArgs.title]) {
    return NO;
  }
  if (![self.destination isEqual:aCreateFileRequestArgs.destination]) {
    return NO;
  }
  if (self.deadline) {
    if (![self.deadline isEqual:aCreateFileRequestArgs.deadline]) {
      return NO;
    }
  }
  if (![self.open isEqual:aCreateFileRequestArgs.open]) {
    return NO;
  }
  if (self.description_) {
    if (![self.description_ isEqual:aCreateFileRequestArgs.description_]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSCreateFileRequestArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSCreateFileRequestArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"title"] = valueObj.title;
  jsonDict[@"destination"] = valueObj.destination;
  if (valueObj.deadline) {
    jsonDict[@"deadline"] = [DBFILEREQUESTSFileRequestDeadlineSerializer serialize:valueObj.deadline];
  }
  jsonDict[@"open"] = valueObj.open;
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSCreateFileRequestArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *title = valueDict[@"title"];
  NSString *destination = valueDict[@"destination"];
  DBFILEREQUESTSFileRequestDeadline *deadline =
      valueDict[@"deadline"] ? [DBFILEREQUESTSFileRequestDeadlineSerializer deserialize:valueDict[@"deadline"]] : nil;
  NSNumber *open = valueDict[@"open"] ?: @YES;
  NSString *description_ = valueDict[@"description"] ?: nil;

  return [[DBFILEREQUESTSCreateFileRequestArgs alloc] initWithTitle:title
                                                        destination:destination
                                                           deadline:deadline
                                                               open:open
                                                       description_:description_];
}

@end

#import "DBFILEREQUESTSFileRequestError.h"
#import "DBFILEREQUESTSGeneralFileRequestsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSFileRequestError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSFileRequestErrorValidationError;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSFileRequestErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSFileRequestErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSFileRequestErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSFileRequestErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSFileRequestErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSFileRequestErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSFileRequestErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSFileRequestErrorValidationError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSFileRequestErrorDisabledForTeam:
    return @"DBFILEREQUESTSFileRequestErrorDisabledForTeam";
  case DBFILEREQUESTSFileRequestErrorOther:
    return @"DBFILEREQUESTSFileRequestErrorOther";
  case DBFILEREQUESTSFileRequestErrorNotFound:
    return @"DBFILEREQUESTSFileRequestErrorNotFound";
  case DBFILEREQUESTSFileRequestErrorNotAFolder:
    return @"DBFILEREQUESTSFileRequestErrorNotAFolder";
  case DBFILEREQUESTSFileRequestErrorAppLacksAccess:
    return @"DBFILEREQUESTSFileRequestErrorAppLacksAccess";
  case DBFILEREQUESTSFileRequestErrorNoPermission:
    return @"DBFILEREQUESTSFileRequestErrorNoPermission";
  case DBFILEREQUESTSFileRequestErrorEmailUnverified:
    return @"DBFILEREQUESTSFileRequestErrorEmailUnverified";
  case DBFILEREQUESTSFileRequestErrorValidationError:
    return @"DBFILEREQUESTSFileRequestErrorValidationError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSFileRequestErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSFileRequestErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSFileRequestErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSFileRequestErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSFileRequestErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileRequestError:other];
}

- (BOOL)isEqualToFileRequestError:(DBFILEREQUESTSFileRequestError *)aFileRequestError {
  if (self == aFileRequestError) {
    return YES;
  }
  if (self.tag != aFileRequestError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSFileRequestErrorDisabledForTeam:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorOther:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorNotFound:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorNotAFolder:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorAppLacksAccess:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorNoPermission:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorEmailUnverified:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  case DBFILEREQUESTSFileRequestErrorValidationError:
    return [[self tagName] isEqual:[aFileRequestError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSFileRequestErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSFileRequestError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSFileRequestError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithValidationError];
  } else {
    return [[DBFILEREQUESTSFileRequestError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSCreateFileRequestError.h"
#import "DBFILEREQUESTSFileRequestError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSCreateFileRequestError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorValidationError;
  }
  return self;
}

- (instancetype)initWithInvalidLocation {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorInvalidLocation;
  }
  return self;
}

- (instancetype)initWithRateLimit {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSCreateFileRequestErrorRateLimit;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorValidationError;
}

- (BOOL)isInvalidLocation {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorInvalidLocation;
}

- (BOOL)isRateLimit {
  return _tag == DBFILEREQUESTSCreateFileRequestErrorRateLimit;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam:
    return @"DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam";
  case DBFILEREQUESTSCreateFileRequestErrorOther:
    return @"DBFILEREQUESTSCreateFileRequestErrorOther";
  case DBFILEREQUESTSCreateFileRequestErrorNotFound:
    return @"DBFILEREQUESTSCreateFileRequestErrorNotFound";
  case DBFILEREQUESTSCreateFileRequestErrorNotAFolder:
    return @"DBFILEREQUESTSCreateFileRequestErrorNotAFolder";
  case DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess:
    return @"DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess";
  case DBFILEREQUESTSCreateFileRequestErrorNoPermission:
    return @"DBFILEREQUESTSCreateFileRequestErrorNoPermission";
  case DBFILEREQUESTSCreateFileRequestErrorEmailUnverified:
    return @"DBFILEREQUESTSCreateFileRequestErrorEmailUnverified";
  case DBFILEREQUESTSCreateFileRequestErrorValidationError:
    return @"DBFILEREQUESTSCreateFileRequestErrorValidationError";
  case DBFILEREQUESTSCreateFileRequestErrorInvalidLocation:
    return @"DBFILEREQUESTSCreateFileRequestErrorInvalidLocation";
  case DBFILEREQUESTSCreateFileRequestErrorRateLimit:
    return @"DBFILEREQUESTSCreateFileRequestErrorRateLimit";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSCreateFileRequestErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSCreateFileRequestErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSCreateFileRequestErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorInvalidLocation:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSCreateFileRequestErrorRateLimit:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToCreateFileRequestError:other];
}

- (BOOL)isEqualToCreateFileRequestError:(DBFILEREQUESTSCreateFileRequestError *)aCreateFileRequestError {
  if (self == aCreateFileRequestError) {
    return YES;
  }
  if (self.tag != aCreateFileRequestError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSCreateFileRequestErrorDisabledForTeam:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorOther:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorNotFound:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorNotAFolder:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorAppLacksAccess:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorNoPermission:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorEmailUnverified:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorValidationError:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorInvalidLocation:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  case DBFILEREQUESTSCreateFileRequestErrorRateLimit:
    return [[self tagName] isEqual:[aCreateFileRequestError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSCreateFileRequestErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSCreateFileRequestError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else if ([valueObj isInvalidLocation]) {
    jsonDict[@".tag"] = @"invalid_location";
  } else if ([valueObj isRateLimit]) {
    jsonDict[@".tag"] = @"rate_limit";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSCreateFileRequestError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithValidationError];
  } else if ([tag isEqualToString:@"invalid_location"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithInvalidLocation];
  } else if ([tag isEqualToString:@"rate_limit"]) {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithRateLimit];
  } else {
    return [[DBFILEREQUESTSCreateFileRequestError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSDeleteAllClosedFileRequestsError.h"
#import "DBFILEREQUESTSFileRequestError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSDeleteAllClosedFileRequestsError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified";
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError:
    return @"DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSDeleteAllClosedFileRequestsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSDeleteAllClosedFileRequestsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSDeleteAllClosedFileRequestsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteAllClosedFileRequestsError:other];
}

- (BOOL)isEqualToDeleteAllClosedFileRequestsError:
    (DBFILEREQUESTSDeleteAllClosedFileRequestsError *)aDeleteAllClosedFileRequestsError {
  if (self == aDeleteAllClosedFileRequestsError) {
    return YES;
  }
  if (self.tag != aDeleteAllClosedFileRequestsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorDisabledForTeam:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorOther:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotFound:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNotAFolder:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorAppLacksAccess:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorNoPermission:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorEmailUnverified:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  case DBFILEREQUESTSDeleteAllClosedFileRequestsErrorValidationError:
    return [[self tagName] isEqual:[aDeleteAllClosedFileRequestsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSDeleteAllClosedFileRequestsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSDeleteAllClosedFileRequestsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSDeleteAllClosedFileRequestsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithValidationError];
  } else {
    return [[DBFILEREQUESTSDeleteAllClosedFileRequestsError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSDeleteAllClosedFileRequestsResult.h"
#import "DBFILEREQUESTSFileRequest.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSDeleteAllClosedFileRequestsResult

#pragma mark - Constructors

- (instancetype)initWithFileRequests:(NSArray<DBFILEREQUESTSFileRequest *> *)fileRequests {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileRequests);

  self = [super init];
  if (self) {
    _fileRequests = fileRequests;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSDeleteAllClosedFileRequestsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSDeleteAllClosedFileRequestsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSDeleteAllClosedFileRequestsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fileRequests hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteAllClosedFileRequestsResult:other];
}

- (BOOL)isEqualToDeleteAllClosedFileRequestsResult:
    (DBFILEREQUESTSDeleteAllClosedFileRequestsResult *)aDeleteAllClosedFileRequestsResult {
  if (self == aDeleteAllClosedFileRequestsResult) {
    return YES;
  }
  if (![self.fileRequests isEqual:aDeleteAllClosedFileRequestsResult.fileRequests]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSDeleteAllClosedFileRequestsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSDeleteAllClosedFileRequestsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file_requests"] = [DBArraySerializer serialize:valueObj.fileRequests
                                                  withBlock:^id(id elem0) {
                                                    return [DBFILEREQUESTSFileRequestSerializer serialize:elem0];
                                                  }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSDeleteAllClosedFileRequestsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILEREQUESTSFileRequest *> *fileRequests =
      [DBArraySerializer deserialize:valueDict[@"file_requests"]
                           withBlock:^id(id elem0) {
                             return [DBFILEREQUESTSFileRequestSerializer deserialize:elem0];
                           }];

  return [[DBFILEREQUESTSDeleteAllClosedFileRequestsResult alloc] initWithFileRequests:fileRequests];
}

@end

#import "DBFILEREQUESTSDeleteFileRequestArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSDeleteFileRequestArgs

#pragma mark - Constructors

- (instancetype)initWithIds:(NSArray<NSString *> *)ids {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators
                        arrayValidator:nil
                              maxItems:nil
                         itemValidator:[DBStoneValidators
                                           nonnullValidator:[DBStoneValidators stringValidator:@(1)
                                                                                     maxLength:nil
                                                                                       pattern:@"[-_0-9a-zA-Z]+"]]]](
      ids);

  self = [super init];
  if (self) {
    _ids = ids;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSDeleteFileRequestArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSDeleteFileRequestArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSDeleteFileRequestArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.ids hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteFileRequestArgs:other];
}

- (BOOL)isEqualToDeleteFileRequestArgs:(DBFILEREQUESTSDeleteFileRequestArgs *)aDeleteFileRequestArgs {
  if (self == aDeleteFileRequestArgs) {
    return YES;
  }
  if (![self.ids isEqual:aDeleteFileRequestArgs.ids]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSDeleteFileRequestArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSDeleteFileRequestArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"ids"] = [DBArraySerializer serialize:valueObj.ids
                                        withBlock:^id(id elem0) {
                                          return elem0;
                                        }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSDeleteFileRequestArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<NSString *> *ids = [DBArraySerializer deserialize:valueDict[@"ids"]
                                                  withBlock:^id(id elem0) {
                                                    return elem0;
                                                  }];

  return [[DBFILEREQUESTSDeleteFileRequestArgs alloc] initWithIds:ids];
}

@end

#import "DBFILEREQUESTSDeleteFileRequestError.h"
#import "DBFILEREQUESTSFileRequestError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSDeleteFileRequestError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorValidationError;
  }
  return self;
}

- (instancetype)initWithFileRequestOpen {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorValidationError;
}

- (BOOL)isFileRequestOpen {
  return _tag == DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam:
    return @"DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam";
  case DBFILEREQUESTSDeleteFileRequestErrorOther:
    return @"DBFILEREQUESTSDeleteFileRequestErrorOther";
  case DBFILEREQUESTSDeleteFileRequestErrorNotFound:
    return @"DBFILEREQUESTSDeleteFileRequestErrorNotFound";
  case DBFILEREQUESTSDeleteFileRequestErrorNotAFolder:
    return @"DBFILEREQUESTSDeleteFileRequestErrorNotAFolder";
  case DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess:
    return @"DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess";
  case DBFILEREQUESTSDeleteFileRequestErrorNoPermission:
    return @"DBFILEREQUESTSDeleteFileRequestErrorNoPermission";
  case DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified:
    return @"DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified";
  case DBFILEREQUESTSDeleteFileRequestErrorValidationError:
    return @"DBFILEREQUESTSDeleteFileRequestErrorValidationError";
  case DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen:
    return @"DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSDeleteFileRequestErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSDeleteFileRequestErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSDeleteFileRequestErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteFileRequestError:other];
}

- (BOOL)isEqualToDeleteFileRequestError:(DBFILEREQUESTSDeleteFileRequestError *)aDeleteFileRequestError {
  if (self == aDeleteFileRequestError) {
    return YES;
  }
  if (self.tag != aDeleteFileRequestError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSDeleteFileRequestErrorDisabledForTeam:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorOther:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorNotFound:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorNotAFolder:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorAppLacksAccess:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorNoPermission:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorEmailUnverified:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorValidationError:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  case DBFILEREQUESTSDeleteFileRequestErrorFileRequestOpen:
    return [[self tagName] isEqual:[aDeleteFileRequestError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSDeleteFileRequestErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSDeleteFileRequestError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else if ([valueObj isFileRequestOpen]) {
    jsonDict[@".tag"] = @"file_request_open";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSDeleteFileRequestError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithValidationError];
  } else if ([tag isEqualToString:@"file_request_open"]) {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithFileRequestOpen];
  } else {
    return [[DBFILEREQUESTSDeleteFileRequestError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSDeleteFileRequestsResult.h"
#import "DBFILEREQUESTSFileRequest.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSDeleteFileRequestsResult

#pragma mark - Constructors

- (instancetype)initWithFileRequests:(NSArray<DBFILEREQUESTSFileRequest *> *)fileRequests {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileRequests);

  self = [super init];
  if (self) {
    _fileRequests = fileRequests;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSDeleteFileRequestsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSDeleteFileRequestsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSDeleteFileRequestsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fileRequests hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToDeleteFileRequestsResult:other];
}

- (BOOL)isEqualToDeleteFileRequestsResult:(DBFILEREQUESTSDeleteFileRequestsResult *)aDeleteFileRequestsResult {
  if (self == aDeleteFileRequestsResult) {
    return YES;
  }
  if (![self.fileRequests isEqual:aDeleteFileRequestsResult.fileRequests]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSDeleteFileRequestsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSDeleteFileRequestsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file_requests"] = [DBArraySerializer serialize:valueObj.fileRequests
                                                  withBlock:^id(id elem0) {
                                                    return [DBFILEREQUESTSFileRequestSerializer serialize:elem0];
                                                  }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSDeleteFileRequestsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILEREQUESTSFileRequest *> *fileRequests =
      [DBArraySerializer deserialize:valueDict[@"file_requests"]
                           withBlock:^id(id elem0) {
                             return [DBFILEREQUESTSFileRequestSerializer deserialize:elem0];
                           }];

  return [[DBFILEREQUESTSDeleteFileRequestsResult alloc] initWithFileRequests:fileRequests];
}

@end

#import "DBFILEREQUESTSFileRequest.h"
#import "DBFILEREQUESTSFileRequestDeadline.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSFileRequest

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                        url:(NSString *)url
                      title:(NSString *)title
                    created:(NSDate *)created
                     isOpen:(NSNumber *)isOpen
                  fileCount:(NSNumber *)fileCount
                destination:(NSString *)destination
                   deadline:(DBFILEREQUESTSFileRequestDeadline *)deadline
               description_:(NSString *)description_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:@"[-_0-9a-zA-Z]+"]](id_);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](url);
  [DBStoneValidators nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](title);
  [DBStoneValidators nonnullValidator:nil](created);
  [DBStoneValidators nonnullValidator:nil](isOpen);
  [DBStoneValidators nonnullValidator:nil](fileCount);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](destination);

  self = [super init];
  if (self) {
    _id_ = id_;
    _url = url;
    _title = title;
    _destination = destination;
    _created = created;
    _deadline = deadline;
    _isOpen = isOpen;
    _fileCount = fileCount;
    _description_ = description_;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_
                        url:(NSString *)url
                      title:(NSString *)title
                    created:(NSDate *)created
                     isOpen:(NSNumber *)isOpen
                  fileCount:(NSNumber *)fileCount {
  return [self initWithId_:id_
                       url:url
                     title:title
                   created:created
                    isOpen:isOpen
                 fileCount:fileCount
               destination:nil
                  deadline:nil
              description_:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSFileRequestSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSFileRequestSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSFileRequestSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  result = prime * result + [self.url hash];
  result = prime * result + [self.title hash];
  result = prime * result + [self.created hash];
  result = prime * result + [self.isOpen hash];
  result = prime * result + [self.fileCount hash];
  if (self.destination != nil) {
    result = prime * result + [self.destination hash];
  }
  if (self.deadline != nil) {
    result = prime * result + [self.deadline hash];
  }
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileRequest:other];
}

- (BOOL)isEqualToFileRequest:(DBFILEREQUESTSFileRequest *)aFileRequest {
  if (self == aFileRequest) {
    return YES;
  }
  if (![self.id_ isEqual:aFileRequest.id_]) {
    return NO;
  }
  if (![self.url isEqual:aFileRequest.url]) {
    return NO;
  }
  if (![self.title isEqual:aFileRequest.title]) {
    return NO;
  }
  if (![self.created isEqual:aFileRequest.created]) {
    return NO;
  }
  if (![self.isOpen isEqual:aFileRequest.isOpen]) {
    return NO;
  }
  if (![self.fileCount isEqual:aFileRequest.fileCount]) {
    return NO;
  }
  if (self.destination) {
    if (![self.destination isEqual:aFileRequest.destination]) {
      return NO;
    }
  }
  if (self.deadline) {
    if (![self.deadline isEqual:aFileRequest.deadline]) {
      return NO;
    }
  }
  if (self.description_) {
    if (![self.description_ isEqual:aFileRequest.description_]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSFileRequestSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSFileRequest *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  jsonDict[@"url"] = valueObj.url;
  jsonDict[@"title"] = valueObj.title;
  jsonDict[@"created"] = [DBNSDateSerializer serialize:valueObj.created dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  jsonDict[@"is_open"] = valueObj.isOpen;
  jsonDict[@"file_count"] = valueObj.fileCount;
  if (valueObj.destination) {
    jsonDict[@"destination"] = valueObj.destination;
  }
  if (valueObj.deadline) {
    jsonDict[@"deadline"] = [DBFILEREQUESTSFileRequestDeadlineSerializer serialize:valueObj.deadline];
  }
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSFileRequest *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *url = valueDict[@"url"];
  NSString *title = valueDict[@"title"];
  NSDate *created = [DBNSDateSerializer deserialize:valueDict[@"created"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  NSNumber *isOpen = valueDict[@"is_open"];
  NSNumber *fileCount = valueDict[@"file_count"];
  NSString *destination = valueDict[@"destination"] ?: nil;
  DBFILEREQUESTSFileRequestDeadline *deadline =
      valueDict[@"deadline"] ? [DBFILEREQUESTSFileRequestDeadlineSerializer deserialize:valueDict[@"deadline"]] : nil;
  NSString *description_ = valueDict[@"description"] ?: nil;

  return [[DBFILEREQUESTSFileRequest alloc] initWithId_:id_
                                                    url:url
                                                  title:title
                                                created:created
                                                 isOpen:isOpen
                                              fileCount:fileCount
                                            destination:destination
                                               deadline:deadline
                                           description_:description_];
}

@end

#import "DBFILEREQUESTSFileRequestDeadline.h"
#import "DBFILEREQUESTSGracePeriod.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSFileRequestDeadline

#pragma mark - Constructors

- (instancetype)initWithDeadline:(NSDate *)deadline allowLateUploads:(DBFILEREQUESTSGracePeriod *)allowLateUploads {
  [DBStoneValidators nonnullValidator:nil](deadline);

  self = [super init];
  if (self) {
    _deadline = deadline;
    _allowLateUploads = allowLateUploads;
  }
  return self;
}

- (instancetype)initWithDeadline:(NSDate *)deadline {
  return [self initWithDeadline:deadline allowLateUploads:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSFileRequestDeadlineSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSFileRequestDeadlineSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSFileRequestDeadlineSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.deadline hash];
  if (self.allowLateUploads != nil) {
    result = prime * result + [self.allowLateUploads hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToFileRequestDeadline:other];
}

- (BOOL)isEqualToFileRequestDeadline:(DBFILEREQUESTSFileRequestDeadline *)aFileRequestDeadline {
  if (self == aFileRequestDeadline) {
    return YES;
  }
  if (![self.deadline isEqual:aFileRequestDeadline.deadline]) {
    return NO;
  }
  if (self.allowLateUploads) {
    if (![self.allowLateUploads isEqual:aFileRequestDeadline.allowLateUploads]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSFileRequestDeadlineSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSFileRequestDeadline *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"deadline"] = [DBNSDateSerializer serialize:valueObj.deadline dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  if (valueObj.allowLateUploads) {
    jsonDict[@"allow_late_uploads"] = [DBFILEREQUESTSGracePeriodSerializer serialize:valueObj.allowLateUploads];
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSFileRequestDeadline *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSDate *deadline = [DBNSDateSerializer deserialize:valueDict[@"deadline"] dateFormat:@"%Y-%m-%dT%H:%M:%SZ"];
  DBFILEREQUESTSGracePeriod *allowLateUploads =
      valueDict[@"allow_late_uploads"]
          ? [DBFILEREQUESTSGracePeriodSerializer deserialize:valueDict[@"allow_late_uploads"]]
          : nil;

  return [[DBFILEREQUESTSFileRequestDeadline alloc] initWithDeadline:deadline allowLateUploads:allowLateUploads];
}

@end

#import "DBFILEREQUESTSGetFileRequestArgs.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSGetFileRequestArgs

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:@"[-_0-9a-zA-Z]+"]](id_);

  self = [super init];
  if (self) {
    _id_ = id_;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSGetFileRequestArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSGetFileRequestArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSGetFileRequestArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileRequestArgs:other];
}

- (BOOL)isEqualToGetFileRequestArgs:(DBFILEREQUESTSGetFileRequestArgs *)aGetFileRequestArgs {
  if (self == aGetFileRequestArgs) {
    return YES;
  }
  if (![self.id_ isEqual:aGetFileRequestArgs.id_]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSGetFileRequestArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSGetFileRequestArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSGetFileRequestArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];

  return [[DBFILEREQUESTSGetFileRequestArgs alloc] initWithId_:id_];
}

@end

#import "DBFILEREQUESTSFileRequestError.h"
#import "DBFILEREQUESTSGetFileRequestError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSGetFileRequestError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGetFileRequestErrorValidationError;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSGetFileRequestErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSGetFileRequestErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSGetFileRequestErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSGetFileRequestErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSGetFileRequestErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSGetFileRequestErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSGetFileRequestErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSGetFileRequestErrorValidationError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSGetFileRequestErrorDisabledForTeam:
    return @"DBFILEREQUESTSGetFileRequestErrorDisabledForTeam";
  case DBFILEREQUESTSGetFileRequestErrorOther:
    return @"DBFILEREQUESTSGetFileRequestErrorOther";
  case DBFILEREQUESTSGetFileRequestErrorNotFound:
    return @"DBFILEREQUESTSGetFileRequestErrorNotFound";
  case DBFILEREQUESTSGetFileRequestErrorNotAFolder:
    return @"DBFILEREQUESTSGetFileRequestErrorNotAFolder";
  case DBFILEREQUESTSGetFileRequestErrorAppLacksAccess:
    return @"DBFILEREQUESTSGetFileRequestErrorAppLacksAccess";
  case DBFILEREQUESTSGetFileRequestErrorNoPermission:
    return @"DBFILEREQUESTSGetFileRequestErrorNoPermission";
  case DBFILEREQUESTSGetFileRequestErrorEmailUnverified:
    return @"DBFILEREQUESTSGetFileRequestErrorEmailUnverified";
  case DBFILEREQUESTSGetFileRequestErrorValidationError:
    return @"DBFILEREQUESTSGetFileRequestErrorValidationError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSGetFileRequestErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSGetFileRequestErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSGetFileRequestErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSGetFileRequestErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGetFileRequestErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGetFileRequestError:other];
}

- (BOOL)isEqualToGetFileRequestError:(DBFILEREQUESTSGetFileRequestError *)aGetFileRequestError {
  if (self == aGetFileRequestError) {
    return YES;
  }
  if (self.tag != aGetFileRequestError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSGetFileRequestErrorDisabledForTeam:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorOther:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorNotFound:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorNotAFolder:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorAppLacksAccess:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorNoPermission:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorEmailUnverified:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  case DBFILEREQUESTSGetFileRequestErrorValidationError:
    return [[self tagName] isEqual:[aGetFileRequestError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSGetFileRequestErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSGetFileRequestError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSGetFileRequestError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithValidationError];
  } else {
    return [[DBFILEREQUESTSGetFileRequestError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSGracePeriod.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSGracePeriod

#pragma mark - Constructors

- (instancetype)initWithOneDay {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodOneDay;
  }
  return self;
}

- (instancetype)initWithTwoDays {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodTwoDays;
  }
  return self;
}

- (instancetype)initWithSevenDays {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodSevenDays;
  }
  return self;
}

- (instancetype)initWithThirtyDays {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodThirtyDays;
  }
  return self;
}

- (instancetype)initWithAlways {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodAlways;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSGracePeriodOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isOneDay {
  return _tag == DBFILEREQUESTSGracePeriodOneDay;
}

- (BOOL)isTwoDays {
  return _tag == DBFILEREQUESTSGracePeriodTwoDays;
}

- (BOOL)isSevenDays {
  return _tag == DBFILEREQUESTSGracePeriodSevenDays;
}

- (BOOL)isThirtyDays {
  return _tag == DBFILEREQUESTSGracePeriodThirtyDays;
}

- (BOOL)isAlways {
  return _tag == DBFILEREQUESTSGracePeriodAlways;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSGracePeriodOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSGracePeriodOneDay:
    return @"DBFILEREQUESTSGracePeriodOneDay";
  case DBFILEREQUESTSGracePeriodTwoDays:
    return @"DBFILEREQUESTSGracePeriodTwoDays";
  case DBFILEREQUESTSGracePeriodSevenDays:
    return @"DBFILEREQUESTSGracePeriodSevenDays";
  case DBFILEREQUESTSGracePeriodThirtyDays:
    return @"DBFILEREQUESTSGracePeriodThirtyDays";
  case DBFILEREQUESTSGracePeriodAlways:
    return @"DBFILEREQUESTSGracePeriodAlways";
  case DBFILEREQUESTSGracePeriodOther:
    return @"DBFILEREQUESTSGracePeriodOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSGracePeriodSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSGracePeriodSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSGracePeriodSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSGracePeriodOneDay:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGracePeriodTwoDays:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGracePeriodSevenDays:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGracePeriodThirtyDays:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGracePeriodAlways:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSGracePeriodOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToGracePeriod:other];
}

- (BOOL)isEqualToGracePeriod:(DBFILEREQUESTSGracePeriod *)aGracePeriod {
  if (self == aGracePeriod) {
    return YES;
  }
  if (self.tag != aGracePeriod.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSGracePeriodOneDay:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  case DBFILEREQUESTSGracePeriodTwoDays:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  case DBFILEREQUESTSGracePeriodSevenDays:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  case DBFILEREQUESTSGracePeriodThirtyDays:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  case DBFILEREQUESTSGracePeriodAlways:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  case DBFILEREQUESTSGracePeriodOther:
    return [[self tagName] isEqual:[aGracePeriod tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSGracePeriodSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSGracePeriod *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isOneDay]) {
    jsonDict[@".tag"] = @"one_day";
  } else if ([valueObj isTwoDays]) {
    jsonDict[@".tag"] = @"two_days";
  } else if ([valueObj isSevenDays]) {
    jsonDict[@".tag"] = @"seven_days";
  } else if ([valueObj isThirtyDays]) {
    jsonDict[@".tag"] = @"thirty_days";
  } else if ([valueObj isAlways]) {
    jsonDict[@".tag"] = @"always";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSGracePeriod *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"one_day"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithOneDay];
  } else if ([tag isEqualToString:@"two_days"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithTwoDays];
  } else if ([tag isEqualToString:@"seven_days"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithSevenDays];
  } else if ([tag isEqualToString:@"thirty_days"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithThirtyDays];
  } else if ([tag isEqualToString:@"always"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithAlways];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithOther];
  } else {
    return [[DBFILEREQUESTSGracePeriod alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSListFileRequestsArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsArg

#pragma mark - Constructors

- (instancetype)initWithLimit:(NSNumber *)limit {

  self = [super init];
  if (self) {
    _limit = limit ?: @(1000);
  }
  return self;
}

- (instancetype)initDefault {
  return [self initWithLimit:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.limit hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsArg:other];
}

- (BOOL)isEqualToListFileRequestsArg:(DBFILEREQUESTSListFileRequestsArg *)aListFileRequestsArg {
  if (self == aListFileRequestsArg) {
    return YES;
  }
  if (![self.limit isEqual:aListFileRequestsArg.limit]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"limit"] = valueObj.limit;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSNumber *limit = valueDict[@"limit"] ?: @(1000);

  return [[DBFILEREQUESTSListFileRequestsArg alloc] initWithLimit:limit];
}

@end

#import "DBFILEREQUESTSListFileRequestsContinueArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsContinueArg

#pragma mark - Constructors

- (instancetype)initWithCursor:(NSString *)cursor {
  [DBStoneValidators nonnullValidator:nil](cursor);

  self = [super init];
  if (self) {
    _cursor = cursor;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsContinueArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsContinueArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsContinueArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.cursor hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsContinueArg:other];
}

- (BOOL)isEqualToListFileRequestsContinueArg:(DBFILEREQUESTSListFileRequestsContinueArg *)aListFileRequestsContinueArg {
  if (self == aListFileRequestsContinueArg) {
    return YES;
  }
  if (![self.cursor isEqual:aListFileRequestsContinueArg.cursor]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsContinueArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsContinueArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"cursor"] = valueObj.cursor;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsContinueArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *cursor = valueDict[@"cursor"];

  return [[DBFILEREQUESTSListFileRequestsContinueArg alloc] initWithCursor:cursor];
}

@end

#import "DBFILEREQUESTSGeneralFileRequestsError.h"
#import "DBFILEREQUESTSListFileRequestsContinueError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsContinueError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSListFileRequestsContinueErrorOther;
  }
  return self;
}

- (instancetype)initWithInvalidCursor {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSListFileRequestsContinueErrorOther;
}

- (BOOL)isInvalidCursor {
  return _tag == DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam:
    return @"DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam";
  case DBFILEREQUESTSListFileRequestsContinueErrorOther:
    return @"DBFILEREQUESTSListFileRequestsContinueErrorOther";
  case DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor:
    return @"DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsContinueErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsContinueErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsContinueErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSListFileRequestsContinueErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsContinueError:other];
}

- (BOOL)isEqualToListFileRequestsContinueError:
    (DBFILEREQUESTSListFileRequestsContinueError *)aListFileRequestsContinueError {
  if (self == aListFileRequestsContinueError) {
    return YES;
  }
  if (self.tag != aListFileRequestsContinueError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsContinueErrorDisabledForTeam:
    return [[self tagName] isEqual:[aListFileRequestsContinueError tagName]];
  case DBFILEREQUESTSListFileRequestsContinueErrorOther:
    return [[self tagName] isEqual:[aListFileRequestsContinueError tagName]];
  case DBFILEREQUESTSListFileRequestsContinueErrorInvalidCursor:
    return [[self tagName] isEqual:[aListFileRequestsContinueError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsContinueErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsContinueError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isInvalidCursor]) {
    jsonDict[@".tag"] = @"invalid_cursor";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsContinueError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSListFileRequestsContinueError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSListFileRequestsContinueError alloc] initWithOther];
  } else if ([tag isEqualToString:@"invalid_cursor"]) {
    return [[DBFILEREQUESTSListFileRequestsContinueError alloc] initWithInvalidCursor];
  } else {
    return [[DBFILEREQUESTSListFileRequestsContinueError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSGeneralFileRequestsError.h"
#import "DBFILEREQUESTSListFileRequestsError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSListFileRequestsErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSListFileRequestsErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSListFileRequestsErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSListFileRequestsErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsErrorDisabledForTeam:
    return @"DBFILEREQUESTSListFileRequestsErrorDisabledForTeam";
  case DBFILEREQUESTSListFileRequestsErrorOther:
    return @"DBFILEREQUESTSListFileRequestsErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSListFileRequestsErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsError:other];
}

- (BOOL)isEqualToListFileRequestsError:(DBFILEREQUESTSListFileRequestsError *)aListFileRequestsError {
  if (self == aListFileRequestsError) {
    return YES;
  }
  if (self.tag != aListFileRequestsError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSListFileRequestsErrorDisabledForTeam:
    return [[self tagName] isEqual:[aListFileRequestsError tagName]];
  case DBFILEREQUESTSListFileRequestsErrorOther:
    return [[self tagName] isEqual:[aListFileRequestsError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSListFileRequestsError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSListFileRequestsError alloc] initWithOther];
  } else {
    return [[DBFILEREQUESTSListFileRequestsError alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSFileRequest.h"
#import "DBFILEREQUESTSListFileRequestsResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsResult

#pragma mark - Constructors

- (instancetype)initWithFileRequests:(NSArray<DBFILEREQUESTSFileRequest *> *)fileRequests {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileRequests);

  self = [super init];
  if (self) {
    _fileRequests = fileRequests;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fileRequests hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsResult:other];
}

- (BOOL)isEqualToListFileRequestsResult:(DBFILEREQUESTSListFileRequestsResult *)aListFileRequestsResult {
  if (self == aListFileRequestsResult) {
    return YES;
  }
  if (![self.fileRequests isEqual:aListFileRequestsResult.fileRequests]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file_requests"] = [DBArraySerializer serialize:valueObj.fileRequests
                                                  withBlock:^id(id elem0) {
                                                    return [DBFILEREQUESTSFileRequestSerializer serialize:elem0];
                                                  }];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILEREQUESTSFileRequest *> *fileRequests =
      [DBArraySerializer deserialize:valueDict[@"file_requests"]
                           withBlock:^id(id elem0) {
                             return [DBFILEREQUESTSFileRequestSerializer deserialize:elem0];
                           }];

  return [[DBFILEREQUESTSListFileRequestsResult alloc] initWithFileRequests:fileRequests];
}

@end

#import "DBFILEREQUESTSFileRequest.h"
#import "DBFILEREQUESTSListFileRequestsV2Result.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSListFileRequestsV2Result

#pragma mark - Constructors

- (instancetype)initWithFileRequests:(NSArray<DBFILEREQUESTSFileRequest *> *)fileRequests
                              cursor:(NSString *)cursor
                             hasMore:(NSNumber *)hasMore {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators arrayValidator:nil
                                             maxItems:nil
                                        itemValidator:[DBStoneValidators nonnullValidator:nil]]](fileRequests);
  [DBStoneValidators nonnullValidator:nil](cursor);
  [DBStoneValidators nonnullValidator:nil](hasMore);

  self = [super init];
  if (self) {
    _fileRequests = fileRequests;
    _cursor = cursor;
    _hasMore = hasMore;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSListFileRequestsV2ResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSListFileRequestsV2ResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSListFileRequestsV2ResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.fileRequests hash];
  result = prime * result + [self.cursor hash];
  result = prime * result + [self.hasMore hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToListFileRequestsV2Result:other];
}

- (BOOL)isEqualToListFileRequestsV2Result:(DBFILEREQUESTSListFileRequestsV2Result *)aListFileRequestsV2Result {
  if (self == aListFileRequestsV2Result) {
    return YES;
  }
  if (![self.fileRequests isEqual:aListFileRequestsV2Result.fileRequests]) {
    return NO;
  }
  if (![self.cursor isEqual:aListFileRequestsV2Result.cursor]) {
    return NO;
  }
  if (![self.hasMore isEqual:aListFileRequestsV2Result.hasMore]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSListFileRequestsV2ResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSListFileRequestsV2Result *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"file_requests"] = [DBArraySerializer serialize:valueObj.fileRequests
                                                  withBlock:^id(id elem0) {
                                                    return [DBFILEREQUESTSFileRequestSerializer serialize:elem0];
                                                  }];
  jsonDict[@"cursor"] = valueObj.cursor;
  jsonDict[@"has_more"] = valueObj.hasMore;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSListFileRequestsV2Result *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSArray<DBFILEREQUESTSFileRequest *> *fileRequests =
      [DBArraySerializer deserialize:valueDict[@"file_requests"]
                           withBlock:^id(id elem0) {
                             return [DBFILEREQUESTSFileRequestSerializer deserialize:elem0];
                           }];
  NSString *cursor = valueDict[@"cursor"];
  NSNumber *hasMore = valueDict[@"has_more"];

  return
      [[DBFILEREQUESTSListFileRequestsV2Result alloc] initWithFileRequests:fileRequests cursor:cursor hasMore:hasMore];
}

@end

#import "DBFILEREQUESTSUpdateFileRequestArgs.h"
#import "DBFILEREQUESTSUpdateFileRequestDeadline.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSUpdateFileRequestArgs

#pragma mark - Constructors

- (instancetype)initWithId_:(NSString *)id_
                      title:(NSString *)title
                destination:(NSString *)destination
                   deadline:(DBFILEREQUESTSUpdateFileRequestDeadline *)deadline
                       open:(NSNumber *)open
               description_:(NSString *)description_ {
  [DBStoneValidators
   nonnullValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:@"[-_0-9a-zA-Z]+"]](id_);
  [DBStoneValidators nullableValidator:[DBStoneValidators stringValidator:@(1) maxLength:nil pattern:nil]](title);
  [DBStoneValidators
   nullableValidator:[DBStoneValidators stringValidator:nil maxLength:nil pattern:@"/(.|[\\r\\n])*"]](destination);

  self = [super init];
  if (self) {
    _id_ = id_;
    _title = title;
    _destination = destination;
    _deadline = deadline ?: [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithNoUpdate];
    _open = open;
    _description_ = description_;
  }
  return self;
}

- (instancetype)initWithId_:(NSString *)id_ {
  return [self initWithId_:id_ title:nil destination:nil deadline:nil open:nil description_:nil];
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSUpdateFileRequestArgsSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSUpdateFileRequestArgsSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSUpdateFileRequestArgsSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.id_ hash];
  if (self.title != nil) {
    result = prime * result + [self.title hash];
  }
  if (self.destination != nil) {
    result = prime * result + [self.destination hash];
  }
  result = prime * result + [self.deadline hash];
  if (self.open != nil) {
    result = prime * result + [self.open hash];
  }
  if (self.description_ != nil) {
    result = prime * result + [self.description_ hash];
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFileRequestArgs:other];
}

- (BOOL)isEqualToUpdateFileRequestArgs:(DBFILEREQUESTSUpdateFileRequestArgs *)anUpdateFileRequestArgs {
  if (self == anUpdateFileRequestArgs) {
    return YES;
  }
  if (![self.id_ isEqual:anUpdateFileRequestArgs.id_]) {
    return NO;
  }
  if (self.title) {
    if (![self.title isEqual:anUpdateFileRequestArgs.title]) {
      return NO;
    }
  }
  if (self.destination) {
    if (![self.destination isEqual:anUpdateFileRequestArgs.destination]) {
      return NO;
    }
  }
  if (![self.deadline isEqual:anUpdateFileRequestArgs.deadline]) {
    return NO;
  }
  if (self.open) {
    if (![self.open isEqual:anUpdateFileRequestArgs.open]) {
      return NO;
    }
  }
  if (self.description_) {
    if (![self.description_ isEqual:anUpdateFileRequestArgs.description_]) {
      return NO;
    }
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSUpdateFileRequestArgsSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSUpdateFileRequestArgs *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"id"] = valueObj.id_;
  if (valueObj.title) {
    jsonDict[@"title"] = valueObj.title;
  }
  if (valueObj.destination) {
    jsonDict[@"destination"] = valueObj.destination;
  }
  jsonDict[@"deadline"] = [DBFILEREQUESTSUpdateFileRequestDeadlineSerializer serialize:valueObj.deadline];
  if (valueObj.open) {
    jsonDict[@"open"] = valueObj.open;
  }
  if (valueObj.description_) {
    jsonDict[@"description"] = valueObj.description_;
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSUpdateFileRequestArgs *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *id_ = valueDict[@"id"];
  NSString *title = valueDict[@"title"] ?: nil;
  NSString *destination = valueDict[@"destination"] ?: nil;
  DBFILEREQUESTSUpdateFileRequestDeadline *deadline =
      valueDict[@"deadline"] ? [DBFILEREQUESTSUpdateFileRequestDeadlineSerializer deserialize:valueDict[@"deadline"]]
                             : [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithNoUpdate];
  NSNumber *open = valueDict[@"open"] ?: nil;
  NSString *description_ = valueDict[@"description"] ?: nil;

  return [[DBFILEREQUESTSUpdateFileRequestArgs alloc] initWithId_:id_
                                                            title:title
                                                      destination:destination
                                                         deadline:deadline
                                                             open:open
                                                     description_:description_];
}

@end

#import "DBFILEREQUESTSFileRequestDeadline.h"
#import "DBFILEREQUESTSUpdateFileRequestDeadline.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSUpdateFileRequestDeadline

@synthesize update = _update;

#pragma mark - Constructors

- (instancetype)initWithNoUpdate {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate;
  }
  return self;
}

- (instancetype)initWithUpdate:(DBFILEREQUESTSFileRequestDeadline *)update {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestDeadlineUpdate;
    _update = update;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestDeadlineOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (DBFILEREQUESTSFileRequestDeadline *)update {
  if (![self isUpdate]) {
    [NSException
         raise:@"IllegalStateException"
        format:@"Invalid tag: required DBFILEREQUESTSUpdateFileRequestDeadlineUpdate, but was %@.", [self tagName]];
  }
  return _update;
}

#pragma mark - Tag state methods

- (BOOL)isNoUpdate {
  return _tag == DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate;
}

- (BOOL)isUpdate {
  return _tag == DBFILEREQUESTSUpdateFileRequestDeadlineUpdate;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSUpdateFileRequestDeadlineOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate:
    return @"DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate";
  case DBFILEREQUESTSUpdateFileRequestDeadlineUpdate:
    return @"DBFILEREQUESTSUpdateFileRequestDeadlineUpdate";
  case DBFILEREQUESTSUpdateFileRequestDeadlineOther:
    return @"DBFILEREQUESTSUpdateFileRequestDeadlineOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSUpdateFileRequestDeadlineSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSUpdateFileRequestDeadlineSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSUpdateFileRequestDeadlineSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestDeadlineUpdate:
    if (self.update != nil) {
      result = prime * result + [self.update hash];
    }
    break;
  case DBFILEREQUESTSUpdateFileRequestDeadlineOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFileRequestDeadline:other];
}

- (BOOL)isEqualToUpdateFileRequestDeadline:(DBFILEREQUESTSUpdateFileRequestDeadline *)anUpdateFileRequestDeadline {
  if (self == anUpdateFileRequestDeadline) {
    return YES;
  }
  if (self.tag != anUpdateFileRequestDeadline.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestDeadlineNoUpdate:
    return [[self tagName] isEqual:[anUpdateFileRequestDeadline tagName]];
  case DBFILEREQUESTSUpdateFileRequestDeadlineUpdate:
    if (self.update) {
      return [self.update isEqual:anUpdateFileRequestDeadline.update];
    }
  case DBFILEREQUESTSUpdateFileRequestDeadlineOther:
    return [[self tagName] isEqual:[anUpdateFileRequestDeadline tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSUpdateFileRequestDeadlineSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSUpdateFileRequestDeadline *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isNoUpdate]) {
    jsonDict[@".tag"] = @"no_update";
  } else if ([valueObj isUpdate]) {
    if (valueObj.update) {
      jsonDict = [[DBFILEREQUESTSFileRequestDeadlineSerializer serialize:valueObj.update] mutableCopy];
    }
    jsonDict[@".tag"] = @"update";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSUpdateFileRequestDeadline *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"no_update"]) {
    return [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithNoUpdate];
  } else if ([tag isEqualToString:@"update"]) {
    DBFILEREQUESTSFileRequestDeadline *update =
        valueDict ? [DBFILEREQUESTSFileRequestDeadlineSerializer deserialize:valueDict] : nil;
    return [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithUpdate:update];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithOther];
  } else {
    return [[DBFILEREQUESTSUpdateFileRequestDeadline alloc] initWithOther];
  }
}

@end

#import "DBFILEREQUESTSFileRequestError.h"
#import "DBFILEREQUESTSUpdateFileRequestError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBFILEREQUESTSUpdateFileRequestError

#pragma mark - Constructors

- (instancetype)initWithDisabledForTeam {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorOther;
  }
  return self;
}

- (instancetype)initWithNotFound {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorNotFound;
  }
  return self;
}

- (instancetype)initWithNotAFolder {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorNotAFolder;
  }
  return self;
}

- (instancetype)initWithAppLacksAccess {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess;
  }
  return self;
}

- (instancetype)initWithNoPermission {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorNoPermission;
  }
  return self;
}

- (instancetype)initWithEmailUnverified {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified;
  }
  return self;
}

- (instancetype)initWithValidationError {
  self = [super init];
  if (self) {
    _tag = DBFILEREQUESTSUpdateFileRequestErrorValidationError;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isDisabledForTeam {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam;
}

- (BOOL)isOther {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorOther;
}

- (BOOL)isNotFound {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorNotFound;
}

- (BOOL)isNotAFolder {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorNotAFolder;
}

- (BOOL)isAppLacksAccess {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess;
}

- (BOOL)isNoPermission {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorNoPermission;
}

- (BOOL)isEmailUnverified {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified;
}

- (BOOL)isValidationError {
  return _tag == DBFILEREQUESTSUpdateFileRequestErrorValidationError;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam:
    return @"DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam";
  case DBFILEREQUESTSUpdateFileRequestErrorOther:
    return @"DBFILEREQUESTSUpdateFileRequestErrorOther";
  case DBFILEREQUESTSUpdateFileRequestErrorNotFound:
    return @"DBFILEREQUESTSUpdateFileRequestErrorNotFound";
  case DBFILEREQUESTSUpdateFileRequestErrorNotAFolder:
    return @"DBFILEREQUESTSUpdateFileRequestErrorNotAFolder";
  case DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess:
    return @"DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess";
  case DBFILEREQUESTSUpdateFileRequestErrorNoPermission:
    return @"DBFILEREQUESTSUpdateFileRequestErrorNoPermission";
  case DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified:
    return @"DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified";
  case DBFILEREQUESTSUpdateFileRequestErrorValidationError:
    return @"DBFILEREQUESTSUpdateFileRequestErrorValidationError";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBFILEREQUESTSUpdateFileRequestErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBFILEREQUESTSUpdateFileRequestErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBFILEREQUESTSUpdateFileRequestErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorNotFound:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorNotAFolder:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorNoPermission:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified:
    result = prime * result + [[self tagName] hash];
    break;
  case DBFILEREQUESTSUpdateFileRequestErrorValidationError:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToUpdateFileRequestError:other];
}

- (BOOL)isEqualToUpdateFileRequestError:(DBFILEREQUESTSUpdateFileRequestError *)anUpdateFileRequestError {
  if (self == anUpdateFileRequestError) {
    return YES;
  }
  if (self.tag != anUpdateFileRequestError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBFILEREQUESTSUpdateFileRequestErrorDisabledForTeam:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorOther:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorNotFound:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorNotAFolder:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorAppLacksAccess:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorNoPermission:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorEmailUnverified:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  case DBFILEREQUESTSUpdateFileRequestErrorValidationError:
    return [[self tagName] isEqual:[anUpdateFileRequestError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBFILEREQUESTSUpdateFileRequestErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBFILEREQUESTSUpdateFileRequestError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isDisabledForTeam]) {
    jsonDict[@".tag"] = @"disabled_for_team";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else if ([valueObj isNotFound]) {
    jsonDict[@".tag"] = @"not_found";
  } else if ([valueObj isNotAFolder]) {
    jsonDict[@".tag"] = @"not_a_folder";
  } else if ([valueObj isAppLacksAccess]) {
    jsonDict[@".tag"] = @"app_lacks_access";
  } else if ([valueObj isNoPermission]) {
    jsonDict[@".tag"] = @"no_permission";
  } else if ([valueObj isEmailUnverified]) {
    jsonDict[@".tag"] = @"email_unverified";
  } else if ([valueObj isValidationError]) {
    jsonDict[@".tag"] = @"validation_error";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBFILEREQUESTSUpdateFileRequestError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"disabled_for_team"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithDisabledForTeam];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithOther];
  } else if ([tag isEqualToString:@"not_found"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithNotFound];
  } else if ([tag isEqualToString:@"not_a_folder"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithNotAFolder];
  } else if ([tag isEqualToString:@"app_lacks_access"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithAppLacksAccess];
  } else if ([tag isEqualToString:@"no_permission"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithNoPermission];
  } else if ([tag isEqualToString:@"email_unverified"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithEmailUnverified];
  } else if ([tag isEqualToString:@"validation_error"]) {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithValidationError];
  } else {
    return [[DBFILEREQUESTSUpdateFileRequestError alloc] initWithOther];
  }
}

@end
