///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBCONTACTSDeleteManualContactsError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `DeleteManualContactsError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBCONTACTSDeleteManualContactsError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBCONTACTSDeleteManualContactsErrorTag` enum type represents the
/// possible tag states with which the `DBCONTACTSDeleteManualContactsError`
/// union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBCONTACTSDeleteManualContactsErrorTag){
    /// Can't delete contacts from this list. Make sure the list only has
    /// manually added contacts. The deletion was cancelled.
    DBCONTACTSDeleteManualContactsErrorContactsNotFound,

    /// (no description).
    DBCONTACTSDeleteManualContactsErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBCONTACTSDeleteManualContactsErrorTag tag;

/// Can't delete contacts from this list. Make sure the list only has manually
/// added contacts. The deletion was cancelled. @note Ensure the
/// `isContactsNotFound` method returns true before accessing, otherwise a
/// runtime exception will be raised.
@property (nonatomic, readonly) NSArray<NSString *> *contactsNotFound;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "contacts_not_found".
///
/// Description of the "contacts_not_found" tag state: Can't delete contacts
/// from this list. Make sure the list only has manually added contacts. The
/// deletion was cancelled.
///
/// @param contactsNotFound Can't delete contacts from this list. Make sure the
/// list only has manually added contacts. The deletion was cancelled.
///
/// @return An initialized instance.
///
- (instancetype)initWithContactsNotFound:(NSArray<NSString *> *)contactsNotFound;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value
/// "contacts_not_found".
///
/// @note Call this method and ensure it returns true before accessing the
/// `contactsNotFound` property, otherwise a runtime exception will be thrown.
///
/// @return Whether the union's current tag state has value
/// "contacts_not_found".
///
- (BOOL)isContactsNotFound;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBCONTACTSDeleteManualContactsError` union.
///
@interface DBCONTACTSDeleteManualContactsErrorSerializer : NSObject

///
/// Serializes `DBCONTACTSDeleteManualContactsError` instances.
///
/// @param instance An instance of the `DBCONTACTSDeleteManualContactsError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBCONTACTSDeleteManualContactsError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBCONTACTSDeleteManualContactsError *)instance;

///
/// Deserializes `DBCONTACTSDeleteManualContactsError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBCONTACTSDeleteManualContactsError` API object.
///
/// @return An instantiation of the `DBCONTACTSDeleteManualContactsError`
/// object.
///
+ (DBCONTACTSDeleteManualContactsError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
