///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBSerializableProtocol.h"

@class DBACCOUNTSetProfilePhotoError;

NS_ASSUME_NONNULL_BEGIN

#pragma mark - API Object

///
/// The `SetProfilePhotoError` union.
///
/// This class implements the `DBSerializable` protocol (serialize and
/// deserialize instance methods), which is required for all Obj-C SDK API route
/// objects.
///
@interface DBACCOUNTSetProfilePhotoError : NSObject <DBSerializable, NSCopying>

#pragma mark - Instance fields

/// The `DBACCOUNTSetProfilePhotoErrorTag` enum type represents the possible tag
/// states with which the `DBACCOUNTSetProfilePhotoError` union can exist.
typedef NS_CLOSED_ENUM(NSInteger, DBACCOUNTSetProfilePhotoErrorTag){
    /// File cannot be set as profile photo.
    DBACCOUNTSetProfilePhotoErrorFileTypeError,

    /// File cannot exceed 10 MB.
    DBACCOUNTSetProfilePhotoErrorFileSizeError,

    /// Image must be larger than 128 x 128.
    DBACCOUNTSetProfilePhotoErrorDimensionError,

    /// Image could not be thumbnailed.
    DBACCOUNTSetProfilePhotoErrorThumbnailError,

    /// Temporary infrastructure failure, please retry.
    DBACCOUNTSetProfilePhotoErrorTransientError,

    /// (no description).
    DBACCOUNTSetProfilePhotoErrorOther,

};

/// Represents the union's current tag state.
@property (nonatomic, readonly) DBACCOUNTSetProfilePhotoErrorTag tag;

#pragma mark - Constructors

///
/// Initializes union class with tag state of "file_type_error".
///
/// Description of the "file_type_error" tag state: File cannot be set as
/// profile photo.
///
/// @return An initialized instance.
///
- (instancetype)initWithFileTypeError;

///
/// Initializes union class with tag state of "file_size_error".
///
/// Description of the "file_size_error" tag state: File cannot exceed 10 MB.
///
/// @return An initialized instance.
///
- (instancetype)initWithFileSizeError;

///
/// Initializes union class with tag state of "dimension_error".
///
/// Description of the "dimension_error" tag state: Image must be larger than
/// 128 x 128.
///
/// @return An initialized instance.
///
- (instancetype)initWithDimensionError;

///
/// Initializes union class with tag state of "thumbnail_error".
///
/// Description of the "thumbnail_error" tag state: Image could not be
/// thumbnailed.
///
/// @return An initialized instance.
///
- (instancetype)initWithThumbnailError;

///
/// Initializes union class with tag state of "transient_error".
///
/// Description of the "transient_error" tag state: Temporary infrastructure
/// failure, please retry.
///
/// @return An initialized instance.
///
- (instancetype)initWithTransientError;

///
/// Initializes union class with tag state of "other".
///
/// @return An initialized instance.
///
- (instancetype)initWithOther;

- (instancetype)init NS_UNAVAILABLE;

#pragma mark - Tag state methods

///
/// Retrieves whether the union's current tag state has value "file_type_error".
///
/// @return Whether the union's current tag state has value "file_type_error".
///
- (BOOL)isFileTypeError;

///
/// Retrieves whether the union's current tag state has value "file_size_error".
///
/// @return Whether the union's current tag state has value "file_size_error".
///
- (BOOL)isFileSizeError;

///
/// Retrieves whether the union's current tag state has value "dimension_error".
///
/// @return Whether the union's current tag state has value "dimension_error".
///
- (BOOL)isDimensionError;

///
/// Retrieves whether the union's current tag state has value "thumbnail_error".
///
/// @return Whether the union's current tag state has value "thumbnail_error".
///
- (BOOL)isThumbnailError;

///
/// Retrieves whether the union's current tag state has value "transient_error".
///
/// @return Whether the union's current tag state has value "transient_error".
///
- (BOOL)isTransientError;

///
/// Retrieves whether the union's current tag state has value "other".
///
/// @return Whether the union's current tag state has value "other".
///
- (BOOL)isOther;

///
/// Retrieves string value of union's current tag state.
///
/// @return A human-readable string representing the union's current tag state.
///
- (NSString *)tagName;

@end

#pragma mark - Serializer Object

///
/// The serialization class for the `DBACCOUNTSetProfilePhotoError` union.
///
@interface DBACCOUNTSetProfilePhotoErrorSerializer : NSObject

///
/// Serializes `DBACCOUNTSetProfilePhotoError` instances.
///
/// @param instance An instance of the `DBACCOUNTSetProfilePhotoError` API
/// object.
///
/// @return A json-compatible dictionary representation of the
/// `DBACCOUNTSetProfilePhotoError` API object.
///
+ (nullable NSDictionary<NSString *, id> *)serialize:(DBACCOUNTSetProfilePhotoError *)instance;

///
/// Deserializes `DBACCOUNTSetProfilePhotoError` instances.
///
/// @param dict A json-compatible dictionary representation of the
/// `DBACCOUNTSetProfilePhotoError` API object.
///
/// @return An instantiation of the `DBACCOUNTSetProfilePhotoError` object.
///
+ (DBACCOUNTSetProfilePhotoError *)deserialize:(NSDictionary<NSString *, id> *)dict;

@end

NS_ASSUME_NONNULL_END
