///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

/// Arguments, results, and errors for the `Account` namespace.

#import "DBACCOUNTPhotoSourceArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBACCOUNTPhotoSourceArg

@synthesize base64Data = _base64Data;

#pragma mark - Constructors

- (instancetype)initWithBase64Data:(NSString *)base64Data {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTPhotoSourceArgBase64Data;
    _base64Data = base64Data;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTPhotoSourceArgOther;
  }
  return self;
}

#pragma mark - Instance field accessors

- (NSString *)base64Data {
  if (![self isBase64Data]) {
    [NSException raise:@"IllegalStateException"
                format:@"Invalid tag: required DBACCOUNTPhotoSourceArgBase64Data, but was %@.", [self tagName]];
  }
  return _base64Data;
}

#pragma mark - Tag state methods

- (BOOL)isBase64Data {
  return _tag == DBACCOUNTPhotoSourceArgBase64Data;
}

- (BOOL)isOther {
  return _tag == DBACCOUNTPhotoSourceArgOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBACCOUNTPhotoSourceArgBase64Data:
    return @"DBACCOUNTPhotoSourceArgBase64Data";
  case DBACCOUNTPhotoSourceArgOther:
    return @"DBACCOUNTPhotoSourceArgOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBACCOUNTPhotoSourceArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBACCOUNTPhotoSourceArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBACCOUNTPhotoSourceArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBACCOUNTPhotoSourceArgBase64Data:
    result = prime * result + [self.base64Data hash];
    break;
  case DBACCOUNTPhotoSourceArgOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToPhotoSourceArg:other];
}

- (BOOL)isEqualToPhotoSourceArg:(DBACCOUNTPhotoSourceArg *)aPhotoSourceArg {
  if (self == aPhotoSourceArg) {
    return YES;
  }
  if (self.tag != aPhotoSourceArg.tag) {
    return NO;
  }
  switch (_tag) {
  case DBACCOUNTPhotoSourceArgBase64Data:
    return [self.base64Data isEqual:aPhotoSourceArg.base64Data];
  case DBACCOUNTPhotoSourceArgOther:
    return [[self tagName] isEqual:[aPhotoSourceArg tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBACCOUNTPhotoSourceArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBACCOUNTPhotoSourceArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isBase64Data]) {
    jsonDict[@"base64_data"] = valueObj.base64Data;
    jsonDict[@".tag"] = @"base64_data";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBACCOUNTPhotoSourceArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"base64_data"]) {
    NSString *base64Data = valueDict[@"base64_data"];
    return [[DBACCOUNTPhotoSourceArg alloc] initWithBase64Data:base64Data];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBACCOUNTPhotoSourceArg alloc] initWithOther];
  } else {
    return [[DBACCOUNTPhotoSourceArg alloc] initWithOther];
  }
}

@end

#import "DBACCOUNTPhotoSourceArg.h"
#import "DBACCOUNTSetProfilePhotoArg.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBACCOUNTSetProfilePhotoArg

#pragma mark - Constructors

- (instancetype)initWithPhoto:(DBACCOUNTPhotoSourceArg *)photo {
  [DBStoneValidators nonnullValidator:nil](photo);

  self = [super init];
  if (self) {
    _photo = photo;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBACCOUNTSetProfilePhotoArgSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBACCOUNTSetProfilePhotoArgSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBACCOUNTSetProfilePhotoArgSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.photo hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetProfilePhotoArg:other];
}

- (BOOL)isEqualToSetProfilePhotoArg:(DBACCOUNTSetProfilePhotoArg *)aSetProfilePhotoArg {
  if (self == aSetProfilePhotoArg) {
    return YES;
  }
  if (![self.photo isEqual:aSetProfilePhotoArg.photo]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBACCOUNTSetProfilePhotoArgSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBACCOUNTSetProfilePhotoArg *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"photo"] = [DBACCOUNTPhotoSourceArgSerializer serialize:valueObj.photo];

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBACCOUNTSetProfilePhotoArg *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  DBACCOUNTPhotoSourceArg *photo = [DBACCOUNTPhotoSourceArgSerializer deserialize:valueDict[@"photo"]];

  return [[DBACCOUNTSetProfilePhotoArg alloc] initWithPhoto:photo];
}

@end

#import "DBACCOUNTSetProfilePhotoError.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBACCOUNTSetProfilePhotoError

#pragma mark - Constructors

- (instancetype)initWithFileTypeError {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorFileTypeError;
  }
  return self;
}

- (instancetype)initWithFileSizeError {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorFileSizeError;
  }
  return self;
}

- (instancetype)initWithDimensionError {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorDimensionError;
  }
  return self;
}

- (instancetype)initWithThumbnailError {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorThumbnailError;
  }
  return self;
}

- (instancetype)initWithTransientError {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorTransientError;
  }
  return self;
}

- (instancetype)initWithOther {
  self = [super init];
  if (self) {
    _tag = DBACCOUNTSetProfilePhotoErrorOther;
  }
  return self;
}

#pragma mark - Instance field accessors

#pragma mark - Tag state methods

- (BOOL)isFileTypeError {
  return _tag == DBACCOUNTSetProfilePhotoErrorFileTypeError;
}

- (BOOL)isFileSizeError {
  return _tag == DBACCOUNTSetProfilePhotoErrorFileSizeError;
}

- (BOOL)isDimensionError {
  return _tag == DBACCOUNTSetProfilePhotoErrorDimensionError;
}

- (BOOL)isThumbnailError {
  return _tag == DBACCOUNTSetProfilePhotoErrorThumbnailError;
}

- (BOOL)isTransientError {
  return _tag == DBACCOUNTSetProfilePhotoErrorTransientError;
}

- (BOOL)isOther {
  return _tag == DBACCOUNTSetProfilePhotoErrorOther;
}

- (NSString *)tagName {
  switch (_tag) {
  case DBACCOUNTSetProfilePhotoErrorFileTypeError:
    return @"DBACCOUNTSetProfilePhotoErrorFileTypeError";
  case DBACCOUNTSetProfilePhotoErrorFileSizeError:
    return @"DBACCOUNTSetProfilePhotoErrorFileSizeError";
  case DBACCOUNTSetProfilePhotoErrorDimensionError:
    return @"DBACCOUNTSetProfilePhotoErrorDimensionError";
  case DBACCOUNTSetProfilePhotoErrorThumbnailError:
    return @"DBACCOUNTSetProfilePhotoErrorThumbnailError";
  case DBACCOUNTSetProfilePhotoErrorTransientError:
    return @"DBACCOUNTSetProfilePhotoErrorTransientError";
  case DBACCOUNTSetProfilePhotoErrorOther:
    return @"DBACCOUNTSetProfilePhotoErrorOther";
  }

  @throw([NSException exceptionWithName:@"InvalidTag" reason:@"Tag has an unknown value." userInfo:nil]);
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBACCOUNTSetProfilePhotoErrorSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBACCOUNTSetProfilePhotoErrorSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBACCOUNTSetProfilePhotoErrorSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  switch (_tag) {
  case DBACCOUNTSetProfilePhotoErrorFileTypeError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBACCOUNTSetProfilePhotoErrorFileSizeError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBACCOUNTSetProfilePhotoErrorDimensionError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBACCOUNTSetProfilePhotoErrorThumbnailError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBACCOUNTSetProfilePhotoErrorTransientError:
    result = prime * result + [[self tagName] hash];
    break;
  case DBACCOUNTSetProfilePhotoErrorOther:
    result = prime * result + [[self tagName] hash];
    break;
  }

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetProfilePhotoError:other];
}

- (BOOL)isEqualToSetProfilePhotoError:(DBACCOUNTSetProfilePhotoError *)aSetProfilePhotoError {
  if (self == aSetProfilePhotoError) {
    return YES;
  }
  if (self.tag != aSetProfilePhotoError.tag) {
    return NO;
  }
  switch (_tag) {
  case DBACCOUNTSetProfilePhotoErrorFileTypeError:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  case DBACCOUNTSetProfilePhotoErrorFileSizeError:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  case DBACCOUNTSetProfilePhotoErrorDimensionError:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  case DBACCOUNTSetProfilePhotoErrorThumbnailError:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  case DBACCOUNTSetProfilePhotoErrorTransientError:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  case DBACCOUNTSetProfilePhotoErrorOther:
    return [[self tagName] isEqual:[aSetProfilePhotoError tagName]];
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBACCOUNTSetProfilePhotoErrorSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBACCOUNTSetProfilePhotoError *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  if ([valueObj isFileTypeError]) {
    jsonDict[@".tag"] = @"file_type_error";
  } else if ([valueObj isFileSizeError]) {
    jsonDict[@".tag"] = @"file_size_error";
  } else if ([valueObj isDimensionError]) {
    jsonDict[@".tag"] = @"dimension_error";
  } else if ([valueObj isThumbnailError]) {
    jsonDict[@".tag"] = @"thumbnail_error";
  } else if ([valueObj isTransientError]) {
    jsonDict[@".tag"] = @"transient_error";
  } else if ([valueObj isOther]) {
    jsonDict[@".tag"] = @"other";
  } else {
    jsonDict[@".tag"] = @"other";
  }

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBACCOUNTSetProfilePhotoError *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *tag = valueDict[@".tag"];

  if ([tag isEqualToString:@"file_type_error"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithFileTypeError];
  } else if ([tag isEqualToString:@"file_size_error"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithFileSizeError];
  } else if ([tag isEqualToString:@"dimension_error"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithDimensionError];
  } else if ([tag isEqualToString:@"thumbnail_error"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithThumbnailError];
  } else if ([tag isEqualToString:@"transient_error"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithTransientError];
  } else if ([tag isEqualToString:@"other"]) {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithOther];
  } else {
    return [[DBACCOUNTSetProfilePhotoError alloc] initWithOther];
  }
}

@end

#import "DBACCOUNTSetProfilePhotoResult.h"
#import "DBStoneSerializers.h"
#import "DBStoneValidators.h"

#pragma mark - API Object

@implementation DBACCOUNTSetProfilePhotoResult

#pragma mark - Constructors

- (instancetype)initWithProfilePhotoUrl:(NSString *)profilePhotoUrl {
  [DBStoneValidators nonnullValidator:nil](profilePhotoUrl);

  self = [super init];
  if (self) {
    _profilePhotoUrl = profilePhotoUrl;
  }
  return self;
}

#pragma mark - Serialization methods

+ (nullable NSDictionary<NSString *, id> *)serialize:(id)instance {
  return [DBACCOUNTSetProfilePhotoResultSerializer serialize:instance];
}

+ (id)deserialize:(NSDictionary<NSString *, id> *)dict {
  return [DBACCOUNTSetProfilePhotoResultSerializer deserialize:dict];
}

#pragma mark - Debug Description method

- (NSString *)debugDescription {
  return [[DBACCOUNTSetProfilePhotoResultSerializer serialize:self] description];
}

#pragma mark - Copyable method

- (instancetype)copyWithZone:(NSZone *)zone {
#pragma unused(zone)
  /// object is immutable
  return self;
}

#pragma mark - Hash method

- (NSUInteger)hash {
  NSUInteger prime = 31;
  NSUInteger result = 1;

  result = prime * result + [self.profilePhotoUrl hash];

  return prime * result;
}

#pragma mark - Equality method

- (BOOL)isEqual:(id)other {
  if (other == self) {
    return YES;
  }
  if (!other || ![other isKindOfClass:[self class]]) {
    return NO;
  }
  return [self isEqualToSetProfilePhotoResult:other];
}

- (BOOL)isEqualToSetProfilePhotoResult:(DBACCOUNTSetProfilePhotoResult *)aSetProfilePhotoResult {
  if (self == aSetProfilePhotoResult) {
    return YES;
  }
  if (![self.profilePhotoUrl isEqual:aSetProfilePhotoResult.profilePhotoUrl]) {
    return NO;
  }
  return YES;
}

@end

#pragma mark - Serializer Object

@implementation DBACCOUNTSetProfilePhotoResultSerializer

+ (NSDictionary<NSString *, id> *)serialize:(DBACCOUNTSetProfilePhotoResult *)valueObj {
  NSMutableDictionary *jsonDict = [[NSMutableDictionary alloc] init];

  jsonDict[@"profile_photo_url"] = valueObj.profilePhotoUrl;

  return [jsonDict count] > 0 ? jsonDict : nil;
}

+ (DBACCOUNTSetProfilePhotoResult *)deserialize:(NSDictionary<NSString *, id> *)valueDict {
  NSString *profilePhotoUrl = valueDict[@"profile_photo_url"];

  return [[DBACCOUNTSetProfilePhotoResult alloc] initWithProfilePhotoUrl:profilePhotoUrl];
}

@end
