﻿//===================================================================================================
// BCR API如下:
//注意: 3 ~ 7的API所使用的二值化Bitmap是採用global variable儲存,故使用FreeBinarize()後,會導致Understanding()和RecognizeClip()無法使用產生回傳錯誤.

// 1.連結kernel需要的database

#if TARGET_OS_IPHONE
extern void Connect();
#elif TARGET_OS_MAC
extern void Connect(const char* aDBPath);
#endif
/*//參數說明:
	aDBPath: 核心資料庫路徑.
 //*/

// 2.釋放kernel使用的database
extern void Disconnect();

// 3.針對jpeg data做二值化
extern int CreateBinarize(int aLang, char* aJpgbuf, int aBufsize);
/*//參數說明:
	aLang: 辨識語系,請參考以下[註1].
	aJpgbuf: jpeg data.
	aBufsize: size of jpeg data.
	回傳值:
		-1000:解jpeg失敗.
		< 0:二值化失敗.
		1:原圖二值化成功.
		2:放大兩倍原圖二值化成功.
		以此類推...
//*/

// 4.針對bitmap data做二值化
#if TARGET_OS_IPHONE
extern int CreateBinarizebmp(int aLang, char* aBmpbuf, int aWidth, int aHeight, int aBufsize);
#elif TARGET_OS_MAC
extern int CreateBinarizebmp(int aLang, char* aBmpbuf, int aWidth, int aHeight, int aBitCount, int aBufsize);
#endif
/*//參數說明:
	aLang: 辨識語系,請參考以下[註1].
	aBmpbuf: bitmap data.
	aWidth: width of bitmap.
	aHeight: height of bitmap.
	aBufsize: size of bitmap data.
	回傳值:
		-1000:bitmap等於null.
		-1001:aHeight或aWidth小於等於0.
		-1002:配置記憶體失敗.
		< 0:二值化失敗.
		1:原圖二值化成功.
		2:放大兩倍原圖二值化成功.
		以此類推...
//*/

// 5.釋放二值化的bitmap記憶體
extern void FreeBinarize();

// 6.進行整張名片辨識
extern int Understanding(int aLang, int aTranLang, int aDir, short* aResult);
/*//參數說明:
	aLang: 辨識語系,請參考以下[註1].
	aTranLang: 辨識結果轉換的語系,請參考以下[註2].
	aDir: 名片的方向,請參考以下[註3].
	aResult: 辨識結果,請參考以下[註4].
	回傳值:
		-1001:二值化的bitmap等於null
		< 0:辨識失敗.
		0:核心辨識名片的角度.
		90:核心辨識名片的角度.
		180:核心辨識名片的角度.
		270:核心辨識名片的角度.
//*/

// 7.欄位手刮辨識
extern int RecognizeClip(int aLang, int aTranLang, int aDir, unsigned short aFieldType, int aLeft, int aTop, int aRight, int aBottom, short* aResult);
/*//參數說明:
	aLang: 辨識語系,請參考以下[註1].
	aTranLang: 辨識結果轉換的語系,請參考以下[註2].
	aDir: 名片方向,請參考以下[註3].
	aFieldType:欄位類型.
	aLeft:欄位影像的左邊座標.
	aTop:欄位影像的上方座標.
	aRight:欄位影像的右邊座標.
	aBottom:欄位影像的下方座標.
	aResult: 辨識結果,請參考以下[註4].
//*/

// 8.電子簽章的辨識
extern int Parsing(unsigned short *aInputStr, unsigned short *aOutputStr);
/*//參數說明:
	aInputStr: 辨識語系,請參考以下[註1].
	aOutputStr: 辨識結果,請參考以下[註4].
	回傳值:
		-1001:aInputStr或aOutputStr等於null.
		< 0:辨識失敗.
//*/

// 9.針對批次的整張名片辨識
extern int UnderstandingBatch(char* aJpgbuf, int aBufsize, int aLang, int aTranLang, int aDir, short* aResult);
/*//參數說明:
	aJpgbuf: jpeg data.
	aBufsize: size of jpeg data.
	aLang: 辨識語系,請參考以下[註1].
	aTranLang: 辨識結果轉換的語系,請參考以下[註2].
	aDir: 名片的方向,請參考以下[註3].
	aResult: 辨識結果,請參考以下[註4].
	回傳值:
		-1000:aJpgbuf等於null或aBufsize小於等於0.
		-1001:二值化的bitmap等於null.
		< 0:辨識失敗.
		0:核心辨識名片的角度.
		90:核心辨識名片的角度.
		180:核心辨識名片的角度.
		270:核心辨識名片的角度.
//*/

/*//
[註1]:辨識語系(Language Version)
	當aLang=B5_LANG:繁體中文
	當aLang=HK_LANG:繁體中文+香港字
	當aLang=GB_LANG:簡體中文
	當aLang=EN_LANG:英文
	當aLang=DE_LANG:德文
	當aLang=FR_LANG:法文
	當aLang=IT_LANG:義大利
	當aLang=ES_LANG:西班牙
	當aLang=NO_LANG:挪威
	當aLang=HU_LANG:匈牙利
	當aLang=PL_LANG:波蘭
	當aLang=SE_LANG:瑞典
	當aLang=NL_LANG:荷蘭
	當aLang=TR_LANG:土耳其
	當aLang=RU_LANG:俄羅斯
	當aLang=JP_LANG:日文
	當aLang=KS_LANG:韓文
	當aLang=DK_LANG:丹麥
	當aLang=FI_LANG:芬蘭
	當aLang=PT_LANG:葡萄牙
	當aLang=GR_LANG:希臘
	當aLang=BR_LANG:巴西
	當aLang=MX_LANG:墨西哥
	當aLang=CZ_LANG:捷克
	當aLang=SK_LANG:斯洛伐克

[註2]:辨識結果轉換的語系(辨識語系為中文語系才有作用).
	當aTranLang=0:視名片語系(如:核心辨認出的語系可能與設定不同)
	當aTranLang=1:將結果轉換為簡體.
	當aTranLang=2:將結果轉換為繁體.

[註3]:名片方向
	當aDir=0時,右轉0度.
	當aDir=1時,右轉90度.
	當aDir=2時,右轉180度.
	當aDir=3時,右轉270度.
	當aDir=255時,核心會自動判斷名片方向.

[註4]:辨識結果格式如下:
	請配置RESULT_MAX_SIZE=2048個unsigned short記憶體.
	例如:index = 0開始,格式如下:
	aResult[index]:欄位數目.
	// 第一個欄位
	aResult[index+1]:欄位影像座標Left.
	aResult[index+2]:欄位影像座標Top.
	aResult[index+3]:欄位影像座標Right.
	aResult[index+4]:欄位影像座標Bottom.
	aResult[index+5]:欄位類型.
	aResult[index+6]:欄位字數(x).
	aResult[index+7~x]:欄位字串.
	// 第二個欄位
	aResult[index+x+1]:欄位影像座標Left.
	aResult[index+x+2]:欄位影像座標Top.
	aResult[index+x+3]:欄位影像座標Right.
	aResult[index+x+4]:欄位影像座標Bottom.
	aResult[index+x+5]:欄位類型.
	aResult[index+x+6]:欄位字數(y).
	aResult[index+x+7~y]:欄位字串.
	以此類推...

	(a)中/日/韓的姓名欄位以0x0A作為區分[姓]和[名](ex:郭文和 -> 郭0x0A文和)
	(b)全語系地址欄位以0x0A分隔為Street + 0x0A + city + 0x0A + state + 0x0A + zip code + 0x0A + country code
//*/

/// 取得sdk版本
extern const char* SDKVersion();