/*
 *  PPWCXFDefine.h
 *  WorldCard Exchange File definition
 *  FormatVersion 104
 *
 *  Created on 2010/11/2.
 *  Modified on 2012/08/12.
 *
 *
 *
 *
 *
 *
 * ====================================
 * !! History
 * ====================================
 *
 * version 104:
 * 1. 定義檔最下方的[default group name definition]中有定義各語系名稱的group，代表可能是語系不同所以有不同名稱，需視為同一個group進行處理。
 *    其他的group只要名稱不同就視為不同的group。
 * 2. Google source產生的交換檔，group名稱若為個語系的"Other Contacts"，在匯入WorldCard source時要匯入到Unfiled group。
 *    (注意事項4-d)
 *
 *
 * version 103:
 * 1. 地址格式說明修正  	
 *		原為  	vWCXF_AF_USA,		// street + "," + city + "," + state + "," + zip + " " + country 
 *		改為  	vWCXF_AF_USA,		// street + ", " + city + ", " + state + " " + zip + " " + country 
 *
 *		原為  	vWCXF_AF_Europe,	// street + "," + zip + "," + city + " " + state + " " + country 
 *		改為  	vWCXF_AF_Europe,	// street + ", " + zip + " " + city + " " + state + " " + country 
 * 
 * 
 * 
 * version 102:
 * 1. 新增地址格式 	vWCXF_AF_Korea
 *				
 * 
 * 
 * version 101:
 * 1. 新增欄位 	kWCXF_CDL1_RecognizedTime
 *				kWCXF_CDL3_Address_GPS
 *				kWCXF_CDL3_IM_GoogleTalk
 *
 *
 *
 *
 *
 * ====================================
 * !! 注意事項
 * ====================================
 * 0. 程式在解譯wcxf時，若遇到未定義tag時，必須跳過此tag內容，而非放棄解譯wcxf。
 * 1. 資料寫入格式
 * 		<key>kWCXF_R_FileCreateTime</key>		--> field type
 *      <date>2011-01-05T06:47:18Z</date>		--> field value
 *		-------------------------------------------------------
 *		a. 每筆資料都必須包含 field type/field value 兩行敘述。
 *		b. field type 使用固定標籤 <key>，內容請參考下方 dictionary keys 定義。
 * 		c. field value 使用變動的資料型態標籤，內容為轉為字串的欄位資料。
 *		d. 可使用的資料型態標籤如下:
 *			<integer>
 *			<string>
 *			<data>		(data資料存取請以base64編碼轉換)
 *			<date>		(date資料的格式為 YYYY-MM-DDTHH:MM:SSZ (2010-11-12T10:00:00Z) 以GMT標準時間儲存，AP讀寫時請轉換)
 * 			<array>
 * 			<dict>
 *		e. 資料若以 <integer>、<string>、<data>、<date> 資料形態儲存，代表沒有其他子欄位。
 *		f. 資料若以 <array>、<dict> 資料形態儲存，代表還有其他子欄位。
 * 
 * 
 * 2. 欄位資料型態說明
 *		a. 以下欄位資料為integer型態
 *			kWCXF_R_FormatVersion
 *    		kWCXF_R_CardCount
 *    		kWCXF_CDL2_RecogLang_Front (核心辨識語系的int定義值)
 *    		kWCXF_CDL2_RecogLang_Back (核心辨識語系的int定義值)
 *    		kWCXF_CDL3_Address_Format
 *
 *  	b. 以下欄位資料為date型態
 *    		kWCXF_R_FileCreateTime
 *    		kWCXF_CDL1_CreateTime
 *    		kWCXF_CDL1_ModifiedTime
 *			kWCXF_CDL1_RecognizedTime
 *    		kWCXF_CDL1_Birthday
 *    		kWCXF_CDL2_Date_Anniversary
 *    		kWCXF_CDL2_Date_Other
 *
 * 		c. 以下欄位資料為data型態
 *    		kWCXF_CDL2_Image_Front
 *    		kWCXF_CDL2_Image_Back
 *    		kWCXF_CDL2_Image_IDPhoto
 * 
 * 
 * 3. root欄位規則說明 (kWCXF_R_XXX)
 *		a. kWCXF_R_Generator請寫入完整名稱及版號 ex. WorldCard Mobile v3.1.2
 * 		b. kWCXF_R_FormatVersion的資料為3碼數字，第1碼代表欄位規則，第2、3碼則是欄位定義的增減。
 *    		 所以FormatVersion的版號若為100/101/111/1xx等，代表可使用相同規則匯入。
 *    		 AP端要注意匯入時要先檢查此版號，濾除不支援的交換檔。
 * 		c. 請在建立完wcxf後，再將file_create_time寫入kWCXF_R_FileCreateTime，同時必須保證file_modify_time與file_create_time間隔1秒以上。
 *    		目的是為了判斷wcxf產生後是否有被覆寫過。實際操作時，當以下條件成立，代表檔案是原始建立的未被覆寫過:
 *    		file_create_time != file_modify_time
 *    		file_create_time == kWCXF_R_FileCreateTime欄位記錄的時間
 *    		(使用iTunes file sharing時，為避免匯入剛匯出的wcxf，必須要進行此檢查動作)
 * 		d. kWCXF_R_FileCreateTime / kWCXF_R_FileID請盡量由底層直接寫入，底層無法處理時才由AP處理。
 * 		e. 寫入時請儘量依照Root Keys的順序寫入，kWCXF_R_CardArray一定要放在最後再寫入。
 * 
 * 
 * 4. card data欄位規則說明 (kWCXF_CDLX_XXX)
 * 		a. kWCXF_CDL1_UniqueID為必要欄位，格式為20個0~F字元，各AP原始uid若長度不足請在前面補滿0。
 *
 * 		b. kWCXF_CDL2_Name_XXX | kWCXF_CDL2_Company_XXX | kWCXF_CDL3_Address_XXX 這3組欄位是組合型欄位。
 *    		當kWCXF_CDL1_Name | kWCXF_CDL1_Company | kWCXF_CDL2_Address_XXX有複數資料時，
 *	  		必須把子欄位先用dict組合好，再把這些dict用array儲存。（不可把子欄位直接用array儲存。）
 *
 * 		c. 除了上述3種欄位外，其他的欄位如果有重複資料，可直接以array儲存。
 *
 * 		d. kWCXF_CDL1_Group資料規則
 *    		.若要紀錄多層類別，請以"/"分隔。(ex: mainGroup/subGroup/.../... -> 第一層類別前不加"/")
 *    		.要紀錄多個類別，請用array儲存。
 *			.若無group資料則將此筆名片歸類到未分類
 * 			.定義檔最下方的[default group name definition]中有定義各語系名稱的group，代表可能是語系不同所以有不同名稱，需視為同一個group進行處理。
 *    		 其他的group只要名稱不同就視為不同的group。
 * 			.Google source產生的交換檔，group名稱若為個語系的"Other Contacts"，在匯入WorldCard source時要匯入到Unfiled group。
 *
 * 		e. kWCXF_CDL1_BloodType | kWCXF_CDL1_Sex | kWCXF_CDL1_Horoscope | kWCXF_CDL1_Education使用指定的value字串時(vWCXF_XXX，請見最下方定義)，
 *    		AP請轉換對應的顯示字串。否則直接使用value字串顯示。
 *
 * 		f. 匯入時請將原本的kWCXF_CDL1_CreateTime/kWCXF_CDL1_ModifiedTime/kWCXF_CDL1_RecognizedTime時間寫入，不要重新產生。
 *     		(若是無法控制的資料庫例如iPhone AddressBook則可略過此規則)
 *
 * 		g. kWCXF_CDL3_Address_GPS資料請轉換為以"度"為表示值的座標顯示格式。(Google Map預設格式)
 *  	   逗號前方為緯度（北正南負），逗號後方為經度（東正西負），小數點到7位。
 * 	    	ex: 24.7933677,121.0034943
 *
 *
 *
 * 
 */

 
 

//--------------------------------
// extention
//--------------------------------
#define WCXF_EXT							@"wcxf"


//--------------------------------
// dictionary keys
//--------------------------------

// kWCXF_R_Generator string format
// app full name + version
// ex:
//		WorldCard Contacts v2.3.0
//		WorldCard Mobile v3.1.0
//		WorldCard for Mac v2.0
//		WorldCard v6.6

// root keys
#define kWCXF_R_Generator					"kWCXF_R_Generator"
// integer format (currently is "102")
#define kWCXF_R_FormatVersion				"kWCXF_R_FormatVersion"
// 16個0~F字元
#define kWCXF_R_FileID						"kWCXF_R_FileID"
// date format
#define kWCXF_R_FileCreateTime				"kWCXF_R_FileCreateTime"
// integer format
#define kWCXF_R_CardCount					"kWCXF_R_CardCount"
#define kWCXF_R_CardArray					"kWCXF_R_CardArray"

// CDL1 (card data level 1) keys
#define kWCXF_CDL1_Group					"kWCXF_CDL1_Group"
#define kWCXF_CDL1_UniqueID					"kWCXF_CDL1_UniqueID"               // 單一 <string> 資料，20個0~F字元
#define kWCXF_CDL1_Image					"kWCXF_CDL1_Image"                  // 單一 <dict> 資料
#define kWCXF_CDL1_RecogLang				"kWCXF_CDL1_RecogLang"              // 單一 <dict> 資料
#define kWCXF_CDL1_Name						"kWCXF_CDL1_Name"
#define kWCXF_CDL1_NickName					"kWCXF_CDL1_NickName"
#define kWCXF_CDL1_Position					"kWCXF_CDL1_Position"
#define kWCXF_CDL1_Department				"kWCXF_CDL1_Department"
#define kWCXF_CDL1_Company					"kWCXF_CDL1_Company"
#define kWCXF_CDL1_Phone					"kWCXF_CDL1_Phone"
#define kWCXF_CDL1_Skype					"kWCXF_CDL1_Skype"
#define kWCXF_CDL1_Address					"kWCXF_CDL1_Address"
#define kWCXF_CDL1_Email					"kWCXF_CDL1_Email"
#define kWCXF_CDL1_URL						"kWCXF_CDL1_URL"
#define kWCXF_CDL1_InstantMessage			"kWCXF_CDL1_InstantMessage"
#define kWCXF_CDL1_Date						"kWCXF_CDL1_Date"
#define kWCXF_CDL1_Other					"kWCXF_CDL1_Other"
#define kWCXF_CDL1_Note						"kWCXF_CDL1_Note"                    // 單一 <string> 
#define kWCXF_CDL1_UnifiedBusinessNumber    "kWCXF_CDL1_UnifiedBusinessNumber"	 // 統一編號
#define kWCXF_CDL1_Birthday					"kWCXF_CDL1_Birthday"				 // 單一 <date> 資料
#define kWCXF_CDL1_Children					"kWCXF_CDL1_Children"
#define kWCXF_CDL1_Spouse					"kWCXF_CDL1_Spouse"
#define kWCXF_CDL1_BloodType				"kWCXF_CDL1_BloodType"				// 單一 <string> 資料，refer to blood type value definition
#define kWCXF_CDL1_Sex						"kWCXF_CDL1_Sex"					// 單一 <string> 資料，refer to sex value definition
#define kWCXF_CDL1_Horoscope				"kWCXF_CDL1_Horoscope"				// 單一 <string> 資料，refer to horoscope value definition
#define kWCXF_CDL1_Education				"kWCXF_CDL1_Education"				// 單一 <string> 資料，refer to education value definition
#define kWCXF_CDL1_CreateTime				"kWCXF_CDL1_CreateTime"			    // 單一 <date> 資料
#define kWCXF_CDL1_ModifiedTime				"kWCXF_CDL1_ModifiedTime"			// 單一 <date> 資料
#define kWCXF_CDL1_RecognizedTime			"kWCXF_CDL1_RecognizedTime"		    // 單一 <date> 資料 (ver101 added)
//-- 105 新增 ------------------------------------------------------------------------------v---
#define kWCXF_CDL1_GroupV2					"kWCXF_CDL1_GroupV2"
#define kWCXF_CDL1_UserDefine				"kWCXF_CDL1_UserDefine"
#define kWCXF_CDL1_Tag						"kWCXF_CDL1_Tag"
#define kWCXF_CDL1_PPAccountID				"kWCXF_CDL1_PPAccountID"
//-- 105 新增 ------------------------------------------------------------------------------^---

// subtype for CDL1_Image
#define kWCXF_CDL2_Image_Front				"kWCXF_CDL2_Image_Front"			// data format
#define kWCXF_CDL2_Image_Back				"kWCXF_CDL2_Image_Back"			    // data format
#define kWCXF_CDL2_Image_IDPhoto			"kWCXF_CDL2_Image_IDPhoto"			// data format

// subtype for CDL1_RecogLang
#define kWCXF_CDL2_RecogLang_Front			"kWCXF_CDL2_RecogLang_Front"		// integer format (核心辨識語系的int定義值)
#define kWCXF_CDL2_RecogLang_Back			"kWCXF_CDL2_RecogLang_Back"		    // integer format (核心辨識語系的int定義值)

// subtype for CDL1_Name
#define kWCXF_CDL2_Name_Full				"kWCXF_CDL2_Name_Full"
#define kWCXF_CDL2_Name_First				"kWCXF_CDL2_Name_First"
#define kWCXF_CDL2_Name_Middle				"kWCXF_CDL2_Name_Middle"
#define kWCXF_CDL2_Name_Last				"kWCXF_CDL2_Name_Last"
#define kWCXF_CDL2_Name_PhoneticFull		"kWCXF_CDL2_Name_PhoneticFull"
#define kWCXF_CDL2_Name_PhoneticFirst		"kWCXF_CDL2_Name_PhoneticFirst"
#define kWCXF_CDL2_Name_PhoneticMiddle		"kWCXF_CDL2_Name_PhoneticMiddle"
#define kWCXF_CDL2_Name_PhoneticLast		"kWCXF_CDL2_Name_PhoneticLast"
#define kWCXF_CDL2_Name_Prefix				"kWCXF_CDL2_Name_Prefix"
#define kWCXF_CDL2_Name_Suffix				"kWCXF_CDL2_Name_Suffix"

// subtype for CDL1_Company
#define kWCXF_CDL2_Company_Name				"kWCXF_CDL2_Company_Name"
#define kWCXF_CDL2_Company_Phonetic			"kWCXF_CDL2_Company_Phonetic"

// subtype for CDL1_Phone
#define kWCXF_CDL2_Phone_Work				"kWCXF_CDL2_Phone_Work"
#define kWCXF_CDL2_Phone_Home				"kWCXF_CDL2_Phone_Home"
#define kWCXF_CDL2_Phone_Other				"kWCXF_CDL2_Phone_Other"
#define kWCXF_CDL2_Phone_Mobile				"kWCXF_CDL2_Phone_Mobile"
#define kWCXF_CDL2_Phone_Main				"kWCXF_CDL2_Phone_Main"
#define kWCXF_CDL2_Phone_Primary			"kWCXF_CDL2_Phone_Primary"
#define kWCXF_CDL2_Phone_GoogleVoice		"kWCXF_CDL2_Phone_GoogleVoice"
#define kWCXF_CDL2_Phone_iPhone				"kWCXF_CDL2_Phone_iPhone"
#define kWCXF_CDL2_Phone_Pager				"kWCXF_CDL2_Phone_Pager"
#define kWCXF_CDL2_Phone_WorkFax			"kWCXF_CDL2_Phone_WorkFax"
#define kWCXF_CDL2_Phone_HomeFax			"kWCXF_CDL2_Phone_HomeFax"
#define kWCXF_CDL2_Phone_OtherFax			"kWCXF_CDL2_Phone_OtherFax"

// subtype for CDL1_Address
#define kWCXF_CDL2_Address_Work				"kWCXF_CDL2_Address_Work"
#define kWCXF_CDL2_Address_Home				"kWCXF_CDL2_Address_Home"
#define kWCXF_CDL2_Address_Other			"kWCXF_CDL2_Address_Other"

// subtype for CD2_Address
#define kWCXF_CDL3_Address_Street			"kWCXF_CDL3_Address_Street"
#define kWCXF_CDL3_Address_City				"kWCXF_CDL3_Address_City"
#define kWCXF_CDL3_Address_State			"kWCXF_CDL3_Address_State"
#define kWCXF_CDL3_Address_ZIP				"kWCXF_CDL3_Address_ZIP"
#define kWCXF_CDL3_Address_Country			"kWCXF_CDL3_Address_Country"
#define kWCXF_CDL3_Address_CountryCode		"kWCXF_CDL3_Address_CountryCode"		// string format (refer to Mac AddressBook country code definition)
#define kWCXF_CDL3_Address_Format			"kWCXF_CDL3_Address_Format"			    // integer format (refer to address format definition)
#define kWCXF_CDL3_Address_GPS				"kWCXF_CDL3_Address_GPS"				// string format

// subtype for CDL1_Email
#define kWCXF_CDL2_Email_Work				"kWCXF_CDL2_Email_Work"
#define kWCXF_CDL2_Email_Home				"kWCXF_CDL2_Email_Home"
#define kWCXF_CDL2_Email_Other				"kWCXF_CDL2_Email_Other"

// subtype for CDL1_URL
#define kWCXF_CDL2_URL_HomePage				"kWCXF_CDL2_URL_HomePage"
#define kWCXF_CDL2_URL_Work					"kWCXF_CDL2_URL_Work"
#define kWCXF_CDL2_URL_Home					"kWCXF_CDL2_URL_Home"
#define kWCXF_CDL2_URL_Facebook				"kWCXF_CDL2_URL_Facebook"
#define kWCXF_CDL2_URL_Twitter				"kWCXF_CDL2_URL_Twitter"
#define kWCXF_CDL2_URL_Plurk				"kWCXF_CDL2_URL_Plurk"
#define kWCXF_CDL2_URL_LinkedIn				"kWCXF_CDL2_URL_LinkedIn"
#define kWCXF_CDL2_URL_Profile				"kWCXF_CDL2_URL_Profile"
#define kWCXF_CDL2_URL_Blog					"kWCXF_CDL2_URL_Blog"
#define kWCXF_CDL2_URL_Other				"kWCXF_CDL2_URL_Other"

// subtype for CDL1_InstantMessage
#define kWCXF_CDL2_IM_Work					"kWCXF_CDL2_IM_Work"
#define kWCXF_CDL2_IM_Home					"kWCXF_CDL2_IM_Home"
#define kWCXF_CDL2_IM_Other					"kWCXF_CDL2_IM_Other"

// subtype for CD2_InstantMessage
#define kWCXF_CDL3_IM_AIM					"kWCXF_CDL3_IM_AIM"
#define kWCXF_CDL3_IM_YahooMessenger		"kWCXF_CDL3_IM_YahooMessenger"
#define kWCXF_CDL3_IM_MSN					"kWCXF_CDL3_IM_MSN"
#define kWCXF_CDL3_IM_ICQ					"kWCXF_CDL3_IM_ICQ"
#define kWCXF_CDL3_IM_Jabber				"kWCXF_CDL3_IM_Jabber"
#define kWCXF_CDL3_IM_QQ					"kWCXF_CDL3_IM_QQ"
#define kWCXF_CDL3_IM_GoogleTalk			"kWCXF_CDL3_IM_GoogleTalk"

// subtype for CDL1_Date
#define kWCXF_CDL2_Date_Anniversary			"kWCXF_CDL2_Date_Anniversary"		// date format
#define kWCXF_CDL2_Date_Other				"kWCXF_CDL2_Date_Other"			    // date format

//-- 105 新增 ------------------------------------------------------------------------------v---
// subtype for kWCXF_CDL1_GroupV2
#define kWCXF_CDL2_GroupV2_Default			"kWCXF_CDL2_GroupV2_Default"	//預設Group
#define kWCXF_CDL2_GroupV2_Defined			"kWCXF_CDL2_GroupV2_Defined"	//使用者自訂Group

// subtype for kWCXF_CDL1_UserDefine
#define kWCXF_CDL2_UserDefine_Label			"kWCXF_CDL2_UserDefine_Label"	//使用者自訂 label
#define kWCXF_CDL2_UserDefine_Content		"kWCXF_CDL2_UserDefine_Content"	//使用者自訂 內容

// subtype for kWCXF_CDL1_Tag
#define kWCXF_CDL2_Tag_Name					"kWCXF_CDL2_Tag_Name"				//Tag Name
#define kWCXF_CDL2_Tag_Data					"kWCXF_CDL2_Tag_Data"				//Tag Data

//-- 105 新增 ------------------------------------------------------------------------------^---

//----------------------------------------------------------------
// special value definition
//----------------------------------------------------------------

// address format value definition (value for kWCXF_CDL3_Address_Format)
typedef enum
{
	vWCXF_AF_None = 0,
	vWCXF_AF_Taiwan,	// country + state + city + street + " ," + zip
	vWCXF_AF_USA,		// street + ", " + city + ", " + state + " " + zip + " " + country 	(ver103 updated)
	vWCXF_AF_Europe,	// street + ", " + zip + " " + city + " " + state + " " + country 	(ver103 updated)
	vWCXF_AF_Japan,		// "¢E" + zip + " " + country + state + city + street
	vWCXF_AF_Korea		// ZIP + " " + country + state + city + street						(ver102 added)
}
vWCXF_AddressFormat;


// blood type value definition (value for kWCXF_CDL1_BloodType)
#define vWCXF_BLOOD_A				L"vWCXF_BLOOD_A"
#define vWCXF_BLOOD_B				L"vWCXF_BLOOD_B"
#define vWCXF_BLOOD_AB				L"vWCXF_BLOOD_AB"
#define vWCXF_BLOOD_O				L"vWCXF_BLOOD_O"


// sex value definition (value for kWCXF_CDL1_Sex)
#define vWCXF_SEX_Male				L"vWCXF_SEX_Male"
#define vWCXF_SEX_Female			L"vWCXF_SEX_Female"


// education value definition (value for kWCXF_CDL1_Education)
#define vWCXF_EDU_PrimarySchool     @"vWCXF_EDU_PrimarySchool"  //小學
#define vWCXF_EDU_JuniorSchool      @"vWCXF_EDU_JuniorSchool"   //中學
#define vWCXF_EDU_SeniorSchool      @"vWCXF_EDU_SeniorSchool"   //高中(職)
#define vWCXF_EDU_College           @"vWCXF_EDU_College"        //專科、學院、短大
#define vWCXF_EDU_University        @"vWCXF_EDU_University"     //大學
#define vWCXF_EDU_Master            @"vWCXF_EDU_Master"         //碩士
#define vWCXF_EDU_Doctor            @"vWCXF_EDU_Doctor"         //博士


// Horoscope value definition (value for kWCXF_CDL1_Horoscope)
#define vWCXF_HORO_AQUARIUS         @"vWCXF_HORO_AQUARIUS"      //水瓶座
#define vWCXF_HORO_PIECES           @"vWCXF_HORO_PIECES"        //雙魚座
#define vWCXF_HORO_ARIES            @"vWCXF_HORO_ARIES"         //白羊座
#define vWCXF_HORO_TAURUS           @"vWCXF_HORO_TAURUS"        //金牛座
#define vWCXF_HORO_GEMINI           @"vWCXF_HORO_GEMINI"        //雙子座
#define vWCXF_HORO_CANCER           @"vWCXF_HORO_CANCER"        //巨蟹座
#define vWCXF_HORO_LEO              @"vWCXF_HORO_LEO"           //獅子座
#define vWCXF_HORO_VIRGO            @"vWCXF_HORO_VIRGO"         //處女座
#define vWCXF_HORO_LIBRA            @"vWCXF_HORO_LIBRA"         //天秤座
#define vWCXF_HORO_SCORPIO          @"vWCXF_HORO_SCORPIO"       //天蠍座
#define vWCXF_HORO_SAGITTARIUS      @"vWCXF_HORO_SAGITTARIUS"   //射手座
#define vWCXF_HORO_CAPRICORN        @"vWCXF_HORO_CAPRICORN"     //摩羯座


//----------------------------------------------------------------
// default group name definition
//----------------------------------------------------------------
// 各語系的預設group名稱請以逗號分隔。
#define Group_Unverified			@"Unverified,未校正聯絡人,未校正联系人,未確認,미확인,No verificado,Non vérifié,Non verificato,Niet geverifieerd,Não verificado,Unbestätigt"
#define Group_Unfiled				@"Unfiled,未分類,未分类,未分類,미분류,Niet ingevuld,Vuoti,Non classé,Nicht gespeichert,Por preencher,Sin archivar"
#define Group_OtherContacts			@"Other Contacts,其他聯絡人,其他联系人,その他の連絡先,기타 주소록,Andere contactpersonen,Altri contatti,Autres contacts,Weitere Kontakte,Otros contactos,Другие контакты,Další kontakty,Inne kontakty,Iné kontakty"


#define Group_MyContacts @"My Contacts,我的聯絡人,通讯录,Myコンタクト,내 주소록,Mis contactos,Mes contacts,Contatti personali,Mijn contactpersonen,Contactos pessoais,Meine Kontakte,Мои контакты,Moje kontakty,Moje kontakty,Moje kontakty"
#define Group_Friends @"Friends,好友,朋友,友達,친구,Amigos,Amis,Amici,Vrienden,Amigos,Freunde,Друзья,Přátelé,Znajomi,Priatelia"
#define Group_Family @"Family,家人,家人,家族,가족,Familia,Famille,Famiglia,Familie,Família,Familie,Семья,Rodina,Rodzina,Rodina"
#define Group_Coworkers @"Coworkers,同事,同事,同僚,동료,Compañeros,Collègues,Colleghi,Collega's,Colegas de trabalho,Kollegen,Коллеги,Kolegové,Współpracownicy,Kolegovia"
